/*-------------------------------------------------------------------------
 *
 * lilbpgc.h
 *	  external definition of the function for pgreplicate and pglb
 *
 * This should be the first file included by replicate modules.
 *
 *-------------------------------------------------------------------------
 */
#ifndef LIBPGC_H
#define	LIBPGC_H

#include <stdio.h>

/* external definition of the function in sem.c */
extern void PGRsem_unlock( int semid, short sem_num );
extern void PGRsem_lock( int semid, short sem_num );

/* external definition of the function in show.c */
extern void show_debug(const char * fmt,...);
extern void show_error(const char * fmt,...);
extern void PGRwrite_log_file(FILE * fp, const char * fmt,...);

/* external definition of the function in signal.c */
typedef void (*PGRsighandler)(int);
extern PGRsighandler PGRsignal(int signo, PGRsighandler sighandler);

#endif /* LIBPGC_H */
