//////////////////////////////////////////////////////////////////////////
//
// pgScript - PostgreSQL Tools
// RCS-ID:      $Id: pgsStmt.h,v 1.1 2008/06/27 18:19:16 pgunittest Exp $
// Copyright (C) 2008 The pgScript Development Team
// This software is released under the Artistic Licence
//
//////////////////////////////////////////////////////////////////////////


#ifndef PGSSTMT_H_
#define PGSSTMT_H_

#include "pgscript/pgScript.h"
#include "pgscript/objects/pgsVariable.h"

class pgsThread;

class pgsStmt
{
	
private:
	
	unsigned int m_line, m_column;
	
protected:
	
	pgsThread * m_app;

public:

	pgsStmt(pgsThread * app = 0);

	virtual ~pgsStmt();
	
	void set_position(int line, int column);

	int line() const;

	int column() const;

	virtual void eval(pgsVarMap & vars) const = 0;

private:

	pgsStmt(const pgsStmt & that);

	pgsStmt & operator=(const pgsStmt & that);

};

#endif /*PGSSTMT_H_*/
