#!/bin/sh

# declare
table_name="${1}"
create_pktype=
create_log=
create_trigger=
create_table=
index_oid_list=()
create_index=

# get sql for create temp objects
create_pktype="`psql -A -t -c "SELECT create_pktype FROM reorg.tables WHERE relid = '${1}'::regclass"`" && \
create_log="`psql -A -t -c "SELECT create_log FROM reorg.tables WHERE relid = '${1}'::regclass"`" && \
create_trigger="`psql -A -t -c "SELECT create_trigger FROM reorg.tables WHERE relid = '${1}'::regclass"`" && \
create_table="`psql -A -t -c "SELECT create_table FROM reorg.tables WHERE relid = '${1}'::regclass"`"
[ ${?} != 0 ] && exit 1

# create temp objects
psql -a -c "${create_pktype}" && \
psql -a -c "${create_log}" && \
psql -a -c "${create_trigger}" && \
psql -a -c "${create_table}"
[ ${?} != 0 ] && exit 1

index_oid_list=("`psql -A -t -c "SELECT indexrelid FROM pg_index WHERE indrelid = '${1}'::regclass"`") || exit 1

for index_oid in ${index_oid_list[@]}
do
	create_index="`psql -A -t -c "SELECT reorg.reorg_indexdef((SELECT oid FROM pg_class WHERE oid = ${index_oid}), '${1}'::regclass)"`" || exit 1
	psql -c "${create_index}" || exit 1
done

exit 0
