<?php 
/*
  Author: Greg Feigenson
  File: header.inc.php
  Copyright: 2004-2005 Greg Feigenson
  
  This software is licensed under the BSD license.
  Please see attached license or www.opensource.org
  for details
*/

//Includes
require('session.inc.php');
require('config.inc.php');
require('functions.inc.php');
require('styles.inc.php');

//Take care of login
if (!isLoggedIn())
{	
	$challange = false;
	
	if (isset($_POST['pass']))
		$challange = checkLogin($_POST['user'],$_POST['pass']);
	
	if (!$challange)
	{
		printLoginForm();
		exit();
	}
}

//Take care of logging out
if (isset($_GET['exit']))
{
  session_destroy();
  echo "<SCRIPT LANGUAGE='Javascript'> window.location = './'</script>";	
}

//If logged in, print the header et al
echo "<HTML><HEAD><TITLE>Tracker DB</TITLE></HEAD>";

echo "<BODY>".
     "<div class='HeaderSpan' align='center'>".
     "<img src='../images/logo.gif'>";
     
require('links.inc.php');

echo "<br><br></div>";


//Security for page
if (!checkSecurity())
{
	printError("Sorry, you do not have the credentials to view this page");
	require('footer.inc.php');
	exit;
}



/*
 * Functions
 */

function printLoginForm()
{
	global $url_base;
	
	echo 	"<br><br>";
	echo	"<div align='center'>".
		"<img src='images/tracker_login.gif'>".
		"<FORM action='index.php' method='post'>".
		"<P>".
		"<LABEL for='username'>Username: </LABEL>".
				"<INPUT type='text' name='user'> <BR>".
		"<LABEL for='password'>Password: </LABEL>".
				"<INPUT type='password' name='pass'><BR>".
			"<INPUT type='submit' value='Log In'>". 
		"</P>".
		"</FORM></DIV>";
}

function checkLogin($user,$pass)
{
	//Hash pass and make sure no injection attacks
	$pass = md5(pg_escape_string($pass));
	$user = pg_escape_string($user);
	
	//Query DB
	require('db.inc.php');
	
	$sql = 	"SELECT username, acct_type ".
		"FROM users ".
		"WHERE username='".$user."' AND pass='".$pass."'";
	
	$query = pg_exec($sql);
	$result = pg_fetch_assoc($query);
	pg_close($connection); 
	
	//Check the number of users with username/pass
	//username is the pkey, so it should be unique.
	if (pg_num_rows($query) == 1)
	{
		logIn($result);
		return true;
	}
	else
		return false;
}

function logIn(&$user)
{
	//will eventually have more stuff
	$_SESSION['username'] = $user['username'];
	$_SESSION['acct_type'] = $user['acct_type'];
}

function checkSecurity()
{
	/*
	 * This checks with the database and sees if the user has credentials
	 * to view this page. Will fail true if the page is not in the DB! so
	 * be careful.
	 *
	 * The link architecture should accomodate you though in that it has a
	 * "visible" parameter, for being printed in the header/footer links.
	 * You should add your link and set it invisible if you don't want it
	 * on your header/footer to follow through with this security mechanism
	 */
	$file = explode("/",$_SERVER['PHP_SELF']); //grab current filename
	$i = count($file) - 1; //should be at the last index
	$filename = $file[$i]; //this is the current file
	
	require('db.inc.php');
	$sql = "SELECT security FROM links WHERE href = '$filename'";	
	$query = pg_exec($sql);
	$result = pg_fetch_assoc($query);
	pg_close($connection);
	
	if (pg_num_rows($query) < 1)
		return true; 
	
	if ($_SESSION['acct_type'] < $result['security'])
		return false;
	else
		return true;
}
?>