# apt.postgresql.org hackathon

The hackathon happened in Credativ place and Christoph Berg and included
Magnus Hagander and Dimitri Fontaine. It took place 2012-08-21 and 22.

That document is both a report of what we managed to do in the hackathon,
including some decisions we took, and a TODO list for later.

## Hackathon goal

We want to build all PostgreSQL stable releases for all supported debian and
ubuntu distributions for i386 and amd64. We already have a Jenkins setup
allowing us to manage a build queue, thanks to Christoph.

## Building pl/sh for squeeze

We need to:

 1. get our own postgresql-common package with the right supported-versions script
 2. change the cowbuilder image source list to inclure our packages
 3. build plsh in the build environment
 4. get plsh packages for squeeze for all those PG versions
 5. publish them in a debian repository in localhost
 
### postgresql-common
 
Editing supported-versions is enough, `postgresql-server-dev-all`
dependencies are taken from that at build time.

### apt preferences

We want that the `~pgdg` packages take priority over the debian provided
packages for the same versions, so we need to do some APT pinning magic here
to make that happen, and include that setup in the repository and in the
installation instructions.

Default policy from the repository is a backports like policy.

We also provide a package that install a
`/etc/apt/preferences.d/apt.postgresql.org` file with the right pinning for
a full pgdg experience:

    Package: *
    Pin: release o=apt.postgresql.org
    Pin-Priority: 600

### libpq

We ship latest stable PostgreSQL version of libpq in all stable
distributions (that's libpq from 9.1 for squeeze and wheezy), and we ship
the latest-including-beta in sid (libpq from 9.2 nowadays).

We need to build extensions with that libpq version too, of course.

### distributions and release policy

We publish maintained PostgreSQL versions to current debian and ubuntu
releases. We also publish old PostgreSQL versions to current and old debian
and ubuntu versions.

Distributions examples with wheezy:

 - wheezy-pgdg               (only PG supported versions, 8.3 -> 9.1)
 - wheezy-pgdg-testing       (including 9.2)
 - wheezy-pgdg-deprecated    (including 8.1)

Same thing with lenny, squeeze, jessy(?), sid, and ubuntu releases lucid,
precise and some others.

# Problems to solve later

## Automatic build

Several sources are available for the packaging. We can either build from
the current `apt-get source` packaging found in sid or from the source code
repository on `alioth` (svn and git are in use over there).

One idea is to build *testing* packages from their source code repositories
and *production* package directely from the `sid` distribution. That means
we're doing both Quality Assurance and Backports, but that might be a little
too much for the first version of this build system.

## Build Images Optimisation

It should be possible to provide for build images (pbuilder, cowbuilder)
including PostgreSQL build dependancies and our own packages pre-installed.
That means we need to rebuild those image at each PostgreSQL Minor release.

We might need a Jenkins job to do that.

## apt.postgresql.org website

We need some templates and build the website with them, or just use django
here. The main installation instruction should go to the main PostgreSQL
website. We agree that Magnus will do the django parts.

## Where to get the sources from

The current Jenkins install is fetching package sources from `bzr`, `git`
and `svn` repositories, we could do it the *backports* way and fetch debian
sid sources instead with `apt-get source`.

## pg_buildext

`debian/pgversions` should include a `*` facility so that we can build
extensions against new PostgreSQL releases without any editing. Worst case
it doesn't work and we report a bug.

## publishing policy

Generally we want to only include packages that come from Debian unstable,
usually in the version from there. Exceptions should be rare so we don't run
out of sync and lose track.

We need to publish a policy about Software Licences and content (postgresql,
extensions, some special cases for clients, but not any client software). We
only publish backend software with an OSI approved licence.

# Build Environment

## Sources

- PostgreSQL common packaging is on bzr
  http://anonscm.debian.org/bzr/pkg-postgresql/

- Debian Packaging for Extensions is on alioth SVN
  https://alioth.debian.org/scm/browser.php?group_id=30209

- Our own build infrastructure is on github
  https://github.com/dimitri/apt.postgresql.org

## Jenkins

- we want the configuration in git if possible: SCM Sync configuration plugin
