/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.access.DeclareGlobalLexicalVariableNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=DeclareGlobalLexicalVariableNode.class)
public final class DeclareGlobalLexicalVariableNodeGen
extends DeclareGlobalLexicalVariableNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private PropertySetNode cached_cache_;

    private DeclareGlobalLexicalVariableNodeGen(String varName, boolean isConst) {
        super(varName, isConst);
    }

    @Override
    protected void executeVoid(DynamicObject arg0Value, JSContext arg1Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0 && arg1Value.getPropertyCacheLimit() > 0) {
                this.doCached(arg0Value, arg1Value, this.cached_cache_);
                return;
            }
            if ((state & 2) != 0) {
                this.doUncached(arg0Value, arg1Value);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(arg0Value, arg1Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndSpecialize(DynamicObject arg0Value, JSContext arg1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (exclude == 0 && arg1Value.getPropertyCacheLimit() > 0) {
                this.cached_cache_ = (PropertySetNode)super.insert((Node)this.makeDefineOwnPropertyCache(arg1Value));
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                this.doCached(arg0Value, arg1Value, this.cached_cache_);
                return;
            }
            this.exclude_ = exclude |= 1;
            state &= 0xFFFFFFFE;
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            this.doUncached(arg0Value, arg1Value);
            return;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[3];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doCached";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            ArrayList<List<PropertySetNode>> cached = new ArrayList<List<PropertySetNode>>();
            cached.add(Arrays.asList(this.cached_cache_));
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doUncached";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static DeclareGlobalLexicalVariableNode create(String varName, boolean isConst) {
        return new DeclareGlobalLexicalVariableNodeGen(varName, isConst);
    }
}

