/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.antrun;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-antrun-plugin:1.7", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven AntRun Plugin", 0);
        this.append(sb, "Runs Ant scripts embedded in the POM", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 2 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "antrun:help", 0);
            this.append(sb, "Display help information on maven-antrun-plugin.\nCall\n\u00a0\u00a0mvn\u00a0antrun:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "run".equals(this.goal)) {
            this.append(sb, "antrun:run", 0);
            this.append(sb, "Maven AntRun Mojo.\nThis plugin provides the capability of calling Ant tasks from a POM by running the nested ant tasks inside the <tasks/> parameter. It is encouraged to move the actual tasks to a separate build.xml file and call that file with an <ant/> task.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "customTaskPrefix", 2);
                this.append(sb, "The xml tag prefix to use for the built in Ant tasks. This prefix needs to be prepended to each task referenced in the antrun target config. For example, a prefix of 'mvn' means that the attachartifact task is referenced by '<mvn:attachartifact>' The default value of an empty string means that no prefix is used for the tasks.", 3);
                this.append(sb, "", 0);
                this.append(sb, "exportAntProperties (Default: false)", 2);
                this.append(sb, "Specifies whether the Ant properties should be propagated to the Maven properties.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Specifies whether a failure in the ant build leads to a failure of the Maven build. If this value is 'true', the Maven build will proceed even if the ant build fails. If it is 'false', then the Maven build fails if the ant build fails.", 3);
                this.append(sb, "", 0);
                this.append(sb, "propertyPrefix", 2);
                this.append(sb, "String to prepend to project and dependency property names.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Specifies whether the Antrun execution should be skipped.", 3);
                this.append(sb, "Expression: ${maven.antrun.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceRoot", 2);
                this.append(sb, "Deprecated. Use the build-helper-maven-plugin to bind source directories", 3);
                this.append(sb, "", 0);
                this.append(sb, "This folder is added to the list of those folders containing source to be compiled. Use this if your ant script generates source code.", 3);
                this.append(sb, "Expression: ${sourceRoot}", 3);
                this.append(sb, "", 0);
                this.append(sb, "target", 2);
                this.append(sb, "The XML for the Ant target. You can add anything you can add between <target> and </target> in a build.xml.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tasks", 2);
                this.append(sb, "Deprecated. Use target instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "The XML for the Ant task. You can add anything you can add between <target> and </target> in a build.xml.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testSourceRoot", 2);
                this.append(sb, "Deprecated. Use the build-helper-maven-plugin to bind test source directories", 3);
                this.append(sb, "", 0);
                this.append(sb, "This folder is added to the list of those folders containing source to be compiled for testing. Use this if your ant script generates test source code.", 3);
                this.append(sb, "Expression: ${testSourceRoot}", 3);
                this.append(sb, "", 0);
                this.append(sb, "versionsPropertyName (Default: maven.project.dependencies.versions)", 2);
                this.append(sb, "The name of a property containing the list of all dependency versions. This is used for the removing the versions from the filenames.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList<String> lines = new ArrayList<String>();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List<String> lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

