/*
 * Decompiled with CFR 0.152.
 */
package org.nibor.autolink.internal;

import org.nibor.autolink.LinkSpan;
import org.nibor.autolink.LinkType;
import org.nibor.autolink.internal.LinkSpanImpl;
import org.nibor.autolink.internal.Scanner;
import org.nibor.autolink.internal.Scanners;

public class UrlScanner
implements Scanner {
    @Override
    public LinkSpan scan(CharSequence input, int triggerIndex, int rewindIndex) {
        int afterSlashSlash = triggerIndex + 3;
        int length = input.length();
        if (afterSlashSlash >= length || input.charAt(triggerIndex + 1) != '/' || input.charAt(triggerIndex + 2) != '/') {
            return null;
        }
        int first = this.findFirst(input, triggerIndex - 1, rewindIndex);
        if (first == -1) {
            return null;
        }
        int last = Scanners.findUrlEnd(input, afterSlashSlash);
        return new LinkSpanImpl(LinkType.URL, first, last + 1);
    }

    private int findFirst(CharSequence input, int beginIndex, int rewindIndex) {
        int first = -1;
        int digit = -1;
        for (int i = beginIndex; i >= rewindIndex; --i) {
            char c = input.charAt(i);
            if (Scanners.isAlpha(c)) {
                first = i;
                continue;
            }
            if (Scanners.isDigit(c)) {
                digit = i;
                continue;
            }
            if (!UrlScanner.schemeSpecial(c)) break;
        }
        if (first > 0 && first - 1 == digit) {
            first = -1;
        }
        return first;
    }

    private static boolean schemeSpecial(char c) {
        switch (c) {
            case '+': 
            case '-': 
            case '.': {
                return true;
            }
        }
        return false;
    }
}

