/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.siterenderer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.maven.doxia.Doxia;
import org.apache.maven.doxia.logging.Log;
import org.apache.maven.doxia.logging.PlexusLoggerWrapper;
import org.apache.maven.doxia.module.site.SiteModule;
import org.apache.maven.doxia.module.site.manager.SiteModuleManager;
import org.apache.maven.doxia.module.site.manager.SiteModuleNotFoundException;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.parser.manager.ParserNotFoundException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.render.RenderingContext;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.DoxiaDocumentRenderer;
import org.apache.maven.doxia.siterenderer.ModuleReference;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.doxia.util.XmlValidator;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.ToolManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.velocity.SiteResourceLoader;
import org.codehaus.plexus.velocity.VelocityComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=Renderer.class)
public class DefaultSiteRenderer
extends AbstractLogEnabled
implements Renderer {
    @Requirement
    private VelocityComponent velocity;
    @Requirement
    private SiteModuleManager siteModuleManager;
    @Requirement
    private Doxia doxia;
    @Requirement
    private I18N i18n;
    private static final String RESOURCE_DIR = "org/apache/maven/doxia/siterenderer/resources";
    private static final String DEFAULT_TEMPLATE = "org/apache/maven/doxia/siterenderer/resources/default-site.vm";
    private static final String SKIN_TEMPLATE_LOCATION = "META-INF/maven/site.vm";

    @Override
    public void render(Collection<DocumentRenderer> documents, SiteRenderingContext siteRenderingContext, File outputDirectory) throws RendererException, IOException {
        this.renderModule(documents, siteRenderingContext, outputDirectory);
        for (File siteDirectory : siteRenderingContext.getSiteDirectories()) {
            this.copyResources(siteRenderingContext, new File(siteDirectory, "resources"), outputDirectory);
        }
    }

    @Override
    public Map<String, DocumentRenderer> locateDocumentFiles(SiteRenderingContext siteRenderingContext) throws IOException, RendererException {
        LinkedHashMap<String, DocumentRenderer> files = new LinkedHashMap<String, DocumentRenderer>();
        Map<String, String> moduleExcludes = siteRenderingContext.getModuleExcludes();
        for (File siteDirectory : siteRenderingContext.getSiteDirectories()) {
            if (!siteDirectory.exists()) continue;
            Collection modules = this.siteModuleManager.getSiteModules();
            for (SiteModule module : modules) {
                File moduleBasedir = new File(siteDirectory, module.getSourceDirectory());
                if (moduleExcludes != null && moduleExcludes.containsKey(module.getParserId())) {
                    this.addModuleFiles(moduleBasedir, module, moduleExcludes.get(module.getParserId()), files);
                    continue;
                }
                this.addModuleFiles(moduleBasedir, module, null, files);
            }
        }
        for (ModuleReference module : siteRenderingContext.getModules()) {
            try {
                if (moduleExcludes != null && moduleExcludes.containsKey(module.getParserId())) {
                    this.addModuleFiles(module.getBasedir(), this.siteModuleManager.getSiteModule(module.getParserId()), moduleExcludes.get(module.getParserId()), files);
                    continue;
                }
                this.addModuleFiles(module.getBasedir(), this.siteModuleManager.getSiteModule(module.getParserId()), null, files);
            }
            catch (SiteModuleNotFoundException e) {
                throw new RendererException("Unable to find module: " + e.getMessage(), e);
            }
        }
        return files;
    }

    private void addModuleFiles(File moduleBasedir, SiteModule module, String excludes, Map<String, DocumentRenderer> files) throws IOException, RendererException {
        if (moduleBasedir.exists()) {
            List allFiles = FileUtils.getFileNames((File)moduleBasedir, (String)"**/*.*", (String)excludes, (boolean)false);
            String lowerCaseExtension = module.getExtension().toLowerCase(Locale.ENGLISH);
            LinkedList docs = new LinkedList(allFiles);
            Iterator it = docs.iterator();
            while (it.hasNext()) {
                String name = ((String)it.next()).trim();
                if (name.toLowerCase(Locale.ENGLISH).endsWith("." + lowerCaseExtension)) continue;
                it.remove();
            }
            LinkedList velocityFiles = new LinkedList(allFiles);
            Iterator it2 = velocityFiles.iterator();
            while (it2.hasNext()) {
                String name = ((String)it2.next()).trim();
                if (name.toLowerCase(Locale.ENGLISH).endsWith(lowerCaseExtension + ".vm")) continue;
                it2.remove();
            }
            docs.addAll(velocityFiles);
            for (String doc : docs) {
                String docc = doc.trim();
                RenderingContext context = new RenderingContext(moduleBasedir, docc, module.getParserId(), module.getExtension());
                if (docc.toLowerCase(Locale.ENGLISH).endsWith(".vm")) {
                    context.setAttribute("velocity", "true");
                }
                String key = context.getOutputName();
                if (files.containsKey(key = StringUtils.replace((String)key, (String)"\\", (String)"/"))) {
                    DocumentRenderer renderer = files.get(key);
                    RenderingContext originalContext = renderer.getRenderingContext();
                    File originalDoc = new File(originalContext.getBasedir(), originalContext.getInputName());
                    throw new RendererException("Files '" + module.getSourceDirectory() + File.separator + docc + "' clashes with existing '" + originalDoc + "'.");
                }
                for (Map.Entry<String, DocumentRenderer> entry : files.entrySet()) {
                    if (!entry.getKey().equalsIgnoreCase(key)) continue;
                    RenderingContext originalContext = entry.getValue().getRenderingContext();
                    File originalDoc = new File(originalContext.getBasedir(), originalContext.getInputName());
                    if (Os.isFamily((String)"windows")) {
                        throw new RendererException("Files '" + module.getSourceDirectory() + File.separator + docc + "' clashes with existing '" + originalDoc + "'.");
                    }
                    if (!this.getLogger().isWarnEnabled()) continue;
                    this.getLogger().warn("Files '" + module.getSourceDirectory() + File.separator + docc + "' could clashes with existing '" + originalDoc + "'.");
                }
                files.put(key, new DoxiaDocumentRenderer(context));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderModule(Collection<DocumentRenderer> docs, SiteRenderingContext siteRenderingContext, File outputDirectory) throws IOException, RendererException {
        for (DocumentRenderer docRenderer : docs) {
            boolean modified;
            RenderingContext renderingContext = docRenderer.getRenderingContext();
            File outputFile = new File(outputDirectory, docRenderer.getOutputName());
            File inputFile = new File(renderingContext.getBasedir(), renderingContext.getInputName());
            boolean bl = modified = !outputFile.exists() || inputFile.lastModified() > outputFile.lastModified() || siteRenderingContext.getDecoration().getLastModified() > outputFile.lastModified();
            if (modified || docRenderer.isOverwrite()) {
                if (!outputFile.getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Generating " + outputFile);
                }
                Writer writer = null;
                try {
                    writer = WriterFactory.newWriter((File)outputFile, (String)siteRenderingContext.getOutputEncoding());
                    docRenderer.renderDocument(writer, this, siteRenderingContext);
                }
                catch (Throwable throwable) {
                    IOUtil.close(writer);
                    throw throwable;
                }
                IOUtil.close((Writer)writer);
                continue;
            }
            if (!this.getLogger().isDebugEnabled()) continue;
            this.getLogger().debug(inputFile + " unchanged, not regenerating...");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void renderDocument(Writer writer, RenderingContext renderingContext, SiteRenderingContext siteContext) throws RendererException, FileNotFoundException, UnsupportedEncodingException {
        SiteRendererSink sink = new SiteRendererSink(renderingContext);
        File doc = new File(renderingContext.getBasedir(), renderingContext.getInputName());
        Object reader = null;
        try {
            block16: {
                String resource = doc.getAbsolutePath();
                Parser parser = this.doxia.getParser(renderingContext.getParserId());
                if (renderingContext.getAttribute("velocity") != null) {
                    try {
                        SiteResourceLoader.setResource((String)resource);
                        Context vc = this.createVelocityContext(sink, siteContext);
                        StringWriter sw = new StringWriter();
                        this.velocity.getEngine().mergeTemplate(resource, siteContext.getInputEncoding(), vc, (Writer)sw);
                        reader = new StringReader(sw.toString());
                        if (parser.getType() == 2 && siteContext.isValidate()) {
                            reader = this.validate((Reader)reader, resource);
                        }
                    }
                    catch (Exception e) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().error("Error parsing " + resource + " as a velocity template, using as text.", (Throwable)e);
                            break block16;
                        }
                        this.getLogger().error("Error parsing " + resource + " as a velocity template, using as text.");
                    }
                } else {
                    switch (parser.getType()) {
                        case 2: {
                            reader = ReaderFactory.newXmlReader((File)doc);
                            if (!siteContext.isValidate()) break;
                            reader = this.validate((Reader)reader, resource);
                            break;
                        }
                        default: {
                            reader = ReaderFactory.newReader((File)doc, (String)siteContext.getInputEncoding());
                        }
                    }
                }
            }
            sink.enableLogging((Log)new PlexusLoggerWrapper(this.getLogger()));
            if (reader == null) {
                throw new RendererException("Error getting a parser for '" + doc + "'");
            }
            this.doxia.parse((Reader)reader, renderingContext.getParserId(), (Sink)sink);
        }
        catch (ParserNotFoundException e) {
            try {
                throw new RendererException("Error getting a parser for '" + doc + "': " + e.getMessage(), e);
                catch (ParseException e2) {
                    throw new RendererException("Error parsing '" + doc + "': line [" + e2.getLineNumber() + "] " + e2.getMessage(), e2);
                }
                catch (IOException e3) {
                    throw new RendererException("IOException when processing '" + doc + "'", e3);
                }
            }
            catch (Throwable throwable) {
                sink.flush();
                sink.close();
                IOUtil.close(reader);
                throw throwable;
            }
        }
        sink.flush();
        sink.close();
        IOUtil.close((Reader)reader);
        this.generateDocument(writer, sink, siteContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context createVelocityContext(SiteRendererSink sink, SiteRenderingContext siteRenderingContext) {
        InputStream inputStream;
        ToolContext context;
        block15: {
            ToolManager toolManager = new ToolManager(true);
            context = toolManager.createContext();
            RenderingContext renderingContext = sink.getRenderingContext();
            context.put("relativePath", (Object)renderingContext.getRelativePath());
            context.put("authors", sink.getAuthors());
            context.put("shortTitle", (Object)sink.getTitle());
            String title = "";
            if (siteRenderingContext.getDecoration() != null && siteRenderingContext.getDecoration().getName() != null) {
                title = siteRenderingContext.getDecoration().getName();
            } else if (siteRenderingContext.getDefaultWindowTitle() != null) {
                title = siteRenderingContext.getDefaultWindowTitle();
            }
            if (title.length() > 0) {
                title = title + " - ";
            }
            title = title + sink.getTitle();
            context.put("title", (Object)title);
            context.put("headContent", (Object)sink.getHead());
            context.put("bodyContent", (Object)sink.getBody());
            context.put("decoration", (Object)siteRenderingContext.getDecoration());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            if (StringUtils.isNotEmpty((String)sink.getDate())) {
                try {
                    context.put("dateCreation", (Object)sdf.format(new SimpleDateFormat("yyyy-MM-dd").parse(sink.getDate())));
                }
                catch (java.text.ParseException e) {
                    this.getLogger().debug("Could not parse date: " + sink.getDate() + ", ignoring!", (Throwable)e);
                }
            }
            context.put("dateRevision", (Object)sdf.format(new Date()));
            context.put("currentDate", (Object)new Date());
            context.put("publishDate", (Object)siteRenderingContext.getPublishDate());
            Locale locale = siteRenderingContext.getLocale();
            DateFormat dateFormat = DateFormat.getDateInstance(2, locale);
            if (siteRenderingContext.getDecoration().getPublishDate() != null && StringUtils.isNotBlank((String)siteRenderingContext.getDecoration().getPublishDate().getFormat())) {
                dateFormat = new SimpleDateFormat(siteRenderingContext.getDecoration().getPublishDate().getFormat(), locale);
            }
            context.put("dateFormat", (Object)dateFormat);
            String currentFileName = renderingContext.getOutputName().replace('\\', '/');
            context.put("currentFileName", (Object)currentFileName);
            context.put("alignedFileName", (Object)PathTool.calculateLink((String)currentFileName, (String)renderingContext.getRelativePath()));
            context.put("locale", (Object)locale);
            context.put("supportedLocales", Collections.unmodifiableList(siteRenderingContext.getSiteLocales()));
            inputStream = null;
            try {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("META-INF/maven/org.apache.maven.doxia/doxia-site-renderer/pom.properties");
                if (inputStream == null) {
                    this.getLogger().debug("pom.properties for doxia-site-renderer could not be found.");
                    break block15;
                }
                Properties properties = new Properties();
                properties.load(inputStream);
                context.put("doxiaSiteRendererVersion", (Object)properties.getProperty("version"));
            }
            catch (IOException e) {
                try {
                    this.getLogger().debug("Failed to load pom.properties, so doxiaVersion is not available in the velocityContext.");
                }
                catch (Throwable throwable) {
                    IOUtil.close(inputStream);
                    throw throwable;
                }
                IOUtil.close((InputStream)inputStream);
            }
        }
        IOUtil.close((InputStream)inputStream);
        Map<String, ?> templateProperties = siteRenderingContext.getTemplateProperties();
        if (templateProperties != null) {
            for (Map.Entry<String, ?> entry : templateProperties.entrySet()) {
                context.put(entry.getKey(), entry.getValue());
            }
        }
        context.put("PathTool", (Object)new PathTool());
        context.put("FileUtils", (Object)new FileUtils());
        context.put("StringUtils", (Object)new StringUtils());
        context.put("i18n", (Object)this.i18n);
        return context;
    }

    @Override
    public void generateDocument(Writer writer, SiteRendererSink sink, SiteRenderingContext siteRenderingContext) throws RendererException {
        Context context = this.createVelocityContext(sink, siteRenderingContext);
        this.writeTemplate(writer, context, siteRenderingContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTemplate(Writer writer, Context context, SiteRenderingContext siteContext) throws RendererException {
        ClassLoader old = null;
        if (siteContext.getTemplateClassLoader() != null) {
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(siteContext.getTemplateClassLoader());
        }
        try {
            this.processTemplate(siteContext.getTemplateName(), context, writer);
        }
        finally {
            IOUtil.close((Writer)writer);
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    private void processTemplate(String templateName, Context context, Writer writer) throws RendererException {
        Template template;
        try {
            template = this.velocity.getEngine().getTemplate(templateName);
        }
        catch (Exception e) {
            throw new RendererException("Could not find the template '" + templateName, e);
        }
        try {
            template.merge(context, writer);
        }
        catch (Exception e) {
            throw new RendererException("Error while generating code.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SiteRenderingContext createContextForSkin(File skinFile, Map<String, ?> attributes, DecorationModel decoration, String defaultWindowTitle, Locale locale) throws IOException {
        SiteRenderingContext context = new SiteRenderingContext();
        ZipFile zipFile = DefaultSiteRenderer.getZipFile(skinFile);
        try {
            if (zipFile.getEntry(SKIN_TEMPLATE_LOCATION) != null) {
                context.setTemplateName(SKIN_TEMPLATE_LOCATION);
                context.setTemplateClassLoader(new URLClassLoader(new URL[]{skinFile.toURI().toURL()}));
            } else {
                context.setTemplateName(DEFAULT_TEMPLATE);
                context.setTemplateClassLoader(this.getClass().getClassLoader());
                context.setUsingDefaultTemplate(true);
            }
        }
        finally {
            DefaultSiteRenderer.closeZipFile(zipFile);
        }
        context.setTemplateProperties(attributes);
        context.setLocale(locale);
        context.setDecoration(decoration);
        context.setDefaultWindowTitle(defaultWindowTitle);
        context.setSkinJarFile(skinFile);
        return context;
    }

    private static ZipFile getZipFile(File file) throws IOException {
        if (file == null) {
            throw new IOException("Error opening ZipFile: null");
        }
        try {
            return new ZipFile(file);
        }
        catch (ZipException ex) {
            IOException ioe = new IOException("Error opening ZipFile: " + file.getAbsolutePath());
            ioe.initCause(ex);
            throw ioe;
        }
    }

    @Override
    public SiteRenderingContext createContextForTemplate(File templateFile, File skinFile, Map<String, ?> attributes, DecorationModel decoration, String defaultWindowTitle, Locale locale) throws MalformedURLException {
        SiteRenderingContext context = new SiteRenderingContext();
        context.setTemplateName(templateFile.getName());
        context.setTemplateClassLoader(new URLClassLoader(new URL[]{templateFile.getParentFile().toURI().toURL()}));
        context.setTemplateProperties(attributes);
        context.setLocale(locale);
        context.setDecoration(decoration);
        context.setDefaultWindowTitle(defaultWindowTitle);
        context.setSkinJarFile(skinFile);
        return context;
    }

    private static void closeZipFile(ZipFile zipFile) {
        try {
            zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyResources(SiteRenderingContext siteRenderingContext, File resourcesDirectory, File outputDirectory) throws IOException {
        File siteCssFile;
        block21: {
            InputStream resourceList;
            if (siteRenderingContext.getSkinJarFile() != null) {
                ZipFile file = DefaultSiteRenderer.getZipFile(siteRenderingContext.getSkinJarFile());
                try {
                    Enumeration<? extends ZipEntry> e = file.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entry = e.nextElement();
                        if (entry.getName().startsWith("META-INF/")) continue;
                        File destFile = new File(outputDirectory, entry.getName());
                        if (!entry.isDirectory()) {
                            destFile.getParentFile().mkdirs();
                            DefaultSiteRenderer.copyFileFromZip(file, entry, destFile);
                            continue;
                        }
                        destFile.mkdirs();
                    }
                }
                finally {
                    DefaultSiteRenderer.closeZipFile(file);
                }
            }
            if (!siteRenderingContext.isUsingDefaultTemplate() || (resourceList = this.getClass().getClassLoader().getResourceAsStream("org/apache/maven/doxia/siterenderer/resources/resources.txt")) == null) break block21;
            Reader r = null;
            LineNumberReader reader = null;
            try {
                r = ReaderFactory.newReader((InputStream)resourceList, (String)"UTF-8");
                reader = new LineNumberReader(r);
                String line = reader.readLine();
                while (line != null) {
                    InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/apache/maven/doxia/siterenderer/resources/" + line);
                    if (is == null) {
                        throw new IOException("The resource " + line + " doesn't exist.");
                    }
                    File outputFile = new File(outputDirectory, line);
                    if (!outputFile.getParentFile().exists()) {
                        outputFile.getParentFile().mkdirs();
                    }
                    FileOutputStream os = null;
                    try {
                        os = new FileOutputStream(outputFile);
                        IOUtil.copy((InputStream)is, (OutputStream)os);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(os);
                        throw throwable;
                    }
                    IOUtil.close((OutputStream)os);
                    IOUtil.close((InputStream)is);
                    line = reader.readLine();
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                IOUtil.close((Reader)r);
                throw throwable;
            }
            IOUtil.close((Reader)reader);
            IOUtil.close((Reader)r);
        }
        if (resourcesDirectory != null && resourcesDirectory.exists()) {
            this.copyDirectory(resourcesDirectory, outputDirectory);
        }
        if (!(siteCssFile = new File(outputDirectory, "/css/site.css")).exists()) {
            File cssDirectory = new File(outputDirectory, "/css/");
            boolean created = cssDirectory.mkdirs();
            if (created && this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The directory '" + cssDirectory.getAbsolutePath() + "' did not exist. It was created.");
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The file '" + siteCssFile.getAbsolutePath() + "' does not exists. Creating an empty file.");
            }
            Writer writer = null;
            try {
                writer = WriterFactory.newWriter((File)siteCssFile, (String)siteRenderingContext.getOutputEncoding());
                writer.write("/* You can override this file with your own styles */");
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
            IOUtil.close((Writer)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileFromZip(ZipFile file, ZipEntry entry, File destFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(destFile);
        try {
            IOUtil.copy((InputStream)file.getInputStream(entry), (OutputStream)fos);
        }
        finally {
            IOUtil.close((OutputStream)fos);
        }
    }

    protected void copyDirectory(File source, File destination) throws IOException {
        if (source.exists()) {
            DirectoryScanner scanner = new DirectoryScanner();
            String[] includedResources = new String[]{"**/**"};
            scanner.setIncludes(includedResources);
            scanner.addDefaultExcludes();
            scanner.setBasedir(source);
            scanner.scan();
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            for (String name : includedFiles) {
                File sourceFile = new File(source, name);
                File destinationFile = new File(destination, name);
                FileUtils.copyFile((File)sourceFile, (File)destinationFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reader validate(Reader source, String resource) throws ParseException, IOException {
        this.getLogger().debug("Validating: " + resource);
        try {
            String content = IOUtil.toString((Reader)new BufferedReader(source));
            new XmlValidator((Log)new PlexusLoggerWrapper(this.getLogger())).validate(content);
            StringReader stringReader = new StringReader(content);
            return stringReader;
        }
        finally {
            IOUtil.close((Reader)source);
        }
    }
}

