/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.SimpleRecursionInterceptor;
import org.codehaus.plexus.interpolation.multi.DelimiterSpecification;

public class MultiDelimiterInterpolatorFilterReaderLineEnding
extends FilterReader {
    private Interpolator interpolator;
    private RecursionInterceptor recursionInterceptor;
    private String replaceData = null;
    private int replaceIndex = -1;
    private int previousIndex = -1;
    public static final String DEFAULT_BEGIN_TOKEN = "${";
    public static final String DEFAULT_END_TOKEN = "}";
    private boolean interpolateWithPrefixPattern = true;
    private String escapeString;
    private boolean useEscape = false;
    private boolean preserveEscapeString = false;
    private LinkedHashSet delimiters = new LinkedHashSet();
    private DelimiterSpecification currentSpec;
    private String beginToken;
    private String originalBeginToken;
    private String endToken;
    private boolean supportMultiLineFiltering;
    private int preserveChar = -1;

    public MultiDelimiterInterpolatorFilterReaderLineEnding(Reader in, Interpolator interpolator, boolean supportMultiLineFiltering) {
        this(in, interpolator, (RecursionInterceptor)new SimpleRecursionInterceptor(), supportMultiLineFiltering);
    }

    public MultiDelimiterInterpolatorFilterReaderLineEnding(Reader in, Interpolator interpolator, RecursionInterceptor ri, boolean supportMultiLineFiltering) {
        super(in);
        this.interpolator = interpolator;
        this.interpolator.setCacheAnswers(true);
        this.recursionInterceptor = ri;
        this.delimiters.add(DelimiterSpecification.DEFAULT_SPEC);
        this.supportMultiLineFiltering = supportMultiLineFiltering;
    }

    public boolean removeDelimiterSpec(String delimiterSpec) {
        return this.delimiters.remove(DelimiterSpecification.parse((String)delimiterSpec));
    }

    public MultiDelimiterInterpolatorFilterReaderLineEnding setDelimiterSpecs(HashSet specs) {
        this.delimiters.clear();
        Iterator it = specs.iterator();
        while (it.hasNext()) {
            String spec = (String)it.next();
            this.delimiters.add(DelimiterSpecification.parse((String)spec));
        }
        return this;
    }

    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        for (long i = 0L; i < n; ++i) {
            if (this.read() != -1) continue;
            return i;
        }
        return n;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int ch = this.read();
            if (ch == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            cbuf[off + i] = (char)ch;
        }
        return len;
    }

    public int read() throws IOException {
        if (this.replaceIndex != -1 && this.replaceIndex < this.replaceData.length()) {
            char ch = this.replaceData.charAt(this.replaceIndex++);
            if (this.replaceIndex >= this.replaceData.length()) {
                this.replaceIndex = -1;
            }
            return ch;
        }
        if (this.preserveChar >= 0) {
            int copy = this.preserveChar;
            this.preserveChar = -1;
            this.replaceIndex = -1;
            return copy;
        }
        int ch = -1;
        ch = this.previousIndex != -1 && this.previousIndex < this.endToken.length() ? (int)this.endToken.charAt(this.previousIndex++) : this.in.read();
        if (ch == 10 && !this.supportMultiLineFiltering) {
            this.previousIndex = -1;
            return ch;
        }
        boolean inEscape = false;
        inEscape = this.useEscape && ch == this.escapeString.charAt(0);
        if (inEscape || this.reselectDelimiterSpec(ch)) {
            StringBuffer key = new StringBuffer();
            key.append((char)ch);
            boolean atEnd = false;
            if (inEscape) {
                for (int i = 0; i < this.escapeString.length() - 1; ++i) {
                    ch = this.in.read();
                    if (ch == -1 || ch == 10 && !this.supportMultiLineFiltering) {
                        atEnd = true;
                        break;
                    }
                    key.append((char)ch);
                }
                if (!atEnd) {
                    ch = this.in.read();
                    if (!this.reselectDelimiterSpec(ch)) {
                        this.replaceData = key.toString();
                        this.replaceIndex = 1;
                        this.preserveChar = ch;
                        return this.replaceData.charAt(0);
                    }
                    key.append((char)ch);
                }
            }
            int beginTokenMatchPos = 1;
            while (!atEnd) {
                ch = this.previousIndex != -1 && this.previousIndex < this.endToken.length() ? (int)this.endToken.charAt(this.previousIndex++) : this.in.read();
                if (ch == 10 && !this.supportMultiLineFiltering) {
                    key.append((char)ch);
                    break;
                }
                if (ch == -1) break;
                key.append((char)ch);
                if (beginTokenMatchPos < this.originalBeginToken.length() && ch != this.originalBeginToken.charAt(beginTokenMatchPos)) {
                    ch = -1;
                    break;
                }
                ++beginTokenMatchPos;
                if (ch != this.endToken.charAt(0)) continue;
            }
            if (ch != -1 && ch != 10 && !this.supportMultiLineFiltering && this.endToken.length() > 1) {
                int endTokenMatchPos = 1;
                while ((ch = this.previousIndex != -1 && this.previousIndex < this.endToken.length() ? (int)this.endToken.charAt(this.previousIndex++) : this.in.read()) != -1) {
                    key.append((char)ch);
                    if (ch != this.endToken.charAt(endTokenMatchPos++) || ch != 10 && !this.supportMultiLineFiltering) {
                        ch = -1;
                        break;
                    }
                    if (endTokenMatchPos < this.endToken.length()) continue;
                }
            }
            if (ch == -1 || ch == 10 && !this.supportMultiLineFiltering) {
                this.replaceData = key.toString();
                this.replaceIndex = 1;
                return this.replaceData.charAt(0);
            }
            String value = null;
            try {
                boolean escapeFound = false;
                if (this.useEscape && key.toString().startsWith(this.beginToken)) {
                    String keyStr = key.toString();
                    value = !this.preserveEscapeString ? keyStr.substring(this.escapeString.length(), keyStr.length()) : keyStr;
                    escapeFound = true;
                }
                if (!escapeFound) {
                    value = this.interpolateWithPrefixPattern ? this.interpolator.interpolate(key.toString(), "", this.recursionInterceptor) : this.interpolator.interpolate(key.toString(), this.recursionInterceptor);
                }
            }
            catch (InterpolationException e) {
                IllegalArgumentException error = new IllegalArgumentException(e.getMessage());
                error.initCause(e);
                throw error;
            }
            if (value != null) {
                if (value.length() != 0) {
                    this.replaceData = value;
                    this.replaceIndex = 0;
                }
                return this.read();
            }
            this.previousIndex = 0;
            this.replaceData = key.substring(0, key.length() - this.endToken.length());
            this.replaceIndex = 0;
            return this.beginToken.charAt(0);
        }
        return ch;
    }

    private boolean reselectDelimiterSpec(int ch) {
        Iterator it = this.delimiters.iterator();
        while (it.hasNext()) {
            DelimiterSpecification spec = (DelimiterSpecification)it.next();
            if (ch != spec.getBegin().charAt(0)) continue;
            this.currentSpec = spec;
            this.originalBeginToken = this.currentSpec.getBegin();
            this.beginToken = this.useEscape ? this.escapeString + this.originalBeginToken : this.originalBeginToken;
            this.endToken = this.currentSpec.getEnd();
            return true;
        }
        return false;
    }

    public boolean isInterpolateWithPrefixPattern() {
        return this.interpolateWithPrefixPattern;
    }

    public void setInterpolateWithPrefixPattern(boolean interpolateWithPrefixPattern) {
        this.interpolateWithPrefixPattern = interpolateWithPrefixPattern;
    }

    public String getEscapeString() {
        return this.escapeString;
    }

    public void setEscapeString(String escapeString) {
        if (escapeString != null && escapeString.length() >= 1) {
            this.escapeString = escapeString;
            this.useEscape = escapeString != null && escapeString.length() >= 1;
        }
    }

    public boolean isPreserveEscapeString() {
        return this.preserveEscapeString;
    }

    public void setPreserveEscapeString(boolean preserveEscapeString) {
        this.preserveEscapeString = preserveEscapeString;
    }

    public RecursionInterceptor getRecursionInterceptor() {
        return this.recursionInterceptor;
    }

    public MultiDelimiterInterpolatorFilterReaderLineEnding setRecursionInterceptor(RecursionInterceptor recursionInterceptor) {
        this.recursionInterceptor = recursionInterceptor;
        return this;
    }
}

