/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.unary.JSIsArrayNode;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSIsArrayNode.class)
public final class JSIsArrayNodeGen
extends JSIsArrayNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @CompilerDirectives.CompilationFinal
    private IsArrayShapeData isArrayShape_cache;
    @CompilerDirectives.CompilationFinal
    private IsArrayJSClassData isArrayJSClass_cache;
    @Node.Child
    private InteropLibrary foreign_interop_;

    private JSIsArrayNodeGen(boolean jsType) {
        super(jsType);
    }

    @Override
    @ExplodeLoop
    public boolean execute(Object arg0Value) {
        int state = this.state_;
        if ((state & 0x1F) != 0 && JSTypes.isDynamicObject(arg0Value)) {
            DynamicObject arg0Value_ = (DynamicObject)arg0Value;
            if ((state & 1) != 0) {
                IsArrayShapeData s1_ = this.isArrayShape_cache;
                while (s1_ != null) {
                    assert (s1_.cachedIsJSObject_);
                    assert (!s1_.cachedIsProxy_);
                    if (s1_.cachedShape_.check(arg0Value_)) {
                        return JSIsArrayNode.doIsArrayShape(arg0Value_, s1_.cachedShape_, s1_.cachedIsJSObject_, s1_.cachedIsArray_, s1_.cachedIsProxy_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                IsArrayJSClassData s2_ = this.isArrayJSClass_cache;
                while (s2_ != null) {
                    assert (!s2_.cachedIsProxy_);
                    assert (s2_.cachedClass_ != null);
                    if (s2_.cachedClass_.isInstance(arg0Value_)) {
                        return JSIsArrayNode.doIsArrayJSClass(arg0Value_, s2_.cachedClass_, s2_.cachedIsArray_, s2_.cachedIsProxy_);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state & 4) != 0 && JSGuards.isJSArray(arg0Value_)) {
                return this.doJSArray(arg0Value_);
            }
            if ((state & 8) != 0 && JSGuards.isJSProxy(arg0Value_)) {
                return this.doJSProxy(arg0Value_);
            }
            if ((state & 0x10) != 0 && JSGuards.isJSType(arg0Value_) && !JSGuards.isJSArray(arg0Value_) && !JSGuards.isJSProxy(arg0Value_)) {
                return this.doJSObject(arg0Value_);
            }
        }
        if ((state & 0x60) != 0) {
            if ((state & 0x20) != 0 && !JSGuards.isJSType(arg0Value)) {
                assert (this.jsType);
                return this.doNotObject(arg0Value);
            }
            if ((state & 0x40) != 0 && !JSGuards.isJSType(arg0Value)) {
                assert (!this.jsType);
                return this.doForeign(arg0Value, this.foreign_interop_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private boolean executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (JSTypes.isDynamicObject(arg0Value)) {
                boolean bl;
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                if ((exclude & 1) == 0) {
                    Shape cachedShape__;
                    boolean cachedIsProxy__;
                    boolean cachedIsJSObject__;
                    int count1_ = 0;
                    IsArrayShapeData s1_ = this.isArrayShape_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null) {
                            assert (s1_.cachedIsJSObject_);
                            assert (!s1_.cachedIsProxy_);
                            if (s1_.cachedShape_.check(arg0Value_)) break;
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && (cachedIsJSObject__ = JSGuards.isJSObject(arg0Value_)) && !(cachedIsProxy__ = JSGuards.isJSProxy(arg0Value_)) && (cachedShape__ = arg0Value_.getShape()).check(arg0Value_) && count1_ < 1) {
                        s1_ = new IsArrayShapeData(this.isArrayShape_cache);
                        s1_.cachedShape_ = cachedShape__;
                        s1_.cachedIsJSObject_ = cachedIsJSObject__;
                        s1_.cachedIsArray_ = JSGuards.isJSArray(arg0Value_);
                        s1_.cachedIsProxy_ = cachedIsProxy__;
                        this.isArrayShape_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        cachedIsJSObject__ = JSIsArrayNode.doIsArrayShape(arg0Value_, s1_.cachedShape_, s1_.cachedIsJSObject_, s1_.cachedIsArray_, s1_.cachedIsProxy_);
                        return cachedIsJSObject__;
                    }
                }
                if ((exclude & 2) == 0) {
                    JSClass cachedClass__;
                    boolean cachedIsProxy__;
                    int count2_ = 0;
                    IsArrayJSClassData s2_ = this.isArrayJSClass_cache;
                    if ((state & 2) != 0) {
                        while (s2_ != null) {
                            assert (!s2_.cachedIsProxy_);
                            assert (s2_.cachedClass_ != null);
                            if (s2_.cachedClass_.isInstance(arg0Value_)) break;
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && !(cachedIsProxy__ = JSGuards.isJSProxy(arg0Value_)) && (cachedClass__ = JSGuards.getJSClassChecked(arg0Value_)) != null && cachedClass__.isInstance(arg0Value_) && count2_ < 1) {
                        s2_ = new IsArrayJSClassData(this.isArrayJSClass_cache);
                        s2_.cachedClass_ = cachedClass__;
                        s2_.cachedIsArray_ = JSGuards.isJSArray(arg0Value_);
                        s2_.cachedIsProxy_ = cachedIsProxy__;
                        this.isArrayJSClass_cache = s2_;
                        this.exclude_ = exclude |= 1;
                        this.isArrayShape_cache = null;
                        state &= 0xFFFFFFFE;
                        this.state_ = state |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        boolean bl2 = JSIsArrayNode.doIsArrayJSClass(arg0Value_, s2_.cachedClass_, s2_.cachedIsArray_, s2_.cachedIsProxy_);
                        return bl2;
                    }
                }
                if (JSGuards.isJSArray(arg0Value_)) {
                    this.exclude_ = exclude |= 3;
                    this.isArrayShape_cache = null;
                    this.isArrayJSClass_cache = null;
                    state &= 0xFFFFFFFC;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    bl = this.doJSArray(arg0Value_);
                    return bl;
                }
                if (JSGuards.isJSProxy(arg0Value_)) {
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    bl = this.doJSProxy(arg0Value_);
                    return bl;
                }
                if (JSGuards.isJSType(arg0Value_) && !JSGuards.isJSArray(arg0Value_) && !JSGuards.isJSProxy(arg0Value_)) {
                    this.exclude_ = exclude |= 3;
                    this.isArrayShape_cache = null;
                    this.isArrayJSClass_cache = null;
                    state &= 0xFFFFFFFC;
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    bl = this.doJSObject(arg0Value_);
                    return bl;
                }
            }
            if (!JSGuards.isJSType(arg0Value) && this.jsType) {
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doNotObject(arg0Value);
                return bl;
            }
            if (!JSGuards.isJSType(arg0Value) && !this.jsType) {
                this.foreign_interop_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(3));
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doForeign(arg0Value, this.foreign_interop_);
                return bl;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            IsArrayShapeData s1_ = this.isArrayShape_cache;
            IsArrayJSClassData s2_ = this.isArrayJSClass_cache;
            if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[8];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doIsArrayShape";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            IsArrayShapeData s1_ = this.isArrayShape_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(s1_.cachedShape_, s1_.cachedIsJSObject_, s1_.cachedIsArray_, s1_.cachedIsProxy_));
                s1_ = s1_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doIsArrayJSClass";
        if ((state & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            IsArrayJSClassData s2_ = this.isArrayJSClass_cache;
            while (s2_ != null) {
                cached.add(Arrays.asList(new Object[]{s2_.cachedClass_, s2_.cachedIsArray_, s2_.cachedIsProxy_}));
                s2_ = s2_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doJSArray";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doJSProxy";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doJSObject";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doNotObject";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doForeign";
        if ((state & 0x40) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.foreign_interop_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[7] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSIsArrayNode create(boolean jsType) {
        return new JSIsArrayNodeGen(jsType);
    }

    @GeneratedBy(value=JSIsArrayNode.class)
    private static final class IsArrayJSClassData {
        @CompilerDirectives.CompilationFinal
        IsArrayJSClassData next_;
        @CompilerDirectives.CompilationFinal
        JSClass cachedClass_;
        @CompilerDirectives.CompilationFinal
        boolean cachedIsArray_;
        @CompilerDirectives.CompilationFinal
        boolean cachedIsProxy_;

        IsArrayJSClassData(IsArrayJSClassData next_) {
            this.next_ = next_;
        }
    }

    @GeneratedBy(value=JSIsArrayNode.class)
    private static final class IsArrayShapeData {
        @CompilerDirectives.CompilationFinal
        IsArrayShapeData next_;
        @CompilerDirectives.CompilationFinal
        Shape cachedShape_;
        @CompilerDirectives.CompilationFinal
        boolean cachedIsJSObject_;
        @CompilerDirectives.CompilationFinal
        boolean cachedIsArray_;
        @CompilerDirectives.CompilationFinal
        boolean cachedIsProxy_;

        IsArrayShapeData(IsArrayShapeData next_) {
            this.next_ = next_;
        }
    }
}

