/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSDoubleToStringNodeGen;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.JSRuntime;

public abstract class JSDoubleToStringNode
extends JavaScriptBaseNode {
    public static JSDoubleToStringNode create() {
        return JSDoubleToStringNodeGen.create();
    }

    public abstract String executeString(Object var1);

    @Specialization
    protected static String doInt(int i) {
        return Boundaries.stringValueOf(i);
    }

    @Specialization
    protected static String doLong(long i) {
        return Boundaries.stringValueOf(i);
    }

    @Specialization
    protected static String doDouble(double d, @Cached(value="createBinaryProfile()") ConditionProfile isInt, @Cached(value="createBinaryProfile()") ConditionProfile isNaN, @Cached(value="createBinaryProfile()") ConditionProfile isPositiveInfinity, @Cached(value="createBinaryProfile()") ConditionProfile isNegativeInfinity, @Cached(value="createBinaryProfile()") ConditionProfile isZero) {
        if (isZero.profile(d == 0.0)) {
            return "0";
        }
        if (isInt.profile(JSRuntime.doubleIsRepresentableAsInt(d, true))) {
            return JSDoubleToStringNode.doInt((int)d);
        }
        if (isNaN.profile(Double.isNaN(d))) {
            return "NaN";
        }
        if (isPositiveInfinity.profile(d == Double.POSITIVE_INFINITY)) {
            return "Infinity";
        }
        if (isNegativeInfinity.profile(d == Double.NEGATIVE_INFINITY)) {
            return "-Infinity";
        }
        return JSRuntime.formatDtoA(d);
    }
}

