/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Layout;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import com.oracle.truffle.js.runtime.objects.JSPrototypeData;
import com.oracle.truffle.js.runtime.objects.JSShapeData;
import com.oracle.truffle.js.runtime.objects.JSSharedData;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.util.UnmodifiableArrayList;
import java.util.function.Function;
import java.util.function.Predicate;

public final class JSShape {
    public static final HiddenKey NOT_EXTENSIBLE_KEY = new HiddenKey("\uf001!extensible");
    private static final Property NOT_EXTENSIBLE_PROPERTY = JSObjectUtil.makeHiddenProperty(NOT_EXTENSIBLE_KEY, JSObjectUtil.createConstantLocation(null));

    private JSShape() {
    }

    public static JSClass getJSClass(Shape shape) {
        return (JSClass)shape.getObjectType();
    }

    public static ObjectType getJSClassNoCast(Shape shape) {
        return shape.getObjectType();
    }

    public static JSSharedData getSharedData(Shape shape) {
        return (JSSharedData)shape.getSharedData();
    }

    public static Shape getProtoChildTree(DynamicObject prototype, JSClass jsclass) {
        JSPrototypeData prototypeData = JSObjectUtil.getPrototypeData(prototype);
        if (prototypeData != null) {
            return prototypeData.getProtoChildTree(jsclass);
        }
        return null;
    }

    public static Shape makeNotExtensible(Shape shape) {
        if (JSShape.isExtensible(shape)) {
            return shape.addProperty(NOT_EXTENSIBLE_PROPERTY);
        }
        return shape;
    }

    public static boolean isExtensible(Shape shape) {
        return shape.getLastProperty() != NOT_EXTENSIBLE_PROPERTY;
    }

    public static boolean isPrototypeInShape(Shape shape) {
        return JSShape.getPrototypeProperty(shape).getLocation().isConstant();
    }

    public static Property getPrototypeProperty(Shape shape) {
        return JSShape.getSharedData(shape).getPrototypeProperty();
    }

    static Property makePrototypeProperty(DynamicObject prototype) {
        return JSObjectUtil.makeHiddenProperty(JSObject.HIDDEN_PROTO, JSObjectUtil.createConstantLocation(prototype));
    }

    public static Assumption getPropertyAssumption(Shape shape, Object key) {
        assert (JSRuntime.isPropertyKey(key) || key instanceof HiddenKey);
        return JSShape.getSharedData(shape).getPropertyAssumption(key);
    }

    public static Assumption getPropertyAssumption(Shape shape, Object key, boolean prototype) {
        assert (JSRuntime.isPropertyKey(key) || key instanceof HiddenKey);
        if (prototype) {
            return shape.getLeafAssumption();
        }
        return JSShape.getSharedData(shape).getPropertyAssumption(key);
    }

    public static void invalidatePropertyAssumption(Shape shape, Object propertyName) {
        JSShape.getSharedData(shape).invalidatePropertyAssumption(propertyName);
    }

    public static JSContext getJSContext(Shape shape) {
        return JSShape.getSharedData(shape).getContext();
    }

    public static Assumption getPrototypeAssumption(Shape shape) {
        return JSShape.getSharedData(shape).getPrototypeAssumption();
    }

    public static void invalidatePrototypeAssumption(Shape shape) {
        JSShape.getSharedData(shape).invalidatePrototypeAssumption();
    }

    private static Shape freezeHelper(Shape shape, Predicate<Shape> pred, Function<Property, Property> propertyConverter) {
        if (!pred.test(shape)) {
            Shape newShape = shape;
            for (Property property : shape.getProperties()) {
                assert (property.equals(newShape.getProperty(property.getKey())));
                newShape = newShape.replaceProperty(property, propertyConverter.apply(property));
            }
            assert (pred.test(newShape));
            return newShape;
        }
        return shape;
    }

    public static Shape freeze(Shape shape) {
        return JSShape.freezeHelper(shape, JSShape::isFrozen, JSProperty::freeze);
    }

    public static Shape seal(Shape shape) {
        return JSShape.freezeHelper(shape, JSShape::isSealed, JSProperty::seal);
    }

    private static boolean isFrozenHelper(Shape shape, Predicate<Property> pred) {
        for (Property property : shape.getProperties()) {
            if (!pred.test(property)) continue;
            return false;
        }
        return true;
    }

    private static boolean isFrozen(Shape shape) {
        return JSShape.isFrozenHelper(shape, currentProperty -> (JSProperty.isConfigurable(currentProperty) || JSProperty.isData(currentProperty) && JSProperty.isWritable(currentProperty)) && !currentProperty.isHidden());
    }

    private static boolean isSealed(Shape shape) {
        return JSShape.isFrozenHelper(shape, currentProperty -> JSProperty.isConfigurable(currentProperty) && !currentProperty.isHidden());
    }

    public static UnmodifiableArrayList<Property> getProperties(Shape shape) {
        return JSShapeData.getProperties(shape);
    }

    public static UnmodifiableArrayList<String> getEnumerablePropertyNames(Shape shape) {
        return JSShapeData.getEnumerablePropertyNames(shape);
    }

    public static UnmodifiableArrayList<Property> getPropertiesIfHasEnumerablePropertyNames(Shape shape) {
        return JSShapeData.getPropertiesIfHasEnumerablePropertyNames(shape);
    }

    public static Shape makeStaticRoot(Layout layout, ObjectType jsclass, int id) {
        return JSShape.makeRootShape(layout, jsclass, new JSSharedData(null, JSShape.makePrototypeProperty(Null.instance)), id);
    }

    public static Shape makeEmptyRoot(Layout layout, ObjectType jsclass, JSContext context) {
        return JSShape.makeRootShape(layout, new JSSharedData(context, JSShape.makePrototypeProperty(Null.instance)), jsclass);
    }

    public static Shape makeEmptyRoot(Layout layout, ObjectType jsclass, JSContext context, Property prototypeProperty) {
        return JSShape.makeRootShape(layout, new JSSharedData(context, prototypeProperty), jsclass);
    }

    public static Shape makeUniqueRoot(Layout layout, ObjectType jsclass, JSContext context, Property prototypeProperty) {
        return JSShape.makeRootShape(layout, new JSSharedData(context, prototypeProperty), jsclass);
    }

    public static Shape makeUniqueRootWithPrototype(Layout layout, ObjectType jsclass, JSContext context, DynamicObject prototype) {
        return JSShape.makeRootShape(layout, new JSSharedData(context, JSShape.makePrototypeProperty(prototype)), jsclass);
    }

    static Shape makeRootShape(Layout layout, JSSharedData sharedData, ObjectType builtinClass) {
        return JSShape.makeRootShape(layout, builtinClass, sharedData, 1);
    }

    public static Shape.Allocator makeAllocator(Layout layout) {
        Shape.Allocator allocator = layout.createAllocator();
        allocator.addLocation(JSObject.PROTO_PROPERTY.getLocation());
        return allocator;
    }

    private static Shape makeRootShape(Layout layout, ObjectType jsclass, JSSharedData sharedData, int id) {
        return layout.createShape(jsclass, (Object)sharedData, id).addProperty(sharedData.getPrototypeProperty());
    }
}

