/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site.descriptor;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.site.descriptor.AbstractSiteDescriptorMojo;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.utils.PathTool;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="attach-descriptor", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class SiteDescriptorAttachMojo
extends AbstractSiteDescriptorMojo {
    @Parameter(property="basedir", required=true, readonly=true)
    private File basedir;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="true")
    private boolean pomPackagingOnly;

    public void execute() throws MojoExecutionException {
        if (this.pomPackagingOnly && !"pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)("Skipping because packaging '" + this.project.getPackaging() + "' is not pom."));
            return;
        }
        boolean attachedSiteDescriptor = false;
        for (Locale locale : this.getLocales()) {
            File descriptorFile = this.siteTool.getSiteDescriptor(this.siteDirectory, locale);
            if (!descriptorFile.exists()) continue;
            attachedSiteDescriptor = true;
            String classifier = SiteDescriptorAttachMojo.getClassifier(descriptorFile);
            String filename = this.project.getArtifactId() + "-" + this.project.getVersion() + "-" + descriptorFile.getName();
            File targetDescriptorFile = new File(this.project.getBuild().getDirectory(), filename);
            try {
                FileUtils.copyFile((File)descriptorFile, (File)targetDescriptorFile);
                this.getLog().info((CharSequence)("Attaching '" + PathTool.getRelativeFilePath((String)this.basedir.getAbsolutePath(), (String)descriptorFile.getAbsolutePath()) + "' site descriptor with classifier '" + classifier + "'."));
                this.projectHelper.attachArtifact(this.project, "xml", classifier, targetDescriptorFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to copy site descriptor", (Exception)e);
            }
        }
        if (!attachedSiteDescriptor) {
            this.getLog().info((CharSequence)"No site descriptor found: nothing to attach.");
        }
    }

    private static String getClassifier(File descriptorFile) throws MojoExecutionException {
        int index = descriptorFile.getName().lastIndexOf(46);
        if (index > 0) {
            return descriptorFile.getName().substring(0, index);
        }
        throw new MojoExecutionException("Unable to determine the classifier to use");
    }
}

