/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.WeakRefPrototypeBuiltins;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import java.lang.ref.WeakReference;
import java.util.EnumSet;

public final class JSWeakRef
extends JSBuiltinObject
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final JSWeakRef INSTANCE = new JSWeakRef();
    public static final String CLASS_NAME = "WeakRef";
    public static final String PROTOTYPE_NAME = "WeakRef.prototype";
    private static final HiddenKey WEAKREF_ID = new HiddenKey("weakref");
    private static final Property WEAKREF_PROPERTY;

    private JSWeakRef() {
    }

    public static DynamicObject create(JSContext context, Object referent) {
        DynamicObject obj = JSObject.create(context, context.getWeakRefFactory(), new WeakReference<Object>(referent));
        assert (JSWeakRef.isJSWeakRef(obj));
        context.getJSAgent().addWeakRefTargetToSet(referent);
        return obj;
    }

    public static WeakReference<?> getInternalWeakRef(DynamicObject obj) {
        assert (JSWeakRef.isJSWeakRef(obj));
        return (WeakReference)WEAKREF_PROPERTY.get(obj, JSWeakRef.isJSWeakRef(obj));
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject prototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putConstructorProperty(ctx, prototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, WeakRefPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putDataProperty(ctx, prototype, Symbol.SYMBOL_TO_STRING_TAG, CLASS_NAME, JSAttributes.configurableNotEnumerableNotWritable());
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        initialShape = initialShape.addProperty(WEAKREF_PROPERTY);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public String safeToString(DynamicObject obj, int depth, JSContext context) {
        return "[" + this.getClassName() + "]";
    }

    public static boolean isJSWeakRef(Object obj) {
        return JSObject.isDynamicObject(obj) && JSWeakRef.isJSWeakRef((DynamicObject)obj);
    }

    public static boolean isJSWeakRef(DynamicObject obj) {
        return JSWeakRef.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getWeakRefPrototype();
    }

    static {
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        WEAKREF_PROPERTY = JSObjectUtil.makeHiddenProperty(WEAKREF_ID, allocator.locationForType(WeakReference.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
    }
}

