/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.matchers;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.regex.tregex.matchers.CharMatcher;
import com.oracle.truffle.regex.tregex.matchers.HybridBitSetMatcherNodeGen;
import com.oracle.truffle.regex.tregex.matchers.InvertibleCharMatcher;
import com.oracle.truffle.regex.util.CompilationFinalBitSet;

public abstract class HybridBitSetMatcher
extends InvertibleCharMatcher {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final byte[] highBytes;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final CompilationFinalBitSet[] bitSets;
    private final CharMatcher restMatcher;

    HybridBitSetMatcher(boolean invert, byte[] highBytes, CompilationFinalBitSet[] bitSets, CharMatcher restMatcher) {
        super(invert);
        this.highBytes = highBytes;
        this.bitSets = bitSets;
        this.restMatcher = restMatcher;
        assert (HybridBitSetMatcher.isSortedUnsigned(highBytes));
    }

    public static HybridBitSetMatcher create(boolean invert, byte[] highBytes, CompilationFinalBitSet[] bitSets, CharMatcher restMatcher) {
        return HybridBitSetMatcherNodeGen.create(invert, highBytes, bitSets, restMatcher);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    @Specialization
    protected boolean match(char c, boolean compactString) {
        assert (!compactString) : "this matcher should be avoided via ProfilingCharMatcher on compact strings";
        int highByte = HybridBitSetMatcher.highByte(c);
        for (int i = 0; i < this.highBytes.length; ++i) {
            int bitSetHighByte = Byte.toUnsignedInt(this.highBytes[i]);
            if (highByte == bitSetHighByte) {
                return this.result(this.bitSets[i].get(HybridBitSetMatcher.lowByte(c)));
            }
            if (highByte < bitSetHighByte) break;
        }
        return this.result(this.restMatcher.execute(c, compactString));
    }

    @Override
    public int estimatedCost() {
        return this.bitSets.length * 2 + this.restMatcher.estimatedCost();
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        StringBuilder sb = new StringBuilder(this.modifiersToString()).append("hybrid [\n");
        for (int i = 0; i < this.highBytes.length; ++i) {
            sb.append(String.format("  %02x: ", Byte.toUnsignedInt(this.highBytes[i]))).append(this.bitSets[i]).append("\n");
        }
        return sb.append("  rest: ").append((Object)this.restMatcher).append("\n]").toString();
    }

    private static boolean isSortedUnsigned(byte[] array) {
        int prev = Integer.MIN_VALUE;
        for (byte b : array) {
            int i = Byte.toUnsignedInt(b);
            if (prev > i) {
                return false;
            }
            prev = i;
        }
        return true;
    }
}

