.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "CREATE_RULE" "l" "08 May 2000" "SQL - Language Statements" ""
.SH NAME
CREATE RULE \- Defines a new rule
.SH SYNOPSIS
.sp
.nf
CREATE RULE \fIname\fR AS ON \fIevent\fR
    TO \fIobject\fR [ WHERE \fIcondition\fR ]
    DO [ INSTEAD ] [ \fIaction\fR | NOTHING ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of a rule to create.
.TP
\fB\fIevent\fB\fR
Event is one of select,
update, delete
or insert.
.TP
\fB\fIobject\fB\fR
Object is either \fItable\fR
or \fItable\fR.\fIcolumn\fR.
.TP
\fB\fIcondition\fB\fR
Any SQL WHERE clause, new or
old can appear instead of an instance
variable whenever an instance variable is permissible in SQL.
.TP
\fB\fIaction\fB\fR
Any SQL statement, new or
old can appear instead of an instance
variable whenever an instance variable is permissible in SQL.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE\fR
Message returned if the rule is successfully created.
.PP
.SH "DESCRIPTION"
.PP
The Postgres 
\fIrule system\fR allows one to define an
alternate action to be performed on inserts, updates, or deletions
from database tables or classes. Currently, rules are used to
implement table views.
.PP
The semantics of a rule is that at the time an individual instance is
accessed, inserted, updated, or deleted, there is a old instance (for
selects, updates and deletes) and a new instance (for inserts and
updates).
If the \fIevent\fR
specified in the ON clause and the
\fIcondition\fR specified in the
WHERE clause are true for the old instance, the
\fIaction\fR part of the rule is
executed. First, however, values from fields in the old instance
and/or the new instance are substituted for
old.\fIattribute-name\fR
and new.\fIattribute-name\fR.
.PP
The \fIaction\fR part of the rule
executes with the same command and transaction identifier as the user
command that caused activation.
.SS "NOTES"
.PP
A caution about SQL rules is in order. If the same class name
or instance variable appears in the
\fIevent\fR,
\fIcondition\fR and
\fIaction\fR parts of a rule,
they are all considered different tuple variables. More accurately,
new and old are the only tuple
variables that are shared between these clauses. For example, the following
two rules have the same semantics:
.sp
.nf
ON UPDATE TO emp.salary WHERE emp.name = "Joe"
    DO 
	UPDATE emp SET ... WHERE ...
    
.sp
.fi
.sp
.nf
ON UPDATE TO emp-1.salary WHERE emp-2.name = "Joe"
    DO 
	UPDATE emp-3 SET ...  WHERE ...
    
.sp
.fi
Each rule can have the optional tag INSTEAD.
Without
this tag, \fIaction\fR will be
performed in addition to the user command when the
\fIevent\fR in the
\fIcondition\fR part of the rule
occurs. Alternately, the
\fIaction\fR part will be done
instead of the user command. In this later case, the
\fIaction\fR can be the keyword
NOTHING.
.PP
It is very important to note to avoid circular rules.
For example, though each
of the following two rule definitions are accepted by
Postgres, the
select command will cause Postgres to 
report an error because the query cycled too many times:
.SS "EXAMPLE OF A CIRCULAR REWRITE RULE COMBINATION."
.sp
.nf
CREATE RULE bad_rule_combination_1 AS
    ON SELECT TO emp
    DO INSTEAD 
	SELECT TO toyemp;
     
.sp
.fi
.sp
.nf
CREATE RULE bad_rule_combination_2 AS
    ON SELECT TO toyemp
    DO INSTEAD 
	SELECT TO emp;
     
.sp
.fi
.PP
This attempt to select from EMP will cause
Postgres to issue an error
because the queries cycled too many times.
.sp
.nf
SELECT * FROM emp;
      
.sp
.fi
.PP
You must have rule definition access to a class in order
to define a rule on it. Use \fBGRANT\fR
and \fBREVOKE\fR to change permissions.
.PP
The object in a SQL rule cannot be an array reference and
cannot have parameters.
.PP
Aside from the "oid" field, system attributes cannot be
referenced anywhere in a rule. Among other things, this
means that functions of instances (e.g., foo(emp) where
emp is a class) cannot be called anywhere in a rule.
.PP
The rule system stores the rule text and query plans as
text attributes. This implies that creation of rules may
fail if the rule plus its various internal representations
exceed some value that is on the order of one page (8KB).
.SH "USAGE"
.PP
Make Sam get the same salary adjustment as Joe:
.sp
.nf
CREATE RULE example_1 AS
    ON UPDATE emp.salary WHERE old.name = "Joe"
    DO 
	UPDATE emp 
	SET salary = new.salary
	WHERE emp.name = "Sam";
   
.sp
.fi
At the time Joe receives a salary adjustment, the event
will become true and Joe's old instance and proposed
new instance are available to the execution routines.
Hence, his new salary is substituted into the action part
of the rule which is subsequently executed. This propagates
Joe's salary on to Sam.
.PP
Make Bill get Joe's salary when it is accessed:
.sp
.nf
CREATE RULE example_2 AS
    ON SELECT TO EMP.salary
    WHERE old.name = "Bill"
    DO INSTEAD
	SELECT emp.salary
	FROM emp
	WHERE emp.name = "Joe";
   
.sp
.fi
.PP
Deny Joe access to the salary of employees in the shoe
department (\fBcurrent_user\fR returns the name of
the current user):
.sp
.nf
  
CREATE RULE example_3 AS
    ON 
	SELECT TO emp.salary
   	WHERE old.dept = "shoe" AND current_user = "Joe"
    DO INSTEAD NOTHING;
   
.sp
.fi
.PP
Create a view of the employees working in the toy department.
.sp
.nf
CREATE toyemp(name = char16, salary = int4);

CREATE RULE example_4 AS
    ON SELECT TO toyemp
    DO INSTEAD
    	SELECT emp.name, emp.salary
	FROM emp
        WHERE emp.dept = "toy";
   
.sp
.fi
.PP
All new employees must make 5,000 or less
.sp
.nf
CREATE RULE example_5 AS
    ON INERT TO emp WHERE new.salary > 5000
    DO 
	UPDATE NEWSET SET salary = 5000;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
\fBCREATE RULE\fR statement is a Postgres
language extension.
There is no \fBCREATE RULE\fR statement in SQL92.
