.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CREATE AGGREGATE" "l" "2002-01-30" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE AGGREGATE \- define a new aggregate function
.SH SYNOPSIS
.sp
.nf
CREATE AGGREGATE \fIname\fR ( BASETYPE = \fIinput_data_type\fR,
    SFUNC = \fIsfunc\fR, STYPE = \fIstate_type\fR
    [ , FINALFUNC = \fIffunc\fR ]
    [ , INITCOND = \fIinitial_condition\fR ] )
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of an aggregate function to create.
.TP
\fB\fIinput_data_type\fB\fR
The input data type on which this aggregate function operates.
This can be specified as ANY for an aggregate that does not
examine its input values
(an example is \fBcount(*)\fR).
.TP
\fB\fIsfunc\fB\fR
The name of the state transition function
to be called for each input data value.
This is normally a function of two arguments, the first being of
type \fIstate_type\fR
and the second of
type \fIinput_data_type\fR.
Alternatively, for an aggregate that does not examine its input
values, the function takes just one argument of
type \fIstate_type\fR.
In either case the function must return a value of
type \fIstate_type\fR.
This function takes the current state value and the current
input data item, and returns the next state value.
.TP
\fB\fIstate_type\fB\fR
The data type for the aggregate's state value.
.TP
\fB\fIffunc\fB\fR
The name of the final function called to compute the aggregate's
result after all input data has been traversed. The function
must take a single argument of type
\fIstate_type\fR.
The output data type of the aggregate is defined as the return
type of this function.
If \fIffunc\fR
is not specified, then the ending state value is used as the
aggregate's result, and the output type is
\fIstate_type\fR.
.TP
\fB\fIinitial_condition\fB\fR
The initial setting for the state value. This must be a literal
constant in the form accepted for the data type
\fIstate_type\fR.
If not specified, the state value starts out NULL.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE\fR
Message returned if the command completes successfully.
.PP
.SH "DESCRIPTION"
.PP
\fBCREATE AGGREGATE\fR 
allows a user or programmer to extend PostgreSQL
functionality by defining new aggregate functions. Some aggregate functions
for base types such as \fBmin(integer)\fR
and \fBavg(double precision)\fR are already provided in the base
distribution. If one defines new types or needs an aggregate function not
already provided, then \fBCREATE AGGREGATE\fR
can be used to provide the desired features.
.PP
An aggregate function is identified by its name and input data type.
Two aggregates can have the same name if they operate on different
input types. To avoid confusion, do not make an ordinary function
of the same name and input data type as an aggregate.
.PP
An aggregate function is made from one or two ordinary
functions:
a state transition function
\fIsfunc\fR,
and an optional final calculation function
\fIffunc\fR.
These are used as follows:
.sp
.nf
\fIsfunc\fR( internal-state, next-data-item ) ---> next-internal-state
\fIffunc\fR( internal-state ) ---> aggregate-value
   
.sp
.fi
.PP
PostgreSQL creates a temporary variable
of data type \fIstype\fR
to hold the current internal state of the aggregate. At each input
data item,
the state transition function is invoked to calculate a new
internal state value. After all the data has been processed,
the final function is invoked once to calculate the aggregate's output
value. If there is no final function then the ending state value
is returned as-is.
.PP
An aggregate function may provide an initial condition,
that is, an initial value for the internal state value.
This is specified and stored in the database as a field of type
\fBtext\fR, but it must be a valid external representation
of a constant of the state value data type. If it is not supplied
then the state value starts out NULL.
.PP
If the state transition function is declared ``strict'',
then it cannot be called with NULL inputs. With such a transition
function, aggregate execution behaves as follows. NULL input values
are ignored (the function is not called and the previous state value
is retained). If the initial state value is NULL, then the first
non-NULL input value replaces the state value, and the transition
function is invoked beginning with the second non-NULL input value.
This is handy for implementing aggregates like \fBmax\fR.
Note that this behavior is only available when
\fIstate_type\fR
is the same as
\fIinput_data_type\fR.
When these types are different, you must supply a non-NULL initial
condition or use a non-strict transition function.
.PP
If the state transition function is not strict, then it will be called
unconditionally at each input value, and must deal with NULL inputs
and NULL transition values for itself. This allows the aggregate
author to have full control over the aggregate's handling of NULLs.
.PP
If the final function is declared ``strict'', then it will not
be called when the ending state value is NULL; instead a NULL result
will be output automatically. (Of course this is just the normal
behavior of strict functions.) In any case the final function has
the option of returning NULL. For example, the final function for
\fBavg\fR returns NULL when it sees there were zero
input tuples.
.SS "NOTES"
.PP
Use \fBDROP AGGREGATE\fR
to drop aggregate functions.
.PP
The parameters of \fBCREATE AGGREGATE\fR can be written
in any order, not just the order illustrated above.
.SH "USAGE"
.PP
Refer to the chapter on aggregate functions
in the \fIPostgreSQL Programmer's Guide\fR for
complete examples of usage.
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
\fBCREATE AGGREGATE\fR 
is a PostgreSQL language extension.
There is no \fBCREATE AGGREGATE\fR in SQL92.
