.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "DROP TABLE" "l" "2002-11-22" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP TABLE \- remove a table
.SH SYNOPSIS
.sp
.nf
DROP TABLE \fIname\fR [, ...] [ CASCADE | RESTRICT ]

  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing table to drop.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the table
(such as views).
.TP
\fBRESTRICT\fR
Refuse to drop the table if there are any dependent objects.
This is the default.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP TABLE\fR
The message returned if the command completes successfully.
.TP
\fBERROR: table "\fIname\fB" does not exist\fR
If the specified table does not exist in the database.
.PP
.SH "DESCRIPTION"
.PP
\fBDROP TABLE\fR removes tables from the database.
Only its owner may destroy a table. A table may be emptied of rows, but not
destroyed, by using \fBDELETE\fR.
.PP
\fBDROP TABLE\fR always removes any indexes, rules,
triggers, and constraints that exist for the target table. However,
to drop a table that is referenced by a foreign-key constraint of another
table, CASCADE must be specified. (CASCADE will remove the foreign-key
constraint, not the other table itself.)
.SS "NOTES"
.PP
Refer to \fBCREATE TABLE\fR and
\fBALTER TABLE\fR for information on
how to create or modify tables.
.SH "USAGE"
.PP
To destroy two tables, films and 
distributors:
.sp
.nf
DROP TABLE films, distributors;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
