.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "FETCH" "l" "2002-11-22" "SQL - Language Statements" "SQL Commands"
.SH NAME
FETCH \- retrieve rows from a table using a cursor
.SH SYNOPSIS
.sp
.nf
FETCH [ \fIdirection\fR ] [ \fIcount\fR ] { IN | FROM } \fIcursor\fR
FETCH [ FORWARD | BACKWARD | RELATIVE ] [ \fI#\fR | ALL | NEXT | PRIOR ]
    { IN | FROM } \fIcursor\fR
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIdirection\fB\fR
\fIselector\fR
defines the fetch direction. It can be one of
the following:
.RS
.TP
\fBFORWARD\fR
fetch next row(s). This is the default
if \fIselector\fR is omitted.
.TP
\fBBACKWARD\fR
fetch previous row(s).
.TP
\fBRELATIVE\fR
Noise word for SQL92 compatibility.
.RE
.PP
.TP
\fB\fIcount\fB\fR
\fIcount\fR
determines how many rows to fetch. It can be one of the following:
.RS
.TP
\fB\fI#\fB\fR
A signed integer that specifies how many rows to fetch.
Note that a negative integer is equivalent to changing the sense of
FORWARD and BACKWARD.
.TP
\fBALL\fR
Retrieve all remaining rows.
.TP
\fBNEXT\fR
Equivalent to specifying a count of \fB1\fR.
.TP
\fBPRIOR\fR
Equivalent to specifying a count of \fB-1\fR.
.RE
.PP
.TP
\fB\fIcursor\fB\fR
An open cursor's name.
.PP
.SS "OUTPUTS"
.PP
\fBFETCH\fR returns the results of the query defined by the specified cursor.
The following messages will be returned if the query fails:
.TP
\fBWARNING: PerformPortalFetch: portal "\fIcursor\fB" not found\fR
If \fIcursor\fR
is not previously declared.
The cursor must be declared within a transaction block.
.TP
\fBWARNING: FETCH/ABSOLUTE not supported, using RELATIVE\fR
PostgreSQL does not support absolute
positioning of cursors.
.TP
\fBERROR: FETCH/RELATIVE at current position is not supported\fR
SQL92 allows one to repetitively retrieve the cursor
at its ``current position'' using the syntax
.sp
.nf
FETCH RELATIVE 0 FROM \fIcursor\fR.
	
.sp
.fi

PostgreSQL does not currently support
this notion; in fact the value zero is reserved to indicate that
all rows should be retrieved and is equivalent to specifying the ALL keyword.
If the RELATIVE keyword has been used, PostgreSQL 
assumes that the user intended SQL92 behavior
and returns this error message.
.PP
.SH "DESCRIPTION"
.PP
\fBFETCH\fR allows a user to retrieve rows using a cursor.
The number of rows retrieved is specified by
\fI#\fR.
If the number of rows remaining in the cursor is less
than \fI#\fR,
then only those available are fetched.
Substituting the keyword ALL in place of a number will
cause all remaining rows in the cursor to be retrieved.
Instances may be fetched in both FORWARD and BACKWARD
directions. The default direction is FORWARD.
.sp
.RS
.B "Tip:"
Negative numbers are allowed to be specified for the
row count. A negative number is equivalent to reversing
the sense of the FORWARD and BACKWARD keywords. For example,
\fBFORWARD -1\fR is the same as \fBBACKWARD 1\fR.
.RE
.sp
.SS "NOTES"
.PP
Note that the FORWARD and BACKWARD keywords are
PostgreSQL extensions.
The SQL92 syntax is also supported, specified
in the second form of the command. See below for details
on compatibility issues.
.PP
Updating data in a cursor is not supported by 
PostgreSQL,
because mapping cursor updates back to base tables is
not generally possible, as is also the case with VIEW updates.
Consequently,
users must issue explicit UPDATE commands to replace data.
.PP
Cursors may only be used inside of transactions because
the data that they store spans multiple user queries.
.PP
Use
MOVE [\fBmove\fR(l)]
to change cursor position.
DECLARE [\fBdeclare\fR(l)]
will define a cursor.
Refer to
BEGIN [\fBbegin\fR(l)],
COMMIT [\fBcommit\fR(l)],
and
ROLLBACK [\fBrollback\fR(l)]
for further information about transactions.
.SH "USAGE"
.PP
The following examples traverses a table using a cursor.
.sp
.nf
-- Set up and use a cursor:

BEGIN WORK;
DECLARE liahona CURSOR FOR SELECT * FROM films;

-- Fetch first 5 rows in the cursor liahona:
FETCH FORWARD 5 IN liahona;

 code  |          title          | did | date_prod  |  kind    | len
-------+-------------------------+-----+------------+----------+-------
 BL101 | The Third Man           | 101 | 1949-12-23 | Drama    | 01:44
 BL102 | The African Queen       | 101 | 1951-08-11 | Romantic | 01:43
 JL201 | Une Femme est une Femme | 102 | 1961-03-12 | Romantic | 01:25
 P_301 | Vertigo                 | 103 | 1958-11-14 | Action   | 02:08
 P_302 | Becket                  | 103 | 1964-02-03 | Drama    | 02:28

-- Fetch previous row:
FETCH BACKWARD 1 IN liahona;

 code  | title   | did | date_prod  | kind   | len
-------+---------+-----+------------+--------+-------
 P_301 | Vertigo | 103 | 1958-11-14 | Action | 02:08

-- close the cursor and commit work:

CLOSE liahona;
COMMIT WORK;
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
.sp
.RS
.B "Note:"
The non-embedded use of cursors is a PostgreSQL
extension. The syntax and usage of cursors is being compared
against the embedded form of cursors defined in SQL92.
.RE
.sp
.PP
SQL92 allows absolute positioning of the cursor for
FETCH, and allows placing the results into explicit variables:
.sp
.nf
FETCH ABSOLUTE \fI#\fR
    FROM \fIcursor\fR
    INTO :\fIvariable\fR [, ...]
    
.sp
.fi
.TP
\fBABSOLUTE\fR
The cursor should be positioned to the specified absolute
row number. All row numbers in PostgreSQL
are relative numbers so this capability is not supported.
.TP
\fB:\fIvariable\fB\fR
Target host variable(s).
.PP
