.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "REINDEX" "l" "2002-11-22" "SQL - Language Statements" "SQL Commands"
.SH NAME
REINDEX \- rebuild corrupted indexes
.SH SYNOPSIS
.sp
.nf
REINDEX { TABLE | DATABASE | INDEX } \fIname\fR [ FORCE ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fBTABLE\fR
Recreate all indexes of a specified table.
.TP
\fBDATABASE\fR
Recreate all system indexes of a specified database.
(User-table indexes are not included.)
.TP
\fBINDEX\fR
Recreate a specified index.
.TP
\fB\fIname\fB\fR
The name of the specific table/database/index to be reindexed.
Table and index names may be schema-qualified.
.TP
\fBFORCE\fR
Force rebuild of system indexes. Without this keyword
\fBREINDEX\fR skips system indexes that are not marked invalid.
FORCE is irrelevant for \fBREINDEX INDEX\fR, or when reindexing
user indexes.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBREINDEX\fR
Message returned if the table is successfully reindexed.
.PP
.SH "DESCRIPTION"
.PP
\fBREINDEX\fR is used to rebuild corrupted indexes.
Although in theory this should never be necessary, in practice
indexes may become corrupted due to software bugs or hardware
failures. \fBREINDEX\fR provides a recovery method.
.PP
\fBREINDEX\fR also removes certain dead index pages that
can't be reclaimed any other way. See the "Routine Reindexing"
section in the manual for more information.
.PP
If you suspect corruption of an index on a user table, you can
simply rebuild that index, or all indexes on the table, using
\fBREINDEX INDEX\fR or \fBREINDEX TABLE\fR.
.sp
.RS
.B "Note:"
Another approach to dealing with a corrupted user-table index is
just to drop and recreate it. This may in fact be preferable if
you would like to maintain some semblance of normal operation on
the table meanwhile. \fBREINDEX\fR acquires exclusive lock
on the table, while \fBCREATE INDEX\fR only locks out writes
not reads of the table.
.RE
.sp
.PP
Things are more difficult if you need to recover from corruption of an
index on a system table. In this case it's important for the backend
doing the recovery to not have used any of the suspect indexes itself.
(Indeed, in this sort of scenario you may find that backends are
crashing immediately at start-up, due to reliance on the corrupted
indexes.) To recover safely, the postmaster must be shut down and a
stand-alone PostgreSQL backend must be
started instead, giving it
the command-line options -O and -P (these options allow system table
modifications and prevent use of system indexes, respectively). Then
issue \fBREINDEX INDEX\fR, \fBREINDEX TABLE\fR, or
\fBREINDEX DATABASE\fR depending on how much you want to reconstruct.
If in doubt, use \fBREINDEX DATABASE FORCE\fR to force reconstruction
of all system indexes in the database. Then quit the standalone backend
and restart the postmaster.
.PP
Since this is likely the only situation when most people will ever use
a standalone backend, some usage notes might be in order:
.TP 0.2i
\(bu
Start the backend with a command like
.sp
.nf
\fBpostgres -D $PGDATA -O -P my_database\fR
.sp
.fi
Provide the correct path to the database area with \fB-D\fR, or
make sure that the environment variable \fBPGDATA\fR is set.
Also specify the name of the particular database you want to work in.
.TP 0.2i
\(bu
You can issue any SQL command, not only \fBREINDEX\fR.
.TP 0.2i
\(bu
Be aware that the standalone backend treats newline as the command
entry terminator; there is no intelligence about semicolons,
as there is in \fBpsql\fR. To continue a command
across multiple lines, you must type backslash just before each
newline except the last one.
Also, you won't have any of the conveniences of command-line editing
(no command history, for example).
.TP 0.2i
\(bu
To quit the backend, type EOF (\fBControl\fR+\fBD\fR, usually).
.PP
See the \fBpostgres\fR(1) reference page for more information.
.SH "USAGE"
.PP
Recreate the indexes on the table mytable:
.sp
.nf
     REINDEX TABLE mytable;
   
.sp
.fi
.PP
Rebuild a single index:
.sp
.nf
    REINDEX INDEX my_index;
   
.sp
.fi
.PP
Rebuild all system indexes (this will only work in a standalone backend):
.sp
.nf
    REINDEX DATABASE my_database FORCE;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBREINDEX\fR in SQL92.
