.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CREATE SEQUENCE" "l" "2003-11-02" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE SEQUENCE \- define a new sequence generator

.SH SYNOPSIS
.sp
.nf
CREATE [ TEMPORARY | TEMP ] SEQUENCE \fIname\fR [ INCREMENT [ BY ] \fIincrement\fR ]
    [ MINVALUE \fIminvalue\fR | NO MINVALUE ] [ MAXVALUE \fImaxvalue\fR | NO MAXVALUE ]
    [ START [ WITH ] \fIstart\fR ] [ CACHE \fIcache\fR ] [ [ NO ] CYCLE ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE SEQUENCE\fR creates a new sequence number
generator. This involves creating and initializing a new special
single-row table with the name \fIname\fR. The generator will be
owned by the user issuing the command.
.PP
If a schema name is given then the sequence is created in the
specified schema. Otherwise it is created in the current schema.
Temporary sequences exist in a special schema, so a schema name may not be
given when creating a temporary sequence.
The sequence name must be distinct from the name of any other sequence,
table, index, or view in the same schema.
.PP
After a sequence is created, you use the functions
\fBnextval\fR,
\fBcurrval\fR, and
\fBsetval\fR
to operate on the sequence. These functions are documented in
the section called ``Sequence-Manipulation Functions'' in the documentation.
.PP
Although you cannot update a sequence directly, you can use a query like
.sp
.nf
SELECT * FROM \fIname\fR;
.sp
.fi
to examine the parameters and current state of a sequence. In particular,
the last_value field of the sequence shows the last value
allocated by any session. (Of course, this value may be obsolete
by the time it's printed, if other sessions are actively doing
\fBnextval\fR calls.)
.SH "PARAMETERS"
.TP
\fBTEMPORARY or TEMP\fR
If specified, the sequence object is created only for this
session, and is automatically dropped on session exit. Existing
permanent sequences with the same name are not visible (in this
session) while the temporary sequence exists, unless they are
referenced with schema-qualified names.
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of the sequence to be created.
.TP
\fB\fIincrement\fB\fR
The optional clause INCREMENT BY \fIincrement\fR specified,
which value is added to the current sequence value to create a
new value. A positive value will make an ascending sequence, a
negative one a descending sequence. The default value is 1.
.TP
\fB\fIminvalue\fB\fR
.TP
\fBNO MINVALUE\fR
The optional clause MINVALUE \fIminvalue\fR determines
the minimum value a sequence can generate. If this clause is not
supplied or \fBNO MINVALUE\fR is specified, then
defaults will be used. The defaults are 1 and
-263-1 for ascending and descending sequences,
respectively.
.TP
\fB\fImaxvalue\fB\fR
.TP
\fBNO MAXVALUE\fR
The optional clause MAXVALUE \fImaxvalue\fR determines
the maximum value for the sequence. If this clause is not
supplied or \fBNO MAXVALUE\fR is specified, then
default values will be used. The defaults are
263-1 and -1 for ascending and descending
sequences, respectively.
.TP
\fB\fIstart\fB\fR
The optional clause START WITH \fIstart\fR  allows the
sequence to begin anywhere. The default starting value is
\fIminvalue\fR for
ascending sequences and \fImaxvalue\fR for descending ones.
.TP
\fB\fIcache\fB\fR
The optional clause CACHE \fIcache\fR specifies how
many sequence numbers are to be preallocated and stored in
memory for faster access. The minimum value is 1 (only one value
can be generated at a time, i.e., no cache), and this is also the
default.
.TP
\fBCYCLE\fR
.TP
\fBNO CYCLE\fR
The CYCLE option allows the sequence to wrap
around when the \fImaxvalue\fR or \fIminvalue\fR has been reached by an
ascending or descending sequence respectively. If the limit is
reached, the next number generated will be the \fIminvalue\fR or \fImaxvalue\fR, respectively.

If NO CYCLE is specified, any calls to
\fBnextval\fR after the sequence has reached its
maximum value will return an error. If neither
CYCLE or NO CYCLE are
specified, NO CYCLE is the default.
.SH "NOTES"
.PP
Use \fBDROP SEQUENCE\fR to remove a sequence.
.PP
Sequences are based on \fBbigint\fR arithmetic, so the range
cannot exceed the range of an eight-byte integer
(-9223372036854775808 to 9223372036854775807). On some older
platforms, there may be no compiler support for eight-byte
integers, in which case sequences use regular \fBinteger\fR
arithmetic (range -2147483648 to +2147483647).
.PP
Unexpected results may be obtained if a \fIcache\fR setting greater than one is
used for a sequence object that will be used concurrently by
multiple sessions. Each session will allocate and cache successive
sequence values during one access to the sequence object and
increase the sequence object's last_value accordingly.
Then, the next \fIcache\fR-1
uses of \fBnextval\fR within that session simply return the
preallocated values without touching the sequence object. So, any
numbers allocated but not used within a session will be lost when
that session ends, resulting in ``holes'' in the
sequence.
.PP
Furthermore, although multiple sessions are guaranteed to allocate
distinct sequence values, the values may be generated out of
sequence when all the sessions are considered. For example, with
a \fIcache\fR setting of 10,
session A might reserve values 1..10 and return
\fBnextval\fR=1, then session B might reserve values
11..20 and return \fBnextval\fR=11 before session A
has generated nextval=2. Thus, with a
\fIcache\fR setting of one
it is safe to assume that \fBnextval\fR values are generated
sequentially; with a \fIcache\fR setting greater than one you
should only assume that the \fBnextval\fR values are all
distinct, not that they are generated purely sequentially. Also,
last_value will reflect the latest value reserved by
any session, whether or not it has yet been returned by
\fBnextval\fR.
.PP
Another consideration is that a \fBsetval\fR executed on
such a sequence will not be noticed by other sessions until they
have used up any preallocated values they have cached.
.SH "EXAMPLES"
.PP
Create an ascending sequence called serial, starting at 101:
.sp
.nf
CREATE SEQUENCE serial START 101;
.sp
.fi
.PP
Select the next number from this sequence:
.sp
.nf
SELECT nextval('serial');
    
 nextval
---------
     114
.sp
.fi
.PP
Use this sequence in an \fBINSERT\fR command:
.sp
.nf
INSERT INTO distributors VALUES (nextval('serial'), 'nothing');
.sp
.fi
.PP
Update the sequence value after a \fBCOPY FROM\fR:
.sp
.nf
BEGIN;
COPY distributors FROM 'input_file';
SELECT setval('serial', max(id)) FROM distributors;
END;
.sp
.fi
.SH "COMPATIBILITY"
.PP
\fBCREATE SEQUENCE\fR is a
PostgreSQL language extension. There is
no \fBCREATE SEQUENCE\fR statement in the SQL
standard.
