.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "PG_SELECT" "" "2008-06-08" "" "PostgreSQL 7.4.21 Documentation"
.SH NAME
pg_select \- loop over the result of a query

.SH SYNOPSIS
.sp
.nf
pg_select \fIconn\fR \fIcommandString\fR \fIarrayVar\fR \fIprocedure\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBpg_select\fR submits a query
(\fBSELECT\fR statement) to the
PostgreSQL server and executes a given
chunk of code for each row in the result. The
\fIcommandString\fR must be a
\fBSELECT\fR statement; anything else returns an
error. The \fIarrayVar\fR variable is an array
name used in the loop. For each row,
\fIarrayVar\fR is filled in with the row values,
using the column names as the array indices. Then the
\fIprocedure\fR is executed.
.PP
In addition to the column values, the following special entries are
made in the array:
.TP
\fB\&.headers\fR
A list of the column names returned by the query.
.TP
\fB\&.numcols\fR
The number of columns returned by the query.
.TP
\fB\&.tupno\fR
The current row number, starting at zero and incrementing for
each iteration of the loop body.
.PP
.SH "ARGUMENTS"
.TP
\fB\fIconn\fB\fR
The handle of the connection on which to execute the query.
.TP
\fB\fIcommandString\fB\fR
The SQL query to execute.
.TP
\fB\fIarrayVar\fB\fR
An array variable for returned rows.
.TP
\fB\fIprocedure\fB\fR
The procedure to run for each returned row.
.SH "RETURN VALUE"
.PP
None
.SH "EXAMPLES"
.PP
This examples assumes that the table \fBtable1\fR has
columns \fBcontrol\fR and \fBname\fR (and
perhaps others):
.sp
.nf
pg_select $pgconn "SELECT * FROM table1;" array {
    puts [format "%5d %s" $array(control) $array(name)]
}
.sp
.fi
