.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "SPI_cursor_open" "" "2010-10-01" "" "PostgreSQL 7.4.30 Documentation"
.SH NAME
SPI_cursor_open \- set up a cursor using a plan created with SPI_prepare

.SH SYNOPSIS
.sp
.nf
Portal SPI_cursor_open(const char * \fIname\fR, void * \fIplan\fR, Datum * \fIvalues\fR, const char * \fInulls\fR)
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBSPI_cursor_open\fR sets up a cursor (internally,
a portal) that will execute a plan prepared by
\fBSPI_prepare\fR.
.PP
Using a cursor instead of executing the plan directly has two
benefits. First, the result rows can be retrieved a few at a time,
avoiding memory overrun for queries that return many rows. Second,
a portal can outlive the current procedure (it can, in fact, live
to the end of the current transaction). Returning the portal name
to the procedure's caller provides a way of returning a row set as
result.
.SH "ARGUMENTS"
.TP
\fBconst char * \fIname\fB\fR
name for portal, or \fBNULL\fR to let the system
select a name
.TP
\fBvoid * \fIplan\fB\fR
execution plan (returned by \fBSPI_prepare\fR)
.TP
\fBDatum * \fIvalues\fB\fR
actual parameter values
.TP
\fBconst char *\fInulls\fB\fR
An array describing which parameters are null values.
n indicates a null value (entry in
\fIvalues\fR will be ignored); a space indicates a
nonnull value (entry in \fIvalues\fR is valid). If
\fInulls\fR is \fBNULL\fR then
\fBSPI_cursor_open\fR assumes that no parameters
are null.
.SH "RETURN VALUE"
.PP
pointer to portal containing the cursor, or \fBNULL\fR
on error
