.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "SPI_saveplan" "" "2009-03-13" "" "PostgreSQL 8.0.21 Documentation"
.SH NAME
SPI_saveplan \- save a plan

.SH SYNOPSIS
.sp
.nf
void * SPI_saveplan(void * \fIplan\fR)
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBSPI_saveplan\fR saves a passed plan (prepared by
\fBSPI_prepare\fR) in memory protected from freeing
by \fBSPI_finish\fR and by the transaction manager
and returns a pointer to the saved plan. This gives you the
ability to reuse prepared plans in the subsequent invocations of
your procedure in the current session. You may save the pointer
returned in a local variable. Always check if this pointer is
\fBNULL\fR or not either when preparing a plan or using
an already prepared plan in \fBSPI_execute_plan\fR.
.SH "ARGUMENTS"
.TP
\fBvoid * \fIplan\fB\fR
the plan to be saved
.SH "RETURN VALUE"
.PP
Pointer to the saved plan; \fBNULL\fR if unsuccessful.
On error, SPI_result is set thus:
.TP
\fBSPI_ERROR_ARGUMENT\fR
if \fIplan\fR is \fBNULL\fR
.TP
\fBSPI_ERROR_UNCONNECTED\fR
if called from an unconnected procedure
.PP
.SH "NOTES"
.PP
If one of the objects (a table, function, etc.) referenced by the
prepared plan is dropped during the session then the results of
\fBSPI_execute_plan\fR for this plan will be unpredictable.
