.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE TRIGGER" "" "2009-09-04" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE TRIGGER \- define a new trigger

.SH SYNOPSIS
.sp
.nf
CREATE TRIGGER \fIname\fR { BEFORE | AFTER } { \fIevent\fR [ OR ... ] }
    ON \fItable\fR [ FOR [ EACH ] { ROW | STATEMENT } ]
    EXECUTE PROCEDURE \fIfuncname\fR ( \fIarguments\fR )
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE TRIGGER\fR creates a new trigger. The
trigger will be associated with the specified table and will
execute the specified function \fIfuncname\fR when certain events occur.
.PP
The trigger can be specified to fire either before the
operation is attempted on a row (before constraints are checked and
the \fBINSERT\fR, \fBUPDATE\fR, or
\fBDELETE\fR is attempted) or after the operation has
completed (after constraints are checked and the
\fBINSERT\fR, \fBUPDATE\fR, or
\fBDELETE\fR has completed). If the trigger fires
before the event, the trigger may skip the operation for the
current row, or change the row being inserted (for
\fBINSERT\fR and \fBUPDATE\fR operations
only). If the trigger fires after the event, all changes, including
the last insertion, update, or deletion, are ``visible''
to the trigger.
.PP
A trigger that is marked FOR EACH ROW is called
once for every row that the operation modifies. For example, a
\fBDELETE\fR that affects 10 rows will cause any
ON DELETE triggers on the target relation to be
called 10 separate times, once for each deleted row. In contrast, a
trigger that is marked FOR EACH STATEMENT only
executes once for any given operation, regardless of how many rows
it modifies (in particular, an operation that modifies zero rows
will still result in the execution of any applicable FOR
EACH STATEMENT triggers).
.PP
If multiple triggers of the same kind are defined for the same event,
they will be fired in alphabetical order by name.
.PP
\fBSELECT\fR does not modify any rows so you can not
create \fBSELECT\fR triggers. Rules and views are more
appropriate in such cases.
.PP
Refer to the documentation for more information about triggers.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name to give the new trigger. This must be distinct from
the name of any other trigger for the same table.
.TP
\fBBEFORE\fR
.TP
\fBAFTER\fR
Determines whether the function is called before or after the
event.
.TP
\fB\fIevent\fB\fR
One of \fBINSERT\fR, \fBUPDATE\fR, or
\fBDELETE\fR; this specifies the event that will
fire the trigger. Multiple events can be specified using
OR.
.TP
\fB\fItable\fB\fR
The name (optionally schema-qualified) of the table the trigger
is for.
.TP
\fBFOR EACH ROW\fR
.TP
\fBFOR EACH STATEMENT\fR
This specifies whether the trigger procedure should be fired
once for every row affected by the trigger event, or just once
per SQL statement. If neither is specified, FOR EACH
STATEMENT is the default.
.TP
\fB\fIfuncname\fB\fR
A user-supplied function that is declared as taking no arguments
and returning type trigger, which is executed when
the trigger fires.
.TP
\fB\fIarguments\fB\fR
An optional comma-separated list of arguments to be provided to
the function when the trigger is executed. The arguments are
literal string constants. Simple names and numeric constants
may be written here, too, but they will all be converted to
strings. Please check the description of the implementation
language of the trigger function about how the trigger arguments
are accessible within the function; it may be different from
normal function arguments.
.SH "NOTES"
.PP
To create a trigger on a table, the user must have the
TRIGGER privilege on the table.
.PP
In PostgreSQL versions before 7.3, it was
necessary to declare trigger functions as returning the placeholder
type \fBopaque\fR, rather than \fBtrigger\fR. To support loading
of old dump files, \fBCREATE TRIGGER\fR will accept a function
declared as returning \fBopaque\fR, but it will issue a notice and
change the function's declared return type to \fBtrigger\fR.
.PP
Use DROP TRIGGER [\fBdrop_trigger\fR(l)] to remove a trigger.
.SH "EXAMPLES"
.PP
the documentation contains a complete example.
.SH "COMPATIBILITY"
.PP
The \fBCREATE TRIGGER\fR statement in
PostgreSQL implements a subset of the
SQL standard. The following functionality is currently missing:
.TP 0.2i
\(bu
SQL allows triggers to fire on updates to specific columns
(e.g., AFTER UPDATE OF col1, col2).
.TP 0.2i
\(bu
SQL allows you to define aliases for the ``old''
and ``new'' rows or tables for use in the definition
of the triggered action (e.g., CREATE TRIGGER ... ON
tablename REFERENCING OLD ROW AS somename NEW ROW AS othername
\&...). Since PostgreSQL
allows trigger procedures to be written in any number of
user-defined languages, access to the data is handled in a
language-specific way.
.TP 0.2i
\(bu
PostgreSQL only allows the execution
of a user-defined function for the triggered action. The standard
allows the execution of a number of other SQL commands, such as
\fBCREATE TABLE\fR as the triggered action. This
limitation is not hard to work around by creating a user-defined
function that executes the desired commands.
.PP
.PP
SQL specifies that multiple triggers should be fired in
time-of-creation order. PostgreSQL uses
name order, which was judged to be more convenient.
.PP
SQL specifies that BEFORE DELETE triggers on cascaded
deletes fire \fBafter\fR the cascaded DELETE completes.
The PostgreSQL behavior is for BEFORE
DELETE to always fire before the delete action, even a cascading
one. This is considered more consistent. There is also unpredictable
behavior when BEFORE triggers modify rows that are later
to be modified by referential actions. This can lead to contraint violations
or stored data that does not honor the referential constraint.
.PP
The ability to specify multiple actions for a single trigger using
OR is a PostgreSQL extension of
the SQL standard.
.SH "SEE ALSO"
CREATE FUNCTION [\fBcreate_function\fR(l)], ALTER TRIGGER [\fBalter_trigger\fR(l)], DROP TRIGGER [\fBdrop_trigger\fR(l)]
