.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER DOMAIN" "" "2010-03-12" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER DOMAIN \- change the definition of a domain

.SH SYNOPSIS
.sp
.nf
ALTER DOMAIN \fIname\fR
    { SET DEFAULT \fIexpression\fR | DROP DEFAULT }
ALTER DOMAIN \fIname\fR
    { SET | DROP } NOT NULL
ALTER DOMAIN \fIname\fR
    ADD \fIdomain_constraint\fR
ALTER DOMAIN \fIname\fR
    DROP CONSTRAINT \fIconstraint_name\fR [ RESTRICT | CASCADE ]
ALTER DOMAIN \fIname\fR
    OWNER TO \fInew_owner\fR 
ALTER DOMAIN \fIname\fR
    SET SCHEMA \fInew_schema\fR 
  
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER DOMAIN\fR changes the definition of an existing domain.
There are several sub-forms:
.TP
\fBSET/DROP DEFAULT\fR
These forms set or remove the default value for a domain. Note
that defaults only apply to subsequent \fBINSERT\fR
commands; they do not affect rows already in a table using the domain.
.TP
\fBSET/DROP NOT NULL\fR
These forms change whether a domain is marked to allow NULL
values or to reject NULL values. You may only SET NOT NULL
when the columns using the domain contain no null values.
.TP
\fBADD \fIdomain_constraint\fB\fR
This form adds a new constraint to a domain using the same syntax as
CREATE DOMAIN [\fBcreate_domain\fR(l)].
This will only succeed if all columns using the domain satisfy the
new constraint.
.TP
\fBDROP CONSTRAINT\fR
This form drops constraints on a domain.
.TP
\fBOWNER\fR
This form changes the owner of the domain to the specified user.
.TP
\fBSET SCHEMA\fR
This form changes the schema of the domain. Any constraints
associated with the domain are moved into the new schema as well.
.PP
You must own the domain to use \fBALTER DOMAIN\fR.
To change the schema of a domain, you must also have
CREATE privilege on the new schema.
To alter the owner, you must also be a direct or indirect member of the new
owning role, and that role must have CREATE privilege on
the domain's schema. (These restrictions enforce that altering the owner
doesn't do anything you couldn't do by dropping and recreating the domain.
However, a superuser can alter ownership of any domain anyway.)
.PP
.SH "PARAMETERS"
.PP
.TP
\fB\fIname\fB\fR
The name (possibly schema-qualified) of an existing domain to
alter.
.TP
\fB\fIdomain_constraint\fB\fR
New domain constraint for the domain.
.TP
\fB\fIconstraint_name\fB\fR
Name of an existing constraint to drop.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the constraint.
.TP
\fBRESTRICT\fR
Refuse to drop the constraint if there are any dependent
objects. This is the default behavior.
.TP
\fB\fInew_owner\fB\fR
The user name of the new owner of the domain.
.TP
\fB\fInew_schema\fB\fR
The new schema for the domain.
.PP
.SH "NOTES"
.PP
Currently, \fBALTER DOMAIN ADD CONSTRAINT\fR and
\fBALTER DOMAIN SET NOT NULL\fR will fail if the named domain or
any derived domain is used within a composite-type column of any
table in the database. They should eventually be improved to be
able to verify the new constraint for such nested columns.
.SH "EXAMPLES"
.PP
To add a NOT NULL constraint to a domain:
.sp
.nf
ALTER DOMAIN zipcode SET NOT NULL;
   
.sp
.fi
To remove a NOT NULL constraint from a domain:
.sp
.nf
ALTER DOMAIN zipcode DROP NOT NULL;
   
.sp
.fi
.PP
To add a check constraint to a domain:
.sp
.nf
ALTER DOMAIN zipcode ADD CONSTRAINT zipchk CHECK (char_length(VALUE) = 5);
   
.sp
.fi
.PP
To remove a check constraint from a domain:
.sp
.nf
ALTER DOMAIN zipcode DROP CONSTRAINT zipchk;
   
.sp
.fi
.PP
To move the domain into a different schema:
.sp
.nf
ALTER DOMAIN zipcode SET SCHEMA customers;
   
.sp
.fi
.SH "COMPATIBILITY"
.PP
\fBALTER DOMAIN\fR conforms to the SQL
standard,
except for the OWNER and SET SCHEMA variants,
which are PostgreSQL extensions.
.SH "SEE ALSO"
CREATE DOMAIN [\fBcreate_domain\fR(l)], DROP DOMAIN [\fBdrop_domain\fR(l)]
