.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE TYPE" "" "2007-02-01" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE TYPE \- define a new data type

.SH SYNOPSIS
.sp
.nf
CREATE TYPE \fIname\fR AS
    ( \fIattribute_name\fR \fIdata_type\fR [, ... ] )

CREATE TYPE \fIname\fR (
    INPUT = \fIinput_function\fR,
    OUTPUT = \fIoutput_function\fR
    [ , RECEIVE = \fIreceive_function\fR ]
    [ , SEND = \fIsend_function\fR ]
    [ , ANALYZE = \fIanalyze_function\fR ]
    [ , INTERNALLENGTH = { \fIinternallength\fR | VARIABLE } ]
    [ , PASSEDBYVALUE ]
    [ , ALIGNMENT = \fIalignment\fR ]
    [ , STORAGE = \fIstorage\fR ]
    [ , DEFAULT = \fIdefault\fR ]
    [ , ELEMENT = \fIelement\fR ]
    [ , DELIMITER = \fIdelimiter\fR ]
)

CREATE TYPE \fIname\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE TYPE\fR registers a new data type for use in
the current database. The user who defines a type becomes its
owner.
.PP
If a schema name is given then the type is created in the specified
schema. Otherwise it is created in the current schema. The type
name must be distinct from the name of any existing type or domain
in the same schema. (Because tables have associated data types,
the type name must also be distinct from the name of any existing
table in the same schema.)
.SS "COMPOSITE TYPES"
.PP
The first form of \fBCREATE TYPE\fR
creates a composite type.
The composite type is specified by a list of attribute names and data types.
This is essentially the same as the row type
of a table, but using \fBCREATE TYPE\fR avoids the need to
create an actual table when all that is wanted is to define a type.
A stand-alone composite type is useful as the argument or return type of a
function.
.SS "BASE TYPES"
.PP
The second form of \fBCREATE TYPE\fR creates a new base type
(scalar type). The parameters may appear in any order, not only that
illustrated above, and most are optional. You must register
two or more functions (using \fBCREATE FUNCTION\fR) before
defining the type. The support functions 
\fIinput_function\fR and
\fIoutput_function\fR
are required, while the functions
\fIreceive_function\fR,
\fIsend_function\fR and
\fIanalyze_function\fR
are optional. Generally these functions have to be coded in C
or another low-level language.
.PP
The \fIinput_function\fR
converts the type's external textual representation to the internal
representation used by the operators and functions defined for the type.
\fIoutput_function\fR
performs the reverse transformation. The input function may be
declared as taking one argument of type \fBcstring\fR,
or as taking three arguments of types
\fBcstring\fR, \fBoid\fR, \fBinteger\fR.
The first argument is the input text as a C string, the second
argument is the type's own OID (except for array types, which instead
receive their element type's OID),
and the third is the typmod of the destination column, if known
(-1 will be passed if not).
The input function must return a value of the data type itself.
Usually, an input function should be declared STRICT; if it is not,
it will be called with a NULL first parameter when reading a NULL
input value. The function must still return NULL in this case, unless
it raises an error.
(This case is mainly meant to support domain input functions, which
may need to reject NULL inputs.)
The output function must be
declared as taking one argument of the new data type.
The output function must return type \fBcstring\fR.
Output functions are not invoked for NULL values.
.PP
The optional \fIreceive_function\fR
converts the type's external binary representation to the internal
representation. If this function is not supplied, the type cannot
participate in binary input. The binary representation should be
chosen to be cheap to convert to internal form, while being reasonably
portable. (For example, the standard integer data types use network
byte order as the external binary representation, while the internal
representation is in the machine's native byte order.) The receive
function should perform adequate checking to ensure that the value is
valid.
The receive function may be declared as taking one argument of type
\fBinternal\fR, or as taking three arguments of types
\fBinternal\fR, \fBoid\fR, \fBinteger\fR.
The first argument is a pointer to a \fBStringInfo\fR buffer
holding the received byte string; the optional arguments are the
same as for the text input function.
The receive function must return a value of the data type itself.
Usually, a receive function should be declared STRICT; if it is not,
it will be called with a NULL first parameter when reading a NULL
input value. The function must still return NULL in this case, unless
it raises an error.
(This case is mainly meant to support domain receive functions, which
may need to reject NULL inputs.)
Similarly, the optional
\fIsend_function\fR converts
from the internal representation to the external binary representation.
If this function is not supplied, the type cannot participate in binary
output. The send function must be
declared as taking one argument of the new data type.
The send function must return type \fBbytea\fR.
Send functions are not invoked for NULL values.
.PP
You should at this point be wondering how the input and output functions
can be declared to have results or arguments of the new type, when they
have to be created before the new type can be created. The answer is that
the type should first be defined as a \fIshell type\fR, which is a
placeholder type that has no properties except a name and an owner. This
is done by issuing the command CREATE TYPE
\fIname\fR, with no additional parameters. Then the
I/O functions can be defined referencing the shell type. Finally,
\fBCREATE TYPE\fR with a full definition replaces the shell entry
with a complete, valid type definition, after which the new type can be
used normally.
.PP
The optional \fIanalyze_function\fR
performs type-specific statistics collection for columns of the data type.
By default, \fBANALYZE\fR will attempt to gather statistics using
the type's ``equals'' and ``less-than'' operators, if there
is a default b-tree operator class for the type. For non-scalar types
this behavior is likely to be unsuitable, so it can be overridden by
specifying a custom analysis function. The analysis function must be
declared to take a single argument of type \fBinternal\fR, and return
a \fBboolean\fR result. The detailed API for analysis functions appears
in \fIsrc/include/commands/vacuum.h\fR.
.PP
While the details of the new type's internal representation are only
known to the I/O functions and other functions you create to work with
the type, there are several properties of the internal representation
that must be declared to PostgreSQL.
Foremost of these is
\fIinternallength\fR.
Base data types can be fixed-length, in which case
\fIinternallength\fR is a
positive integer, or variable length, indicated by setting
\fIinternallength\fR
to VARIABLE. (Internally, this is represented
by setting typlen to -1.) The internal representation of all
variable-length types must start with a 4-byte integer giving the total
length of this value of the type.
.PP
The optional flag PASSEDBYVALUE indicates that
values of this data type are passed by value, rather than by
reference. You may not pass by value types whose internal
representation is larger than the size of the \fBDatum\fR type
(4 bytes on most machines, 8 bytes on a few).
.PP
The \fIalignment\fR parameter
specifies the storage alignment required for the data type. The
allowed values equate to alignment on 1, 2, 4, or 8 byte boundaries.
Note that variable-length types must have an alignment of at least
4, since they necessarily contain an \fBint4\fR as their first component.
.PP
The \fIstorage\fR parameter
allows selection of storage strategies for variable-length data
types. (Only plain is allowed for fixed-length
types.) plain specifies that data of the type
will always be stored in-line and not compressed.
extended specifies that the system will first
try to compress a long data value, and will move the value out of
the main table row if it's still too long.
external allows the value to be moved out of the
main table, but the system will not try to compress it.
main allows compression, but discourages moving
the value out of the main table. (Data items with this storage
strategy may still be moved out of the main table if there is no
other way to make a row fit, but they will be kept in the main
table preferentially over extended and
external items.)
.PP
A default value may be specified, in case a user wants columns of the
data type to default to something other than the null value.
Specify the default with the DEFAULT key word.
(Such a default may be overridden by an explicit DEFAULT
clause attached to a particular column.)
.PP
To indicate that a type is an array, specify the type of the array
elements using the ELEMENT key word. For example, to
define an array of 4-byte integers (\fBint4\fR), specify
ELEMENT = int4. More details about array types
appear below.
.PP
To indicate the delimiter to be used between values in the external
representation of arrays of this type, \fIdelimiter\fR can be
set to a specific character. The default delimiter is the comma
(,). Note that the delimiter is associated
with the array element type, not the array type itself.
.SS "ARRAY TYPES"
.PP
Whenever a user-defined base data type is created, 
PostgreSQL automatically creates an
associated array type, whose name consists of the base type's
name prepended with an underscore. The parser understands this
naming convention, and translates requests for columns of type
foo[] into requests for type _foo.
The implicitly-created array type is variable length and uses the
built-in input and output functions array_in and
array_out.
.PP
You might reasonably ask why there is an \fBELEMENT\fR
option, if the system makes the correct array type automatically.
The only case where it's useful to use \fBELEMENT\fR is when you are
making a fixed-length type that happens to be internally an array of a number of
identical things, and you want to allow these things to be accessed
directly by subscripting, in addition to whatever operations you plan
to provide for the type as a whole. For example, type \fBname\fR
allows its constituent \fBchar\fR elements to be accessed this way.
A 2-D \fBpoint\fR type could allow its two component numbers to be
accessed like point[0] and point[1].
Note that
this facility only works for fixed-length types whose internal form
is exactly a sequence of identical fixed-length fields. A subscriptable
variable-length type must have the generalized internal representation
used by array_in and array_out.
For historical reasons (i.e., this is clearly wrong but it's far too
late to change it), subscripting of fixed-length array types starts from
zero, rather than from one as for variable-length arrays.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of a type to be created.
.TP
\fB\fIattribute_name\fB\fR
The name of an attribute (column) for the composite type.
.TP
\fB\fIdata_type\fB\fR
The name of an existing data type to become a column of the
composite type.
.TP
\fB\fIinput_function\fB\fR
The name of a function that converts data from the type's
external textual form to its internal form.
.TP
\fB\fIoutput_function\fB\fR
The name of a function that converts data from the type's
internal form to its external textual form.
.TP
\fB\fIreceive_function\fB\fR
The name of a function that converts data from the type's
external binary form to its internal form.
.TP
\fB\fIsend_function\fB\fR
The name of a function that converts data from the type's
internal form to its external binary form.
.TP
\fB\fIanalyze_function\fB\fR
The name of a function that performs statistical analysis for the
data type.
.TP
\fB\fIinternallength\fB\fR
A numeric constant that specifies the length in bytes of the new
type's internal representation. The default assumption is that
it is variable-length.
.TP
\fB\fIalignment\fB\fR
The storage alignment requirement of the data type. If specified,
it must be char, int2,
int4, or double; the
default is int4.
.TP
\fB\fIstorage\fB\fR
The storage strategy for the data type. If specified, must be
plain, external,
extended, or main; the
default is plain.
.TP
\fB\fIdefault\fB\fR
The default value for the data type. If this is omitted, the
default is null.
.TP
\fB\fIelement\fB\fR
The type being created is an array; this specifies the type of
the array elements.
.TP
\fB\fIdelimiter\fB\fR
The delimiter character to be used between values in arrays made
of this type.
.SH "NOTES"
.PP
User-defined type names cannot begin with the underscore character
(_) and can only be 62 characters
long (or in general \fBNAMEDATALEN\fR - 2, rather than
the \fBNAMEDATALEN\fR - 1 characters allowed for other
names). Type names beginning with underscore are reserved for
internally-created array type names.
.PP
Because there are no restrictions on use of a data type once it's been
created, creating a base type is tantamount to granting public execute
permission on the functions mentioned in the type definition. (The creator
of the type is therefore required to own these functions.) This is usually
not an issue for the sorts of functions that are useful in a type
definition. But you might want to think twice before designing a type
in a way that would require ``secret'' information to be used
while converting it to or from external form.
.PP
Before PostgreSQL version 8.2, the syntax
CREATE TYPE \fIname\fR did not exist.
The way to create a new base type was to create its input function first.
In this approach, PostgreSQL will first see
the name of the new data type as the return type of the input function.
The shell type is implicitly created in this situation, and then it
can be referenced in the definitions of the remaining I/O functions.
This approach still works, but is deprecated and may be disallowed in
some future release. Also, to avoid accidentally cluttering
the catalogs with shell types as a result of simple typos in function
definitions, a shell type will only be made this way when the input
function is written in C.
.PP
In PostgreSQL versions before 7.3, it
was customary to avoid creating a shell type at all, by replacing the
functions' forward references to the type name with the placeholder
pseudotype \fBopaque\fR. The \fBcstring\fR arguments and
results also had to be declared as \fBopaque\fR before 7.3. To
support loading of old dump files, \fBCREATE TYPE\fR will
accept I/O functions declared using \fBopaque\fR, but it will issue
a notice and change the function declarations to use the correct
types.
.SH "EXAMPLES"
.PP
This example creates a composite type and uses it in
a function definition:
.sp
.nf
CREATE TYPE compfoo AS (f1 int, f2 text);

CREATE FUNCTION getfoo() RETURNS SETOF compfoo AS $$
    SELECT fooid, fooname FROM foo
$$ LANGUAGE SQL;
.sp
.fi
.PP
This example creates the base data type \fBbox\fR and then uses the
type in a table definition:
.sp
.nf
CREATE TYPE box;

CREATE FUNCTION my_box_in_function(cstring) RETURNS box AS ... ;
CREATE FUNCTION my_box_out_function(box) RETURNS cstring AS ... ;

CREATE TYPE box (
    INTERNALLENGTH = 16,
    INPUT = my_box_in_function,
    OUTPUT = my_box_out_function
);

CREATE TABLE myboxes (
    id integer,
    description box
);
.sp
.fi
.PP
If the internal structure of \fBbox\fR were an array of four
\fBfloat4\fR elements, we might instead use
.sp
.nf
CREATE TYPE box (
    INTERNALLENGTH = 16,
    INPUT = my_box_in_function,
    OUTPUT = my_box_out_function,
    ELEMENT = float4
);
.sp
.fi
which would allow a box value's component numbers to be accessed
by subscripting. Otherwise the type behaves the same as before.
.PP
This example creates a large object type and uses it in
a table definition:
.sp
.nf
CREATE TYPE bigobj (
    INPUT = lo_filein, OUTPUT = lo_fileout,
    INTERNALLENGTH = VARIABLE
);
CREATE TABLE big_objs (
    id integer,
    obj bigobj
);
.sp
.fi
.PP
More examples, including suitable input and output functions, are
in in the documentation.
.SH "COMPATIBILITY"
.PP
This \fBCREATE TYPE\fR command is a
PostgreSQL extension. There is a
\fBCREATE TYPE\fR statement in the SQL standard
that is rather different in detail.
.SH "SEE ALSO"
CREATE FUNCTION [\fBcreate_function\fR(l)], DROP TYPE [\fBdrop_type\fR(l)], ALTER TYPE [\fBalter_type\fR(l)], CREATE DOMAIN [\fBcreate_domain\fR(l)]
