.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "DROP LANGUAGE" "" "2012-05-31" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP LANGUAGE \- remove a procedural language

.SH SYNOPSIS
.sp
.nf
DROP [ PROCEDURAL ] LANGUAGE [ IF EXISTS ] \fIname\fR [ CASCADE | RESTRICT ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBDROP LANGUAGE\fR removes the definition of a
previously registered procedural language. You must be a superuser
or the owner of the language to use \fBDROP LANGUAGE\fR.
.SH "PARAMETERS"
.TP
\fBIF EXISTS\fR
Do not throw an error if the language does not exist. A notice is issued 
in this case.
.TP
\fB\fIname\fB\fR
The name of an existing procedural language. For backward
compatibility, the name can be enclosed by single quotes.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the language (such as
functions in the language).
.TP
\fBRESTRICT\fR
Refuse to drop the language if any objects depend on it. This
is the default.
.SH "EXAMPLES"
.PP
This command removes the procedural language
plsample:
.sp
.nf
DROP LANGUAGE plsample;
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBDROP LANGUAGE\fR statement in the SQL
standard.
.SH "SEE ALSO"
ALTER LANGUAGE [\fBalter_language\fR(l)], CREATE LANGUAGE [\fBcreate_language\fR(l)], \fBdroplang\fR(1)
