.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "TRUNCATE" "" "2008-09-19" "SQL - Language Statements" "SQL Commands"
.SH NAME
TRUNCATE \- empty a table or set of tables

.SH SYNOPSIS
.sp
.nf
TRUNCATE [ TABLE ] \fIname\fR [, ...] [ CASCADE | RESTRICT ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBTRUNCATE\fR quickly removes all rows from a set of
tables. It has the same effect as an unqualified
\fBDELETE\fR on each table, but since it does not actually
scan the tables it is faster. Furthermore, it reclaims disk space
immediately, rather than requiring a subsequent \fBVACUUM\fR
operation. This is most useful on large tables.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of a table to be truncated.
.TP
\fBCASCADE\fR
Automatically truncate all tables that have foreign-key references
to any of the named tables, or to any tables added to the group
due to CASCADE.
.TP
\fBRESTRICT\fR
Refuse to truncate if any of the tables have foreign-key references
from tables that are not to be truncated. This is the default.
.SH "NOTES"
.PP
Only the owner of a table can \fBTRUNCATE\fR it.
.PP
\fBTRUNCATE\fR cannot be used on a table that has foreign-key
references from other tables, unless all such tables are also truncated
in the same command. Checking validity in such cases would require table
scans, and the whole point is not to do one. The CASCADE
option can be used to automatically include all dependent tables \(em
but be very careful when using this option, or else you might lose data you
did not intend to!
.PP
\fBTRUNCATE\fR will not run any ON DELETE
triggers that might exist for the tables.
.sp
.RS
.B "Warning:"
.PP
\fBTRUNCATE\fR is not MVCC-safe (see in the documentation
for general information about MVCC). After truncation, the table
will appear empty to all concurrent transactions, even if they
are using a snapshot taken before the truncation occurred. This
will only be an issue for a transaction that did not access the
truncated table before the truncation happened \(em any
transaction that has done so would hold at least an
ACCESS SHARE lock, which would block
\fBTRUNCATE\fR until that transaction completes. So
truncation will not cause any apparent inconsistency in the table
contents for successive queries on the same table, but it could
cause visible inconsistency between the contents of the truncated
table and other tables in the database.
.PP
\fBTRUNCATE\fR is transaction-safe, however: the truncation
will be safely rolled back if the surrounding transaction does not
commit.
.RE
.sp
.SH "EXAMPLES"
.PP
Truncate the tables bigtable and fattable:
.sp
.nf
TRUNCATE bigtable, fattable;
.sp
.fi
.PP
Truncate the table othertable, and cascade to any tables
that reference othertable via foreign-key
constraints:
.sp
.nf
TRUNCATE othertable CASCADE;
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBTRUNCATE\fR command in the SQL standard.
