/* A Bison parser, made by GNU Bison 3.0.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2013 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         base_yyparse
#define yylex           base_yylex
#define yyerror         base_yyerror
#define yydebug         base_yydebug
#define yynerrs         base_yynerrs

#define yylval          base_yylval
#define yychar          base_yychar
#define yylloc          base_yylloc

/* Copy the first part of user declarations.  */
#line 5 "preproc.y" /* yacc.c:339  */

#include "postgres_fe.h"

#include "extern.h"
#include "ecpg_config.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
		if (N)						\
			(Current) = (Rhs)[1];	\
		else						\
			(Current) = (Rhs)[0];	\
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
char *current_function;
int ecpg_internal_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char	pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];
static int	varchar_counter = 1;

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list ap;

	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, base_yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			if (base_yyin)
				fclose(base_yyin);
			if (base_yyout)
				fclose(base_yyout);

			if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
				fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(base_yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essentially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, mm_strdup(pacounter_buffer), mm_strdup(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_outofscope_cursor_vars(struct cursor *cur)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * For instance you can DECLARE a cursor in one function, and OPEN/FETCH/CLOSE
	 * it in another functions. This is very useful for e.g. event-driver programming,
	 * but may also lead to dangerous programming. The limitation when this is allowed
	 * and doesn't cause problems have to be documented, like the allocated variables
	 * must not be realloc()'ed.
	 *
	 * We have to change the variables to our own struct and just store the pointer
	 * instead of the variable. Do it only for local variables, not for globals.
	 */

	char *result = EMPTY;
	int insert;

	for (insert = 1; insert >= 0; insert--)
	{
		struct arguments *list;
		struct arguments *ptr;
		struct arguments *newlist = NULL;
		struct variable *newvar, *newind;

		list = (insert ? cur->argsinsert : cur->argsresult);

		for (ptr = list; ptr != NULL; ptr = ptr->next)
		{
			char var_text[20];
			char *original_var;
			bool skip_set_var = false;
			bool var_ptr = false;

			/* change variable name to "ECPGget_var(<counter>)" */
			original_var = ptr->variable->name;
			sprintf(var_text, "%d))", ecpg_internal_var);

			/* Don't emit ECPGset_var() calls for global variables */
			if (ptr->variable->brace_level == 0)
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type == ECPGt_char_variable)
					 && (strncmp(ptr->variable->name, "ECPGprepared_statement", strlen("ECPGprepared_statement")) == 0))
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type != ECPGt_varchar
					  && ptr->variable->type->type != ECPGt_char
					  && ptr->variable->type->type != ECPGt_unsigned_char
					  && ptr->variable->type->type != ECPGt_string)
					 && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type,
																			   mm_strdup("1"),
																			   ptr->variable->type->u.element->counter),
														  ptr->variable->type->size),
									  0);
			}
			else if ((ptr->variable->type->type == ECPGt_varchar
					  || ptr->variable->type->type == ECPGt_char
					  || ptr->variable->type->type == ECPGt_unsigned_char
					  || ptr->variable->type->type == ECPGt_string)
					 && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_simple_type(ptr->variable->type->type,
														   ptr->variable->type->size,
														   ptr->variable->type->counter),
									  0);
				if (ptr->variable->type->type == ECPGt_varchar)
					var_ptr = true;
			}
			else if (ptr->variable->type->type == ECPGt_struct
					 || ptr->variable->type->type == ECPGt_union)
			{
				newvar = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->variable->type->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
									  ECPGmake_struct_type(ptr->variable->type->u.members,
														   ptr->variable->type->type,
														   ptr->variable->type->type_name,
														   ptr->variable->type->struct_sizeof),
									  0);
				var_ptr = true;
			}
			else if (ptr->variable->type->type == ECPGt_array)
			{
				if (ptr->variable->type->u.element->type == ECPGt_struct
					|| ptr->variable->type->u.element->type == ECPGt_union)
				{
					newvar = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->variable->type->u.element->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
										  ECPGmake_struct_type(ptr->variable->type->u.element->u.members,
															   ptr->variable->type->u.element->type,
															   ptr->variable->type->u.element->type_name,
															   ptr->variable->type->u.element->struct_sizeof),
										  0);
				}
				else
				{
					newvar = new_variable(cat_str(4, mm_strdup("("),
												  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type,
																				   ptr->variable->type->u.element->size,
																				   ptr->variable->type->u.element->counter),
															  ptr->variable->type->size),
										  0);
					var_ptr = true;
				}
			}
			else
			{
				newvar = new_variable(cat_str(4, mm_strdup("*("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_simple_type(ptr->variable->type->type,
														   ptr->variable->type->size,
														   ptr->variable->type->counter),
									  0);
				var_ptr = true;
			}

			/* create call to "ECPGset_var(<counter>, <connection>, <pointer>. <line number>)" */
			if (!skip_set_var)
			{
				sprintf(var_text, "%d, %s", ecpg_internal_var++, var_ptr ? "&(" : "(");
				result = cat_str(5, result, mm_strdup("ECPGset_var("),
								 mm_strdup(var_text), mm_strdup(original_var),
								 mm_strdup("), __LINE__);\n"));
			}

			/* now the indicator if there is one and it's not a global variable */
			if ((ptr->indicator->type->type == ECPGt_NO_INDICATOR) || (ptr->indicator->brace_level == 0))
			{
				newind = ptr->indicator;
			}
			else
			{
				/* change variable name to "ECPGget_var(<counter>)" */
				original_var = ptr->indicator->name;
				sprintf(var_text, "%d))", ecpg_internal_var);
				var_ptr = false;

				if (ptr->indicator->type->type == ECPGt_struct
					|| ptr->indicator->type->type == ECPGt_union)
				{
					newind = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->indicator->type->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
										  ECPGmake_struct_type(ptr->indicator->type->u.members,
															   ptr->indicator->type->type,
															   ptr->indicator->type->type_name,
															   ptr->indicator->type->struct_sizeof),
										  0);
					var_ptr = true;
				}
				else if (ptr->indicator->type->type == ECPGt_array)
				{
					if (ptr->indicator->type->u.element->type == ECPGt_struct
						|| ptr->indicator->type->u.element->type == ECPGt_union)
					{
						newind = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->indicator->type->u.element->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
											  ECPGmake_struct_type(ptr->indicator->type->u.element->u.members,
																   ptr->indicator->type->u.element->type,
																   ptr->indicator->type->u.element->type_name,
																   ptr->indicator->type->u.element->struct_sizeof),
											  0);
					}
					else
					{
						newind = new_variable(cat_str(4, mm_strdup("("),
													  mm_strdup(ecpg_type_name(ptr->indicator->type->u.element->type)),
													  mm_strdup(" *)(ECPGget_var("), mm_strdup(var_text)),
											  ECPGmake_array_type(ECPGmake_simple_type(ptr->indicator->type->u.element->type,
																					   ptr->indicator->type->u.element->size,
																					   ptr->indicator->type->u.element->counter),
																  ptr->indicator->type->size),
											  0);
						var_ptr = true;
					}
				}
				else if (atoi(ptr->indicator->type->size) > 1)
				{
					newind = new_variable(cat_str(4, mm_strdup("("),
												  mm_strdup(ecpg_type_name(ptr->indicator->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_simple_type(ptr->indicator->type->type,
															   ptr->indicator->type->size,
															   ptr->variable->type->counter),
										  0);
				}
				else
				{
					newind = new_variable(cat_str(4, mm_strdup("*("),
												  mm_strdup(ecpg_type_name(ptr->indicator->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_simple_type(ptr->indicator->type->type,
															   ptr->indicator->type->size,
															   ptr->variable->type->counter),
										  0);
					var_ptr = true;
				}

				/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
				sprintf(var_text, "%d, %s", ecpg_internal_var++, var_ptr ? "&(" : "(");
				result = cat_str(5, result, mm_strdup("ECPGset_var("),
								 mm_strdup(var_text), mm_strdup(original_var),
								 mm_strdup("), __LINE__);\n"));
			}

			add_variable_to_tail(&newlist, newvar, newind);
		}

		if (insert)
			cur->argsinsert_oos = newlist;
		else
			cur->argsresult_oos = newlist;
	}

	return result;
}

/* This tests whether the cursor was declared and opened in the same function. */
#define SAMEFUNC(cur)	\
	((cur->function == NULL) ||		\
	 (cur->function != NULL && strcmp(cur->function, current_function) == 0))

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;
	int (* strcmp_fn)(const char *, const char *) = ((name[0] == ':' || name[0] == '"') ? strcmp : pg_strcasecmp);

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp_fn(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = (SAMEFUNC(ptr) ? ptr->argsinsert : ptr->argsinsert_oos); p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = (SAMEFUNC(ptr) ? ptr->argsresult : ptr->argsresult_oos); p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char *dimension, char *length, enum ECPGttype type_enum,
			char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
		 type_enum == ECPGt_union) &&
		initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else if (INFORMIX_MODE && strcmp(name, "string") == 0)
		mmerror(PARSE_ERROR, ET_ERROR, "type name \"string\" is reserved in Informix mode");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			type_enum != ECPGt_string &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}

#line 630 "preproc.c" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* In a future release of Bison, this section will be replaced
   by #include "preproc.h".  */
#ifndef YY_BASE_YY_PREPROC_H_INCLUDED
# define YY_BASE_YY_PREPROC_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int base_yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    SQL_ALLOCATE = 258,
    SQL_AUTOCOMMIT = 259,
    SQL_BOOL = 260,
    SQL_BREAK = 261,
    SQL_CALL = 262,
    SQL_CARDINALITY = 263,
    SQL_CONNECT = 264,
    SQL_COUNT = 265,
    SQL_DATETIME_INTERVAL_CODE = 266,
    SQL_DATETIME_INTERVAL_PRECISION = 267,
    SQL_DESCRIBE = 268,
    SQL_DESCRIPTOR = 269,
    SQL_DISCONNECT = 270,
    SQL_FOUND = 271,
    SQL_FREE = 272,
    SQL_GET = 273,
    SQL_GO = 274,
    SQL_GOTO = 275,
    SQL_IDENTIFIED = 276,
    SQL_INDICATOR = 277,
    SQL_KEY_MEMBER = 278,
    SQL_LENGTH = 279,
    SQL_LONG = 280,
    SQL_NULLABLE = 281,
    SQL_OCTET_LENGTH = 282,
    SQL_OPEN = 283,
    SQL_OUTPUT = 284,
    SQL_REFERENCE = 285,
    SQL_RETURNED_LENGTH = 286,
    SQL_RETURNED_OCTET_LENGTH = 287,
    SQL_SCALE = 288,
    SQL_SECTION = 289,
    SQL_SHORT = 290,
    SQL_SIGNED = 291,
    SQL_SQL = 292,
    SQL_SQLERROR = 293,
    SQL_SQLPRINT = 294,
    SQL_SQLWARNING = 295,
    SQL_START = 296,
    SQL_STOP = 297,
    SQL_STRUCT = 298,
    SQL_UNSIGNED = 299,
    SQL_VAR = 300,
    SQL_WHENEVER = 301,
    S_ADD = 302,
    S_AND = 303,
    S_ANYTHING = 304,
    S_AUTO = 305,
    S_CONST = 306,
    S_DEC = 307,
    S_DIV = 308,
    S_DOTPOINT = 309,
    S_EQUAL = 310,
    S_EXTERN = 311,
    S_INC = 312,
    S_LSHIFT = 313,
    S_MEMPOINT = 314,
    S_MEMBER = 315,
    S_MOD = 316,
    S_MUL = 317,
    S_NEQUAL = 318,
    S_OR = 319,
    S_REGISTER = 320,
    S_RSHIFT = 321,
    S_STATIC = 322,
    S_SUB = 323,
    S_VOLATILE = 324,
    S_TYPEDEF = 325,
    CSTRING = 326,
    CVARIABLE = 327,
    CPP_LINE = 328,
    IP = 329,
    DOLCONST = 330,
    ECONST = 331,
    NCONST = 332,
    UCONST = 333,
    UIDENT = 334,
    IDENT = 335,
    FCONST = 336,
    SCONST = 337,
    BCONST = 338,
    XCONST = 339,
    Op = 340,
    ICONST = 341,
    PARAM = 342,
    TYPECAST = 343,
    DOT_DOT = 344,
    COLON_EQUALS = 345,
    ABORT_P = 346,
    ABSOLUTE_P = 347,
    ACCESS = 348,
    ACTION = 349,
    ADD_P = 350,
    ADMIN = 351,
    AFTER = 352,
    AGGREGATE = 353,
    ALL = 354,
    ALSO = 355,
    ALTER = 356,
    ALWAYS = 357,
    ANALYSE = 358,
    ANALYZE = 359,
    AND = 360,
    ANY = 361,
    ARRAY = 362,
    AS = 363,
    ASC = 364,
    ASSERTION = 365,
    ASSIGNMENT = 366,
    ASYMMETRIC = 367,
    AT = 368,
    ATTRIBUTE = 369,
    AUTHORIZATION = 370,
    BACKWARD = 371,
    BEFORE = 372,
    BEGIN_P = 373,
    BETWEEN = 374,
    BIGINT = 375,
    BINARY = 376,
    BIT = 377,
    BOOLEAN_P = 378,
    BOTH = 379,
    BY = 380,
    CACHE = 381,
    CALLED = 382,
    CASCADE = 383,
    CASCADED = 384,
    CASE = 385,
    CAST = 386,
    CATALOG_P = 387,
    CHAIN = 388,
    CHAR_P = 389,
    CHARACTER = 390,
    CHARACTERISTICS = 391,
    CHECK = 392,
    CHECKPOINT = 393,
    CLASS = 394,
    CLOSE = 395,
    CLUSTER = 396,
    COALESCE = 397,
    COLLATE = 398,
    COLLATION = 399,
    COLUMN = 400,
    COMMENT = 401,
    COMMENTS = 402,
    COMMIT = 403,
    COMMITTED = 404,
    CONCURRENTLY = 405,
    CONFIGURATION = 406,
    CONNECTION = 407,
    CONSTRAINT = 408,
    CONSTRAINTS = 409,
    CONTENT_P = 410,
    CONTINUE_P = 411,
    CONVERSION_P = 412,
    COPY = 413,
    COST = 414,
    CREATE = 415,
    CROSS = 416,
    CSV = 417,
    CURRENT_P = 418,
    CURRENT_CATALOG = 419,
    CURRENT_DATE = 420,
    CURRENT_ROLE = 421,
    CURRENT_SCHEMA = 422,
    CURRENT_TIME = 423,
    CURRENT_TIMESTAMP = 424,
    CURRENT_USER = 425,
    CURSOR = 426,
    CYCLE = 427,
    DATA_P = 428,
    DATABASE = 429,
    DAY_P = 430,
    DEALLOCATE = 431,
    DEC = 432,
    DECIMAL_P = 433,
    DECLARE = 434,
    DEFAULT = 435,
    DEFAULTS = 436,
    DEFERRABLE = 437,
    DEFERRED = 438,
    DEFINER = 439,
    DELETE_P = 440,
    DELIMITER = 441,
    DELIMITERS = 442,
    DESC = 443,
    DICTIONARY = 444,
    DISABLE_P = 445,
    DISCARD = 446,
    DISTINCT = 447,
    DO = 448,
    DOCUMENT_P = 449,
    DOMAIN_P = 450,
    DOUBLE_P = 451,
    DROP = 452,
    EACH = 453,
    ELSE = 454,
    ENABLE_P = 455,
    ENCODING = 456,
    ENCRYPTED = 457,
    END_P = 458,
    ENUM_P = 459,
    ESCAPE = 460,
    EXCEPT = 461,
    EXCLUDE = 462,
    EXCLUDING = 463,
    EXCLUSIVE = 464,
    EXECUTE = 465,
    EXISTS = 466,
    EXPLAIN = 467,
    EXTENSION = 468,
    EXTERNAL = 469,
    EXTRACT = 470,
    FALSE_P = 471,
    FAMILY = 472,
    FETCH = 473,
    FIRST_P = 474,
    FLOAT_P = 475,
    FOLLOWING = 476,
    FOR = 477,
    FORCE = 478,
    FOREIGN = 479,
    FORWARD = 480,
    FREEZE = 481,
    FROM = 482,
    FULL = 483,
    FUNCTION = 484,
    FUNCTIONS = 485,
    GLOBAL = 486,
    GRANT = 487,
    GRANTED = 488,
    GREATEST = 489,
    GROUP_P = 490,
    HANDLER = 491,
    HAVING = 492,
    HEADER_P = 493,
    HOLD = 494,
    HOUR_P = 495,
    IDENTITY_P = 496,
    IF_P = 497,
    ILIKE = 498,
    IMMEDIATE = 499,
    IMMUTABLE = 500,
    IMPLICIT_P = 501,
    IN_P = 502,
    INCLUDING = 503,
    INCREMENT = 504,
    INDEX = 505,
    INDEXES = 506,
    INHERIT = 507,
    INHERITS = 508,
    INITIALLY = 509,
    INLINE_P = 510,
    INNER_P = 511,
    INOUT = 512,
    INPUT_P = 513,
    INSENSITIVE = 514,
    INSERT = 515,
    INSTEAD = 516,
    INT_P = 517,
    INTEGER = 518,
    INTERSECT = 519,
    INTERVAL = 520,
    INTO = 521,
    INVOKER = 522,
    IS = 523,
    ISNULL = 524,
    ISOLATION = 525,
    JOIN = 526,
    KEY = 527,
    LABEL = 528,
    LANGUAGE = 529,
    LARGE_P = 530,
    LAST_P = 531,
    LC_COLLATE_P = 532,
    LC_CTYPE_P = 533,
    LEADING = 534,
    LEAKPROOF = 535,
    LEAST = 536,
    LEFT = 537,
    LEVEL = 538,
    LIKE = 539,
    LIMIT = 540,
    LISTEN = 541,
    LOAD = 542,
    LOCAL = 543,
    LOCALTIME = 544,
    LOCALTIMESTAMP = 545,
    LOCATION = 546,
    LOCK_P = 547,
    MAPPING = 548,
    MATCH = 549,
    MAXVALUE = 550,
    MINUTE_P = 551,
    MINVALUE = 552,
    MODE = 553,
    MONTH_P = 554,
    MOVE = 555,
    NAME_P = 556,
    NAMES = 557,
    NATIONAL = 558,
    NATURAL = 559,
    NCHAR = 560,
    NEXT = 561,
    NO = 562,
    NONE = 563,
    NOT = 564,
    NOTHING = 565,
    NOTIFY = 566,
    NOTNULL = 567,
    NOWAIT = 568,
    NULL_P = 569,
    NULLIF = 570,
    NULLS_P = 571,
    NUMERIC = 572,
    OBJECT_P = 573,
    OF = 574,
    OFF = 575,
    OFFSET = 576,
    OIDS = 577,
    ON = 578,
    ONLY = 579,
    OPERATOR = 580,
    OPTION = 581,
    OPTIONS = 582,
    OR = 583,
    ORDER = 584,
    OUT_P = 585,
    OUTER_P = 586,
    OVER = 587,
    OVERLAPS = 588,
    OVERLAY = 589,
    OWNED = 590,
    OWNER = 591,
    PARSER = 592,
    PARTIAL = 593,
    PARTITION = 594,
    PASSING = 595,
    PASSWORD = 596,
    PLACING = 597,
    PLANS = 598,
    POSITION = 599,
    PRECEDING = 600,
    PRECISION = 601,
    PRESERVE = 602,
    PREPARE = 603,
    PREPARED = 604,
    PRIMARY = 605,
    PRIOR = 606,
    PRIVILEGES = 607,
    PROCEDURAL = 608,
    PROCEDURE = 609,
    QUOTE = 610,
    RANGE = 611,
    READ = 612,
    REAL = 613,
    REASSIGN = 614,
    RECHECK = 615,
    RECURSIVE = 616,
    REF = 617,
    REFERENCES = 618,
    REINDEX = 619,
    RELATIVE_P = 620,
    RELEASE = 621,
    RENAME = 622,
    REPEATABLE = 623,
    REPLACE = 624,
    REPLICA = 625,
    RESET = 626,
    RESTART = 627,
    RESTRICT = 628,
    RETURNING = 629,
    RETURNS = 630,
    REVOKE = 631,
    RIGHT = 632,
    ROLE = 633,
    ROLLBACK = 634,
    ROW = 635,
    ROWS = 636,
    RULE = 637,
    SAVEPOINT = 638,
    SCHEMA = 639,
    SCROLL = 640,
    SEARCH = 641,
    SECOND_P = 642,
    SECURITY = 643,
    SELECT = 644,
    SEQUENCE = 645,
    SEQUENCES = 646,
    SERIALIZABLE = 647,
    SERVER = 648,
    SESSION = 649,
    SESSION_USER = 650,
    SET = 651,
    SETOF = 652,
    SHARE = 653,
    SHOW = 654,
    SIMILAR = 655,
    SIMPLE = 656,
    SMALLINT = 657,
    SNAPSHOT = 658,
    SOME = 659,
    STABLE = 660,
    STANDALONE_P = 661,
    START = 662,
    STATEMENT = 663,
    STATISTICS = 664,
    STDIN = 665,
    STDOUT = 666,
    STORAGE = 667,
    STRICT_P = 668,
    STRIP_P = 669,
    SUBSTRING = 670,
    SYMMETRIC = 671,
    SYSID = 672,
    SYSTEM_P = 673,
    TABLE = 674,
    TABLES = 675,
    TABLESPACE = 676,
    TEMP = 677,
    TEMPLATE = 678,
    TEMPORARY = 679,
    TEXT_P = 680,
    THEN = 681,
    TIME = 682,
    TIMESTAMP = 683,
    TO = 684,
    TRAILING = 685,
    TRANSACTION = 686,
    TREAT = 687,
    TRIGGER = 688,
    TRIM = 689,
    TRUE_P = 690,
    TRUNCATE = 691,
    TRUSTED = 692,
    TYPE_P = 693,
    TYPES_P = 694,
    UNBOUNDED = 695,
    UNCOMMITTED = 696,
    UNENCRYPTED = 697,
    UNION = 698,
    UNIQUE = 699,
    UNKNOWN = 700,
    UNLISTEN = 701,
    UNLOGGED = 702,
    UNTIL = 703,
    UPDATE = 704,
    USER = 705,
    USING = 706,
    VACUUM = 707,
    VALID = 708,
    VALIDATE = 709,
    VALIDATOR = 710,
    VALUE_P = 711,
    VALUES = 712,
    VARCHAR = 713,
    VARIADIC = 714,
    VARYING = 715,
    VERBOSE = 716,
    VERSION_P = 717,
    VIEW = 718,
    VOLATILE = 719,
    WHEN = 720,
    WHERE = 721,
    WHITESPACE_P = 722,
    WINDOW = 723,
    WITH = 724,
    WITHOUT = 725,
    WORK = 726,
    WRAPPER = 727,
    WRITE = 728,
    XML_P = 729,
    XMLATTRIBUTES = 730,
    XMLCONCAT = 731,
    XMLELEMENT = 732,
    XMLEXISTS = 733,
    XMLFOREST = 734,
    XMLPARSE = 735,
    XMLPI = 736,
    XMLROOT = 737,
    XMLSERIALIZE = 738,
    YEAR_P = 739,
    YES_P = 740,
    ZONE = 741,
    NULLS_FIRST = 742,
    NULLS_LAST = 743,
    WITH_TIME = 744,
    POSTFIXOP = 745,
    UMINUS = 746
  };
#endif

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE YYSTYPE;
union YYSTYPE
{
#line 564 "preproc.y" /* yacc.c:355  */

	double	dval;
	char	*str;
	int		ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;

#line 1177 "preproc.c" /* yacc.c:355  */
};
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif

/* Location type.  */
#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE YYLTYPE;
struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


extern YYSTYPE base_yylval;
extern YYLTYPE base_yylloc;
int base_yyparse (void);

#endif /* !YY_BASE_YY_PREPROC_H_INCLUDED  */

/* Copy the second part of user declarations.  */

#line 1206 "preproc.c" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   105232

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  511
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  688
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2735
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  4951

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   746

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   498,     2,     2,
     503,   504,   496,   494,   506,   495,   505,   497,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   508,   507,
     491,   490,   492,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   501,     2,   502,   499,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   509,     2,   510,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   493,   500
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1466,  1466,  1469,  1471,  1473,  1475,  1477,  1479,  1481,
    1483,  1485,  1487,  1489,  1491,  1493,  1495,  1497,  1499,  1501,
    1503,  1505,  1507,  1509,  1511,  1513,  1515,  1517,  1519,  1521,
    1539,  1541,  1543,  1545,  1547,  1549,  1551,  1553,  1555,  1557,
    1559,  1561,  1563,  1565,  1567,  1569,  1571,  1573,  1575,  1577,
    1579,  1581,  1583,  1585,  1587,  1589,  1591,  1593,  1595,  1599,
    1601,  1603,  1605,  1607,  1609,  1611,  1613,  1615,  1617,  1619,
    1621,  1623,  1625,  1627,  1629,  1631,  1633,  1635,  1637,  1639,
    1641,  1643,  1645,  1647,  1649,  1651,  1653,  1655,  1657,  1659,
    1661,  1663,  1665,  1672,  1674,  1676,  1678,  1680,  1682,  1684,
    1686,  1688,  1690,  1692,  1694,  1700,  1702,  1704,  1706,  1708,
    1710,  1712,  1714,  1716,  1722,  1732,  1736,  1742,  1746,  1756,
    1766,  1767,  1781,  1788,  1794,  1805,  1811,  1820,  1827,  1833,
    1842,  1849,  1857,  1862,  1870,  1875,  1881,  1886,  1892,  1897,
    1903,  1907,  1911,  1915,  1919,  1923,  1927,  1931,  1935,  1943,
    1947,  1951,  1955,  1959,  1963,  1971,  1979,  1988,  1990,  1998,
    2006,  2014,  2022,  2026,  2034,  2038,  2046,  2054,  2062,  2066,
    2074,  2078,  2086,  2090,  2098,  2103,  2109,  2114,  2120,  2124,
    2128,  2132,  2136,  2140,  2148,  2152,  2156,  2164,  2168,  2172,
    2180,  2184,  2188,  2192,  2196,  2200,  2204,  2209,  2213,  2217,
    2221,  2225,  2229,  2233,  2241,  2245,  2253,  2257,  2265,  2269,
    2283,  2287,  2291,  2295,  2303,  2307,  2311,  2315,  2323,  2327,
    2331,  2335,  2339,  2343,  2347,  2355,  2359,  2364,  2370,  2374,
    2382,  2386,  2390,  2394,  2398,  2406,  2410,  2418,  2422,  2430,
    2434,  2438,  2442,  2446,  2455,  2463,  2467,  2475,  2479,  2487,
    2495,  2499,  2503,  2507,  2515,  2519,  2523,  2527,  2531,  2535,
    2539,  2543,  2551,  2555,  2563,  2567,  2571,  2575,  2579,  2583,
    2587,  2591,  2595,  2599,  2603,  2607,  2611,  2615,  2619,  2623,
    2627,  2631,  2635,  2639,  2643,  2647,  2651,  2655,  2659,  2663,
    2667,  2671,  2675,  2679,  2683,  2687,  2691,  2695,  2699,  2703,
    2707,  2711,  2715,  2719,  2723,  2727,  2735,  2739,  2747,  2751,
    2756,  2762,  2767,  2773,  2778,  2784,  2792,  2797,  2803,  2807,
    2815,  2819,  2823,  2827,  2835,  2843,  2847,  2855,  2859,  2863,
    2867,  2875,  2880,  2888,  2899,  2910,  2914,  2922,  2926,  2930,
    2938,  2942,  2950,  2955,  2961,  2965,  2969,  2973,  2977,  2981,
    2985,  2989,  2993,  2997,  3001,  3005,  3013,  3018,  3024,  3029,
    3035,  3040,  3046,  3051,  3057,  3061,  3069,  3077,  3081,  3085,
    3089,  3094,  3100,  3104,  3112,  3120,  3124,  3128,  3132,  3140,
    3144,  3148,  3152,  3156,  3160,  3164,  3169,  3175,  3180,  3186,
    3191,  3197,  3201,  3209,  3213,  3221,  3225,  3229,  3237,  3241,
    3249,  3257,  3265,  3270,  3276,  3280,  3284,  3288,  3296,  3300,
    3304,  3308,  3312,  3316,  3320,  3328,  3332,  3336,  3340,  3348,
    3356,  3360,  3365,  3371,  3375,  3379,  3383,  3387,  3391,  3399,
    3403,  3411,  3415,  3419,  3423,  3427,  3431,  3435,  3443,  3448,
    3454,  3459,  3465,  3469,  3477,  3485,  3489,  3494,  3499,  3505,
    3509,  3517,  3521,  3529,  3534,  3540,  3544,  3548,  3552,  3557,
    3563,  3571,  3579,  3583,  3587,  3591,  3595,  3603,  3608,  3614,
    3618,  3622,  3627,  3633,  3637,  3641,  3646,  3652,  3657,  3663,
    3668,  3674,  3682,  3690,  3694,  3699,  3705,  3713,  3717,  3725,
    3730,  3736,  3740,  3748,  3752,  3756,  3760,  3764,  3768,  3772,
    3776,  3780,  3784,  3788,  3792,  3800,  3805,  3811,  3815,  3819,
    3827,  3831,  3839,  3843,  3851,  3856,  3862,  3866,  3874,  3879,
    3885,  3889,  3897,  3902,  3908,  3912,  3920,  3925,  3931,  3939,
    3944,  3950,  3954,  3962,  3966,  3974,  3979,  3985,  3989,  3993,
    4001,  4009,  4014,  4020,  4028,  4032,  4036,  4040,  4044,  4048,
    4052,  4056,  4060,  4064,  4068,  4072,  4076,  4080,  4084,  4088,
    4092,  4096,  4100,  4104,  4108,  4112,  4120,  4128,  4132,  4136,
    4140,  4148,  4152,  4160,  4165,  4171,  4175,  4183,  4187,  4195,
    4200,  4206,  4210,  4218,  4226,  4230,  4238,  4242,  4246,  4250,
    4258,  4266,  4274,  4282,  4290,  4295,  4301,  4305,  4313,  4318,
    4324,  4328,  4336,  4340,  4344,  4352,  4356,  4364,  4368,  4376,
    4380,  4388,  4396,  4400,  4408,  4416,  4420,  4424,  4432,  4436,
    4444,  4452,  4456,  4464,  4468,  4472,  4480,  4484,  4492,  4496,
    4500,  4504,  4508,  4516,  4521,  4527,  4532,  4538,  4542,  4550,
    4555,  4561,  4565,  4570,  4576,  4580,  4584,  4588,  4596,  4601,
    4608,  4610,  4618,  4622,  4626,  4630,  4634,  4638,  4646,  4650,
    4658,  4667,  4676,  4680,  4684,  4688,  4692,  4696,  4700,  4704,
    4708,  4712,  4716,  4720,  4724,  4728,  4736,  4744,  4748,  4756,
    4760,  4768,  4772,  4776,  4780,  4784,  4792,  4796,  4804,  4812,
    4816,  4824,  4832,  4837,  4843,  4847,  4855,  4859,  4863,  4871,
    4879,  4883,  4891,  4895,  4899,  4903,  4907,  4915,  4920,  4926,
    4931,  4937,  4941,  4946,  4952,  4958,  4964,  4972,  4976,  4984,
    4988,  4996,  5000,  5008,  5012,  5020,  5024,  5032,  5040,  5048,
    5052,  5056,  5060,  5068,  5072,  5076,  5080,  5084,  5088,  5092,
    5096,  5100,  5104,  5108,  5112,  5116,  5120,  5124,  5132,  5136,
    5144,  5148,  5156,  5160,  5168,  5176,  5180,  5185,  5191,  5195,
    5199,  5203,  5207,  5211,  5215,  5219,  5223,  5227,  5231,  5235,
    5239,  5243,  5247,  5251,  5255,  5263,  5267,  5271,  5275,  5279,
    5283,  5287,  5291,  5295,  5299,  5303,  5307,  5311,  5315,  5319,
    5323,  5327,  5335,  5339,  5347,  5351,  5355,  5359,  5363,  5371,
    5376,  5382,  5386,  5390,  5394,  5398,  5402,  5406,  5410,  5414,
    5418,  5422,  5430,  5434,  5442,  5446,  5450,  5454,  5460,  5466,
    5472,  5478,  5484,  5490,  5496,  5506,  5517,  5528,  5539,  5550,
    5561,  5572,  5588,  5604,  5620,  5631,  5647,  5658,  5674,  5689,
    5693,  5701,  5706,  5712,  5720,  5724,  5732,  5736,  5740,  5744,
    5748,  5756,  5760,  5768,  5772,  5776,  5780,  5788,  5792,  5796,
    5800,  5804,  5808,  5812,  5816,  5820,  5824,  5828,  5832,  5836,
    5840,  5844,  5848,  5856,  5860,  5868,  5872,  5880,  5885,  5891,
    5895,  5903,  5911,  5919,  5923,  5931,  5936,  5942,  5947,  5953,
    5961,  5966,  5972,  5976,  5980,  5988,  5992,  5996,  6004,  6008,
    6012,  6016,  6024,  6032,  6037,  6043,  6048,  6054,  6059,  6065,
    6070,  6076,  6080,  6088,  6092,  6096,  6104,  6109,  6115,  6119,
    6124,  6130,  6134,  6139,  6145,  6149,  6154,  6160,  6164,  6168,
    6176,  6181,  6187,  6191,  6199,  6203,  6211,  6215,  6223,  6227,
    6235,  6239,  6243,  6247,  6251,  6259,  6263,  6267,  6271,  6275,
    6283,  6291,  6299,  6303,  6307,  6315,  6319,  6323,  6331,  6335,
    6343,  6347,  6351,  6355,  6359,  6363,  6367,  6371,  6375,  6379,
    6383,  6387,  6391,  6395,  6399,  6407,  6411,  6415,  6419,  6427,
    6431,  6439,  6444,  6450,  6458,  6462,  6470,  6478,  6482,  6490,
    6495,  6501,  6505,  6513,  6517,  6525,  6529,  6537,  6541,  6545,
    6549,  6557,  6561,  6569,  6577,  6581,  6589,  6593,  6601,  6605,
    6609,  6617,  6621,  6626,  6632,  6640,  6645,  6651,  6655,  6659,
    6667,  6671,  6679,  6684,  6690,  6694,  6698,  6702,  6706,  6710,
    6714,  6718,  6722,  6726,  6730,  6734,  6738,  6742,  6746,  6750,
    6754,  6758,  6762,  6766,  6770,  6774,  6778,  6782,  6786,  6790,
    6794,  6798,  6802,  6806,  6810,  6814,  6818,  6822,  6826,  6830,
    6834,  6838,  6842,  6846,  6850,  6858,  6863,  6869,  6874,  6880,
    6884,  6888,  6892,  6896,  6900,  6904,  6908,  6912,  6916,  6920,
    6924,  6928,  6932,  6936,  6940,  6944,  6948,  6952,  6956,  6960,
    6964,  6972,  6976,  6980,  6984,  6988,  6992,  6996,  7000,  7004,
    7008,  7012,  7016,  7020,  7024,  7028,  7032,  7036,  7040,  7048,
    7056,  7060,  7064,  7072,  7076,  7084,  7088,  7092,  7096,  7100,
    7108,  7113,  7119,  7123,  7127,  7131,  7139,  7143,  7148,  7154,
    7158,  7166,  7174,  7179,  7185,  7193,  7197,  7205,  7209,  7213,
    7217,  7221,  7225,  7229,  7233,  7237,  7241,  7245,  7249,  7253,
    7257,  7265,  7269,  7274,  7280,  7284,  7288,  7292,  7296,  7304,
    7308,  7312,  7320,  7325,  7331,  7335,  7343,  7348,  7353,  7359,
    7365,  7373,  7381,  7386,  7392,  7396,  7400,  7404,  7408,  7412,
    7416,  7420,  7424,  7428,  7432,  7436,  7440,  7444,  7448,  7452,
    7460,  7465,  7471,  7475,  7483,  7491,  7496,  7502,  7510,  7514,
    7522,  7530,  7534,  7538,  7542,  7546,  7550,  7554,  7562,  7567,
    7573,  7581,  7585,  7589,  7593,  7597,  7601,  7609,  7617,  7621,
    7625,  7633,  7638,  7644,  7648,  7652,  7656,  7660,  7668,  7672,
    7680,  7684,  7688,  7692,  7700,  7704,  7712,  7716,  7724,  7729,
    7735,  7740,  7746,  7751,  7757,  7762,  7768,  7772,  7776,  7780,
    7788,  7792,  7796,  7800,  7804,  7808,  7812,  7820,  7824,  7832,
    7840,  7844,  7852,  7856,  7861,  7867,  7873,  7883,  7888,  7894,
    7898,  7902,  7906,  7914,  7916,  7924,  7929,  7935,  7943,  7947,
    7951,  7959,  7963,  7971,  7979,  7984,  7990,  7998,  8003,  8009,
    8017,  8022,  8028,  8032,  8036,  8040,  8044,  8048,  8052,  8056,
    8064,  8069,  8075,  8083,  8087,  8095,  8099,  8107,  8115,  8123,
    8131,  8135,  8143,  8196,  8200,  8213,  8215,  8219,  8223,  8227,
    8236,  8242,  8246,  8254,  8258,  8266,  8270,  8278,  8282,  8286,
    8290,  8294,  8298,  8302,  8306,  8314,  8318,  8326,  8330,  8334,
    8338,  8342,  8346,  8354,  8358,  8366,  8370,  8378,  8386,  8391,
    8397,  8402,  8404,  8410,  8414,  8418,  8422,  8426,  8430,  8434,
    8438,  8442,  8450,  8455,  8461,  8465,  8470,  8476,  8480,  8484,
    8489,  8495,  8500,  8506,  8514,  8518,  8526,  8530,  8538,  8542,
    8546,  8550,  8558,  8563,  8569,  8573,  8578,  8586,  8590,  8598,
    8602,  8610,  8618,  8622,  8627,  8633,  8641,  8645,  8653,  8657,
    8665,  8670,  8676,  8681,  8687,  8691,  8699,  8704,  8710,  8714,
    8722,  8726,  8734,  8739,  8745,  8749,  8757,  8762,  8768,  8772,
    8780,  8784,  8788,  8792,  8796,  8800,  8804,  8808,  8814,  8818,
    8822,  8830,  8834,  8838,  8842,  8846,  8850,  8858,  8862,  8866,
    8870,  8878,  8882,  8886,  8890,  8898,  8903,  8909,  8913,  8921,
    8925,  8929,  8933,  8941,  8945,  8953,  8957,  8961,  8969,  8977,
    8982,  8988,  8992,  8998,  9004,  9009,  9015,  9019,  9027,  9035,
    9037,  9039,  9043,  9047,  9051,  9059,  9069,  9080,  9089,  9093,
    9097,  9101,  9105,  9109,  9113,  9121,  9125,  9129,  9133,  9141,
    9145,  9153,  9158,  9164,  9168,  9172,  9176,  9180,  9184,  9188,
    9192,  9196,  9200,  9204,  9212,  9217,  9223,  9227,  9235,  9239,
    9247,  9255,  9263,  9267,  9275,  9279,  9287,  9295,  9303,  9307,
    9311,  9315,  9319,  9323,  9331,  9336,  9342,  9347,  9353,  9357,
    9361,  9365,  9373,  9381,  9385,  9390,  9396,  9400,  9404,  9408,
    9412,  9416,  9420,  9424,  9428,  9432,  9436,  9440,  9444,  9449,
    9455,  9459,  9467,  9471,  9475,  9479,  9483,  9487,  9491,  9495,
    9499,  9503,  9507,  9511,  9515,  9519,  9523,  9527,  9531,  9535,
    9539,  9543,  9547,  9551,  9555,  9559,  9563,  9567,  9571,  9575,
    9579,  9583,  9587,  9591,  9595,  9599,  9603,  9607,  9611,  9615,
    9619,  9623,  9627,  9631,  9635,  9639,  9643,  9647,  9651,  9655,
    9659,  9663,  9667,  9671,  9675,  9679,  9683,  9687,  9691,  9696,
    9700,  9708,  9712,  9716,  9720,  9724,  9728,  9732,  9736,  9740,
    9744,  9748,  9752,  9756,  9760,  9764,  9768,  9772,  9776,  9780,
    9784,  9788,  9792,  9800,  9804,  9808,  9812,  9816,  9820,  9824,
    9828,  9832,  9836,  9840,  9844,  9852,  9856,  9860,  9864,  9868,
    9872,  9876,  9880,  9884,  9888,  9892,  9896,  9900,  9904,  9908,
    9912,  9916,  9920,  9924,  9928,  9932,  9936,  9940,  9944,  9948,
    9952,  9956,  9960,  9964,  9968,  9972,  9976,  9980,  9984,  9988,
    9992,  9996, 10000, 10004, 10008, 10012, 10016, 10020, 10024, 10028,
   10032, 10036, 10040, 10044, 10048, 10056, 10060, 10068, 10072, 10076,
   10081, 10087, 10095, 10099, 10107, 10111, 10119, 10123, 10131, 10135,
   10140, 10146, 10150, 10154, 10158, 10166, 10171, 10177, 10181, 10189,
   10197, 10201, 10206, 10212, 10220, 10224, 10231, 10236, 10242, 10247,
   10252, 10258, 10262, 10270, 10274, 10278, 10282, 10286, 10294, 10298,
   10302, 10310, 10314, 10318, 10326, 10330, 10338, 10342, 10346, 10350,
   10354, 10358, 10362, 10366, 10370, 10378, 10382, 10390, 10394, 10402,
   10406, 10410, 10414, 10418, 10422, 10430, 10434, 10442, 10446, 10454,
   10458, 10466, 10470, 10478, 10482, 10486, 10494, 10498, 10506, 10511,
   10517, 10521, 10525, 10529, 10533, 10537, 10541, 10545, 10553, 10557,
   10565, 10573, 10578, 10584, 10588, 10592, 10596, 10600, 10605, 10611,
   10619, 10627, 10631, 10635, 10643, 10647, 10655, 10663, 10667, 10675,
   10683, 10688, 10694, 10699, 10705, 10709, 10717, 10721, 10725, 10729,
   10737, 10741, 10750, 10752, 10760, 10765, 10771, 10775, 10783, 10787,
   10795, 10803, 10807, 10815, 10819, 10823, 10827, 10835, 10839, 10847,
   10851, 10859, 10863, 10871, 10879, 10887, 10895, 10903, 10911, 10919,
   10923, 10931, 10935, 10939, 10943, 10947, 10951, 10955, 10959, 10963,
   10967, 10971, 10975, 10979, 10983, 10984, 10989, 10995, 11003, 11007,
   11015, 11019, 11020, 11024, 11032, 11036, 11040, 11044, 11052, 11056,
   11060, 11064, 11068, 11072, 11076, 11080, 11084, 11088, 11092, 11096,
   11100, 11104, 11108, 11112, 11116, 11120, 11124, 11128, 11132, 11136,
   11140, 11144, 11148, 11152, 11156, 11160, 11164, 11168, 11172, 11176,
   11180, 11184, 11188, 11192, 11196, 11200, 11204, 11208, 11212, 11216,
   11220, 11224, 11228, 11232, 11236, 11240, 11244, 11248, 11252, 11256,
   11260, 11264, 11268, 11272, 11276, 11280, 11284, 11288, 11292, 11296,
   11300, 11304, 11308, 11312, 11316, 11320, 11324, 11328, 11332, 11336,
   11340, 11344, 11348, 11352, 11356, 11360, 11364, 11368, 11372, 11376,
   11380, 11384, 11388, 11392, 11396, 11400, 11404, 11408, 11412, 11416,
   11420, 11424, 11428, 11432, 11436, 11440, 11444, 11448, 11452, 11456,
   11460, 11464, 11468, 11472, 11476, 11480, 11484, 11488, 11492, 11496,
   11500, 11504, 11508, 11512, 11516, 11520, 11524, 11528, 11532, 11536,
   11540, 11544, 11548, 11552, 11556, 11560, 11564, 11568, 11572, 11576,
   11580, 11584, 11588, 11592, 11596, 11600, 11604, 11608, 11612, 11616,
   11620, 11624, 11628, 11632, 11636, 11640, 11644, 11648, 11652, 11656,
   11660, 11664, 11668, 11672, 11676, 11680, 11684, 11688, 11692, 11696,
   11700, 11704, 11708, 11712, 11716, 11720, 11724, 11728, 11732, 11736,
   11740, 11744, 11748, 11752, 11756, 11760, 11764, 11768, 11772, 11776,
   11780, 11784, 11788, 11792, 11796, 11800, 11804, 11808, 11812, 11816,
   11820, 11824, 11828, 11832, 11836, 11840, 11844, 11848, 11852, 11856,
   11860, 11864, 11868, 11872, 11876, 11880, 11884, 11888, 11892, 11896,
   11900, 11904, 11908, 11912, 11916, 11920, 11924, 11928, 11932, 11936,
   11940, 11944, 11948, 11952, 11956, 11960, 11964, 11968, 11972, 11976,
   11980, 11984, 11988, 11992, 11996, 12000, 12004, 12008, 12012, 12020,
   12024, 12028, 12032, 12036, 12040, 12044, 12048, 12052, 12056, 12060,
   12064, 12068, 12072, 12076, 12080, 12084, 12088, 12092, 12096, 12100,
   12104, 12108, 12112, 12116, 12120, 12124, 12128, 12132, 12136, 12140,
   12144, 12148, 12152, 12156, 12160, 12164, 12168, 12172, 12176, 12180,
   12184, 12188, 12192, 12200, 12204, 12208, 12212, 12216, 12220, 12224,
   12228, 12232, 12236, 12240, 12244, 12248, 12252, 12256, 12260, 12264,
   12268, 12272, 12276, 12280, 12284, 12288, 12296, 12300, 12304, 12308,
   12312, 12316, 12320, 12324, 12328, 12332, 12336, 12340, 12344, 12348,
   12352, 12356, 12360, 12364, 12368, 12372, 12376, 12380, 12384, 12388,
   12392, 12396, 12400, 12404, 12408, 12412, 12416, 12420, 12424, 12428,
   12432, 12436, 12440, 12444, 12448, 12452, 12456, 12460, 12464, 12468,
   12472, 12476, 12480, 12484, 12488, 12492, 12496, 12500, 12504, 12508,
   12512, 12516, 12520, 12524, 12528, 12532, 12536, 12540, 12544, 12548,
   12552, 12556, 12560, 12564, 12568, 12572, 12576, 12580, 12584, 12588,
   12598, 12599, 12602, 12603, 12604, 12610, 12611, 12612, 12613, 12614,
   12627, 12627, 12636, 12651, 12653, 12656, 12658, 12662, 12674, 12690,
   12694, 12705, 12706, 12709, 12721, 12730, 12731, 12734, 12735, 12736,
   12739, 12740, 12743, 12744, 12747, 12748, 12751, 12753, 12755, 12757,
   12761, 12768, 12775, 12791, 12825, 12835, 12838, 12842, 12855, 12856,
   12858, 12860, 12864, 12878, 12885, 12946, 12955, 12957, 12958, 12961,
   12963, 12964, 12967, 12968, 12969, 12970, 12971, 12978, 12977, 12987,
   12989, 12991, 12992, 12995, 12996, 12997, 12998, 13001, 13002, 13006,
   13005, 13022, 13020, 13036, 13035, 13049, 13055, 13056, 13059, 13061,
   13062, 13065, 13066, 13067, 13068, 13071, 13072, 13075, 13083, 13100,
   13108, 13131, 13237, 13271, 13273, 13275, 13279, 13283, 13282, 13333,
   13335, 13334, 13349, 13355, 13362, 13367, 13373, 13374, 13377, 13378,
   13379, 13380, 13381, 13382, 13383, 13391, 13399, 13402, 13403, 13404,
   13405, 13406, 13407, 13415, 13423, 13424, 13425, 13428, 13429, 13432,
   13434, 13443, 13531, 13532, 13539, 13540, 13541, 13547, 13556, 13559,
   13560, 13561, 13562, 13565, 13566, 13567, 13570, 13572, 13580, 13581,
   13587, 13595, 13596, 13599, 13600, 13603, 13608, 13615, 13620, 13627,
   13634, 13634, 13636, 13643, 13644, 13647, 13648, 13649, 13650, 13651,
   13652, 13653, 13654, 13655, 13661, 13668, 13680, 13686, 13693, 13701,
   13702, 13714, 13725, 13736, 13740, 13741, 13744, 13749, 13753, 13754,
   13757, 13763, 13771, 13777, 13784, 13788, 13789, 13792, 13795, 13799,
   13800, 13803, 13809, 13818, 13823, 13833, 13843, 13855, 13856, 13857,
   13858, 13859, 13860, 13861, 13862, 13863, 13864, 13865, 13866, 13867,
   13868, 13869, 13876, 13877, 13880, 13881, 13888, 13889, 13890, 13897,
   13896, 13913, 13914, 13921, 13920, 13990, 13996, 14002, 14010, 14016,
   14022, 14028, 14034, 14040, 14046, 14052, 14058, 14069, 14070, 14073,
   14074, 14075, 14076, 14077, 14078, 14079, 14080, 14081, 14082, 14083,
   14084, 14085, 14086, 14087, 14088, 14089, 14090, 14091, 14092, 14093,
   14094, 14095, 14096, 14099, 14100, 14101, 14102, 14103, 14104, 14108,
   14109, 14110, 14111, 14112, 14113, 14114, 14117, 14120, 14121, 14122,
   14123, 14124, 14125, 14126, 14127, 14140, 14141, 14142, 14143, 14144,
   14145, 14146, 14151, 14152, 14153, 14154, 14155, 14156, 14162, 14163,
   14164, 14165, 14166, 14167, 14168, 14169, 14170, 14171, 14172, 14175,
   14176, 14177, 14178, 14179, 14182, 14183, 14184, 14185, 14188, 14189,
   14190, 14191, 14192, 14193, 14194, 14211, 14212, 14213, 14216, 14217,
   14218, 14219, 14220, 14221, 14225, 14225, 14228, 14234, 14235, 14238,
   14240, 14245, 14255, 14266, 14273, 14274, 14275, 14278, 14311, 14313,
   14315, 14318, 14328, 14338, 14348, 14349, 14352, 14354, 14355, 14356,
   14359, 14361, 14369, 14370, 14371, 14375, 14376, 14380, 14381, 14384,
   14385, 14388, 14389, 14390, 14391, 14392, 14395, 14396, 14397, 14398,
   14399, 14400, 14401, 14402, 14403, 14404, 14405, 14406, 14407, 14408,
   14409, 14410, 14411, 14412, 14413, 14414, 14415, 14416, 14417, 14418,
   14419, 14420, 14421, 14422, 14423, 14424, 14425, 14426, 14427, 14428,
   14429, 14430, 14431, 14432, 14433, 14434, 14435, 14436, 14437, 14438,
   14439, 14440, 14441, 14442, 14443, 14444, 14445, 14446, 14447, 14448,
   14449, 14450, 14453, 14454, 14455, 14456, 14459, 14460, 14461, 14462,
   14463, 14464, 14465, 14466, 14467, 14470, 14471, 14472, 14473, 14474,
   14477, 14478, 14481, 14482, 14493, 14494
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT",
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT",
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE",
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR",
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO",
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER",
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN",
  "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH",
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT",
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT",
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED",
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO",
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN",
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL",
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB",
  "S_VOLATILE", "S_TYPEDEF", "CSTRING", "CVARIABLE", "CPP_LINE", "IP",
  "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", "IDENT", "FCONST",
  "SCONST", "BCONST", "XCONST", "Op", "ICONST", "PARAM", "TYPECAST",
  "DOT_DOT", "COLON_EQUALS", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION",
  "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", "ALWAYS",
  "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION",
  "ASSIGNMENT", "ASYMMETRIC", "AT", "ATTRIBUTE", "AUTHORIZATION",
  "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT",
  "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", "CASCADE", "CASCADED",
  "CASE", "CAST", "CATALOG_P", "CHAIN", "CHAR_P", "CHARACTER",
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER",
  "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMENT", "COMMENTS",
  "COMMIT", "COMMITTED", "CONCURRENTLY", "CONFIGURATION", "CONNECTION",
  "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", "CONTINUE_P", "CONVERSION_P",
  "COPY", "COST", "CREATE", "CROSS", "CSV", "CURRENT_P", "CURRENT_CATALOG",
  "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_SCHEMA", "CURRENT_TIME",
  "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", "DATA_P",
  "DATABASE", "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", "DECLARE",
  "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE_P",
  "DELIMITER", "DELIMITERS", "DESC", "DICTIONARY", "DISABLE_P", "DISCARD",
  "DISTINCT", "DO", "DOCUMENT_P", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH",
  "ELSE", "ENABLE_P", "ENCODING", "ENCRYPTED", "END_P", "ENUM_P", "ESCAPE",
  "EXCEPT", "EXCLUDE", "EXCLUDING", "EXCLUSIVE", "EXECUTE", "EXISTS",
  "EXPLAIN", "EXTENSION", "EXTERNAL", "EXTRACT", "FALSE_P", "FAMILY",
  "FETCH", "FIRST_P", "FLOAT_P", "FOLLOWING", "FOR", "FORCE", "FOREIGN",
  "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "FUNCTIONS", "GLOBAL",
  "GRANT", "GRANTED", "GREATEST", "GROUP_P", "HANDLER", "HAVING",
  "HEADER_P", "HOLD", "HOUR_P", "IDENTITY_P", "IF_P", "ILIKE", "IMMEDIATE",
  "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX",
  "INDEXES", "INHERIT", "INHERITS", "INITIALLY", "INLINE_P", "INNER_P",
  "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P",
  "INTEGER", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL",
  "ISOLATION", "JOIN", "KEY", "LABEL", "LANGUAGE", "LARGE_P", "LAST_P",
  "LC_COLLATE_P", "LC_CTYPE_P", "LEADING", "LEAKPROOF", "LEAST", "LEFT",
  "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", "LOCALTIME",
  "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "MAPPING", "MATCH", "MAXVALUE",
  "MINUTE_P", "MINVALUE", "MODE", "MONTH_P", "MOVE", "NAME_P", "NAMES",
  "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NONE", "NOT", "NOTHING",
  "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NULLS_P", "NUMERIC",
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "ON", "ONLY", "OPERATOR",
  "OPTION", "OPTIONS", "OR", "ORDER", "OUT_P", "OUTER_P", "OVER",
  "OVERLAPS", "OVERLAY", "OWNED", "OWNER", "PARSER", "PARTIAL",
  "PARTITION", "PASSING", "PASSWORD", "PLACING", "PLANS", "POSITION",
  "PRECEDING", "PRECISION", "PRESERVE", "PREPARE", "PREPARED", "PRIMARY",
  "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "QUOTE", "RANGE",
  "READ", "REAL", "REASSIGN", "RECHECK", "RECURSIVE", "REF", "REFERENCES",
  "REINDEX", "RELATIVE_P", "RELEASE", "RENAME", "REPEATABLE", "REPLACE",
  "REPLICA", "RESET", "RESTART", "RESTRICT", "RETURNING", "RETURNS",
  "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROW", "ROWS", "RULE",
  "SAVEPOINT", "SCHEMA", "SCROLL", "SEARCH", "SECOND_P", "SECURITY",
  "SELECT", "SEQUENCE", "SEQUENCES", "SERIALIZABLE", "SERVER", "SESSION",
  "SESSION_USER", "SET", "SETOF", "SHARE", "SHOW", "SIMILAR", "SIMPLE",
  "SMALLINT", "SNAPSHOT", "SOME", "STABLE", "STANDALONE_P", "START",
  "STATEMENT", "STATISTICS", "STDIN", "STDOUT", "STORAGE", "STRICT_P",
  "STRIP_P", "SUBSTRING", "SYMMETRIC", "SYSID", "SYSTEM_P", "TABLE",
  "TABLES", "TABLESPACE", "TEMP", "TEMPLATE", "TEMPORARY", "TEXT_P",
  "THEN", "TIME", "TIMESTAMP", "TO", "TRAILING", "TRANSACTION", "TREAT",
  "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE", "TRUSTED", "TYPE_P", "TYPES_P",
  "UNBOUNDED", "UNCOMMITTED", "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN",
  "UNLISTEN", "UNLOGGED", "UNTIL", "UPDATE", "USER", "USING", "VACUUM",
  "VALID", "VALIDATE", "VALIDATOR", "VALUE_P", "VALUES", "VARCHAR",
  "VARIADIC", "VARYING", "VERBOSE", "VERSION_P", "VIEW", "VOLATILE",
  "WHEN", "WHERE", "WHITESPACE_P", "WINDOW", "WITH", "WITHOUT", "WORK",
  "WRAPPER", "WRITE", "XML_P", "XMLATTRIBUTES", "XMLCONCAT", "XMLELEMENT",
  "XMLEXISTS", "XMLFOREST", "XMLPARSE", "XMLPI", "XMLROOT", "XMLSERIALIZE",
  "YEAR_P", "YES_P", "ZONE", "NULLS_FIRST", "NULLS_LAST", "WITH_TIME",
  "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", "'%'",
  "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", "','", "';'", "':'",
  "'{'", "'}'", "$accept", "prog", "stmt", "CreateRoleStmt", "opt_with",
  "OptRoleList", "AlterOptRoleList", "AlterOptRoleElem",
  "CreateOptRoleElem", "CreateUserStmt", "AlterRoleStmt",
  "opt_in_database", "AlterRoleSetStmt", "AlterUserStmt",
  "AlterUserSetStmt", "DropRoleStmt", "DropUserStmt", "CreateGroupStmt",
  "AlterGroupStmt", "add_drop", "DropGroupStmt", "CreateSchemaStmt",
  "OptSchemaName", "OptSchemaEltList", "schema_stmt", "VariableSetStmt",
  "set_rest", "set_rest_more", "var_name", "var_list", "var_value",
  "iso_level", "opt_boolean_or_string", "zone_value", "opt_encoding",
  "NonReservedWord_or_Sconst", "VariableResetStmt", "SetResetClause",
  "FunctionSetResetClause", "VariableShowStmt", "ConstraintsSetStmt",
  "constraints_set_list", "constraints_set_mode", "CheckPointStmt",
  "DiscardStmt", "AlterTableStmt", "alter_table_cmds", "alter_table_cmd",
  "alter_column_default", "opt_drop_behavior", "opt_collate_clause",
  "alter_using", "reloptions", "opt_reloptions", "reloption_list",
  "reloption_elem", "AlterCompositeTypeStmt", "alter_type_cmds",
  "alter_type_cmd", "ClosePortalStmt", "CopyStmt", "copy_from",
  "copy_file_name", "copy_options", "copy_opt_list", "copy_opt_item",
  "opt_binary", "opt_oids", "copy_delimiter", "opt_using",
  "copy_generic_opt_list", "copy_generic_opt_elem", "copy_generic_opt_arg",
  "copy_generic_opt_arg_list", "copy_generic_opt_arg_list_item",
  "CreateStmt", "OptTemp", "OptTableElementList",
  "OptTypedTableElementList", "TableElementList", "TypedTableElementList",
  "TableElement", "TypedTableElement", "columnDef", "columnOptions",
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr",
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption",
  "TableConstraint", "ConstraintElem", "opt_no_inherit", "opt_column_list",
  "columnList", "columnElem", "key_match", "ExclusionConstraintList",
  "ExclusionConstraintElem", "ExclusionWhereClause", "key_actions",
  "key_update", "key_delete", "key_action", "OptInherit", "OptWith",
  "OnCommitOption", "OptTableSpace", "OptConsTableSpace", "ExistingIndex",
  "create_as_target", "opt_with_data", "CreateSeqStmt", "AlterSeqStmt",
  "OptSeqOptList", "SeqOptList", "SeqOptElem", "opt_by", "NumericOnly",
  "NumericOnly_list", "CreatePLangStmt", "opt_trusted", "handler_name",
  "opt_inline_handler", "validator_clause", "opt_validator",
  "DropPLangStmt", "opt_procedural", "CreateTableSpaceStmt",
  "OptTableSpaceOwner", "DropTableSpaceStmt", "CreateExtensionStmt",
  "create_extension_opt_list", "create_extension_opt_item",
  "AlterExtensionStmt", "alter_extension_opt_list",
  "alter_extension_opt_item", "AlterExtensionContentsStmt",
  "CreateFdwStmt", "fdw_option", "fdw_options", "opt_fdw_options",
  "DropFdwStmt", "AlterFdwStmt", "create_generic_options",
  "generic_option_list", "alter_generic_options",
  "alter_generic_option_list", "alter_generic_option_elem",
  "generic_option_elem", "generic_option_name", "generic_option_arg",
  "CreateForeignServerStmt", "opt_type", "foreign_server_version",
  "opt_foreign_server_version", "DropForeignServerStmt",
  "AlterForeignServerStmt", "CreateForeignTableStmt",
  "OptForeignTableElementList", "ForeignTableElementList",
  "ForeignTableElement", "AlterForeignTableStmt", "CreateUserMappingStmt",
  "auth_ident", "DropUserMappingStmt", "AlterUserMappingStmt",
  "CreateTrigStmt", "TriggerActionTime", "TriggerEvents",
  "TriggerOneEvent", "TriggerForSpec", "TriggerForOptEach",
  "TriggerForType", "TriggerWhen", "TriggerFuncArgs", "TriggerFuncArg",
  "OptConstrFromTable", "ConstraintAttributeSpec",
  "ConstraintAttributeElem", "DropTrigStmt", "CreateAssertStmt",
  "DropAssertStmt", "DefineStmt", "definition", "def_list", "def_elem",
  "def_arg", "aggr_args", "old_aggr_definition", "old_aggr_list",
  "old_aggr_elem", "opt_enum_val_list", "enum_val_list", "AlterEnumStmt",
  "CreateOpClassStmt", "opclass_item_list", "opclass_item", "opt_default",
  "opt_opfamily", "opclass_purpose", "opt_recheck", "CreateOpFamilyStmt",
  "AlterOpFamilyStmt", "opclass_drop_list", "opclass_drop",
  "DropOpClassStmt", "DropOpFamilyStmt", "DropOwnedStmt",
  "ReassignOwnedStmt", "DropStmt", "drop_type", "any_name_list",
  "any_name", "attrs", "TruncateStmt", "opt_restart_seqs", "CommentStmt",
  "comment_type", "comment_text", "SecLabelStmt", "opt_provider",
  "security_label_type", "security_label", "FetchStmt", "fetch_args",
  "from_in", "opt_from_in", "GrantStmt", "RevokeStmt", "privileges",
  "privilege_list", "privilege", "privilege_target", "grantee_list",
  "grantee", "opt_grant_grant_option", "function_with_argtypes_list",
  "function_with_argtypes", "GrantRoleStmt", "RevokeRoleStmt",
  "opt_grant_admin_option", "opt_granted_by", "AlterDefaultPrivilegesStmt",
  "DefACLOptionList", "DefACLOption", "DefACLAction",
  "defacl_privilege_target", "IndexStmt", "opt_unique", "opt_concurrently",
  "opt_index_name", "access_method_clause", "index_params", "index_elem",
  "opt_collate", "opt_class", "opt_asc_desc", "opt_nulls_order",
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list",
  "func_args_with_defaults", "func_args_with_defaults_list", "func_arg",
  "arg_class", "param_name", "func_return", "func_type",
  "func_arg_with_default", "createfunc_opt_list", "common_func_opt_item",
  "createfunc_opt_item", "func_as", "opt_definition", "table_func_column",
  "table_func_column_list", "AlterFunctionStmt", "alterfunc_opt_list",
  "opt_restrict", "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt",
  "oper_argtypes", "any_operator", "DoStmt", "dostmt_opt_list",
  "dostmt_opt_item", "CreateCastStmt", "cast_context", "DropCastStmt",
  "opt_if_exists", "ReindexStmt", "reindex_type", "opt_force",
  "RenameStmt", "opt_column", "opt_set_data", "AlterObjectSchemaStmt",
  "AlterOwnerStmt", "RuleStmt", "RuleActionList", "RuleActionMulti",
  "RuleActionStmt", "RuleActionStmtOrEmpty", "event", "opt_instead",
  "DropRuleStmt", "NotifyStmt", "notify_payload", "ListenStmt",
  "UnlistenStmt", "TransactionStmt", "opt_transaction",
  "transaction_mode_item", "transaction_mode_list",
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option",
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item",
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt",
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", "CreateDomainStmt",
  "AlterDomainStmt", "opt_as", "AlterTSDictionaryStmt",
  "AlterTSConfigurationStmt", "CreateConversionStmt", "ClusterStmt",
  "cluster_index_specification", "VacuumStmt", "vacuum_option_list",
  "vacuum_option_elem", "AnalyzeStmt", "analyze_keyword", "opt_verbose",
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt",
  "ExplainableStmt", "explain_option_list", "explain_option_elem",
  "explain_option_name", "explain_option_arg", "PrepareStmt",
  "prep_type_clause", "PreparableStmt", "ExecuteStmt",
  "execute_param_clause", "InsertStmt", "insert_rest",
  "insert_column_list", "insert_column_item", "returning_clause",
  "DeleteStmt", "using_clause", "LockStmt", "opt_lock", "lock_type",
  "opt_nowait", "UpdateStmt", "set_clause_list", "set_clause",
  "single_set_clause", "multiple_set_clause", "set_target",
  "set_target_list", "DeclareCursorStmt", "cursor_name", "cursor_options",
  "opt_hold", "SelectStmt", "select_with_parens", "select_no_parens",
  "select_clause", "simple_select", "with_clause", "cte_list",
  "common_table_expr", "opt_with_clause", "into_clause",
  "OptTempTableName", "opt_table", "opt_all", "opt_distinct",
  "opt_sort_clause", "sort_clause", "sortby_list", "sortby",
  "select_limit", "opt_select_limit", "limit_clause", "offset_clause",
  "select_limit_value", "select_offset_value",
  "opt_select_fetch_first_value", "select_offset_value2", "row_or_rows",
  "first_or_next", "group_clause", "having_clause", "for_locking_clause",
  "opt_for_locking_clause", "for_locking_items", "for_locking_item",
  "locked_rels_list", "values_clause", "from_clause", "from_list",
  "table_ref", "joined_table", "alias_clause", "join_type", "join_outer",
  "join_qual", "relation_expr", "relation_expr_list",
  "relation_expr_opt_alias", "func_table", "where_clause",
  "where_or_current_clause", "OptTableFuncElementList",
  "TableFuncElementList", "TableFuncElement", "Typename",
  "opt_array_bounds", "SimpleTypename", "ConstTypename", "GenericType",
  "opt_type_modifiers", "Numeric", "opt_float", "Bit", "ConstBit",
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter",
  "CharacterWithLength", "CharacterWithoutLength", "character",
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval",
  "opt_timezone", "opt_interval", "interval_second", "a_expr", "b_expr",
  "c_expr", "func_expr", "xml_root_version", "opt_xml_root_standalone",
  "xml_attributes", "xml_attribute_list", "xml_attribute_el",
  "document_or_content", "xml_whitespace_option", "xmlexists_argument",
  "window_clause", "window_definition_list", "window_definition",
  "over_clause", "window_specification", "opt_existing_window_name",
  "opt_partition_clause", "opt_frame_clause", "frame_extent",
  "frame_bound", "row", "sub_type", "all_Op", "MathOp", "qual_Op",
  "qual_all_Op", "subquery_Op", "expr_list", "func_arg_list",
  "func_arg_expr", "type_list", "array_expr", "array_expr_list",
  "extract_list", "extract_arg", "overlay_list", "overlay_placing",
  "position_list", "substr_list", "substr_from", "substr_for", "trim_list",
  "in_expr", "case_expr", "when_clause_list", "when_clause",
  "case_default", "case_arg", "columnref", "indirection_el", "indirection",
  "opt_indirection", "opt_asymmetric", "ctext_expr", "ctext_expr_list",
  "ctext_row", "target_list", "target_el", "qualified_name_list",
  "qualified_name", "name_list", "name", "database_name", "access_method",
  "attr_name", "index_name", "file_name", "func_name", "AexprConst",
  "Iconst", "RoleId", "role_list", "SignedIconst", "NonReservedWord",
  "unreserved_keyword", "col_name_keyword", "type_func_name_keyword",
  "reserved_keyword", "statements", "statement", "CreateAsStmt", "$@1",
  "at", "ECPGConnect", "connection_target", "opt_database_name",
  "db_prefix", "server", "opt_server", "server_name", "opt_port",
  "opt_connection_name", "opt_user", "ora_user", "user_name",
  "char_variable", "opt_options", "connect_options", "opt_opt_value",
  "prepared_name", "ECPGCursorStmt", "ECPGExecuteImmediateStmt",
  "ECPGVarDeclaration", "single_vt_declaration", "precision", "opt_scale",
  "ecpg_interval", "ECPGDeclaration", "$@2", "sql_startdeclare",
  "sql_enddeclare", "var_type_declarations", "vt_declarations",
  "variable_declarations", "type_declaration", "$@3", "var_declaration",
  "$@4", "$@5", "opt_bit_field", "storage_declaration", "storage_clause",
  "storage_modifier", "var_type", "enum_type", "enum_definition",
  "struct_union_type_with_symbol", "$@6", "struct_union_type", "$@7",
  "s_struct_union_symbol", "s_struct_union", "simple_type",
  "unsigned_type", "signed_type", "opt_signed", "variable_list",
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare",
  "ECPGDisconnect", "dis_name", "connection_object", "execstring",
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using",
  "using_descriptor", "into_descriptor", "into_sqlda", "using_list",
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output",
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader",
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem",
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems",
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item",
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem",
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem",
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off",
  "ECPGSetConnection", "ECPGTypedef", "$@8", "opt_reference", "ECPGVar",
  "$@9", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames",
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColId",
  "type_function_name", "ColLabel", "ECPGColLabel", "ECPGColLabelCommon",
  "ECPGCKeywords", "all_unreserved_keyword", "ECPGunreserved_interval",
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind",
  "char_civar", "civar", "indicator", "cvariable", "ecpg_param",
  "ecpg_bconst", "ecpg_fconst", "ecpg_sconst", "ecpg_xconst", "ecpg_ident",
  "quoted_ident_stringvar", "c_stuff_item", "c_stuff", "c_list", "c_term",
  "c_thing", "c_anything", "DeallocateStmt", "Iresult", "execute_rest",
  "ecpg_into", "ecpg_fetch_into", "opt_ecpg_fetch_into", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
      61,    60,    62,   745,    43,    45,    42,    47,    37,    94,
     746,    91,    93,    40,    41,    46,    44,    59,    58,   123,
     125
};
# endif

#define YYPACT_NINF -4326

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-4326)))

#define YYTABLE_NINF -2577

#define yytable_value_is_error(Yytable_value) \
  (!!((Yytable_value) == (-2577)))

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const int yypact[] =
{
   -4326,   812, 16980, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, 24119, -4326,
   -4326, -4326, -4326, -4326, 94541,   828, -4326, -4326, -4326, 99374,
   -4326, -4326, -4326,   428, 64238, -4326, 67124,   876, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, 70491, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, 53644,  1206, -4326,
     474, -4326, -4326, -4326, -4326, -4326, -4326, -4326,   882, 13286,
   -4326, -4326, 67605, -4326,   216, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, 68086,   495, -4326, -4326,   734,  1216, -4326,   121,
   14322, -4326, -4326, 60871, 65200, -4326, -4326, 70972,   457,  1937,
   13181,   882, 23635, 71453, -4326,  1099, -4326, 50235, -4326, -4326,
   -4326, 64719, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, 78187,  2320,   645, 50725, -4326, -4326,
   -4326, -4326, 78187, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, 71934, -4326,   840,   711, 78668, 79149, 62314,
   -4326,  1287, -4326, 78187,   960,   211, 52680, -4326, 79630, -4326,
   -4326,  1002, -4326, 72415, -4326, -4326, -4326, -4326,   645, -4326,
   53644, 49271,    24,   968, -4326, -4326, 80111, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326,  1818,  1012, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326,   495, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326,   341, -4326,  1026,
     638,  1741,  1006,  1094, -4326, -4326, -4326, 24943, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, 95975,  2007, -4326, -4326, -4326,
    1046, -4326,  1186, -4326, -4326, -4326,  1317, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326,  1251, -4326, -4326, -4326, -4326,  1699,
   95019, 70491, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, 60390, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326,   192, -4326, -4326, -4326, -4326, -4326, 70491, 70491, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, 70491,  1358, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326,   406,  1504, -4326, -4326,
   53644,  2289,  2289,  1838, 95975, -4326, -4326, -4326, 54608, 78187,
   78187, 78187,  1505, 78187, 78187,    73, 54608,102681, 80592,  1626,
   44848, -4326,102681, 78187, 81073, 78187, 72896, 78187,  1484, 78187,
   78187,103094, 81554,  1736, -4326,  1988,  1552, -4326, -4326, -4326,
   78187,  8715,  2320, -4326, -4326, 78187,  1635, 54608, 78187,  1579,
   78187,  1684, 78187, -4326, 78187, 82035,   279,  1627,102681,  1934,
   45342,  1779,102681, 78187, 78187, 78187, -4326, -4326,  1795, 78187,
   78187, -4326, -4326,103507,  1200,  2000,  1952,   540, -4326, -4326,
    2130,  1721, -4326, -4326,  2179, 70491, -4326, 68567, -4326, -4326,
   -4326,  2137, -4326, -4326, -4326, -4326, -4326,100616,  1937, -4326,
   -4326, 55090, 78187,  2034, -4326, -4326, 82516, -4326, -4326,   287,
   55572,103920,  2143, 45836,  2173,104333, 82997, -4326, -4326, 83478,
   -4326, 83959,  1932, 84440, -4326,104746, -4326,  2056, 84921, -4326,
   21052, -4326,  1832,  1842,  1841,  1340, 70491, 70491,  1320, 97279,
     495, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,   270,
    1805, 51215,   795, 51705, -4326, -4326,  1003,  1441,  1467,   270,
    2247,  2247,   637, 70491, -4326, -4326,  1805, -4326,   360,   -59,
    1847,  1847,  1847,  2070,  -118, -4326,  1847, -4326, -4326, -4326,
   -4326, 72415, 51215, 51705, -4326,  1902,  2320,   152,  2317, 78187,
   -4326, 78187, -4326, 78187, 78187, -4326, -4326, -4326,  2335,  1978,
    2150, -4326,  2019, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
    2157,  2166,  2204,    77,  2320,  2113, -4326,  2340, -4326,  2224,
   29107,   -84, 70491,  2320, 52195, 73377, 92136,   180,100616,  2320,
   85402,  2073,  1460,  2240, -4326, -4326,   671, -4326,  2462,  2088,
    2313,   506,  1552, 42414, -4326,  2095,  1035, 72415, 96453, -4326,
   -4326, -4326, -4326,   251,  2379, 29606, -4326, 78187,  2106, -4326,
    2103,  2118,  2128,  1741, -4326, 78187,   679,   679,  2513,   679,
    1861,  1946, -4326,  1769, -4326,  2417,  2381, 72415,   968,   882,
    2141, -4326, -4326, -4326,  2158, -4326,  2151,  2160, -4326,   469,
    2399, -4326, -4326, -4326, -4326,  2254,  2259,  2263,  2269,  2199,
    2280,   214, -4326, -4326, -4326, -4326,  2467, -4326, -4326, -4326,
   -4326, -4326, -4326,  2595,  2594, 99790, 99790,   713,   743,   140,
     245, -4326, -4326, -4326,  2463, -4326, -4326,  2458, 78187,  2315,
   78187, -4326, -4326, -4326, 85883, -4326, -4326,  2289,  2158,  2231,
   -4326,   194, -4326,  1035, -4326,   271,   371,   392,  1431,  2256,
    1700,  1857, -4326,   630,  2349,   141,   -30,  2293, 73858,  4823,
    2249,   296,  2563,  5579,   214, -4326, 78187, 78187, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326,  2281, -4326, -4326,
    2283,  1302,   856,  2589,  7974,  1443,  2590,  5720,  1851,   708,
    2481,  1571,  2583,  2060,  2599,  6080, 78187,  2306, -4326,  2540,
    2646,   -36, -4326,   598, -4326,  2392,  2528,  1143, 54608,  2367,
   -4326, -4326, 78187, -4326, -4326, -4326, -4326,   308, 54608, -4326,
    2555, 46330, -4326, 78187, -4326, -4326, -4326, -4326, -4326,  2490,
   78187, -4326, -4326,  2622, 78187, -4326,  1847,   293,  2374,  2770,
   57982,   191, 78187,  2439,  2807,  2612,  2439,  2450, 86364, -4326,
   -4326,  2439, -4326, -4326, 78187, 78187,  2423,  1931,  2439,  2814,
    2819,  2497,  2604,   742,  1217,    96,  2717,  2439, 78187, 86845,
   78187, 78187,  2802, 54608, 78187, -4326,  2613, 74339, -4326,  2448,
    2130, -4326, -4326, -4326, -4326, -4326,  1218, -4326, -4326, -4326,
   -4326,  2746,  2231,   255,  2766,  2475,  2771, -4326,  2524, -4326,
    2774,  2249,  2789, -4326,  2495, 87326, 87807, 88288,  2798,  2281,
  102681,  2824,  2495,  2827,  2694,  2840,   255,  2844, -4326,   757,
    2853,  2742,  2856,  1824,  2495,101029,  2860,    81, -4326, 21965,
   21052, -4326, 25134,  1630, -4326, -4326, -4326, -4326, -4326, -4326,
   33099,   766,  2647, -4326, -4326, -4326,  1987, -4326, 98537, -4326,
    1320,  1805, -4326, 70491,  1805, 70491,   637,  1805, 70491,  1805,
   70491,   637,  1805, 70491, 70491, 70491,  1805, -4326, -4326,  1179,
    1991, -4326, -4326, -4326, -4326, -4326, 70491,  2569, 78187, 78187,
   -4326, -4326, -4326, 65681,102681, 66162, -4326, -4326,   208, 70491,
   -4326, 70491, -4326,  2320, -4326, -4326,  1842, 57982,  2965,102681,
    2851,  2851,  2851, -4326, -4326, -4326,  2792, 78187,  2854,  2857,
   65681,102681, -4326, 88769,100616,  2754,  2577, -4326, -4326, -4326,
   -4326,  1996,  2835,   142,  2855, 33099,  2578,   257,   257,  2581,
    2864, -4326, -4326, -4326,   413,  2584,  2585, -4326,   422,   422,
    2744,  2588,  2591, -4326,   433,  2593, -4326,  2873,   441,  2596,
    2597,  2598,  2125,   257, 33099, -4326,  2600,   422,  2601,  2609,
    2610,  2898,  2614, -4326,  2912,  2615,   347,   358,  2616,  2618,
   -4326,  2588, -4326,   230,  2619,  2620,  2621,  2626,  2627,  2629,
    2631,  2632, 33099, 33099, -4326, 28109,  1035,  2320, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326,    72, -4326,   477,  5078, -4326,
   -4326,  2759, 33099, -4326, -4326,   172, -4326,   516, -4326, -4326,
    1035, -4326, -4326,  1376, -4326, -4326, -4326, -4326,  1771,  1771,
     195, -4326, 67605, 67605, -4326, -4326,   990,  2587, -4326,  1804,
   -4326, -4326, -4326, -4326, -4326, -4326,100203,  2989, -4326,  1038,
    2320,   598,  1015,  2935, 97695, 98116,  2836,  2836,  2842, -4326,
   -4326, 78187, -4326, -4326, 33099, 48307, -4326,  1035,    54,  2868,
   -4326, -4326, -4326,  2016, -4326, -4326, -4326,   495, -4326, 13765,
   -4326,  2028,  2106, 78187, 78187,  3030, -4326, -4326,  2103, -4326,
   -4326,  1741,  1741, 33099,  1741,   106,  1283, 30105, 33099,  2919,
    2821,  1400,  1421,  2921, -4326,  1861,  1946, 72415, 78187, 89250,
    2749, -4326, -4326,  2158,  2651,  1620, -4326, 59909, 95497, 95497,
    2886, -4326, -4326,  1235,   851,  2764,  2858,  2247,  1180,  1314,
   -4326, -4326,  2649, -4326,  2974, 67605,  2709, 99790, -4326, -4326,
   78187, -4326, -4326, 74820, -4326, -4326, -4326,  1350,  2659, -4326,
    2676, 78187,  3153, -4326,  1314,  1314, -4326, -4326,  2662, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, 95975,  2666, 78187,
   -4326,  2668,  2669, -4326, 96453, 48789,  1830,  1035,  2745,  2747,
    2791, 53644,  2672,  2751,  2752,  2799,  2753,  2755, 92617, -4326,
   -4326, -4326, -4326,  1746,   725,  1436,  2757,   227,   945,  3036,
   -4326,  2810, -4326, -4326, -4326,  3875, 78187,  2979,  6687,  2872,
     214,  2803, -4326, -4326,  2916,  2768,  2769,  2887,   214,   915,
   93098, -4326, -4326, -4326, -4326, -4326, -4326,  3334, 26638, -4326,
    2773,  2750, 78187, 61352,  3059,  2884,   911,   767,   364, 78187,
    2956,  2892, 78187,  2710,  2783,  2788,  2715,  1395,  3066,  2714,
   -4326, -4326,  2885,  2776,  2785, 57018,   569, 46824,  3048,  2805,
   -4326,  1409,  2818,  2820, 78187,   214, -4326,  3123,   214,   214,
    1408,  3125,  2823,   313,  1820,  2439,  2714,  1734, -4326,  2825,
    2830,  1005, -4326,  2926, 72415,   145,  1940,  2714,  2831,  2838,
    2715,  2715, 78187, 78187, 78187, 78187, 78187,   125,  3150,  3154,
    2841,   153,  2891,  2772, -4326,101442,  2848, 92136, -4326, -4326,
   78187,  2850,  2082,  2714,  1522, -4326,  1566, -4326, -4326, -4326,
    1552, -4326, 78187, -4326, 78187,  2231, 57982,  2957,  2813, -4326,
    2249,   214, 78187, 78187,  2281,  1151,   869,  2959, 78187,  3019,
    2822, -4326, -4326,  2439, -4326, 48789,  2423, -4326,  2790, -4326,
    2834, -4326,  2834,  2834,  2795,  2795,  2796, -4326, -4326,  2125,
    2834,  2795, -4326, 58946, -4326,  1315,  1556, -4326,  3187,  3193,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,  1515,
   -4326,  2045, -4326, -4326, -4326, 78187, 53644, -4326,  3204, -4326,
   -4326, 57982,  3091, -4326, 78187,  2994,  2801, -4326,  3127,  2859,
   -4326,  2846, -4326,102681,  1171,  2320,  2849, 78187,  3021, 78187,
   78187, 78187, 78187, -4326, -4326,  2998,   736,    31, -4326,101442,
   -4326,  1734,  3014,  3223,   410,  1847,  3114, -4326, 78187,  2845,
    3229,  3067, -4326, -4326,  2839,  2247, -4326,  2448, -4326,  1844,
   -4326,  2958, -4326, 54608,   255, -4326, -4326, -4326, -4326, 57982,
   78187, 89731, 54608,   255,102681,102681,  3138,    81,  3139,  2900,
    3141,  2902, 46824,   255,   123,102681, 78187, 78187, 78187, -4326,
   78187, -4326, -4326, -4326, -4326, 78187, 78187,102681,101442,  3143,
    3144,   255, 78187, 78187, -4326, -4326, 22835,  1674, -4326, 21052,
   -4326, 13765,  2054,  2836, -4326,  1358, 78187,  1276,  1320,101855,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, 70491, -4326,
   70491,   637, -4326, -4326, 70491, -4326, 70491,   637, -4326, 70491,
   -4326, -4326, -4326, 70491, 78187,  3343,  2852, -4326,  1376, -4326,
   78187,  2078, -4326, -4326,  2083,   652, 78187, 78187,   588, 54608,
   78187,  3042, 78187, 78187, 78187, 78187, 78187,  2932,  2587,   299,
   -4326,   486, 72415,  3050, -4326, -4326, -4326, -4326, -4326,  2084,
    1818,   693, -4326, -4326, -4326, -4326, -4326, -4326, 66162, 64719,
    3137,   199, 78187, -4326, -4326,  3382, 33099, 28608, -4326, -4326,
   -4326,  2862, 13765,  2901, 33099, -4326, -4326, 33099,  2867,  2247,
    2247, 33099, -4326, -4326, -4326, -4326,  1533,  2247, -4326, 33099,
   33099,  2247,  2247,  2834,  2834, -4326,  9086, 33099, -4326, 46824,
   33099, 34596, 26138, 33099,  2940,  2888,  2247, -4326,  2247, -4326,
   33099, 27610, -4326, 33099,  3070, 35594, 33099,  1015,  3072, 33099,
    1015,  3287,  3287,   968,  2987,  5524,  2871,  1035, -4326,  2985,
    2247, -4326,  2247,   827,   238, 57982, 33099, 53644,  2955,   161,
   78187, 33099,  2881,  1521, -4326, 33099,   941, -4326,  2882, 33099,
    2964, 33099, 33099, 33099, 33099, 33099, 33099, 33099, 33099, 33099,
   -4326, 36564,   352, -4326,   -86,  1774, 66643, 29107,  3159, -4326,
   25638, -4326,   338, 70491, -4326, -4326,  1035, -4326, -4326, -4326,
   -4326, -4326,  1350,  2889, -4326,  2897, -4326, -4326, -4326, -4326,
   -4326, 78187,  2989, -4326, -4326,  2967, -4326, -4326, -4326, -4326,
     528, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,  2890,
   -4326, -4326, -4326, -4326,  2890, -4326, -4326,  2836,  2896,  5157,
   -4326, -4326, -4326, -4326,  3161,  3162,   255, 95975, 78187,   251,
   69048, -4326, 29606, -4326,  2092, -4326,  2903, -4326,  3140, -4326,
    2904, -4326, 10958,  3140, -4326, -4326,   178,  3083,  3089,  3089,
   -4326,  2906, 13765, -4326,  2036, 13765,  2052, -4326, -4326, -4326,
   -4326, -4326, -4326,  1125, -4326,  2919,  1421,  2966,   867, 78187,
   -4326, 42899,  1919, -4326,  2158, -4326, -4326, 22969, -4326, 24597,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,  2905,
   -4326, -4326, -4326, -4326,   214,  2911,  3385, -4326, 99790, -4326,
   -4326, -4326,  3343, -4326,  2179, -4326,  2179,  3406, -4326, 70491,
   -4326, -4326, -4326, -4326,   917, -4326, 21052, -4326, 21052, -4326,
    2927,  2096,  2991,  2996,  3039,102681, 78187, 78187, -4326, 53644,
  102681, 78187, 78187,102681, 78187, 78187, -4326,  3281,  1326, 64719,
    3052, 62795, -4326, -4326,  2945, 78187,  2999,  3177,  3181,   -73,
   -4326, -4326, 90212, -4326,  3142,102681, 78187, 78187, 33099,  3146,
   78187, 78187, 78187,  3026, 54608,  2954, 78187, 78187, 78187,   454,
   54608, 47318, 78187, 78187, 78187, 78187,  3076, 78187, 78187,  3184,
    1623, 72415,   129,  2155,  2714,  3149, -4326,  1031, -4326,102681,
   78187,  3148, -4326, -4326, -4326, 63276,  3350,  3063, -4326, -4326,
   93579, -4326, -4326,  3145, -4326, -4326, 58946, -4326, -4326,  2122,
   -4326, 58464, 56054, -4326, -4326,  1567,102681,102681,  6790, 78187,
    1198, -4326, -4326, 57982, -4326, 78187, 78187, 78187, 69529, 90693,
   91174,  1464,  1470, 78187, 70010, -4326, 78187, -4326, -4326, 54126,
  102681, 78187, 53644, -4326, 78187,  3151,   662, -4326, 78187,  2843,
    3038, 78187, 78187,  2968,  2127,  3049,  3093, -4326, 78187,102681,
    2391, -4326,102681, 78187,  9464, -4326, -4326,   214, -4326, -4326,
   -4326, -4326, -4326, 78187, 78187,   214, 78187,   214,  1291, -4326,
  102681, 78187, -4326, -4326, -4326,  6890, 78187, 78187, 78187, 78187,
  102681, 78187, -4326, -4326,  1585,  1063,  1162,  1392,  3112, 78187,
    2320, 78187, 91655,102681, 78187, 78187, 78187,  1427, -4326, -4326,
    3090, -4326,102681,  2391,  6955, 78187, 78187,  3055,  3057,    95,
    3132, -4326, -4326, -4326, -4326, -4326, -4326,  3222,  3386, 78187,
   -4326,  3231,  3233,  3053,  3058,  3235,  1675, 78187, 78187, 78187,
   78187, 78187, 78187,  3240,  1675,  3188,   633,  3008,  2147, -4326,
    3022, -4326, 33099,  3407, 57982,  3012,  3015,  3088, -4326,  3092,
    2247, -4326,  2152, -4326, -4326,  2161, -4326,  3028,   736,  1559,
   -4326, 78187,   554,    29,  3308, 39988,  3129,  3166,  3298, 78187,
   78187,  3166, -4326,  2057, 64719, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326,  3299, -4326,  2320,  2423,  2423,  2423,
    2423, -4326, -4326, -4326, -4326,  3205,  1877, -4326,  3023,  2423,
   78187,  3136,  3166, -4326,  1734,  3319,  3321, 78187, 61833,  1977,
    3065,  2320,  3209, -4326, 27124,  5043,  3213,100616, 74339, -4326,
    3040,  3303,  3304,  3316, -4326,  2231, -4326,  3437, -4326,  3336,
     255,  2249, -4326,  2495, -4326, 78187, -4326, 78187, 78187, 78187,
   78187,  2281, -4326, -4326,  2495,  3226,   255,   255, -4326,  3227,
     255,  2495,  3158,  3330,100616, -4326,    81, -4326, -4326, -4326,
   -4326, -4326, 33099, -4326, -4326,  1847,  1844, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, 70491,  2179,
   -4326,  2167, -4326, 78187, -4326,  3307,  3310,  3311,  3056,  3060,
    3087, 78187,  3061, -4326,  3056,   214,  3056,  2587,  2587,  3056,
    3060,102268,  3465,  3331,   576, -4326,   692,   965,  3265, -4326,
   -4326, -4326, -4326, 57982, -4326, -4326, -4326, -4326, -4326, 78187,
     124,  3242,  3062,102268,  3444,   255, -4326, 54608, -4326, -4326,
   -4326,  3152, 54608,  3252, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326,  3301, 78187,  2180, -4326,  1306, -4326,  1756, 33099, 33099,
      64, -4326, 12322,  2187, 33099,  3069,  3078,  2202, -4326, -4326,
   -4326, -4326, -4326, -4326,  3080,  3358, -4326, -4326,  3085,  2227,
    2243,  3094,  3095, -4326, -4326,  4127,  3096, 12519,  3097, 34596,
   34596,  1787, -4326, -4326, 34596,  3098, -4326,  2244, 11006,  3099,
    3100,  3105, -4326,  3103,  3108, 12468, 30604, 33099, 30604, 30604,
   12662,  3099,  3109,  2252, 53644,  3253, 13097,  2253, -4326, 33099,
   53644,  5435, 33099, -4326, 33099, 78187,  3116,  3120, -4326, -4326,
    9086, -4326,  3155, -4326, 34596, 34596, -4326,  2216, 28109, -4326,
   -4326,  3367, -4326, -4326,  1716, -4326,  3122, -4326, -4326,  3543,
     179, 33099,  2881, 33099,  3197, 46824, 10380, 33099,  3683,  7642,
    7642,   473,   473,   135,   135,   135,  1708,  1774, -4326, -4326,
   -4326,  3126,  2614, 33099, -4326,  2298,  2351, 78187,  9028, 10008,
   11870, -4326, -4326, -4326, 38047,  3164, 33099, 33099, 33099,  3128,
    3302,  3545, 13765,   783, -4326,  3546, -4326, -4326, -4326,   378,
    3406,  1350, -4326,  1552,  2247,   827, 98537, -4326, -4326, -4326,
   33099, -4326, -4326, -4326, -4326,  2103, -4326, -4326, -4326, -4326,
   -4326, 78187,  1818, 33099, -4326, -4326,  2015,  1981, 33099,  2036,
   -4326, -4326, 78187,  3050,  3050, 33099, -4326, -4326, -4326, -4326,
   -4326, 38047,  3171,  3182, 41929,  3266, -4326, -4326, 78187,   171,
   -4326, -4326, -4326,  3168, -4326, -4326, -4326,  1719, -4326, -4326,
   -4326, -4326, -4326, -4326,  3135, -4326,  3160, -4326,  3169, -4326,
   -4326, -4326, -4326,   170,  3157,  3167,  3163,  1177, -4326, -4326,
  102681, 78187, 78187, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326,  3360, -4326,102681,102681,  3326, 78187,  3338,
    3337, 33099,   735, 78187,  3165,  3172,  1240,  3415, 78187, -4326,
    3461,   255, -4326, -4326,  3245, -4326, 13765, -4326, -4326, -4326,
   -4326,100616, -4326,  2231, 57982, -4326, -4326, -4326,  3206, 78187,
   -4326, 78187, 78187,  2281, -4326, -4326, -4326, -4326,   938, -4326,
   -4326, 78187, 78187,    32,  3247,  3248, 78187, -4326,   507,  2926,
    7569, 78187, 78187, 78187,  3421, -4326, -4326, -4326, -4326,  3368,
   -4326, -4326,  2045, -4326, 56054, 58464, -4326, 58464, -4326,  2045,
    1834, -4326,  2495,  3255,  2714, -4326,  3354,   750, -4326, -4326,
   -4326, -4326, -4326,  3474,   255,  3480,   255, 78187, 78187, 78187,
   78187, -4326, -4326, -4326, -4326, -4326, 53644, 53644, 53644,  2274,
   -4326, -4326,  2320, -4326, -4326, -4326,  2275, -4326,  1479, -4326,
   -4326, -4326, -4326, -4326, -4326,102681,  1856, -4326,   166, 57982,
   -4326, 57500,102681, 78187, -4326, -4326,  3408,  3351, -4326,  1767,
    3353,102681,  3249, -4326, -4326, -4326, -4326,  3267,  2165,  2714,
    1734, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,   207,
    2171,  2714,  3269, -4326,  3270, -4326, -4326, -4326,  3409,  3410,
    3411,  3271,  3277,  3324,  3282,  3283,  3329, -4326,  3285,  3332,
    3288,  3335,  3291,   255, 57982,  1992,  3314,  3512,   255, -4326,
    3296, -4326, -4326,  3612, -4326, 78187, -4326,  3300,  2194,  2714,
   -4326, -4326,102681, 78187, -4326, -4326, -4326,  1675, 57982,  3459,
    1675,  1675, 78187, 78187,  1675, -4326, -4326, -4326,  3460,  3463,
    3464,  3466,  3468,  3469,  1675, -4326, -4326, -4326, -4326,   293,
   53644, -4326,  2806, -4326,  2137, 44354,  5868,  3232,  3015,  3236,
    2247, 40474,  1212,  3442,  3238, -4326, -4326, 53644, 44354,  1910,
    3458,  3256,  3256,  3256,  3256,  3256,  3256,  3256, -4326,  3246,
    2439,100616, 78187,100616, -4326,    29,  3354, 78187, -4326, -4326,
    2305, -4326, 78187,102681,   580,102681,  2247, -4326, -4326,  3315,
   -4326,  1847,  1171,  3383,  1312,  3582, -4326, -4326, -4326, -4326,
   -4326, 78187, 78187,   736,  2320, -4326,  3254,  3250, -4326, 78187,
   78187, 78187,  1818,  3258, 78187,  3261,  3263, -4326, -4326, -4326,
   -4326, 57982,   -39,  3445,  3436,  2715,  3662,  3345, 78187, -4326,
    2314,    60, -4326,  2320,100616, 56536, -4326,  4306, -4326, -4326,
     755,  3542, -4326, 78187, -4326, -4326, 41444,   255, 57982, 78187,
   -4326,   255,    81,  3328,   255,  3340,   255,   255, 78187, -4326,
   -4326, 78187, -4326, 78187,101442,   255, -4326, 13765,  3558, -4326,
   -4326, -4326, -4326,  3397,  3398,  3403, 78187,  3056, 54608, -4326,
    3286,102681,  1473, -4326, -4326,  3462, -4326, -4326, -4326, -4326,
   -4326,  3580,  3584, -4326, -4326, -4326,102681, 65681,   132,102681,
   -4326,  2231, -4326,  2249,   214, 78187,  3527, -4326, -4326, -4326,
    3317,  2325, 13050, 33099, -4326,  3594, 57982, -4326,  6235, -4326,
   -4326, -4326, -4326, 33099, -4326, -4326, -4326, -4326, -4326, 33099,
   -4326, 33099,  3572, -4326,  3712,  3712, 57982, 34596,  1187,  2601,
   34596, 34596, 34596, 34596, 34596, 34596, 34596, 34596, 34596, 37063,
     556, -4326, -4326, 33099, 33099,  3583,  3572, -4326, -4326,  1442,
    1442, 57982,  3305,  3099,  3312,  3313, 33099, -4326, -4326,  2330,
   36079,  3318, 53644, -4326, 33099, 11503,  2342,  3342, 13747,  1035,
    6469, -4326,  3673,  2320, 33099,  2272,  2295, 33099,  2343, 33099,
    3588, -4326, -4326, -4326,  3322, -4326, -4326, 57982, 33099, 34596,
   34596,  4938, -4326,  6798, 33099,  3320,  7778, 28109, -4326,   645,
     645,   645,   645, -4326, 78187, 78187, 78187, 37562, 75301,  3323,
    1950, -4326, 75301, 75782, -4326,  3325,  1035, 33099,  3586,   699,
     699,  3327,  3302, 43384, -4326, 33099,  1185, 31103,  3333, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326,  3341, -4326,  3346, -4326, -4326,   598,
    3339, -4326, -4326, 10697,   170, -4326, -4326,  3344, -4326,  3347,
   -4326,  1981, -4326, -4326, -4326,  7244,  3495,  2587, -4326, -4326,
   -4326,  3323, 31602,  3266, -4326,  2353, -4326, -4326, 29107, -4326,
   -4326,  2357, 42899,  3171, 29606,  1035,  2247,  3349, -4326,  2179,
     378, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,  3256,
    2495,  2495,   966,  3056,  3608,   966,  7292, -4326, -4326, 38532,
   78187, 78187, -4326, 78187,  2358,  1619, 78187, -4326, 78187, -4326,
   -4326,  3725, 78187, -4326,  3389,  3390, -4326, 78187, 78187, 78187,
   78187, -4326, -4326,  2256, -4326, -4326,102681, 78187, -4326, -4326,
   -4326,   219,  2225,  2714, -4326,  3413, -4326, -4326,  3591,  1876,
   -4326, -4326, -4326,  3414, 78187,  3348, -4326,   709,  2715,   754,
   -4326, -4326,  3418, 78187, -4326, 78187, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, 54126, -4326, -4326, -4326, 53644,
   44354, 53644, -4326,  3417,  3424,  3473,  1202,   954,  3429,  3430,
    3476,  3357,  3359,  3361, -4326, -4326,   270,  2320, -4326, -4326,
    2320,  2495,  2320, 78187, 78187, 78187, 78187, 78187, 78187, 78187,
    3622,    74,  1901,102681, 78187, 78187,102681, 78187, 78187, 78187,
   78187, 78187, 78187, 78187, -4326,  3719,  2320,  2320,  3693,  3431,
   78187, -4326, 78187,  2926, 78187, 78187, -4326, -4326, -4326,  3363,
    1675, -4326, -4326,  3607,  3609, -4326,  1675,  1675,  1675,  1675,
    1675,  1675, -4326,   241,  2377, -4326, 96866, -4326, -4326,  2807,
    2320,  2807,   819, -4326,  2807, -4326,  2807, -4326, -4326,  3022,
    3347,  2247,  1314, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
    2247,  2006,  3374, -4326, 40959, -4326, -4326, -4326,  2241,   827,
   -4326, -4326, 78187,  3256, -4326,  2603,  2337,  2720,  2739, 76263,
   76744, 77225,  3376, 78187, 78187, 34596, -4326,  1127,   127, -4326,
    3611, 78187,  3416, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326,  2801, -4326, 78187,  3354,  2495,102681,102681,  2495, -4326,
   57982,  3065,  1340, 86845,  3412,  3381,  3658, -4326,  3387,  3384,
   -4326, -4326, 78187,  3354,   746,  1841,  3420, 63757,  1977, -4326,
    3639, 61833, -4326, -4326, -4326,  3745,  3475, -4326,  1818,  2320,
    2999, -4326, 56054, 33099, 33099, -4326,  3388, -4326,  3394,  5472,
   -4326,  2423, -4326, -4326, -4326, -4326, -4326, -4326,  3470, 78187,
    3813, -4326, -4326, -4326,  3396,   255, -4326, -4326, 78187, -4326,
   78187, -4326, -4326,   255,   255, -4326,  3508, -4326,  1818, 78187,
   78187, 78187,  3056, -4326,   214, -4326,  3670,102268, -4326, -4326,
   -4326, -4326,   199,  3676, -4326, -4326,  3636,  3638,  3640,  3641,
    1802, -4326, -4326, 33099, 13765, -4326,  3419, -4326, 13765,  7346,
   13765,  3583, -4326,  1047,  3680, -4326,  1404,  3425,  1047,  1160,
    1160,   455,   455,   115,   115,   115,  3712,   556, 13765, 13765,
   -4326, -4326, -4326, -4326,  3423, -4326, -4326, -4326,  3099, -4326,
   33598,  3548,  3786, -4326, -4326, -4326,  3447,  3449,  3428, -4326,
   33099, 34097,  3427, 58946, -4326, -4326,   827,  1641, 34596, 34596,
    2611, -4326,  1296, 33099, 57982,  2380,  2611,  2734,  3156, 33099,
   33099,  8217,   425, 33099,  7975, 78187, 78187, 78187, 78187, -4326,
   -4326, -4326, 39502,  1950,  3432, 78187, -4326,  3426, 38047,  3646,
    3581, -4326, 38047,  3581,  1611,  3581,  3649, -4326, 43869, -4326,
    3434, 25638,  1520, 13765,  3797,  3687, 33099,  3435, -4326,  3441,
    3302, -4326, 94060, -4326, -4326, 13765, -4326, -4326, 33099, -4326,
    3302,   378,  1020,  2320, -4326, -4326, -4326, 46824, -4326, -4326,
   -4326,  3615, 13765, -4326,  1818, 78187,  1035,   394,  3448, 78187,
   -4326,  3266, -4326, -4326, 21052, -4326, -4326, -4326,   270, -4326,
   -4326, -4326, -4326,  3506, 64719,  3713, -4326, 33099,  2383, -4326,
    3472,  3803,    79,  2386,  2389,  1619, -4326,  3416, -4326,  1555,
    3695,   158, -4326,   255, -4326, 57982, -4326, 78187, 78187, -4326,
   -4326, -4326, -4326,  2672, -4326, -4326, 78187, 78187, 78187, 78187,
   -4326,  3510, -4326, -4326, 53644,  3246,  3635, -4326, -4326,  3642,
     270, 78187, -4326, 57982,   255,   255, -4326, -4326, -4326,  3467,
  102681, 78187, 78187,  2247,  2247, 57982,  3452, -4326,  2247,  2247,
    3453, -4326,102681, 78187, 78187, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326,  3521, -4326, -4326, -4326, 78187,
   78187, 78187, 78187,  3742, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, 78187, -4326, -4326, -4326, 57982,
     255,   255, -4326, -4326, -4326,  3686, -4326,  1675,  1675, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326,  2439,  3768, -4326, 53644,
   -4326, 98958, -4326, -4326, -4326,  2320, -4326,  2320,  3651, 49753,
    2320,  2320,  1619,  3481,   164,  3737, -4326,  1957, 40959, 40959,
   40959, 40959, 40959, -4326, -4326,  3743,   270, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, 33099, -4326,  1411,  1047, -4326, -4326, -4326, -4326,
    3416,  1847,  3518,   554,  3578, -4326, -4326,  2495,  2495,  3523,
    3864,   752, 78187,  3778,  3517, -4326,  2320, -4326, -4326, 78187,
   61833,  3420,   143, -4326,  2393, -4326, -4326, -4326,  3515,  3436,
     821,  3482,  1977, -4326,  1228, 78187, -4326,  3520,  3763,  3490,
   -4326, 13765, 13765,  2320, 59428,  4306, -4326, 78187,  3741, 78187,
   -4326,   255, -4326,   255,   255, -4326, -4326, 78187,  3056,  3056,
    3056, -4326,  3674, -4326,   255,102268,  1802,  1802,  1802,  1802,
   -4326, -4326, -4326, 13765, -4326, -4326, -4326, 34596,  3772, -4326,
    3499, 57982, -4326,  3500,  2397,  2410, 35594,  3643, -4326, -4326,
   -4326,  8111,  3553, 13765,  3598,  3509,  3511, -4326,  1136,  1136,
    1296,  2441, -4326, 34596, 34596,  2611,  2611, 33099,  2611, -4326,
   -4326, -4326, -4326, -4326, 75301,  3514, 78187,  1950, 38047, -4326,
   -4326,  2638, -4326, 38047,  3747, -4326, 38047, 78187,  3519, 78187,
     861, 33099, 33099,  3544,  3302,  3302, -4326,  3682, -4326,  3524,
   -4326, -4326,  1314, -4326, -4326, -4326, -4326,   827,  3532, 70491,
   -4326, -4326, -4326,   968, -4326, -4326, -4326, -4326,102268,  3700,
  102268,  1619,  8557,  3416, 38532, 47812, 78187, 77706, 77706,  3661,
    3416,  3518, -4326, -4326, -4326, -4326, -4326, -4326,  3539, -4326,
   -4326, -4326,  3596, -4326, -4326, -4326,  2456, -4326, -4326, -4326,
   -4326, -4326,  3719, -4326, -4326, 44354, -4326, -4326, -4326, 39017,
   46824, -4326,  1202,  3541,  3547,   954, -4326, -4326, -4326, 78187,
    1532,  1115,  3579,  3056,  3805, -4326,  3719, -4326, -4326,  1675,
   -4326, -4326,  3008,  2320, -4326, -4326,  2459, -4326, -4326, -4326,
   78187, -4326,  3381, -4326, -4326, -4326, 54608,  3939,  3939, -4326,
    1873,  1873, -4326, -4326, -4326, 78187, -4326, -4326,  9125,  3735,
   -4326,  3518,  3757,  3804, -4326, 78187, 78187,  1818, 61833,  3354,
   -4326,  1516,  3550,  3845, -4326,  3258,  3552, -4326, -4326,  3884,
   -4326, 63757,  3731,  3475,  1173,  1173, 78187,  3436,  3678, -4326,
    3679, -4326,  1365, -4326, 78187, 38532, -4326, 58464, -4326,  2466,
   -4326, -4326,  3164, 78187,     8, -4326,  3571, -4326, -4326, -4326,
   -4326, -4326, -4326,   132, -4326, -4326, -4326, -4326,   642, 34596,
   57982,  2477, 33099, -4326, 33099, -4326,  3937, -4326, -4326, -4326,
     -20, -4326, -4326, -4326,  1136,  1136,  2611, -4326, 78187,  2489,
   -4326, 33099,  3560, -4326, -4326, 38047,  2638,  2493, 78187,  2502,
   57982,  3302,  3099, 13765, 78187, -4326, -4326, -4326,  3940,  3739,
    3302, -4326, -4326, -4326, -4326, -4326, -4326,  1473,   966,   132,
    3803,  3518, -4326,  3563, -4326, -4326, 78187, -4326,   209,   209,
   78187,  3518, -4326, -4326, 78187, -4326, 53644,  3618, -4326, 57982,
    2249,    19, -4326, 57982, 57982, -4326, -4326, 78187, 78187, 78187,
   78187, 78187,   255, -4326, -4326, -4326, -4326, 98958,  3381,  3939,
     824, -4326, -4326, -4326,  1646,  3764, -4326,   950,  3750,  3653,
    3354,  3860,  3520, -4326, -4326, -4326, -4326, 33099,  3724,  1977,
    3639, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326,  2506,  3475, -4326, -4326,  3942,  3755,  3947,
   -4326,  2512, -4326, -4326,  5472, 59428,  3893, -4326,  3632, 78187,
   -4326, -4326,  2220,  4003, -4326,   642,  2516, -4326,  2517,  2520,
    3727,  3634, -4326,  2521, -4326, 13765, 78187, -4326, -4326, -4326,
    2526, -4326,  3585, -4326,  3984, 33099,  1534, -4326, -4326,  3866,
   -4326, 77706,  3628, 46824, -4326,  1981,  1981,  1847, -4326,  1619,
   -4326, -4326, 33099, -4326,  2530, -4326,  1452,  3738,  3878,  2541,
    2542,  3060,  3637,  3060, -4326,  3056, -4326, -4326, -4326, -4326,
   -4326,  3899,  3849, -4326, -4326, -4326, -4326,   182, -4326,  3782,
    3784, 78187, -4326, 78187,  4001, -4326,  9721, 54608,  3436,  1977,
    3246, -4326, -4326,  3785, -4326,  3787,  3065, 38532,  4306, -4326,
     937, -4326, -4326, -4326, -4326, -4326, 78187, -4326, -4326, -4326,
   -4326, -4326, -4326,  2548, -4326, 78187,  3613,  3099, 32101, 32101,
    3606,102268,   209,  3614, -4326,  3619, -4326, -4326,  3757,  1619,
   13765, 54608,  3993, -4326, -4326, -4326,  3738, -4326, -4326, 78187,
    3744, -4326,   880,   880,  3934, -4326,  3684, -4326, -4326, -4326,
    1202, -4326,  3624,  3475,  3436, -4326, -4326,  3475, -4326, -4326,
   -4326, -4326,  2076, -4326, -4326, -4326, -4326, 35095,  3748,   585,
   11548, -4326, -4326, -4326, -4326,   132,  1981, 33099,  1619, -4326,
    3750,  2249, 78187, -4326, -4326,  3517, -4326,  4035, -4326,   542,
   -4326, -4326,  3452, 53162, -4326,  3475,  3164, -4326,  2100, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326,  4027, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, 10084, -4326, -4326, -4326,  3924, -4326,
   -4326, -4326,  2552, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
    1739, -4326, -4326,  1757,  2128, 32600, -4326,  1619,  3783, -4326,
   53162, -4326,  2100, -4326, 54608, -4326, -4326,  3633, 53162,  2556,
   -4326
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
    2260,     0,     2,     1,  2690,  2694,  2698,  2699,  2616,  2700,
    2701,  2666,  2667,  2668,  2669,  2670,  2671,  2672,  2673,  2674,
    2675,  2676,  2677,  2679,  2678,  2680,  2681,  2682,  2683,  2684,
    2685,  2686,  2687,  2689,  2688,  2638,  2267,  2635,  2632,  2633,
    2634,  2639,  2637,  2630,  2631,  1866,  2703,  2691,  2704,  2692,
    2693,  2695,  2696,  2665,  2697,  2705,  2706,  2707,  2702,  2710,
    2661,  2662,  2660,  2663,  2664,  2708,  2709,  2652,  2653,  2654,
    2655,  2711,  2268,  2269,  2657,  2261,  2265,  2327,  2398,  2658,
    2659,  2656,  2266,  2651,  2398,     0,  2519,  2520,  2521,     0,
    2522,  2523,  2524,  2450,  2412,  2525,     0,     0,  2526,  2527,
    2528,  2529,  2530,  2531,  2532,  2533,     0,  2534,  2535,  2536,
    2537,  2397,  2538,  2539,  2540,  2541,  2542,  2374,  2380,  2503,
       0,  2354,  2355,  2351,  2353,  2352,  2356,  2339,  1153,   527,
    1237,  1236,     0,  2163,  1153,  2119,  2120,  2164,  2121,  2122,
    2123,   249,     0,  1239,  2124,  2165,     0,  1153,  2166,   357,
     931,  2167,  2168,  2282,     0,  2125,  2126,     0,     0,     0,
     527,  1153,     0,     0,  2127,  1349,  2128,     0,  2129,  2169,
    2170,     0,  2130,  2171,  2172,  2131,  2132,  2133,  2173,  2174,
    2175,  2134,  2176,  2177,     0,     0,  1363,     0,  2135,  2178,
    2136,  2137,     0,  2179,  2138,  2139,  2140,  2180,  2181,  2182,
    2141,  2142,  2143,     0,  2144,     0,     0,     0,     0,     0,
    2183,  1153,  2145,     0,     0,  1370,     0,  2146,     0,  2184,
    2147,     0,  2148,     0,  2149,  2150,  2151,  2152,  1363,  2499,
    2375,     0,  1241,     0,  2153,  2185,     0,  2154,  2155,  2156,
    2157,  2158,  2159,  2160,  2161,  2162,     0,     0,    54,    55,
      21,    20,    26,    25,    77,    78,    44,    14,    68,    49,
     110,   109,   111,    32,    28,    62,    18,    19,    29,    33,
      51,    50,    17,    48,    72,    52,    75,    39,     8,     9,
      40,    66,    10,    41,    67,    11,    42,    12,    56,    79,
      24,    53,    76,    35,    64,    60,     7,    45,    46,    47,
      69,    70,    71,    93,    74,   105,    31,   102,    83,    84,
      99,    85,   100,     5,    86,    43,    13,    96,    95,    97,
      63,    36,    65,    94,    98,    15,    16,   101,    73,    91,
      88,   106,   104,   112,    89,    57,     3,     4,    80,    38,
       6,    23,    22,    37,    30,   108,    27,  1239,    82,    92,
      81,    87,    61,    90,   107,    59,   103,  1336,  1323,  1372,
    1335,  1348,     0,  1338,  2595,  2596,    34,  1349,   114,   115,
     120,  2264,  2316,  2317,  2318,  2398,  2349,  2350,  2343,  2359,
    2369,  2358,  2362,  2370,  2357,  2376,     0,   117,   119,   121,
     124,   118,   113,   116,   123,   128,   122,   127,   125,   126,
     129,   130,   131,  2597,  1549,  2594,    58,  2334,  2333,     0,
    2398,     0,  2627,  1878,  1879,  1880,  1881,  1882,  1883,  1884,
    1885,  1886,  1887,  1888,  1889,  1890,  1891,  1892,  1893,  1894,
    1895,  1896,  1897,  1898,  1899,  1900,  1901,  1902,  1903,  1904,
    1905,  1906,  1907,  1908,  1909,  1910,  1911,  1912,  1913,  1914,
    1915,  1916,  1917,  1918,  1919,  1920,  1921,  1922,  1923,  1924,
    1925,  1926,  1927,  1928,  1929,  1930,  1931,  1932,  1933,  1934,
    1935,  1936,  1937,  1938,  1939,  1940,  1941,  1942,  1943,  1944,
    1945,  1946,  1947,  1948,  1949,  1950,  1951,  1952,  1953,  1954,
    1955,  1956,  1957,  1958,  1959,  1960,  1961,  1962,  1963,  1964,
    1965,  1966,  1967,  1968,  1969,  1970,  1971,  1972,  1973,  1974,
    1975,  1976,  1977,  1978,  1979,  1980,  1981,  1982,  1983,  1984,
    1985,  1986,  1987,  1988,  1989,  1990,  1991,  1992,  1993,  1994,
    1995,  1996,  1997,  1998,  1999,  2000,  2001,  2002,  2003,  2004,
    2005,  2006,  2007,  2008,  2009,  2010,  2011,  2012,  2013,  2014,
    2015,  2016,  2017,  2018,  2019,  2020,  2021,  2022,  2023,  2024,
    2027,  2025,  2026,  2028,  2029,  2030,  2031,  2032,  2033,  2034,
    2035,  2036,  2037,  2038,  2039,  2040,  2041,  2042,  2043,  2044,
    2045,  2046,  2047,  2048,  2049,  2050,  2051,  2052,  2053,  2054,
    2055,  2056,  2057,  2058,  2059,  2060,  2061,  2062,  2063,  2064,
    2065,  2066,  2067,  2068,  2069,  2070,  2071,  2072,  2073,  2074,
    2075,  2076,  2077,  2078,  2079,  2080,  2081,  2082,  2083,  2084,
    2085,  2086,  2087,  2282,  2088,  2089,  2090,  2091,  2092,  2093,
    2094,  2095,  2096,  2097,  2098,  2099,  2100,  2101,  2102,  2103,
    2104,  2105,  2106,  2107,  2108,  2109,  2110,  2111,  2112,  2113,
    2114,  2115,  2116,  2117,  2118,  2300,  1867,  1875,  1876,  1877,
    2275,  2296,  2302,  2623,  2301,  1874,  2449,     0,     0,  2543,
    2544,  2545,  2546,  2547,  2548,  2598,  2599,  2600,  2601,  2602,
    2604,  2603,  2411,  2570,  2607,  2410,  2608,  2414,  2609,  2610,
    2611,  2612,  2571,  2613,  2413,  2605,  2567,  2415,  2408,  2409,
    2568,  2517,  2518,  1844,  2569,  2566,  2606,  2303,  2565,  2419,
    2418,  1313,  2622,  1843,  1314,     0,  2421,  2549,  2550,  2551,
    2552,  2554,  2553,  2555,  2186,  2187,  2188,  2189,  2190,  2191,
    2192,  2193,  2194,  2195,  2196,  2197,  2580,  2198,  2199,  2200,
    2593,  2201,  2202,  2581,  2203,  2204,  2205,  2206,  2207,  2208,
    2209,  2210,  2211,  2212,  2213,  2214,  2215,  2216,  2217,  2218,
    2219,  2220,  2221,  2222,  2223,  2224,  2225,  2226,  2582,  2583,
    2227,  2228,  2229,  2230,  2231,  2232,  2233,  2234,  2235,  2236,
    2237,  2238,  2239,  2240,  2241,  2242,  2243,  2244,  2245,  2246,
    2247,  2248,  2249,  2584,  2250,  2251,  2585,  2252,  2253,  2254,
    2586,  2255,  2256,  2257,  2258,  2259,  2590,  2591,  2592,  2579,
    2372,  2556,  2578,  2589,  2587,  2588,  2382,  2378,  2386,  2381,
       0,     0,     0,     0,  2398,  1152,  1151,  1137,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   526,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2272,     0,  1163,   332,   331,  1238,
    1219,   527,     0,  1140,   356,     0,     0,     0,     0,     0,
       0,     0,     0,   707,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   175,     0,     0,   380,   379,     0,     0,
       0,   903,   385,     0,     0,     0,     0,   515,  2281,  2276,
    2286,     0,  2279,  2280,  2565,     0,  2714,  2025,  2312,  2313,
    2712,  2073,  1315,   250,   253,   251,   252,     0,  1003,  1004,
    1006,     0,     0,  1016,   740,   741,     0,   739,   743,     0,
       0,     0,   736,     0,     0,     0,     0,   742,   734,     0,
     733,     0,     0,     0,   738,     0,   735,     0,     0,  1141,
       0,  2364,  2365,  1966,  1276,   386,     0,     0,  1349,     0,
    1239,  1246,  1256,  1251,  1253,  1252,  1254,  1250,  1255,  1879,
     842,  1893,   842,  1956,   839,   840,   842,   842,   842,  2040,
       0,     0,   814,     0,   825,  1870,   842,  1871,  2623,   847,
     441,   441,   441,     0,   846,   851,   441,  1134,  1170,  1848,
    1362,     0,  1893,  1956,   815,  1133,  2088,  1268,     0,     0,
    1020,     0,  1021,     0,  2055,  1145,   234,  2563,  2064,  2149,
    2088,  2564,   230,  2558,  2559,  2561,   204,  2562,  2560,  2557,
    1883,     0,     0,   846,     0,  1142,  1143,   800,  1369,  1367,
       0,     0,     0,  1901,     0,  1913,  1992,   227,  2051,  2056,
    2064,  2149,  2088,  2116,   184,   189,     0,   243,  2064,  2149,
    2088,     0,  1163,     0,  1339,  1449,  1839,     0,     0,  2373,
    1136,  1135,  1240,     0,  1243,     0,  1414,  2037,  1343,  1345,
    1245,  1336,     0,     0,  2263,  1234,  1366,  1366,     0,  1366,
       0,  1328,  1336,  1331,  1335,     0,     0,     0,     0,  1153,
       0,  2341,  2369,  2348,  2404,  2345,     0,     0,  2394,  2390,
    2387,  2395,  2396,  2389,  2377,  1538,  1539,  1540,  1537,  1550,
    1536,     0,  2322,  1541,  2361,  2328,     0,  2336,  2335,  2640,
    2641,  2451,  2274,  2293,     0,     0,     0,     0,     0,     0,
       0,  2420,  2422,  2424,  2384,  2383,  2379,     0,     0,     0,
       0,  2509,  2510,  2508,     0,  2505,  2507,     0,  2404,     0,
    2574,  2568,  2577,     0,  1849,  2569,  2566,  2565,     0,   750,
       0,   135,   891,     0,     0,     0,  1843,     0,     0,     0,
       0,     0,  1965,     0,     0,  1744,  1905,  1952,  1754,  1752,
    1753,  1746,  1747,  1748,  1749,  1750,  1751,     0,  1001,  1745,
       0,   135,     0,  1965,     0,     0,  1965,     0,     0,     0,
       0,     0,  1995,   135,  1965,     0,     0,     0,  1157,     0,
       0,     0,  1159,  1162,  1138,  1222,     0,  1839,     0,     0,
     784,   775,     0,   785,   776,   781,   787,     0,     0,   778,
       0,     0,   788,     0,   777,   779,   790,   780,   786,     0,
       0,   782,   783,     0,     0,  1149,   441,     0,     0,     0,
       0,     0,     0,   135,  1209,  1965,   135,     0,     0,   384,
     383,   135,   382,   381,  1905,  1952,     0,   930,   135,     0,
     177,   595,   530,     0,     0,   666,  1995,   135,     0,     0,
       0,     0,   906,     0,     0,   514,   527,     0,  2285,  2291,
       0,  2283,  2452,  2715,  2713,  2407,     0,  1007,   228,   229,
    1005,  1965,     0,   310,     0,     0,  1965,  1198,     0,   737,
    1965,     0,  1965,  1868,   170,     0,  1905,  1952,  1965,     0,
       0,  1965,   162,  1965,     0,  1965,   310,  1965,   531,     0,
    1965,     0,  1965,  1995,   164,     0,  1965,   310,   748,     0,
       0,  2645,  2649,     0,  2647,  2642,  2363,  2417,  2416,  2315,
       0,  2725,     0,  1315,  1248,  1261,     0,  1257,  1264,  1260,
    1349,   842,   841,     0,   842,     0,  2734,   842,     0,   842,
       0,  2734,   842,     0,     0,     0,   842,  1872,  1873,     0,
       0,  2733,  2731,  2732,   816,   826,     0,   848,     0,     0,
     855,   854,   853,     0,     0,     0,   856,  1453,  1291,     0,
     823,     0,   821,     0,  1131,  1148,     0,     0,     0,     0,
    1023,  1023,  1023,  1144,   233,   231,     0,     0,     0,     0,
       0,     0,  1150,     0,     0,     0,     0,  2629,  1855,  1755,
    2628,     0,  2120,  2121,  2122,  1813,     0,  2570,  2123,  2124,
    2165,  1667,  1654,  1663,  1668,  1655,  1657,  1664,  2125,  2126,
    1937,  2127,  2128,  1862,  2129,  2130,  1493,  2132,  2133,  2134,
    1659,  1661,  2135,  2136,     0,  1863,  2138,  2139,  2013,  2141,
    2142,  2144,  2145,  1665,  2147,  2148,  2149,  2150,  2151,  2152,
    1861,     0,  1666,  2153,  2155,  2156,  2157,  2158,  2159,  2160,
    2161,  2162,     0,     0,  1836,     0,  1639,     0,  1485,  1486,
    1508,  1509,  1487,  1514,  1515,  1527,  1488,     0,  1835,  1552,
    1638,  1644,     0,  1637,  1633,  1352,  1831,     0,  1634,  1851,
    1814,  1865,  1864,  2623,  1822,  1854,  1852,  1853,     0,     0,
       0,   196,     0,     0,  2498,   245,     0,   246,  1837,  2064,
     185,   226,   198,   225,   199,   197,     0,  1903,   186,     0,
       0,   187,     0,     0,     0,     0,     0,     0,     0,   239,
    1139,     0,  1451,  1450,     0,     0,  1820,  1840,   757,     0,
    1232,  1233,  1231,     0,  1228,  1230,  1242,  1239,  1827,  1826,
    1828,     0,  1344,     0,     0,     0,  1326,  1325,  1245,  1364,
    1365,     0,     0,     0,     0,     0,     0,     0,     0,  1407,
    1380,  1381,  1383,  1404,  1408,     0,  1332,     0,     0,  1455,
       0,  1415,  2262,  2404,  2405,     0,  2399,     0,  2398,  2398,
    2392,  2391,  2388,     0,     0,     0,     0,     0,     0,     0,
    2319,   509,  2321,   507,     0,     0,  2295,     0,  2299,  2297,
       0,  2444,  2447,     0,  2445,  2446,  2448,     0,  2453,  2454,
       0,     0,     0,  2636,     0,     0,  2435,  2423,  2430,  2432,
    2434,  2433,  2442,  2438,  2441,  2443,  2385,  2398,  2516,     0,
    2511,  2514,     0,  2506,     0,     0,     0,  1850,     0,     0,
       0,     0,   751,     0,     0,     0,     0,     0,     0,   134,
    1196,   236,  1194,     0,     0,     0,     0,     0,     0,     0,
    1201,     0,   168,   169,   542,   527,     0,  1965,     0,     0,
       0,     0,   963,   970,     0,     0,     0,     0,     0,     0,
       0,   964,   962,   965,   238,   974,   987,   990,     0,   881,
       0,     0,     0,     0,  1066,     0,     0,  1066,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   256,
     262,   305,     0,     0,     0,     0,     0,     0,     0,     0,
     139,     0,     0,     0,     0,     0,   494,   506,     0,     0,
       0,     0,     0,   503,     0,   135,   258,   487,   491,     0,
       0,     0,   604,   603,     0,  1066,     0,   254,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   324,   325,     0,     0,     0,   139,   161,
       0,     0,     0,   260,     0,  2329,     0,  1158,  1155,  1156,
       0,  1161,     0,  1218,     0,     0,     0,     0,     0,   789,
       0,     0,  1905,  1952,     0,     0,     0,     0,     0,     0,
     359,   338,   339,   135,   337,     0,     0,   663,     0,  1496,
    1525,  1503,  1525,  1525,  1492,  1492,  1505,  1494,  1532,     0,
    1525,  1492,  1497,     0,  1495,  1535,  1535,  1520,     0,  1477,
    1478,  1479,  1480,  1506,  1507,  1481,  1512,  1513,  1482,  1549,
    2575,  1492,  2576,  2573,  2572,     0,     0,   674,     0,  1173,
    1208,     0,     0,   536,     0,  1965,     0,   137,   708,     0,
     664,     0,   137,     0,   173,     0,   599,     0,     0,     0,
       0,     0,     0,   624,   623,     0,     0,     0,   665,     0,
     137,   490,  1965,     0,   441,   441,     0,   905,   908,     0,
       0,     0,  2289,  2284,  2287,     0,  2277,  2291,  1318,  1320,
    1319,     0,  1317,     0,   310,   308,   309,   661,  1015,     0,
       0,     0,     0,   310,     0,     0,  1965,   310,  1965,     0,
    1965,     0,     0,   310,   310,     0,     0,     0,     0,   600,
       0,   747,   745,   744,   746,     0,     0,     0,     0,     0,
    1965,   310,     0,     0,   730,  2643,     0,     0,  2646,     0,
    2366,  1765,     0,  2728,  1273,  2729,     0,     0,  1349,     0,
     215,   216,   214,  1262,   217,  1263,  1259,  1247,     0,   834,
       0,  2734,  2735,   819,     0,   829,     0,  2734,   817,     0,
     830,   827,   828,     0,     0,     0,  2730,  2614,  2620,   833,
       0,     0,   442,   444,     0,     0,  1923,  1936,     0,  1957,
    1983,  1984,  2056,  2060,     0,  2083,  2092,     0,   857,   886,
     852,     0,     0,  1301,   824,   822,  1132,  1266,  1771,     0,
    1349,     0,  1022,  1019,  1018,  1017,   232,   205,     0,     0,
       0,   888,  2055,  1147,   799,   527,     0,     0,  1642,  1643,
    1524,  1511,  1812,     0,     0,  1519,  1518,     0,     0,     0,
       0,     0,  1501,  1500,  1499,  1641,  1779,     0,  1498,     0,
       0,     0,     0,  1525,  1525,  1523,  1572,     0,  1502,     0,
       0,  1792,     0,  1798,     0,     0,     0,  1531,     0,  1529,
       0,     0,  1608,     0,     0,     0,     0,     0,     0,     0,
       0,  1556,  1557,  2571,  1639,  1765,     0,  1640,  1858,     0,
       0,  1517,     0,  1549,  1755,     0,     0,     0,     0,  1825,
       0,  1763,     0,     0,  1586,  1761,     0,  1588,     0,     0,
       0,  1754,  1752,  1753,  1746,  1747,  1748,  1749,  1750,  1751,
    1759,  1569,     0,  1834,     0,  1568,     0,     0,  1417,  1351,
       0,  1856,  1815,     0,  2621,  2624,  1635,  2495,  2494,  2493,
    2492,  2463,     0,  2457,  2458,     0,  2496,  2497,   247,   248,
     244,     0,     0,   201,   200,     0,   223,   224,   195,   222,
       0,   218,   219,   203,  1707,  1706,   202,   194,   192,   190,
     206,   208,   209,   193,   191,   242,   240,     0,     0,     0,
    1817,  1816,  1846,  1821,     0,     0,   310,  2398,  1226,     0,
    1223,  1830,     0,  1346,     0,  1841,     0,  1235,  1342,  1341,
    1373,  1374,   923,  1340,  1398,  1399,  1394,     0,  1413,  1413,
    1390,  1384,  1389,  1387,     0,  1391,  1552,  1406,  1330,  1378,
    1379,  1382,  1329,     0,  1409,  1407,  1383,  1288,     0,     0,
    1456,     0,     0,  2406,  2404,  2344,  1477,  2398,  2337,  2398,
    2393,  2325,  1543,  1544,  1545,  1546,  1547,  1548,  2326,     0,
    2323,  1542,  2324,   508,     0,     0,     0,  2292,     0,  2273,
    2298,  2429,  2538,  2461,     0,  2462,     0,     0,  2426,     0,
    2436,  2439,  2437,  2440,     0,  1477,  2617,  2512,  2617,  1477,
       0,     0,     0,     0,     0,     0,     0,     0,   752,     0,
       0,     0,     0,     0,     0,  2083,   235,  1192,     0,     0,
       0,     0,   890,   889,     0,     0,   910,     0,     0,     0,
    1204,   430,     0,   307,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   540,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     574,     0,  1066,     0,   612,     0,   972,     0,   971,     0,
       0,     0,   973,   968,   969,  2056,  2064,  2088,   237,   989,
       0,   988,   986,   945,   947,   946,     0,   949,   933,     0,
     934,     0,     0,   944,   952,   950,     0,     0,     0,     0,
    1945,   264,   277,     0,  1065,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   297,     0,   300,   299,     0,
       0,     0,     0,   304,     0,     0,     0,   303,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1002,     0,     0,
     156,   159,     0,     0,     0,   493,   505,     0,   497,   498,
     495,   499,   500,     0,     0,     0,     0,     0,     0,   492,
       0,     0,   597,   596,   602,     0,     0,     0,     0,     0,
       0,     0,  1058,  1057,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   615,   616,
       0,   617,     0,   160,     0,     0,     0,     0,     0,     0,
       0,   213,  1154,  1160,  1221,  1847,  1220,     0,     0,     0,
     791,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   343,     0,   689,
    2572,   662,     0,  1477,     0,  1473,  1469,  1538,  1537,  1536,
       0,  1483,  1492,  1489,   675,     0,   677,   680,     0,  1171,
     403,     0,   533,   574,     0,     0,     0,   166,     0,     0,
       0,   133,   177,   386,     0,   176,   178,   180,   181,   182,
     179,   183,   594,   598,     0,   529,     0,     0,     0,     0,
       0,   625,   629,   628,   632,   630,     0,   626,     0,     0,
    1465,     0,   155,   486,   489,     0,  2270,     0,   388,   472,
     317,     0,     0,   907,     0,     0,     0,     0,     0,  2290,
       0,     0,     0,     0,  1316,     0,   993,     0,  1199,  1965,
     310,     0,   991,   171,  1869,     0,   731,     0,     0,     0,
       0,     0,   995,   727,   163,     0,   310,   310,   532,     0,
     310,   165,     0,     0,     0,   524,   310,   749,  2644,  2650,
    2648,  1275,     0,  2726,  2727,   441,  1320,  1249,  1258,   831,
     838,   820,   837,   836,   818,   835,   832,  2428,     0,     0,
    2619,     0,   849,     0,   440,     0,     0,     0,   863,   864,
       0,     0,   862,   879,   865,     0,   867,   859,   858,   868,
     869,     0,     0,   888,     0,  1298,     0,  1296,     0,  1454,
    1300,  1289,  1267,     0,  1265,  1270,  1272,  1271,  1269,     0,
       0,     0,   846,     0,     0,   310,  1146,     0,   801,   802,
     807,     0,     0,     0,   808,   804,   805,   806,   809,   810,
     811,     0,     0,     0,  1775,     0,  1776,     0,     0,     0,
    1811,  1807,     0,     0,     0,     0,     0,     0,  1783,  1784,
    1785,  1782,  1786,  1781,     0,     0,  1787,  1780,     0,     0,
       0,     0,     0,  1522,  1521,     0,     0,     0,     0,     0,
       0,     0,  1611,  1644,     0,     0,  1739,     0,  1765,  1797,
       0,     0,  1533,     0,     0,     0,     0,     0,     0,     0,
    1765,  1803,     0,     0,     0,     0,  1705,     0,  1702,     0,
       0,     0,     0,  1822,     0,     0,     0,     0,  1859,  1553,
    1570,  1833,     0,  1824,     0,     0,  1554,  1577,     0,  1804,
    1604,     0,  1609,  1592,     0,  1585,     0,  1590,  1594,  1573,
    1825,  1764,     0,  1762,     0,     0,  1571,     0,  1566,  1564,
    1565,  1558,  1559,  1560,  1561,  1562,  1563,  1567,  1743,  1741,
    1742,     0,     0,     0,  1589,  1959,  1992,     0,  1363,  1363,
    1363,  1350,  1361,  1832,     0,  1460,     0,     0,     0,     0,
    1722,     0,  1769,     0,  1767,  1849,  2626,  2625,  1823,     0,
       0,     0,  1838,     0,     0,  1549,     0,   241,  1452,  1818,
       0,   755,   756,   754,  1477,  1245,  1229,  1225,  1224,  1829,
    1244,     0,  1349,     0,   921,   922,     0,   926,     0,     0,
    1392,  1405,     0,  1301,  1301,     0,  1396,  1397,  1388,  1334,
    1333,     0,  1463,     0,     0,  1285,  1278,  1457,     0,  1417,
    1303,  1305,  1306,     0,  1822,  2342,  2400,  2347,  2368,  2338,
    2371,  1551,  2320,  2360,     0,  2294,  2464,  2465,     0,  2455,
    2456,  2425,  2431,  2502,     0,  2618,     0,     0,   687,   686,
       0,     0,     0,  1092,  1025,  1070,   753,  1093,  1026,  1071,
    1094,  1027,  1193,     0,  1195,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   650,
    1965,   310,  1202,  1095,     0,  1028,   306,  1203,  1072,  1207,
    1073,     0,   541,     0,     0,   546,   547,   548,     0,     0,
     549,  1905,  1952,     0,   554,   560,   564,   555,     0,   565,
     561,     0,     0,     0,     0,     0,     0,   571,   573,     0,
       0,     0,     0,     0,     0,   966,   967,  1096,  1031,     0,
    1074,   948,  1492,   932,     0,     0,   943,     0,   942,  1492,
    1492,  1032,   167,     0,   257,   265,   580,  1068,   283,   296,
     291,   292,   290,  1965,   310,  1965,   310,     0,     0,     0,
       0,   293,   288,   289,   285,   298,  1882,  1938,  2065,     0,
     584,   586,     0,   591,   301,  1044,     0,   318,   321,   302,
     281,   284,   282,   278,   263,     0,     0,  1845,     0,     0,
     997,     0,     0,     0,   158,  1054,     0,     0,   144,     0,
       0,     0,     0,   138,   148,  1102,  1036,     0,     0,   259,
     488,   496,   501,  1040,   504,  1084,   502,  1108,  1037,  1066,
       0,   255,     0,  1038,     0,  1078,  1104,  1056,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1210,     0,     0,
       0,     0,     0,   310,     0,   696,  1068,  1965,   310,  1103,
       0,  1063,  1090,     0,   326,     0,  1055,     0,     0,   261,
    1042,  1086,     0,     0,   211,   210,   212,     0,     0,     0,
       0,     0,     0,     0,     0,   793,   764,   792,     0,     0,
       0,     0,     0,     0,     0,   758,   358,   335,   336,     0,
       0,   334,   340,   688,     0,     0,     0,  1474,  1470,     0,
       0,     0,     0,     0,     0,  1490,   676,     0,     0,     0,
       0,  1191,  1191,  1191,  1191,  1191,  1191,  1191,  1172,  1200,
     135,     0,     0,     0,   535,   573,   580,     0,   608,   611,
       0,   609,     0,     0,     0,     0,     0,   149,   136,     0,
     716,   441,   172,     0,     0,     0,   528,   673,   671,   670,
     672,     0,     0,     0,   693,   669,     0,  1464,  1466,     0,
       0,     0,     0,   390,     0,     0,   387,   391,   395,   396,
     397,   444,     0,     0,   476,     0,     0,     0,     0,   937,
       0,   955,   938,     0,     0,     0,   977,   982,   978,   958,
       0,   512,  2288,  2282,  1321,  1322,     0,   310,     0,     0,
     575,   310,   310,     0,   310,     0,   310,   310,     0,  1129,
     601,     0,   658,     0,     0,   310,   729,  1766,     0,  2427,
    2615,   850,   443,     0,     0,     0,     0,   861,     0,   510,
     866,     0,   878,   873,   875,     0,   882,  1299,  1292,  1294,
    1293,     0,     0,  1290,  1772,   728,     0,     0,   310,     0,
     883,     0,   803,     0,     0,     0,     0,  1368,  1773,  1774,
       0,     0,     0,     0,  1808,     0,     0,  1680,     0,  1656,
    1658,  1491,  1670,     0,  1504,  1681,  1682,  1660,  1662,     0,
    1756,     0,     0,  1671,  1613,  1614,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1626,
    1625,  1672,  1738,     0,     0,  1795,  1796,  1673,  1534,  1535,
    1535,     0,     0,  1802,     0,     0,     0,  1678,  1683,     0,
       0,     0,     0,  1689,     0,  1710,     0,     0,     0,  1636,
    1766,  1526,  1527,     0,     0,     0,     0,     0,     0,     0,
       0,  1610,  1593,  1587,     0,  1591,  1595,     0,     0,     0,
       0,  1579,  1605,  1575,     0,     0,  1581,     0,  1606,  1363,
    1363,  1363,  1363,  1360,     0,     0,     0,     0,  1427,  1416,
    1418,  1429,  1420,  1422,  1458,     0,  1839,     0,  1401,  1372,
    1372,     0,  1722,     0,  1645,     0,  1722,     0,     0,  2477,
    2479,  2480,  2481,  2482,  2483,  2485,  2486,  2488,  2489,  2490,
    2478,  2484,  2487,  2491,  2468,  2469,     0,  2459,  2460,   188,
       0,   220,   207,     0,  2502,  1227,  1842,     0,  1375,     0,
    1757,   926,   924,   925,  1377,     0,     0,  1412,  1411,  1410,
    1385,  1287,     0,  1285,  1280,     0,  1281,  1822,     0,  1277,
    1310,     0,     0,  1463,     0,  1309,     0,  2402,  2330,     0,
       0,  2501,  2504,  2515,  2513,  2340,  1091,  1024,  1069,  1191,
     893,   894,     0,   892,     0,     0,     0,   429,   909,     0,
       0,     0,   650,     0,     0,   433,     0,  1205,     0,   543,
     544,     0,     0,   562,     0,     0,   551,     0,     0,     0,
       0,   550,   567,   516,   568,   570,     0,     0,   569,   572,
     577,  1066,     0,   613,  1046,     0,  1088,   960,     0,  1492,
     935,   940,   941,     0,     0,     0,   403,     0,     0,     0,
     266,   276,     0,     0,   280,     0,   274,   294,   286,   295,
     287,   588,   589,   587,   583,     0,   590,   592,   315,     0,
       0,     0,  1098,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1099,  1075,     0,     0,   141,   140,
       0,   147,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   327,   312,     0,     0,     0,     0,
       0,   329,     0,     0,     0,     0,  1097,  1033,   759,     0,
       0,   760,   768,     0,     0,   761,     0,     0,     0,     0,
       0,     0,   770,   361,     0,   364,   371,   344,   348,  1209,
       0,  1209,     0,   349,  1209,   345,  1209,   342,   690,     0,
    2013,  1746,  1747,   684,   691,   681,   683,   682,   685,   650,
       0,     0,     0,  1475,     0,  2716,  2724,  2723,     0,  1549,
     678,   679,     0,  1191,  1190,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   415,     0,     0,   409,
       0,     0,   982,   402,   405,   406,   536,   539,   537,   538,
     566,     0,   607,     0,   580,   151,     0,     0,   152,   150,
       0,   317,   386,     0,     0,   631,   634,   627,     0,   692,
     694,   667,     0,   580,     0,  1276,   485,     0,   472,   422,
     468,     0,   470,   469,   471,     0,   478,   316,     0,     0,
     910,   936,     0,     0,     0,   975,   979,   976,     0,     0,
     951,     0,   959,   929,  1124,  1125,  1122,  1123,     0,     0,
    2305,  1312,  2314,   994,     0,   310,   992,   732,     0,   723,
       0,   725,   996,   310,   310,   618,     0,   525,     0,     0,
       0,     0,   860,   880,     0,   876,     0,     0,   843,   885,
    1297,  1295,   888,     0,   844,   887,     0,     0,     0,     0,
       0,  1777,  1510,     0,  1810,  1806,     0,  1653,  1778,     0,
    1790,  1789,  1612,  1791,     0,  1631,     0,     0,  1623,  1621,
    1622,  1615,  1616,  1617,  1618,  1619,  1620,  1624,  1800,  1799,
    1793,  1794,  1530,  1528,     0,  1675,  1676,  1677,  1801,  1684,
       0,  1896,  1711,  1688,  1704,  1703,     0,     0,     0,  1691,
       0,     0,  1700,     0,  1740,  1516,  1549,  1555,     0,     0,
    1578,  1805,  1596,     0,     0,     0,  1574,     0,     0,     0,
       0,  1583,  1756,     0,     0,     0,     0,     0,     0,  1354,
    1353,  1359,  1336,     0,  1429,     0,  1428,  1440,     0,     0,
    1446,  1444,     0,  1446,     0,  1446,     0,  1421,     0,  1423,
    1440,     0,  1840,  1459,     0,  1403,     0,     0,  1371,     0,
    1722,  1652,  1725,  1720,  1721,  1770,  1646,  1857,     0,  1768,
    1722,     0,     0,     0,  1819,  2500,  1347,     0,  1376,  1393,
    1386,     0,  1461,  1286,     0,     0,  1283,     0,     0,     0,
    1304,  1285,  1307,  2346,     0,  2401,  2466,  2467,     0,   899,
     900,   898,   901,     0,     0,     0,   650,     0,     0,   449,
       0,   917,   917,     0,     0,   435,   481,   982,   653,     0,
       0,     0,   651,   310,  1029,     0,   563,     0,     0,   559,
     557,   556,   558,   517,  1107,  1030,     0,     0,     0,     0,
     961,     0,   953,  1045,     0,   400,     0,   271,  1067,     0,
       0,     0,   270,     0,   310,   310,   585,   319,   320,   323,
       0,     0,     0,     0,     0,     0,   717,   700,     0,     0,
     718,   719,     0,     0,     0,   999,  1000,   998,   145,   142,
     143,   146,  1041,  1085,  1039,     0,  1079,  1050,  1048,     0,
       0,     0,     0,     0,  1106,  1062,  1083,  1105,  1060,  1081,
    1059,  1080,  1061,  1082,  1053,     0,  1468,   698,   697,     0,
     310,   310,   620,  1043,  1087,     0,   762,     0,     0,   763,
     774,   772,   771,   773,   765,   362,   135,     0,   341,     0,
     369,     0,   367,   366,   368,     0,   355,     0,     0,     0,
       0,     0,   660,     0,     0,     0,  1471,     0,     0,     0,
       0,     0,     0,  1476,  1484,   649,     0,  1182,  1181,  1180,
    1184,  1183,  1186,  1185,  1177,  1176,  1189,  1188,  1175,  1174,
    1179,  1178,     0,   407,     0,   413,   417,   418,   416,   408,
     982,   441,   480,   534,     0,   610,   605,   154,   153,     0,
       0,     0,     0,   636,   640,   668,     0,  1467,   614,     0,
     388,   485,     0,  2271,     0,   393,   398,   399,     0,   476,
     419,     0,   472,   392,     0,     0,   482,  1169,     0,     0,
     939,   956,   957,     0,     0,   982,   981,     0,   519,     0,
    2278,   310,   576,   310,   310,  1130,   659,     0,   872,   871,
     870,   511,     0,   874,   310,     0,     0,     0,     0,     0,
     813,   794,   812,  1809,  1669,  1679,  1788,     0,     0,  1632,
       0,     0,  1674,  2154,     0,     0,     0,     0,  1708,  1709,
    1690,     0,  2004,  1695,     0,     0,     0,  1860,  1602,  1600,
    1597,     0,  1598,     0,     0,  1580,  1576,     0,  1582,  1607,
    1358,  1357,  1356,  1355,  1431,  1438,     0,  1419,     0,  1445,
    1441,     0,  1442,     0,     0,  1443,     0,     0,  1438,     0,
       0,     0,     0,  1716,  1722,  1722,  1647,  1727,  1724,     0,
    1649,  2470,     0,  2473,  2471,  2472,  2476,  1549,     0,     0,
    1279,  1282,  1284,     0,  1311,  1302,  2403,  1197,     0,     0,
       0,   431,     0,   982,     0,     0,     0,   920,   920,     0,
     982,   480,   655,   654,   657,   652,   656,  1206,     0,   552,
     553,  1047,     0,  1089,  1051,   954,     0,   581,   267,   268,
     269,   272,   312,   279,   273,     0,  1100,  1034,  1076,     0,
       0,   706,     0,     0,     0,     0,  1101,  1035,  1077,     0,
       0,     0,     0,  1215,     0,   311,   312,   328,  1064,     0,
     766,   767,   343,     0,   365,   374,     0,   372,   346,   351,
       0,   353,   352,   347,   350,  1472,     0,  1013,  1013,  2717,
    2718,  2719,  2720,  2721,  2722,     0,   650,  1187,     0,     0,
     404,   480,   448,     0,   410,     0,     0,     0,   388,   580,
     635,     0,     0,     0,   695,   390,     0,  1274,   483,     0,
     389,     0,     0,   478,     0,     0,     0,   476,     0,   473,
       0,   477,     0,  1164,     0,     0,   980,     0,   984,     0,
     950,   927,  1460,     0,   523,  2304,  2308,  1014,   724,   726,
     619,   877,   884,   310,   795,   796,   797,   798,  1627,     0,
       0,     0,     0,  1685,     0,  1686,  1713,  1712,  1692,  1696,
       0,  1693,  1694,  1599,  1603,  1601,  1584,  1430,     0,     0,
    1432,     0,     0,  1434,  1436,     0,     0,     0,     0,     0,
    1843,  1722,  1400,  1402,     0,  1337,  1650,  1651,     0,  1372,
    1722,  2475,  2474,   221,  1758,  1462,  1308,   878,     0,   310,
     917,   480,   450,  2013,   451,   916,     0,   918,   923,   923,
       0,   480,   650,   545,     0,   579,     0,   314,   322,     0,
       0,   713,   701,     0,     0,   720,  1049,     0,     0,     0,
       0,     0,   310,   769,   333,   360,   370,     0,   354,  1013,
       0,  1010,  1009,   648,     0,   439,   411,     0,   459,     0,
     580,   710,  1169,   593,   637,   638,   633,     0,     0,   472,
     468,   484,   394,   403,   377,   428,   427,   424,   423,   425,
     426,   421,   420,     0,   478,   474,   475,     0,     0,     0,
    1217,     0,   911,   983,     0,     0,     0,   518,     0,     0,
     522,   513,     0,  2306,   845,  1628,     0,  1629,     0,     0,
       0,  1698,  1697,     0,  1439,  1448,     0,  1435,  1433,  1424,
       0,  1426,  1715,  1717,     0,     0,  1730,  1648,   895,     0,
     896,   920,   454,     0,   919,   926,   926,   441,   650,   432,
    1052,   582,     0,   275,     0,   704,     0,   715,   713,     0,
       0,  1211,     0,  1212,  1213,  1216,   330,   373,  1008,  1012,
    1011,     0,     0,   412,   445,   446,   447,     0,   414,   455,
     456,     0,   606,     0,     0,  1165,     0,     0,   476,   472,
     401,   467,   375,     0,  1166,     0,   317,     0,   982,   985,
    1128,   521,   520,  2309,  2311,  2310,     0,  1630,  1701,  1687,
    1714,  1699,  1437,     0,  1425,     0,     0,  1726,     0,     0,
       0,     0,   923,     0,   650,     0,   914,   913,   448,   434,
     313,     0,     0,   711,   714,   702,   715,   722,   721,     0,
       0,   438,     0,     0,     0,   457,     0,   458,   479,   709,
       0,   639,     0,   478,   476,  1167,  1168,   478,   912,   928,
    1127,  1126,  1349,  2307,  1447,  1718,  1719,  2119,     0,  2094,
       0,  1728,  1731,  1729,  1723,   310,   926,     0,   436,   452,
     459,     0,     0,   703,  1214,   640,   464,     0,   463,     0,
     461,   460,   699,   643,   378,   478,  1460,  1110,  1349,  1109,
    1111,  1119,  1116,  1118,  1117,  1115,     0,  1735,  1734,  1733,
    1737,  1736,   897,   915,     0,   650,   705,   712,     0,   462,
     466,   465,     0,   641,   644,   647,   645,   646,   376,   902,
       0,  1120,  1114,  1336,  1323,     0,   453,   437,     0,   621,
       0,  1112,  1349,  1732,     0,   642,  1113,     0,   643,     0,
     622
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -4326, -4326,  3773, -4326, -1165,   253,  2321, -1497, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326, -4326,  2960,
   -4326, -4326, -4326,  1540, -4326, -4326,   -60, -1556,  1869,  2579,
    1219, -4326, -1361, -4326, -4326,  -799,    15, -1021, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -1078,  1677,  1050,  4256,
   -4102, -4326, -1660, -3691, -4326,   459, -4326, -4326,  1622, -4326,
   -4326, -4326,   912,  -330, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326,   -52, -4326, -4326,  -502, -1819,  -117,  -122,  -366, -4326,
   -4326,   300,  -371, -1684, -4326, -3512, -4326,   -92, -4326, -4326,
   -4326,  -372, -1666,  1142, -4326,  -971, -1364,  1453,  -663, -4326,
    -257, -4326,  -712,  -611,  -609,  -672,  -497, -3703, -4095, -4020,
   -3110,  1158, -4326,   -96, -1810, -4326, -4326, -1747, -1671, -4326,
   -1079, -4326, -4326, -4326, -2983, -4326, -4326, -4326, -4326,   -74,
   -4326, -4326, -4326, -4326,   362, -4326, -4326, -4326, -4326, -4326,
   -4326, -2802,  1593,  1596, -4326, -4326, -3173, -4326, -1168, -4326,
     508, -3016,  1074, -4326, -4326, -4326,  2276, -4326, -4326, -4326,
   -4326,   366, -4326,   365, -4326, -4326, -1830, -4326, -4326, -1806,
   -4326,  1607,   896, -4326, -4326, -4326,  -684,  -746,  -736, -4326,
   -3432, -4326, -4326, -4326, -4326, -4326, -1244, -4326,   948, -3120,
   -1202, -4326, -4326,   962, -4326, -4326, -4326, -4326,  -642,  -252,
    2303, -4326,  -545,  -622, -4326, -4326, -4326,  -249, -4326, -4326,
   -4326, -4326, -4326, -4326, -1309,  9807, -1812, -4326, -4326, -4326,
   -4326, -2476, -4326, -4326, -4326, -1889, -4326,  4030,     2,    63,
   -1805, -4326,  -203,  -102,  2815, -1360, -2708,   301,  -398, -4326,
   -2009, -4326, -4326, -4326, -2599, -4326, -4326, -4326, -4326, -3456,
   -1802, -4326, -4326, -4326,   351, -4326, -4291, -3909, -4202, -3711,
   -3438, -4326, -4326, -1293, -4326, -4326, -4326, -1619,  1790, -1677,
   -4326, -2308,   353, -3716,  -986, -3246, -4326, -3621,  -482, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -1307,  -879, -4326, -4326,
    3306, -4326, -3430, -4326, -4326, -4326, -4326,  1116, -4326, -1674,
    1030, -4326, -4326, -4326, -4326, -4326,  -635,  -713, -4326, -4326,
   -4326,   175, -4326, -4326, -4326, -4326,  1672, -1184,  -980,  3173,
   -1800,  -442, -4326, -4326, -4326, -4326, -3033, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326, -1459, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326,  1982,  1983,  -105,  -194, -4326, -4326, -1478, -4326,
    -813, -4326,  2228, -4326, -4326, -4326, -4326,  1292,   202,   381,
     -70, -4326, -4326,   173, -3381,   -68, -4326, -4326, -4326, -4326,
    -400,   -64, -4326,   647, -4326, -4326, -2825, -4326,   246,   -79,
    2878,  1546,   -54,  1103,  -241,  -214,  -181,   -75,  3170,  2650,
   -4326, -4326, -4326,  -182,  1588, -4326, -1081,  -357, -4326,  1301,
    -899,  1962,  2641,  2639, -4326,  1298, -4326, -4326,  1305, -4326,
   -4326, -4326,  -895,  1970, -4326,  2644,  1989, -4326,  1293,  1299,
   -3353,   744, -3361,   239,  -962,  -332,  -171,  3199,  2652, -4326,
   -4325,   674, -4326, -3616, -2392,  -518, -2114, -1838, -4326, -4326,
   -1393,  6065, -4326, -4326, -4326,  7480,  9101, -4326, -4326, 11877,
   15818, -4326, -1262,   790, 16335,  5605, -1420, -1834, -1503, 11097,
   -2289,  1064, -2659, -4326, -4326, -4326,  -299,   802,   165, -4326,
   -4326, -4326, -4326,  -536, -2813,  -535, -4326, -4326, -4326,  -539,
   -3306,  1221, -4326,  -822, -4326, 18806,  1336, -4326, -1334, -2758,
   -2736, -1355, -1952, -4326, -4326, -4326, -4326, -4326, -4326, -4326,
   -1486, -3259,  -261,  1413, -4326, -4326,  1503, -4326, -4326, -4326,
   -1530, -1134, -2673,  1416, -2127, -4326, -1089,   701,  2104, -1030,
    5019, -1520, 15544,  -140, -2391, -1524, -1757, -4326,  1373, -4326,
    2804,  4338,  -767,  -116,  -906,  5247,  4167,  4871, -3093, -4326,
   -4326,   252, -4326, -4326, -4326,  3664,   947, -4326,  2992, -4326,
    1647,  2350, -4326, -4326,  1980,  -937,    34, -4326,  -510, -4326,
    -123, -4326, -4326, -4326,   154, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326, -4326, -4326,  2674, -4326, -4326, -1453, -4326, -4326,
   -4326, -4326, -4326,  3925,  -286, -4326,  3352,  -283, -4326, -4326,
   -4326, -4326, -4326, -4326, -4326, -4326, -4326,  2683,  2013, -4326,
    3174, -4326, -4326, -4326,   -38,  2893, -4326, -4326, -4326, -1182,
    -570,  3176,  3178,  1974, -4326, -4326, -4326, -4326, -4326, -4326,
   -4326, -4326,  1984, -4326, -4326,  1391, -2117,  1990, -4326, -4326,
     716, -4326, -4326,   267, -4326,   719, -4326,  2781, -4326, -4326,
   -4326,   758, -4326, -4326, -4326,  -579, 13284,   197,  -113,   423,
    1514, -4326,  7901, 13752,   -94,  2697,   -34, 10937, 17804,   505,
   -4326,  3917,  1993,  1624, -1001, -4326,  2185,  2290, 16753, -4326,
    -996,    28,  1054, -4326,    -2,  -658, -1175,  2988,  -735, -1935,
   -4326,  4334, -4326, -3436, -4326, -1018,  3364, -1208
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,   247,   248,  1700,  2597,  2480,  3287,  3288,   249,
     250,  1771,   251,   252,   253,   254,   255,   256,   257,  1715,
     258,   259,  1279,  1914,  2605,   260,  2356,  1055,  1056,  2229,
    2230,  2542,  2231,  2218,  1552,  2014,  1734,  1702,  1735,   262,
     263,  1546,  2210,   264,   265,   266,  1759,  1760,  1710,  1957,
    4186,  4753,  2467,  3326,  3126,  3127,   267,  1813,  1814,   268,
     269,  3239,  1853,  3241,  3242,  3777,   865,  2566,  4206,  4207,
    3764,  3765,  4213,  4486,  4487,   270,  1911,  3315,  3858,  3316,
    4284,  3317,  4285,  3318,  4286,  3269,  3823,  3824,  3825,  3319,
    4290,  4691,  3320,  2371,  4773,  2639,  2044,  2042,  4668,  4088,
    4089,  4824,  4778,  4779,  4780,  4890,  4292,  3324,  3866,  4296,
    4514,  3029,  1933,  4283,   271,   272,  2633,  1787,  1788,  2487,
    3783,  3380,   273,  1296,  3642,  4554,  4710,  4711,   274,   853,
     275,  1918,   276,   277,  2592,  3274,   278,  2383,  3042,   279,
     280,  3067,  3068,  3069,   281,   282,  3666,  4446,  1761,  3119,
    3120,  3121,  3122,  3686,   283,  1916,  1793,  2614,   284,   285,
     286,  2596,  3280,  3281,   287,   288,  2530,   289,   290,   291,
    1926,  2626,  2627,  4274,  4521,  4676,  4523,  4922,  4923,  4506,
    3625,  4102,   292,   293,   294,   295,  1897,  2585,  2586,  3784,
    1686,  1857,  2568,  2569,  3848,  3849,   296,   297,  4146,  4147,
     895,  4784,  4757,  4835,   298,   299,  4150,  4151,   300,   301,
     302,   303,   304,   948,  1347,  1348,  1692,   305,  2246,   306,
    1254,  3226,   307,  1435,  2772,  4331,   308,   982,  1372,  1373,
     309,   310,   993,  2752,   995,  2057,  3382,  3383,  3918,  2722,
    1179,   311,   312,  2733,  2755,   313,  1703,  2362,  2363,  4083,
     314,   896,  1938,  2642,  3024,  4701,  4090,  4427,  4628,  2947,
    3574,   315,   897,  1739,  2429,  2645,  3330,  3331,  2431,  2911,
    3879,  2433,  3332,  3337,  3338,  3339,  3875,  3883,  4548,  4549,
     316,  1737,  2422,   317,   318,   319,  1766,  1197,   320,   918,
     919,   321,  4661,   322,  1315,   323,  1013,  2073,   324,  2445,
    3672,   325,   326,   327,  4899,  4930,  4931,  4932,  3888,  4862,
     328,  4901,  1414,   330,   331,   332,   856,  1222,  1223,  1224,
     333,  4543,   334,   335,  2589,  3268,  3805,   336,   337,  2357,
    3014,   338,   339,   340,  1901,   341,   342,   343,   344,  1833,
     345,  1583,  1584,   346,   347,   860,  1074,  1587,  1595,   348,
     961,  1366,  1367,  1368,  2016,   349,  1418,  2744,   962,  1361,
     963,  2965,  3585,  3586,  3589,   964,  2962,   353,  2063,  2738,
    2741,   965,  2969,  2970,  2971,  2972,  2973,  3591,   966,   984,
    1306,  2653,   967,  1506,   358,   359,   360,  1083,  1078,  1079,
     362,  2188,  2901,  1001,  1601,  1040,  1090,  4038,  2260,  2261,
    2281,  2282,  1610,  1611,  2271,  2273,  2949,  2274,  2958,  2266,
    4035,  4393,  2277,  2278,  1613,  1614,  2953,   363,  2905,  3519,
    3520,  3521,  4016,  4026,  4380,  4593,  3522,  1408,  1620,  3523,
    3528,  3583,  3306,  3307,  3308,  2434,  2576,  1879,  1507,  1880,
    2583,  1508,  2108,  1882,  1509,  1510,  1511,  1885,  1512,  1513,
    1514,  1515,  2091,  2151,  1516,  1517,  2127,  1122,  1123,  2001,
    2811,  1519,  1520,  3982,  4355,  4344,  2837,  2838,  2226,  3978,
    3471,  4605,  4732,  4733,  4046,  4043,  4397,  4609,  4820,  4871,
    4872,  1521,  2891,  2180,  1199,  1522,  3786,  2182,  2831,  2913,
    2914,  2341,  2089,  2777,  2794,  2795,  2808,  3432,  2815,  2820,
    3455,  3456,  2832,  2860,  1523,  2780,  2781,  3415,  2093,  1524,
    1576,  1577,  2196,  2855,  1590,  1591,  1076,  1525,  1526,  2058,
    1065,  4589,   711,   694,  3136,  2241,  1226,   998,  1527,  1528,
    1529,  1323,  1324,  1641,   656,   695,   696,  1160,   807,     2,
      75,   968,  3312,   367,   368,   899,   900,   901,  1298,  1299,
    1943,  1946,  1646,  2319,   660,   661,   712,  4310,  4555,  4713,
     954,   369,   370,   371,   372,  1642,  2315,  1124,    76,    84,
      77,  1125,   409,   410,  2297,   373,   824,   374,  1623,  1104,
    3597,   375,   376,   377,   378,   379,   951,   380,  1106,   381,
    1107,   382,   383,   384,   385,  1114,   386,  1625,  1626,  4075,
    1627,   387,   388,   698,   699,  1359,   389,   390,  1141,  1142,
    1391,  1392,  1652,  1667,  1668,  1669,   391,   668,   392,   393,
     394,  1658,  1659,   395,  2203,  2204,  2324,  2205,   396,  2986,
    2987,   397,  3554,  3555,  4404,  3556,   398,  2199,   399,   400,
    1068,  3602,   401,   820,   402,  1155,   700,   701,   702,  1162,
     810,  1026,   713,  1164,  3123,   812,   813,   704,   705,   706,
    2036,    78,  2994,  2037,  1531,   714,  1532,  2194,  1533,  1534,
    1535,  1536,  1537,  1675,   708,  1131,  1351,  1352,  2995,  1354,
      82,  1355,   406,  3798,  2004,  1393,  2022,  2023
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      81,  1276,  1091,   361,   808,  1082,  1032,  2013,   351,  1621,
     352,  1308,  1615,   898,   354,  1547,  1967,   710,  1198,  1400,
    1401,  1402,  1973,   811,   356,  1406,  2002,   716,  1963,  1687,
      79,   910,  1910,   894,  2041,  2573,  1770,  1792,  2370,  1831,
    2723,  1928,  1640,  1569,   404,  3398,  1067,  2243,  1818,   808,
     404,   986,  1064,  1369,  1329,  2581,  1856,  1139,  1198,  2441,
     960,  2432,  2069,   858,  2690,  2102,  2103,  2129,   811,   994,
    2080,   986,  1561,  2450,  2254,  2544,   405,  2442,   912,  2582,
    1007,  3138,   405,  3648,  2118,  2919,   947,   665,  3235,  1101,
     361,  3882,  1102,   261,   854,  2606,  2463,  3534,  1899,  2631,
    3681,  1903,  3683,  3830,  2607,  1762,  1907,  1033,  2608,  2609,
    1954,  1198,  2610,  1912,  2611,   405,  2499,   808,  1307,  2430,
    2257,  2508,  1930,  3086,  3088,  2939,  1786,  3193,   697,  1797,
    2304,  2306,  2307,  4058,  3386,  2776,   811,  1823,  3801,  1670,
    2512,  2513,  1308,  3590,  1672,  1364,  1143,  1093,  3529,  3530,
    4270,   904,  3787,  1085,  4125,  4289,  1054,  2243,  2682,  4085,
     405,  4027,  4029,  4305,  4013,  3787,   697,  2348,  1332,   983,
    3479,  2146,  3531,  2028,  2418,  2298,  2298,  1998,  1344,  2003,
    1094,  2643,  2977,  4428,  2634,  2095,  2096,   902,   909,   983,
    4095,  1609,  1819,  1736,  4533,  1612,  3960,   909,  1648,  1649,
    3601,  4262,  4063,  3436,  1927,  2201,  1029,  2149,  3290,  1955,
    2244,  2115,   412,  1134,  1029,  1353,  1029, -1525, -1525, -1525,
   -1525,  2993,  4426,  2155, -1525,  2997,  4629,  4706,   405,  3806,
    3807,  3808,  3809,  3810,  3811,  2628,  1712,   909,   408,  2519,
    3873,  4756,   864,  1156,  3214,  3524,  1177,  1302,  2158,  1554,
     412,  1955,  1072,   329,  4702,    37,    38,    39,    40,  1661,
    1955,  3696,    44,  3413,    45,  3062,  3649,  2524,  3644, -2575,
   -2575, -2575, -2575,  2853,  2444,   403, -2575,  3354,  2160,  3356,
     350,   403,  1662,  3862, -2575,  1850,   412,  4721,  1828,  2015,
    2444,  2853,   361,  1397,  2892,    43,  4170,   351,  2506,   352,
      45,  3595,  3524,   354,  1431, -1520, -1520, -1520, -1520,  4258,
    1038,  1404, -1520,   356,   403,  4708,  4528,   412,  2944,  2848,
      37,    38,    39,    40,   355,  2264,    43,    44,  1437,  1663,
     366,    45, -1525, -1525, -1525, -1525,  3063, -1744,  1713, -1525,
    4435,   404,   412,  2005, -1744,  1538, -2576, -2576, -2576, -2576,
    4637,  3396,  2444, -2576,   130,   131,    45,  4222,  4227,   403,
    1551, -2576,  1844,  3697,  2444, -1520,  -750,  4842,    37,    38,
      39,    40,  2147,   405,  4652,    44,   404,  1831,  3027,  1416,
    2376,  3050,   261,  1955,  1540,  -135,  3539,  2629,  1405,  3540,
    3541,  1712, -1525,  4496,  -135,   855,  2192,  2945,  2904,  -135,
    3542,  3543,  3544,  1039,  3545,  3546,  1539, -2002,   405,  3547,
    3548,  3549,  2265, -1850, -1850, -1850, -1850,  2893,  1895,  1198,
   -1850,  4497, -1535, -1535, -1535, -1535,  2245,   403,  -363, -1535,
    3028,  1144,  2754, -1535, -1535, -1535, -1535,  1829,  2186,  1308,
   -1535,  4259,  4694,  4171,  1398,  1130, -2573, -2573, -2573, -2573,
    4529,  2888,  1267, -2573,  1956,  2061,  2129,   666,  2889,  3248,
    1318, -2573,  1308,  4709,  2462,  4722,  2451, -2572, -2572, -2572,
   -2572,  2102,  2103,  3649, -2572,  1691,  4431,  1580,  2118,  1581,
    2219,  1838, -2572,   898,  3066,  2232,  2232,  3645, -2168, -2168,
   -2168, -2168,  1178,  1713,  1630, -2168,  1956, -1492, -1492, -1492,
   -1492, -1324,  3698, -2168, -1492,  1956,  4858,  2189, -1505, -1505,
   -1505, -1505,   821,  4684,   822, -1505, -1532, -1532, -1532, -1532,
    3434,  3435,  1765, -1532, -1760,  3450,  2718,  1073,  1308,  2779,
    2724, -1760,  2726,  3699,  2630,  2729,  3215,  2555,  1158,  4822,
     809,  1102,   329,  3436,  1137,  1138,  1991,  2551,  2235,  2236,
    3874,  3550,    37,    38,    39,    40,   913,  2017,  3071,    44,
    2062,  2155,  3700,  1974,  1128,  3485,  3486,  1651,  1654,   350,
    4138,  4929,   403, -1324,  2507,  2150,  4078,  2854,  1683,  2734,
    1574,  2520,  2525,  1405,  1575,   809,  2158,  1993,  2573,  4537,
    1714,    37,    38,    39,    40,  3499,  1657,  3787,    44,  1896,
    2095,  2096,  2090,    37,    38,    39,    40,   403,  2115, -2002,
      44,  4436,  2571,   355,  3448,  1997,  2160,  2243,  2495,   366,
    2497,   904,   815,  3090,   246,  2504, -2303,  3048,  1956,  1965,
    1405,  4843,  3618,  2547,  2179,  2084,  3715,  2059,  3917,  4511,
    2404,  2406, -1744,  1135,  3436, -1525,  2543,   825,  4116,  2412,
    1308,  2202,  2071,   809,  4421,  1417,  2377,   902,  1308,  1308,
    1389,  4266,  2243,  1740,  2081,  4377,  2918,   815,  1145,  4381,
   -2002,  3251,   980,   981,  4792,  1207,  2711,  3592,  2187,  3551,
    4278,  2948,  4336,  2686,  4551, -2002,   667,   826,  2567,  1136,
    4415,  1171,  4205,  4853,  1896,  2735,  2485, -2575,  1268,  2488,
    2489,   909,   909,  1851,  1852,  1965,  1319,   808,   980,  1639,
    2320,  4741,  1582,  1028,  2062, -1324,  2285,  2090,  1082,  4041,
    2286,  1028,  4920,  1028,  3552,  1704,  1147,  1839,  3072,  2637,
    3436,  1631,  1263, -1520,  2452,   815,  1616,  3160,  2719,  1664,
    1665,  3748,  1878,  3062,  3751,  3752,  2453,  2730,  3755,  1130,
    2481,  2421,  2773,  2775,  3085,  3095,  2890,  2214,  3762,  4895,
   -1525,  2720,  2552,  2783,   980,   981,  1370,  2787,  2732,  1293,
    4236,  4597,  1389,  4599, -2576,  2799,  2800,  3661,  1599,  3662,
    1218,  3271,  1699,   823,  1304,  3387,  1317,  1253,  2817,  2819,
     404,  1143,  4500,  4501,  4502,  4503,  4504,  2454, -1327,  2833,
     914,  4049,  4621,  3131,  3558,  1965,  4908,  -135,  -135,  4631,
   -1324, -2303,     3,  2701,  3063,  3836,  3553,  2124,   405,  2704,
    3564,  1998,   405,  2694,  3438,  3006,  1167,  1705,  2124, -1760,
    1407,  3753,  3754,  4894,  1167,   665,  2125,  4896,  1362,  1574,
     665, -1850,   411,  1575,  2979, -1324,  2979,  2125, -1324,   665,
    2126,  2803,  2804,  1371,  1365,  1377,  4921,  1382,  3524,  1802,
    3237,  2128,  2364,  1386,  2418,  1167,  2736, -2303,  1219,  1093,
   -1327,  1600,  2364,  3049, -2573,  4928,   665,  1363,  2365,   915,
     665,   916,  2715,   361,  2737,  1009,  1377,  1382,  2477,  2373,
     715,   665,  1376,  1919,  1381, -2572,  1407,  1803,  1563,  2068,
    2187,  3389,  1094,  1389,  1395,  2475,  4308,  1220,  1981,  1305,
   -2577,  3279,  2444,  2638,  4066,   665, -2168,  4745,  4746,  1167,
    2449,  2622,  1294,  1410,  1412,  2101,  1619,  4128,  1167,   665,
    4909,  1920,  2366,   665,  2378,  4769,  2107,  3785,  3272,  1130,
    3884,   909,  2366,   665, -1532,  1198,  1982,  3667,    81,  2367,
    3785,  3445,  3446,  3447,  3448,  1221,   859,   665,  3837,  2367,
    4091,  1010,  3066,  2499,  2640,  2476,  1706,  2432,  1585,  2176,
    2177,  2178,  2179,  1375,  3388,  1380,  4788,  1295,    79,  1650,
    2152,  2721,  4730,  3153,  3132,  2693,  1550,  1358,  4798,   412,
    1558,   909,    37,    38,    39,    40,  2623,  1707,    43,    44,
    1437,  1663,  2577,    45,  1409,  1411,  1544,  1718,  4886,  1653,
    2147,  1427, -1327,  4587,  -578,  3885,  3273,   403,  4126,  2190,
    2558,   403,   974,  2727,  2728,  4590,  1708,  3880,  1088,  4534,
    4594,  2924,  1389,  4596,  1579,  1378,  3153,  4860,  1167,  1383,
    1384,  1385,   975,  2716,  1029,  1804,   665,  2963,  1029,  1396,
    3443,  3444,  3445,  3446,  3447,  3448,    80,   861,  2559,  3882,
    2870, -1953,  3238,  4129,  1000,  4279,   405,  1116,  4662,  4535,
    4770,  2637,  2717,  1167,  4664,  2368,  1130,  1753,   697,  1921,
      37,    38,    39,    40,  1709,  2368,  4854,    44,  1390,  3637,
    3390,  3561,   412,  2671,  1983,    37,    38,    39,    40,  2413,
    1564,    43,    44,  1369,  1830,  4857,    45, -1327,  4447,    35,
     412,  4876,  1088,    37,    38,    39,    40,    41,    42,    43,
      44,  3668,  2749,  1117,    45,  2378,  2578,  3638,  4218,  1011,
    1012,  1805,  1439,   665,   665,  3436,  3443,  3444,  3445,  3446,
    3447,  3448, -1327,   664,  3886, -1327,  3669,  2305,  3943,  1643,
    1198,  3948,  3949,  3950,  3951,  3952,  3953,  3954,  3955,  3956,
    3957,  1565,  4739,  4130,  1390,  1922,  4131,  2068,  1673,  2369,
    2224,  4790,  2624,  2208,  4219,  1008,  1427,  4859,  4774,  2369,
    1984,   357,  2414,  4148,  2871,  2625,  1701,  4887,  2872,  3255,
    1088,  1095,  1772,  2034,  1390,  2697,  4079,  2663,  4861,  1965,
    4749,  3377,   130,   131,  3887,  4036,  2560,   903,  2674,  2225,
    3997,  3998,  1643,   920,  1119,  3075,  2035,  1140,  2216,  2927,
    2681,  1439,  1941,  1773,  3436,  2873,  1167,  4396,  1701,  4768,
     974,   816,  1086,  1037,  2209,  2982,  1167,  4400,  1119,   999,
    2806,   817,  4727,   809,  4414,  1439, -1953,  2474,  3436,  4280,
     975,   412,   866,  4888,  2379,  4518,   215,  2462,  1894,   955,
      37,    38,    39,    40,  1082,   403,  1096,    44,   357, -1985,
    3659,  3187,  4685,  4390,  4196,  3639,  4889,  3090,   956,  4149,
    4199,  4200,  4201,  4202,  4203,  4204,   223,  3536,  4775,  3537,
    1087,  1167,  2561,  2447,  2019,   361,  2021,  1198,  3076,  2025,
    4049,  2027, -1953,  1868,  2030,  2031,  2032,  4826,  4827,   957,
    4256,  2579,  4399,   825,  1923,  3438,  4829,  2039,  2548,  2502,
    4686,  4632,  1108,  4324,   233,   815,  2217,  4687,   665,  2380,
    2064,  2603,  2065,  1670,  1924,  4638,   236,  2068,  1672,  1948,
     818,  2874,  1109,   665,  2448,  3391,  4673,    81,    81,  1081,
      81,  4776,  1110,   826,  4688,  1088,  3352,  4080,  1167,  3524,
    3094,  3640,  3787,  3524,  3357,  4601,   665,  3537,  3351,  3913,
    2964,  4257,  3439,  3297,  3298,  3299,  3300,    79,    79,  3944,
      79,  3945,  3785,  2590,  2155,  3305,  4081,  2258,  2259,  1949,
    2263,  2335,  4878,  2250,  1102,    43,  1643,  1948,  2193,  3184,
      45,  4666,   665,  2604,  3438,  4082,  3159,  2432,  3161,  2158,
    2301,  1664,  1665,  4538,  3392,  1894,  3164,   665,  3166,  2556,
    1094,  1094,   412,  1094,  4689,  4539,  1115,  3171,  3438,   665,
    3185,  4143,   665,  1062,  2018,  1143,    45,  2020,  4913,  2160,
    2024,  2657,  2026,  1167,  3411,  2029,  1619,  2696,   412,  2033,
    1358,  1111,  2302,  3347, -1985,  1097,  3209,  3565,  3931,  3186,
    4277,  3439,   808,  2490,  1092,  3660, -1847,  4072,   819,  1089,
     357,  1075,  1167,  2606,  2557,  2302,  2310,  1950,  1925,  2311,
     955,  2242,  2607,  4937,  4648,  3439,  2608,  2609,   215,  2499,
    2610,  1116,  2611,  3463,  4697,  3716,  3946,  4782,  3613,   956,
    1167,  1167,  4698,  1167,  2206,  2207,  3947,  4313,  2303,  4314,
   -1985,  4742,  3053,  1112,   808,  4402,  2183,  3533,   223,  1084,
    1167,  4748,  3203,  2268,  3488,  1951,  4255,  4144,  1808,  3188,
     957,  2303,   980,  1639,  3906,  1950,  1574,  3440,  3441,  3442,
    1575,  3443,  3444,  3445,  3446,  3447,  3448,  1117,  3812,  1768,
    1118,  1028,  3882,  1105,   665,  1028,   233,  2222,  3189,  2146,
     958,  4906,   665,   665, -2577,   862,  1896,  2312,   236,  1198,
    4707,   877,  1167,   405,  2269,  4540,   697,   697,   808,  1113,
    2490,  4606,  4607,  1951,  4649,  4690,  2491,  1643,  2492,  2372,
    1288,  3815,  1643,  1643,   404,   404,  4338,  2242,  4339,  1119,
    1098,  1167,   959,  1952,    35,  1167,  1167,  2317,    37,    38,
      39,    40,    41,    42,  4145,    44,  2373,  4563,  1605,  1289,
    4751,  2941,  1119,  2505,  1809,   405,   405,   405,   879,  4943,
    3443,  3444,  3445,  3446,  3447,  3448,  1034,  2849,  1119,  1605,
    2267,  2399,  1218,   404,  1574,   665,  3379,   825,  1575,  3023,
    2339, -2577, -2577,  4699,  3443,  3444,  3445,  3446,  3447,  3448,
    2456,  1952,  3863,  1290,  3624,  3867,  1807,  2313,   974,  1769,
    3092,  2991,  1808,  -157, -1492,   405,   952,   903,  3251,   697,
    3178,  2268,   405,  1894,  3605,  1607,  3179,   826,   975,   405,
    2577,  3027,  2331,  2333,   974, -2367,  1029,  3255,  -157,  4358,
    4359,  -910,  1288,  2491,  3015,  2492,  1607, -2003,  2788,   215,
    4617,  3260,  4619,  2861,   975,  2862,  4439,  4440,   825,  3524,
    4509,  4480,  4481,  4340,  3524,  3819,  4802,  3524,  1029,  2155,
    1219,  3843,  2269, -2028,  1218,  1120,  1894,  2863,  4432,   223,
       8,  1308,  1608,  3621,  1069,  2374,  3636, -1492,  1643,  2304,
      37,    38,    39,    40,  1121,  1116,  1643,    44,   826,  3190,
    3261,  3820,   886,  1894,   887,  4091,  1146,  1688,  1809,  1220,
    1753,  1699,   403,  2789,  3821,  1290,  3016,   233,  1308,  1789,
     208,  4832,  3180,   808,  2160,  2124,  1701,   892,  3191,   236,
    2174,  2175,  2176,  2177,  2178,  2179,  2155,  4737,  1689,  4433,
     827,  4098,  2587,  1643,  2125,  1817,  1643,  1643,  3408,  1140,
    1790,  1117,  2692,   665,  2578,  1029,  2464,  1221,  2126,   863,
    2658,  2158,  1219,   246,   403,   403,   403,  1690,  4098,  2790,
    2864,  4113,  2791,   949,  1894,  2865,  3262,  3263,  4833,  4020,
    2866,  3630,    37,    38,    39,    40,  3107,  2232,  3341,    44,
    3264,  2160,  3109,  2570,  1157,  3822,  3912,  1172,  2537,  3062,
    1775,  1220,  2155,  1560,  2465,  2466,  4096,  4021,  4771,  1643,
    1209,  1894,  1439,  4099,   403,  3436,  2751,    37,    38,    39,
      40,   403,  4383,  1035,    44,  3365,  4091,  2158,   403,  2538,
    4818,  2739, -2003,  4023,   405,  3265,  4674,  3108,  2462,  1894,
    4099,  3650,  1119,  3110,  1365,  1791,  1776,  1810,  3490,  1221,
    3491,   665,  2124,  1357,   412,  4819,  1255,  2160, -2028,  1556,
    2792,  3181,  3577,  2539,  4675,  3096,  4100,   665,  4101,  3671,
    3063,  2125,  3492,   361,  2540,  4403,  3524,  3845,  1811,  2699,
    2212,  2700,  3916,  3559,  1184,  2702,  3941,  2703, -2003,  2918,
    2705,  1167,  3182,  4100,  2706,  4101,  2867,  1894,  2541,  3064,
    1167,  2934,   665,   665,  1102,  4234,  2868,  1812,  2358,  3690,
    3961,  1309,   920,   665, -2028,  1086,  2750,  4117,  2359,  3917,
    3266,  3183,  3267,  1777,  3691,   665,   665, -1372,  4025,  3225,
    3065, -1372,  3653,  2360,    81,   361,  3505,    81,   809,  2579,
    2745,  4647,  2746,  4653,    80,  1661,  2747,   665,  4127,  4132,
    1216,  2771,    37,    38,    39,    40,  2748,  2793,  2580,    44,
    1308,  1574,  1217, -1850,    79,  1575,  2124,    79,  1662,  1778,
    3493,  1779,   974,  1087,  3437,  3494,  1693,  3923,  2941,  3962,
    3963,  2498,  2163,  2164,   808,  2125,  1988,  1167,  4568,  1269,
    3369,  1270,   975,  1198, -1372,  3438,  3249, -1492,   122,  2128,
    1415,   357,  1081,  2851,  1257,  2918,  1989,  1694, -1492,  1781,
    2101, -1492,  1691, -1492,  4584,  4585,   126,  1022,  3066,  1605,
     815,  3708,  1260,  1606,  1167,  1167,  2167,  1061,  1432,  3736,
   -1372,  2197,  1167,   403,  2198,  1167,  1695,  1541,  1088,  1167,
    1185,  1553,  1309,  1555,  2797,  3826,  1783,  1167,  1167,  3737,
    3927,  4019,  3439,  4875,   809,  1167,  4330,  1262,  1167,  1167,
    1167,  1167,  2361,  4172,  3570,  4671,  2294,  2295,  1167,  1167,
     215,  1167,  3968,  1167,  1167,  1308,  1999,  1167,  4091,  4416,
    2000,  1785,  3995,  4173,  1585,  4356,  1607,  3785,  1277,  3279,
    2950,  3495,  4357,  1894,  1167,   405,  3017,  1291,  3020,  1167,
     223,  3496,   877,  1167, -1371,  2601,  2342,  1167, -1371,  1167,
    1167,  1167,  1167,  1167,  1167,  1167,  1167,  1167,  4020,  1167,
    1999,  1283,  1608,  2632,  2689,  1167,  1092,  1798,  1167,   664,
     664,  4287,  3693,  1696,  1674,  2432,   815,  2343,   233,  3926,
    3302,  1159,  1292,  1028,  2496,  3303,  4021,   215,    35,  1180,
     871,   917,  1089,   404,  3011,  1297,    41,    42,  1799,   879,
    3251,  4022,  1800,  3694,  1697,  3394,  2344,  3596,   208,  1300,
    3070, -1371,  4023,  3802,  2966,  1028,   808,   223,  3303,  4703,
    1258,  2464,  3629,  4941,   246,   405,  4942,  1801,  3610,  3611,
    1167,   412,  3695,  1698,  4024,  2242,  4093,  4094,  3409,  2113,
    2114,  1596,  3410,   404, -1324,   404,  3255, -1371,  2174,  2175,
    2176,  2177,  2178,  2179,   662,   233,  1314,  3440,  3441,  3442,
    4715,  3443,  3444,  3445,  3446,  3447,  3448,   236,   877,  2465,
    2466,    35,   412,  1325,  1312,   405,  1148,   405,  1330,    41,
      42,  2154,  2839,  1321,  2155,  2842,    45,  -904,  1149,  1150,
    4215,  1854,  4217,  2651,  2652,  4220,   665,  4221,  1339,   809,
    3841,   246,  1028,  2462,  2509,  3928,  1699,  4025,  1151,  2158,
    1345,  1152,  3663,    45,    81,  2159,    81,  2101,  3144,  2349,
    3569,   950,  1643,   665,  1360,   879,   808,   405,   665,   808,
    1399,   665,   987,   886,   403,   887,  1272,  1439,  1273,  2160,
    3436,  2464,  1673,  1130,    79,  1308,    79,  1308,  3128,  4230,
    4231,  4232,   987,   665,  4121,  1831,  1167,  3988,   892,  2101,
    1439,  2349,  1167,  3436,  3711,  3293,  4897,   192,  1167,  4318,
    4319,  4320,  4032,  1403,  -386,    37,    38,    39,    40,  1309,
    3989,   815,    44,    80,    80,  4212,    80,   665,  1413,  2465,
    2466,   192,    37,    38,    39,    40,  2956,  2957,  1029,    44,
    1426,  3487,  1309,  3570,  1894,  2294,  2975,  1816,  1308,  1894,
    1894,   208, -1395, -1395,   665,   665,  3570,  4564,  4565,  4566,
    4567,  1894,  1419,  2462,   403,  1153,  3322,  3323,  4037,  4039,
    1424,  4228,  4229,  4230,  4231,  4232,  1817,   405,   665, -2577,
     405,  4499,    35,  2162,  1425,   215,  2536,  2066,  3572,  3573,
      41,    42,  3827,   357,  3829,  4224,  4225,   665,  3154,   886,
     665,   887,  1154,  1428,  2163,  2164,  3294,  4659,  1309,   215,
     889,  2008,  1429,  2009,   403,   223,   403,  2087,   665,   246,
   -2577,   891,  2243,  2464,   892,  1188,  1189,  1190,   665,  1191,
    1192,  1193,  1194,  1195,  1196,  1643,  3835,  4240,  3838,   223,
    2248,   665,  2249,  1643,  1427,  1643,  3631,  1430,  2167,  1699,
     665,  3154,  2251,   233,  2252,  3877,  2918,  2074,  2075,  3073,
    3438,  2168,  1433,  3146,  2088,   236,   403,  1436,  2101,  3714,
    1691,  2465,  2466,  3578,  3579,  3717,  3538,   233,  2691,  1559,
    2692,  2148,  1434,  3438,  2105,  3462,  1562,  3464,  3465,   236,
    1167,  2153,  1894,  4613,  1567,  4192,  2464,  1566,  3745,  4898,
     809,  2191,  2712,  1568,  2713,  2462,  2464,  2714,  2742,  2713,
    2743,  1573,  2464,  3147,  2132,  3154,  2940,  3439,  2941,  3154,
    2999,  1835,  2743,   246, -1121,  1586,  1594, -1121,  2144,  4118,
    1309,  1840,  1593,  2221,  2223,  2464, -2577,  1082,  1309,  1309,
    3439,  3701,  1596,  3703,  2465,  2466,  3083,  4547,  3084,  3922,
    3154,  3140,  1597,  3141,  2465,  2466,  4345,  4306,  1603,  4361,
    2465,  2466,  1894,  3148,  1617,   665,  2464,  1618,  1622,  4470,
    4471,  3243,  4473,  3244,  1624,  2101,   403,  2349,  2462,   403,
    1628,  1632,   815,  2465,  2466,  3256,  1939,  3257,  2462,  1629,
    1644,  3371,  2276,  2713,  2462,  1602,  3735,  1604,    37,    38,
      39,    40,   665,  1633,  3407,    44,  2692,  4214,  1634,    45,
    1167,  3417,  1635,  2692,  2465,  2466,  2154,  2462,  1636,  2155,
    3749,   664,  1637,  1645,  1092,  1092,  3421,  1092,  2692,  1638,
    2174,  2175,  2176,  2177,  2178,  2179,  3514,  3515,  3516,  1647,
    3509,   808,  3510,  1082,  2158,  1676,  1677,   808,  2462,   665,
    2159,  3425,  3149,  2692,  1685,  4228,  4229,  4230,  4231,  4232,
    3469,  1894,  1130,  4233,  1679,  1711,  3476,  3426,  3452,  2692,
    2692,   665,  1738,  1643,  2160,  1167,  3468,  3473,  2692,  3474,
    1167,  1691,  3440,  3441,  3442,  1716,  3443,  3444,  3445,  3446,
    3447,  3448,   809,  3511,  1742,  3512,  1167,  1167,  3684,  3688,
    3685,  3689,  1167,  4237,  1765,  3440,  3441,  3442,  1767,  3443,
    3444,  3445,  3446,  3447,  3448,    37,    38,    39,    40,  4019,
    1774,  1794,    44,  3096,  1806,  1815,    74,  1167,  1167,  3832,
    1820,  3833,  1167,  1825,    37,    38,    39,    40,  3871,  1439,
    3872,    44,  3436,  1826,  1167,  1167,  1167,  1167,  1827,  3932,
    3894,  2692,   405,  3150,  3969,  4321,  3970,  1167,   405,  4363,
    1167,  3151,  1167,  1832,  3152,  2503,  3979,  3991,  3980,  2692,
    4485,  1834,  1167,  1167,   815,  4492,  1167,  4064,  2162,  4065,
    1308,  4068,  4097,  4069,  2713,  4287,  4020,   361,  3570,  1167,
    1836,  1167,  2745,  1841,  2746,  1167,  1846,  1855,  2747,  2163,
    2164,  4208,   809,  4209,  4362,   809,  2743,  4423,  2748,  4424,
    4429,  1167,  2713,  4430,  4021,  2713,  1848,  4530,  3936,  4531,
    4242,  4573,  1167,  4574,  1167,  1167,  1167,  1858,  1699,  4022,
   -1496, -1496, -1496, -1496,  4575,  1900,  2692, -1496,  3942,  4244,
    4023,  1902,  1904,  2167,   665,  1028,  1896,  3767,  1167,  1913,
   -1503, -1503, -1503, -1503,  -174,  1915,  2168, -1503,  1743,  1929,
    1917,  1167,  4024,  3964,  1744,  4583,  1167,  2743, -1494, -1494,
   -1494, -1494,  1937,  1167,  1643, -1494,  1945,  1953,  1687,  1167,
    4635,  4591,  4636,  4656,   815,  4657,   841,   815,  3768,  2612,
    4704,   985,  4705, -1497, -1497, -1497, -1497,  1958,  1959,  2068,
   -1497,  4717,  1960,  2743,  1745,  1962,  4571, -1495, -1495, -1495,
   -1495,   985,  3769,  4724, -1495,  2941,  1961,  4729,   665,  3852,
    1964,  1965,  3438,   808,   808,   808,  4731,  3770,  3852,  1972,
    4791,  3771,  2211,   665,   665,  4025,  4796,  1977,  4797,  1167,
    4807,  4808,  2743,  3474,  4809,  4812,  2692,  2941,  4547,  3772,
    4814,   403,  3852,  1746,  4831,  1975,  2743,   403,  1976,   665,
    1747,  4482,  1894,  1748,  3773,  4837,  4838,  2743,  2743,  4412,
      80,  1978,  4864,    80,  2941,  1980,  4939,  4602,  4940,  3439,
    4950,  4382,  4940,  4385,  1985,  1986,  2006,  1987,  4723,  4267,
    4268,  1992,  2040,  2070,  2072,  2076,  2078,  2085,  4723,  2079,
    2086,  2094,  1894,  1894,  2097,  1894,  2098,  2099,  2100,  4592,
    2104,   246,  2184,  2211,  2106,  1749,  2109,  2215,  2227,  2110,
    2111,  2112,  1389,  2117,  2119,  2174,  2175,  2176,  2177,  2178,
    2179,   357,  2120,  2121,   405,   405,   405,  2122,  2123,  2130,
    3774,  2131,  2133,  2134,  2135,  2237,  4658,   808,  3775,  2136,
    2137,  4765,  2138,   665,  2139,  2140,  2247,  1894,  2256,  1894,
     665,  1606,  1608,  2283,   808,  2291,  3766,  2293,  2300,   665,
    1750,  1119,  1751,  2316,   987,  2314,   987,  2308,   987,  2318,
    2796,  3776,  1752,  2587,   987,  2326,  2327,  2329,  2334,  2336,
    1753, -2519,  2338,   357,  2345,  2347,  2346,  2349,  4408,  1754,
    2350,  2351,  2353,  2352,  2354,  2812,  2375,   987,   987,  2381,
    2401,  2407,  1894, -1336,  2382,  2405,  2408,  2409,  2410,  2835,
    2437,  2411,  2436,   898,  2444, -1336,  4813,  2446,  2456, -1336,
     665,  2457,  2460,  2459,  1756,  4716,  1894,  2461,  2462,  2468,
    2469,  2470,  2478,  3892,  3440,  3441,  3442,  2471,  3443,  3444,
    3445,  3446,  3447,  3448,  2479,  1198,  2472,    35,   405,  1757,
    4719,  1439,  3779,  1894,  3436,    41,    42,  2482,  2486,  2483,
    2493, -1336,  2494,  1753,  2500,   405,  1894,   809,  3856,  2501,
    2510,  4364,  3283,   809,  2521,  2859,  1082,  2511,  2522,   665,
    2523,   665, -1336,  1643,  2925,  2526,  1082,  2532,  2527,  2535,
    2549,   665,  2562,   665,  4754,  2550,  1643,  2564,  4759,  4760,
    4512,  2565,  3891,  2572,  2090,  2574,  4485,  1758,  2101,  2107,
    2575,  2588,  2591,  2594,  2595,  1308,   987,   873, -1336,  2600,
    2599,  1791,  2616,   403,   403,   403, -1336,  2621,  3146,  1894,
     662,   662,  4269,  2635,  4616,  1671,  2655,  4005,  4006,  4007,
    4008,  2636,   665,  1894,  4758,  2661,  2641,  2646,  4761,   815,
    4763,  2647,  2813,  2654,  2648,   815,  1894,  4755,  2644,  2665,
    2667,  2668,  2669,  2670,  2683,  2684,  2813,  2708,  2709,   808,
    2725,  2731,   665,  2740,  2753,  2778,  2779,  2821,  3147,   987,
    2784,  2834,   664,  2840,  2822,  2155,  1167,  2844,  3974,   665,
     909,  2845,  2852,  3812,  2858,  2875,  2904,  2921,  1674,  3813,
      80,   357,    80,  2877,   665,  2920,  2926,   665,  2923,  3814,
    2928,  4817,  2931,  2932,  1087,  2894,  2942,  2951,  2952,  2981,
    2943,  1167,  2955,  3284,  1894,  2983,  2201,  2961,  3148,  2984,
    3000,  1167,  1180,  3002,  3438,  3001,  3815,  1167,  3816,  1167,
   -1336,  2998,  1643,  3013,  1894,  1167,  3018,   403,  1167,  1167,
    1167,  1167,  1167,  1167,  1167,  1167,  1167,  1167,  3021,  3025,
    3023,  1167,  1167,  3026,   403,  3041,  3032,  3044,  3061,  1894,
    3037,  1719,  3058,  3074,  1167,  1556,  1560,  3135,  1167,  1555,
     405,  3079,  1167,  3130,  3139,  3081,  2068,  3143,  3142,  3192,
    2757,  3439,  1167,  3205,  3212,  1167,  3213,  1167,  1574,  3216,
    3217,  1596,  1575,  1720,  3218,  1894,  1167,  1167,  1167,  3220,
    3817,  3221,  1167,  3224,  3222,  1167,  4693,  3149,  3234,  3223,
    3236,  3240,  3245,  3250,  3247,  1167,  3251,  3252,  3258,  3277,
    3289,  3253,  3282,  3295,  3301,  1167,  3304,  2758,  4736,  3309,
    3310,  3311,  3328,  1167,  3325,  1167,  3340,  3343,  3346,   809,
     809,   809,  3344,  3345,  3285,  3348,  4624,  3349,  1721,  3358,
    3361,  3363,  3364,   987,  3373,  3818,  2759,  3374,  3375,  3376,
    3819,  3385,  2941,  3393,  2754,  3397,  1993,  3378,  1405,  3399,
    3404,  3402,   808,  3419,  3195,  3405,   808,  2760,   808,  1722,
    1167,  4641,  3420,  3286,  3422,  3423,  1167,  4438,  4916,  3424,
    4158,  3458,  1167,  3470,  3489,  3128,  3820,  4139,  3427,  3428,
    3430,  3433,  3451,  1198,  3457,  2692,  2761,  3459,  3150,  3821,
    3227,  2762,  3460,  3467,  1723,  4452,  3151,  1167,  3227,  3152,
    3482,   815,   815,   815,  3483,  3497,  3504,  4461,  2154,  3507,
    3527,  2155,  3532,  3570,  3533,  3535,  -950,  3582,  1198,  3584,
    3588,  3484,  3598,  1724,   665,  3609,  3440,  3441,  3442,  3612,
    3443,  3444,  3445,  3446,  3447,  3448,  2158,  2763,  3594,  3600,
    3615,  3603,  2159,   809,  3614,  3623,  3599,  3604,  3619,   403,
    3296,  4476,  3626,  1999,  3628,  3620,  3646,  3647,  3632,  3657,
     809,  3665,  3658,   405,  3664,  3673,  2160,   405,  1894,   405,
    3822,  3675,  3707,  3706,  3710,  3327,  3713,  3712,  3718,  3719,
    3723,  1309,  3720,  3721,  3722,   208,  3724,  2419,  3725,  1727,
    3738,  3726,  3727,  3728,  3729,  1728,  3730,  3731,  1643,  3732,
    3733,   665,  1729,  3740,   665,  3742,  2519,  3750,  3756,  3744,
    2420,  3757,  3758,  3790,  3759,   841,  3760,  3761,  1309,  1731,
    3791,  2311,  3799,  3803,   987,   815,  3804,  1732,  3498,   987,
     987,  1308,  3842,  3840,    74,  3844,  3852,  3043,  3851,  3865,
    2764,  3857,   815,  1180,   665,  3860,  2765,  3864,  2154,  3861,
    3868,  2155,  2766,   985,  3869,   985,  4828,   985,  3889,  3898,
    3908,  3909,  3910,   985,  1387,  1388, -2577,  3911,  3919,  3920,
    2162,  3900,  3914,  3921,  1643,  3930,  2158,  3935,  1733,  3454,
    3436,  2767,  2159,  2768,  3981,  3453,   985,   985,  2149,  3965,
    2313,  2163,  2164,  1167,  4297,  3993,  3966,  3967,  2087,  4060,
    2769,  4034,  3973,  2068,  4002,  3994,  2160, -2577,  4031,  4018,
    4084,  4040,   662,  4105,   665,   665,  4052,  4050,  1894,  4074,
    4107,  4108,  4119,  4053,  4169,  2770,  4140,  4051,  4056,  4120,
    4057,  4124,  4122,  4141,  3891,  2167,  4133,  4142,  4152,  4153,
    4154,  4155,  4185,  4156,  4825,  4157,  4128,  4195,  2168,  4189,
    1894,  1167,  1167,  2812,  2812,  4197,  4226,  4198,  2812,  4252,
    4273,  4419,   403,  4260,  4272,  3881,   403,  2713,   403,  4282,
    4276,  4275,  4291,  4294,  4303,   809,  4295,  4304,  4309,  4307,
    4311,  4317,  4322,  4325,  4326,   987,  4327,  4337,  4328,  4329,
    4346,  4347,  4379,   987,  4348,   665,  4349,  4378,  2812,  2812,
    4386,  1198,  4391,  4334,  4392,   985,  2161,  4342,  4341,  4376,
    2162,  1167,  4350,  4354,  4409,  4418,  4374,  4389,  4413,  4394,
    4420,  4425,  1643, -2577,  1666,  4395,  4426,  4434,  4445,  4448,
    4469,  2163,  2164,  4474,  4479,  4483,  4449,  4455,  4462,  4465,
     987,  2144,  4417,   987,   987,  4490,  4498,  2165,  1167,  4513,
    4505,  4515,  4517,  2384,  4516,  2859,  4520,   815,  1167,  1167,
    1309,  1894,  4522,  4495,  4532,  4536,  1167,  1167,   985,  4542,
    4544,  1167,  1894,  4545,  3508,  2167,  4553,  1167,  1167,  4569,
    4561,  1167,  4570,  4572,  4580,  4577,  2385,  3518,  2168,  4579,
    4410,   808,  4604,  4581,  4450,  4582,  1167,  4588,  4595,  2386,
    1167,  4608,  4598,  4618,  4630,  4634,   987,  4651,  4610,  1167,
    2813,  2813,  2387,  3538,  1167,  2813,  4614,  2174,  2175,  2176,
    2177,  2178,  2179,  4633,  4643,   357,  1167,  4660,  4650,  4259,
    4644,  4667,  2068,  4677,  4669,  4678,  4680,  4681,  4683,  4695,
    4696,  4712,  4720,  4726,  3518,  4735,  4743,  1081,  1088,  4752,
    2388,  4772,    81,  4777,  4781,  2813,  2813,  4783,  4787,  4793,
    4405,  4794,  3735,  2170,  4795,  1167,  4800,  4801,  4806,  4810,
    4811,  4815,  4816,  4821,  4823,  1309,   808,  4840,  4834,  2389,
    4756,  4841,    79,  1894,  2390,  4844,  4839,  4846,   809,  4850,
    4874,  4855,   809,  4856,   809,  3766,  4042,  4877,  4882,  4842,
    4507,  2068,   405,  4879,  4885,  2068,  2068,  4893,  4907,  4919,
    3401,  1894,  4935,  4843,  4938,  3403,  4948,  4944,   665,  2533,
    1100,  1741,  3292,  1894,  2234,  3562,  3134,  3670,  4137,  3204,
     665,  3763,  4654,    74,    74,  4767,    74,  4484,  4526,  4679,
    4682,  4293,  4510,  4692,  3617,  4880,  3372,  4622,  4915,  4847,
    4845,  4891,   985,  2171,  2172,  2173,  3687,  2174,  2175,  2176,
    2177,  2178,  2179,  4789,  3622,  4527,  3275,  1894,  4263,  3276,
     815,  3682,  2613,  4136,   815,  3259,   815,  4264,  4265,  3847,
    2391,  4918,  4949,  3709,  4945,  3800,  3778,   405,  4892,   665,
    4642,  2598,  2154,  4836,  4883,  2155,  4645,  1004,  4323,  4738,
    2060,  4299,  3087,  4799,  1310,  4300,  3739,  4900,   841,  4946,
    4785,  2936,  2156,  2937,  3567,  1570,  4281,  2698,  4411,  4070,
    2158,  2007,  3368,  2253,  3568,   364,  2159,  1592,  2960,  2279,
    1167,   364,  2280,  3580,  3576,  2959,   658,  2284,  2954,  2392,
    3581,  4014,  3593,  4384,  4728,  2393,  1578,  4071,  2394,  2287,
    2160,  3227,  3985,  4718,  3227,  3227,  3975,  3525,  3227,  4865,
    4873,  4866,  3571,  3414,   364,  3502,  3500,  1133,  3227,  4067,
    3890,  2903,  1947,  1854,  2395,  3342,  4863,  2650,  2985,  3788,
    2396,  1103,  1894,  2299,  1356,  3797,  2292,  2976,  2992,  2067,
    2989,  3557,  3788,  2397,  1655,  4076,  1656,  2990,  4401,  4077,
    2200,   403,  4055,   665,  2296,  1309,  1126,  1309,  2710,   364,
    4615,  2996,  1684,  3370,  3525,  1167,    83,  1996,  2398,  1894,
       0,     0,     0,     0,  1167,     0,  1394,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3850,     0,
       0,  1167,  1167,   985,     0,  1167,     0,     0,   985,   985,
    2161,     0,     0,     0,  2162,  1024,  1167,     0,     0,     0,
       0,  1167,     0,  1024,  1167,  1024,     0,  3876,  1309,  1167,
    1167,     0,     0,     0,     0,  2163,  2164,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   403,     0,     0,     0,
       0,  2165,     0,     0,  3333,   357,   665,     0,   665,     0,
       0,     0,  1167,     0,     0,     0,     0,   655,     0,     0,
    4612,     0,     0,  1719,     0,     0,  2166,     0,     0,  2167,
       0,  2309,     0,  1388,     0,     0,     0,     0,     0,   357,
       0,   987,  2168,  1894,     0,  2169,     0,  1167,     0,     0,
       0,  2323,     0,  4672,     0,  1720,     0,     0,  2330,  2332,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1643,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1167,     0,     0,     0,     0,   987,
       0,  2812,     0,   662,  2812,  2812,  2812,  2812,  2812,  2812,
    2812,  2812,  2812,  2812,     0,     0,     0,     0,     0,  1671,
    1721,     0,     0,   808,   985,     0,     0,  2170,     0,     0,
       0,     0,   985,     0,  3972,     0,     0,  3986,     0,     0,
       0,     0,   364,  1167,     0,  1894,     0,   809,     0,     0,
       0,  1722,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2812,  2812,     0,     0,  1167,  1894,     0,
    1167,     0,  1167,     0,     0,     0,     0,   364,     0,   985,
    3334,     0,   985,   985,     0,     0,  1723,     0,     0,  1167,
    4047,     0,     0,  1167,     0,     0,     0,     0,  1894,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2144,     0,     0,     0,     0,  1724,     0,  2171,  2172,  2173,
    4012,  2174,  2175,  2176,  2177,  2178,  2179,     0,     0,   815,
       0,     0,   809,  3429,   405,     0,     0,  1894,     0,     0,
       0,  1894,  1894,     0,     0,   985,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   665,     0,  4934,  2813,     0,
       0,  2813,  2813,  2813,  2813,  2813,  2813,  2813,  2813,  2813,
    2813,     0,   987,     0,     0,  1167,     0,   208,     0,     0,
     987,  1727,   987,     0,     0,     0,     0,  1728,     0,     0,
       0,  2813,     0,     0,  1729,     0,     0,     0,     0,     0,
       0,     0,  2420,  1894,     0,     0,     0,     0,     0,     0,
    4805,  1731,     0,     0,   815,     0,     0,     0,     0,  1732,
    2813,  2813,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1167,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3788,     0,     0,     0,     0,  2649,
    1167,  1180,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4159,     0,     0,  4160,     0,  4161,     0,     0,     0,
    1733,     0,     0,     0,  3336,  3881,     0,     0,     0,     0,
     808,     0,     0,     0,     0,  1167,     0,   361,     0,     0,
    4187,  4188,  4902,     0,  4903,  1167,     0,     0,  4904,  4925,
      74,     0,     0,    74,  3227,     0,     0,     0,  4905,     0,
    3227,  3227,  3227,  3227,  3227,  3227,  1167,  1167,     0,   665,
    1309,     0,     0,   361,  4216,     0,     0,   808,  4902,  1167,
    4903,     0,     0,   403,  4904,   808,     0,     0,     0,     0,
       0,     0,     0,     0,  4905,     0,  4925,     0,  3797,     0,
       0,     0,     0,     0,  4925,     0,     0,     0,     0,  4239,
    4241,  4243,  4245,     0,     0,  1167,     0,   361,     0,     0,
       0,     0,  4902,     0,  4903,  1167,     0,     0,  4904,  2812,
       0,     0,     0,     0,     0,     0,     0,     0,  4905,     0,
    3525,   405,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2785,  2786,     0,     0,     0,     0,     0,
     987,  2798,     0,     0,     0,  2801,  2802,     0,     0,     0,
       0,  4926,     0,  4298,     0,     0,     0,     0,     0,     0,
    2823,     0,  2824,  1167,     0,     0,     0,     0,   405,     0,
       0,     0,  1167,     0,     0,     0,   405,     0,     0,   365,
    1719,     0,     0,     0,  2846,   365,  2847,     0,     0,     0,
     659,     0,     0,     0,     0,     0,     0,     0,  4926,     0,
       0,   357,     0,     0,     0,     0,  4926,     0,     0,     0,
       0,     0,  1720,     0,  4332,     0,     0,   364,   365,     0,
       0,   364,  3525,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   658,     0,  2323,     0,     0,   658,
       0,   357,     0,     0,     0,     0,     0,     0,   658,     0,
       0,     0,     0,  2154,     0,     0,  2155,     0,     0,     0,
       0,     0,     0,   365,     0,     0,  2813,  1721,     0,     0,
       0,     0,     0,     0,     0,   658,     0,     0,     0,   658,
       0,  2158,  2812,  2812,     0,     0,     0,  2159,     0,   809,
     658,     0,     0,     0,     0,     0,     0,     0,  1722,     0,
     985,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2160,     0,     0,   658,     0,     0,     0,     0,     0,
     403,     0,     0,     0,     0,     0,     0,     0,   658,     0,
       0,   365,   658,  1723,     0,     0,  4406,  4407,     0,     0,
       0,   987,   658,     0,     0,     0,     0,     0,   985,     0,
       0,  3518,     0,     0,     0,  3518,   658,     0,    80,     0,
       0,     0,  1724,     0,     0,     0,     0,   403,  1666,     0,
      74,   815,    74,  3999,     0,   403,     0,     0,     0,    35,
       0,  3333,     0,     0,     0,     0,     0,    41,    42,  1725,
       0,     0,     0,  2154,     0,     0,  2155,   357,     0,     0,
    1719,     0,     0,     0,     0,  1181,     0,     0,     0,     0,
    1201, -2577,     0,  2156,     0,  2162,  2157,     0,     0,  1213,
    1726,  2158,     0,     0,   208,     0,     0,  2159,  1727,     0,
       0,     0,  1720,     0,  1728,     0,  2163,  2164,     0,  2813,
    2813,  1729,     0,  1024,     0,   658,  1271,  1024,     0,  1730,
    1278,  2160, -2577,     0,     0,     0,     0,     0,  1731,     0,
       0,  1287,     0,     0,     0,   364,  1732,     0,     0,     0,
       0,     0,  2154,     0,     0,  2155,   365,     0,     0,     0,
    2167,  3227,  3227,     0,     0,     0,     0,  1721,     0,     0,
       0,     0,  2156,  2168,     0,  1309,     0,     0,     0,  4488,
    2158,  4489,     0,     0,  4493,  4494,  2159,     0,     0,     0,
       0,   365,  3797,  3797,  3797,  3797,  3797,  1733,  1722,     0,
       0,   985,     0,     0,     0,     0,     0,     0,     0,   985,
    2160,   985,   658,   658,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   809,  3334,     0,     0,
       0,  2161,     0,  1723,     0,  2162,     0,     0,     0,     0,
    4524,     0,     0,     0,     0,     0,   657,     0, -2577,     0,
       0,     0,     0,     0,     0,     0,  2163,  2164,     0,     0,
       0,     0,  1724,     0,     0,     0,     0,  4546,     0,     0,
       0,     0,  2165,   809,   806,     0,     0,     0,     0,     0,
       0,   809,     0,     0,     0,     0,     0,     0,     0,     0,
    4332,  4332,  4332,  4332,  3254,     0,     0,  2166,     0,     0,
    2167,  3525,     0,     0,     0,  3525,     0,     0,   815,     0,
    2161,  2812,     0,  2168,  2162,     0,  2169,     0,     0,   806,
    4576,     0,     0,     0,   208,     0,     0,     0,  3335,     0,
       0,     0,     0,     0,  1728,  2163,  2164,  2812,  2812,     0,
     987,  1729,  2174,  2175,  2176,  2177,  2178,  2179,     0,  2420,
       0,  2165,     0,   987,     0,   815,     0,     0,  1731,     0,
       0,     0,     0,   815,     0,  1023,  1732,     0,     0,     0,
       0,     0,     0,  1023,     0,  1023,  2166,     0,     0,  2167,
       0,     0,     0,   655,   655,     0,     0,   806,  2170,     0,
       0,  3518,  2168,     0,     0,  2169,  3518,     0,     0,  3518,
       0,     0,     0,     0,     0,     0,     0,   658,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1733,     0,  3788,
       0,  3336,   658,     0,     0,     0,     0,     0,     0,     0,
    2154,     0,     0,  2155,     0,     0,     0,     0,     0,   985,
       0,     0,     0,  3227,     0,   658,     0,  4655,     0,     0,
    2156,     0,     0,     0,     0,     0,     0,     0,  2158,     0,
       0,     0,     0,     0,  2159,     0,     0,  2170,  2813,     0,
       0,     0,     0,     0,     0,     0,     0,  2813,  2171,  2172,
    2173,   658,  2174,  2175,  2176,  2177,  2178,  2179,  2160,     0,
    3333,     0,     0,     0,  2813,  2813,   658,     0,     0,   987,
       0,     0,  1979,     0,     0,     0,     0,     0,   658,  1719,
       0,   658,     0,  1994,     0,     0,     0,     0,     0,  2154,
       0,     0,  2155,     0,     0,     0,     0,     0,     0,     0,
     357,     0,     0,     0,     0,     0,     0,     0,     0,  2156,
       0,  1720,     0,  2812,     0,     0,     0,  2158,     0,     0,
       0,     0,     0,  2159,     0,     0,     0,  2171,  2172,  2173,
       0,  2174,  2175,  2176,  2177,  2178,  2179,     0,     0,  2929,
       0,     0,     0,     0,     0,  2930,     0,  2160,     0,     0,
       0,     0,     0,     0,  1743,     0,     0,     0,  2161,     0,
    1744,     0,  2162,     0,     0,     0,  1721,     0,     0,     0,
       0,   365,     0,     0,     0,   365,     0,     0,  3518,     0,
       0,     0,     0,  2163,  2164,     0,     0,     0,   659,     0,
       0,  1309,     0,   659,     0,     0,     0,  1722,     0,  2165,
    1745,     0,   659,   658,     0,  2323,     0,     0,  3560,     0,
     985,   658,   658,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   364,     0,  2166,     0,  3334,  2167,     0,   659,
       0,  3525,  1723,   659,     0,     0,  3525,     0,     0,  3525,
    2168,     0,     0,  2169,   659,     0,     0,  2161,     0,  1746,
       0,  2162,     0,     0,     0,     0,  1747,     0,     0,  1748,
       0,  1724,     0,     0,     0,     0,     0,     0,   659,     0,
    2813,     0,  2163,  2164,   364,   364,   364,  3525,     0,     0,
       0,     0,   659,     0,     0,     0,   659,     0,  2165,     0,
       0,     0,     0,     0,   658,  1743,   659,     0,     0,     0,
       0,  1744,     0,     0,     0,     0,     0,     0,     0,     0,
     659,  1749,  4640,  2166,     0,  2170,  2167,     0,     0,     0,
       0,     0,     0,   208,   364,     0,     0,  1727,     0,  2168,
       0,   364,  2169,  1728,     0,     0,     0,  1183,   364,     0,
    1729,  1745,     0,  1204,     0,  1024,     0,     0,  2420,  1180,
       0,  1215,     0,     0,     0,   987,     0,  1731,     0,  1225,
       0,     0,     0,     0,  1256,  1732,  1750,     0,  1751,     0,
       0,   987,     0,     0,     0,     0,     0,  1024,  1752,     0,
       0,     0,     0,     0,     0,     0,  1753,     0,     0,     0,
    1746,     0,     0,     0,     0,  1754,     0,  1747,  3525,   659,
    1748,     0,     0,     0,  2170,  2171,  2172,  2173,     0,  2174,
    2175,  2176,  2177,  2178,  2179,     0,  1733,     0,     0,   365,
    3336,  3477,     0,     0,     0,     0,  1755,  4927,     0,     0,
    1756,   987,     0,  2154,     0,     0,  2155,     0,     0,     0,
       0,     0,     0,     0,     0,   357,     0,     0,  3525,     0,
       0,     0,  1749,  2156,     0,  1757,     0,     0,     0,     0,
       0,  2158,   658,     0,  1024,   655,     0,  2159,     0,     0,
       0,     0,     0,     0,  4927,     0,     0,     0,     0,     0,
       0,  4933,  4927,     0,     0,     0,   659,   659,     0,     0,
       0,  2160,     0,     0,  2171,  2172,  2173,     0,  2174,  2175,
    2176,  2177,  2178,  2179,     0,     0,     0,  1750,  2843,  1751,
       0,     0,  1422,  1758,     0,     0,     0,     0,     0,  1752,
       0,     0,     0,     0,     0,   357,     0,  1753,     0,   985,
       0,     0,     0,     0,  3792,  3795,  1754,     0,     0,     0,
       0,     0,   985,   364,  1548,     0,     0,   806,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     658,     0,  1572,     0,   657,     0,     0,  1795,     0,   657,
    3839,  1756,     0,     0,     0,     0,   658,     0,   657,   987,
       0,     0,     0,     0,  1598,     0,     0,     0,     0,     0,
       0,  2161,     0,     0,     0,  2162,  1796,     0,     0,     0,
       0,     0,     0,     0,     0,   657,     0,     0,     0,   657,
       0,   658,   658,     0,     0,     0,  2163,  2164,     0,     0,
     657,     0,   658,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2165,  2531,   658,   658,     0,     0,     0,     0,
    4852,     0,     0,     0,   657,     0,     0,     0,     0,     0,
    3525,     0,     0,     0,  1758,  1743,   658,  2166,   657,     0,
    2167,  1744,   657,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   657,  2168,     0,     0,  2169,     0,     0,     0,
       0,   659,     0,     0,  4881,     0,   657,     0,   985,     0,
    2656,     0,     0,     0,     0,     0,   659,     0,     0,  2662,
       0,  1745,     0,  2666,     0,     0,     0,     0,     0,  2672,
    2673,     0,     0,     0,     0,     0,     0,     0,     0,   659,
       0,     0,     0,     0,     0,     0,     0,  2685,     0,     0,
       0,  2602,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   987,     0,     0,     0,  2531,  2170,     0,
    1746,     0,     0,     0,     0,   659,     0,  1747,     0,     0,
    1748,     0,     0,     0,     0,     0,     0,  1906,     0,     0,
     659,     0,     0,  1023,     0,   657,     0,  1023,     0,     0,
       0,     0,   659,  2664,     0,   659,     0,  1931,  1934,  1935,
       0,     0,     0,     0,     0,   987,     0,  4947,     0,     0,
    2154,     0,     0,  2155,   364,     0,  2531,     0,     0,     0,
       0,     0,  1749,     0,     0,     0,     0,     0,     0,     0,
    2156,     0,     0,     0,     0,     0,     0,     0,  2158,     0,
       0,     0,     0,     0,  2159,     0,     0,     0,  2171,  2172,
    2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,     0,     0,
       0,     0,  3789,     0,     0,     0,     0,     0,  2160,     0,
       0,     0,   657,   657,     0,     0,     0,  1750,     0,  1751,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1752,
    4073,     0,     0,     0,     0,     0,     0,  1753,     0,     0,
       0,     0,     0,     0,   364,     0,  1754,     0,     0,     0,
       0,   987,  1548,     0,     0,     0,     0,   659,     0,     0,
       0,     0,     0,     0,     0,   659,   659,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   365,  1821,     0,  1548,
       0,  1756,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   364,     0,   364,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1822,     0,  2161,     0,
       0,     0,  2162,     0,     0,   658,     0,     0,     0,     0,
       0,     0,     0,     0,   985,     0,     0,     0,   365,   365,
     365,     0,  2933,  2163,  2164,     0,     0,     0,     0,     0,
     985,     0,   658,     0,     0,     0,   364,   658,   659,  2165,
     658,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1758,     0,     0,     0,     0,     0,
       0,     0,   658,     0,  2166,     0,     0,  2167,   365,     0,
       0,     0,     0,     0,  2154,   365,     0,  2155,     0,     0,
    2168,     0,   365,  2169,     0,     0,     0,     0,     0,     0,
     985,     0,     0,     0,  2156,     0,   658,   657,     0,     0,
       0,     0,  2158,     0,     0,  1387,  1388,  1024,  2159,     0,
    2238,     0,   657,     0,  4223,     0,     0,     0,  3795,     0,
       0,     0,     0,   658,   658,     0,     0,     0,     0,  4238,
       0,     0,  2160,     0,     0,   657,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   658,     0,   364,
       0,     0,     0,     0,     0,  2170,     0,  2288,     0,     0,
     987,     0,     0,     0,     0,     0,   658,     0,     0,   658,
       0,   657,     0,     0,     0,     0,   655,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   657,   658,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   658,   657,     0,
       0,   657,     0,  3003,     0,     0,   659,     0,  3007,     0,
     658,  3010,     0,     0,     0,     0,     0,     0,     0,   658,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2161,  3033,     0,     0,  2162,     0,   985,     0,
       0,     0,     0,     0,     0,  2171,  2172,  2173,     0,  2174,
    2175,  2176,  2177,  2178,  2179,     0,     0,  2163,  2164,  3937,
       0,     0,     0,     0,     0,     0,     0,  3077,     0,     0,
       0,     0,     0,  2165,     0,     0,     0,     0,     0,     0,
       0,  2438,     0,     0,     0,     0,     0,   365,  2455,     0,
       0,     0,     0,     0,  3091,     0,     0,     0,  2166,     0,
       0,  2167,  1743,     0,   659,     0,     0,     0,  1744,     0,
       0,     0,     0,  2484,  2168,     0,     0,  2169,  3124,     0,
     659,     0,     0,   657,     0,     0,     0,     0,     0,     0,
       0,   657,   657,     0,   658,     0,     0,  3145,     0,     0,
    3155,     0,   806,     0,     0,  2518,     0,     0,  1745,     0,
       0,     0,     0,     0,     0,   659,   659,     0,  3167,  2534,
       0,     0,     0,     0,     0,     0,   659,     0,  3176,     0,
       0,   658,     0,  2546,     0,     0,  2323,     0,   659,   659,
       0,  3199,     0,     0,     0,  1889,     0,     0,     0,  2170,
    3206,     0,     0,     0,   806,     0,     0,  1746,    74,     0,
     659,     0,   985,  2154,  1747,  1743,  2155,  1748,     0,     0,
       0,  1744,     0,     0,   657,     0,     0,  4804,   658,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2158,     0,     0,     0,     0,  3350,  2159,     0,     0,
     658,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1745,  3359,  3360,   985,     0,  3362,     0,   806,  1749,
       0,  2160,  3366,     0,     0,  1023,     0,  4459,  4460,     0,
       0,     0,  4463,  4464,     0,     0,     0,     0,     0,  2171,
    2172,  2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,     0,
       0,     0,     0,  3984,     0,     0,     0,  1023,     0,     0,
    1746,     0,     0,     0,     0,  1743,     0,  1747,     0,     0,
    1748,  1744,     0,     0,  1750,     0,  1751,     0,     0,     0,
       0,   364,     0,  4000,     0,     0,  1752,   364,     0,     0,
       0,  3400,     0,     0,  1753,     0,     0,     0,     0,     0,
       0,     0,  1889,  1754,     0,  2695,     0,     0,   365,     0,
       0,  1745,  3795,  3795,  3795,  3795,  3795,     0,     0,     0,
     985, -2577,  1749,     0,     0,  2162,     0,     0,     0,     0,
    1743,     0,     0,     0,  2402,     0,  1744,     0,  1756,     0,
       0,     0,   657,     0,  1023,     0,  2163,  2164,     0,  3384,
       0,     0,  1548,  1548,     0,     0,     0,     0,     0,     0,
    1746,     0, -2577,  2403,     0,     0,     0,  1747,     0,     0,
    1748,  3384,     0,   658,     0,     0,  1745,  1750,     0,  1751,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1752,
    2167,     0,     0,     0,     0,     0,     0,  1753,   365,     0,
       0,     0,     0,  2168,     0,     0,  1754,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1758,  1749,   806,     0,  1746,     0,     0,     0,     0,
       0,     0,  1747,     0,     0,  1748,     0,  3093,     0,     0,
     657,  1756,     0,     0,  2220,     0,     0,   658,   365,     0,
     365,     0,     0,     0,     0,     0,   657,     0,     0,     0,
       0,     0,   658,   658,     0,     0,  1757,     0,     0,   659,
       0,     0,     0,     0,     0,     0,     0,  1750, -2577,  1751,
       0,     0,     0,     0,     0,  2902,  4611,  1749,   658,  1752,
       0,   657,   657,     0,     0,     0,   659,  1753,     0,     0,
     365,   659,   657,     0,   659,     0,  1754,     0,     0,     0,
    2922,     0,     0,     0,   657,   657,     0,     0,     0,     0,
       0,     0,     0,     0,  1758,     0,   659,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   657,  3169,     0,   985,
       0,  1756,  1750,     0,  1751,     0,     0,  2935,     0,  2938,
       0,     0,     0,     0,  1752,     0,     0,     0,     0,     0,
     659,     0,  1753,   364,   364,   364,  3170,  3627,     0,     0,
    1889,  1754,  2174,  2175,  2176,  2177,  2178,  2179,     0,     0,
       0,     0,   658,     0,     0,     0,     0,   659,   659,   658,
       0,     0,     0,     0,     0,     0,     0,     0,   658,     0,
       0,     0,  3207,     0,     0,  1881,  1756,     0,     0,  2154,
     365,   659,  2155,   365,     0,     0,     0,     0,  3606,     0,
       0,     0,     0,  1889,  1758,     0,     0,     0,     0,  2156,
     659,  3208,     0,   659,     0,     0,     0,  2158,     0,     0,
    3674,     0,  3676,  2159,     0,     0,     0,     0,     0,     0,
    1889,   659,     0,     0,     0,     0,     0,  2154,     0,   658,
    2155,   659,     0,     0,     0,     0,     0,  2160,     0,     0,
       0,     0,     0,     0,   659,     0,     0,  2156,     0,     0,
       0,     0,     0,   659,   806,  2158,     0,   364,     0,  1758,
       0,  2159,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,     0,     0,     0,
       0,  2154,     0,     0,  2155,  2160,     0,     0,   658,     0,
     658,  1889,     0,     0,     0,     0,     0,     0,     0,  3734,
     658,  2156,   658,     0,  3741,     0,     0,     0,     0,  2158,
    1889,     0,     0,     0,     0,  2159,     0,     0,     0,     0,
       0,     0,     0,  3692,     0,  3115,     0,     0,  1889,     0,
    3704,     0,  1881,     0,     0,     0,     0,  2161,     0,  2160,
       0,  2162,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   658,     0,     0,     0,     0,  1889,     0,     0,     0,
       0,     0,  2163,  2164,     0,     0,  4803,     0,   659,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2165,     0,
       0,   658,     0,     0,     0,  2161,     0,     0,     0,  2162,
       0,     0,     0,     0,     0,     0,     0,     0,   658,     0,
    3746,     0,     0,  2166,     0,   659,  2167,     0,     0,     0,
    2163,  2164,     0,   658,  1889,   657,   658,     0,     0,  2168,
       0,     0,  2169,     0,     0,     0,  2165,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2161,
       0,     0,   657,  2162,     0,     0,   806,   657,     0,     0,
     657,  2166,   659,  3893,  2167,     0,     0,  3896,  3897,     0,
    3899,     0,  3901,  3902,  2163,  2164,     0,  2168,     0,  3291,
    2169,  3907,   657,     0,   659,     0,     0,     0,     0,     0,
    2165,     0,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,     0,     0,  2170,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3924,  2166,   657,     0,  2167,     0,
       0,     0,     0,     0,  1743,     0,     0,  1023,     0,     0,
    1744,  2168,     0,     0,  2169,     0,     0,     0,     0,     0,
       0,     0,     0,   657,   657,     0,     0,     0,     0,     0,
       0,     0,  2170,     0,     0,     0,     0,  4924,     0,     0,
       0,     0,  2531,     0,     0,   365,   806,   657,     0,   806,
    1745,   365,     0,     0,     0,     0,     0,     0,     0,  3915,
       0,     0,     0,     0,     0,     0,   657,  2154,     0,   657,
    2155,     0,     0,     0,  2171,  2172,  2173,  3925,  2174,  2175,
    2176,  2177,  2178,  2179,  4924,     0,  2170,   657,  4059,     0,
    1881,     0,  4924,     0,     0,  2158,     0,   657,     0,  1746,
    1889,  2159,     0,     0,     0,     0,  1747,     0,     0,  1748,
     657,     0,     0,     0,     0,     0,     0,     0,     0,   657,
       0,     0,  2171,  2172,  2173,  2160,  2174,  2175,  2176,  2177,
    2178,  2179,     0,     0,     0,     0,  4086,   659,     0,     0,
       0,     0,     0,  1881,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   658,     0,     0,     0,     0,     0,     0,
       0,  1749,     0,     0,     0,     0,     0,     0,     0,     0,
    1881,     0,     0,     0,     0,     0,  2171,  2172,  2173,     0,
    2174,  2175,  2176,  2177,  2178,  2179,     0,     0,     0,     0,
    4335,     0,   364,     0,     0,     0,   364,     0,   364,     0,
       0,     0,     0,  2154,     0,     0,  2155,     0,     0,     0,
       0,   659,     0,     0,     0,     0,  1750,     0,  1751,     0,
       0,     0,     0,     0,     0,  2161,   659,   659,  1752,  2162,
     658,  2158,     0,   658,   657,     0,  1753,  2159,     0,     0,
       0,  1881,     0,     0,     0,  1754,     0,     0,     0,     0,
    2163,  2164,   659,     0,     0,     0,  3513,     0,     0,     0,
    1881,  2160,     0,     0,     0,     0,  2165,     0,     0,     0,
       0,   657,     0,   658,     0,     0,  3651,     0,  1881,     0,
    1756,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2167,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3652,  1881,  2168,     0,     0,
       0,  1548,     0,     0,     0,     0,     0,     0,   657,     0,
       0,     0,     0,  4003,  4114,     0,     0,   365,   365,   365,
       0,     0,     0,     0,     0,   703,     0,     0,     0,     0,
     657,     0,     0,   658,   658,     0,   659,     0,     0,     0,
       0,     0,     0,   659,     0,     0,     0,     0,     0,     0,
       0, -2577,   659,  1758,  1881,  2162,     0,     0,     0,     0,
       0,  1889,     0,   703,     0,     0,  1889,  1889,     0,     0,
       0,     0,  2170,     0,     0,     0,  2163,  2164,  1889,     0,
       0,     0,     0,     0,   703,     0,     0,     0,     0,     0,
    2154,  4174, -2577,  2155,  4177,     0,     0,     0,     0,  1743,
       0,     0,   996,     0,     0,  1744,     0,     0,     0,     0,
    2156,   806,     0,   659,   658,   997,     0,   806,  2158,     0,
    2167,     0,     0,  1005,  2159,     0,     0,     0,     0,     0,
    1775,     0,     0,  2168,     0,     0,     0,     0,  1015,     0,
     996,   365,     0,     0,  1036,  1745,     0,     0,  2160,     0,
       0,     0,     0,     0,  1066,     0,     0,     0,   365,     0,
       0,     0,  1071, -2577, -2577,     0,  2174,  2175,  2176,  2177,
    2178,  2179,   659,     0,   659,     0,  1776,     0,     0,     0,
       0,  4312,     0,     0,   659,     0,   659,     0,     0,  4315,
    4316,     0,     0,     0,  1746,     0,     0,     0,     0,     0,
       0,  1747,     0,   657,  1748,     0,     0,     0, -2577,  1889,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2154,     0,     0,  2155,
       0,     0,     0,     0,     0,   659,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2156,     0,  2161,     0,
    1881,     0,  2162,  1777,  2158,     0,  1749,     0,     0,     0,
    2159,     0,     0,     0,     0,   659,     0,     0,     0,     0,
       0,     0,     0,  2163,  2164,     0,     0,   657,     0,  1889,
       0,     0,   659,     0,  2160,  3384,     0,     0,     0,  2165,
       0,     0,   657,   657,     0,     0,     0,   659,     0,  1778,
     659,  1779,  2174,  2175,  2176,  2177,  2178,  2179,     0,     0,
       0,  1780,     0,  1751,  2166,     0,     0,  2167,   657,     0,
       0,   364,     0,  1752,     0,     0,  3831,     0,     0,     0,
    2168,  1753,  2154,  2169,     0,  2155,     0,   658,     0,  1781,
    1754,     0,     0,     0,     0,     0,     0,     0,     0,   658,
       0,  3846,     0,     0,     0,     0,     0,     0,     0,  3854,
    2158,     0,     0,  3859,     0,     0,  2159,     0,     0,     0,
       0,  1782,     0,   365,     0,  1756,  1783,  3870,  1889,     0,
       0,     0,     0,     0,  2161,     0,     0,     0,  2162,  4437,
    2160,     0,     0,   806,   806,   806,     0,     0,     0,     0,
    1784,     0,     0,     0,     0,  2170,   364,     0,   658,  2163,
    2164,  1785,   657,     0,     0,     0,     0,     0,     0,   657,
    4453,  4454,     0,     0,     0,  2165,     0,     0,   657,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1548,     0,     0,     0,
    2166,     0,  4367,  2167,     0,     0,     0,     0,  1758,     0,
       0,     0,     0,     0,     0,     0,  2168,     0,     0,  2169,
       0,     0,     0,     0,     0,     0,  4477,  4478,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   657,
   -2577,     0,     0,     0,  2162,  2171,  2172,  2173,     0,  2174,
    2175,  2176,  2177,  2178,  2179,     0,     0,     0,  4456,  4369,
       0,     0,     0,     0,     0,  2163,  2164,   806,     0,     0,
    4466,  1881,   658,     0,     0,     0,  1881,  1881,     0,     0,
       0, -2577,     0,     0,   806,     0,     0,     0,  1881,     0,
       0,  2170,     0,     0,     0,     0,     0,   659,   657,     0,
     657,     0,     0,     0,   703,     0,     0,     0,     0,  2167,
     657,     0,   657,  4009,  4010,  4011,     0,     0,     0,     0,
       0,     0,  2168,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   365,     0,     0,     0,
     365,     0,   365,     0,     0,     0,     0,  4557,     0,  4558,
    4559,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4562,   657,     0,     0,     0,   658,     0,   658,     0,     0,
       0,     0,     0,     0,   659,     0,     0,   659,     0,     0,
       0,  2171,  2172,  2173,     0,  2174,  2175,  2176,  2177,  2178,
    2179,   657,     0,     0,     0,  4578,     0, -2577,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   657,     0,
       0,     0,     0,     0,     0,     0,     0,   659,     0,  1881,
       0,     0,  2154,   657,     0,  2155,   657,     0,     0,  1889,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2156,  3384,     0,     0,     0,     0,     0,     0,
    2158,     0,     0,     0,     0,     0,  2159,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1889,
    1889,     0,  1889,     0,     0,     0,     0,     0,     0,     0,
    2160,     0,     0,     0,     0,     0,     0,   659,   659,  1881,
       0,  2174,  2175,  2176,  2177,  2178,  2179,     0,     0,   806,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1163,
    1169,  1169,   703,     0,  1169,  1176,     0,  1163,     0,  1066,
    1883,  1200,     0,     0,  1889,  1066,  1889,  1066,     0,     0,
       0,  1169,     0,  1066,     0,     0,  3384,     0,  3384,     0,
       0,  1227,     0,     0,     0,     0,  1066,     0,  1163,     0,
       0,  1169,     0,   703,     0,  1169,     0,     0,     0,     0,
       0,  1200,     0,     0,  1280,     0,     0,     0,   659,     0,
       0,  1169,     0,     0,     0,     0,     0,     0,     0,  1889,
    2161,     0,     0,   364,  2162,     0,     0,     0,  1881,     0,
       0,     0,     0,  1228,     0,     0,     0,     0,     0,  4714,
       0,  4235,  1163,  1889,   658,  2163,  2164,   703,     0,     0,
       0,  1163,     0,     0,  1200,     0,     0,     0,     0,     0,
    4261,  2165,     0,     0,     0,     0,  1229,     0,     0,  1169,
    1889,     0,     0,     0,     0,     0,     0,     0,     0,  1230,
    1231,     0,  4271,  1889,     0,     0,  2166,     0,  1232,  2167,
       0,     0,  1233,     0,     0,  4740,     0,     0,     0,     0,
       0,     0,  2168,     0,     0,  2169,     0,     0,     0,  1234,
       0,     0,     0,   657,     0,     0,     0,  1883,     0,     0,
       0,     0,  1066,     0,     0,     0,     0,     0,  4766,     0,
    1235,     0,     0,     0,  1066,  1423,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1889,     0,  1236,     0,
       0,     0,   806,     0,     0,     0,   806,     0,   806,  1237,
    1889,  1530,     0,     0,  1238,   703,  1066,     0,     0,     0,
       0,     0,     0,  1889,     0,     0,     0,  2170,     0,     0,
       0,     0,     0,     0,  1066,  1239,     0,     0,  1066,     0,
     657,     0,     0,   657,     0,     0,  1530,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1066,     0,   658,     0,
    1240,     0,     0,     0,     0,   365,     0,     0,  1066,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   659,     0,   657,     0,     0,     0,     0,     0,     0,
       0,  1889,     0,   659,  4370,  4371,  4372,  4373,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1241,  1889,     0,     0,     0,     0,     0,  2171,  2172,  2173,
       0,  2174,  2175,  2176,  2177,  2178,  2179,     0,     0,     0,
     364,  4620,     0,     0,     0,     0,  1889,     0,   841,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1066,
     365,     0,   659,   657,   657,     0,     0,  1169,  1169,     0,
       0,     0,     0,  1242,     0,     0,     0,  1243,     0,  1244,
       0,     0,  1889,     0,     0,  1245,     0,   364,  1246,  1881,
       0,     0,     0,     0,     0,   364,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1163,
       0,  4912,     0,     0,  1247,     0,  1248,     0,     0,  1163,
    1249,     0,  1200,     0,     0,     0,     0,     0,  1250,  1881,
    1881,     0,  1881,  1251,     0,  1169,     0,     0,     0,  3384,
       0,     0,     0,     0,   657,  1883,     0,     0,     0,  1066,
       0,  2154,     0,     0,  2155,  1169,  1169,     0,  1252,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2084,  1066,
    1066,  1066,  1169,     0,  1163,     0,   659,     0,  1944,  2158,
       0,     0,     0,     0,  1881,  2159,  1881,     0,     0,     0,
    2154,     0,     0,  2155,     0,     0,     0,     0,  1883,     0,
       0,     0,     0,     0,     0,     0,  1169,  1169,  1169,  2160,
    2156,     0,     0,     0, -2084,     0,     0,     0,  2158,     0,
       0,     0,     0,     0,  2159,  1883, -2084,     0,     0,     0,
   -2084,     0,     0,     0,     0, -2084,     0,     0,     0,  1881,
   -2084,  1530,     0, -2084,     0, -2084,     0,     0,  2160,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1881,     0,     0,     0,     0,     0,   659,
       0,   659, -2084,     0,     0,  1889,     0,     0,     0,  2043,
    2043,     0,     0,     0,  1066,     0,   996,     0,     0,     0,
    1881,     0,     0, -2084,     0,     0,  1883,     0,     0,     0,
       0,     0,     0,  1881,     0,     0,  4552,     0,  2077,  2161,
       0,  1066,     0,  2162,  2083,  1883,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1530,     0,     0, -2084,
       0,     0,     0,  1883,  2163,  2164,     0, -2084,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2161,     0,
    2165,   806,  2162,     0,     0,  1530,     0,     0,     0,     0,
       0,  1883,     0,     0,     0,     0,  1881,   657,     0,     0,
       0,     0,     0,  2163,  2164,  2166,     0,     0,  2167,   657,
    1881,     0, -2084,  1530,  1530,     0,  1530,     0,     0,  2165,
       0,  2168,     0,  1881,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1530,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2166,     0,     0,  2167,     0,  1883,
       0,     0,     0,   703,   703,  1889,     0,  1000,     0,     0,
    2168,     0,     0,  2169,     0,     0,   806,     0,   657,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2084,  1066,     0,     0,  1530,     0,  1889,     0,     0,
       0,  1881,     0,     0,     0,     0,  2170,     0,     0,     0,
       0,     0,     0,     0, -2084,     0, -2084, -2084,     0,     0,
       0,  1881,     0,     0,  1530,     0,     0,   365,  1530,  1530,
       0,     0,     0,     0,     0,     0,     0,     0,  1066,  1066,
    2290,     0,     0,     0,  4663,  2170,  1881,     0,   659, -2084,
       0,     0, -2084, -2084,     0, -2084,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   703,     0,     0,     0,
       0,     0,     0,     0,     0,  1548,     0,     0,     0,  1743,
       0,     0,  1881,     0,     0,  1744,     0,     0,     0,     0,
       0,     0,   657,     0,     0,     0,  2171,  2172,  2173,     0,
    2174,  2175,  2176,  2177,  2178,  2179,     0,     0,  1889,     0,
    1775,     0,     0,     0,     0,     0,     0,     0,     0,  1889,
       0,     0,     0,     0,     0,  1745,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2171,  2172,  2173,     0,  2174,
    2175,  2176,  2177,  2178,  2179,     0,     0,     0,     0,  4665,
       0,     0,     0,     0,     0,  1883,  1776,     0,     0,     0,
       0,     0,     0,  1066,  2443,     0,     0,     0,     0,  4747,
    1066,     0,     0,  1169,  1746,     0,     0,     0,     0,     0,
       0,  1747,     0,     0,  1748,   657,     0,   657,  1200,     0,
       0,     0,     0,     0,     0,  1066,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   659,     0,     0,  1066,     0,     0,     0,     0,
       0,     0,     0,  1169,  1169,  1169,  1169,  1066,     0,     0,
    1889,     0,     0,  1777,     0,     0,  1749,     0,     0,     0,
       0,  1066,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2545,     0,  1066,     0,     0,  1889,     0,
       0,     0,     0,  1169,  1169,     0,     0,     0,     0,  1169,
    1889,     0,     0,     0,     0,  1881,     0,     0,     0,  1778,
       0,  1779,     0,     0,   365,     0,     0,     0,     0,     0,
       0,  1780,     0,  1751,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1752,     0,     0,     0,     0,     0,     0,
       0,  1753,     0,     0,  1889,     0,  1169,     0,     0,  1781,
    1754,     0,     0,     0,     0,     0,  2154,     0,     0,  2155,
       0,   365,     0,     0,     0,     0,     0,     0,     0,   365,
    1169,  1169,  1169,  1169,     0,     0,  2156,     0,     0,     0,
       0,  3157,     0,     0,  2158,  1756,  1783,     0,     0,  2545,
    2159,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1163,     0,     0,     0,     0,     0,
    3158,   703,     0,  1163,  2160,     0,     0,     0,     0,     0,
       0,  1785,     0,  1200,     0,     0,     0,     0,  1169,     0,
       0,     0,     0,   806,     0,     0,     0,  1169,     0,     0,
       0,     0,     0,  1169,  1169,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   657,  1881,  1883,  1066,     0,     0,
       0,  1883,  1883,     0,     0,     0,     0,     0,  1758,     0,
       0,     0,     0,  1883,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1881,     0,     0,
       0,  2043,     0,     0,     0,     0,  1889,     0,  1169,     0,
    1163,     0,     0,     0,  1066,  1066,     0,  1169,     0,     0,
       0,     0,     0,  1066,  2161,     0,     0,     0,  2162,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   996,
     996,     0,     0,  2756,     0,     0,     0,  1530,  1530,  2163,
    2164,     0,     0,     0,     0,  1530,     0,     0,  1530,     0,
       0,     0,  1530,     0,     0,  2165,     0,     0,     0,     0,
    1530,  1530,     0,     0,     0,     0,     0,     0,  1530,     0,
    1200,  1530,  1530,  1530,  1530,     0,     0,     0,     0,     0,
    2166,  1530,  1530,  2167,  1530,     0,  1530,  1530,     0,     0,
    1530,     0,     0,     0,     0,     0,  2168,     0,  1881,  2169,
       0,     0,     0,     0,  1883,     0,     0,  1530,     0,  1881,
    1889,  1169,  1530,     0,     0,     0,  1530,     0,   657,     0,
    1530,     0,  1530,  1530,  1530,  1530,  1530,  1530,  1530,  1530,
    1530,     0,  1530,     0,     0,     0,     0,  1066,  1530,     0,
       0,  1530,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1066,     0,     0,     0,     0,     0,     0,     0,
       0,  2170,     0,     0,  1883,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     806,     0,     0,     0,     0,     0,     0,     0,     0,  1066,
       0,  1066,  1889,  1530,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2086,  2154,
    1881,     0,  2155,     0,     0,  1889,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   806,     0,  2156,
    2967,     0,  2974,     0,     0,   806,     0,  2158,  1881,     0,
       0,     0,     0,  2159,     0,  1889,     0,     0,     0,     0,
    1881,  2171,  2172,  2173, -2086,  2174,  2175,  2176,  2177,  2178,
    2179,     0,     0,  1883,     0,  4851, -2086,  2160,     0,     0,
   -2086,     0,     0,     0,     0, -2086,     0,     0,     0,     0,
   -2086,     0,     0, -2086,  1889, -2086,     0,     0,  1889,  1889,
       0,     0,     0,     0,  1881,   703,     0,     0,     0,     0,
     996,     0,   996,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2086,     0,     0,     0,     0,     0,     0,  1530,
       0,     0,     0,     0,     0,  1163,     0,  1169,  1169,  1169,
       0,  1163,  1200, -2086,  1169,     0,  1169,     0,  1169,  1169,
       0,     0,  1066,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2161,     0, -2086,
       0,  2162,     0,     0,     0,     0,     0, -2086,     0,     0,
    2443,     0,     0,     0,     0,     0,  3097,     0,     0,     0,
       0,  3106,  2163,  2164,     0,     0,     0,  1066,     0,     0,
       0,  1884,     0,     0,     0,     0,     0,     0,  2165,     0,
       0,     0,  3137,  3137,     0,     0,     0,     0,     0,   703,
       0,     0, -2086,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2166,  1169,     0,  2167,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1881,     0,     0,  2168,
       0,     0,  2169,     0,     0,     0,     0,     0,     0,     0,
    3194,     0,  3196,  3198,     0,     0,     0,  1000,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1169, -2086,     0,     0,     0,     0,     0,     0,  1169,  1169,
    1169,  1169,  1169,  1169,     0,  2154,     0,     0,  2155,     0,
       0,     0,     0,  1530, -2086,     0, -2086, -2086,     0,     0,
       0,     0,     0,     0,  2170,  2156,     0,     0,     0,     0,
       0,     0,     0,  2158,     0,     0,  2443,     0,     0,  2159,
    3137,  1066,     0,     0,     0,   996,     0,     0,     0, -2086,
       0,     0, -2086, -2086,     0, -2086,     0,     0,  1884,     0,
    1881,     0,     0,  2160,  1883,     0,     0,     0,     0,     0,
       0,  3194,     0,     0,     0,     0,     0,     0,  1169,  3321,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1944,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1883,  1883,  1169,  1883,  1169,  3137,
    1169,  3137,     0,     0,  2171,  2172,  2173,     0,  2174,  2175,
    2176,  2177,  2178,  2179,     0,     0,     0,     0,  4936,     0,
       0,     0,     0,  1530,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1881,     0,  2043,     0,     0,     0,     0,  1883,
       0,  1883,     0,  2161,     0,     0,     0,  2162,     0,     0,
       0,     0,     0,     0,     0,  1881,  1168,  1170,     0,     0,
    1173,  1174,     0,     0,     0,     0,     0,     0,  2163,  2164,
       0,     0,     0,     0,     0,     0,     0,  1211,  1163,     0,
       0,     0,     0,  1163,  2165,  1881,     0,     0,     0,     0,
       0,     0,     0,  1169,  1883,     0,     0,  1261,     0,  1530,
    1530,  1264,     0,     0,     0,  1530,     0,     0,     0,  2166,
       0,     0,  2167,     0,     0,     0,     0,  1285,  1883,     0,
       0,     0,     0,     0,  1881,  2168,     0,     0,  1881,  1881,
    1530,  1530,     0,     0,     0,  1530,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1883,     0,  1530,  1530,  1530,
    1530,     0,     0,     0,     0,     0,     0,     0,  1883,     0,
    1530,     0,     0,  1530,     0,  1530,  3481,     0,     0,     0,
       0,     0,     0,     0,     0,  1530,  1530,     0,     0,  1530,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1530,     0,  1530,     0,  1200,     0,  1530,     0,
    2170,     0,  2154,     0,     0,  2155,  1884,     0,     0,     0,
       0,     0,     0,     0,  1530,     0,     0,     0,  1066,     0,
       0,  1883,  2156,     0,     0,  3526,     0,  1530,  1530,  1530,
    2158,     0,     0,     0,     0,  1883,  2159,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1883,     0,
       0,  1530,     0,     0,     0,     0,     0,     0,     0,  1884,
    2160,     0,     0,     0,  1530,     0,     0,     0,     0,  1530,
       0,     0,     0,  1066,     0,     0,  1530,     0,     0,     0,
       0,     0,  3526,     0,     0,  3587,  1884,     0,     0,  2974,
    2171,  2172,  2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1883,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1883,     0,     0,     0,
       0,     0,  1530,     0,  3137,     0,     0,     0,     0,  2043,
       0,     0,     0,     0,     0,     0,     0,  1884,     0,     0,
    2161,  1883,     0,     0,  2162,     0,     0,     0,     0,     0,
    1169,     0,  1169,  1169,     0,     0,  1884,     0,     0,     0,
       0,     0,     0,     0,     0,  2163,  2164,     0,     0,     0,
       0,     0,     0,     0,  1884,     0,     0,  1883,     0,     0,
       0,  2165,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1763,  1764,     0,     0,     0,     0,     0,
       0,     0,  1884,     0,     0,     0,  2166,     0,     0,  2167,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2168,     0,     0,  2169,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2154,     0,     0,  2155,     0,     0,     0,
       0,     0,     0,     0,   814,     0,     0,     0,     0,     0,
    1884,  1849,     0,  2156,     0,     0,     0,  2944,     0,     0,
       0,  2158,     0,     0,     0,     0,     0,  2159,     0,     0,
       0,  1908,  1909,     0,     0,     0,     0,     0,     0,     0,
       0,  2154,     0,     0,  2155,     0,     0,  2170,  1936,   814,
       0,  2160,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2156,     0,     0,     0,     0,     0,     0,     0,  2158,
       0,     0,     0,  3137,  3137,  2159,     0,     0,     0,     0,
       0,     0,     0,  1969,  1971,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1027,  2945,     0,     0,  2160,
       0,     0,  3796,  1027,     0,  1027,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   814,     0,     0,
    1883,     0,     0,     0,     0,     0,     0,     0,  1066,     0,
       0,     0,     0,     0,     0,     0,     0,  2171,  2172,  2173,
       0,  2174,  2175,  2176,  2177,  2178,  2179,     0,     0,  4054,
       0,  2161,  2043,  1066,     0,  2162,     0,     0,     0,     0,
       0,  1066,     0,     0,     0,  1066,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2163,  2164,  3453,  1066,
       0,     0,     0,  3454,     0,     0,     0,     0,     0,     0,
       0,     0,  2165,     0,   703,     0,     0,     0,     0,  2161,
       0,     0,     0,  2162,     0,     0,  1884,     0,     0,  1169,
       0,     0,  1169,     0,     0,     0,     0,  2166,     0,     0,
    2167,     0,     0,     0,  2163,  2164,     0,     0,     0,  1163,
       0,     0,     0,  2168,     0,     0,  2169,     0,     0,     0,
    2165,     0,     0,     0,     0,     0,     0,     0,  1066,     0,
       0,     0,     0,     0,     0,     0,  1169,     0,     0,     0,
       0,     0,     0,     0,  1530,  2166,     0,     0,  2167,     0,
    1883,     0,     0,     0,  1530,     0,     0,     0,     0,     0,
    1530,  2168,  1530,     0,  2169,     0,     0,     0,  1530,     0,
       0,  1530,  1530,  1530,  1530,  1530,  1530,  1530,  1530,  1530,
    1530,     0,  1883,     0,  1530,  1530,     0,     0,  2170,     0,
       0,     0,     0,     0,     0,     0,     0,  1530,     0,     0,
       0,  1530,     0,     0,     0,  1530,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1530,     0,     0,  1530,     0,
    1530,     0,     0,     0,     0,     0,     0,     0,     0,  1530,
    1530,  1530,     0,     0,     0,  1530,  2170,     0,  1530,  2946,
       0,     0,     0,     0,     0,  1066,  1066,  1066,  3526,  4017,
       0,     0,     0,  4017,  4030,     0,     0,     0,  1530,     0,
       0,     0,     0,     0,  4044,     0,  1530,     0,  1530,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2171,  2172,
    2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,     0,     0,
       0,     0,     0,  1883,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1883,     0,     0,     0,     0,     0,
       0,     0,     0,  1530,     0,     0,     0,     0,     0,  1530,
       0,     0,     0,  2974,     0,  1530,  2171,  2172,  2173,     0,
    2174,  2175,  2176,  2177,  2178,  2179,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4092,  2043,  2043,     0,  2545,     0,     0,  1884,     0,     0,
       0,     0,  1884,  1884,     0,     0,     0,     0,  1169,  1169,
    1169,  1169,     0,     0,  1884,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2458,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4135,     0,     0,     0,
       0,     0,     0,     0,     0,  1883,     0,     0,  2154,     0,
       0,  2155,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2156,  2514,
    2515,  2516,  2517,  1883,     0,     0,  2158,     0,     0,     0,
       0,     0,  2159,     0,     0,  1883,     0,     0,     0,     0,
       0,     0,     0,  2154,     0,     0,  2155,     0,     0,     0,
       0,  4190,     0,     0,     0,     0,  2160,     0,     0,  2553,
    2554,     0,     0,  2156,     0,  2563,     0,     0,     0,     0,
       0,  2158,     0,     0,     0,     0,     0,  2159,     0,  1883,
       0,     0,     0,     0,     0,  1884,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2160,     0,     0,     0,  3796,     0,     0,     0,     0,
       0,     0,  2584,  1066,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1169,     0,  1530,     0,     0,     0,
       0,     0,  1066,     0,     0,     0,  2617,  2618,  2619,  2620,
       0,     0,     0,     0,  2443,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1066,  1884,  2161,     0,     0,     0,
    2162,     0,     0,  3194,     0,     0,     0,   814,  4288,     0,
       0,     0,  2443,     0,     0,  1165,     0,     0,     0,  4910,
       0,  2163,  2164,  1165,  1530,  1530,     0,     0,     0,     0,
       0,     0,     0,     0,  2676,     0,     0,  2165,     0,     0,
       0,  2161,     0,  2680,     0,  2162,     0,     0,     0,  3137,
    2687,  3137,     0,     0,  1165,     0,     0,     0,     0,     0,
       0,     0,  2166,     0,     0,  2167,  2163,  2164,     0,     0,
       0,  1883,     0,     0,     0,     0,     0,     0,  2168,     0,
       0,  2169,  2165,     0,  1530,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1884,     0,     0,     0,     0,     0,
    3976,     0,     0,     0,     0,     0,     0,  2166,  1165,     0,
    2167,     0,     0,     0,     0,     0,     0,  1165,     0,     0,
       0,  1530,     0,  2168,     0,     0,  2169,     0,     0,     0,
       0,  1530,  1530,     0,     0,     0,     0,     0,     0,  1530,
    1530,     0,     0,  4911,  1530,     0,     0,     0,     0,     0,
    1530,  1530,     0,  2170,  1530,     0,  1066,  1066,  1066,  1066,
       0,     0,     0,  4017,     0,     0,  4375,  3977,     0,  3526,
       0,     0,     0,  3526,     0,     0,     0,     0,     0,  4388,
       0,     0,  1530,     0,     0,  1883,     0,  1530,     0,     0,
       0,     0,     0,  4398,     0,     0,     0,     0,  2170,  1530,
       0,     0,     0,     0,     0,     0,     0,     0,  1200,     0,
       0,     0,     0,     0,     0,     0,  3587,  2856,     0,     0,
    2974,     0,     0,     0,     0,     0,     0,  1165,     0,     0,
       0,     0,     0,  1027,     0,   996,     0,  1027,  1530,     0,
       0,     0,     0,  2171,  2172,  2173,     0,  2174,  2175,  2176,
    2177,  2178,  2179,     0,     0,     0,     0,     0,  3137,  3137,
       0,     0,  1165,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1883,     0,     0,
   -2099,     0,  4451,     0,     0,     0,     0,     0,  2171,  2172,
    2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,     0,     0,
    1883,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1169,     0,     0,     0, -2099,     0,     0,     0,
    1883,     0,     0,     0,     0,     0,  1169,     0, -2099,     0,
       0,     0, -2099,     0,     0,     0,     0, -2099,     0,     0,
       0,     0, -2099,     0,     0, -2099,     0, -2099,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1883,
    2043,     0,     0,  1883,  1883,     0,     0,     0,     0,  3796,
    3796,  3796,  3796,  3796, -2099,     0,     0,  1518,     0,     0,
       0,     0,     0,     0,     0,  1884,     0,     0,     0,     0,
       0,     0,     0,  1530,     0, -2099,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1165,     0,     0,     0,     0,
       0,     0,  1589,     0,     0,  1165,     0,     0,     0,     0,
    1169,  2443,     0,     0,     0,  1884,  1884,     0,  1884,     0,
       0, -2099,     0,  3045,  3046,  3047,     0,  1892,     0, -2099,
    3055,     0,  3057,     0,  3059,  3060,     0,     0,  1066,     0,
    4556,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1165,     0,     0,     0,     0,     0,     0,     0,  1530,     0,
    1884,     0,  1884,     0, -2099,     0,     0,  1530,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1530,  1530,     0,     0,  1530,     0,
       0,     0,     0,     0,     0,  4017,     0,     0,     0,  3526,
       0,     0,     0,     0,  3526,     0,     0,  3526,  3194,  1000,
    4600,     0,  1530,  1530,     0,  1884,     0,  1165,     0,     0,
    3162,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2099,     0,     0,     0,     0,     0,  1884,
       0,     0,     0,     0,     0,  4092,  1200,  1169,  1169,  1169,
       0,     0,     0,     0,     0,     0, -2099,     0, -2099, -2099,
       0,     0,     0,     0,     0,     0,  1884,     0,     0,     0,
       0,     0,     0,     0,  1892,     0,  3219,     0,     0,  1884,
    1163,  1200,     0,     0,  3228,  3229,  3230,  3231,  3232,  3233,
       0, -2099,     0,     0, -2099, -2099,     0, -2099,     0,     0,
       0,     0,  1165,     0,     0,     0,     0,     0,     0,     0,
       0,  2043,     0,     0,     0,     0,     0,  1163,     0,     0,
       0,     0,     0,     0,     0,     0,  1066,  2154,     0,     0,
    2155,  1165,     0,     0,     0,     0,     0,  3137,     0,  2443,
       0,     0,  1884,     0,     0,     0,     0,  2156,     0,     0,
    3416,     0,  4288,     0,     0,  2158,  1884,  1066,     0,  1165,
    1165,  2159,  1165,     0,  3313,  1169,  4092,     0,     0,  1884,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1165,
       0,     0,     0,     0,     0,  2160,     0,     0,     0,     0,
    1530,     0,     0,  1530,  3353,  1530,  3355,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1530,     0,     0,     0,  3526,     0,     0,  4600,
       0,     0,     0,     0,     0,  4734,     0,     0,     0,     0,
       0,  1165,   814,     0,     0,     0,     0,  1884,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1169,     0,     0,
       0,  1066,     0,     0,     0,     0,     0,  1884,     0,     0,
    1165,     0,  2092,     0,  1165,  1165,     0,     0,  1169,  1169,
    1169,  1169,     0,  2154,     0,     0,  2155,     0,     0,     0,
       0,     0,  1884,     0,     0,  2161,     0,     0,     0,  2162,
       0,  2116,     0,  2156,     0,     0,  3461,     0,  1530,  3406,
       0,  2158,     0,     0,     0,     0,     0,  2159,     0,     0,
    2163,  2164,     0,     0,     0,     0,     0,     0,  1884,  2141,
    2142,     0,  2145,     0,  2154,     0,  2165,  2155,     0,     0,
       0,  2160,     0,     0,     0,     0,     0,     0,     0,  2185,
       0,     0,  1892,     0,  2156,     0,     0,     0,   814,     0,
       0,  2166,  2158,     0,  2167,  1027,  1530,     0,  2159,     0,
       0,     0,  1169,     0,  1200,     0,     0,  2168,     0,     0,
    2169,     0,     0,  1530,     0,     0,     0,     0,     0,     0,
       0,     0,  2160,     0,     0,     0,     0,  1027,     0,     0,
       0,  2239,     0,     0,     0,  1892,     0,     0,     0,     0,
       0,     0,     0,     0,  1169,     0,     0,     0,  1163,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4092,     0,
    2262,     0,  1892,     0,  2272,  2275,     0,  4556,     0,     0,
       0,  2161,     0,     0,     0,  2162,  4734,     0,     0,  1530,
    1530,     0,  2170,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1163,     0,     0,     0,  2163,  2164,     0,     0,
    1169,     0,     0,     0,     0,     0,     0,  2154,     0,     0,
    2155,     0,  2165,     0,  1027,     0,     0,     0,     0,     0,
       0,     0,  2161,     0,     0,     0,  2162,  2156,  1530,     0,
       0,     0,     0,  1892,     0,  2158,     0,  2166,  1530,     0,
    2167,  2159,     0,  1169,     0,     0,     0,  2163,  2164,     0,
       0,  1884,  1892,  2168,     0,     0,  2169,     0,     0,     0,
       0,     0,     0,  2165,     0,  2160,     0,     0,     0,     0,
    1892,     0,  2171,  2172,  2173,     0,  2174,  2175,  2176,  2177,
    2178,  2179,     0,     0,     0,     0,     0,     0,  2166,     0,
       0,  2167,     0,   814,     0,     0,  1530,     0,  1892,     0,
       0,     0,     0,     0,  2168,  1163,     0,  2169,     0,     0,
       0,     0,     0,     0,     0,     0,  3633,     0,  3634,  3635,
       0,  3431,     0,     0,     0,     0,     0,     0,  2170,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3466,
    1165,     0,     0,     0,     0,     0,  1892,     0,     0,  1165,
       0,     0,     0,     0,     0,  2161,     0,     0,     0,  2162,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2170,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2163,  2164,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1884,     0,     0,     0,     0,  2165,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2171,  2172,
    2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,     0,     0,
       0,  2166,     0,  1884,  2167,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1165,  2168,     0,     0,
    2169,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2171,
    2172,  2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,     0,
       0,     0,     0,  1165,  1165,     0,     0,     0,     0,     0,
       0,  1165,     0,     0,  1165,     0,     0,     0,  1165,     0,
       0,     0,     0,     0,     0,     0,  1165,  1165,     0,     0,
       0,     0,     0,     0,  1165,     0,     0,  1165,  1165,  1165,
    1165,     0,  2170,     0,     0,     0,     0,  1165,  1165,     0,
    1165,     0,  1165,  1165,     0,     0,  1165,     0,     0,     0,
       0,     0,     0,     0,  1884,     0,     0,     0,     0,     0,
       0,     0,  1892,  1165,   814,  1884,     0,     0,  1165,     0,
       0,     0,  1165,     0,     0,     0,  1165,     0,  1165,  1165,
    1165,  1165,  1165,  1165,  1165,  1165,  1165,     0,  1165,     0,
       0,     0,     0,     0,  1165,     0,     0,  1165,     0,     0,
       0,     0,     0,     0,     0,  2154,     0,  1886,  2155,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2171,  2172,  2173,  2156,  2174,  2175,  2176,  2177,
    2178,  2179,     0,  2158,     0,  3903,     0,     0,  3904,  2159,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2154,     0,     0,  2155,     0,     0,     0,  1165,
       0,  2782,     0,  2160,     0,     0,     0,     0,     0,     0,
       0,     0,  2156,     0,     0,  3472,  1884,     0,     0,     0,
    2158,     0,  3929,     0,  2805,     0,  2159,  2807,     0,     0,
    2818,     0,     0,     0,     0,     0,     0,  2825,  2830,     0,
       0,     0,     0,  2836,  1884,     0,  2841,     0,     0,     0,
    2160,     0,     0,     0,     0,     0,  1884,     0,     0,     0,
       0,     0,     0,  2850,     0,     0,     0,     0,  2857,     0,
       0,     0,  2869,     0,     0,     0,  2876,     0,  2878,  2879,
    2880,  2881,  2882,  2883,  2884,  2885,  2886,     0,  2887,   921,
       0,     0,     0,     0,  1518,     0,   814,  2912,     0,     0,
    1884,   922,     0,  2161,  1886,     0,     0,  2162,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   923,     0,     0,  1165,     0,     0,  2163,  2164,
       0,  1165,     0,     0,     0,   924,     0,  1165,     0,     0,
       0,     0,     0,     0,  2165,     0,     0,     0,   925,     0,
    2161,     0,     0,     0,  2162,     0,     0,     0,     0,  1589,
       0,     0,     0,     0,     0,   926,     0,  1027,     0,  2166,
       0,     0,  2167,  1892,     0,  2163,  2164,     0,  1892,  1892,
       0,     0,     0,     0,     0,  2168,   927,     0,  2169,     0,
    1892,  2165,     0,     0,   828,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   928,     0,   814,     0,     0,   814,
       0,     0,     0,     0,     0,   929,  2166,     0,     0,  2167,
     930,     0,     0,     0,     0,     0,   931,     0,     0,     0,
       0,     0,  2168,     0,     0,  2169,     0,     0,     0,     0,
     829,   932,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1884,   830,  4109,  4110,  4111,  4112,     0,     0,
    2170,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     831,     0,     0,     0,     0,     0,   832,     0,     0,     0,
       0,     0,     0,     0,     0,  3036,  3933,     0,     0,     0,
       0,   833,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1025,     0,     0,     0,     0,  2170,     0,   834,
    1025,     0,  1025,     0,     0,     0,   933,     0,     0,  1165,
     835,  1892,     0,     0,     0,   836,   934,     0,     0,     0,
       0,   837,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   841,     0,   838,     0,     0,     0,
    2171,  2172,  2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,
       0,     0,     0,     0,     0,     0,  1884,     0,     0,   935,
       0,   839,  1886,   936,     0,   937,     0,     0,     0,     0,
       0,   938,     0,     0,   939,     0,     0,     0,     0,     0,
       0,  1892,     0,     0,     0,     0,     0,  2171,  2172,  2173,
       0,  2174,  2175,  2176,  2177,  2178,  2179,     0,     0,     0,
     940,     0,   941,     0,     0,     0,   942,     0,     0,     0,
       0,   840,     0,     0,   943,  1886,     0,     0,     0,   944,
    4253,     0,     0,     0,     0,     0,     0,     0,     0,  1165,
       0,   945,     0,     0,     0,     0,     0,     0,     0,   841,
       0,     0,  1886,     0,   946,     0,     0,     0,  1884,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   842,     0,     0,     0,     0,  3246,
     843,  1884,     0,     0,     0,     0,   844,     0,     0,   845,
    1892,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1165,     0,     0,     0,     0,  1165,
       0,  1884,     0,     0,     0,   846,     0,   847,     0,     0,
       0,   848,     0,  1886,     0,  1165,  1165,     0,     0,   849,
       0,  1165,     0,     0,   850,     0,     0,     0,     0,     0,
       0,     0,  1886,     0,     0,     0,   851,     0,     0,     0,
    1884,     0,     0,     0,  1884,  1884,  1165,  1165,     0,   852,
    1886,  1165,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1165,  1165,  1165,  1165,     0,     0,     0,
       0,   814,     0,     0,     0,     0,  1165,   814,  1886,  1165,
       0,  1165,     0,     0,     0,     0,     0,     0,     0,  3367,
       0,  1165,  1165,     0,     0,  1165,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1165,     0,
    1165,     0,     0,     0,  1165,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1165,     0,  2154,     0,     0,  2155,  1886,     0,     0,     0,
       0,  1165,     0,  1165,  1165,  1165,     0,     0,     0,     0,
    2154,     0,  2156,  2155,     0,  3983,     0,     0,     0,     0,
    2158,     0,     0,     0,     0,     0,  2159,  1165,     0,     0,
    2156,     0,     0,     0,     0,     0,  3412,     0,  2158,     0,
    1165,  3418,     0,     0,  2159,  1165,     0,     0,     0,     0,
    2160,     0,  1165,     0,     0,     0,     0,     0,  1165,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2160,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2830,     0,  2830,  2830,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3475,     0,     0,  3478,
       0,  3480,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1165,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3501,     0,
    3503,     0,     0,     0,  3506,     0,     0,     0,  4472,     0,
       0,  1892,     0,     0,     0,     0,     0,     0,     0,     0,
    2161,     0,  4475,     0,  2162,     0,     0,     0,     0,     0,
       0,     0,     0,  2912,  2912,  2912,     0,     0,  2161,     0,
       0,     0,  2162,     0,     0,  2163,  2164,     0,     0,     0,
       0,  1892,  1892,     0,  1892,     0,     0,  3563,     0,     0,
       0,  2165,  1886,  2163,  2164,     0,     0,     0,     0,     0,
    2262,     0,     0,     0,     0,  3575,     0,     0,     0,  2165,
       0,     0,  2275,   814,   814,   814,  2166,     0,     0,  2167,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2168,     0,  2166,  2169,  1892,  2167,  1892,     0,
       0,     0,     0,     0,     0,     0,  4525,     0,     0,     0,
    2168,     0,     0,  2169,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1161,     0,     0,     0,     0,     0,  3616,     0,
    1161,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1892,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2170,     0,     0,
       0,  1161,     0,     0,     0,  1892,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2170,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   814,     0,     0,
       0,     0,  1892,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   814,  1892,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1161,     0,     0,     0,     0,
       0,     0,     0,     0,  1161,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4625,  4627,  4627,     0,  2171,  2172,  2173,
       0,  2174,  2175,  2176,  2177,  2178,  2179,     0,     0,     0,
       0,     0,     0,     0,     0,  2171,  2172,  2173,  1892,  2174,
    2175,  2176,  2177,  2178,  2179,     0,     0,     0,     0,     0,
       0,     0,  1892,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1892,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1886,     0,     0,     0,     0,  1886,  1886,
       0,     0,     0,     0,     0,  1165,     0,     0,     0,     0,
    1886,     0,     0,     0,  1161,     0,     0,     0,     0,     0,
    1025,     0,     0,     0,  1025,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1165,  4700,     0,  1892,     0,     0,     0,     0,     0,  1161,
    1165,     0,     0,     0,     0,     0,  1165,     0,  1165,     0,
       0,     0,     0,  1892,  1165,     0,     0,  1165,  1165,  1165,
    1165,  1165,  1165,  1165,  1165,  1165,  1165,     0,     0,     0,
    1165,  1165,     0,     0,     0,     0,     0,     0,  1892,     0,
       0,     0,     0,  1165,     0,     0,     0,  1165,     0,   814,
       0,  1165,     0,     0,     0,     0,     0,     0,     0,     0,
     867,  1165,     0,     0,  1165,     0,  1165,     0,     0,     0,
       0,     0,   868,  4744,  1892,  1165,  1165,  1165,     0,     0,
       0,  1165,     0,     0,  1165,     0,     0,     0,     0,     0,
       0,  1886,     0,   869,  1165,  4762,     0,  4764,     0,     0,
       0,     0,     0,     0,  1165,     0,   870,     0,     0,     0,
       0,     0,  1165,     0,  1165,   871,     0,     0,     0,  -708,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   872,     0,     0,     0,
       0,     0,   873,     0,     0,     0,     0,     0,     0,     0,
    3934,     0,  1161,     0,     0,     0,     0,   874,     0,  1165,
    3938,  1886,  1161,     0,     0,  1165,  3939,     0,  3940,     0,
       0,  1165,     0,     0,     0,   875,     0,     0,     0,     0,
       0,     0,     0,     0,  1890,     0,   876,     0,  4627,     0,
    3958,  3959,     0,   877,     0,     0,  1165,   878,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2836,  -904,     0,     0,     0,     0,  1161,     0,     0,
       0,  3987,     0,     0,  3990,     0,  3992,     0,     0,     0,
    4849,     0,     0,     0,     0,  3996,     0,     0,     0,     0,
       0,  4001,     0,     0,  4004,     0,     0,     0,     0,     0,
     879,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1886,     0,   814,     0,  4033,     0,   814,  1892,   814,     0,
       0,     0,  4045,     0,  2912,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1161,     0,  4884,   880,     0,     0,
     881,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4062,
       0,     0,     0,     0,     0,  1518,     0,     0,     0,  4917,
       0,  1589,     0,     0,     0,     0,     0,     0,     0,     0,
     882,  1890,     0,     0,     0,     0,   883,     0,     0,     0,
       0,     0,  -386,     0,     0,   884,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1161,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -386,     0,   885,   886,     0,   887,   888,     0,     0,
       0,     0,  1165,     0,     0,   889,     0,     0,  1161,     0,
     890,     0,     0,     0,     0,     0,   891,     0,     0,   892,
       0,     0,   893,     0,     0,     0,     0,  1892,     0,     0,
       0,     0,     0,     0,     0,  -386,  1161,  1161,     0,  1161,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1161,     0,     0,  1892,
    1165,  1165,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1161,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1165,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1161,     0,     0,
       0,  1161,  1161,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1165,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1165,  1165,     0,
    1892,  1886,     0,     0,     0,  1165,  1165,     0,     0,     0,
    1165,  1892,     0,     0,     0,     0,  1165,  1165,     0,     0,
    1165,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1165,     0,     0,     0,  1165,
       0,  1886,  1886,     0,  1886,     0,     0,     0,  1165,  1890,
    4301,  4302,     0,  1165,     0,     0,     0,     0,     0,     0,
       0,     0,  1025,     0,     0,  1165,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1891,     0,  1025,     0,  1886,     0,  1886,     0,
       0,     0,  1890,     0,  1165,     0,     0,     0,     0,     0,
    4333,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1892,     0,     0,     0,     0,     0,     0,  1890,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   814,     0,     0,     0,     0,     0,     0,     0,     0,
    1892,  1886,     0,     0,     0,     0,     0,  4351,  4353,     0,
       0,     0,  1892,     0,     0,     0,     0,     0,     0,     0,
    4360,     0,     0,     0,     0,  1886,  4365,  4366,     0,     0,
    4368,  1025,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1890,     0,  1886,     0,     0,     0,  1892,     0,  2912,     0,
       0,     0,     0,  2912,     0,  1886,     0,     0,     0,  1890,
       0,     0,     0,     0,     0,  2912,   814,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1890,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1891,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4422,  1890,     0,     0,     0,  1165,
       0,     0,     0,     0,     0,     0,     0,     0,  1886,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1886,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1886,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1161,     0,     0,
       0,  1892,     0,  1890,     0,     0,  1161,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1165,     0,     0,     0,  1892,     0,
       0,     0,     0,  1165,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1886,     0,     0,     0,     0,     0,     0,
    1165,  1165,     0,     0,  1165,     0,     0,     0,     0,     0,
       0,     0,     0,  1886,     0,  1165,     0,     0,     0,     0,
    1165,     0,     0,  1165,     0,     0,     0,     0,  1165,  1165,
       0,     0,     0,  1161,     0,     0,     0,     0,  1886,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4508,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1165,     0,     0,     0,     0,     0,     0,     0,     0,
    1161,  1161,     0,     0,  1886,     0,     0,     0,  1161,     0,
       0,  1161,     0,     0,     0,  1161,     0,     0,     0,     0,
       0,     0,  1892,  1161,  1161,     0,  1165,     0,     0,     0,
       0,  1161,     0,     0,  1161,  1161,  1161,  1161,     0,     0,
       0,     0,     0,     0,  1161,  1161,     0,  1161,     0,  1161,
    1161,     0,     0,  1161,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1165,     0,     0,     0,  1891,     0,  1890,
    1161,     0,     0,     0,     0,  1161,     0,     0,     0,  1161,
       0,     0,     0,  1161,     0,  1161,  1161,  1161,  1161,  1161,
    1161,  1161,  1161,  1161,  4586,  1161,     0,     0,     0,     0,
       0,  1161,     0,     0,  1161,     0,     0,     0,     0,     0,
       0,     0,  1165,     0,  1892,     0,     0,     0,     0,  4603,
    2435,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1165,  1892,     0,  1165,
       0,  1165,     0,     0,     0,     0,     0,  1891,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1165,     0,
       0,     0,  1165,     0,     0,     0,  1161,  1892,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1886,     0,     0,
       0,     0,     0,   814,     0,     0,  1892,     0,     0,     0,
    1892,  1892,     0,     0,     0,     0,     0,     0,  1891,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1891,     0,     0,
       0,     0,     0,     0,  1165,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1891,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1892,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1891,     0,     0,     0,     0,     0,     0,
       0,     0,  1161,     0,     0,     0,     0,     0,  1161,  2836,
       0,     0,  1165,     0,  1161,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4725,  1165,
       0,     0,     0,     0,     0,     0,     0,     0,   908,     0,
       0,     0,     0,     0,  1025,     0,     0,   908,     0,     0,
    1890,  1891,     0,     0,     0,  1890,  1890,  1886,     0,     0,
       0,     0,     0,     0,  1165,     0,     0,  1890,     0,     0,
       0,     0,     0,     0,  1165,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   908,     0,  1886,
       0,     0,     0,     0,     0,  1165,  1165,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1165,     0,
       0,     0,     0,     0,  4786,     0,     0,     0,     0,     0,
    1080,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1165,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1165,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     814,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4830,
       0,     0,     0,     0,     0,     0,  1161,     0,  1890,     0,
    1886,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1886,  1165,     0,     0,     0,     0,   814,     0,     0,
       0,  1165,     0,     0,     0,   814,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1891,     0,     0,
       0,     0,     0,     0,     0,  4870,  4870,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1890,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2915,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1129,     0,     0,     0,     0,
       0,     0,     0,     0,  4870,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4914,     0,  1161,     0,     0,     0,
       0,     0,  1886,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1886,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1886,     0,     0,     0,     0,  1890,     0,     0,
       0,     0,  4870,     0,     0,     0,     0,     0,     0,     0,
       0,  1161,     0,     0,     0,     0,  1161,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1161,  1161,     0,     0,  1886,     0,  1161,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1161,  1161,     0,     0,     0,  1161,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1161,  1161,  1161,  1161,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1161,     0,     0,  1161,     0,  1161,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1161,  1161,
       0,     0,  1161,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1161,     0,  1161,     0,     0,
       0,  1161,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1161,  3082,     0,
       0,     0,     0,  2435,  3089,     0,     0,     0,  1161,     0,
    1161,  1161,  1161,     0,     0,  1891,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   908,   908,     0,  1161,     0,     0,     0,  1886,     0,
       0,     0,     0,     0,     0,     0,     0,  1161,     0,     0,
       0,     0,  1161,     0,     0,     0,     0,     0,     0,  1161,
       0,     0,     0,     0,     0,  1161,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1129,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1161,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1891,     0,  1890,     0,
       0,     0,  1886,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1890,  1890,
       0,  1890,     0,     0,     0,     0,     0,     0,  1175,     0,
       0,     0,     0,     0,     0,     0,     0,  1202,     0,  1205,
       0,  1208,     0,  1210,     0,     0,  2435,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1259,     0,     0,     0,     0,     0,     0,  1266,
       0,     0,     0,  1890,  1886,  1890,     0,     0,  1281,  1282,
       0,     0,     0,  1284,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1886,     0,  1129,
       0,   908,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1313,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1886,  1890,     0,
    1334,     0,     0,  1336,     0,  1338,     0,  1341,     0,     0,
       0,     0,     0,     0,     0,  1891,     0,     0,     0,     0,
       0,   908,  1890,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1886,     0,     0,     0,
    1886,  1886,     0,     0,     0,     0,     0,     0,     0,  1890,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1890,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1420,     0,  1421,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1129,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1890,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1890,
       0,  1080,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1890,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2915,  2915,
    2915,     0,  1161,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1678,     0,  1680,     0,     0,  1161,  1682,     0,
    1890,     0,     0,     0,     0,     0,     0,  1161,     0,     0,
       0,     0,     0,  1161,     0,  1161,     0,     0,     0,     0,
    1890,  1161,     0,     0,  1161,  1161,  1161,  1161,  1161,  1161,
    1161,  1161,  1161,  1161,     0,     0,     0,  1161,  1161,     0,
       0,     0,     0,     0,     0,  1890,     0,     0,     0,     0,
    1161,     0,     0,     0,  1161,     0,     0,     0,  1161,     0,
    1824,     0,     0,     0,     0,     0,     0,     0,  1161,     0,
       0,  1161,     0,  1161,     0,     0,  1837,     0,     0,     0,
       0,  1890,  1161,  1161,  1161,     0,     0,  1845,  1161,     0,
       0,  1161,     0,     0,  1847,     0,  1891,     0,     0,     0,
       0,  1161,     0,     0,     0,     0,  1898,     0,     0,     0,
       0,  1161,     0,     0,     0,     0,     0,     0,     0,  1161,
       0,  1161,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2435,  3089,  1940,  3089,
       0,     0,   663,     0,     0,     0,     0,   707,     0,   707,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   707,
       0,     0,     0,     0,     0,     0,  1161,     0,     0,     0,
       0,     0,  1161,     0,     0,     0,     0,     0,  1161,     0,
       0,     0,     0,     0,     0,   707,     0,     0,     0,     0,
       0,  1891,     0,  1891,     0,   707,     0,     0,     0,     0,
       0,     0,     0,  1161,     0,     0,   707,   707,     0,     0,
     707,     0,     0,     0,     0,     0,   707,     0,     0,     0,
     988,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     988,     0,     0,     0,     0,     0,  1891,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   707,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1891,     0,     0,     0,  1890,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     4,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3089,     0,     0,
       0,     0,     0,     0,     0,     5,     0,     0,     0,     0,
    3089,     0,     0,     0,     0,     6,     7,     0,     0,     0,
       0,     8,     0,     9,    10,     0,     0,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,     0,    36,     0,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,     0,    45,     0,     0,     0,
       0,     0,     0,  1891,     0,     0,     0,     0,  1887,     0,
       0,     0,     0,     0,     0,     0,     0,  3089,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1161,
    1891,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1890,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1080,  2255,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1890,  1161,  1161,     0,
       0,     0,     0,     0,   707,     0,     0,     0,  1891,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,  1891,     0,
       0,     0,     0,     0,  2321,     0,     0,  2321,     0,     0,
      48,     0,     0,     0,     0,  2328,     0,     0,     0,     0,
       0,     0,     0,  1891,     0,     0,     0,  1161,     0,     0,
      49,     0,     0,  2337,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1887,     0,     0,     0,     0,
       0,     0,    50,     0,     0,     0,     0,     0,     0,  1891,
       0,     0,     0,     0,  1161,     0,     0,     0,     0,     0,
    2400,     0,     0,     0,  1161,  1161,     0,  1890,     0,     0,
       0,     0,  1161,  1161,     0,     0,    51,  1161,  1890,    52,
       0,     0,     0,  1161,  1161,     0,     0,  1161,     0,  2915,
       0,     0,     0,     0,    53,     0,     0,     0,     0,     0,
       0,     0,  1161,     0,     0,     0,  1161,     0,     0,     0,
       0,     0,     0,     0,     0,  1161,     0,     0,     0,     0,
    1161,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1161,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    54,     0,     0,
       0,  1161,     0,     0,     0,     0,   707,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1890,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    55,
       0,     0,     0,     0,     0,     0,     0,  1890,     0,     0,
     707,   707,     0,    56,     0,     0,     0,     0,     0,  1890,
       0,     0,     0,     0,     0,     0,     0,     0,    57,     0,
       0,     0,  3089,     0,     0,     0,     0,     0,  2593,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2615,     0,     0,    58,     0,     0,     0,   707,     0,
      59,     0,     0,  1890,    60,    61,    62,    63,    64,     0,
       0,    65,    66,    67,    68,     0,    69,    70,    71,    72,
      73,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1887,     0,  2660,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2675,     0,  2677,     0,  2678,     0,     0,     0,     0,  2679,
       0,     0,     0,     0,     0,     0,  1161,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1887,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2707,     0,
       0,     0,     0,  1887,     0,     0,     0,     0,  1890,     0,
    2255,     0,  1891,     0,  2255,  1888,  2255,     0,     0,  2255,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1161,     0,     0,  2435,  1890,     0,     0,     0,     0,
    1161,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1161,  1161,     0,
       0,  1161,     0,     0,  1887,     0,     0,  1301,   707,     0,
     707,     0,  1161,     0,     0,     0,     0,  1161,     0,     0,
    1161,     0,     0,  1887,     0,  1161,  1161,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1887,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   707,     0,  1161,   707,
     707,     0,     0,     0,     0,     0,     0,     0,     0,  1887,
       0,     0,   663,     0,   988,     0,   988,     0,     0,     0,
       0,     0,   663,     0,     0,  1891,   707,  2916,     0,  1890,
       0,     0,     0,  1161,     0,     0,  1891,     0,     0,     0,
       0,     0,  1888,     0,     0,   988,   988,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1887,     0,     0,
    1161,     0,     0,  2915,     0,     0,     0,     0,  2915,     0,
       0,     0,     0,     0,     0,   707,     0,   707,     0,     0,
    2915,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1161,
       0,  1890,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1161,  1890,     0,  1161,  1891,  1161,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1129,   663,  1161,     0,     0,     0,  1161,
       0,     0,     0,     0,  1890,  1891,     0,     0,   663,   663,
    3004,  3005,  1660,     0,     0,  3008,  3009,  1891,     0,  3012,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3022,
       0,     0,     0,     0,     0,     0,  3031,     0,     0,     0,
    3034,  3035,     0,  1890,  3038,  3039,  3040,  1890,  1890,     0,
       0,     0,     0,     0,     0,     0,  3054,   663,  3056,     0,
       0,  1891,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3078,     0,     0,     0,     0,  3080,
       0,  1161,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1887,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1890,
    3098,  3099,  3102,  3104,     0,     0,     0,  3111,  3114,     0,
       0,     0,     0,     0,     0,  3125,     0,     0,  3129,     0,
       0,     0,  3133,     0,     0,     0,     0,     0,     0,  1161,
    1888,     0,     0,     0,     0,     0,     0,  3156,     0,     0,
       0,     0,     0,     0,     0,     0,  1161,     0,  3163,     0,
    3165,     0,     0,     0,     0,  3168,     0,     0,     0,     0,
    3172,  3173,  3174,  3175,     0,  3177,  4550,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3200,  3201,
    3202,  1161,     0,  1888,     0,     0,     0,     0,     0,  3210,
    3211,  1161,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1891,     0,     0,     0,     0,     0,     0,
    1888,     0,  1161,  1161,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1161,     0,     0,     0,     0,
       0,   663,     0,     0,     0,     0,   707,     0,   707,     0,
       0,   707,     0,   707,     0,  3270,   707,   707,   707,     0,
       0,     0,  2038,     0,     0,     0,     0,     0,     0,   707,
       0,  1161,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1161,   707,     0,   707,     0,     0,     0,     0,   707,
       0,  1888,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1888,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3089,  1888,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1161,
       0,     0,     0,     0,     0,     0,     0,     0,  1161,     0,
       0,     0,     0,     0,     0,     0,  1888,     0,     0,     0,
       0,     0,     0,     0,  1887,     0,     0,     0,     0,  1887,
    1887,     0,  1129,     0,     0,     0,     0,     0,     0,     0,
       0,  1887,     0,     0,     0,  2255,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2195,     0,     0,     0,
       0,     0,     0,  3395,  1888,   707,   707,     0,     0,  3089,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   663,     0,     0,     0,     0,   663,   663,     0,
       0,     0,  1891,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1891,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1891,  1887,     0,     0,  1891,  1891,     0,   707,     0,
     663,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2325,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4550,     0,     0,
       0,     0,  1887,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   663,     0,     0,     0,     0,     0,     0,
       0,   663,     0,     0,     0,  3566,     0,     0,     0,     0,
    1888,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   663,     0,
       0,   663,   663,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3607,  3608,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1887,  2255,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   663,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3641,  3643,     0,     0,     0,
    3643,     0,     0,     0,     0,  3654,  3655,  3656,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1166,     0,     0,     0,     0,     0,     0,     0,
    1166,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3677,  3678,  3679,  3680,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3705,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1166,     0,     0,     0,     0,
       0,     0,     0,     0,  1166,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3743,
       0,     0,     0,     0,     0,     0,     0,  3747,     0,     0,
       0,  1888,     0,     0,     0,     0,  1888,  1888,     0,     0,
       0,   707,     0,   707,     0,     0,     0,   707,  1888,   707,
       0,     0,   707,     0,     0,     0,   707,     0,     0,     0,
       0,  2195,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3828,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3834,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1166,     0,     0,     0,     0,     0,
       0,     0,     0,  3853,     0,  3855,     0,     0,     0,     0,
       0,     0,  1887,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1166,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     908,     0,     0,  3895,     0,     0,     0,     0,     0,     0,
       0,     0,  1887,  1887,     0,  1887,     0,  3905,     0,  1888,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2255,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2038,
       0,     0,     0,     0,     0,     0,  2917,     0,     0,     0,
       0,     0,     0,     0,     0,  2325,     0,  1887,     0,  1887,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1888,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1887,     0,     0,     0,     0,     0,     0,   663,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1166,     0,     0,     0,  1887,     0,     0,     0,
       0,     0,  1166,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1887,  1893,     0,     0,   663,     0,     0,
       0,   663,     0,     0,     0,     0,  1887,  2988,  1888,  1660,
       0,     0,   707,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1166,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1887,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1887,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1166,     0,  1887,     0,     0,     0,
    4103,     0,  4104,     0,     0,     0,  4106,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4115,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4123,     0,
       0,     0,     0,     0,     0,     0,     0,  4134,     0,     0,
       0,  1893,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1887,     0,     0,     0,     0,     0,
     663,     0,     0,     0,     0,     0,     0,     0,   663,  1166,
     663,     0,     0,     0,  1887,     0,     0,  4162,  4163,  4164,
    4165,  4166,  4167,  4168,     0,     0,     0,     0,  4175,  4176,
       0,  4178,  4179,  4180,  4181,  4182,  4183,  4184,  1166,  1887,
       0,     0,     0,     0,     0,     0,  4191,     0,  4193,  4194,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1166,  1166,     0,  1166,
       0,     0,     0,     0,     0,  1887,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1166,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4247,  4249,  4251,     0,     0,  4254,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1166,  1888,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1166,     0,     0,
       0,  1166,  1166,     0,     0,     0,     0,     0,     0,  1888,
    1888,     0,  1888,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3643,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2255,  2255,  2255,     0,     0,     0,     0,
       0,   707,  2038,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1888,     0,  1888,     0,   663,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1893,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1887,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1888,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1893,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1888,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1893,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1888,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1888,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1893,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1888,     0,  1887,  1893,
    4441,  4442,  4443,  4444,     0,     0,     0,     0,     0,     0,
    1888,     0,     0,     0,  2325,     0,     0,  1893,     0,   663,
       0,     0,     0,  1888,     0,  4457,  4458,     0,     0,     0,
    1887,     0,     0,     0,     0,     0,     0,  4467,  4468,     0,
       0,     0,     0,     0,     0,  1893,     0,     0,     0,     0,
       0,     0,     0,  2255,  2255,     0,  2255,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1888,     0,     0,     0,     0,     0,  1166,     0,     0,
       0,     0,     0,  1893,     0,     0,  1166,     0,     0,     0,
       0,  1888,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1888,     0,     0,     0,
       0,  1887,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1887,     0,     0,     0,  4519,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1888,     0,     0,     0,     0,     0,     0,  4541,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1166,     0,     0,     0,     0,     0,     0,
       0,  4560,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1166,  1166,     0,     0,     0,     0,     0,     0,  1166,     0,
       0,  1166,     0,     0,     0,  1166,     0,     0,     0,     0,
       0,     0,     0,  1166,  1166,     0,     0,     0,     0,     0,
    2255,  1166,     0,  1887,  1166,  1166,  1166,  1166,     0,     0,
       0,     0,     0,  2255,  1166,  1166,     0,  1166,     0,  1166,
    1166,     0,     0,  1166,     0,     0,     0,     0,     0,     0,
       0,  1887,     0,     0,     0,     0,     0,     0,     0,  1893,
    1166,     0,     0,  1887,     0,  1166,     0,     0,     0,  1166,
       0,     0,     0,  1166,     0,  1166,  1166,  1166,  1166,  1166,
    1166,  1166,  1166,  1166,     0,  1166,     0,     0,     0,     0,
       0,  1166,     0,     0,  1166,     0,     0,     0,   663,     0,
       0,     0,     0,     0,     0,     0,     0,  1887,     0,     0,
       0,   663,     0,  4646,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1888,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1166,     0,     0,  4670,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3643,     0,   707,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2255,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2255,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   663,     0,  1887,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1888,     0,     0,  4750,     0,
       0,     0,  1166,     0,     0,     0,     0,     0,  1166,     0,
       0,     0,     0,     0,  1166,  2255,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1888,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1893,     0,     0,     0,     0,  1893,  1893,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1893,     0,     0,
       0,     0,     0,  3643,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2255,     0,     0,  1887,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1888,     0,
       0,     0,     0,     0,  2181,  4848,     0,     0,     0,  1888,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2988,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1887,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1166,     0,  1893,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1887,     0,
       0,     0,     0,     0,     0,  2181,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1887,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1888,     0,     0,   663,     0,     0,     0,     0,  1893,     0,
       0,     0,     0,     0,     0,     0,     0,  1887,     0,   663,
       0,  1887,  1887,     0,     0,     0,     0,     0,  1888,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1888,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1166,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   663,
       0,     0,     0,     0,  1888,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1893,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1166,     0,     0,     0,     0,  1166,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1166,  1166,     0,     0,     0,     0,  1166,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1166,  1166,     0,     0,     0,  1166,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1166,  1166,  1166,  1166,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1166,     0,     0,  1166,     0,  1166,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1166,  1166,
       0,     0,  1166,     0,     0,     0,     0,   663,     0,     0,
       0,     0,     0,     0,     0,  1166,  1888,  1166,     0,     0,
       0,  1166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1166,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1166,     0,
    1166,  1166,  1166,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1166,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1166,     0,     0,
       0,     0,  1166,     0,     0,     0,     0,     0,     0,  1166,
       0,     0,     0,     0,     0,  1166,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1888,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2325,     0,  2181,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1166,     0,     0,     0,     0,
       0,   663,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1893,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1888,   663,     0,     0,     0,     0,  1893,  1893,
       0,  1893,     0,     0,     0,     0,     0,     0,  2181,     0,
       0,     0,     0,     0,     0,  1888,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2181,     0,     0,     0,     0,  2814,     0,     0,
       0,     0,     0,     0,     0,  1888,     0,     0,     0,     0,
       0,     0,     0,  1893,     0,  1893,     0,  2181,  2181,     0,
       0,  2181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1888,     0,     0,     0,  1888,  1888,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   663,
       0,  2181,     0,     0,     0,     0,     0,     0,  1893,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1893,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2181,     0,     0,     0,  1893,
       0,     0,     0,     0,     0,     0,     0,     4,     0,     0,
       0,     0,  1893,     0,     0,     0,     0,     0,  2181,     0,
       0,     0,     0,     0,     0,     0,     0,     5,  2181,     0,
       0,  2181,     0,     0,     0,     0,     0,     6,     7,     0,
       0,     0,     0,     0,     0,     9,    10,     0,     0,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,     0,  1893,     0,    37,    38,    39,
      40,    41,    42,    43,    44,     0,     0,     0,    45,  1893,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1893,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   707,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1166,     0,     0,     0,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   663,     0,
       0,     0,     0,     0,     0,     0,     0,  1166,     0,     0,
    1893,     0,     0,     0,     0,     0,     0,  1166,     0,     0,
       0,     0,     0,  1166,     0,  1166,     0,     0,     0,     0,
    1893,  1166,     0,     0,  1166,  1166,  1166,  1166,  1166,  1166,
    1166,  1166,  1166,  1166,     0,     0,    47,  1166,  1166,     0,
       0,     0,     0,     0,     0,  1893,     0,     0,     0,     0,
    1166,     0,    48,     0,  1166,     0,     0,     0,  1166,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1166,     0,
       0,  1166,    49,  1166,     0,     0,     0,     0,     0,     0,
       0,  1893,  1166,  1166,  1166,     0,     0,     0,  1166,     0,
       0,  1166,     0,     0,    50,     0,     0,     0,     0,     0,
       0,  1166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1166,     0,     0,     0,     0,     0,     0,     0,  1166,
       0,  1166,     0,     0,     0,     0,     0,     0,    51,     0,
       0,    52,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    53,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1166,     0,     0,     0,
       0,     0,  1166,     0,     0,     0,     0,     0,  1166,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1166,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    54,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   663,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    55,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1893,    56,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      57,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    58,     0,     0,     0,
       0,     0,    59,     0,     0,     0,    60,    61,    62,    63,
      64,     0,     0,    65,    66,  1349,     0,     0,     0,     0,
      71,  1350,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2181,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2181,     0,  2181,     0,  2814,  2814,  3449,     0,  1166,
    2814,     0,     0,     0,  2181,     0,     0,     0,     0,     0,
       0,  2181,     0,     0,     0,     0,  2181,     0,     0,     0,
       0,     0,  2181,     0,  1893,     0,     0,  2181,     0,     0,
       0,     0,     0,     0,     0,     0,  2181,     0,     0,     0,
    2814,  2814,     0,  2181,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2181,  1893,  1166,  1166,     0,
       0,     0,  2181,     0,  2181,  2181,  2181,  2181,  2181,  2181,
    2181,  2181,  2181,  2181,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2181,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1166,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1166,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1166,  1166,     0,  1893,     0,     0,
       0,     0,  1166,  1166,     0,     0,     0,  1166,  1893,     0,
       0,     0,     0,  1166,  1166,     0,     0,  1166,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1166,     0,     0,     0,  1166,     0,     0,     0,
       0,     0,     0,     0,     0,  1166,     0,     0,     0,     0,
    1166,     0,  2181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1166,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1893,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1893,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1893,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       4,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       5,     0,     0,  1893,     0,     0,     0,     0,     0,     0,
       6,     7,     0,     0,     0,     0,     0,     0,     9,    10,
       0,     0,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,     0,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
       0,    45,  2181,     0,     0,     0,  1166,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,  1893,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1166,     0,     0,     0,  1893,     0,     0,     0,     0,
    1166,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1166,  1166,    47,
       0,  1166,     0,  2181,     0,     0,     0,     0,     0,     0,
       0,     0,  1166,     0,     0,    48,     0,  1166,     0,     0,
    1166,     0,     0,     0,     0,  1166,  1166,     0,     0,     0,
       0,     0,     0,     0,     0,    49,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2181,     0,
       0,     0,     0,     0,  2181,     0,     0,    50,  1166,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3449,  3449,     0,  2814,     0,     0,  2814,  2814,  2814,  2814,
    2814,  2814,  2814,  2814,  2814,  2814,  3449,     0,     0,  1893,
       0,    51,     0,  1166,    52,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    53,
       0,  2181,     0,     0,  2181,     0,  2181,     0,     0,     0,
       0,  3449,  3449,     0,     0,     0,     0,     0,     0,     0,
    1166,     0,     0,     0,     0,  2814,  2814,  2181,     0,  2181,
       0,     0,  2181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1166,
       0,  1893,    54,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2181,
       0,     0,     0,  1166,  1893,     0,  1166,     0,  1166,     0,
       0,  2181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    55,  1166,     0,     0,     0,  1166,
       0,     0,     0,     0,  1893,     0,     0,     0,    56,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2181,    57,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1893,     0,     0,     0,  1893,  1893,    58,
       0,     0,     0,     0,     0,    59,     0,     0,     0,    60,
      61,    62,    63,    64,     0,     0,    65,    66,  1349,  1995,
       0,     0,     0,    71,     0,     0,     0,     0,     0,     0,
       0,  1166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1893,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1166,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1166,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2814,  1166,  1166,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1166,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1166,
    2181,     0,     0,     0,  2181,  2181,  2181,     0,  1166,  3449,
       0,     0,     0,     0,  3449,  3449,  3449,  3449,  3449,  3449,
    3449,  3449,  3449,  3449,  2181,  2181,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2181,  2814,  2814,  2181,     0,  2181,     0,
       0,     0,  2181,  3449,  3449,     0,     0,  2181,     0,     0,
    2181,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2181,
       4,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2181,     0,     0,     0,     0,     0,     0,     0,     0,
       5,     0,     0,     0,     0,     0,     0,     0,  2181,     0,
       6,     7,     0,     0,     0,     0,     0,     0,     9,    10,
       0,     0,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,     0,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
       0,    45,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
       0,     0,     0,     0,     0,    86,    87,    88,     0,    90,
      91,    92,     0,     0,     0,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,     0,     0,     0,
     107,   108,   109,   110,     0,   111,   112,   113,   114,   115,
       0,   116,   117,   118,     0,     0,     0,     0,     0,   121,
     122,     0,     0,     0,     0,   123,     0,     0,     0,     0,
       0,     0,     0,     0,   124,     0,   125,     0,   126,    47,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,    48,     0,     0,     0,     0,
       0,  3449,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    49,     0,     0,     0,     0,
       0,     0,     0,     0,   133,     0,     0,     0,   135,   136,
     137,   138,   139,     0,     0,     0,     0,    50,     0,     0,
       0,     0,     0,     0,   140,     0,     0,  2181,  2181,     0,
       0,   144,     0,   145,     0,     0,     0,     0,     0,   148,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     151,    51,     0,     0,    52,     0,   152,     0,     0,  2181,
       0,     0,     0,  2814,     0,     0,   155,   156,     0,    53,
       0,     0,     0,     0,     0,     0,     0,  2181,     0,  2181,
       0,     0,     0,     0,  3449,  3449,  2181,     0,     0,  2814,
    2814,  2181,  2181,   162,  2181,     0,     0,     0,     0,     0,
     164,     0,     0,     0,   166,     0,     0,     0,     0,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   172,     0,     0,     0,     0,     0,     0,
       0,     0,   173,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    54,     0,     0,   174,   175,     0,  2181,     0,
       0,     0,   176,     0,   177,     0,     0,   178,   179,     0,
     180,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     181,   182,     0,   183,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    55,     0,     0,     0,     0,     0,
       0,     0,   188,   189,   190,     0,     0,   191,    56,     0,
       0,   193,     0,     0,   194,     0,   195,     0,     0,     0,
       0,     0,     0,    57,     0,     0,     0,     0,     0,   196,
     197,   198,   199,   200,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   201,  2181,   202,     0,     0,     0,    58,
       0,     0,     0,     0,     0,    59,     0,   204,     0,    60,
      61,    62,    63,    64,     0,     0,    65,    66,  1349,  2688,
       0,     0,     0,    71,     0,     0,   210,     0,     0,   212,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   217,     0,     0,   219,
       0,   220,     0,     0,  3449,  2814,     0,     0,     0,     0,
       0,     0,     0,     0,   222,     0,     0,     0,     0,     0,
    3449,  3449,  2181,     0,     0,     0,   224,   225,     0,     0,
       0,   226,     0,   227,     0,     0,     0,     0,     0,  2181,
       0,     0,   230,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   234,     0,     0,
     235,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   237,   238,   239,   240,   241,   242,
     243,   244,   245,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2978,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3449,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2181,     0,     0,     0,
     717,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     718,   104,   105,   672,   719,     0,   107,   108,   109,   110,
     720,   721,   112,   113,   114,   115,  2181,   116,   722,   723,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
    2181,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,   724,   421,   422,   423,   725,   726,
     727,   728,   729,   730,   731,   424,   425,   732,   426,   427,
     133,   428,   429,   430,   135,   136,   137,   138,   139,   733,
     431,   432,   433,   434,   435,   734,   735,   436,   437,   736,
     140,   438,   737,   439,   440,   441,   442,   144,   738,   145,
     739,   443,   444,   445,   446,   148,   447,   740,   741,   448,
     449,   450,   451,   452,   453,   742,   151,   454,   743,   744,
     745,   746,   152,   747,   748,   749,   455,   456,   457,   458,
     686,   459,   155,   156,   460,   750,   461,   751,   462,   463,
     464,   465,   466,   752,   467,   468,   469,   753,   754,   470,
     471,   472,   473,   474,   755,   475,   476,   477,   756,   478,
     479,   757,   480,   481,   482,   483,   164,   484,   485,   486,
     166,   758,   487,   759,   488,   168,   489,   760,   490,   761,
     491,   169,   762,   170,   492,   493,   494,   763,   495,   172,
     764,   496,   765,   497,   498,   688,   499,   500,   173,   501,
     502,   503,   766,   504,   505,   506,   507,   508,   509,   767,
     510,   174,   175,   768,   511,   512,   513,   769,   176,   770,
     177,   771,   514,   178,   179,   515,   180,   516,   517,   518,
     519,   520,   521,   522,   772,   523,   181,   182,   524,   183,
     773,   525,   526,   527,   774,   775,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,   189,
     190,   538,   539,   191,   776,   540,   541,   193,   542,   777,
     194,   543,   195,   544,   545,   546,   778,   547,   779,   780,
     548,   549,   550,   781,   782,   196,   197,   198,   199,   200,
     551,   552,   553,   554,   555,   556,   557,   783,   558,   201,
     559,   202,   560,   561,   562,   784,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,   785,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   786,
     584,   585,   210,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,   787,   595,   596,   597,   598,   599,
     788,   600,   217,   601,   602,   219,   603,   220,   604,   789,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,   790,   615,   616,   791,   617,   618,   619,   620,   621,
     622,   792,   224,   225,   793,   794,   624,   226,   625,   227,
     795,   626,   627,   628,   629,   630,   631,   632,   796,   797,
     633,   634,   635,   636,   637,   798,   799,   638,   639,   640,
     641,   642,   800,   234,   801,   643,   235,   644,   645,   646,
     802,   803,   647,   804,   805,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,    85,     0,     0,    86,    87,    88,    89,    90,
      91,    92,    93,     0,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   950,   104,   105,   106,     0,     0,
     107,   108,   109,   110,     0,   111,   112,   113,   114,   115,
       0,   116,   117,   118,   119,   120,     0,     0,     0,   121,
     122,     0,     0,     0,     0,   123,     0,     0,     0,     0,
       0,     0,     0,     0,   124,     0,   125,     0,   126,   127,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     129,     0,   130,   131,     0,     0,     0,     0,     0,     0,
       0,     0,   132,     0,   133,     0,     0,   134,   135,   136,
     137,   138,   139,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   140,     0,     0,   141,     0,   142,
     143,   144,     0,   145,     0,   146,     0,   147,     0,   148,
       0,     0,     0,     0,     0,     0,     0,   149,     0,   150,
     151,     0,     0,     0,     0,     0,   152,     0,     0,     0,
       0,     0,     0,   153,     0,   154,   155,   156,   157,     0,
       0,     0,     0,     0, -1349,     0,     0,     0,     0,     0,
     158,     0,   159,     0,     0,     0,   160,     0,     0,     0,
       0,     0,   161,   162,     0,     0,     0,     0,     0,   163,
     164,   165,     0,     0,   166,     0,     0,   167,     0,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,   171,     0,   172,     0,     0,     0,     0,     0,     0,
       0,     0,   173,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   174,   175,     0,     0, -1349,
       0,     0,   176,     0,   177,     0,     0,   178,   179,     0,
     180,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     181,   182,     0,   183,     0,   184,   185,     0,     0,     0,
       0,   186,     0,     0,     0,     0,     0,     0,     0,   187,
       0,     0,   188,   189,   190,     0,     0,   191,     0,     0,
     192,   193,     0,     0,   194,     0,   195,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   196,
     197,   198,   199,   200,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   201,     0,   202,     0,   203,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   204,   205,     0,
       0,     0,     0,   206,     0,   207,     0,     0,     0,     0,
     208,     0,     0,     0,     0,   209,   210,     0,   211,   212,
       0,     0,   213,     0,     0,     0,     0,   214,   215,     0,
       0,     0,     0,     0,     0,   216,   217,     0,   218,   219,
       0,   220,     0,     0,     0,     0,   221,     0,     0,     0,
       0,     0,     0,     0,   222,     0,     0,     0,   223,     0,
       0,     0,     0,     0,     0,     0,   224,   225,     0,     0,
       0,   226,     0,   227,     0,   228,     0,   229,     0,     0,
       0,     0,   230,     0,     0,   231,     0,     0, -1349,     0,
       0,   232,     0,     0,     0,     0,   233,   234,     0,     0,
     235,     0,     0,     0,     0,     0,     0,     0,   236,     0,
       0,     0,     0,     0,   237,   238,   239,   240,   241,   242,
     243,   244,   245,    86,    87,    88,     0,    90,    91,    92,
       0,     0,     0,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   246,   104,   105,     0,  -132,     0,   107,   108,
     109,   110,     0,   111,   112,   113,   114,   115,     0,   116,
     117,   118,     0,     0,     0,     0,     0,   121,   122,     0,
       0,     0,     0,   123,     0,     0,     0,     0,     0,     0,
       0,     0,   124,     0,   125,     0,   126,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   133,     0,     0,     0,   135,   136,   137,   138,
     139,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   140,     0,     0,     0,     0,     0,     0,   144,
       0,   145,     0,     0,     0,     0,     0,   148,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   151,     0,
       0,     0,     0,     0,   152,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   155,   156,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   162,     0,     0,     0,     0,     0,     0,   164,     0,
       0,     0,   166,     0,     0,     0,     0,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   172,     0,     0,     0,     0,     0,     0,     0,     0,
     173,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   174,   175,     0,     0,     0,     0,     0,
     176,     0,   177,     0,     0,   178,   179,     0,   180,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   181,   182,
       0,   183,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     188,   189,   190,     0,     0,   191,     0,     0,     0,   193,
       0,     0,   194,     0,   195,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   196,   197,   198,
     199,   200,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   201,     0,   202,     0,     0,    85,     0,     0,     0,
       0,     0,    89,     0,     0,   204,    93,     0,    94,     0,
      96,    97,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   106,     0,     0,   210,     0,     0,   212,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   119,   120,
       0,     0,     0,     0,   217,     0,     0,   219,     0,   220,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   222,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   224,   225,     0,     0,     0,   226,
       0,   227,     0,     0,   128,     0,     0,     0,     0,     0,
     230,     0,     0,     0,   129,     0,   130,   131,     0,     0,
       0,     0,     0,     0,     0,   234,     0,     0,   235,     0,
       0,  1099,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   141,     0,   142,   143,     0,     0,     0,     0,   146,
       0,   147,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   149,     0,   150,     0,     0,     0,  2980,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   153,     0,   154,
       0,     0,   157,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   158,     0,   159,     0,     0,     4,
     160,     0,     0,     0,     0,     0,   161,     0,     0,     0,
       0,     0,     0,   163,     0,   165,     0,     0,     0,     5,
       0,   167,     0,     0,     0,     0,     0,     0,     0,     6,
       7,     0,     0,     0,     0,   171,     0,     9,    10,     0,
       0,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,     0,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,     0,     0,     0,
      45,     0,     0,     0,     0,     0,     0,     0,     0,   184,
     185,     0,     0,     0,     0,   186,     0,     0,     0,     0,
       0,     0,     0,   187,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   192,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   203,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   205,     0,     0,     0,     0,   206,     0,   207,
       0,     0,     0,     0,   208,     0,     0,     0,     0,   209,
       0,     0,   211,     0,     0,     0,   213,     0,     0,     0,
       0,   214,   215,     0,     0,     0,     0,     0,    47,   216,
       0,     0,   218,     0,     0,     0,     0,     0,     0,     0,
     221,     0,     0,     0,    48,     0,     0,     0,     0,     0,
       0,     0,   223,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    49,     0,     0,     0,     0,   228,
       0,   229,     0,     0,     0,     0,     0,     0,     0,   231,
       0,     0,     0,     0,     0,   232,    50,     0,     0,     0,
     233,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   236,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      51,     0,     0,    52,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   246,     0,    53,     0,
    -132,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    54,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    55,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    56,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    57,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    58,     0,
       0,     0,     0,     0,    59,     0,     0,     0,    60,    61,
      62,    63,    64,     0,     0,    65,    66,  1349,     0,     0,
       0,     0,    71,   717,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   718,   104,   105,   672,   719,     0,   107,
     108,   109,   110,   720,   721,   112,   113,   114,   115,     0,
     116,   722,   723,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
     412,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1437,  1438,  1439,    45,  1440,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,  2906,   421,   422,
     423,     0,     0,     0,     0,  1441,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,   135,  1442,   137,
    1443,  1444,     0,   431,   432,   433,   434,   435,  1445,  1446,
     436,   437,  1447,  1448,   438,     0,   439,   440,   441,   442,
    1449,     0,  1450,     0,   443,   444,   445,   446,   148,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,
     456,   457,   458,   686,   459,  1458,  1459,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
    2907,     0,   470,   471,  1460,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,  1461,
     484,   485,   486,  1462,  1463,   487,     0,   488,  1464,   489,
       0,   490,     0,   491,   169,     0,   170,   492,   493,   494,
       0,   495,  1465,     0,   496,     0,   497,   498,   688,   499,
     500,   173,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,   174,   175,     0,   511,   512,   513,
    1466,  1467,     0,  1468,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,  1469,
     182,   524,   183,     0,   525,   526,   527,  1470,  1471,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,  1472,   189,  1473,   538,   539,   191,  1474,   540,   541,
     193,   542,  1475,  1476,   543,  1477,   544,   545,   546,     0,
     547,     0,     0,  1478,   549,   550,     0,     0,   196,   197,
     198,   199,  1479,   551,   552,   553,   554,   555,   556,   557,
       0,   558,  1480,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,  1481,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,  1482,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,  1483,   600,   217,   601,   602,   219,   603,
    1484,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,  1485,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,  1486,  1487,     0,     0,   624,
    1488,   625,  1489,  1490,   626,   627,   628,   629,   630,   631,
     632,     0,  1491,   633,   634,   635,   636,   637,  1492,     0,
     638,   639,   640,   641,   642,   692,  1493,  2908,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,  1494,  1495,  1496,  1497,  1498,  1499,
    1500,  1501,   693,   653,   654,     0,     0,     0,     0,     0,
       0,     0,  1502,  1503,  2909,     0,     0,     0,     0,     0,
       0,  1505,  2910,   717,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   718,   104,   105,   672,   719,     0,   107,
     108,   109,   110,   720,   721,   112,   113,   114,   115,     0,
     116,   722,   723,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
     412,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1437,  1438,  1439,    45,  1440,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,  1441,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,   135,  1442,   137,
    1443,  1444,     0,   431,   432,   433,   434,   435,  1445,  1446,
     436,   437,  1447,  1448,   438,     0,   439,   440,   441,   442,
    1449,     0,  1450,     0,   443,   444,   445,   446,   148,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,
     456,   457,   458,   686,   459,  1458,  1459,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,  1460,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,  1461,
     484,   485,   486,  1462,  1463,   487,     0,   488,  1464,   489,
       0,   490,     0,   491,   169,     0,   170,   492,   493,   494,
       0,   495,  1465,     0,   496,     0,   497,   498,   688,   499,
     500,   173,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,   174,   175,     0,   511,   512,   513,
    1466,  1467,     0,  1468,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,  1469,
     182,   524,   183,     0,   525,   526,   527,  1470,  1471,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,  1472,   189,  1473,   538,   539,   191,  1474,   540,   541,
     193,   542,  1475,  1476,   543,  1477,   544,   545,   546,     0,
     547,     0,     0,  1478,   549,   550,     0,     0,   196,   197,
     198,   199,  1479,   551,   552,   553,   554,   555,   556,   557,
       0,   558,  1480,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,  1481,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,  1482,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,  1483,   600,   217,   601,   602,   219,   603,
    1484,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,  1485,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,  1486,  1487,     0,     0,   624,
    1488,   625,  1489,  1490,   626,   627,   628,   629,   630,   631,
     632,     0,  1491,   633,   634,   635,   636,   637,  1492,     0,
     638,   639,   640,   641,   642,   692,  1493,     0,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,  1494,  1495,  1496,  1497,  1498,  1499,
    1500,  1501,   693,   653,   654,     0,     0,     0,     0,     0,
       0,     0,  1502,  1503,     0,     0,     0,     0,     0,     0,
       0,  1505,  2816,   717,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   718,   104,   105,   672,   719,     0,   107,
     108,   109,   110,   720,   721,   112,   113,   114,   115,     0,
     116,   722,   723,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,     0,  1859,   137,
    1860,  1861,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,  1862,  1863,   438,     0,   439,   440,   441,   442,
       0,     0,   145,     0,   443,   444,   445,   446,   148,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,     0,     0,     0,   152,     0,     0,     0,   455,
     456,   457,   458,   686,   459,  1864,  1865,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,  1460,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,     0,
     484,   485,   486,     0,     0,   487,     0,   488,  1866,   489,
       0,   490,     0,   491,   169,     0,   170,   492,   493,   494,
       0,   495,     0,     0,   496,     0,   497,   498,   688,   499,
     500,   173,   501,   502,   503,  2423,   504,   505,   506,   507,
     508,   509,     0,   510,   174,  2424,     0,   511,   512,   513,
    1466,  1867,     0,  1868,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,     0,
     182,   524,   183,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,  1869,   189,  1870,   538,   539,     0,     0,   540,   541,
     193,   542,     0,     0,   543,  1871,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,  2425,   197,
     198,   199,     0,   551,   552,   553,   554,   555,   556,   557,
       0,   558,     0,   559,     0,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,  1872,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,     0,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,  2426,   601,   602,   219,   603,
    1874,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,     0,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,  1875,  1876,     0,     0,   624,
       0,   625,     0,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,     0,  1877,  2427,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   693,   653,   654,     0,     0,     0,     0,   717,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,  2428,    98,    99,   100,   101,   102,   103,   718,
     104,   105,   672,   719,     0,   107,   108,   109,   110,   720,
     721,   112,   113,   114,   115,     0,   116,   722,   723,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,   133,
     428,   429,   430,     0,  1859,   137,  1860,  1861,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,  1862,  1863,
     438,     0,   439,   440,   441,   442,     0,     0,   145,     0,
     443,   444,   445,   446,   148,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,   151,   454,     0,     0,     0,
       0,   152,     0,     0,     0,   455,   456,   457,   458,   686,
     459,  1864,  1865,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
    1460,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,     0,   484,   485,   486,     0,
       0,   487,     0,   488,  1866,   489,     0,   490,     0,   491,
     169,     0,   170,   492,   493,   494,     0,   495,     0,     0,
     496,     0,   497,   498,   688,   499,   500,   173,   501,   502,
     503,  2423,   504,   505,   506,   507,   508,   509,     0,   510,
     174,  2424,     0,   511,   512,   513,  1466,  1867,     0,  1868,
       0,   514,   178,   179,   515,   180,   516,   517,   518,   519,
     520,   521,   522,     0,   523,     0,   182,   524,   183,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,  1869,   189,  1870,
     538,   539,     0,     0,   540,   541,   193,   542,     0,     0,
     543,  1871,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,  2425,   197,   198,   199,     0,   551,
     552,   553,   554,   555,   556,   557,     0,   558,     0,   559,
       0,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,  1872,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,   210,   586,   587,     0,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,  2426,   601,   602,   219,   603,  1874,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,     0,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,  1875,  1876,     0,     0,   624,     0,   625,     0,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,     0,  1877,  2427,   643,   235,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   693,   653,
     654,     0,     0,     0,     0,   717,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,  3329,    98,
      99,   100,   101,   102,   103,   718,   104,   105,   672,   719,
       0,   107,   108,   109,   110,   720,   721,   112,   113,   114,
     115,     0,   116,   722,   723,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,   412,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1437,  1438,  1439,    45,  1440,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,  1441,     0,     0,
     424,   425,     0,   426,   427,   133,   428,   429,   430,   135,
    1442,   137,  1443,  1444,  2826,   431,   432,   433,   434,   435,
    1445,  1446,   436,   437,  1447,  1448,   438,     0,   439,   440,
     441,   442,  1449,     0,  1450,     0,   443,   444,   445,   446,
     148,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,   151,   454,     0,  1451,  1452,  1453,  1454,  1455,  1456,
    1457,   455,   456,   457,   458,   686,   459,  1458,  1459,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,  1460,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,  1461,   484,   485,   486,  1462,  1463,   487,     0,   488,
    1464,   489,     0,   490,     0,   491,   169,  2827,   170,   492,
     493,   494,     0,   495,  1465,     0,   496,     0,   497,   498,
     688,   499,   500,   173,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,   174,   175,     0,   511,
     512,   513,  1466,  1467,     0,  1468,     0,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,  2828,
     523,  1469,   182,   524,   183,     0,   525,   526,   527,  1470,
    1471,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,  1472,   189,  1473,   538,   539,   191,  1474,
     540,   541,   193,   542,  1475,  1476,   543,  1477,   544,   545,
     546,     0,   547,     0,     0,  1478,   549,   550,     0,     0,
     196,   197,   198,   199,  1479,   551,   552,   553,   554,   555,
     556,   557,     0,   558,  1480,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,  1481,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,   210,   586,   587,
    1482,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,  1483,   600,   217,   601,   602,
     219,   603,  1484,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,  1485,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,  1486,  1487,     0,
    2829,   624,  1488,   625,  1489,  1490,   626,   627,   628,   629,
     630,   631,   632,     0,  1491,   633,   634,   635,   636,   637,
    1492,     0,   638,   639,   640,   641,   642,   692,  1493,     0,
     643,   235,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,  1494,  1495,  1496,  1497,
    1498,  1499,  1500,  1501,   693,   653,   654,     0,     0,     0,
       0,     0,     0,     0,  1502,  1503,     0,     0,     0,     0,
       0,     0,     0,  1505,   717,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   718,   104,   105,   672,   719,     0,
     107,   108,   109,   110,   720,   721,   112,   113,   114,   115,
       0,   116,   722,   723,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,   412,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1437,  1438,  1439,    45,  1440,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,  1441,     0,     0,   424,
     425,     0,   426,   427,   133,   428,   429,   430,   135,  1442,
     137,  1443,  1444,     0,   431,   432,   433,   434,   435,  1445,
    1446,   436,   437,  1447,  1448,   438,     0,   439,   440,   441,
     442,  1449,     0,  1450,     0,   443,   444,   445,   446,   148,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
     151,   454,     0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,
     455,   456,   457,   458,   686,   459,  1458,  1459,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,  1460,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
    1461,   484,   485,   486,  1462,  1463,   487,     0,   488,  1464,
     489,     0,   490,     0,   491,   169,     0,   170,   492,   493,
     494,     0,   495,  1465,     0,   496,     0,   497,   498,   688,
     499,   500,   173,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,   174,   175,     0,   511,   512,
     513,  1466,  1467,     0,  1468,     0,   514,   178,   179,   515,
     180,   516,   517,   518,   519,   520,   521,   522,     0,   523,
    1469,   182,   524,   183,     0,   525,   526,   527,  1470,  1471,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,  1472,   189,  1473,   538,   539,   191,  1474,   540,
     541,   193,   542,  1475,  1476,   543,  1477,   544,   545,   546,
       0,   547,     0,     0,  1478,   549,   550,     0,     0,   196,
     197,   198,   199,  1479,   551,   552,   553,   554,   555,   556,
     557,     0,   558,  1480,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,  1481,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,   210,   586,   587,  1482,
     588,   589,   590,   591,   592,   593,   691,   594,   215,   595,
     596,   597,   598,   599,  1483,   600,   217,   601,   602,   219,
     603,  1484,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,  1485,     0,   615,   616,   223,   617,
     618,   619,   620,   621,   622,     0,  1486,  1487,     0,     0,
     624,  1488,   625,  1489,  1490,   626,   627,   628,   629,   630,
     631,   632,     0,  1491,   633,   634,   635,   636,   637,  1492,
       0,   638,   639,   640,   641,   642,  2143,  1493,     0,   643,
     235,   644,   645,   646,     0,     0,   647,     0,   236,   648,
     649,   650,   651,   652,   237,  1494,  1495,  1496,  1497,  1498,
    1499,  1500,  1501,   693,   653,   654,     0,     0,     0,     0,
       0,     0,     0,  1502,  1503,     0,     0,     0,     0,     0,
       0,     0,  1505,   717,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   718,   104,   105,   672,   719,     0,   107,
     108,   109,   110,   720,   721,   112,   113,   114,   115,     0,
     116,   722,   723,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
     412,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1437,  1438,  1439,    45,  1440,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,  1441,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,   135,  1442,   137,
    1443,  1444,     0,   431,   432,   433,   434,   435,  1445,  1446,
     436,   437,  1447,  1448,   438,     0,   439,   440,   441,   442,
    1449,     0,  1450,     0,   443,   444,   445,   446,   148,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,
     456,   457,   458,   686,   459,  1458,  1459,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,  1460,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,  1461,
     484,   485,   486,  1462,  1463,   487,     0,   488,  1464,   489,
       0,   490,     0,   491,   169,     0,   170,   492,   493,   494,
       0,   495,  1465,     0,   496,     0,   497,   498,   688,   499,
     500,   173,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,   174,   175,     0,   511,   512,   513,
    1466,  1467,     0,  1468,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,  1469,
     182,   524,   183,     0,   525,   526,   527,  1470,  1471,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,  1472,   189,  1473,   538,   539,   191,  1474,   540,   541,
     193,   542,  1475,  1476,   543,  1477,   544,   545,   546,     0,
     547,     0,     0,  1478,   549,   550,     0,     0,   196,   197,
     198,   199,  1479,   551,   552,   553,   554,   555,   556,   557,
       0,   558,  1480,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,  1481,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,  1482,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,  1483,   600,   217,   601,   602,   219,   603,
    1484,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,  1485,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,  1486,  1487,     0,     0,   624,
    1488,   625,  1489,  1490,   626,   627,   628,   629,   630,   631,
     632,     0,  1491,   633,   634,   635,   636,   637,  1492,     0,
     638,   639,   640,   641,   642,   692,  1493,     0,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,  1494,  1495,  1496,  1497,  1498,  1499,
    1500,  1501,   693,   653,   654,     0,     0,     0,     0,     0,
       0,     0,  1502,  1503,     0,     0,     0,     0,     0,  2087,
    2774,  1505,   717,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   718,   104,   105,   672,   719,     0,   107,   108,
     109,   110,   720,   721,   112,   113,   114,   115,     0,   116,
     722,   723,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,   412,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1437,  1438,  1439,    45,  1440,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,  1441,     0,     0,   424,   425,     0,
     426,   427,   133,   428,   429,   430,   135,  1442,   137,  1443,
    1444,     0,   431,   432,   433,   434,   435,  1445,  1446,   436,
     437,  1447,  1448,   438,     0,   439,   440,   441,   442,  1449,
       0,  1450,     0,   443,   444,   445,   446,   148,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,   151,   454,
       0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,   456,
     457,   458,   686,   459,  1458,  1459,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,  1460,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,  1461,   484,
     485,   486,  1462,  1463,   487,     0,   488,  1464,   489,     0,
     490,     0,   491,   169,     0,   170,   492,   493,   494,     0,
     495,  1465,     0,   496,     0,   497,   498,   688,   499,   500,
     173,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,   174,   175,     0,   511,   512,   513,  1466,
    1467,     0,  1468,     0,   514,   178,   179,   515,   180,   516,
     517,   518,   519,   520,   521,   522,     0,   523,  1469,   182,
     524,   183,     0,   525,   526,   527,  1470,  1471,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
    1472,   189,  1473,   538,   539,   191,  1474,   540,   541,   193,
     542,  1475,  1476,   543,  1477,   544,   545,   546,     0,   547,
       0,     0,  1478,   549,   550,     0,     0,   196,   197,   198,
     199,  1479,   551,   552,   553,   554,   555,   556,   557,     0,
     558,  1480,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,  1481,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,   210,   586,   587,  1482,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,  1483,   600,   217,   601,   602,   219,   603,  1484,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,  1485,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,  1486,  1487,     0,     0,   624,  1488,
     625,  1489,  1490,   626,   627,   628,   629,   630,   631,   632,
       0,  1491,   633,   634,   635,   636,   637,  1492,     0,   638,
     639,   640,   641,   642,   692,  1493,     0,   643,   235,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,  1494,  1495,  1496,  1497,  1498,  1499,  1500,
    1501,   693,   653,   654,     0,     0,     0,     0,     0,     0,
       0,  1502,  1503,  1504,     0,     0,     0,     0,     0,     0,
    1505,   717,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   718,   104,   105,   672,   719,     0,   107,   108,   109,
     110,   720,   721,   112,   113,   114,   115,     0,   116,   722,
     723,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,   412,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1437,
    1438,  1439,    45,  1440,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,  1441,     0,     0,   424,   425,     0,   426,
     427,   133,   428,   429,   430,   135,  1442,   137,  1443,  1444,
       0,   431,   432,   433,   434,   435,  1445,  1446,   436,   437,
    1447,  1448,   438,     0,   439,   440,   441,   442,  1449,     0,
    1450,     0,   443,   444,   445,   446,   148,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,   151,   454,     0,
    1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,   456,   457,
     458,   686,   459,  1458,  1459,   460,  1588,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,  1460,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,  1461,   484,   485,
     486,  1462,  1463,   487,     0,   488,  1464,   489,     0,   490,
       0,   491,   169,     0,   170,   492,   493,   494,     0,   495,
    1465,     0,   496,     0,   497,   498,   688,   499,   500,   173,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,   174,   175,     0,   511,   512,   513,  1466,  1467,
       0,  1468,     0,   514,   178,   179,   515,   180,   516,   517,
     518,   519,   520,   521,   522,     0,   523,  1469,   182,   524,
     183,     0,   525,   526,   527,  1470,  1471,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,  1472,
     189,  1473,   538,   539,   191,  1474,   540,   541,   193,   542,
    1475,  1476,   543,  1477,   544,   545,   546,     0,   547,     0,
       0,  1478,   549,   550,     0,     0,   196,   197,   198,   199,
    1479,   551,   552,   553,   554,   555,   556,   557,     0,   558,
    1480,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,  1481,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,   210,   586,   587,  1482,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,  1483,   600,   217,   601,   602,   219,   603,  1484,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,  1485,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,  1486,  1487,     0,     0,   624,  1488,   625,
    1489,  1490,   626,   627,   628,   629,   630,   631,   632,     0,
    1491,   633,   634,   635,   636,   637,  1492,     0,   638,   639,
     640,   641,   642,   692,  1493,     0,   643,   235,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,  1494,  1495,  1496,  1497,  1498,  1499,  1500,  1501,
     693,   653,   654,     0,     0,     0,     0,     0,     0,     0,
    1502,  1503,     0,     0,     0,     0,     0,     0,     0,  1505,
     717,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     718,   104,   105,   672,   719,     0,   107,   108,   109,   110,
     720,   721,   112,   113,   114,   115,     0,   116,   722,   723,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,   412,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1437,  1438,
    1439,    45,  1440,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,  2270,   421,   422,   423,     0,     0,
       0,     0,  1441,     0,     0,   424,   425,     0,   426,   427,
     133,   428,   429,   430,   135,  1442,   137,  1443,  1444,     0,
     431,   432,   433,   434,   435,  1445,  1446,   436,   437,  1447,
    1448,   438,     0,   439,   440,   441,   442,  1449,     0,  1450,
       0,   443,   444,   445,   446,   148,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,   151,   454,     0,  1451,
    1452,  1453,  1454,  1455,  1456,  1457,   455,   456,   457,   458,
     686,   459,  1458,  1459,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,  1460,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,  1461,   484,   485,   486,
    1462,  1463,   487,     0,   488,  1464,   489,     0,   490,     0,
     491,   169,     0,   170,   492,   493,   494,     0,   495,  1465,
       0,   496,     0,   497,   498,   688,   499,   500,   173,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,   174,   175,     0,   511,   512,   513,  1466,  1467,     0,
    1468,     0,   514,   178,   179,   515,   180,   516,   517,   518,
     519,   520,   521,   522,     0,   523,  1469,   182,   524,   183,
       0,   525,   526,   527,  1470,  1471,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,  1472,   189,
    1473,   538,   539,   191,  1474,   540,   541,   193,   542,  1475,
    1476,   543,  1477,   544,   545,   546,     0,   547,     0,     0,
    1478,   549,   550,     0,     0,   196,   197,   198,   199,  1479,
     551,   552,   553,   554,   555,   556,   557,     0,   558,  1480,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,  1481,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,   210,   586,   587,  1482,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
    1483,   600,   217,   601,   602,   219,   603,  1484,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
    1485,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,  1486,  1487,     0,     0,   624,  1488,   625,  1489,
    1490,   626,   627,   628,   629,   630,   631,   632,     0,  1491,
     633,   634,   635,   636,   637,  1492,     0,   638,   639,   640,
     641,   642,   692,  1493,     0,   643,   235,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,  1494,  1495,  1496,  1497,  1498,  1499,  1500,  1501,   693,
     653,   654,     0,     0,     0,     0,     0,     0,     0,  1502,
    1503,     0,     0,     0,     0,     0,     0,     0,  1505,   717,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   718,
     104,   105,   672,   719,     0,   107,   108,   109,   110,   720,
     721,   112,   113,   114,   115,     0,   116,   722,   723,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,   412,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1437,  1438,  1439,
      45,  1440,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,  1441,     0,     0,   424,   425,     0,   426,   427,   133,
     428,   429,   430,   135,  1442,   137,  1443,  1444,     0,   431,
     432,   433,   434,   435,  1445,  1446,   436,   437,  1447,  1448,
     438,     0,   439,   440,   441,   442,  1449,     0,  1450,     0,
     443,   444,   445,   446,   148,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,   151,   454,     0,  1451,  1452,
    1453,  1454,  1455,  1456,  1457,   455,   456,   457,   458,   686,
     459,  1458,  1459,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
    1460,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,  1461,   484,   485,   486,  1462,
    1463,   487,     0,   488,  1464,   489,     0,   490,     0,   491,
     169,  2827,   170,   492,   493,   494,     0,   495,  1465,     0,
     496,     0,   497,   498,   688,   499,   500,   173,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
     174,   175,     0,   511,   512,   513,  1466,  1467,     0,  1468,
       0,   514,   178,   179,   515,   180,   516,   517,   518,   519,
     520,   521,   522,     0,   523,  1469,   182,   524,   183,     0,
     525,   526,   527,  1470,  1471,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,  1472,   189,  1473,
     538,   539,   191,  1474,   540,   541,   193,   542,  1475,  1476,
     543,  1477,   544,   545,   546,     0,   547,     0,     0,  1478,
     549,   550,     0,     0,   196,   197,   198,   199,  1479,   551,
     552,   553,   554,   555,   556,   557,     0,   558,  1480,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,  1481,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,   210,   586,   587,  1482,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,  1483,
     600,   217,   601,   602,   219,   603,  1484,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,  1485,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,  1486,  1487,     0,     0,   624,  1488,   625,  1489,  1490,
     626,   627,   628,   629,   630,   631,   632,     0,  1491,   633,
     634,   635,   636,   637,  1492,     0,   638,   639,   640,   641,
     642,   692,  1493,     0,   643,   235,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
    1494,  1495,  1496,  1497,  1498,  1499,  1500,  1501,   693,   653,
     654,     0,     0,     0,     0,     0,     0,     0,  1502,  1503,
       0,     0,     0,     0,     0,     0,     0,  1505,   717,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   718,   104,
     105,   672,   719,     0,   107,   108,   109,   110,   720,   721,
     112,   113,   114,   115,     0,   116,   722,   723,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,   412,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1437,  1438,  1439,    45,
    1440,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
    1441,     0,     0,   424,   425,     0,   426,   427,   133,   428,
     429,   430,   135,  1442,   137,  1443,  1444,     0,   431,   432,
     433,   434,   435,  1445,  1446,   436,   437,  1447,  1448,   438,
       0,   439,   440,   441,   442,  1449,     0,  1450,     0,   443,
     444,   445,   446,   148,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,   151,   454,     0,  1451,  1452,  1453,
    1454,  1455,  1456,  1457,   455,   456,   457,   458,   686,   459,
    1458,  1459,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,  1460,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,  1461,   484,   485,   486,  1462,  1463,
     487,     0,   488,  1464,   489,     0,   490,     0,   491,   169,
       0,   170,   492,   493,   494,     0,   495,  1465,     0,   496,
       0,   497,   498,   688,   499,   500,   173,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,   174,
     175,     0,   511,   512,   513,  1466,  1467,     0,  1468,     0,
     514,   178,   179,   515,   180,   516,   517,   518,   519,   520,
     521,   522,     0,   523,  1469,   182,   524,   183,     0,   525,
     526,   527,  1470,  1471,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,  1472,   189,  1473,   538,
     539,   191,  1474,   540,   541,   193,   542,  1475,  1476,   543,
    1477,   544,   545,   546,     0,   547,     0,     0,  1478,   549,
     550,     0,     0,   196,   197,   198,   199,  1479,   551,   552,
     553,   554,   555,   556,   557,     0,   558,  1480,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,  1481,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
     210,   586,   587,  1482,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,  1483,   600,
     217,   601,   602,   219,   603,  1484,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,  1485,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
    1486,  1487,     0,     0,   624,  1488,   625,  1489,  1490,   626,
     627,   628,   629,   630,   631,   632,     0,  1491,   633,   634,
     635,   636,   637,  1492,     0,   638,   639,   640,   641,   642,
     692,  1493,  4048,   643,   235,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,  1494,
    1495,  1496,  1497,  1498,  1499,  1500,  1501,   693,   653,   654,
       0,     0,     0,     0,     0,     0,     0,  1502,  1503,     0,
       0,     0,     0,     0,     0,     0,  1505,   717,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   718,   104,   105,
     672,   719,     0,   107,   108,   109,   110,   720,   721,   112,
     113,   114,   115,     0,   116,   722,   723,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,   412,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1437,  1438,  1439,    45,  1440,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,  1441,
       0,     0,   424,   425,     0,   426,   427,   133,   428,   429,
     430,   135,  1442,   137,  1443,  1444,     0,   431,   432,   433,
     434,   435,  1445,  1446,   436,   437,  1447,  1448,   438,     0,
     439,   440,   441,   442,  1449,     0,  1450,     0,   443,   444,
     445,   446,   148,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,   151,   454,  4061,  1451,  1452,  1453,  1454,
    1455,  1456,  1457,   455,   456,   457,   458,   686,   459,  1458,
    1459,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,  1460,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,  1461,   484,   485,   486,  1462,  1463,   487,
       0,   488,  1464,   489,     0,   490,     0,   491,   169,     0,
     170,   492,   493,   494,     0,   495,  1465,     0,   496,     0,
     497,   498,   688,   499,   500,   173,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,   174,   175,
       0,   511,   512,   513,  1466,  1467,     0,  1468,     0,   514,
     178,   179,   515,   180,   516,   517,   518,   519,   520,   521,
     522,     0,   523,  1469,   182,   524,   183,     0,   525,   526,
     527,  1470,  1471,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,  1472,   189,  1473,   538,   539,
     191,  1474,   540,   541,   193,   542,  1475,  1476,   543,  1477,
     544,   545,   546,     0,   547,     0,     0,  1478,   549,   550,
       0,     0,   196,   197,   198,   199,  1479,   551,   552,   553,
     554,   555,   556,   557,     0,   558,  1480,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
    1481,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,   210,
     586,   587,  1482,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,  1483,   600,   217,
     601,   602,   219,   603,  1484,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,  1485,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,  1486,
    1487,     0,     0,   624,  1488,   625,  1489,  1490,   626,   627,
     628,   629,   630,   631,   632,     0,  1491,   633,   634,   635,
     636,   637,  1492,     0,   638,   639,   640,   641,   642,   692,
    1493,     0,   643,   235,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,  1494,  1495,
    1496,  1497,  1498,  1499,  1500,  1501,   693,   653,   654,     0,
       0,     0,     0,     0,     0,     0,  1502,  1503,     0,     0,
       0,     0,     0,     0,     0,  1505,   717,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   718,   104,   105,   672,
     719,     0,   107,   108,   109,   110,   720,   721,   112,   113,
     114,   115,     0,   116,   722,   723,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,   412,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1437,  1438,  1439,    45,  1440,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,  1441,     0,
       0,   424,   425,     0,   426,   427,   133,   428,   429,   430,
    4867,  1442,   137,  1443,  1444,     0,   431,   432,   433,   434,
     435,  1445,  1446,   436,   437,  1447,  1448,   438,     0,   439,
     440,   441,   442,  1449,     0,  1450,     0,   443,   444,   445,
     446,   148,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,   151,   454,  4868,  1451,  1452,  1453,  1454,  1455,
    1456,  1457,   455,   456,   457,   458,   686,   459,  1458,  1459,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,  1460,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,  1461,   484,   485,   486,  1462,  1463,   487,     0,
     488,  1464,   489,     0,   490,     0,   491,   169,     0,   170,
     492,   493,   494,     0,   495,  1465,     0,   496,     0,   497,
     498,   688,   499,   500,   173,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,   174,   175,     0,
     511,   512,   513,  1466,  1467,     0,  1468,     0,   514,   178,
     179,   515,   180,   516,   517,   518,   519,   520,   521,   522,
       0,   523,  1469,   182,   524,   183,     0,   525,   526,   527,
    1470,  1471,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,  1472,   189,  1473,   538,   539,   191,
    1474,   540,   541,   193,   542,  1475,  1476,   543,  1477,   544,
     545,   546,     0,   547,     0,     0,  1478,   549,   550,     0,
       0,   196,   197,   198,   199,  1479,   551,   552,   553,   554,
     555,   556,   557,     0,   558,  1480,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,  1481,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,   210,   586,
     587,  1482,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,  1483,   600,   217,   601,
     602,   219,   603,  1484,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,  1485,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,  1486,  1487,
       0,     0,   624,  1488,   625,  1489,  1490,   626,   627,   628,
     629,  4869,   631,   632,     0,  1491,   633,   634,   635,   636,
     637,  1492,     0,   638,   639,   640,   641,   642,   692,  1493,
       0,   643,   235,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,  1494,  1495,  1496,
    1497,  1498,  1499,  1500,  1501,   693,   653,   654,     0,     0,
       0,     0,     0,     0,     0,  1502,  1503,     0,     0,     0,
       0,     0,     0,     0,  1505,   717,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   718,   104,   105,   672,   719,
       0,   107,   108,   109,   110,   720,   721,   112,   113,   114,
     115,     0,   116,   722,   723,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,   412,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1437,  1438,  1439,    45,  1440,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,  1441,     0,     0,
     424,   425,     0,   426,   427,   133,   428,   429,   430,   135,
    1442,   137,  1443,  1444,     0,   431,   432,   433,   434,   435,
    1445,  1446,   436,   437,  1447,  1448,   438,     0,   439,   440,
     441,   442,  1449,     0,  1450,     0,   443,   444,   445,   446,
     148,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,   151,   454,  4868,  1451,  1452,  1453,  1454,  1455,  1456,
    1457,   455,   456,   457,   458,   686,   459,  1458,  1459,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,  1460,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,  1461,   484,   485,   486,  1462,  1463,   487,     0,   488,
    1464,   489,     0,   490,     0,   491,   169,     0,   170,   492,
     493,   494,     0,   495,  1465,     0,   496,     0,   497,   498,
     688,   499,   500,   173,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,   174,   175,     0,   511,
     512,   513,  1466,  1467,     0,  1468,     0,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,     0,
     523,  1469,   182,   524,   183,     0,   525,   526,   527,  1470,
    1471,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,  1472,   189,  1473,   538,   539,   191,  1474,
     540,   541,   193,   542,  1475,  1476,   543,  1477,   544,   545,
     546,     0,   547,     0,     0,  1478,   549,   550,     0,     0,
     196,   197,   198,   199,  1479,   551,   552,   553,   554,   555,
     556,   557,     0,   558,  1480,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,  1481,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,   210,   586,   587,
    1482,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,  1483,   600,   217,   601,   602,
     219,   603,  1484,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,  1485,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,  1486,  1487,     0,
       0,   624,  1488,   625,  1489,  1490,   626,   627,   628,   629,
    4869,   631,   632,     0,  1491,   633,   634,   635,   636,   637,
    1492,     0,   638,   639,   640,   641,   642,   692,  1493,     0,
     643,   235,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,  1494,  1495,  1496,  1497,
    1498,  1499,  1500,  1501,   693,   653,   654,     0,     0,     0,
       0,     0,     0,     0,  1502,  1503,     0,     0,     0,     0,
       0,     0,     0,  1505,   717,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   718,   104,   105,   672,   719,     0,
     107,   108,   109,   110,   720,   721,   112,   113,   114,   115,
       0,   116,   722,   723,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,   412,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1437,  1438,  1439,    45,  1440,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,  1441,     0,     0,   424,
     425,     0,   426,   427,   133,   428,   429,   430,   135,  1442,
     137,  1443,  1444,     0,   431,   432,   433,   434,   435,  1445,
    1446,   436,   437,  1447,  1448,   438,     0,   439,   440,   441,
     442,  1449,     0,  1450,     0,   443,   444,   445,   446,   148,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
     151,   454,     0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,
     455,   456,   457,   458,   686,   459,  1458,  1459,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,  1460,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
    1461,   484,   485,   486,  1462,  1463,   487,     0,   488,  1464,
     489,     0,   490,     0,   491,   169,     0,   170,   492,   493,
     494,     0,   495,  1465,     0,   496,     0,   497,   498,   688,
     499,   500,   173,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,   174,   175,     0,   511,   512,
     513,  1466,  1467,     0,  1468,     0,   514,   178,   179,   515,
     180,   516,   517,   518,   519,   520,   521,   522,     0,   523,
    1469,   182,   524,   183,     0,   525,   526,   527,  1470,  1471,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,  1472,   189,  1473,   538,   539,   191,  1474,   540,
     541,   193,   542,  1475,  1476,   543,  1477,   544,   545,   546,
       0,   547,     0,     0,  1478,   549,   550,     0,     0,   196,
     197,   198,   199,  1479,   551,   552,   553,   554,   555,   556,
     557,     0,   558,  1480,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,  1481,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,   210,   586,   587,  1482,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,  1483,   600,   217,   601,   602,   219,
     603,  1484,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,  1485,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,  1486,  1487,     0,     0,
     624,  1488,   625,  1489,  1490,   626,   627,   628,   629,   630,
     631,   632,     0,  1491,   633,   634,   635,   636,   637,  1492,
       0,   638,   639,   640,   641,   642,   692,  1493,     0,   643,
     235,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,  1494,  1495,  1496,  1497,  1498,
    1499,  1500,  1501,   693,   653,   654,     0,     0,     0,     0,
       0,     0,     0,  1502,  1503,     0,     0,     0,     0,     0,
       0,     0,  1505,   717,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   718,   104,   105,   672,   719,     0,   107,
     108,   109,   110,   720,   721,   112,   113,   114,   115,     0,
     116,   722,   723,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
     412,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1437,  1438,  1439,    45,  1440,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,  1441,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,   135,  1442,   137,
    1443,  1444,     0,   431,   432,   433,   434,   435,  1445,  1446,
     436,   437,  1447,  1448,   438,     0,   439,   440,   441,   442,
    1449,     0,  1450,     0,   443,   444,   445,   446,   148,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,
     456,   457,   458,   686,   459,  1458,  1459,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,  1460,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,  1461,
     484,   485,   486,  1462,  1463,   487,     0,   488,  1464,   489,
       0,   490,     0,   491,   169,     0,   170,   492,   493,   494,
       0,   495,  1465,     0,   496,     0,   497,   498,   688,   499,
     500,   173,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,   174,   175,     0,   511,   512,   513,
    1466,  1467,     0,  1468,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,  1469,
     182,   524,   183,     0,   525,   526,   527,  1470,  1471,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,  1472,   189,  1473,   538,   539,   191,  1474,   540,   541,
     193,   542,  1475,  1476,   543,  1477,   544,   545,   546,     0,
     547,     0,     0,  1478,   549,   550,     0,     0,   196,   197,
     198,   199,  1479,   551,   552,   553,   554,   555,   556,   557,
       0,   558,  1480,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,  1481,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,  1482,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,  1483,   600,   217,   601,   602,   219,   603,
    1484,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,  1485,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,  1486,  1487,     0,     0,   624,
    1488,   625,  1489,  1490,   626,   627,   628,   629,   630,   631,
     632,     0,  1491,   633,   634,   635,   636,   637,  1492,     0,
     638,   639,   640,   641,   642,   692,  1493,     0,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,  4343,  1494,  1495,  1496,  1497,  1498,  1499,
    1500,  1501,   693,   653,   654,     0,     0,     0,     0,     0,
       0,     0,  1502,  1503,     0,     0,     0,     0,     0,     0,
       0,  1505,   717,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   718,   104,   105,   672,   719,     0,   107,   108,
     109,   110,   720,   721,   112,   113,   114,   115,     0,   116,
     722,   723,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,   412,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1437,  1438,  1439,    45,  1440,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,  1441,     0,     0,   424,   425,     0,
     426,   427,   133,   428,   429,   430,   135,  1442,   137,  1443,
    1444,     0,   431,   432,   433,   434,   435,  1445,  1446,   436,
     437,  1447,  1448,   438,     0,   439,   440,   441,   442,  1449,
       0,  1450,     0,   443,   444,   445,   446,   148,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,   151,   454,
       0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,   456,
     457,   458,   686,   459,  1458,  1459,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,  1460,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,  1461,   484,
     485,   486,  1462,  1463,   487,     0,   488,  1464,   489,     0,
     490,     0,   491,   169,     0,   170,   492,   493,   494,     0,
     495,  1465,     0,   496,     0,   497,   498,   688,   499,   500,
     173,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,   174,   175,     0,   511,   512,   513,  1466,
    1467,     0,  1468,     0,   514,   178,   179,   515,   180,   516,
     517,   518,   519,   520,   521,   522,     0,   523,  1469,   182,
     524,   183,     0,   525,   526,   527,  1470,  1471,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
    1472,   189,  1473,   538,  4352,   191,  1474,   540,   541,   193,
     542,  1475,  1476,   543,  1477,   544,   545,   546,     0,   547,
       0,     0,  1478,   549,   550,     0,     0,   196,   197,   198,
     199,  1479,   551,   552,   553,   554,   555,   556,   557,     0,
     558,  1480,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,  1481,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,   210,   586,   587,  1482,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,  1483,   600,   217,   601,   602,   219,   603,  1484,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,  1485,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,  1486,  1487,     0,     0,   624,  1488,
     625,  1489,  1490,   626,   627,   628,   629,   630,   631,   632,
       0,  1491,   633,   634,   635,   636,   637,  1492,     0,   638,
     639,   640,   641,   642,   692,  1493,     0,   643,   235,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,  1494,  1495,  1496,  1497,  1498,  1499,  1500,
    1501,   693,   653,   654,     0,     0,     0,     0,     0,     0,
       0,  1502,  1503,     0,     0,     0,     0,     0,     0,     0,
    1505,   717,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   718,   104,   105,   672,   719,     0,   107,   108,   109,
     110,   720,   721,   112,   113,   114,   115,     0,   116,   722,
     723,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,   412,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1437,
    1438,  1439,    45,  1440,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,  1441,     0,     0,   424,   425,     0,   426,
     427,   133,   428,   429,   430,   135,  1442,   137,  1443,  1444,
       0,   431,   432,   433,   434,   435,  1445,  1446,   436,   437,
    1447,  1448,   438,     0,   439,   440,   441,   442,  1449,     0,
    1450,     0,   443,   444,   445,   446,   148,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,   151,   454,     0,
    1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,   456,   457,
     458,   686,   459,  1458,  1459,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,  1460,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,  1461,   484,   485,
     486,  1462,  1463,   487,     0,   488,  1464,   489,     0,   490,
       0,   491,   169,     0,   170,   492,   493,   494,     0,   495,
    1465,     0,   496,     0,   497,   498,   688,   499,   500,   173,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,   174,   175,     0,   511,   512,   513,  1466,  1467,
       0,  1468,     0,   514,   178,   179,   515,   180,   516,   517,
     518,   519,   520,   521,   522,     0,   523,  1469,   182,   524,
     183,     0,   525,   526,   527,  1470,  1471,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,  1472,
     189,  1473,   538,   539,   191,     0,   540,   541,   193,   542,
    1475,  1476,   543,  1477,   544,   545,   546,     0,   547,     0,
       0,  1478,   549,   550,     0,     0,   196,   197,   198,   199,
    1479,   551,   552,   553,   554,   555,   556,   557,     0,   558,
    1480,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,  1481,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,   210,   586,   587,  1482,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,  1483,   600,   217,   601,   602,   219,   603,  1484,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,  1485,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,  1486,  1487,     0,     0,   624,  1488,   625,
    1489,  1490,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,  1492,     0,   638,   639,
     640,   641,   642,   692,  1493,     0,   643,   235,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,  1494,  1495,  1496,  1497,  1498,  1499,  1500,  1501,
     693,   653,   654,     0,     0,     0,     0,     0,     0,     0,
    2809,  2810,     0,     0,     0,     0,     0,     0,     0,  1505,
     717,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     718,   104,   105,   672,   719,     0,   107,   108,   109,   110,
     720,   721,   112,   113,   114,   115,     0,   116,   722,   723,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,   412,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1437,  1438,
    1439,    45,  1440,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,  1441,     0,     0,   424,   425,     0,   426,   427,
     133,   428,   429,   430, -2577,  1442,   137,  1443,  1444,     0,
     431,   432,   433,   434,   435,  1445,  1446,   436,   437,  1447,
    1448,   438,     0,   439,   440,   441,   442,  1449,     0,  1450,
       0,   443,   444,   445,   446,   148,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,   151,   454,  4868,  1451,
    1452,  1453,  1454,  1455,  1456,  1457,   455,   456,   457,   458,
     686,   459,  1458,  1459,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,  1460,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,  1461,   484,   485,   486,
    1462,  1463,   487,     0,   488,  1464,   489,     0,   490,     0,
     491,   169,     0,   170,   492,   493,   494,     0,   495,  1465,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,   174,   175,     0,   511,   512,   513,  1466,  1467,     0,
    1468,     0,   514,   178,   179,   515,   180,   516,   517,   518,
     519,   520,   521,   522,     0,   523,  1469,   182,   524,     0,
       0,   525,   526,   527,  1470,  1471,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,  1472,   189,
    1473,   538,   539,   191,     0,   540,   541,   193,   542,  1475,
    1476,   543,  1477,   544,   545,   546,     0,   547,     0,     0,
    1478,   549,   550,     0,     0,   196,   197,   198,   199,  1479,
     551,   552,   553,   554,   555,   556,   557,     0,   558,  1480,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,  1481,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,   210,   586,   587,  1482,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
    1483,   600,   217,   601,   602,     0,   603,  1484,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
    1485,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,  1486,  1487,     0,     0,   624,  1488,   625,  1489,
    1490,   626,   627,   628,   629,  4869,   631,   632,     0,  1491,
     633,   634,   635,   636,   637,  1492,     0,   638,   639,   640,
     641,   642,   692,  1493,     0,   643,   235,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,  1494,  1495,  1496,  1497,  1498,  1499,  1500,  1501,   693,
     653,   654,     0,     0,     0,     0,     0,     0,     0,  1502,
    1503,     0,     0,     0,     0,     0,     0,     0,  1505,   717,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   718,
     104,   105,   672,   719,     0,   107,   108,   109,   110,   720,
     721,   112,   113,   114,   115,     0,   116,   722,   723,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,   412,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1437,  1438,     0,
      45,  1440,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,  1441,     0,     0,   424,   425,     0,   426,   427,   133,
     428,   429,   430,   135,  1442,   137,  1443,  1444,     0,   431,
     432,   433,   434,   435,  1445,  1446,   436,   437,  1447,  1448,
     438,     0,   439,   440,   441,   442,  1449,     0,  1450,     0,
     443,   444,   445,   446,   148,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,   151,   454,     0,  1451,  1452,
    1453,  1454,  1455,  1456,  1457,   455,   456,   457,   458,   686,
     459,  1458,  1459,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
    1460,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,  1461,   484,   485,   486,  1462,
    1463,   487,     0,   488,  1464,   489,     0,   490,     0,   491,
     169,     0,   170,   492,   493,   494,     0,   495,  1465,     0,
     496,     0,   497,   498,   688,   499,   500,   173,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
     174,   175,     0,   511,   512,   513,  1466,  1467,     0,  1468,
       0,   514,   178,   179,   515,   180,   516,   517,   518,   519,
     520,   521,   522,     0,   523,  1469,   182,   524,   183,     0,
     525,   526,   527,  1470,  1471,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,  1472,   189,  1473,
     538,   539,   191,     0,   540,   541,   193,   542,  1475,  1476,
     543,  1477,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,   197,   198,   199,  1479,   551,
     552,   553,   554,   555,   556,   557,     0,   558,  1480,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,  1481,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,   210,   586,   587,  1482,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,  1483,
     600,   217,   601,   602,   219,   603,  1484,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,  1485,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,  1486,  1487,     0,     0,   624,  1488,   625,  1489,  1490,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,  1492,     0,   638,   639,   640,   641,
     642,   692,  1493,     0,   643,   235,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
    1494,  1495,  1496,  1497,  1498,  1499,  1500,  1501,   693,   653,
     654,     0,     0,     0,   717,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,  1505,    98,    99,
     100,   101,   102,   103,   718,   104,   105,   672,   719,     0,
     107,   108,   109,   110,   720,   721,   112,   113,   114,   115,
       0,   116,   722,   723,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,   412,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1437,  1438,     0,    45,  1440,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,  1441,     0,     0,   424,
     425,     0,   426,   427,   133,   428,   429,   430,   135,  1442,
     137,  1443,  1444,     0,  3971,   432,   433,   434,   435,  1445,
    1446,   436,   437,  1447,  1448,   438,     0,   439,   440,   441,
     442,  1449,     0,  1450,     0,   443,   444,   445,   446,   148,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
     151,   454,     0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,
     455,   456,   457,   458,   686,   459,  1458,  1459,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,  1460,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
    1461,   484,   485,   486,  1462,  1463,   487,     0,   488,  1464,
     489,     0,   490,     0,   491,   169,     0,   170,   492,   493,
     494,     0,   495,  1465,     0,   496,     0,   497,   498,   688,
     499,   500,   173,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,   174,   175,     0,   511,   512,
     513,  1466,  1467,     0,  1468,     0,   514,   178,   179,   515,
     180,   516,   517,   518,   519,   520,   521,   522,     0,   523,
    1469,   182,   524,   183,     0,   525,   526,   527,  1470,  1471,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,  1472,   189,  1473,   538,   539,   191,     0,   540,
     541,   193,   542,  1475,  1476,   543,  1477,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
     197,   198,   199,  1479,   551,   552,   553,   554,   555,   556,
     557,     0,   558,  1480,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,  1481,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,   210,   586,   587,  1482,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,  1483,   600,   217,   601,   602,   219,
     603,  1484,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,  1485,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,  1486,  1487,     0,     0,
     624,  1488,   625,  1489,  1490,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,  1492,
       0,   638,   639,   640,   641,   642,   692,  1493,     0,   643,
     235,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,  1494,  1495,  1496,  1497,  1498,
    1499,  1500,  1501,   693,   653,   654,     0,     0,     0,   717,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,  1505,    98,    99,   100,   101,   102,   103,   718,
     104,   105,   672,   719,     0,   107,   108,   109,   110,   720,
     721,   112,   113,   114,   115,     0,   116,   722,   723,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,   412,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1437,  1438,  1439,
      45,  1440,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,  1441,     0,     0,   424,   425,     0,   426,   427,   133,
     428,   429,   430,     0,  1442,   137,  1443,  1444,     0,   431,
     432,   433,   434,   435,  1445,  1446,   436,   437,  1447,  1448,
     438,     0,   439,   440,   441,   442,  1449,     0,  1450,     0,
     443,   444,   445,   446,   148,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,   151,   454,     0,  1451,  1452,
    1453,  1454,  1455,  1456,  1457,   455,   456,   457,   458,   686,
     459,  1458,  1459,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
    1460,   473,   474,     0,   475,   476,   477,     0,   478,     0,
       0,   480,   481,   482,   483,  1461,   484,   485,   486,  1462,
    1463,   487,     0,   488,  1464,   489,     0,   490,     0,   491,
     169,     0,   170,   492,   493,   494,     0,   495,  1465,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
     174,   175,     0,   511,   512,   513,  1466,  1467,     0,  1468,
       0,   514,   178,   179,   515,   180,   516,   517,   518,   519,
     520,   521,   522,     0,   523,  1469,   182,   524,     0,     0,
     525,   526,   527,  1470,  1471,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,  1472,   189,  1473,
     538,   539,   191,     0,   540,   541,   193,   542,  1475,  1476,
     543,  1477,   544,   545,   546,     0,   547,     0,     0,  1478,
     549,   550,     0,     0,   196,   197,   198,   199,  1479,   551,
     552,   553,   554,   555,   556,   557,     0,   558,  1480,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,  1481,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,   210,   586,   587,  1482,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,  1483,
     600,   217,   601,   602,     0,   603,  1484,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,  1485,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,  1486,  1487,     0,     0,   624,  1488,   625,  1489,  1490,
     626,   627,   628,   629,   630,   631,   632,     0,  1491,   633,
     634,   635,   636,   637,  1492,     0,   638,   639,   640,   641,
     642,   692,  1493,     0,   643,   235,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
    1494,  1495,  1496,  1497,  1498,  1499,  1500,  1501,   693,   653,
     654,     0,     0,     0,     0,     0,     0,     0,  1502,  1503,
       0,     0,     0,     0,     0,     0,     0,  1505,   717,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   718,   104,
     105,   672,   719,     0,   107,   108,   109,   110,   720,   721,
     112,   113,   114,   115,     0,   116,   722,   723,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,   412,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1437,  1438,  1439,    45,
    1440,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
    1441,     0,     0,   424,   425,     0,   426,   427,   133,   428,
     429,   430,     0,  1442,   137,  1443,  1444,     0,   431,   432,
     433,   434,   435,  1445,  1446,   436,   437,  1447,  1448,   438,
       0,   439,   440,   441,   442,  1449,     0,  1450,     0,   443,
     444,   445,   446,   148,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,   151,   454,     0,  1451,  1452,  1453,
    1454,  1455,  1456,  1457,   455,   456,   457,   458,   686,   459,
    1458,  1459,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,  1460,
     473,   474,     0,   475,   476,   477,     0,   478,     0,     0,
     480,   481,   482,   483,  1461,   484,   485,   486,  1462,  1463,
     487,     0,   488,  1464,   489,     0,   490,     0,   491,   169,
       0,   170,   492,   493,   494,     0,   495,  1465,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,   174,
     175,     0,   511,   512,   513,  1466,  1467,     0,  1468,     0,
     514,   178,   179,   515,   180,   516,   517,   518,   519,   520,
     521,   522,     0,   523,  1469,   182,   524,     0,     0,   525,
     526,   527,  1470,  1471,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,  1472,   189,  1473,   538,
     539,   191,     0,   540,   541,   193,   542,  1475,  1476,   543,
    1477,   544,   545,   546,     0,   547,     0,     0,  1478,   549,
     550,     0,     0,   196,   197,   198,   199,  1479,   551,   552,
     553,   554,   555,   556,   557,     0,   558,  1480,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,  1481,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
     210,   586,   587,  1482,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,  1483,   600,
     217,   601,   602,     0,   603,  1484,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,  1485,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
    1486,  1487,     0,     0,   624,  1488,   625,  1489,  1490,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,  1492,     0,   638,   639,   640,   641,   642,
     692,  1493,     0,   643,   235,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,  1494,
    1495,  1496,  1497,  1498,  1499,  1500,  1501,   693,   653,   654,
       0,     0,     0,     0,     0,     0,     0,  2809,  2810,     0,
       0,     0,     0,     0,     0,     0,  1505,   717,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   718,   104,   105,
     672,   719,     0,   107,   108,   109,   110,   720,   721,   112,
     113,   114,   115,     0,   116,   722,   723,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,   133,   428,   429,
     430,   135,   136,   137,   138,   139,     0,   431,   432,   433,
     434,   435,     0,  1446,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,  1449,     0,  1450,     0,   443,   444,
     445,   446,   148,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,   151,   454,     0,  1451,  1452,  1453,  1454,
    1455,  1456,  1457,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,  1462,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,   169,     0,
     170,   492,   493,   494,     0,   495,  1465,     0,   496,     0,
     497,   498,   688,   499,   500,   173,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,   174,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
     178,   179,   515,   180,   516,   517,   518,   519,   520,   521,
     522,     0,   523,  1469,   182,   524,   183,     0,   525,   526,
     527,  1470,  1471,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,   189,   190,   538,   539,
     191,     0,   540,   541,   193,   542,     0,  1476,   543,   195,
     544,   545,   546,     0,   547,     0,  1063,   548,   549,   550,
       0,     0,   196,   197,   198,   199,  1479,   551,   552,   553,
     554,   555,   556,   557,     0,   558,  1480,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,   210,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,   215,   595,   596,   597,   598,   599,  1483,   600,   217,
     601,   602,   219,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,  1485,     0,   615,
     616,   223,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,  1488,   625,  1489,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,  1492,     0,   638,   639,   640,   641,   642,  2143,
     234,     0,   643,   235,   644,   645,   646,     0,     0,   647,
       0,   236,   648,   649,   650,   651,   652,   237,  1494,  1495,
    1496,  1497,  1498,  1499,  1500,  1501,   693,   653,   654,     0,
       0,     0,   717,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,  3517,    98,    99,   100,   101,
     102,   103,   718,   104,   105,   672,   719,     0,   107,   108,
     109,   110,   720,   721,   112,   113,   114,   115,     0,   116,
     722,   723,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,   133,   428,   429,   430,   135,   136,   137,   138,
     139,     0,   431,   432,   433,   434,   435,     0,  1446,   436,
     437,   683,   140,   438,     0,   439,   440,   441,   442,  1449,
       0,  1450,     0,   443,   444,   445,   446,   148,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,   151,   454,
       0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,  1462,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,   169,     0,   170,   492,   493,   494,     0,
     495,  1465,     0,   496,     0,   497,   498,   688,   499,   500,
     173,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,   174,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,   178,   179,   515,   180,   516,
     517,   518,   519,   520,   521,   522,     0,   523,  1469,   182,
     524,   183,     0,   525,   526,   527,  1470,  1471,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,   189,   190,   538,   539,   191,     0,   540,   541,   193,
     542,     0,  1476,   543,   195,   544,   545,   546,     0,   547,
       0,  1063,   548,   549,   550,     0,     0,   196,   197,   198,
     199,  1479,   551,   552,   553,   554,   555,   556,   557,     0,
     558,  1480,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,   210,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,  1483,   600,   217,   601,   602,   219,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,  1485,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,  1488,
     625,  1489,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,  1492,     0,   638,
     639,   640,   641,   642,   692,   234,     0,   643,   235,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,  1494,  1495,  1496,  1497,  1498,  1499,  1500,
    1501,   693,   653,   654,     0,     0,     0,   717,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
    3517,    98,    99,   100,   101,   102,   103,   718,   104,   105,
     672,   719,     0,   107,   108,   109,   110,   720,   721,   112,
     113,   114,   115,     0,   116,   722,   723,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,   133,   428,   429,
     430,   135,   136,   137,   138,   139,     0,   431,   432,   433,
     434,   435,     0,  1446,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,  1449,     0,  1450,     0,   443,   444,
     445,   446,   148,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,   151,   454,     0,  1451,  1452,  1453,  1454,
    1455,  1456,  1457,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,  1462,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,   169,     0,
     170,   492,   493,   494,     0,   495,  1465,     0,   496,     0,
     497,   498,   688,   499,   500,   173,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,   174,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
     178,   179,   515,   180,   516,   517,   518,   519,   520,   521,
     522,     0,   523,  1469,   182,   524,   183,     0,   525,   526,
     527,  1470,  1471,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,   189,   190,   538,   539,
     191,     0,   540,   541,   193,   542,     0,  1476,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,   197,   198,   199,  1479,   551,   552,   553,
     554,   555,   556,   557,     0,   558,  1480,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,   210,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,  1483,   600,   217,
     601,   602,   219,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,  1485,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,  1488,   625,  1489,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,  1492,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,   235,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,  1494,  1495,
    1496,  1497,  1498,  1499,  1500,  1501,   693,   653,   654,     0,
       0,     0,   717,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,  4087,    98,    99,   100,   101,
     102,   103,   718,   104,   105,   672,   719,     0,   107,   108,
     109,   110,   720,   721,   112,   113,   114,   115,     0,   116,
     722,   723,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,   133,   428,   429,   430,   135,   136,   137,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   683,   140,   438,     0,   439,   440,   441,   442,   144,
       0,   145,     0,   443,   444,   445,   446,   148,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,   151,   454,
       0,     0,     0,     0,   152,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,   169,     0,   170,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,   500,
     173,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,   174,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,   178,   179,   515,   180,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,   182,
     524,   183,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,   189,   190,   538,   539,   191,     0,   540,   541,   193,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,   197,   198,
     199,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,   210,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,   219,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,   692,   234,     0,   643,   235,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,     0,     0,     0,     0,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
    4639,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
    4015,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0, -1427,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
   -1427,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,   500,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510, -1427,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515, -1427,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181, -1427,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188, -1427,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585, -1427,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,     0,
       0,     0,     0,     0,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,  1596,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
     500,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,     0,     0,     0,     0,     0,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,  3278,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,    37,
      38,    39,    40,    41,    42,     0,    44,     0,     0,     0,
      45,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,     0,     0,     0,     0,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,  3793,  3794,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,    37,    38,    39,    40,    41,    42,
       0,    44,     0,     0,     0,    45,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,     0,     0,     0,     0,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,  3794,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,   412,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,   215,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,   223,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,  2143,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,   236,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,     0,     0,     0,     0,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,   246,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,   215,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,   223,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,  2143,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,   236,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,     0,     0,     0,     0,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,   246,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,     0,     0,     0,     0,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,  1571,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,     0,     0,     0,     0,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,  2968,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,     0,     0,     0,     0,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,  4042,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,     0,     0,     0,   717,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,  4387,    98,    99,   100,   101,   102,   103,   718,
     104,   105,   672,   719,     0,   107,   108,   109,   110,   720,
     721,   112,   113,   114,   115,     0,   116,   722,   723,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,   412,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,     0,     0,  1185,
      45,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,   724,   421,   422,   423,   725,   726,   727,
     728,   729,   730,   731,   424,   425,   732,   426,   427,   133,
     428,   429,   430,     0,  1859,   137,  1860,  1861,   733,   431,
     432,   433,   434,   435,   734,   735,   436,   437,  1862,  1863,
     438,   737,   439,   440,   441,   442,     0,   738,   145,   739,
     443,   444,   445,   446,   148,   447,   684,   741,   448,   449,
     450,   451,   452,   453,   742,   151,   454,     0,   744,   745,
     746,   152,   747,   748,   749,   455,   456,   457,   458,   686,
     459,  1864,  1865,   460,   750,   461,   751,   462,   463,   464,
     465,   466,   752,   467,   468,   469,   753,   754,   470,   471,
    1460,   473,   474,   755,   475,   476,   477,   756,   478,   479,
     757,   480,   481,   482,   483,     0,   484,   485,   486,     0,
     758,   487,   759,   488,  1866,   489,   760,   490,   761,   491,
     169,   762,   170,   492,   493,   494,   763,   495,     0,   764,
     496,   765,   497,   498,   688,   499,   500,   173,   501,   502,
     503,   766,   504,   505,   506,   507,   508,   509,   767,   510,
     174,     0,     0,   511,   512,   513,  1466,  1867,   770,  1868,
     771,   514,   178,   179,   515,   180,   516,   517,   518,   519,
     520,   521,   522,   772,   523,     0,   182,   524,   183,   773,
     525,   526,   527,   774,   775,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,  1869,   189,  1870,
     538,   539,     0,   776,   540,   541,   193,   542,   777,     0,
     543,  1871,   544,   545,   546,   778,   547,   779,   780,  3780,
     549,   550,   781,   782,     0,   197,   198,   199,     0,   551,
     552,   553,   554,   555,   556,   557,   783,   558,     0,   559,
       0,   560,   561,   562,   784,   563,   564,   565,   566,   567,
     568,   569,  1872,   570,   571,   572,   573,   785,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,   786,   584,
     585,   210,   586,   587,     0,   588,   589,   590,   591,   592,
     593,   691,   594,   787,   595,   596,   597,   598,   599,   788,
     600,  2426,   601,   602,   219,   603,  1874,   604,   789,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,     0,
     790,   615,   616,   791,   617,   618,   619,   620,   621,   622,
     792,  1875,  1876,     0,   794,   624,     0,   625,     0,   795,
     626,   627,   628,   629,   630,   631,   632,     0,   797,   633,
     634,   635,   636,   637,   798,   799,   638,   639,   640,   641,
     642,     0,  1877,   801,   643,   235,   644,   645,   646,   802,
     803,   647,   804,   805,   648,   649,   650,   651,   652,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   693,   653,
     654,     0,     0,     0,  1188,  1189,  1190,     0,  3781,  3782,
    1193,  1194,  1195,  1196,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,  1185,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,  1186,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,  1187,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
     500,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,     0,     0,     0,  1188,  1189,
    1190,     0,  1191,  1192,  1193,  1194,  1195,  1196,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,  1185,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,  1274,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,  1275,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,   500,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,     0,
       0,     0,  1188,  1189,  1190,     0,  1191,  1192,  1193,  1194,
    1195,  1196,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,  1185,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,  1326,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,  1327,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,  1328,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,     0,     0,     0,  1188,  1189,  1190,     0,
    1191,  1192,  1193,  1194,  1195,  1196,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,  1185,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,  1842,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,  1843,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,   500,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,   692,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,     0,     0,     0,
    1188,  1189,  1190,     0,  1191,  1192,  1193,  1194,  1195,  1196,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,     0,     0,     0,  1188,  1189,  1190,     0,  1191,  1192,
    1193,  1194,  1195,  1196,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,  1185,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,  3051,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,  3052,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
     500,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,     0,     0,     0,  1188,  1189,
    1190,     0,  1191,  1192,  1193,  1194,  1195,  1196,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,  1185,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,   500,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,  4623,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,     0,
       0,     0,  1188,  1189,  1190,     0,  1191,  1192,  1193,  1194,
    1195,  1196,   717,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   718,   104,   105,   672,   719,     0,   107,   108,
     109,   110,   720,   721,   112,   113,   114,   115,     0,   116,
     722,   723,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,   724,   421,   422,   423,
     725,   726,   727,   728,   729,   730,   731,   424,   425,   732,
     426,   427,   133,   428,   429,   430,   135,   136,   137,   138,
     139,   733,   431,   432,   433,   434,   435,   734,   735,   436,
     437,   736,   140,   438,   737,   439,   440,   441,   442,   144,
     738,   145,   739,   443,   444,   445,   446,   148,   447,   740,
     741,   448,   449,   450,   451,   452,   453,   742,   151,   454,
     743,   744,   745,   746,   152,   747,   748,   749,   455,   456,
     457,   458,   686,   459,   155,   156,   460,   750,   461,   751,
     462,   463,   464,   465,   466,   752,   467,   468,   469,   753,
     754,   470,   471,   472,   473,   474,   755,   475,   476,   477,
     756,   478,   479,   757,   480,   481,   482,   483,   164,   484,
     485,   486,   166,   758,   487,   759,   488,   168,   489,   760,
     490,   761,   491,   169,   762,   170,   492,   493,   494,   763,
     495,   172,   764,   496,   765,   497,   498,   688,   499,   500,
     173,   501,   502,   503,   766,   504,   505,   506,   507,   508,
     509,   767,   510,   174,   175,   768,   511,   512,   513,   769,
     176,   770,   177,   771,   514,   178,   179,   515,   180,   516,
     517,   518,   519,   520,   521,   522,   772,   523,   181,   182,
     524,   183,   773,   525,   526,   527,   774,   775,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,   189,   190,   538,   539,   191,   776,   540,   541,   193,
     542,   777,   194,   543,   195,   544,   545,   546,   778,   547,
     779,   780,   548,   549,   550,   781,   782,   196,   197,   198,
     199,   200,   551,   552,   553,   554,   555,   556,   557,   783,
     558,   201,   559,   202,   560,   561,   562,   784,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
     785,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,   786,   584,   585,   210,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,   787,   595,   596,   597,
     598,   599,   788,   600,   217,   601,   602,   219,   603,   220,
     604,   789,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,   790,   615,   616,   791,   617,   618,   619,
     620,   621,   622,   792,   224,   225,   793,   794,   624,   226,
     625,   227,   795,   626,   627,   628,   629,   630,   631,   632,
     796,   797,   633,   634,   635,   636,   637,   798,   799,   638,
     639,   640,   641,   642,   800,   234,   801,   643,   235,   644,
     645,   646,   802,   803,   647,   804,   805,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,   717,    86,    87,    88,   669,    90,
      91,    92,   670,  2240,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   718,   104,   105,   672,   719,     0,
     107,   108,   109,   110,   720,   721,   112,   113,   114,   115,
       0,   116,   722,   723,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,   133,   428,   429,   430,     0,  1859,
     137,  1860,  1861,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,  1862,  1863,   438,     0,   439,   440,   441,
     442,     0,     0,   145,     0,   443,   444,   445,   446,   148,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
     151,   454,     0,     0,     0,     0,   152,     0,     0,     0,
     455,   456,   457,   458,   686,   459,  1864,  1865,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,  1460,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
       0,   484,   485,   486,     0,     0,   487,     0,   488,  1866,
     489,     0,   490,     0,   491,   169,     0,   170,   492,   493,
     494,     0,   495,     0,     0,   496,     0,   497,   498,   688,
     499,   500,   173,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,   174,     0,     0,   511,   512,
     513,  1466,  1867,     0,  1868,     0,   514,   178,   179,   515,
     180,   516,   517,   518,   519,   520,   521,   522,     0,   523,
       0,   182,   524,   183,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,  1869,   189,  1870,   538,   539,     0,     0,   540,
     541,   193,   542,     0,     0,   543,  1871,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,     0,
     197,   198,   199,     0,   551,   552,   553,   554,   555,   556,
     557,     0,   558,     0,   559,     0,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,  1872,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,   210,   586,   587,     0,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,  1873,   601,   602,   219,
     603,  1874,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,     0,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,  1875,  1876,     0,     0,
     624,     0,   625,     0,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,     0,  1877,     0,   643,
     235,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   693,   653,   654,     0,    86,    87,    88,
     669,    90,    91,    92,   670,  2340,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,     0,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,   500,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,     0,    86,
      87,    88,   669,    90,    91,    92,   670,  1070,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
       0,    86,    87,    88,   669,    90,    91,    92,   670,  4491,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,   412,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,    45,     0,     0,     0,     0,   413,   969,   415,   416,
     417,   418,   419,   420,   970,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   971,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   972,   168,   489,     0,   490,     0,
     973,     0,   974,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,   975,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   976,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   977,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   978,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     979,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,     0,     0,     0,     0,     0,     0,     0,   980,
     981,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,   412,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,    45,     0,     0,     0,     0,   413,   969,   415,   416,
     417,   418,   419,   420,   970,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,  1002,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   972,   168,   489,     0,   490,     0,
    1003,     0,   974,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,   975,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   976,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   977,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   978,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     979,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,     0,     0,     0,     0,     0,     0,     0,   980,
     981,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,   412,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,    45,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,  1374,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,   974,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,   975,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,     0,     0,     0,     0,     0,     0,     0,   980,
     981,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,   412,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,    45,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,  1379,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,   974,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,   975,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,     0,     0,     0,     0,     0,     0,     0,   980,
     981,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,   412,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,   687,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,  1542,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,     0,     0,  1041,  1543,    86,    87,    88,   669,
      90,    91,    92,   670,  1042,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,  1043,   437,  1017,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,  1044,     0,  1045,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,   500,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,  1046,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,  1047,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,  1048,   587,
     212,   588,   589,   590,  1049,   592,   593,   691,   594,     0,
     595,   596,   597,   598,  1050,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,  1051,   225,     0,
       0,  1052,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,  1021,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,  1053,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,   717,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   718,   104,   105,
     672,   719,     0,   107,   108,   109,   110,   720,   721,   112,
     113,   114,   115,     0,   116,   722,   723,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,     0,     0,     0,    45,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,   724,   421,   422,   423,   725,   726,   727,   728,   729,
     730,   731,   424,   425,   732,   426,   427,   133,   428,   429,
     430,   135,   136,   137,   138,   139,   733,   431,   432,   433,
     434,   435,   734,   735,   436,   437,   736,   140,   438,   737,
     439,   440,   441,   442,   144,   738,   145,   739,   443,   444,
     445,   446,   148,   447,   740,   741,   448,   449,   450,   451,
     452,   453,   742,   151,   454,   743,   744,   745,   746,   152,
     747,   748,   749,   455,   456,   457,   458,   686,   459,   155,
     156,   460,   750,   461,   751,   462,   463,   464,   465,   466,
     752,   467,   468,   469,   753,   754,   470,   471,   472,   473,
     474,   755,   475,   476,   477,   756,   478,   479,   757,   480,
     481,   482,   483,   164,   484,   485,   486,   166,   758,   487,
     759,   488,   168,   489,   760,   490,   761,   491,   169,   762,
     170,   492,   493,   494,   763,   495,   172,   764,   496,   765,
     497,   498,   688,   499,   500,   173,   501,   502,   503,   766,
     504,   505,   506,   507,   508,   509,   767,   510,   174,   175,
     768,   511,   512,   513,   769,   176,   770,   177,   771,   514,
     178,   179,   515,   180,   516,   517,   518,   519,   520,   521,
     522,   772,   523,   181,   182,   524,   183,   773,   525,   526,
     527,   774,   775,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,   189,   190,   538,   539,
     191,   776,   540,   541,   193,   542,   777,   194,   543,   195,
     544,   545,   546,   778,   547,   779,   780,   548,   549,   550,
     781,   782,   196,   197,   198,   199,   200,   551,   552,   553,
     554,   555,   556,   557,   783,   558,   201,   559,   202,   560,
     561,   562,   784,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,   785,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,   786,   584,   585,   210,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,   787,   595,   596,   597,   598,   599,   788,   600,   217,
     601,   602,   219,   603,   220,   604,   789,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,   790,   615,
     616,   791,   617,   618,   619,   620,   621,   622,   792,   224,
     225,   793,   794,   624,   226,   625,   227,   795,   626,   627,
     628,   629,   630,   631,   632,   796,   797,   633,   634,   635,
     636,   637,   798,   799,   638,   639,   640,   641,   642,   800,
     234,   801,   643,   235,   644,   645,   646,   802,   803,   647,
     804,   805,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,   717,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   718,
     104,   105,   672,   719,     0,   107,   108,   109,   110,   720,
     721,   112,   113,   114,   115,     0,   116,   722,   723,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,   724,   421,   422,   423,   725,   726,   727,
     728,   729,   730,   731,   424,   425,   732,   426,   427,   133,
     428,   429,   430,   135,   136,   137,   138,   139,   733,   431,
     432,   433,   434,   435,   734,   735,   436,   437,   736,   140,
     438,   737,   439,   440,   441,   442,   144,   738,   145,   739,
     443,   444,   445,   446,   148,   447,   740,   741,   448,   449,
     450,   451,   452,   453,   742,   151,   454,   743,   744,   745,
     746,   152,   747,   748,   749,   455,   456,   457,   458,   686,
     459,   155,   156,   460,   750,   461,   751,   462,   463,   464,
     465,   466,   752,   467,   468,   469,   753,   754,   470,   471,
     472,   473,   474,   755,   475,   476,   477,   756,   478,   479,
     757,   480,   481,   482,   483,   164,   484,   485,   486,   166,
     758,   487,   759,   488,   168,   489,   760,   490,   761,   491,
     169,   762,   170,   492,   493,   494,   763,   495,   172,   764,
     496,   765,   497,   498,   688,   499,   500,   173,   501,   502,
     503,   766,   504,   505,   506,   507,   508,   509,   767,   510,
     174,   175,   768,   511,   512,   513,   769,   176,   770,   177,
     771,   514,   178,   179,   515,   180,   516,   517,   518,   519,
     520,   521,   522,   772,   523,   181,   182,   524,   183,   773,
     525,   526,   527,   774,   775,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,   189,   190,
     538,   539,   191,   776,   540,   541,   193,   542,   777,   194,
     543,   195,   544,   545,   546,   778,   547,   779,   780,   548,
     549,   550,   781,   782,   196,   197,   198,   199,   200,   551,
     552,   553,   554,   555,   556,   557,   783,   558,   201,   559,
     202,   560,   561,   562,   784,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,   785,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,   786,   584,
     585,   210,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,   787,   595,   596,   597,   598,   599,   788,
     600,   217,   601,   602,   219,   603,   220,   604,   789,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
     790,   615,   616,   791,   617,   618,   619,   620,   621,   622,
     792,   224,   225,   793,   794,   624,   226,   625,   227,   795,
     626,   627,   628,   629,   630,   631,   632,   796,   797,   633,
     634,   635,   636,   637,   798,   799,   638,   639,   640,   641,
     642,   800,   234,   801,   643,   235,   644,   645,   646,   802,
     803,   647,   804,   805,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,   717,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   718,   104,   105,   672,   719,     0,   107,   108,   109,
     110,   720,   721,   112,   113,   114,   115,     0,   116,   722,
     723,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,  3116,   418,   419,   420,   724,   421,   422,   423,   725,
     726,   727,   728,   729,   730,   731,   424,   425,   732,   426,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
     733,   431,   432,   433,   434,   435,   734,   735,   436,   437,
     736,   140,   438,   737,   439,   440,   441,   442,   144,   738,
     145,   739,   443,   444,   445,   446,   148,   447,   740,   741,
     448,   449,   450,   451,   452,   453,   742,   151,   454,   743,
     744,   745,   746,   152,   747,   748,   749,   455,   456,   457,
     458,   686,   459,   155,   156,   460,   750,   461,   751,   462,
     463,   464,   465,   466,   752,   467,   468,   469,   753,   754,
     470,   471,   472,  3117,   474,   755,   475,   476,   477,   756,
     478,   479,   757,   480,   481,   482,   483,   164,   484,   485,
     486,   166,   758,   487,   759,   488,   168,   489,   760,   490,
     761,   491,   169,   762,   170,   492,   493,   494,   763,   495,
     172,   764,   496,   765,   497,   498,   688,   499,   500,   173,
     501,   502,   503,   766,   504,   505,   506,   507,   508,   509,
     767,   510,   174,   175,   768,   511,   512,   513,   769,   176,
     770,   177,   771,   514,   178,   179,   515,   180,   516,   517,
     518,   519,   520,   521,   522,   772,   523,   181,   182,   524,
     183,   773,   525,   526,   527,   774,   775,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
     189,   190,   538,   539,   191,   776,   540,   541,   193,   542,
     777,   194,   543,   195,   544,   545,   546,   778,   547,   779,
     780,   548,   549,   550,   781,   782,   196,   197,   198,   199,
     200,   551,   552,   553,   554,   555,   556,   557,   783,   558,
     201,   559,   202,   560,   561,   562,   784,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,   785,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
     786,   584,   585,   210,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,   787,   595,   596,   597,   598,
     599,   788,  3118,   217,   601,   602,   219,   603,   220,   604,
     789,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,   790,   615,   616,   791,   617,   618,   619,   620,
     621,   622,   792,   224,   225,   793,   794,   624,   226,   625,
     227,   795,   626,   627,   628,   629,   630,   631,   632,   796,
     797,   633,   634,   635,   636,   637,   798,   799,   638,   639,
     640,   641,   642,   800,   234,   801,   643,   235,   644,   645,
     646,   802,   803,   647,   804,   805,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,   717,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   718,   104,   105,   672,   719,     0,   107,
     108,   109,   110,   720,   721,   112,   113,   114,   115,     0,
     116,   722,   723,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,   135,   136,   137,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,   145,     0,   443,   444,   445,   446,   148,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,     0,     0,     0,   152,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,   169,     0,   170,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
     500,   173,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,   174,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
     182,   524,   183,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,   189,   190,   538,   539,   191,     0,   540,   541,
     193,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,   197,
     198,   199,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,   219,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,   717,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   718,   104,   105,   672,   719,
       0,   107,   108,   109,   110,   720,   721,   112,   113,   114,
     115,     0,   116,   722,   723,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,   133,   428,   429,   430,   135,
     136,   137,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,   440,
     441,   442,   144,     0,   145,     0,   443,   444,   445,   446,
     148,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,   151,   454,     0,     0,     0,     0,   152,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,   169,     0,   170,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,  1311,   173,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,   174,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,   182,   524,   183,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,   189,   190,   538,   539,   191,     0,
     540,   541,   193,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,   197,   198,   199,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,   210,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
     219,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,   692,   234,     0,
     643,   235,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,   717,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   718,   104,   105,
     672,   719,     0,   107,   108,   109,   110,   720,   721,   112,
     113,   114,   115,     0,   116,   722,   723,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,   133,   428,   429,
     430,   135,   136,   137,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,   145,     0,   443,   444,
     445,   446,   148,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,   151,   454,     0,     0,     0,     0,   152,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,   169,     0,
     170,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,  1320,   173,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,   174,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
     178,   179,   515,   180,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,   182,   524,   183,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,   189,   190,   538,   539,
     191,     0,   540,   541,   193,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,   197,   198,   199,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,   210,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,   219,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,   235,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,   717,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   718,
     104,   105,   672,   719,     0,   107,   108,   109,   110,   720,
     721,   112,   113,   114,   115,     0,   116,   722,   723,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,   133,
     428,   429,   430,     0,  1859,   137,  1860,  1861,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,  1862,  1863,
     438,     0,   439,   440,   441,   442,     0,     0,   145,     0,
     443,   444,   445,   446,   148,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,   151,   454,     0,     0,     0,
       0,   152,     0,     0,     0,   455,   456,   457,   458,   686,
     459,  1864,  1865,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
    1460,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,     0,   484,   485,   486,     0,
       0,   487,     0,   488,  1866,   489,     0,   490,     0,   491,
     169,     0,   170,   492,   493,   494,     0,   495,     0,     0,
     496,     0,   497,   498,   688,   499,   500,   173,   501,   502,
     503,  2423,   504,   505,   506,   507,   508,   509,     0,   510,
     174,  2424,     0,   511,   512,   513,  1466,  1867,     0,  1868,
       0,   514,   178,   179,   515,   180,   516,   517,   518,   519,
     520,   521,   522,     0,   523,     0,   182,   524,   183,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,  1869,   189,  1870,
     538,   539,     0,     0,   540,   541,   193,   542,     0,     0,
     543,  1871,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,  2425,   197,   198,   199,     0,   551,
     552,   553,   554,   555,   556,   557,     0,   558,     0,   559,
       0,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,  1872,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,   210,   586,   587,     0,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,  2426,   601,   602,   219,   603,  1874,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,     0,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,  1875,  1876,     0,     0,   624,     0,   625,     0,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,     0,  1877,  2427,   643,   235,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   693,   653,
     654,   717,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   718,   104,   105,   672,   719,     0,   107,   108,   109,
     110,   720,   721,   112,   113,   114,   115,     0,   116,   722,
     723,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,   133,   428,   429,   430,     0,  1859,   137,  1860,  1861,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
    1862,  1863,   438,     0,   439,   440,   441,   442,     0,     0,
     145,     0,   443,   444,   445,   446,   148,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,   151,   454,     0,
       0,     0,     0,   152,     0,     0,     0,   455,   456,   457,
     458,   686,   459,  1864,  1865,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,  1460,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,     0,   484,   485,
     486,     0,     0,   487,     0,   488,  1866,   489,     0,   490,
       0,   491,   169,     0,   170,   492,   493,   494,     0,   495,
       0,     0,   496,     0,   497,   498,   688,   499,   500,   173,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,   174,     0,     0,   511,   512,   513,  1466,  1867,
       0,  1868,     0,   514,   178,   179,   515,   180,   516,   517,
     518,   519,   520,   521,   522,     0,   523,     0,   182,   524,
     183,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,  1869,
     189,  1870,   538,   539,     0,     0,   540,   541,   193,   542,
    2411,     0,   543,  1871,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,     0,   197,   198,   199,
       0,   551,   552,   553,   554,   555,   556,   557,     0,   558,
       0,   559,     0,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,  1872,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,   210,   586,   587,     0,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,  2426,   601,   602,   219,   603,  1874,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,     0,     0,   615,   616,  3878,   617,   618,   619,   620,
     621,   622,     0,  1875,  1876,     0,     0,   624,     0,   625,
       0,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,     0,  1877,     0,   643,   235,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     693,   653,   654,   717,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   718,   104,   105,   672,   719,     0,   107,
     108,   109,   110,   720,   721,   112,   113,   114,   115,     0,
     116,   722,   723,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,     0,  1859,   137,
    1860,  1861,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,  1862,  1863,   438,     0,   439,   440,   441,   442,
       0,     0,   145,     0,   443,   444,   445,   446,   148,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,     0,     0,     0,   152,     0,     0,     0,   455,
     456,   457,   458,   686,   459,  1864,  1865,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,  1460,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,     0,
     484,   485,   486,     0,     0,   487,     0,   488,  1866,   489,
       0,   490,     0,   491,   169,     0,   170,   492,   493,   494,
       0,   495,     0,     0,   496,     0,   497,   498,   688,   499,
     500,   173,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,   174,     0,     0,   511,   512,   513,
    1466,  1867,     0,  1868,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,     0,
     182,   524,   183,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,  1869,   189,  1870,   538,   539,  2473,     0,   540,   541,
     193,   542,     0,     0,   543,  1871,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,     0,   197,
     198,   199,     0,   551,   552,   553,   554,   555,   556,   557,
       0,   558,     0,   559,     0,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,  1872,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,     0,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,  1873,   601,   602,   219,   603,
    1874,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,     0,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,  1875,  1876,     0,     0,   624,
       0,   625,     0,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,     0,  1877,     0,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   693,   653,   654,   717,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   718,   104,   105,   672,   719,
       0,   107,   108,   109,   110,   720,   721,   112,   113,   114,
     115,     0,   116,   722,   723,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,   133,   428,   429,   430,     0,
    1859,   137,  1860,  1861,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,  1862,  1863,   438,     0,   439,   440,
     441,   442,     0,     0,   145,     0,   443,   444,   445,   446,
     148,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,   151,   454,     0,     0,     0,     0,   152,     0,     0,
       0,   455,   456,   457,   458,   686,   459,  1864,  1865,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,  1460,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,     0,   484,   485,   486,     0,     0,   487,     0,   488,
    1866,   489,     0,   490,     0,   491,   169,     0,   170,   492,
     493,   494,     0,   495,     0,     0,   496,     0,   497,   498,
     688,   499,   500,   173,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,   174,     0,     0,   511,
     512,   513,  1466,  1867,     0,  1868,     0,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,     0,
     523,     0,   182,   524,   183,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,  1869,   189,  1870,   538,   539,  3702,     0,
     540,   541,   193,   542,     0,     0,   543,  1871,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
       0,   197,   198,   199,     0,   551,   552,   553,   554,   555,
     556,   557,     0,   558,     0,   559,     0,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,  1872,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,   210,   586,   587,
       0,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,  1873,   601,   602,
     219,   603,  1874,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,     0,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,  1875,  1876,     0,
       0,   624,     0,   625,     0,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,     0,  1877,     0,
     643,   235,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   693,   653,   654,   717,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   718,   104,   105,
     672,   719,     0,   107,   108,   109,   110,   720,   721,   112,
     113,   114,   115,     0,   116,   722,   723,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,   133,   428,   429,
     430,     0,  1859,   137,  1860,  1861,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,  1862,  1863,   438,     0,
     439,   440,   441,   442,     0,     0,   145,     0,   443,   444,
     445,   446,   148,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,   151,   454,     0,     0,     0,     0,   152,
       0,     0,     0,   455,   456,   457,   458,   686,   459,  1864,
    1865,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,  1460,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,     0,   484,   485,   486,     0,     0,   487,
       0,   488,  1866,   489,     0,   490,     0,   491,   169,     0,
     170,   492,   493,   494,     0,   495,     0,     0,   496,     0,
     497,   498,   688,   499,   500,   173,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,   174,     0,
       0,   511,   512,   513,  1466,  1867,     0,  1868,     0,   514,
     178,   179,   515,   180,   516,   517,   518,   519,   520,   521,
     522,     0,   523,     0,   182,   524,   183,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,  1869,   189,  1870,   538,   539,
       0,     0,   540,   541,   193,   542,     0,     0,   543,  1871,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,     0,   197,   198,   199,     0,   551,   552,   553,
     554,   555,   556,   557,     0,   558,     0,   559,     0,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
    1872,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,   210,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,  1873,
     601,   602,   219,   603,  1874,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,     0,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,  1875,
    1876,     0,     0,   624,     0,   625,     0,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,     0,
    1877,     0,   643,   235,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   693,   653,   654,   717,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   718,
     104,   105,   672,   719,     0,   107,   108,   109,   110,   720,
     721,   112,   113,   114,   115,     0,   116,   722,   723,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,   133,
     428,   429,   430,     0,  1859,   137,  1860,  1861,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,  1862,  1863,
     438,     0,   439,   440,   441,   442,     0,     0,   145,     0,
     443,   444,   445,   446,   148,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,   151,   454,     0,     0,     0,
       0,   152,     0,     0,     0,   455,   456,   457,   458,   686,
     459,  1864,  1865,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
    1460,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,     0,   484,   485,   486,     0,
       0,   487,     0,   488,  1866,   489,     0,   490,     0,   491,
     169,     0,   170,   492,   493,   494,     0,   495,     0,     0,
     496,     0,   497,   498,   688,   499,   500,   173,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
     174,     0,     0,   511,   512,   513,  1466,  1867,     0,  1868,
       0,   514,   178,   179,   515,   180,   516,   517,   518,   519,
     520,   521,   522,     0,   523,     0,   182,   524,   183,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,  1869,   189,  1870,
     538,   539,     0,     0,   540,   541,   193,   542,     0,     0,
     543,  1871,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,     0,   197,   198,   199,     0,   551,
     552,   553,   554,   555,   556,   557,     0,   558,     0,   559,
       0,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,  1872,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,   210,   586,   587,     0,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,  2426,   601,   602,   219,   603,  1874,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,     0,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,  1875,  1876,     0,     0,   624,     0,   625,     0,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,     0,  1877,     0,   643,   235,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   693,   653,
     654,   717,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   718,   104,   105,   672,   719,     0,   107,   108,   109,
     110,   720,   721,   112,   113,   114,   115,     0,   116,   722,
     723,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,   133,   428,   429,   430,     0,  1859,   137,  1860,  1861,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
    1862,  1863,   438,     0,   439,   440,   441,   442,     0,     0,
     145,     0,   443,   444,   445,   446,   148,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,   151,   454,     0,
       0,     0,     0,   152,     0,     0,     0,   455,   456,   457,
     458,   686,   459,  1864,  1865,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,  1460,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,     0,   484,   485,
     486,     0,     0,   487,     0,   488,  1866,   489,     0,   490,
       0,   491,   169,     0,   170,   492,   493,   494,     0,   495,
       0,     0,   496,     0,   497,   498,   688,   499,   500,   173,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,   174,     0,     0,   511,   512,   513,  1466,  1867,
       0,  1868,     0,   514,   178,   179,   515,   180,   516,   517,
     518,   519,   520,   521,   522,     0,   523,     0,   182,   524,
     183,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,  1869,
     189,  1870,   538,   539,     0,     0,   540,   541,   193,   542,
       0,     0,   543,  1871,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,     0,   197,   198,   199,
       0,   551,   552,   553,   554,   555,   556,   557,     0,   558,
       0,   559,     0,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,  1872,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,   210,   586,   587,     0,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,     0,   601,   602,   219,   603,  1874,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,     0,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,  1875,  1876,     0,     0,   624,     0,   625,
       0,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,     0,  1877,     0,   643,   235,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     693,   653,   654,   717,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   718,   104,   105,   672,   719,     0,   107,
     108,   109,   110,   720,   721,   112,   113,   114,   115,     0,
     116,   722,   723,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,     0,     0,   137,
       0,     0,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,     0,     0,   438,     0,   439,   440,   441,   442,
       0,     0,   145,     0,   443,   444,   445,   446,   148,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,     0,     0,     0,   152,     0,     0,     0,   455,
     456,   457,   458,   686,   459,     0,     0,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,     0,
     484,   485,   486,     0,     0,   487,     0,   488,     0,   489,
       0,   490,     0,   491,   169,     0,   170,   492,   493,   494,
       0,   495,     0,     0,   496,     0,   497,   498,   688,   499,
     500,   173,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,   174,     0,     0,   511,   512,   513,
       0,     0,     0,     0,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,     0,
     182,   524,   183,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,     0,   189,     0,   538,   539,     0,     0,   540,   541,
     193,   542,     0,     0,   543,     0,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,     0,   197,
     198,   199,     0,   551,   552,   553,   554,   555,   556,   557,
       0,   558,     0,   559,     0,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,     0,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,     0,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,     0,   601,   602,   219,   603,
       0,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,     0,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,     0,     0,     0,     0,   624,
       0,   625,     0,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,     0,     0,     0,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   693,   653,   654,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,   724,   421,
     422,   423,   725,   726,   727,   728,   729,   730,   731,   424,
     425,   732,   426,   427,   133,   428,   429,   430,   135,   136,
     137,   138,   139,   733,   431,   432,   433,   434,   435,   734,
     735,   436,   437,     0,   140,   438,   737,   439,   440,   441,
     442,   144,   738,   145,   739,   443,   444,   445,   446,   148,
     447,   740,   741,   448,   449,   450,   451,   452,   453,   742,
     151,   454,     0,   744,   745,   746,   152,   747,   748,   749,
     455,   456,   457,   458,     0,   459,   155,   156,   460,   750,
     461,   751,   462,   463,   464,   465,   466,   752,   467,   468,
     469,   753,   754,   470,   471,   472,   473,   474,   755,   475,
     476,   477,   756,   478,   479,   757,   480,   481,   482,   483,
     164,   484,   485,   486,   166,   758,   487,   759,   488,   168,
     489,   760,   490,   761,   491,   169,   762,   170,   492,   493,
     494,   763,   495,   172,   764,   496,   765,   497,   498,     0,
     499,   500,   173,   501,   502,   503,   766,   504,   505,   506,
     507,   508,   509,   767,   510,   174,   175,     0,   511,   512,
     513,     0,   176,   770,   177,   771,   514,   178,   179,   515,
     180,   516,   517,   518,   519,   520,   521,   522,   772,   523,
     181,   182,   524,   183,   773,   525,   526,   527,   774,   775,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,   537,   188,   189,   190,   538,   539,   191,   776,   540,
     541,   193,   542,   777,   194,   543,   195,   544,   545,   546,
     778,   547,   779,   780,   548,   549,   550,   781,   782,   196,
     197,   198,   199,   200,   551,   552,   553,   554,   555,   556,
     557,   783,   558,   201,   559,   202,   560,   561,   562,   784,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,   785,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,   786,   584,   585,   210,   586,   587,   212,
     588,   589,   590,   591,   592,   593,     0,   594,   787,   595,
     596,   597,   598,   599,   788,   600,   217,   601,   602,   219,
     603,   220,   604,   789,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,   790,   615,   616,   791,   617,
     618,   619,   620,   621,   622,   792,   224,   225,     0,   794,
     624,   226,   625,   227,   795,   626,   627,   628,   629,   630,
     631,   632,     0,   797,   633,   634,   635,   636,   637,   798,
     799,   638,   639,   640,   641,   642,     0,   234,   801,   643,
     235,   644,   645,   646,   802,   803,   647,   804,   805,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,     0,   653,   654,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,   412,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
    1132,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,   500,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,   692,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,   412,     0,     0,    37,    38,    39,    40,
      41,    42,     0,    44,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,     0,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,   500,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,  2364,
     439,   440,   441,   442,   144,     0,     0,  2439,   443,   444,
     445,   446,     0,   447,   684,  2365,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,  2440,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,  2367,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,   500,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,  2368,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,  2369,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
    2364,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,  2365,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
    2440,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,  2367,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,  3314,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,  2368,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,  2369,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
    1030,   419,   420,   989,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,   990,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,  1031,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,   991,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,   992,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,   989,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,   990,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,  3019,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,   991,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,   992,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,   500,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   672,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,     0,   428,   429,   430,   135,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   683,   140,   438,  2364,   439,   440,   441,   442,   144,
       0,     0,     0,   443,   444,   445,   446,     0,   447,   684,
    2365,   448,   449,   450,   451,   452,   453,     0,     0,   454,
       0,     0,     0,     0,     0,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,  2440,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,  2367,   491,     0,     0,     0,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,   500,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,     0,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,     0,     0,   515,     0,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,     0,
     524,     0,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,     0,   190,   538,   539,   191,     0,   540,   541,     0,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,     0,     0,
       0,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,  2368,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,     0,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,     0,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,  2369,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,   692,   234,     0,   643,     0,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
     412,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,   682,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,   685,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,   687,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
     500,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,   989,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,   990,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,   991,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,   992,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,    86,    87,    88,   669,
      90,    91,    92,   670,   905,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,   412,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,   906,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,   500,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   907,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,   692,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
    2045,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,     0,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,  2046,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,  2047,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,  2048,   491,     0,     0,     0,
    2049,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,   500,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,  2050,  2051,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,   586,
     587,   212,   588,   589,   590,  2052,   592,   593,   691,   594,
       0,  2053,   596,   597,   598,   599,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
    2054,   617,  2055,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,  2056,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,   990,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,   500,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,   991,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,   992,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,    86,
      87,    88,   669,    90,    91,    92,   670,  2034,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
    2322,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,   412,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,  2895,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,  2896,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,  2897,   617,   618,  2898,   620,  2899,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
    2900,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,   412,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,   709,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,   412,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,   687,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,   412,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,   857,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,   500,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   672,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,   412,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,  1303,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,     0,   428,   429,   430,   135,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   683,   140,   438,     0,   439,   440,   441,   442,   144,
       0,     0,     0,   443,   444,   445,   446,     0,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,     0,   454,
       0,     0,     0,     0,     0,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,     0,     0,     0,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,   500,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,     0,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,     0,     0,   515,     0,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,     0,
     524,     0,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,     0,   190,   538,   539,   191,     0,   540,   541,     0,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,     0,     0,
       0,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,     0,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,     0,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,   692,   234,     0,   643,     0,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,   130,   131,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
     500,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,  3100,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,  3101,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,  3112,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,   500,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
    3113,     0,   638,   639,   640,   641,   642,   692,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,   412,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,     0,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,   500,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,   412,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,   500,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     911,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,   412,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   953,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,   412,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,  1006,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,  1063,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,  1206,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
    1063,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   672,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,  1545,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,     0,   428,   429,   430,   135,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   683,   140,   438,     0,   439,   440,   441,   442,   144,
       0,     0,     0,   443,   444,   445,   446,     0,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,     0,   454,
       0,     0,     0,     0,     0,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,     0,     0,     0,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,   500,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,     0,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,     0,     0,   515,     0,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,     0,
     524,     0,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,     0,   190,   538,   539,   191,     0,   540,   541,     0,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,     0,     0,
       0,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,     0,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,     0,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,   692,   234,     0,   643,     0,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
    1717,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,  1063,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,  1942,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,    86,    87,    88,   669,
      90,    91,    92,   670,  2034,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,  2322,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,   500,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,   692,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,  4015,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,     0,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,   500,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
    4028,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,   500,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,  4246,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,  4248,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,  4250,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,   500,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,  4626,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   672,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,     0,   428,   429,   430,   135,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   683,   140,   438,     0,   439,   440,   441,   442,   144,
       0,     0,     0,   443,   444,   445,   446,     0,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,     0,   454,
       0,     0,     0,     0,     0,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,     0,     0,     0,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,   500,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,     0,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,     0,     0,   515,     0,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,     0,
     524,     0,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,     0,   190,   538,   539,   191,     0,   540,   541,     0,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,     0,     0,
       0,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,     0,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,     0,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,   692,   234,     0,   643,     0,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
     500,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,  1014,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,  1016,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,  1017,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,     0,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,  1018,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,  1019,   225,     0,     0,
    1020,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,  1021,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,  1057,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,  1017,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,     0,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,   500,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,  1058,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,  1059,   225,     0,
       0,  1060,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,  1021,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,     0,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,   500,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,  1077,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,  1182,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,  1203,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,  1214,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,  1265,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,  1316,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   672,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,     0,   428,   429,   430,   135,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   683,   140,   438,     0,   439,   440,   441,   442,   144,
       0,     0,     0,   443,   444,   445,   446,     0,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,     0,   454,
       0,     0,     0,     0,     0,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,     0,     0,     0,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,  1333,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,     0,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,     0,     0,   515,     0,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,     0,
     524,     0,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,     0,   190,   538,   539,   191,     0,   540,   541,     0,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,     0,     0,
       0,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,     0,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,     0,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,   692,   234,     0,   643,     0,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
    1335,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,  1337,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,  1340,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,   692,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,     0,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,  1346,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,  1556,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,  1043,   437,  1017,   140,  1557,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,     0,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,   500,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,  1047,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
    1048,   587,   212,   588,   589,   590,  1049,   592,   593,   691,
     594,     0,   595,   596,   597,   598,  1549,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,  1051,
     225,     0,     0,  1052,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,  1021,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,  1053,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,  1681,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,  1905,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,  1932,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,  1966,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   672,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,     0,   428,   429,   430,   135,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   683,   140,   438,     0,   439,   440,   441,   442,   144,
       0,     0,     0,   443,   444,   445,   446,     0,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,     0,   454,
       0,     0,     0,     0,     0,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,     0,     0,     0,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,  1968,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,     0,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,     0,     0,   515,     0,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,     0,
     524,     0,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,     0,   190,   538,   539,   191,     0,   540,   541,     0,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,     0,     0,
       0,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,     0,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,     0,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,   692,   234,     0,   643,     0,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
    1970,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,  2082,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,  2289,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,   500,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,     0,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,   692,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,     0,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,  2659,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,  3030,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,  3103,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,  3105,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,  3197,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,  1043,   437,
    1017,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,     0,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,   500,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,  1047,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,  1048,   587,   212,   588,   589,   590,
    1049,   592,   593,   691,   594,     0,   595,   596,   597,   598,
    1549,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,  1051,   225,     0,     0,  1052,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,  1021,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
    1053,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   672,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,     0,   428,   429,   430,   135,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,  1043,
     437,  1017,   140,   438,     0,   439,   440,   441,   442,   144,
       0,     0,     0,   443,   444,   445,   446,     0,   447,     0,
       0,   448,   449,   450,   451,   452,   453,     0,     0,   454,
       0,     0,     0,     0,     0,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,     0,     0,     0,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,   500,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,     0,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,     0,     0,   515,     0,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,     0,
     524,     0,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,  1047,
     188,     0,   190,   538,   539,   191,     0,   540,   541,     0,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,     0,     0,
       0,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,     0,  1048,   587,   212,   588,   589,
     590,  1049,   592,   593,   691,   594,     0,   595,   596,   597,
     598,  1549,     0,   600,   217,   601,   602,     0,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,  2355,   619,
     620,   621,   622,     0,  1051,   225,     0,     0,  1052,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,  1021,   234,     0,   643,     0,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,  1053,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
    1043,   437,  1017,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
       0,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
     500,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
    1047,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,  1048,   587,   212,   588,
     589,   590,  2415,   592,   593,   691,   594,     0,   595,   596,
     597,   598,  2416,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,  1051,   225,     0,     0,  2417,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,  1021,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,  1053,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,  1043,   437,  1017,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,     0,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,  1047,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,  1048,   587,   212,
     588,   589,   590,  1049,   592,   593,   691,   594,     0,   595,
     596,   597,   598,  2416,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,  1051,   225,     0,     0,
    2417,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,  1021,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,  1053,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,   500,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,     0,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,     0,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,     0,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,   692,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    86,    87,    88,
       0,    90,    91,    92,     0,     0,     0,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,     0,
       0,     0,   107,   108,   109,   110,     0,   111,   112,   113,
     114,   115, -2331,   116,   117,   118,     0,     0,     0,     0,
       0,   121,   122,     0,     0,     0,     0,   123,     0,     0,
       0,     0,     0,     0,     0,     0,   124,     0,   125,     0,
     126,   127,    35,     0,   407,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   133,     0,     0,     0,
     135,   136,   137,   138,   139,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   140,     0,     0,     0,
       0,     0,     0,   144,     0,   145,     0,     0,     0,     0,
       0,   148,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   151,     0,     0,     0,     0,     0,   152,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   155,   156,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   162,     0,     0,     0,     0,
       0,     0,   164,     0,     0,     0,   166,     0,     0,     0,
       0,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   172,     0,     0,     0,     0,
       0,     0,     0,     0,   173,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   174,   175,     0,
       0,     0,     0,     0,   176,     0,   177,     0,     0,   178,
     179,     0,   180,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   181,   182,     0,   183,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   188,   189,   190,     0,     0,   191,
       0,     0,     0,   193,     0,     0,   194,     0,   195,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   196,   197,   198,   199,   200,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   204,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   210,     0,
       0,   212,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   217,     0,
       0,   219,     0,   220,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   222,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   224,   225,
       0,     0,     0,   226,     0,   227,     0,     0,     0,     0,
       0,     0,     0,     0,   230,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   234,
       0,     0,   235,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   237,   238,   239,   240,
     241,   242,   243,   244,   245,    86,    87,    88,     0,    90,
      91,    92,     0,     0,     0,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,     0,     0,     0,
     107,   108,   109,   110,     0,   111,   112,   113,   114,   115,
   -2332,   116,   117,   118,     0,     0,     0,     0,     0,   121,
     122,     0,     0,     0,     0,   123,     0,     0,     0,     0,
       0,     0,     0,     0,   124,     0,   125,     0,   126,   127,
      35,     0,  1127,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   133,     0,     0,     0,   135,   136,
     137,   138,   139,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   140,     0,     0,     0,     0,     0,
       0,   144,     0,   145,     0,     0,     0,     0,     0,   148,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     151,     0,     0,     0,     0,     0,   152,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   155,   156,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   162,     0,     0,     0,     0,     0,     0,
     164,     0,     0,     0,   166,     0,     0,     0,     0,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   172,     0,     0,     0,     0,     0,     0,
       0,     0,   173,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   174,   175,     0,     0,     0,
       0,     0,   176,     0,   177,     0,     0,   178,   179,     0,
     180,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     181,   182,     0,   183,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   188,   189,   190,     0,     0,   191,     0,     0,
       0,   193,     0,     0,   194,     0,   195,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   196,
     197,   198,   199,   200,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   204,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   210,     0,     0,   212,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   217,     0,     0,   219,
       0,   220,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   222,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   224,   225,     0,     0,
       0,   226,     0,   227,     0,     0,     0,     0,     0,     0,
       0,     0,   230,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   234,     0,     0,
     235,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   237,   238,   239,   240,   241,   242,
     243,   244,   245,    86,    87,    88,     0,    90,    91,    92,
       0,     0,     0,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,     0,     0,     0,   107,   108,
     109,   110,     0,   111,   112,   113,   114,   115,     0,   116,
     117,   118,     0,     0,     0,     0,     0,   121,   122,     0,
       0,     0,     0,   123,     0,     0,     0,     0,     0,     0,
       0,     0,   124,     0,   125,     0,   126,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   133,     0,     0,     0,   135,   136,   137,   138,
     139,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   140,     0,     0,     0,     0,     0,     0,   144,
       0,   145,     0,     0,     0,     0,     0,   148,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   151,     0,
       0,     0,     0,     0,   152,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   155,   156,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   162,     0,     0,     0,     0,     0,     0,   164,     0,
       0,     0,   166,     0,     0,     0,     0,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   172,     0,     0,     0,     0,     0,     0,     0,     0,
     173,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   174,   175,     0,     0,     0,     0,     0,
     176,     0,   177,     0,     0,   178,   179,     0,   180,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   181,   182,
       0,   183,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     188,   189,   190,     0,     0,   191,     0,     0,     0,   193,
       0,     0,   194,     0,   195,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   196,   197,   198,
     199,   200,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   204,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   210,     0,     0,   212,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   217,     0,     0,   219,     0,   220,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   222,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   224,   225,     0,     0,     0,   226,
       0,   227,     0,     0,     0,     0,     0,     0,     0,     0,
     230,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   234,     0,     0,   235,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   237,   238,   239,   240,   241,   242,   243,   244,
     245,    86,    87,    88,     0,    90,    91,    92,     0,     0,
       0,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,     0,     0,     0,   107,   108,   109,   110,
       0,   111,   112,   113,   114,   115,     0,   116,   117,   118,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     133,     0,     0,     0,   135,   136,   137,   138,   139,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     140,     0,     0,     0,     0,     0,     0,   144,     0,   145,
       0,     0,     0,     0,     0,   148,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   151,     0,     0,     0,
       0,     0,   152,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   155,   156,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   162,
       0,     0,     0,     0,     0,     0,   164,     0,     0,     0,
     166,     0,     0,     0,     0,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   172,
       0,     0,     0,     0,     0,     0,     0,     0,   173,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   174,   175,     0,     0,     0,     0,     0,   176,     0,
     177,     0,     0,   178,   179,     0,   180,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   181,   182,     0,   183,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   188,   189,
     190,     0,     0,   191,     0,     0,     0,   193,     0,     0,
     194,     0,   195,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   196,   197,   198,   199,   200,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   201,
       0,   202,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   204,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   210,     0,     0,   212,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   217,     0,     0,   219,     0,   220,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     222,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   224,   225,     0,     0,     0,   226,     0,   227,
       0,     0,     0,     0,     0,     0,     0,     0,   230,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   234,     0,     0,   235,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     237,   238,   239,   240,   241,   242,   243,   244,   245,    86,
      87,    88,     0,    90,    91,    92,     0,     0,     0,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,     0,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   133,     0,
       0,     0,   135,   136,   137,   138,   139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   140,     0,
       0,     0,     0,     0,     0,   144,     0,   145,     0,     0,
       0,     0,     0,   148,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   151,     0,     0,     0,     0,     0,
     152,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     155,   156,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   164,     0,     0,     0,   166,     0,
       0,     0,     0,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   172,     0,     0,
       0,     0,     0,     0,     0,     0,   173,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   174,
     175,     0,     0,     0,     0,     0,   176,     0,   177,     0,
       0,   178,   179,     0,   180,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   181,   182,     0,   183,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   188,   189,   190,     0,
       0,   191,     0,     0,     0,   193,     0,     0,   194,     0,
     195,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   196,   197,   198,   199,   200,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   204,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     210,     0,     0,   212,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     217,     0,     0,   219,     0,   220,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   222,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     224,   225,     0,     0,     0,   226,     0,   227,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   234,     0,     0,   235,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   237,   238,
     239,   240,   241,   242,   243,   244,   245,    35,   412,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
       0,   140,   438,     0,   439,   440,   441,   442,   144,     0,
     145,     0,   443,   444,   445,   446,   148,   447,     0,     0,
     448,   449,   450,   451,   452,   453,     0,   151,   454,     0,
       0,     0,     0,   152,     0,     0,     0,   455,   456,   457,
     458,     0,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,  2010,   487,     0,   488,   168,   489,     0,   490,
       0,   491,   169,     0,   170,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,     0,   499,   500,   173,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,   174,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,   178,   179,   515,   180,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,   182,   524,
     183,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,     0,   533,   534,     0,   535,   536,   537,   188,
     189,   190,   538,   539,   191,     0,   540,   541,   193,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,  2011,
       0,   548,   549,   550,     0,     0,   196,   197,   198,   199,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,   210,   586,   587,   212,   588,   589,   590,
     591,   592,   593,     0,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,   219,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,  2012,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,     0,   234,     0,   643,   235,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
      35,   653,   654,     0,     0,     0,     0,     0,    41,    42,
     980,  1639,  4210,     0,     0,     0,     0,     0,     0,  4211,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,   130,   131,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,   133,   428,   429,   430,   135,   136,
     137,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,   140,   438,     0,   439,   440,   441,
     442,   144,     0,   145,     0,   443,   444,   445,   446,   148,
     447,     0,     0,   448,   449,   450,   451,   452,   453,     0,
     151,   454,     0,     0,     0,     0,   152,     0,     0,     0,
     455,   456,   457,   458,     0,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,   169,     0,   170,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,     0,
     499,   500,   173,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,   174,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,   178,   179,   515,
     180,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,   182,   524,   183,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,   537,   188,   189,   190,   538,   539,   191,     0,   540,
     541,   193,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
     197,   198,   199,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,   210,   586,   587,   212,
     588,   589,   590,   591,   592,   593,     0,   594,   215,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,   219,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,   223,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   233,   234,     0,   643,
     235,   644,   645,   646,     0,     0,   647,     0,   236,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,     0,   653,   654,    35,   412,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
       0,    45,   246,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
     133,   428,   429,   430,   135,   136,   137,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,     0,
     140,   438,     0,   439,   440,   441,   442,   144,     0,   145,
       0,   443,   444,   445,   446,   148,   447,     0,     0,   448,
     449,   450,   451,   452,   453,     0,   151,   454,     0,     0,
       0,     0,   152,     0,     0,     0,   455,   456,   457,   458,
       0,   459,   155,   156,   460,  2228,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,  2010,   487,     0,   488,   168,   489,     0,   490,     0,
     491,   169,     0,   170,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,     0,   499,   500,   173,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,   174,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,   178,   179,   515,   180,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,   182,   524,   183,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,     0,   533,   534,     0,   535,   536,   537,   188,   189,
     190,   538,   539,   191,     0,   540,   541,   193,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,  2011,     0,
     548,   549,   550,     0,     0,   196,   197,   198,   199,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,   210,   586,   587,   212,   588,   589,   590,   591,
     592,   593,     0,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,   219,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
    2012,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,     0,   234,     0,   643,   235,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,     0,
     653,   654,     0,     0,     0,     0,     0,    35,   412,   980,
    1639,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
       0,   140,   438,     0,   439,   440,   441,   442,   144,     0,
     145,     0,   443,   444,   445,   446,   148,   447,     0,     0,
     448,   449,   450,   451,   452,   453,     0,   151,   454,     0,
       0,     0,     0,   152,     0,     0,     0,   455,   456,   457,
     458,     0,   459,   155,   156,   460,  2233,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,  2010,   487,     0,   488,   168,   489,     0,   490,
       0,   491,   169,     0,   170,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,     0,   499,   500,   173,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,   174,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,   178,   179,   515,   180,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,   182,   524,
     183,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,     0,   533,   534,     0,   535,   536,   537,   188,
     189,   190,   538,   539,   191,     0,   540,   541,   193,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,  2011,
       0,   548,   549,   550,     0,     0,   196,   197,   198,   199,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,   210,   586,   587,   212,   588,   589,   590,
     591,   592,   593,     0,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,   219,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,  2012,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,     0,   234,     0,   643,   235,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
       0,   653,   654,     0,     0,     0,     0,     0,    35,   412,
     980,  1639,    37,    38,    39,    40,    41,    42,    43,    44,
       0,     0,     0,    45,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,   133,   428,   429,   430,   135,   136,   137,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,     0,   140,   438,     0,   439,   440,   441,   442,   144,
       0,   145,     0,   443,   444,   445,   446,   148,   447,     0,
       0,   448,   449,   450,   451,   452,   453,     0,   151,   454,
       0,     0,     0,     0,   152,     0,     0,     0,   455,   456,
     457,   458,     0,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,  2010,   487,     0,   488,   168,   489,     0,
     490,     0,   491,   169,     0,   170,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,     0,   499,   500,
     173,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,   174,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,   178,   179,   515,   180,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,   182,
     524,   183,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,   537,
     188,   189,   190,   538,   539,   191,     0,   540,   541,   193,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
    2011,     0,   548,   549,   550,     0,     0,   196,   197,   198,
     199,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,   210,   586,   587,   212,   588,   589,
     590,   591,   592,   593,     0,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,   219,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,  2012,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,     0,   234,     0,   643,   235,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,     0,   653,   654,     0,     0,     0,     0,     0,    35,
       0,   980,  1639,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,   135,   136,   137,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,     0,   140,   438,     0,   439,   440,   441,   442,
     144,     0,   145,     0,   443,   444,   445,   446,   148,   447,
       0,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,     0,     0,     0,   152,     0,     0,     0,   455,
     456,   457,   458,     0,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,  2010,   487,     0,   488,   168,   489,
       0,   490,     0,   491,   169,     0,   170,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,     0,   499,
     500,   173,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,   174,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
     182,   524,   183,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,     0,   533,   534,     0,   535,   536,
     537,   188,   189,   190,   538,   539,   191,     0,   540,   541,
     193,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,  2011,     0,   548,   549,   550,     0,     0,   196,   197,
     198,   199,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,   212,   588,
     589,   590,   591,   592,   593,     0,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,   219,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,  2012,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,     0,   234,     0,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,     0,   653,   654,    35,   412,     0,     0,    37,
      38,    39,    40,    41,    42,     0,    44,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,   133,
     428,   429,   430,   135,   136,   137,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,     0,   140,
     438,     0,   439,   440,   441,   442,   144,     0,   145,     0,
     443,   444,   445,   446,   148,   447,     0,     0,   448,   449,
     450,   451,   452,   453,     0,   151,   454,     0,     0,     0,
       0,   152,     0,     0,     0,   455,   456,   457,   458,     0,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
     169,     0,   170,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,     0,   499,   500,   173,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
     174,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,   178,   179,   515,   180,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,   182,   524,   183,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
       0,   533,   534,     0,   535,   536,   537,   188,   189,   190,
     538,   539,   191,     0,   540,   541,   193,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,   197,   198,   199,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,   210,   586,   587,   212,   588,   589,   590,   591,   592,
     593,     0,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,   219,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,   623,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,     0,   234,     0,   643,   235,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,     0,   653,
     654,    35,   412,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,   133,   428,   429,   430,   135,
     136,   137,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,     0,   140,   438,     0,   439,   440,
     441,   442,   144,     0,   145,     0,   443,   444,   445,   446,
     148,   447,     0,     0,   448,   449,   450,   451,   452,   453,
       0,   151,   454,     0,     0,     0,     0,   152,     0,     0,
       0,   455,   456,   457,   458,     0,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,   169,     0,   170,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
       0,   499,   500,   173,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,   174,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,   182,   524,   183,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,   537,   188,   189,   190,   538,   539,   191,     0,
     540,   541,   193,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,   197,   198,   199,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,   210,   586,   587,
     212,   588,   589,   590,   591,   592,   593,     0,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
     219,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,     0,   234,     0,
     643,   235,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,    35,   653,   654,     0,    37,    38,
      39,    40,    41,    42,     0,    44,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,   133,   428,
     429,   430,   135,   136,   137,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,     0,   140,   438,
       0,   439,   440,   441,   442,   144,     0,   145,     0,   443,
     444,   445,   446,   148,   447,     0,     0,   448,   449,   450,
     451,   452,   453,     0,   151,   454,     0,     0,     0,     0,
     152,     0,     0,     0,   455,   456,   457,   458,     0,   459,
     155,   156,   460,  2213,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,   169,
       0,   170,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,     0,   499,   500,   173,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,   174,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,   178,   179,   515,   180,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,   182,   524,   183,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,     0,
     533,   534,     0,   535,   536,   537,   188,   189,   190,   538,
     539,   191,     0,   540,   541,   193,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,   197,   198,   199,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
     210,   586,   587,   212,   588,   589,   590,   591,   592,   593,
       0,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,   219,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
       0,   234,     0,   643,   235,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,    35,   653,   654,
       0,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
       0,   140,   438,     0,   439,   440,   441,   442,   144,     0,
     145,     0,   443,   444,   445,   446,   148,   447,     0,     0,
     448,   449,   450,   451,   452,   453,     0,   151,   454,     0,
       0,     0,     0,   152,     0,     0,     0,   455,   456,   457,
     458,     0,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,   169,     0,   170,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,     0,   499,   500,   173,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,   174,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,   178,   179,   515,   180,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,   182,   524,
     183,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,     0,   533,   534,     0,   535,   536,   537,   188,
     189,   190,   538,   539,   191,     0,   540,   541,   193,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,   197,   198,   199,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,   210,   586,   587,   212,   588,   589,   590,
     591,   592,   593,     0,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,   219,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,     0,   234,     0,   643,   235,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
      35,   653,   654,     0,    37,    38,    39,    40,    41,    42,
       0,    44,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,   133,   428,   429,   430,   135,   136,
     137,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,   140,   438,     0,   439,   440,   441,
     442,   144,     0,   145,     0,   443,   444,   445,   446,   148,
     447,     0,     0,   448,   449,   450,   451,   452,   453,     0,
     151,   454,     0,     0,     0,     0,   152,     0,     0,     0,
     455,   456,   457,   458,     0,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,   169,     0,   170,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,     0,
     499,  1990,   173,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,   174,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,   178,   179,   515,
     180,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,   182,   524,   183,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,   537,   188,   189,   190,   538,   539,   191,     0,   540,
     541,   193,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
     197,   198,   199,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,   210,   586,   587,   212,
     588,   589,   590,   591,   592,   593,     0,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,   219,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,     0,   234,     0,   643,
     235,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,    35,   653,   654,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,   133,   428,   429,
     430,   135,   136,   137,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,     0,   140,   438,     0,
     439,   440,   441,   442,   144,     0,   145,     0,   443,   444,
     445,   446,   148,   447,     0,     0,   448,   449,   450,   451,
     452,   453,     0,   151,   454,     0,     0,     0,     0,   152,
       0,     0,  2528,   455,   456,   457,   458,     0,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,   169,     0,
     170,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,     0,   499,   500,   173,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,   174,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
     178,   179,   515,   180,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,   182,   524,   183,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,     0,   533,
     534,     0,   535,   536,   537,   188,   189,   190,   538,   539,
     191,     0,   540,   541,   193,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,   197,   198,   199,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,   210,
     586,   587,   212,   588,   589,   590,   591,   592,   593,     0,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,   219,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,  2529,     0,   638,   639,   640,   641,   642,     0,
     234,     0,   643,   235,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,    35,   653,   654,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,   130,   131,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
     133,   428,   429,   430,   135,   136,   137,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,     0,
     140,   438,     0,   439,   440,   441,   442,   144,     0,   145,
       0,   443,   444,   445,   446,   148,   447,     0,     0,   448,
     449,   450,   451,   452,   453,     0,   151,   454,     0,     0,
       0,     0,   152,     0,     0,     0,   455,   456,   457,   458,
       0,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,   169,     0,   170,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,     0,   499,   500,   173,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,   174,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,   178,   179,   515,   180,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,   182,   524,   183,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,     0,   533,   534,     0,   535,   536,   537,   188,   189,
     190,   538,   539,   191,     0,   540,   541,   193,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,   197,   198,   199,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,   210,   586,   587,   212,   588,   589,   590,   591,
     592,   593,     0,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,   219,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,     0,   234,     0,   643,   235,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,    35,
     653,   654,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,   135,   136,   137,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,     0,   140,   438,     0,   439,   440,   441,   442,
     144,     0,   145,     0,   443,   444,   445,   446,   148,   447,
       0,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,     0,     0,     0,   152,     0,     0,     0,   455,
     456,   457,   458,     0,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,   169,     0,   170,   492,   493,   494,
       0,   495,   172,  3381,   496,     0,   497,   498,     0,   499,
     500,   173,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,   174,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
     182,   524,   183,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,     0,   533,   534,     0,   535,   536,
     537,   188,   189,   190,   538,   539,   191,     0,   540,   541,
     193,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,   197,
     198,   199,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,   212,   588,
     589,   590,   591,   592,   593,     0,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,   219,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,     0,   234,     0,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,    35,   653,   654,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,   133,   428,   429,   430,
     135,   136,   137,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,     0,   140,   438,     0,   439,
     440,   441,   442,   144,     0,   145,     0,   443,   444,   445,
     446,   148,   447,     0,     0,   448,   449,   450,   451,   452,
     453,     0,   151,   454,     0,     0,     0,     0,   152,     0,
       0,     0,   455,   456,   457,   458,     0,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,   169,     0,   170,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,     0,   499,   500,   173,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,   174,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,   178,
     179,   515,   180,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,   182,   524,   183,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,     0,   533,   534,
       0,   535,   536,   537,   188,   189,   190,   538,   539,   191,
       0,   540,   541,   193,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,   197,   198,   199,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,   210,   586,
     587,   212,   588,   589,   590,   591,   592,   593,     0,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,   219,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,     0,   234,
       0,   643,   235,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,    35,   653,   654,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,   133,
     428,   429,   430,   135,   136,   137,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,     0,   140,
     438,     0,   439,   440,   441,   442,   144,     0,   145,     0,
     443,   444,   445,   446,   148,   447,     0,     0,   448,   449,
     450,   451,   452,   453,     0,   151,   454,     0,     0,     0,
       0,   152,     0,     0,     0,   455,   456,   457,   458,     0,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
     169,     0,   170,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,     0,   499,   500,   173,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
     174,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,   178,   179,   515,   180,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,   182,   524,   183,     0,
     525,   526,   527,     0,     0,   528,   529,  1212,   531,   532,
       0,   533,   534,     0,   535,   536,   537,   188,   189,   190,
     538,   539,   191,     0,   540,   541,   193,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,   197,   198,   199,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,   210,   586,   587,   212,   588,   589,   590,   591,   592,
     593,     0,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,   219,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,     0,   234,     0,   643,   235,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,    35,   653,
     654,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,   133,   428,   429,   430,   135,   136,   137,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,     0,   140,   438,     0,   439,   440,   441,   442,   144,
       0,   145,     0,   443,   444,   445,   446,   148,   447,     0,
       0,   448,   449,   450,   451,   452,   453,     0,   151,   454,
       0,     0,     0,     0,   152,     0,     0,     0,   455,   456,
     457,   458,     0,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,   169,     0,   170,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,     0,   499,   500,
     173,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,   174,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,   178,   179,   515,   180,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,   182,
     524,   183,     0,   525,   526,   527,     0,     0,   528,   529,
    1286,   531,   532,     0,   533,   534,     0,   535,   536,   537,
     188,   189,   190,   538,   539,   191,     0,   540,   541,   193,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,   197,   198,
     199,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,   210,   586,   587,   212,   588,   589,
     590,   591,   592,   593,     0,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,   219,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,     0,   234,     0,   643,   235,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,    35,   653,   654,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,   133,   428,   429,   430,   135,
     136,   137,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,     0,   140,   438,     0,   439,   440,
     441,   442,   144,     0,   145,     0,   443,   444,   445,   446,
     148,   447,     0,     0,   448,   449,   450,   451,   452,   453,
       0,   151,   454,     0,     0,     0,     0,   152,     0,     0,
       0,   455,   456,   457,   458,     0,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,   169,     0,   170,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
       0,   499,  1322,   173,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,   174,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,   182,   524,   183,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,   537,   188,   189,   190,   538,   539,   191,     0,
     540,   541,   193,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,   197,   198,   199,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,   210,   586,   587,
     212,   588,   589,   590,   591,   592,   593,     0,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
     219,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,     0,   234,     0,
     643,   235,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,    35,   653,   654,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,   133,   428,
     429,   430,   135,   136,   137,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,     0,   140,   438,
       0,   439,   440,   441,   442,   144,     0,   145,     0,   443,
     444,   445,   446,   148,   447,     0,     0,   448,   449,   450,
     451,   452,   453,     0,   151,   454,     0,     0,     0,     0,
     152,     0,     0,     0,   455,   456,   457,   458,     0,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,   169,
       0,   170,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,     0,   499,  1331,   173,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,   174,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,   178,   179,   515,   180,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,   182,   524,   183,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,     0,
     533,   534,     0,   535,   536,   537,   188,   189,   190,   538,
     539,   191,     0,   540,   541,   193,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,   197,   198,   199,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
     210,   586,   587,   212,   588,   589,   590,   591,   592,   593,
       0,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,   219,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
       0,   234,     0,   643,   235,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,    35,   653,   654,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
       0,   140,   438,     0,   439,   440,   441,   442,   144,     0,
     145,     0,   443,   444,   445,   446,   148,   447,     0,     0,
     448,   449,   450,   451,   452,   453,     0,   151,   454,     0,
       0,     0,     0,   152,     0,     0,     0,   455,   456,   457,
     458,     0,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,   169,     0,   170,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,     0,   499,  1342,   173,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,   174,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,   178,   179,   515,   180,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,   182,   524,
     183,     0,   525,   526,   527,     0,     0,   528,   529,  1343,
     531,   532,     0,   533,   534,     0,   535,   536,   537,   188,
     189,   190,   538,   539,   191,     0,   540,   541,   193,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,   197,   198,   199,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,   210,   586,   587,   212,   588,   589,   590,
     591,   592,   593,     0,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,   219,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,     0,   234,     0,   643,   235,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
       0,   653,   654
};

static const yytype_int16 yycheck[] =
{
       2,   880,   359,    78,   117,   246,   209,  1368,    78,  1098,
      78,   917,  1093,   153,    78,  1045,  1325,    96,   840,   990,
     991,   992,  1329,   117,    78,   996,  1360,   106,  1321,  1163,
       2,   154,  1276,   150,  1398,  1873,  1201,  1205,  1704,  1223,
    2049,  1285,  1121,  1061,    78,  2753,   228,  1577,  1213,   162,
      84,   167,   223,   959,   933,  1889,  1258,   715,   880,  1743,
     165,  1738,  1417,   142,  1999,  1458,  1459,  1487,   162,   171,
    1430,   187,  1052,  1747,  1594,  1832,    78,  1743,   157,  1891,
     203,  2472,    84,  3066,  1477,  2202,   160,    89,  2564,   375,
     165,  3337,   375,    78,   132,  1914,  1756,  2910,  1263,  1929,
    3116,  1266,  3118,  3276,  1914,  1184,  1271,   209,  1914,  1914,
    1312,   933,  1914,  1278,  1914,   117,  1787,   230,   917,  1738,
    1598,  1795,  1287,  2431,  2432,  2252,  1204,  2519,    94,  1207,
    1633,  1634,  1635,  3571,  2733,  2087,   230,  1215,  3258,  1140,
    1800,  1801,  1048,  2968,  1140,   958,   716,   361,  2906,  2907,
    3841,   153,  3245,   347,  3666,  3858,   216,  1687,  1988,  3615,
     162,  3522,  3523,  3879,  3517,  3258,   132,  1691,   935,   167,
    2843,  1505,  2908,  1381,  1730,  1628,  1629,  1352,   945,  1361,
     361,  1938,  2296,  4092,  1931,  1447,  1448,   153,   154,   187,
    3622,  1090,  1213,  1179,  4289,  1090,  3455,   163,  1135,  1136,
      30,  3822,  3583,    88,   108,    10,   208,   135,  2599,   128,
     156,  1473,    72,    21,   216,   950,   218,    75,    76,    77,
      78,  2335,   143,    88,    82,  2339,  4428,  4552,   230,  3262,
    3263,  3264,  3265,  3266,  3267,   204,    95,   203,    84,   114,
     180,   222,   121,   822,   149,  2904,   173,   905,   113,  1048,
      72,   128,   228,    78,  4545,    75,    76,    77,    78,    14,
     128,    95,    82,   199,    86,   236,  3068,   114,   236,    75,
      76,    77,    78,   112,   145,    78,    82,  2668,   143,  2670,
      78,    84,    37,   322,    90,  1256,    72,   307,   324,  1368,
     145,   112,   367,   352,   380,    81,   222,   367,   153,   367,
      86,  2974,  2961,   367,   227,    75,    76,    77,    78,   182,
      99,   429,    82,   367,   117,   307,   173,    72,   109,  2153,
      75,    76,    77,    78,    78,   219,    81,    82,    83,    84,
      78,    86,    75,    76,    77,    78,   307,    99,   197,    82,
     182,   375,    72,  1361,   106,   429,    75,    76,    77,    78,
    4452,   227,   145,    82,   103,   104,    86,  3789,  3794,   162,
     180,    90,  1241,   197,   145,   135,   396,   185,    75,    76,
      77,    78,  1506,   375,  4476,    82,   410,  1561,   451,   227,
     153,  2390,   367,   128,  1042,    72,     8,   356,   506,    11,
      12,    95,   135,   229,    81,   179,  1530,   188,   227,    86,
      22,    23,    24,   192,    26,    27,   490,   227,   410,    31,
      32,    33,   306,    75,    76,    77,    78,   503,   227,  1241,
      82,   257,    75,    76,    77,    78,   372,   230,   187,    82,
     503,    25,   233,    75,    76,    77,    78,   473,   266,  1345,
      82,   314,  4537,   369,   503,   411,    75,    76,    77,    78,
     307,    99,   173,    82,   373,   247,  1876,    29,   106,  2573,
     173,    90,  1368,   455,   503,   485,   102,    75,    76,    77,
      78,  1864,  1865,  3275,    82,   505,  4097,   226,  1871,   228,
    1559,   173,    90,   623,   455,  1564,  1565,   455,    75,    76,
      77,    78,   419,   197,    25,    82,   373,    75,    76,    77,
      78,   160,   336,    90,    82,   373,  4797,  1525,    75,    76,
      77,    78,    38,  4533,    40,    82,    75,    76,    77,    78,
    2809,  2810,   503,    82,    99,  2814,  2046,   503,  1434,   465,
    2050,   106,  2052,   367,   503,  2055,   441,  1844,   824,  4741,
     117,   824,   367,    88,   667,   668,  1345,  1840,  1566,  1567,
     490,   173,    75,    76,    77,    78,    99,  1370,   429,    82,
     506,    88,   396,  1330,   410,  2854,  2855,  1137,  1138,   367,
    3690,  4896,   375,   232,   429,   503,  3609,   416,  1157,    93,
     501,   456,   429,   506,   505,   162,   113,   506,  2426,  4292,
     449,    75,    76,    77,    78,   416,   456,  3690,    82,   503,
    1862,  1863,   460,    75,    76,    77,    78,   410,  1870,   429,
      82,   453,  1856,   367,   499,  1350,   143,  2147,  1783,   367,
    1785,   623,   117,  2435,   503,  1793,   266,   173,   373,   506,
     506,   449,  3023,  1835,   499,  1434,   429,  1404,   506,  4260,
    1718,  1720,   404,   451,    88,   503,  1830,   431,   429,  1728,
    1556,   456,  1419,   230,  4086,   503,   429,   623,  1564,  1565,
     266,  3834,  2192,   367,  1431,  4018,  2196,   162,   262,  4022,
     490,   501,   494,   495,  4694,   846,  2040,   506,   506,   301,
    3853,   503,  3941,  1992,  4305,   505,   258,   471,  1853,   497,
    4071,   831,   451,  4788,   503,   209,  1775,   503,   419,  1778,
    1779,   667,   668,   410,   411,   506,   419,   820,   494,   495,
    1647,  4620,   461,   208,   506,   374,  1615,   460,   959,  3532,
    1615,   216,   180,   218,   346,    95,   820,   419,  2402,   319,
      88,   262,   872,   503,   370,   230,  1093,  2484,  2047,   494,
     495,  3217,  1260,   236,  3220,  3221,   382,  2056,  3224,   715,
    1771,  1737,  2086,  2087,  2431,  2439,   404,  1556,  3234,  4854,
     503,   173,  1841,  2097,   494,   495,   960,  2101,   469,   229,
    3803,  4387,   266,  4389,   503,  2109,  2110,  3085,    99,  3087,
     182,   227,   469,   309,   907,   209,   926,   861,  2122,  2123,
     824,  1361,  4228,  4229,  4230,  4231,  4232,   433,   160,  2133,
     343,  3537,  4423,   141,  2921,   506,   221,   494,   495,  4430,
     469,   451,     0,  2021,   307,   235,   438,   470,   820,  2027,
    2934,  1996,   824,  2005,   268,  2349,   828,   197,   470,   404,
    1001,  3222,  3223,  4853,   836,   837,   489,  4857,   955,   501,
     842,   503,    14,   505,  2297,   504,  2299,   489,   507,   851,
     503,  2113,  2114,   969,   959,   971,   314,   973,  3517,   151,
     227,   503,   137,   979,  2420,   867,   380,   507,   270,  1083,
     232,   192,   137,   419,   503,  4895,   878,   956,   153,   422,
     882,   424,   230,   958,   398,   174,  1002,  1003,  1767,   180,
      14,   893,   971,   151,   973,   503,  1067,   189,   227,  1417,
     506,   209,  1083,   266,   983,   336,  3889,   309,   151,   911,
     268,  2595,   145,   503,  3587,   917,   503,  4628,  4629,   921,
     153,   185,   382,  1002,  1003,   503,  1097,   173,   930,   931,
     345,   189,   207,   935,   180,   111,   503,  3245,   384,   905,
     185,   907,   207,   945,   503,  1767,   189,   197,   950,   224,
    3258,   496,   497,   498,   499,   357,   461,   959,   378,   224,
    3619,   250,   455,  2634,  1935,   396,   336,  2644,  1073,   496,
     497,   498,   499,   971,   398,   973,  4679,   437,   950,   266,
     503,   393,  4598,  2480,   322,  2003,  1046,   953,  4704,    72,
    1050,   957,    75,    76,    77,    78,   260,   367,    81,    82,
      83,    84,   175,    86,  1002,  1003,  1044,  1178,   128,   266,
    2144,   505,   374,  4374,   507,   260,   462,   820,   309,   503,
     151,   824,   227,  2053,  2054,  4378,   396,  3335,   329,   208,
    4383,   503,   266,  4386,  1068,   972,  2533,   100,  1040,   976,
     977,   978,   247,   391,  1046,   337,  1048,   180,  1050,   986,
     494,   495,   496,   497,   498,   499,     2,   323,   189,  4305,
     119,   266,   429,   309,   419,   319,  1068,   240,  4498,   248,
     246,   319,   420,  1075,  4506,   350,  1042,   327,  1044,   337,
      75,    76,    77,    78,   454,   350,  4789,    82,   451,   151,
     398,  2925,    72,  1972,   337,    75,    76,    77,    78,   184,
     429,    81,    82,  2009,   506,  4796,    86,   469,  4124,    71,
      72,  4822,   329,    75,    76,    77,    78,    79,    80,    81,
      82,   371,   429,   296,    86,   180,   299,   189,   309,   418,
     419,   423,    85,  1135,  1136,    88,   494,   495,   496,   497,
     498,   499,   504,    89,   389,   507,   396,   296,  3437,  1121,
    1972,  3440,  3441,  3442,  3443,  3444,  3445,  3446,  3447,  3448,
    3449,   490,  4618,   409,   451,   423,   412,  1685,  1140,   444,
     155,  4683,   436,   183,   355,   335,   505,  4798,   228,   444,
     423,    78,   267,   229,   243,   449,  1171,   307,   247,  2582,
     329,   185,   336,    14,   451,  2008,   230,  1964,   261,   506,
    4632,  2721,   103,   104,   449,   506,   337,   153,  1975,   194,
    3499,  3500,  1184,   159,   387,   184,    37,   451,   180,  2237,
    1987,    85,  1296,   367,    88,   284,  1228,  4040,  1213,  4659,
     227,    25,   206,   273,   244,  2314,  1238,  4050,   387,   185,
    2119,    35,  4595,   820,  4069,    85,   451,  1765,    88,   503,
     247,    72,   149,   373,   309,   503,   389,   503,  1260,   160,
      75,    76,    77,    78,  1505,  1068,   260,    82,   165,   266,
    3082,  2515,    99,  4031,  3750,   337,   396,  3089,   179,   325,
    3756,  3757,  3758,  3759,  3760,  3761,   419,   504,   338,   506,
     264,  1293,   423,   382,  1373,  1370,  1375,  2119,   267,  1378,
    4036,  1380,   507,   265,  1383,  1384,  1385,  4745,  4746,   210,
     183,   484,  4048,   431,    97,   268,  4748,  1396,  1836,   314,
     147,  4431,     5,  3922,   457,   820,   288,   154,  1330,   384,
    1409,   160,  1411,  2334,   117,  4455,   469,  1855,  2334,   121,
     134,   400,    25,  1345,   433,   380,  4519,  1349,  1350,   246,
    1352,   401,    35,   471,   181,   329,  2665,   391,  1360,  4018,
    2438,   423,  4455,  4022,  2671,   504,  1368,   506,  2661,  3378,
     503,   244,   325,  2617,  2618,  2619,  2620,  1349,  1350,   192,
    1352,   194,  3690,  1901,    88,  2629,   420,  1601,  1602,   171,
    1604,  1677,  4824,  1587,  1677,    81,  1368,   121,    22,   336,
      86,  4511,  1404,   232,   268,   439,  2484,  3084,  2487,   113,
     175,   494,   495,   185,   449,  1417,  2495,  1419,  2497,   268,
    1601,  1602,    72,  1604,   251,   197,   175,  2505,   268,  1431,
     367,   229,  1434,   431,  1371,  2005,    86,  1374,  4876,   143,
    1377,  1959,  1379,  1445,  2778,  1382,  1617,   171,    72,  1386,
    1416,   134,   240,  2655,   451,   449,  2534,  2935,  3410,   396,
    3852,   325,  1575,   172,   361,  3084,   323,  3594,   262,   443,
     367,   503,  1474,  3292,   323,   240,   296,   259,   261,   299,
     160,  1575,  3292,  4915,   369,   325,  3292,  3292,   389,  3160,
    3292,   240,  3292,  2827,   129,  3169,   309,  4670,  3018,   179,
    1502,  1503,   137,  1505,  1542,  1543,   319,  3898,   296,  3900,
     507,  4621,  2391,   196,  1627,   495,  1518,   332,   419,   507,
    1522,  4631,    95,   398,  2858,   307,  3815,   325,   101,   367,
     210,   296,   494,   495,  3364,   259,   501,   490,   491,   492,
     505,   494,   495,   496,   497,   498,   499,   296,   137,   247,
     299,  1046,  4798,   507,  1556,  1050,   457,  1559,   396,  2893,
     461,  4867,  1564,  1565,   268,   349,   503,   387,   469,  2391,
    4553,   231,  1574,  1575,   449,   347,  1542,  1543,  1691,   262,
     172,  4394,  4395,   307,   469,   412,   295,  1559,   297,   153,
     390,   180,  1564,  1565,  1628,  1629,   192,  1691,   194,   387,
     506,  1603,   503,   385,    71,  1607,  1608,  1645,    75,    76,
      77,    78,    79,    80,   412,    82,   180,  4325,   218,   419,
    4636,   506,   387,  1794,   197,  1627,  1628,  1629,   288,  4935,
     494,   495,   496,   497,   498,   499,   349,  2155,   387,   218,
     357,  1715,   182,  1677,   501,  1647,  2725,   431,   505,   451,
    1684,   491,   492,   288,   494,   495,   496,   497,   498,   499,
     252,   385,  3322,   463,  3028,  3325,    95,  1639,   227,   367,
    2437,  2329,   101,   371,   107,  1677,   162,   623,   501,  1645,
      95,   398,  1684,  1685,   507,   285,   101,   471,   247,  1691,
     175,   451,  1664,  1665,   227,   509,  1698,  3090,   396,  3988,
    3989,   503,   390,   295,   378,   297,   285,   266,   175,   389,
    4418,   152,  4420,   192,   247,   194,  4107,  4108,   431,  4378,
     309,  4197,  4198,   319,  4383,   314,  4709,  4386,  1730,    88,
     270,   419,   449,   266,   182,   484,  1738,   216,   183,   419,
      41,  2647,   321,   503,   230,   309,  3053,   180,  1720,  3252,
      75,    76,    77,    78,   503,   240,  1728,    82,   471,   367,
     201,   350,   422,  1765,   424,  4424,   262,   336,   197,   309,
     327,   469,  1575,   240,   363,   463,   450,   457,  2684,   336,
     371,   329,   197,  1896,   143,   470,  1771,   447,   396,   469,
     494,   495,   496,   497,   498,   499,    88,  4610,   367,   244,
     128,   182,  1896,  1775,   489,   396,  1778,  1779,   502,   451,
     367,   296,   506,  1815,   299,  1817,   421,   357,   503,   147,
    1960,   113,   270,   503,  1627,  1628,  1629,   396,   182,   296,
     309,  3643,   299,   161,  1836,   314,   277,   278,   386,   228,
     319,  3043,    75,    76,    77,    78,   382,  2926,  2647,    82,
     291,   143,   382,  1855,    16,   444,  3376,   352,   336,   236,
     126,   309,    88,   403,   469,   470,  3623,   256,   222,  1841,
     386,  1873,    85,   254,  1677,    88,  2079,    75,    76,    77,
      78,  1684,   271,   211,    82,  2684,  4545,   113,  1691,   367,
     356,  2062,   451,   282,  1896,   336,   380,   433,   503,  1901,
     254,  3069,   387,   433,  2009,   462,   172,   336,   192,   357,
     194,  1913,   470,    71,    72,   381,   862,   143,   451,   115,
     387,   336,  2952,   357,   408,  2443,   307,  1929,   309,  3097,
     307,   489,   216,  2008,   368,  4052,  4595,  3301,   367,  2018,
     136,  2020,   469,  2923,   318,  2024,  3432,  2026,   507,  3479,
    2029,  1953,   367,   307,  2033,   309,   435,  1959,   392,   336,
    1962,  2247,  1964,  1965,  2247,  3799,   445,   396,   222,   490,
    3456,   917,   918,  1975,   507,   206,  2078,  3651,   232,   506,
     421,   396,   423,   249,   505,  1987,  1988,   218,   377,   314,
     367,   222,  3070,   247,  1996,  2070,  2875,  1999,  1575,   484,
    2070,   469,  2070,  4479,   950,    14,  2070,  2009,  3668,  3669,
     274,  2085,    75,    76,    77,    78,  2070,   484,   503,    82,
    2926,   501,    34,   503,  1996,   505,   470,  1999,    37,   295,
     314,   297,   227,   264,   247,   319,   336,  3397,   506,  3459,
    3460,   307,   268,   269,  2157,   489,   222,  2049,  4337,   422,
    2708,   424,   247,  2875,   285,   268,  2574,   490,    51,   503,
    1006,   958,   959,  2157,   429,  3595,   242,   367,   501,   335,
     503,   504,   505,   506,  4363,  4364,    69,   208,   455,   218,
    1575,   314,   503,   222,  2086,  2087,   312,   218,  1034,    97,
     321,   320,  2094,  1896,   323,  2097,   396,  1043,   329,  2101,
      85,  1047,  1048,  1049,  2106,  3270,   372,  2109,  2110,   117,
    3403,   161,   325,  4821,  1691,  2117,   314,   433,  2120,  2121,
    2122,  2123,   376,   222,  2946,  4516,   506,   507,  2130,  2131,
     389,  2133,  3466,  2135,  2136,  3041,   506,  2139,  4797,  4074,
     510,   407,  3497,   242,  2249,  3983,   285,  4455,   369,  3833,
    2266,   435,  3986,  2155,  2156,  2157,  2359,   157,  2361,  2161,
     419,   445,   231,  2165,   218,  1912,   336,  2169,   222,  2171,
    2172,  2173,  2174,  2175,  2176,  2177,  2178,  2179,   228,  2181,
     506,   386,   321,  1930,   510,  2187,  1083,   336,  2190,  1135,
    1136,  3857,   336,   336,  1140,  3872,  1691,   367,   457,  3401,
     323,   828,   250,  1698,   384,   328,   256,   389,    71,   836,
     153,   274,   443,  2247,  2354,    85,    79,    80,   367,   288,
     501,   271,   371,   367,   367,  2743,   396,   508,   371,   508,
    2401,   285,   282,   323,  2288,  1730,  2349,   419,   328,  4547,
     867,   421,  3041,   504,   503,  2247,   507,   396,  3015,  3016,
    2252,    72,   396,   396,   304,  2349,  3620,  3621,   502,   134,
     135,   504,   506,  2297,   507,  2299,  3659,   321,   494,   495,
     496,   497,   498,   499,    89,   457,   242,   490,   491,   492,
    4569,   494,   495,   496,   497,   498,   499,   469,   231,   469,
     470,    71,    72,   150,   921,  2297,     7,  2299,   125,    79,
      80,    85,  2137,   930,    88,  2140,    86,   250,    19,    20,
    3769,  1257,  3771,   469,   470,  3774,  2318,  3776,   386,  1896,
    3291,   503,  1817,   503,   384,  3404,   469,   377,    39,   113,
     274,    42,   498,    86,  2336,   119,  2338,   503,  2478,   505,
     325,   509,  2314,  2345,   503,   288,  2459,  2349,  2350,  2462,
     503,  2353,   167,   422,  2157,   424,   422,    85,   424,   143,
      88,   421,  2334,  2329,  2336,  3271,  2338,  3273,  2462,   496,
     497,   498,   187,  2375,   498,  3559,  2378,   105,   447,   503,
      85,   505,  2384,    88,  3151,   328,   310,   311,  2390,  3909,
    3910,  3911,  3526,   323,   463,    75,    76,    77,    78,  1345,
     105,  1896,    82,  1349,  1350,  3766,  1352,  2409,   506,   469,
     470,   311,    75,    76,    77,    78,   380,   381,  2420,    82,
     270,   205,  1368,  3245,  2426,   506,   507,   367,  3334,  2431,
    2432,   371,   380,   381,  2436,  2437,  3258,  4326,  4327,  4328,
    4329,  2443,   125,   503,  2247,   156,   469,   470,  3529,  3530,
     115,   494,   495,   496,   497,   498,   396,  2459,  2460,   243,
    2462,   504,    71,   247,   486,   389,   384,  1413,   487,   488,
      79,    80,  3271,  1370,  3273,   469,   470,  2479,  2480,   422,
    2482,   424,   193,   326,   268,   269,  2603,  4496,  1434,   389,
     433,   504,   326,   506,  2297,   419,  2299,   501,  2500,   503,
     284,   444,  4032,   421,   447,   490,   491,   492,  2510,   494,
     495,   496,   497,   498,   499,  2487,  3283,   180,  3285,   419,
     504,  2523,   506,  2495,   505,  2497,  3044,   323,   312,   469,
    2532,  2533,   504,   457,   506,  3334,  4066,  1421,  1422,   384,
     268,   325,   429,   152,  1441,   469,  2349,   323,   503,   384,
     505,   469,   470,  2953,  2954,   384,  2913,   457,   504,   486,
     506,  1507,   222,   268,  1461,  2826,   326,  2828,  2829,   469,
    2572,  1517,  2574,  4407,   486,  3743,   421,   115,   384,   503,
    2157,  1527,   504,   270,   506,   503,   421,   504,   504,   506,
     506,   496,   421,   202,  1491,  2597,   504,   325,   506,  2601,
     504,  1228,   506,   503,   504,   226,   503,   507,  1505,   384,
    1556,  1238,   506,  1559,  1560,   421,   400,  2858,  1564,  1565,
     325,  3139,   504,  3141,   469,   470,   504,  4304,   506,  3396,
    2632,   504,   504,   506,   469,   470,  3970,  3881,   125,  3994,
     469,   470,  2644,   252,   227,  2647,   421,   266,   507,  4169,
    4170,   504,  4172,   506,   496,   503,  2459,   505,   503,  2462,
     509,   262,  2157,   469,   470,   504,  1293,   506,   503,   509,
     203,   504,  1608,   506,   503,  1087,  3194,  1089,    75,    76,
      77,    78,  2684,   429,   504,    82,   506,  3766,   429,    86,
    2692,   504,   429,   506,   469,   470,    85,   503,   429,    88,
    3218,  1647,   503,   108,  1601,  1602,   504,  1604,   506,   429,
     494,   495,   496,   497,   498,   499,  2898,  2899,  2900,   125,
     422,  2834,   424,  2964,   113,   262,   268,  2840,   503,  2731,
     119,   504,   341,   506,   503,   494,   495,   496,   497,   498,
    2834,  2743,  2708,   502,   429,   396,  2840,   504,   504,   506,
     506,  2753,   503,  2725,   143,  2757,   504,   504,   506,   506,
    2762,   505,   490,   491,   492,   472,   494,   495,   496,   497,
     498,   499,  2349,   422,   211,   424,  2778,  2779,   504,   504,
     506,   506,  2784,   180,   503,   490,   491,   492,   505,   494,
     495,   496,   497,   498,   499,    75,    76,    77,    78,   161,
     211,   211,    82,  3321,   323,   222,     2,  2809,  2810,   504,
     211,   506,  2814,   507,    75,    76,    77,    78,   504,    85,
     506,    82,    88,   283,  2826,  2827,  2828,  2829,   182,   504,
    3348,   506,  2834,   442,   504,  3914,   506,  2839,  2840,   105,
    2842,   450,  2844,   451,   453,  1791,   504,   504,   506,   506,
    4211,   323,  2854,  2855,  2349,  4219,  2858,   504,   247,   506,
    3766,   504,   504,   506,   506,  4531,   228,  2942,  3690,  2871,
     503,  2873,  2942,   318,  2942,  2877,   386,   503,  2942,   268,
     269,   504,  2459,   506,   504,  2462,   506,   504,  2942,   506,
     504,  2893,   506,   504,   256,   506,   274,   504,  3416,   506,
     180,   504,  2904,   506,  2906,  2907,  2908,   137,   469,   271,
      75,    76,    77,    78,   504,   108,   506,    82,  3436,   180,
     282,   309,   472,   312,  2926,  2420,   503,   121,  2930,   115,
      75,    76,    77,    78,   115,   438,   325,    82,    95,   222,
     336,  2943,   304,  3461,   101,   504,  2948,   506,    75,    76,
      77,    78,   150,  2955,  2926,    82,   508,   211,  4092,  2961,
     504,   323,   506,   504,  2459,   506,   353,  2462,   162,  1915,
     504,   167,   506,    75,    76,    77,    78,   211,   503,  3497,
      82,   504,   211,   506,   141,   211,  4341,    75,    76,    77,
      78,   187,   186,   504,    82,   506,   472,   504,  3000,   506,
     211,   506,   268,  3116,  3117,  3118,   504,   201,   506,   211,
     504,   205,   506,  3015,  3016,   377,   504,   323,   506,  3021,
     504,   504,   506,   506,   504,   504,   506,   506,  4705,   223,
     504,  2834,   506,   190,   504,   211,   506,  2840,   211,  3041,
     197,  4206,  3044,   200,   238,   504,   504,   506,   506,  4067,
    1996,   211,   504,  1999,   506,   211,   504,  4391,   506,   325,
     504,  4023,   506,  4025,   211,   323,   419,   211,  4588,  3836,
    3837,   211,   503,   108,   223,   283,   222,   323,  4598,   222,
     503,   503,  3084,  3085,   503,  3087,   222,   503,   503,   451,
     346,   503,   333,   506,   503,   252,   503,   108,   163,   503,
     503,   503,   266,   503,   503,   494,   495,   496,   497,   498,
     499,  2008,   503,   503,  3116,  3117,  3118,   503,   503,   503,
     314,   503,   503,   503,   503,   283,  4490,  3240,   322,   503,
     503,  4651,   503,  3135,   503,   503,   268,  3139,   108,  3141,
    3142,   222,   321,   222,  3257,   396,  3240,   496,   262,  3151,
     307,   387,   309,   179,   969,   506,   971,   299,   973,   450,
    2106,   355,   319,  3257,   979,   506,   490,    14,   506,   503,
     327,   503,   503,  2070,   429,   384,   429,   505,  4057,   336,
     429,   429,   429,   384,   429,  2121,   429,  1002,  1003,   153,
     211,   388,  3194,   206,   384,   323,   280,   429,   429,  2135,
     450,   314,   429,  3343,   145,   218,  4726,   323,   252,   222,
    3212,   319,   429,   503,   371,  4570,  3218,   429,   503,   153,
     506,   336,   174,  3346,   490,   491,   492,   451,   494,   495,
     496,   497,   498,   499,   429,  4057,   451,    71,  3240,   396,
    4574,    85,  3244,  3245,    88,    79,    80,   429,   125,   429,
     125,   264,   429,   327,   429,  3257,  3258,  2834,  3312,   429,
     429,   105,    96,  2840,   114,  2162,  3507,   429,   114,  3271,
     429,  3273,   285,  3245,  2220,   384,  3517,   429,   506,   429,
     323,  3283,   323,  3285,  4639,   472,  3258,   268,  4643,  4644,
    4261,   469,  3346,   503,   460,   108,  4657,   454,   503,   503,
     107,    97,   211,   309,   503,  4211,  1121,   180,   321,   463,
     451,   462,   291,  3116,  3117,  3118,   329,   319,   152,  3321,
    1135,  1136,  3840,   309,  4413,  1140,  1953,  3509,  3510,  3511,
    3512,   108,  3334,  3335,  4641,  1962,   222,   108,  4647,  2834,
    4649,   274,  2121,   385,   505,  2840,  3348,  4640,   503,   211,
     211,   451,   211,   451,   211,   211,  2135,    14,   506,  3472,
     318,   429,  3364,   313,   227,   503,   465,   427,   202,  1184,
     503,   301,  2318,   301,   486,    88,  3378,   506,  3472,  3381,
    3346,   396,   427,   137,   503,   503,   227,   490,  2334,   143,
    2336,  2288,  2338,   429,  3396,   506,   506,  3399,   431,   153,
     504,  4735,   241,   241,   264,  2184,   503,   324,   319,   504,
     506,  3413,   506,   247,  3416,   504,    10,   451,   252,    34,
     429,  3423,  2049,   384,   268,   429,   180,  3429,   182,  3431,
     443,   504,  3404,   152,  3436,  3437,   384,  3240,  3440,  3441,
    3442,  3443,  3444,  3445,  3446,  3447,  3448,  3449,   503,   272,
     451,  3453,  3454,   272,  3257,   429,   314,   503,   274,  3461,
     314,   127,   386,   314,  3466,   115,   403,   429,  3470,  2415,
    3472,   323,  3474,   322,   506,   330,  3994,   384,   429,   367,
      98,   325,  3484,   393,   429,  3487,   429,  3489,   501,   357,
     268,   504,   505,   159,   108,  3497,  3498,  3499,  3500,   268,
     254,   268,  3504,   268,   451,  3507,  4536,   341,   268,   451,
     322,   503,   490,   501,   107,  3517,   501,   429,   490,   211,
     222,   429,   393,   224,   319,  3527,   503,   145,  4609,   393,
     211,   210,   323,  3535,   469,  3537,   323,   497,   222,  3116,
    3117,  3118,   239,   239,   378,   108,  4425,   211,   214,   323,
     323,   393,   222,  1368,   247,   309,   174,   247,   247,   472,
     314,    96,   506,   298,   233,   323,   506,   506,   506,   125,
     318,   419,  3685,   504,  2520,   274,  3689,   195,  3691,   245,
    3582,  4460,   504,   417,   504,   227,  3588,  4105,  4881,   504,
    3706,   486,  3594,   340,   227,  3689,   350,  3691,   504,   504,
     504,   504,   504,  4425,   504,   506,   224,   504,   442,   363,
    2556,   229,   504,   504,   280,  4133,   450,  3619,  2564,   453,
     504,  3116,  3117,  3118,   504,   503,   429,  4145,    85,   503,
     466,    88,   504,  4455,   332,    90,    90,   466,  4460,   457,
     374,   486,   507,   309,  3646,   285,   490,   491,   492,   323,
     494,   495,   496,   497,   498,   499,   113,   275,   490,   490,
     323,   504,   119,  3240,   326,   250,   506,   504,   503,  3472,
    2616,  4189,   211,   506,   429,   503,   429,   429,   472,   258,
    3257,   327,   314,  3685,   429,   211,   143,  3689,  3690,  3691,
     444,   211,   341,   285,   341,  2641,   429,   448,   429,   429,
     429,  2647,   293,   293,   293,   371,   429,   373,   384,   375,
     396,   429,   429,   384,   429,   381,   384,   429,  3690,   384,
     429,  3723,   388,   211,  3726,   429,   114,   268,   268,   429,
     396,   268,   268,   501,   268,   353,   268,   268,  2684,   405,
     504,   299,   504,   285,  1559,  3240,   490,   413,   205,  1564,
    1565,  4657,   369,   438,   950,   173,   506,  2384,   504,   323,
     378,   503,  3257,  2390,  3766,   504,   384,   322,    85,   506,
     108,    88,   390,   969,   429,   971,  4747,   973,   236,   451,
     222,   384,   384,   979,   980,   981,   243,   384,   326,   209,
     247,   451,   506,   209,  3766,   268,   113,   203,   464,   227,
      88,   419,   119,   421,   462,   222,  1002,  1003,   135,   504,
    3782,   268,   269,  3815,  3868,   227,   504,   504,   501,   324,
     438,   235,   504,  4341,   504,   503,   143,   284,   503,   506,
     222,   504,  1647,   108,  3836,  3837,   490,   504,  3840,   490,
     451,   451,   429,   504,   222,   463,   429,   506,   504,   258,
     503,   503,   438,   429,  3908,   312,   438,   384,   429,   429,
     384,   504,   143,   504,  4743,   504,   173,   504,   325,   438,
    3872,  3873,  3874,  2809,  2810,   268,   502,   268,  2814,   503,
     222,  4084,  3685,   272,   472,   469,  3689,   506,  3691,   469,
     506,   504,   253,   148,   506,  3472,   421,   503,    85,   429,
     504,   393,   232,   227,   268,  1720,   268,   227,   268,   268,
     362,   125,   331,  1728,   467,  3917,   467,   271,  2854,  2855,
     271,  4743,   125,   504,   237,  1121,   243,   504,   503,   503,
     247,  3933,   504,   506,   319,   429,   504,   503,   490,   504,
     227,   469,  3914,   400,  1140,   504,   143,   252,   438,   314,
     429,   268,   269,   211,   268,   187,   314,   490,   506,   506,
    1775,  2858,  4078,  1778,  1779,   314,   229,   284,  3970,   451,
     227,   393,   108,    98,   451,  2872,   198,  3472,  3980,  3981,
    2926,  3983,   465,   502,   469,   503,  3988,  3989,  1184,   469,
     227,  3993,  3994,   503,  2891,   312,   255,  3999,  4000,   227,
     326,  4003,   503,   503,   406,   362,   131,  2904,   325,   456,
    4064,  4124,   468,   504,  4130,   504,  4018,   503,   271,   144,
    4022,   339,   503,   323,   363,   429,  1841,   222,   504,  4031,
    2809,  2810,   157,  4390,  4036,  2814,   504,   494,   495,   496,
     497,   498,   499,   504,   503,  2942,  4048,   108,   469,   314,
     503,   294,  4570,   503,   250,   210,   504,   173,   327,   381,
     381,   490,   125,   503,  2961,   125,   503,  2964,   329,   451,
     195,   307,  4074,   323,   421,  2854,  2855,   217,   354,   137,
    4052,   326,  4600,   400,   137,  4087,   193,   455,    85,   362,
     456,   506,   108,   227,   466,  3041,  4209,   198,   360,   224,
     222,   252,  4074,  4105,   229,   323,   469,   323,  3685,   108,
     504,   326,  3689,   326,  3691,  4209,   503,   503,   125,   185,
    4236,  4639,  4124,   504,   380,  4643,  4644,   503,   380,    94,
    2757,  4133,   105,   449,   210,  2762,   503,   354,  4140,  1818,
     367,  1181,  2602,  4145,  1565,  2926,  2469,  3097,  3689,  2527,
    4152,  3239,  4482,  1349,  1350,  4657,  1352,  4209,  4280,  4525,
    4531,  3861,  4254,  4535,  3022,  4828,  2713,  4424,  4880,  4780,
    4779,  4843,  1368,   490,   491,   492,  3122,   494,   495,   496,
     497,   498,   499,  4680,  3026,  4281,  2593,  4189,  3826,  2593,
    3685,  3117,  1916,  3685,  3689,  2588,  3691,  3831,  3833,  3303,
     325,  4885,  4948,  3149,  4940,  3257,  3244,  4209,  4850,  4211,
    4462,  1908,    85,  4758,  4836,    88,  4465,   187,  3917,  4617,
    1405,  3870,  2432,  4705,   918,  3872,  3196,  4862,   353,  4942,
    4672,  2249,   105,  2250,  2942,  1062,  3855,  2009,  4065,  3592,
     113,  1363,  2696,  1593,  2943,    78,   119,  1077,  2286,  1610,
    4252,    84,  1611,  2955,  2949,  2285,    89,  1613,  2269,   384,
    2961,  3517,  2969,  4024,  4596,   390,  1067,  3593,   393,  1617,
     143,  3217,  3482,  4572,  3220,  3221,  3474,  2904,  3224,  4815,
    4819,  4816,  2946,  2780,   117,  2872,  2870,   623,  3234,  3588,
    3343,  2187,  1300,  3239,   419,  2648,  4806,  1947,  2318,  3245,
     425,   376,  4304,  1629,   952,  3251,  1623,  2294,  2334,  1416,
    2326,  2920,  3258,   438,  1138,  3599,  1138,  2327,  4051,  3600,
    1539,  4124,  3564,  4325,  1627,  3271,   409,  3273,  2038,   162,
    4409,  2338,  1158,  2709,  2961,  4337,     2,  1349,   463,  4341,
      -1,    -1,    -1,    -1,  4346,    -1,   982,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3304,    -1,
      -1,  4363,  4364,  1559,    -1,  4367,    -1,    -1,  1564,  1565,
     243,    -1,    -1,    -1,   247,   208,  4378,    -1,    -1,    -1,
      -1,  4383,    -1,   216,  4386,   218,    -1,  3333,  3334,  4391,
    4392,    -1,    -1,    -1,    -1,   268,   269,   230,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4209,    -1,    -1,    -1,
      -1,   284,    -1,    -1,   108,  3312,  4418,    -1,  4420,    -1,
      -1,    -1,  4424,    -1,    -1,    -1,    -1,    89,    -1,    -1,
    4402,    -1,    -1,   127,    -1,    -1,   309,    -1,    -1,   312,
      -1,  1637,    -1,  1639,    -1,    -1,    -1,    -1,    -1,  3346,
      -1,  2266,   325,  4455,    -1,   328,    -1,  4459,    -1,    -1,
      -1,  1657,    -1,  4517,    -1,   159,    -1,    -1,  1664,  1665,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4455,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4496,    -1,    -1,    -1,    -1,  2314,
      -1,  3437,    -1,  2318,  3440,  3441,  3442,  3443,  3444,  3445,
    3446,  3447,  3448,  3449,    -1,    -1,    -1,    -1,    -1,  2334,
     214,    -1,    -1,  4636,  1720,    -1,    -1,   400,    -1,    -1,
      -1,    -1,  1728,    -1,  3470,    -1,    -1,  3483,    -1,    -1,
      -1,    -1,   375,  4545,    -1,  4547,    -1,  4124,    -1,    -1,
      -1,   245,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3499,  3500,    -1,    -1,  4569,  4570,    -1,
    4572,    -1,  4574,    -1,    -1,    -1,    -1,   410,    -1,  1775,
     274,    -1,  1778,  1779,    -1,    -1,   280,    -1,    -1,  4591,
    3536,    -1,    -1,  4595,    -1,    -1,    -1,    -1,  4600,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3507,    -1,    -1,    -1,    -1,   309,    -1,   490,   491,   492,
    3517,   494,   495,   496,   497,   498,   499,    -1,    -1,  4124,
      -1,    -1,  4209,   506,  4636,    -1,    -1,  4639,    -1,    -1,
      -1,  4643,  4644,    -1,    -1,  1841,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4657,    -1,  4898,  3437,    -1,
      -1,  3440,  3441,  3442,  3443,  3444,  3445,  3446,  3447,  3448,
    3449,    -1,  2487,    -1,    -1,  4677,    -1,   371,    -1,    -1,
    2495,   375,  2497,    -1,    -1,    -1,    -1,   381,    -1,    -1,
      -1,  3470,    -1,    -1,   388,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   396,  4705,    -1,    -1,    -1,    -1,    -1,    -1,
    4712,   405,    -1,    -1,  4209,    -1,    -1,    -1,    -1,   413,
    3499,  3500,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4735,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3690,    -1,    -1,    -1,    -1,  1945,
    4752,  3378,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3707,    -1,    -1,  3710,    -1,  3712,    -1,    -1,    -1,
     464,    -1,    -1,    -1,   468,   469,    -1,    -1,    -1,    -1,
    4893,    -1,    -1,    -1,    -1,  4787,    -1,  4862,    -1,    -1,
    3736,  3737,  4862,    -1,  4862,  4797,    -1,    -1,  4862,  4893,
    1996,    -1,    -1,  1999,  3750,    -1,    -1,    -1,  4862,    -1,
    3756,  3757,  3758,  3759,  3760,  3761,  4818,  4819,    -1,  4821,
    3766,    -1,    -1,  4898,  3770,    -1,    -1,  4940,  4898,  4831,
    4898,    -1,    -1,  4636,  4898,  4948,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4898,    -1,  4940,    -1,  3794,    -1,
      -1,    -1,    -1,    -1,  4948,    -1,    -1,    -1,    -1,  3805,
    3806,  3807,  3808,    -1,    -1,  4867,    -1,  4942,    -1,    -1,
      -1,    -1,  4942,    -1,  4942,  4877,    -1,    -1,  4942,  3815,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4942,    -1,
    3517,  4893,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2099,  2100,    -1,    -1,    -1,    -1,    -1,
    2725,  2107,    -1,    -1,    -1,  2111,  2112,    -1,    -1,    -1,
      -1,  4893,    -1,  3869,    -1,    -1,    -1,    -1,    -1,    -1,
    2126,    -1,  2128,  4935,    -1,    -1,    -1,    -1,  4940,    -1,
      -1,    -1,  4944,    -1,    -1,    -1,  4948,    -1,    -1,    78,
     127,    -1,    -1,    -1,  2150,    84,  2152,    -1,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4940,    -1,
      -1,  3868,    -1,    -1,    -1,    -1,  4948,    -1,    -1,    -1,
      -1,    -1,   159,    -1,  3930,    -1,    -1,   820,   117,    -1,
      -1,   824,  3619,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   837,    -1,  2202,    -1,    -1,   842,
      -1,  3908,    -1,    -1,    -1,    -1,    -1,    -1,   851,    -1,
      -1,    -1,    -1,    85,    -1,    -1,    88,    -1,    -1,    -1,
      -1,    -1,    -1,   162,    -1,    -1,  3815,   214,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   878,    -1,    -1,    -1,   882,
      -1,   113,  3988,  3989,    -1,    -1,    -1,   119,    -1,  4636,
     893,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   245,    -1,
    2266,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   143,    -1,    -1,   917,    -1,    -1,    -1,    -1,    -1,
    4893,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   931,    -1,
      -1,   230,   935,   280,    -1,    -1,  4052,  4053,    -1,    -1,
      -1,  2926,   945,    -1,    -1,    -1,    -1,    -1,  2314,    -1,
      -1,  4018,    -1,    -1,    -1,  4022,   959,    -1,  4074,    -1,
      -1,    -1,   309,    -1,    -1,    -1,    -1,  4940,  2334,    -1,
    2336,  4636,  2338,   205,    -1,  4948,    -1,    -1,    -1,    71,
      -1,   108,    -1,    -1,    -1,    -1,    -1,    79,    80,   336,
      -1,    -1,    -1,    85,    -1,    -1,    88,  4064,    -1,    -1,
     127,    -1,    -1,    -1,    -1,   837,    -1,    -1,    -1,    -1,
     842,   243,    -1,   105,    -1,   247,   108,    -1,    -1,   851,
     367,   113,    -1,    -1,   371,    -1,    -1,   119,   375,    -1,
      -1,    -1,   159,    -1,   381,    -1,   268,   269,    -1,  3988,
    3989,   388,    -1,  1046,    -1,  1048,   878,  1050,    -1,   396,
     882,   143,   284,    -1,    -1,    -1,    -1,    -1,   405,    -1,
      -1,   893,    -1,    -1,    -1,  1068,   413,    -1,    -1,    -1,
      -1,    -1,    85,    -1,    -1,    88,   375,    -1,    -1,    -1,
     312,  4197,  4198,    -1,    -1,    -1,    -1,   214,    -1,    -1,
      -1,    -1,   105,   325,    -1,  4211,    -1,    -1,    -1,  4215,
     113,  4217,    -1,    -1,  4220,  4221,   119,    -1,    -1,    -1,
      -1,   410,  4228,  4229,  4230,  4231,  4232,   464,   245,    -1,
      -1,  2487,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2495,
     143,  2497,  1135,  1136,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4893,   274,    -1,    -1,
      -1,   243,    -1,   280,    -1,   247,    -1,    -1,    -1,    -1,
    4276,    -1,    -1,    -1,    -1,    -1,    89,    -1,   400,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   268,   269,    -1,    -1,
      -1,    -1,   309,    -1,    -1,    -1,    -1,  4303,    -1,    -1,
      -1,    -1,   284,  4940,   117,    -1,    -1,    -1,    -1,    -1,
      -1,  4948,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4326,  4327,  4328,  4329,  2580,    -1,    -1,   309,    -1,    -1,
     312,  4018,    -1,    -1,    -1,  4022,    -1,    -1,  4893,    -1,
     243,  4337,    -1,   325,   247,    -1,   328,    -1,    -1,   162,
    4346,    -1,    -1,    -1,   371,    -1,    -1,    -1,   375,    -1,
      -1,    -1,    -1,    -1,   381,   268,   269,  4363,  4364,    -1,
    3245,   388,   494,   495,   496,   497,   498,   499,    -1,   396,
      -1,   284,    -1,  3258,    -1,  4940,    -1,    -1,   405,    -1,
      -1,    -1,    -1,  4948,    -1,   208,   413,    -1,    -1,    -1,
      -1,    -1,    -1,   216,    -1,   218,   309,    -1,    -1,   312,
      -1,    -1,    -1,  1135,  1136,    -1,    -1,   230,   400,    -1,
      -1,  4378,   325,    -1,    -1,   328,  4383,    -1,    -1,  4386,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1330,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   464,    -1,  4455,
      -1,   468,  1345,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      85,    -1,    -1,    88,    -1,    -1,    -1,    -1,    -1,  2725,
      -1,    -1,    -1,  4479,    -1,  1368,    -1,  4483,    -1,    -1,
     105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   113,    -1,
      -1,    -1,    -1,    -1,   119,    -1,    -1,   400,  4337,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4346,   490,   491,
     492,  1404,   494,   495,   496,   497,   498,   499,   143,    -1,
     108,    -1,    -1,    -1,  4363,  4364,  1419,    -1,    -1,  3404,
      -1,    -1,  1336,    -1,    -1,    -1,    -1,    -1,  1431,   127,
      -1,  1434,    -1,  1347,    -1,    -1,    -1,    -1,    -1,    85,
      -1,    -1,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4517,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   105,
      -1,   159,    -1,  4569,    -1,    -1,    -1,   113,    -1,    -1,
      -1,    -1,    -1,   119,    -1,    -1,    -1,   490,   491,   492,
      -1,   494,   495,   496,   497,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,    -1,   508,    -1,   143,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    -1,    -1,    -1,   243,    -1,
     101,    -1,   247,    -1,    -1,    -1,   214,    -1,    -1,    -1,
      -1,   820,    -1,    -1,    -1,   824,    -1,    -1,  4595,    -1,
      -1,    -1,    -1,   268,   269,    -1,    -1,    -1,   837,    -1,
      -1,  4657,    -1,   842,    -1,    -1,    -1,   245,    -1,   284,
     141,    -1,   851,  1556,    -1,  2921,    -1,    -1,  2924,    -1,
    2926,  1564,  1565,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1575,    -1,   309,    -1,   274,   312,    -1,   878,
      -1,  4378,   280,   882,    -1,    -1,  4383,    -1,    -1,  4386,
     325,    -1,    -1,   328,   893,    -1,    -1,   243,    -1,   190,
      -1,   247,    -1,    -1,    -1,    -1,   197,    -1,    -1,   200,
      -1,   309,    -1,    -1,    -1,    -1,    -1,    -1,   917,    -1,
    4569,    -1,   268,   269,  1627,  1628,  1629,  4424,    -1,    -1,
      -1,    -1,   931,    -1,    -1,    -1,   935,    -1,   284,    -1,
      -1,    -1,    -1,    -1,  1647,    95,   945,    -1,    -1,    -1,
      -1,   101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     959,   252,  4459,   309,    -1,   400,   312,    -1,    -1,    -1,
      -1,    -1,    -1,   371,  1677,    -1,    -1,   375,    -1,   325,
      -1,  1684,   328,   381,    -1,    -1,    -1,   838,  1691,    -1,
     388,   141,    -1,   844,    -1,  1698,    -1,    -1,   396,  4496,
      -1,   852,    -1,    -1,    -1,  3690,    -1,   405,    -1,   860,
      -1,    -1,    -1,    -1,   865,   413,   307,    -1,   309,    -1,
      -1,  3706,    -1,    -1,    -1,    -1,    -1,  1730,   319,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   327,    -1,    -1,    -1,
     190,    -1,    -1,    -1,    -1,   336,    -1,   197,  4545,  1048,
     200,    -1,    -1,    -1,   400,   490,   491,   492,    -1,   494,
     495,   496,   497,   498,   499,    -1,   464,    -1,    -1,  1068,
     468,   506,    -1,    -1,    -1,    -1,   367,  4893,    -1,    -1,
     371,  3766,    -1,    85,    -1,    -1,    88,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4862,    -1,    -1,  4595,    -1,
      -1,    -1,   252,   105,    -1,   396,    -1,    -1,    -1,    -1,
      -1,   113,  1815,    -1,  1817,  1647,    -1,   119,    -1,    -1,
      -1,    -1,    -1,    -1,  4940,    -1,    -1,    -1,    -1,    -1,
      -1,  4898,  4948,    -1,    -1,    -1,  1135,  1136,    -1,    -1,
      -1,   143,    -1,    -1,   490,   491,   492,    -1,   494,   495,
     496,   497,   498,   499,    -1,    -1,    -1,   307,   504,   309,
      -1,    -1,  1013,   454,    -1,    -1,    -1,    -1,    -1,   319,
      -1,    -1,    -1,    -1,    -1,  4942,    -1,   327,    -1,  3245,
      -1,    -1,    -1,    -1,  3250,  3251,   336,    -1,    -1,    -1,
      -1,    -1,  3258,  1896,  1045,    -1,    -1,   820,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1913,    -1,  1063,    -1,   837,    -1,    -1,   367,    -1,   842,
    3286,   371,    -1,    -1,    -1,    -1,  1929,    -1,   851,  3914,
      -1,    -1,    -1,    -1,  1085,    -1,    -1,    -1,    -1,    -1,
      -1,   243,    -1,    -1,    -1,   247,   396,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   878,    -1,    -1,    -1,   882,
      -1,  1964,  1965,    -1,    -1,    -1,   268,   269,    -1,    -1,
     893,    -1,  1975,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   284,  1815,  1987,  1988,    -1,    -1,    -1,    -1,
    4787,    -1,    -1,    -1,   917,    -1,    -1,    -1,    -1,    -1,
    4797,    -1,    -1,    -1,   454,    95,  2009,   309,   931,    -1,
     312,   101,   935,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   945,   325,    -1,    -1,   328,    -1,    -1,    -1,
      -1,  1330,    -1,    -1,  4831,    -1,   959,    -1,  3404,    -1,
    1954,    -1,    -1,    -1,    -1,    -1,  1345,    -1,    -1,  1963,
      -1,   141,    -1,  1967,    -1,    -1,    -1,    -1,    -1,  1973,
    1974,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1368,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1991,    -1,    -1,
      -1,  1913,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4078,    -1,    -1,    -1,  1929,   400,    -1,
     190,    -1,    -1,    -1,    -1,  1404,    -1,   197,    -1,    -1,
     200,    -1,    -1,    -1,    -1,    -1,    -1,  1268,    -1,    -1,
    1419,    -1,    -1,  1046,    -1,  1048,    -1,  1050,    -1,    -1,
      -1,    -1,  1431,  1965,    -1,  1434,    -1,  1288,  1289,  1290,
      -1,    -1,    -1,    -1,    -1,  4130,    -1,  4944,    -1,    -1,
      85,    -1,    -1,    88,  2157,    -1,  1988,    -1,    -1,    -1,
      -1,    -1,   252,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   113,    -1,
      -1,    -1,    -1,    -1,   119,    -1,    -1,    -1,   490,   491,
     492,    -1,   494,   495,   496,   497,   498,   499,    -1,    -1,
      -1,    -1,   504,    -1,    -1,    -1,    -1,    -1,   143,    -1,
      -1,    -1,  1135,  1136,    -1,    -1,    -1,   307,    -1,   309,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   319,
    3596,    -1,    -1,    -1,    -1,    -1,    -1,   327,    -1,    -1,
      -1,    -1,    -1,    -1,  2247,    -1,   336,    -1,    -1,    -1,
      -1,  4236,  1403,    -1,    -1,    -1,    -1,  1556,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1564,  1565,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1575,   367,    -1,  1430,
      -1,   371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2297,    -1,  2299,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   396,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,  2318,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3690,    -1,    -1,    -1,  1627,  1628,
    1629,    -1,  2246,   268,   269,    -1,    -1,    -1,    -1,    -1,
    3706,    -1,  2345,    -1,    -1,    -1,  2349,  2350,  1647,   284,
    2353,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   454,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2375,    -1,   309,    -1,    -1,   312,  1677,    -1,
      -1,    -1,    -1,    -1,    85,  1684,    -1,    88,    -1,    -1,
     325,    -1,  1691,   328,    -1,    -1,    -1,    -1,    -1,    -1,
    3766,    -1,    -1,    -1,   105,    -1,  2409,  1330,    -1,    -1,
      -1,    -1,   113,    -1,    -1,  3781,  3782,  2420,   119,    -1,
    1571,    -1,  1345,    -1,  3790,    -1,    -1,    -1,  3794,    -1,
      -1,    -1,    -1,  2436,  2437,    -1,    -1,    -1,    -1,  3805,
      -1,    -1,   143,    -1,    -1,  1368,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2459,  2460,    -1,  2462,
      -1,    -1,    -1,    -1,    -1,   400,    -1,  1618,    -1,    -1,
    4455,    -1,    -1,    -1,    -1,    -1,  2479,    -1,    -1,  2482,
      -1,  1404,    -1,    -1,    -1,    -1,  2318,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1419,  2500,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2510,  1431,    -1,
      -1,  1434,    -1,  2345,    -1,    -1,  1815,    -1,  2350,    -1,
    2523,  2353,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2532,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,  2375,    -1,    -1,   247,    -1,  3914,    -1,
      -1,    -1,    -1,    -1,    -1,   490,   491,   492,    -1,   494,
     495,   496,   497,   498,   499,    -1,    -1,   268,   269,   504,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2409,    -1,    -1,
      -1,    -1,    -1,   284,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1742,    -1,    -1,    -1,    -1,    -1,  1896,  1749,    -1,
      -1,    -1,    -1,    -1,  2436,    -1,    -1,    -1,   309,    -1,
      -1,   312,    95,    -1,  1913,    -1,    -1,    -1,   101,    -1,
      -1,    -1,    -1,  1774,   325,    -1,    -1,   328,  2460,    -1,
    1929,    -1,    -1,  1556,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1564,  1565,    -1,  2647,    -1,    -1,  2479,    -1,    -1,
    2482,    -1,  1575,    -1,    -1,  1806,    -1,    -1,   141,    -1,
      -1,    -1,    -1,    -1,    -1,  1964,  1965,    -1,  2500,  1820,
      -1,    -1,    -1,    -1,    -1,    -1,  1975,    -1,  2510,    -1,
      -1,  2684,    -1,  1834,    -1,    -1,  4052,    -1,  1987,  1988,
      -1,  2523,    -1,    -1,    -1,  1260,    -1,    -1,    -1,   400,
    2532,    -1,    -1,    -1,  1627,    -1,    -1,   190,  4074,    -1,
    2009,    -1,  4078,    85,   197,    95,    88,   200,    -1,    -1,
      -1,   101,    -1,    -1,  1647,    -1,    -1,  4712,  2731,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   113,    -1,    -1,    -1,    -1,  2660,   119,    -1,    -1,
    2753,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   141,  2676,  2677,  4130,    -1,  2680,    -1,  1691,   252,
      -1,   143,  2686,    -1,    -1,  1698,    -1,  4143,  4144,    -1,
      -1,    -1,  4148,  4149,    -1,    -1,    -1,    -1,    -1,   490,
     491,   492,    -1,   494,   495,   496,   497,   498,   499,    -1,
      -1,    -1,    -1,   504,    -1,    -1,    -1,  1730,    -1,    -1,
     190,    -1,    -1,    -1,    -1,    95,    -1,   197,    -1,    -1,
     200,   101,    -1,    -1,   307,    -1,   309,    -1,    -1,    -1,
      -1,  2834,    -1,   205,    -1,    -1,   319,  2840,    -1,    -1,
      -1,  2755,    -1,    -1,   327,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1417,   336,    -1,  2006,    -1,    -1,  2157,    -1,
      -1,   141,  4228,  4229,  4230,  4231,  4232,    -1,    -1,    -1,
    4236,   243,   252,    -1,    -1,   247,    -1,    -1,    -1,    -1,
      95,    -1,    -1,    -1,   367,    -1,   101,    -1,   371,    -1,
      -1,    -1,  1815,    -1,  1817,    -1,   268,   269,    -1,  2731,
      -1,    -1,  2053,  2054,    -1,    -1,    -1,    -1,    -1,    -1,
     190,    -1,   284,   396,    -1,    -1,    -1,   197,    -1,    -1,
     200,  2753,    -1,  2926,    -1,    -1,   141,   307,    -1,   309,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   319,
     312,    -1,    -1,    -1,    -1,    -1,    -1,   327,  2247,    -1,
      -1,    -1,    -1,   325,    -1,    -1,   336,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   454,   252,  1896,    -1,   190,    -1,    -1,    -1,    -1,
      -1,    -1,   197,    -1,    -1,   200,    -1,   367,    -1,    -1,
    1913,   371,    -1,    -1,  1559,    -1,    -1,  3000,  2297,    -1,
    2299,    -1,    -1,    -1,    -1,    -1,  1929,    -1,    -1,    -1,
      -1,    -1,  3015,  3016,    -1,    -1,   396,    -1,    -1,  2318,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   307,   400,   309,
      -1,    -1,    -1,    -1,    -1,  2186,  4402,   252,  3041,   319,
      -1,  1964,  1965,    -1,    -1,    -1,  2345,   327,    -1,    -1,
    2349,  2350,  1975,    -1,  2353,    -1,   336,    -1,    -1,    -1,
    2211,    -1,    -1,    -1,  1987,  1988,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   454,    -1,  2375,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2009,   367,    -1,  4455,
      -1,   371,   307,    -1,   309,    -1,    -1,  2248,    -1,  2250,
      -1,    -1,    -1,    -1,   319,    -1,    -1,    -1,    -1,    -1,
    2409,    -1,   327,  3116,  3117,  3118,   396,  3031,    -1,    -1,
    1685,   336,   494,   495,   496,   497,   498,   499,    -1,    -1,
      -1,    -1,  3135,    -1,    -1,    -1,    -1,  2436,  2437,  3142,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3151,    -1,
      -1,    -1,   367,    -1,    -1,  1260,   371,    -1,    -1,    85,
    2459,  2460,    88,  2462,    -1,    -1,    -1,    -1,  3000,    -1,
      -1,    -1,    -1,  1738,   454,    -1,    -1,    -1,    -1,   105,
    2479,   396,    -1,  2482,    -1,    -1,    -1,   113,    -1,    -1,
    3104,    -1,  3106,   119,    -1,    -1,    -1,    -1,    -1,    -1,
    1765,  2500,    -1,    -1,    -1,    -1,    -1,    85,    -1,  3212,
      88,  2510,    -1,    -1,    -1,    -1,    -1,   143,    -1,    -1,
      -1,    -1,    -1,    -1,  2523,    -1,    -1,   105,    -1,    -1,
      -1,    -1,    -1,  2532,  2157,   113,    -1,  3240,    -1,   454,
      -1,   119,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3257,    -1,    -1,    -1,    -1,    -1,
      -1,    85,    -1,    -1,    88,   143,    -1,    -1,  3271,    -1,
    3273,  1836,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3193,
    3283,   105,  3285,    -1,  3198,    -1,    -1,    -1,    -1,   113,
    1855,    -1,    -1,    -1,    -1,   119,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3135,    -1,  2456,    -1,    -1,  1873,    -1,
    3142,    -1,  1417,    -1,    -1,    -1,    -1,   243,    -1,   143,
      -1,   247,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3334,    -1,    -1,    -1,    -1,  1901,    -1,    -1,    -1,
      -1,    -1,   268,   269,    -1,    -1,  4712,    -1,  2647,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   284,    -1,
      -1,  3364,    -1,    -1,    -1,   243,    -1,    -1,    -1,   247,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3381,    -1,
    3212,    -1,    -1,   309,    -1,  2684,   312,    -1,    -1,    -1,
     268,   269,    -1,  3396,  1959,  2318,  3399,    -1,    -1,   325,
      -1,    -1,   328,    -1,    -1,    -1,   284,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,
      -1,    -1,  2345,   247,    -1,    -1,  2349,  2350,    -1,    -1,
    2353,   309,  2731,  3347,   312,    -1,    -1,  3351,  3352,    -1,
    3354,    -1,  3356,  3357,   268,   269,    -1,   325,    -1,  2600,
     328,  3365,  2375,    -1,  2753,    -1,    -1,    -1,    -1,    -1,
     284,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3472,
      -1,    -1,    -1,    -1,   400,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3398,   309,  2409,    -1,   312,    -1,
      -1,    -1,    -1,    -1,    95,    -1,    -1,  2420,    -1,    -1,
     101,   325,    -1,    -1,   328,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2436,  2437,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   400,    -1,    -1,    -1,    -1,  4893,    -1,    -1,
      -1,    -1,  3364,    -1,    -1,  2834,  2459,  2460,    -1,  2462,
     141,  2840,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3381,
      -1,    -1,    -1,    -1,    -1,    -1,  2479,    85,    -1,  2482,
      88,    -1,    -1,    -1,   490,   491,   492,  3399,   494,   495,
     496,   497,   498,   499,  4940,    -1,   400,  2500,   504,    -1,
    1685,    -1,  4948,    -1,    -1,   113,    -1,  2510,    -1,   190,
    2155,   119,    -1,    -1,    -1,    -1,   197,    -1,    -1,   200,
    2523,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2532,
      -1,    -1,   490,   491,   492,   143,   494,   495,   496,   497,
     498,   499,    -1,    -1,    -1,    -1,   504,  2926,    -1,    -1,
      -1,    -1,    -1,  1738,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3646,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   252,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1765,    -1,    -1,    -1,    -1,    -1,   490,   491,   492,    -1,
     494,   495,   496,   497,   498,   499,    -1,    -1,    -1,    -1,
     504,    -1,  3685,    -1,    -1,    -1,  3689,    -1,  3691,    -1,
      -1,    -1,    -1,    85,    -1,    -1,    88,    -1,    -1,    -1,
      -1,  3000,    -1,    -1,    -1,    -1,   307,    -1,   309,    -1,
      -1,    -1,    -1,    -1,    -1,   243,  3015,  3016,   319,   247,
    3723,   113,    -1,  3726,  2647,    -1,   327,   119,    -1,    -1,
      -1,  1836,    -1,    -1,    -1,   336,    -1,    -1,    -1,    -1,
     268,   269,  3041,    -1,    -1,    -1,  2897,    -1,    -1,    -1,
    1855,   143,    -1,    -1,    -1,    -1,   284,    -1,    -1,    -1,
      -1,  2684,    -1,  3766,    -1,    -1,   367,    -1,  1873,    -1,
     371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   312,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   396,  1901,   325,    -1,    -1,
      -1,  2952,    -1,    -1,    -1,    -1,    -1,    -1,  2731,    -1,
      -1,    -1,    -1,   205,  3646,    -1,    -1,  3116,  3117,  3118,
      -1,    -1,    -1,    -1,    -1,    94,    -1,    -1,    -1,    -1,
    2753,    -1,    -1,  3836,  3837,    -1,  3135,    -1,    -1,    -1,
      -1,    -1,    -1,  3142,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   243,  3151,   454,  1959,   247,    -1,    -1,    -1,    -1,
      -1,  2426,    -1,   132,    -1,    -1,  2431,  2432,    -1,    -1,
      -1,    -1,   400,    -1,    -1,    -1,   268,   269,  2443,    -1,
      -1,    -1,    -1,    -1,   153,    -1,    -1,    -1,    -1,    -1,
      85,  3723,   284,    88,  3726,    -1,    -1,    -1,    -1,    95,
      -1,    -1,   171,    -1,    -1,   101,    -1,    -1,    -1,    -1,
     105,  2834,    -1,  3212,  3917,   184,    -1,  2840,   113,    -1,
     312,    -1,    -1,   192,   119,    -1,    -1,    -1,    -1,    -1,
     126,    -1,    -1,   325,    -1,    -1,    -1,    -1,   207,    -1,
     209,  3240,    -1,    -1,   213,   141,    -1,    -1,   143,    -1,
      -1,    -1,    -1,    -1,   223,    -1,    -1,    -1,  3257,    -1,
      -1,    -1,   231,   491,   492,    -1,   494,   495,   496,   497,
     498,   499,  3271,    -1,  3273,    -1,   172,    -1,    -1,    -1,
      -1,  3895,    -1,    -1,  3283,    -1,  3285,    -1,    -1,  3903,
    3904,    -1,    -1,    -1,   190,    -1,    -1,    -1,    -1,    -1,
      -1,   197,    -1,  2926,   200,    -1,    -1,    -1,   400,  2574,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    85,    -1,    -1,    88,
      -1,    -1,    -1,    -1,    -1,  3334,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   105,    -1,   243,    -1,
    2155,    -1,   247,   249,   113,    -1,   252,    -1,    -1,    -1,
     119,    -1,    -1,    -1,    -1,  3364,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   268,   269,    -1,    -1,  3000,    -1,  2644,
      -1,    -1,  3381,    -1,   143,  3917,    -1,    -1,    -1,   284,
      -1,    -1,  3015,  3016,    -1,    -1,    -1,  3396,    -1,   295,
    3399,   297,   494,   495,   496,   497,   498,   499,    -1,    -1,
      -1,   307,    -1,   309,   309,    -1,    -1,   312,  3041,    -1,
      -1,  4124,    -1,   319,    -1,    -1,  3277,    -1,    -1,    -1,
     325,   327,    85,   328,    -1,    88,    -1,  4140,    -1,   335,
     336,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4152,
      -1,  3302,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3310,
     113,    -1,    -1,  3314,    -1,    -1,   119,    -1,    -1,    -1,
      -1,   367,    -1,  3472,    -1,   371,   372,  3328,  2743,    -1,
      -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,   247,  4103,
     143,    -1,    -1,  3116,  3117,  3118,    -1,    -1,    -1,    -1,
     396,    -1,    -1, 