/* { dg-do compile } */
/* { dg-options "-O2 -Werror-implicit-function-declaration -march=k8 -msse4a -m3dnow -mavx -mavx2 -mfma4 -mxop -maes -mpclmul -mpopcnt -mabm -mlzcnt -mbmi -mbmi2 -mtbm -mlwp -mfsgsbase -mrdrnd -mf16c -mfma -mrtm -mrdseed -mprfchw -madx -mfxsr -mxsaveopt -mavx512f -mavx512er -mavx512cd -mavx512pf -msha -mprefetchwt1 -mxsavec -mxsaves -mclflushopt -mavx512vl -mavx512dq -mavx512bw -mavx512vbmi -mavx512ifma -mavx5124fmaps -mavx5124vnniw -mavx512vpopcntdq -mclwb -mmwaitx -mclzero -mpku -msgx -mrdpid -mgfni -mavx512bitalg -mpconfig -mwbnoinvd" } */
/* { dg-add-options bind_pic_locally } */

#include <mm_malloc.h>

/* Test that the intrinsics compile with optimization.  All of them
   are defined as inline functions in {,x,e,p,t,s,w,a,b,i}mmintrin.h,
   mm3dnow.h, fma4intrin.h, xopintrin.h, abmintrin.h, bmiintrin.h,
   tbmintrin.h, lwpintrin.h, popcntintrin.h, fmaintrin.h and mm_malloc.h 
   that reference the proper builtin functions.

   Defining away "extern" and "__inline" results in all of them being
   compiled as proper functions.  */

#define extern
#define __inline

/* Following intrinsics require immediate arguments. */

/* ammintrin.h */
#define __builtin_ia32_extrqi(X, I, L)  __builtin_ia32_extrqi(X, 1, 1)
#define __builtin_ia32_insertqi(X, Y, I, L) __builtin_ia32_insertqi(X, Y, 1, 1)

/* immintrin.h */
#define __builtin_ia32_blendpd256(X, Y, M) __builtin_ia32_blendpd256(X, Y, 1)
#define __builtin_ia32_blendps256(X, Y, M) __builtin_ia32_blendps256(X, Y, 1)
#define __builtin_ia32_dpps256(X, Y, M) __builtin_ia32_dpps256(X, Y, 1)
#define __builtin_ia32_shufpd256(X, Y, M) __builtin_ia32_shufpd256(X, Y, 1)
#define __builtin_ia32_shufps256(X, Y, M) __builtin_ia32_shufps256(X, Y, 1)
#define __builtin_ia32_cmpsd(X, Y, O) __builtin_ia32_cmpsd(X, Y, 1)
#define __builtin_ia32_cmpss(X, Y, O) __builtin_ia32_cmpss(X, Y, 1)
#define __builtin_ia32_cmppd(X, Y, O) __builtin_ia32_cmppd(X, Y, 1)
#define __builtin_ia32_cmpps(X, Y, O) __builtin_ia32_cmpps(X, Y, 1)
#define __builtin_ia32_cmppd256(X, Y, O) __builtin_ia32_cmppd256(X, Y, 1)
#define __builtin_ia32_cmpps256(X, Y, O) __builtin_ia32_cmpps256(X, Y, 1)
#define __builtin_ia32_vextractf128_pd256(X, N) __builtin_ia32_vextractf128_pd256(X, 1)
#define __builtin_ia32_vextractf128_ps256(X, N) __builtin_ia32_vextractf128_ps256(X, 1)
#define __builtin_ia32_vextractf128_si256(X, N) __builtin_ia32_vextractf128_si256(X, 1)
#define __builtin_ia32_vpermilpd(X, N) __builtin_ia32_vpermilpd(X, 1)
#define __builtin_ia32_vpermilpd256(X, N) __builtin_ia32_vpermilpd256(X, 1)
#define __builtin_ia32_vpermilps(X, N) __builtin_ia32_vpermilps(X, 1)
#define __builtin_ia32_vpermilps256(X, N) __builtin_ia32_vpermilps256(X, 1)
#define __builtin_ia32_vpermil2pd(X, Y, C, I) __builtin_ia32_vpermil2pd(X, Y, C, 1)
#define __builtin_ia32_vpermil2pd256(X, Y, C, I) __builtin_ia32_vpermil2pd256(X, Y, C, 1)
#define __builtin_ia32_vpermil2ps(X, Y, C, I) __builtin_ia32_vpermil2ps(X, Y, C, 1)
#define __builtin_ia32_vpermil2ps256(X, Y, C, I) __builtin_ia32_vpermil2ps256(X, Y, C, 1)
#define __builtin_ia32_vperm2f128_pd256(X, Y, C) __builtin_ia32_vperm2f128_pd256(X, Y, 1)
#define __builtin_ia32_vperm2f128_ps256(X, Y, C) __builtin_ia32_vperm2f128_ps256(X, Y, 1)
#define __builtin_ia32_vperm2f128_si256(X, Y, C) __builtin_ia32_vperm2f128_si256(X, Y, 1)
#define __builtin_ia32_vinsertf128_pd256(X, Y, C) __builtin_ia32_vinsertf128_pd256(X, Y, 1)
#define __builtin_ia32_vinsertf128_ps256(X, Y, C) __builtin_ia32_vinsertf128_ps256(X, Y, 1)
#define __builtin_ia32_vinsertf128_si256(X, Y, C) __builtin_ia32_vinsertf128_si256(X, Y, 1)
#define __builtin_ia32_roundpd256(V, M) __builtin_ia32_roundpd256(V, 1)
#define __builtin_ia32_roundps256(V, M) __builtin_ia32_roundps256(V, 1)
#define __builtin_ia32_vcvtps2ph(A, I) __builtin_ia32_vcvtps2ph(A, 1)
#define __builtin_ia32_vcvtps2ph256(A, I) __builtin_ia32_vcvtps2ph256(A, 1)

/* wmmintrin.h */
#define __builtin_ia32_aeskeygenassist128(X, C) __builtin_ia32_aeskeygenassist128(X, 1)
#define __builtin_ia32_pclmulqdq128(X, Y, I) __builtin_ia32_pclmulqdq128(X, Y, 1)

/* smmintrin.h */
#define __builtin_ia32_roundpd(V, M) __builtin_ia32_roundpd(V, 1)
#define __builtin_ia32_roundsd(D, V, M) __builtin_ia32_roundsd(D, V, 1)
#define __builtin_ia32_roundps(V, M) __builtin_ia32_roundps(V, 1)
#define __builtin_ia32_roundss(D, V, M) __builtin_ia32_roundss(D, V, 1)

#define __builtin_ia32_pblendw128(X, Y, M) __builtin_ia32_pblendw128 (X, Y, 1)
#define __builtin_ia32_blendps(X, Y, M) __builtin_ia32_blendps(X, Y, 1)
#define __builtin_ia32_blendpd(X, Y, M) __builtin_ia32_blendpd(X, Y, 1)
#define __builtin_ia32_dpps(X, Y, M) __builtin_ia32_dpps(X, Y, 1)
#define __builtin_ia32_dppd(X, Y, M) __builtin_ia32_dppd(X, Y, 1)
#define __builtin_ia32_insertps128(D, S, N) __builtin_ia32_insertps128(D, S, 1)
#define __builtin_ia32_vec_ext_v4sf(X, N) __builtin_ia32_vec_ext_v4sf(X, 1)
#define __builtin_ia32_vec_set_v16qi(D, S, N) __builtin_ia32_vec_set_v16qi(D, S, 1)
#define __builtin_ia32_vec_set_v4si(D, S, N) __builtin_ia32_vec_set_v4si(D, S, 1)
#define __builtin_ia32_vec_set_v2di(D, S, N) __builtin_ia32_vec_set_v2di(D, S, 1)
#define __builtin_ia32_vec_ext_v16qi(X, N) __builtin_ia32_vec_ext_v16qi(X, 1)
#define __builtin_ia32_vec_ext_v4si(X, N) __builtin_ia32_vec_ext_v4si(X, 1)
#define __builtin_ia32_vec_ext_v2di(X, N) __builtin_ia32_vec_ext_v2di(X, 1)
#define __builtin_ia32_mpsadbw128(X, Y, M) __builtin_ia32_mpsadbw128(X, Y, 1)
#define __builtin_ia32_pcmpistrm128(X, Y, M) \
  __builtin_ia32_pcmpistrm128(X, Y, 1)
#define __builtin_ia32_pcmpistri128(X, Y, M) \
  __builtin_ia32_pcmpistri128(X, Y, 1)
#define __builtin_ia32_pcmpestrm128(X, LX, Y, LY, M) \
  __builtin_ia32_pcmpestrm128(X, LX, Y, LY, 1)
#define __builtin_ia32_pcmpestri128(X, LX, Y, LY, M) \
  __builtin_ia32_pcmpestri128(X, LX, Y, LY, 1)
#define __builtin_ia32_pcmpistria128(X, Y, M) \
  __builtin_ia32_pcmpistria128(X, Y, 1)
#define __builtin_ia32_pcmpistric128(X, Y, M) \
  __builtin_ia32_pcmpistric128(X, Y, 1)
#define __builtin_ia32_pcmpistrio128(X, Y, M) \
  __builtin_ia32_pcmpistrio128(X, Y, 1)
#define __builtin_ia32_pcmpistris128(X, Y, M) \
  __builtin_ia32_pcmpistris128(X, Y, 1)
#define __builtin_ia32_pcmpistriz128(X, Y, M) \
  __builtin_ia32_pcmpistriz128(X, Y, 1)
#define __builtin_ia32_pcmpestria128(X, LX, Y, LY, M) \
  __builtin_ia32_pcmpestria128(X, LX, Y, LY, 1)
#define __builtin_ia32_pcmpestric128(X, LX, Y, LY, M) \
  __builtin_ia32_pcmpestric128(X, LX, Y, LY, 1)
#define __builtin_ia32_pcmpestrio128(X, LX, Y, LY, M) \
  __builtin_ia32_pcmpestrio128(X, LX, Y, LY, 1)
#define __builtin_ia32_pcmpestris128(X, LX, Y, LY, M) \
  __builtin_ia32_pcmpestris128(X, LX, Y, LY, 1)
#define __builtin_ia32_pcmpestriz128(X, LX, Y, LY, M) \
  __builtin_ia32_pcmpestriz128(X, LX, Y, LY, 1)

/* tmmintrin.h */
#define __builtin_ia32_palignr128(X, Y, N) __builtin_ia32_palignr128(X, Y, 8)
#define __builtin_ia32_palignr(X, Y, N) __builtin_ia32_palignr(X, Y, 8)

/* emmintrin.h */
#define __builtin_ia32_psrldqi128(A, B) __builtin_ia32_psrldqi128(A, 8)
#define __builtin_ia32_pslldqi128(A, B) __builtin_ia32_pslldqi128(A, 8)
#define __builtin_ia32_pshufhw(A, N) __builtin_ia32_pshufhw(A, 0)
#define __builtin_ia32_pshuflw(A, N) __builtin_ia32_pshuflw(A, 0)
#define __builtin_ia32_pshufd(A, N) __builtin_ia32_pshufd(A, 0)
#define __builtin_ia32_vec_set_v8hi(A, D, N) \
  __builtin_ia32_vec_set_v8hi(A, D, 0)
#define __builtin_ia32_vec_ext_v8hi(A, N) __builtin_ia32_vec_ext_v8hi(A, 0)
#define __builtin_ia32_shufpd(A, B, N) __builtin_ia32_shufpd(A, B, 0)

/* xmmintrin.h */
#define __builtin_prefetch(P, A, I) __builtin_prefetch(P, 0, _MM_HINT_NTA)
#define __builtin_ia32_pshufw(A, N) __builtin_ia32_pshufw(A, 0)
#define __builtin_ia32_vec_set_v4hi(A, D, N) \
  __builtin_ia32_vec_set_v4hi(A, D, 0)
#define __builtin_ia32_vec_ext_v4hi(A, N) __builtin_ia32_vec_ext_v4hi(A, 0)
#define __builtin_ia32_shufps(A, B, N) __builtin_ia32_shufps(A, B, 0)

/* xopintrin.h */
#define __builtin_ia32_vprotbi(A, N) __builtin_ia32_vprotbi (A,1)
#define __builtin_ia32_vprotwi(A, N) __builtin_ia32_vprotwi (A,1)
#define __builtin_ia32_vprotdi(A, N) __builtin_ia32_vprotdi (A,1)
#define __builtin_ia32_vprotqi(A, N) __builtin_ia32_vprotqi (A,1)

/* lwpintrin.h */
#define __builtin_ia32_lwpval32(D2, D1, F) __builtin_ia32_lwpval32 (D2, D1, 1)
#define __builtin_ia32_lwpval64(D2, D1, F) __builtin_ia32_lwpval64 (D2, D1, 1)
#define __builtin_ia32_lwpins32(D2, D1, F) __builtin_ia32_lwpins32 (D2, D1, 1)
#define __builtin_ia32_lwpins64(D2, D1, F) __builtin_ia32_lwpins64 (D2, D1, 1)

/* tbmintrin.h */
#define __builtin_ia32_bextri_u32(X, Y) __builtin_ia32_bextri_u32 (X, 1)
#define __builtin_ia32_bextri_u64(X, Y) __builtin_ia32_bextri_u64 (X, 1)

/* avx2intrin.h */
#define __builtin_ia32_mpsadbw256(X, Y, Z) __builtin_ia32_mpsadbw256 (X, Y, 1)
#define __builtin_ia32_palignr256(X, Y, Z) __builtin_ia32_palignr256 (X, Y, 8)
#define __builtin_ia32_pblendw256(X, Y, Z) __builtin_ia32_pblendw256 (X, Y, 1)
#define __builtin_ia32_pshufd256(X, Y) __builtin_ia32_pshufd256(X, 1)
#define __builtin_ia32_pshufhw256(X, Y) __builtin_ia32_pshufhw256(X, 1)
#define __builtin_ia32_pshuflw256(X, Y) __builtin_ia32_pshuflw256(X, 1)
#define __builtin_ia32_pslldqi256(X, Y) __builtin_ia32_pslldqi256(X, 8)
#define __builtin_ia32_psrldqi256(X, Y) __builtin_ia32_psrldqi256(X, 8)
#define __builtin_ia32_pblendd128(X, Y, Z) __builtin_ia32_pblendd128(X, Y, 1)
#define __builtin_ia32_pblendd256(X, Y, Z) __builtin_ia32_pblendd256(X, Y, 1)
#define __builtin_ia32_permdf256(X, Y) __builtin_ia32_permdf256(X, 1)
#define __builtin_ia32_permdi256(X, Y) __builtin_ia32_permdi256(X, 1)
#define __builtin_ia32_permti256(X, Y, Z) __builtin_ia32_permti256(X, Y, 1)
#define __builtin_ia32_extract128i256(X, Y) __builtin_ia32_extract128i256(X, 1)
#define __builtin_ia32_insert128i256(X, Y, Z) __builtin_ia32_insert128i256(X, Y, 1)
#define __builtin_ia32_gathersiv2df(X, Y, Z, K, M) __builtin_ia32_gathersiv2df(X, Y, Z, K, 1)
#define __builtin_ia32_gathersiv4df(X, Y, Z, K, M) __builtin_ia32_gathersiv4df(X, Y, Z, K, 1)
#define __builtin_ia32_gatherdiv2df(X, Y, Z, K, M) __builtin_ia32_gatherdiv2df(X, Y, Z, K, 1)
#define __builtin_ia32_gatherdiv4df(X, Y, Z, K, M) __builtin_ia32_gatherdiv4df(X, Y, Z, K, 1)
#define __builtin_ia32_gathersiv4sf(X, Y, Z, K, M) __builtin_ia32_gathersiv4sf(X, Y, Z, K, 1)
#define __builtin_ia32_gathersiv8sf(X, Y, Z, K, M) __builtin_ia32_gathersiv8sf(X, Y, Z, K, 1)
#define __builtin_ia32_gatherdiv4sf(X, Y, Z, K, M) __builtin_ia32_gatherdiv4sf(X, Y, Z, K, 1)
#define __builtin_ia32_gatherdiv4sf256(X, Y, Z, K, M) __builtin_ia32_gatherdiv4sf256(X, Y, Z, K, 1)
#define __builtin_ia32_gathersiv2di(X, Y, Z, K, M) __builtin_ia32_gathersiv2di(X, Y, Z, K, 1)
#define __builtin_ia32_gathersiv4di(X, Y, Z, K, M) __builtin_ia32_gathersiv4di(X, Y, Z, K, 1)
#define __builtin_ia32_gatherdiv2di(X, Y, Z, K, M) __builtin_ia32_gatherdiv2di(X, Y, Z, K, 1)
#define __builtin_ia32_gatherdiv4di(X, Y, Z, K, M) __builtin_ia32_gatherdiv4di(X, Y, Z, K, 1)
#define __builtin_ia32_gathersiv4si(X, Y, Z, K, M) __builtin_ia32_gathersiv4si(X, Y, Z, K, 1)
#define __builtin_ia32_gathersiv8si(X, Y, Z, K, M) __builtin_ia32_gathersiv8si(X, Y, Z, K, 1)
#define __builtin_ia32_gatherdiv4si(X, Y, Z, K, M) __builtin_ia32_gatherdiv4si(X, Y, Z, K, 1)
#define __builtin_ia32_gatherdiv4si256(X, Y, Z, K, M) __builtin_ia32_gatherdiv4si256(X, Y, Z, K, 1)

/* rtmintrin.h */
#define __builtin_ia32_xabort(N) __builtin_ia32_xabort(1)

/* avx512fintrin.h */
#define __builtin_ia32_kshiftlihi(A, B) __builtin_ia32_kshiftlihi(A, 8)
#define __builtin_ia32_kshiftrihi(A, B) __builtin_ia32_kshiftrihi(A, 8)
#define __builtin_ia32_addpd512_mask(A, B, C, D, E) __builtin_ia32_addpd512_mask(A, B, C, D, 8)
#define __builtin_ia32_addps512_mask(A, B, C, D, E) __builtin_ia32_addps512_mask(A, B, C, D, 8)
#define __builtin_ia32_addsd_round(A, B, C) __builtin_ia32_addsd_round(A, B, 8)
#define __builtin_ia32_addsd_mask_round(A, B, C, D, E) __builtin_ia32_addsd_mask_round(A, B, C, D, 8)
#define __builtin_ia32_addss_round(A, B, C) __builtin_ia32_addss_round(A, B, 8)
#define __builtin_ia32_addss_mask_round(A, B, C, D, E) __builtin_ia32_addss_mask_round(A, B, C, D, 8)
#define __builtin_ia32_alignd512_mask(A, B, F, D, E) __builtin_ia32_alignd512_mask(A, B, 1, D, E)
#define __builtin_ia32_alignq512_mask(A, B, F, D, E) __builtin_ia32_alignq512_mask(A, B, 1, D, E)
#define __builtin_ia32_cmpd512_mask(A, B, E, D) __builtin_ia32_cmpd512_mask(A, B, 1, D)
#define __builtin_ia32_cmppd512_mask(A, B, F, D, E) __builtin_ia32_cmppd512_mask(A, B, 1, D, 8)
#define __builtin_ia32_cmpps512_mask(A, B, F, D, E) __builtin_ia32_cmpps512_mask(A, B, 1, D, 8)
#define __builtin_ia32_cmpq512_mask(A, B, E, D) __builtin_ia32_cmpq512_mask(A, B, 1, D)
#define __builtin_ia32_cmpsd_mask(A, B, F, D, E) __builtin_ia32_cmpsd_mask(A, B, 1, D, 8)
#define __builtin_ia32_cmpss_mask(A, B, F, D, E) __builtin_ia32_cmpss_mask(A, B, 1, D, 8)
#define __builtin_ia32_cvtdq2ps512_mask(A, B, C, D) __builtin_ia32_cvtdq2ps512_mask(A, B, C, 8)
#define __builtin_ia32_cvtpd2dq512_mask(A, B, C, D) __builtin_ia32_cvtpd2dq512_mask(A, B, C, 8)
#define __builtin_ia32_cvtpd2ps512_mask(A, B, C, D) __builtin_ia32_cvtpd2ps512_mask(A, B, C, 8)
#define __builtin_ia32_cvtpd2udq512_mask(A, B, C, D) __builtin_ia32_cvtpd2udq512_mask(A, B, C, 8)
#define __builtin_ia32_cvtps2dq512_mask(A, B, C, D) __builtin_ia32_cvtps2dq512_mask(A, B, C, 8)
#define __builtin_ia32_cvtps2pd512_mask(A, B, C, D) __builtin_ia32_cvtps2pd512_mask(A, B, C, 8)
#define __builtin_ia32_cvtps2udq512_mask(A, B, C, D) __builtin_ia32_cvtps2udq512_mask(A, B, C, 8)
#define __builtin_ia32_cvtsd2ss_round(A, B, C) __builtin_ia32_cvtsd2ss_round(A, B, 8)
#define __builtin_ia32_cvtss2sd_round(A, B, C) __builtin_ia32_cvtss2sd_round(A, B, 4)
#define __builtin_ia32_cvtsi2sd64(A, B, C) __builtin_ia32_cvtsi2sd64(A, B, 8)
#define __builtin_ia32_cvtsi2ss32(A, B, C) __builtin_ia32_cvtsi2ss32(A, B, 8)
#define __builtin_ia32_cvtsi2ss64(A, B, C) __builtin_ia32_cvtsi2ss64(A, B, 8)
#define __builtin_ia32_cvttpd2dq512_mask(A, B, C, D) __builtin_ia32_cvttpd2dq512_mask(A, B, C, 8)
#define __builtin_ia32_cvttpd2udq512_mask(A, B, C, D) __builtin_ia32_cvttpd2udq512_mask(A, B, C, 8)
#define __builtin_ia32_cvttps2dq512_mask(A, B, C, D) __builtin_ia32_cvttps2dq512_mask(A, B, C, 8)
#define __builtin_ia32_cvttps2udq512_mask(A, B, C, D) __builtin_ia32_cvttps2udq512_mask(A, B, C, 8)
#define __builtin_ia32_cvtudq2ps512_mask(A, B, C, D) __builtin_ia32_cvtudq2ps512_mask(A, B, C, 8)
#define __builtin_ia32_cvtusi2sd64(A, B, C) __builtin_ia32_cvtusi2sd64(A, B, 8)
#define __builtin_ia32_cvtusi2ss32(A, B, C) __builtin_ia32_cvtusi2ss32(A, B, 8)
#define __builtin_ia32_cvtusi2ss64(A, B, C) __builtin_ia32_cvtusi2ss64(A, B, 8)
#define __builtin_ia32_divpd512_mask(A, B, C, D, E) __builtin_ia32_divpd512_mask(A, B, C, D, 8)
#define __builtin_ia32_divps512_mask(A, B, C, D, E) __builtin_ia32_divps512_mask(A, B, C, D, 8)
#define __builtin_ia32_divsd_round(A, B, C) __builtin_ia32_divsd_round(A, B, 8)
#define __builtin_ia32_divsd_mask_round(A, B, C, D, E) __builtin_ia32_divsd_mask_round(A, B, C, D, 8)
#define __builtin_ia32_divss_round(A, B, C) __builtin_ia32_divss_round(A, B, 8)
#define __builtin_ia32_divss_mask_round(A, B, C, D, E) __builtin_ia32_divss_mask_round(A, B, C, D, 8)
#define __builtin_ia32_extractf32x4_mask(A, E, C, D) __builtin_ia32_extractf32x4_mask(A, 1, C, D)
#define __builtin_ia32_extractf64x4_mask(A, E, C, D) __builtin_ia32_extractf64x4_mask(A, 1, C, D)
#define __builtin_ia32_extracti32x4_mask(A, E, C, D) __builtin_ia32_extracti32x4_mask(A, 1, C, D)
#define __builtin_ia32_extracti64x4_mask(A, E, C, D) __builtin_ia32_extracti64x4_mask(A, 1, C, D)
#define __builtin_ia32_fixupimmpd512_mask(A, B, C, I, E, F) __builtin_ia32_fixupimmpd512_mask(A, B, C, 1, E, 8)
#define __builtin_ia32_fixupimmpd512_maskz(A, B, C, I, E, F) __builtin_ia32_fixupimmpd512_maskz(A, B, C, 1, E, 8)
#define __builtin_ia32_fixupimmps512_mask(A, B, C, I, E, F) __builtin_ia32_fixupimmps512_mask(A, B, C, 1, E, 8)
#define __builtin_ia32_fixupimmps512_maskz(A, B, C, I, E, F) __builtin_ia32_fixupimmps512_maskz(A, B, C, 1, E, 8)
#define __builtin_ia32_fixupimmsd_mask(A, B, C, I, E, F) __builtin_ia32_fixupimmsd_mask(A, B, C, 1, E, 8)
#define __builtin_ia32_fixupimmsd_maskz(A, B, C, I, E, F) __builtin_ia32_fixupimmsd_maskz(A, B, C, 1, E, 8)
#define __builtin_ia32_fixupimmss_mask(A, B, C, I, E, F) __builtin_ia32_fixupimmss_mask(A, B, C, 1, E, 8)
#define __builtin_ia32_fixupimmss_maskz(A, B, C, I, E, F) __builtin_ia32_fixupimmss_maskz(A, B, C, 1, E, 8)
#define __builtin_ia32_gatherdiv8df(A, B, C, D, F) __builtin_ia32_gatherdiv8df(A, B, C, D, 8)
#define __builtin_ia32_gatherdiv8di(A, B, C, D, F) __builtin_ia32_gatherdiv8di(A, B, C, D, 8)
#define __builtin_ia32_gatherdiv16sf(A, B, C, D, F) __builtin_ia32_gatherdiv16sf(A, B, C, D, 8)
#define __builtin_ia32_gatherdiv16si(A, B, C, D, F) __builtin_ia32_gatherdiv16si(A, B, C, D, 8)
#define __builtin_ia32_gathersiv16sf(A, B, C, D, F) __builtin_ia32_gathersiv16sf(A, B, C, D, 8)
#define __builtin_ia32_gathersiv16si(A, B, C, D, F) __builtin_ia32_gathersiv16si(A, B, C, D, 8)
#define __builtin_ia32_gathersiv8df(A, B, C, D, F) __builtin_ia32_gathersiv8df(A, B, C, D, 8)
#define __builtin_ia32_gathersiv8di(A, B, C, D, F) __builtin_ia32_gathersiv8di(A, B, C, D, 8)
#define __builtin_ia32_getexppd512_mask(A, B, C, D) __builtin_ia32_getexppd512_mask(A, B, C, 8)
#define __builtin_ia32_getexpps512_mask(A, B, C, D) __builtin_ia32_getexpps512_mask(A, B, C, 8)
#define __builtin_ia32_getexpsd128_round(A, B, C) __builtin_ia32_getexpsd128_round(A, B, 4)
#define __builtin_ia32_getexpsd_mask_round(A, B, C, D, E) __builtin_ia32_getexpsd_mask_round(A, B, C, D, 4)
#define __builtin_ia32_getexpss128_round(A, B, C) __builtin_ia32_getexpss128_round(A, B, 4)
#define __builtin_ia32_getexpss_mask_round(A, B, C, D, E) __builtin_ia32_getexpss_mask_round(A, B, C, D, 4)
#define __builtin_ia32_getmantpd512_mask(A, F, C, D, E) __builtin_ia32_getmantpd512_mask(A, 1, C, D, 8)
#define __builtin_ia32_getmantps512_mask(A, F, C, D, E) __builtin_ia32_getmantps512_mask(A, 1, C, D, 8)
#define __builtin_ia32_getmantsd_round(A, B, C, D) __builtin_ia32_getmantsd_round(A, B, 1, 4)
#define __builtin_ia32_getmantsd_mask_round(A, B, C, W, U, D) __builtin_ia32_getmantsd_mask_round(A, B, 1, W, U, 4)
#define __builtin_ia32_getmantss_round(A, B, C, D) __builtin_ia32_getmantss_round(A, B, 1, 4)
#define __builtin_ia32_getmantss_mask_round(A, B, C, W, U, D) __builtin_ia32_getmantss_mask_round(A, B, 1, W, U, 4)
#define __builtin_ia32_insertf32x4_mask(A, B, F, D, E) __builtin_ia32_insertf32x4_mask(A, B, 1, D, E)
#define __builtin_ia32_insertf64x4_mask(A, B, F, D, E) __builtin_ia32_insertf64x4_mask(A, B, 1, D, E)
#define __builtin_ia32_inserti32x4_mask(A, B, F, D, E) __builtin_ia32_inserti32x4_mask(A, B, 1, D, E)
#define __builtin_ia32_inserti64x4_mask(A, B, F, D, E) __builtin_ia32_inserti64x4_mask(A, B, 1, D, E)
#define __builtin_ia32_maxpd512_mask(A, B, C, D, E) __builtin_ia32_maxpd512_mask(A, B, C, D, 8)
#define __builtin_ia32_maxps512_mask(A, B, C, D, E) __builtin_ia32_maxps512_mask(A, B, C, D, 8)
#define __builtin_ia32_maxsd_round(A, B, C) __builtin_ia32_maxsd_round(A, B, 4)
#define __builtin_ia32_maxsd_mask_round(A, B, C, D, E) __builtin_ia32_maxsd_mask_round(A, B, C, D, 4)
#define __builtin_ia32_maxss_round(A, B, C) __builtin_ia32_maxss_round(A, B, 4)
#define __builtin_ia32_maxss_mask_round(A, B, C, D, E) __builtin_ia32_maxss_mask_round(A, B, C, D, 4)
#define __builtin_ia32_minpd512_mask(A, B, C, D, E) __builtin_ia32_minpd512_mask(A, B, C, D, 8)
#define __builtin_ia32_minps512_mask(A, B, C, D, E) __builtin_ia32_minps512_mask(A, B, C, D, 8)
#define __builtin_ia32_minsd_round(A, B, C) __builtin_ia32_minsd_round(A, B, 4)
#define __builtin_ia32_minsd_mask_round(A, B, C, D, E) __builtin_ia32_minsd_mask_round(A, B, C, D, 4)
#define __builtin_ia32_minss_round(A, B, C) __builtin_ia32_minss_round(A, B, 4)
#define __builtin_ia32_minss_mask_round(A, B, C, D, E) __builtin_ia32_minss_mask_round(A, B, C, D, 4)
#define __builtin_ia32_mulpd512_mask(A, B, C, D, E) __builtin_ia32_mulpd512_mask(A, B, C, D, 8)
#define __builtin_ia32_mulps512_mask(A, B, C, D, E) __builtin_ia32_mulps512_mask(A, B, C, D, 8)
#define __builtin_ia32_mulsd_round(A, B, C) __builtin_ia32_mulsd_round(A, B, 8)
#define __builtin_ia32_mulsd_mask_round(A, B, C, D, E) __builtin_ia32_mulsd_mask_round(A, B, C, D, 8)
#define __builtin_ia32_mulss_round(A, B, C) __builtin_ia32_mulss_round(A, B, 8)
#define __builtin_ia32_mulss_mask_round(A, B, C, D, E) __builtin_ia32_mulss_mask_round(A, B, C, D, 8)
#define __builtin_ia32_permdf512_mask(A, E, C, D) __builtin_ia32_permdf512_mask(A, 1, C, D)
#define __builtin_ia32_permdi512_mask(A, E, C, D) __builtin_ia32_permdi512_mask(A, 1, C, D)
#define __builtin_ia32_prold512_mask(A, E, C, D) __builtin_ia32_prold512_mask(A, 1, C, D)
#define __builtin_ia32_prolq512_mask(A, E, C, D) __builtin_ia32_prolq512_mask(A, 1, C, D)
#define __builtin_ia32_prord512_mask(A, E, C, D) __builtin_ia32_prord512_mask(A, 1, C, D)
#define __builtin_ia32_prorq512_mask(A, E, C, D) __builtin_ia32_prorq512_mask(A, 1, C, D)
#define __builtin_ia32_pshufd512_mask(A, E, C, D) __builtin_ia32_pshufd512_mask(A, 1, C, D)
#define __builtin_ia32_pslldi512_mask(A, E, C, D) __builtin_ia32_pslldi512_mask(A, 1, C, D)
#define __builtin_ia32_psllqi512_mask(A, E, C, D) __builtin_ia32_psllqi512_mask(A, 1, C, D)
#define __builtin_ia32_psradi512_mask(A, E, C, D) __builtin_ia32_psradi512_mask(A, 1, C, D)
#define __builtin_ia32_psraqi512_mask(A, E, C, D) __builtin_ia32_psraqi512_mask(A, 1, C, D)
#define __builtin_ia32_psrldi512_mask(A, E, C, D) __builtin_ia32_psrldi512_mask(A, 1, C, D)
#define __builtin_ia32_psrlqi512_mask(A, E, C, D) __builtin_ia32_psrlqi512_mask(A, 1, C, D)
#define __builtin_ia32_pternlogd512_mask(A, B, C, F, E) __builtin_ia32_pternlogd512_mask(A, B, C, 1, E)
#define __builtin_ia32_pternlogd512_maskz(A, B, C, F, E) __builtin_ia32_pternlogd512_maskz(A, B, C, 1, E)
#define __builtin_ia32_pternlogq512_mask(A, B, C, F, E) __builtin_ia32_pternlogq512_mask(A, B, C, 1, E)
#define __builtin_ia32_pternlogq512_maskz(A, B, C, F, E) __builtin_ia32_pternlogq512_maskz(A, B, C, 1, E)
#define __builtin_ia32_rndscalepd_mask(A, F, C, D, E) __builtin_ia32_rndscalepd_mask(A, 1, C, D, 8)
#define __builtin_ia32_rndscaleps_mask(A, F, C, D, E) __builtin_ia32_rndscaleps_mask(A, 1, C, D, 8)
#define __builtin_ia32_rndscalesd_round(A, B, C, D) __builtin_ia32_rndscalesd_round(A, B, 1, 4)
#define __builtin_ia32_rndscaless_round(A, B, C, D) __builtin_ia32_rndscaless_round(A, B, 1, 4)
#define __builtin_ia32_scalefpd512_mask(A, B, C, D, E) __builtin_ia32_scalefpd512_mask(A, B, C, D, 8)
#define __builtin_ia32_scalefps512_mask(A, B, C, D, E) __builtin_ia32_scalefps512_mask(A, B, C, D, 8)
#define __builtin_ia32_scalefsd_mask_round(A, B, C, D, E) __builtin_ia32_scalefsd_mask_round(A, B, C, D, 8)
#define __builtin_ia32_scalefss_mask_round(A, B, C, D, E) __builtin_ia32_scalefss_mask_round(A, B, C, D, 8)
#define __builtin_ia32_scatterdiv8df(A, B, C, D, F) __builtin_ia32_scatterdiv8df(A, B, C, D, 8)
#define __builtin_ia32_scatterdiv8di(A, B, C, D, F) __builtin_ia32_scatterdiv8di(A, B, C, D, 8)
#define __builtin_ia32_scatterdiv16sf(A, B, C, D, F) __builtin_ia32_scatterdiv16sf(A, B, C, D, 8)
#define __builtin_ia32_scatterdiv16si(A, B, C, D, F) __builtin_ia32_scatterdiv16si(A, B, C, D, 8)
#define __builtin_ia32_scattersiv16sf(A, B, C, D, F) __builtin_ia32_scattersiv16sf(A, B, C, D, 8)
#define __builtin_ia32_scattersiv16si(A, B, C, D, F) __builtin_ia32_scattersiv16si(A, B, C, D, 8)
#define __builtin_ia32_scattersiv8df(A, B, C, D, F) __builtin_ia32_scattersiv8df(A, B, C, D, 8)
#define __builtin_ia32_scattersiv8di(A, B, C, D, F) __builtin_ia32_scattersiv8di(A, B, C, D, 8)
#define __builtin_ia32_shuf_f32x4_mask(A, B, F, D, E) __builtin_ia32_shuf_f32x4_mask(A, B, 1, D, E)
#define __builtin_ia32_shuf_f64x2_mask(A, B, F, D, E) __builtin_ia32_shuf_f64x2_mask(A, B, 1, D, E)
#define __builtin_ia32_shuf_i32x4_mask(A, B, F, D, E) __builtin_ia32_shuf_i32x4_mask(A, B, 1, D, E)
#define __builtin_ia32_shuf_i64x2_mask(A, B, F, D, E) __builtin_ia32_shuf_i64x2_mask(A, B, 1, D, E)
#define __builtin_ia32_shufpd512_mask(A, B, F, D, E) __builtin_ia32_shufpd512_mask(A, B, 1, D, E)
#define __builtin_ia32_shufps512_mask(A, B, F, D, E) __builtin_ia32_shufps512_mask(A, B, 1, D, E)
#define __builtin_ia32_sqrtpd512_mask(A, B, C, D) __builtin_ia32_sqrtpd512_mask(A, B, C, 8)
#define __builtin_ia32_sqrtps512_mask(A, B, C, D) __builtin_ia32_sqrtps512_mask(A, B, C, 8)
#define __builtin_ia32_sqrtss_mask_round(A, B, C, D, E) __builtin_ia32_sqrtss_mask_round(A, B, C, E, 8)
#define __builtin_ia32_sqrtsd_mask_round(A, B, C, D, E) __builtin_ia32_sqrtsd_mask_round(A, B, C, E, 8)
#define __builtin_ia32_subpd512_mask(A, B, C, D, E) __builtin_ia32_subpd512_mask(A, B, C, D, 8)
#define __builtin_ia32_subps512_mask(A, B, C, D, E) __builtin_ia32_subps512_mask(A, B, C, D, 8)
#define __builtin_ia32_subsd_round(A, B, C) __builtin_ia32_subsd_round(A, B, 8)
#define __builtin_ia32_subsd_mask_round(A, B, C, D, E) __builtin_ia32_subsd_mask_round(A, B, C, D, 8)
#define __builtin_ia32_subss_round(A, B, C) __builtin_ia32_subss_round(A, B, 8)
#define __builtin_ia32_subss_mask_round(A, B, C, D, E) __builtin_ia32_subss_mask_round(A, B, C, D, 8)
#define __builtin_ia32_ucmpd512_mask(A, B, E, D) __builtin_ia32_ucmpd512_mask(A, B, 1, D)
#define __builtin_ia32_ucmpq512_mask(A, B, E, D) __builtin_ia32_ucmpq512_mask(A, B, 1, D)
#define __builtin_ia32_vcomisd(A, B, C, D) __builtin_ia32_vcomisd(A, B, 1, 8)
#define __builtin_ia32_vcomiss(A, B, C, D) __builtin_ia32_vcomiss(A, B, 1, 8)
#define __builtin_ia32_vcvtph2ps512_mask(A, B, C, D) __builtin_ia32_vcvtph2ps512_mask(A, B, C, 8)
#define __builtin_ia32_vcvtps2ph512_mask(A, E, C, D) __builtin_ia32_vcvtps2ph512_mask(A, 1, C, D)
#define __builtin_ia32_vcvtsd2si32(A, B) __builtin_ia32_vcvtsd2si32(A, 8)
#define __builtin_ia32_vcvtsd2si64(A, B) __builtin_ia32_vcvtsd2si64(A, 8)
#define __builtin_ia32_vcvtsd2usi32(A, B) __builtin_ia32_vcvtsd2usi32(A, 8)
#define __builtin_ia32_vcvtsd2usi64(A, B) __builtin_ia32_vcvtsd2usi64(A, 8)
#define __builtin_ia32_vcvtss2si32(A, B) __builtin_ia32_vcvtss2si32(A, 8)
#define __builtin_ia32_vcvtss2si64(A, B) __builtin_ia32_vcvtss2si64(A, 8)
#define __builtin_ia32_vcvtss2usi32(A, B) __builtin_ia32_vcvtss2usi32(A, 8)
#define __builtin_ia32_vcvtss2usi64(A, B) __builtin_ia32_vcvtss2usi64(A, 8)
#define __builtin_ia32_vcvttsd2si32(A, B) __builtin_ia32_vcvttsd2si32(A, 8)
#define __builtin_ia32_vcvttsd2si64(A, B) __builtin_ia32_vcvttsd2si64(A, 8)
#define __builtin_ia32_vcvttsd2usi32(A, B) __builtin_ia32_vcvttsd2usi32(A, 8)
#define __builtin_ia32_vcvttsd2usi64(A, B) __builtin_ia32_vcvttsd2usi64(A, 8)
#define __builtin_ia32_vcvttss2si32(A, B) __builtin_ia32_vcvttss2si32(A, 8)
#define __builtin_ia32_vcvttss2si64(A, B) __builtin_ia32_vcvttss2si64(A, 8)
#define __builtin_ia32_vcvttss2usi32(A, B) __builtin_ia32_vcvttss2usi32(A, 8)
#define __builtin_ia32_vcvttss2usi64(A, B) __builtin_ia32_vcvttss2usi64(A, 8)
#define __builtin_ia32_vfmaddpd512_mask(A, B, C, D, E) __builtin_ia32_vfmaddpd512_mask(A, B, C, D, 8)
#define __builtin_ia32_vfmaddpd512_mask3(A, B, C, D, E) __builtin_ia32_vfmaddpd512_mask3(A, B, C, D, 8)
#define __builtin_ia32_vfmaddpd512_maskz(A, B, C, D, E) __builtin_ia32_vfmaddpd512_maskz(A, B, C, D, 8)
#define __builtin_ia32_vfmaddps512_mask(A, B, C, D, E) __builtin_ia32_vfmaddps512_mask(A, B, C, D, 8)
#define __builtin_ia32_vfmaddps512_mask3(A, B, C, D, E) __builtin_ia32_vfmaddps512_mask3(A, B, C, D, 8)
#define __builtin_ia32_vfmaddps512_maskz(A, B, C, D, E) __builtin_ia32_vfmaddps512_maskz(A, B, C, D, 8)
#define __builtin_ia32_vfmaddsd3_round(A, B, C, D) __builtin_ia32_vfmaddsd3_round(A, B, C, 8)
#define __builtin_ia32_vfmaddss3_round(A, B, C, D) __builtin_ia32_vfmaddss3_round(A, B, C, 8)
#define __builtin_ia32_vfmaddsubpd512_mask(A, B, C, D, E) __builtin_ia32_vfmaddsubpd512_mask(A, B, C, D, 8)
#define __builtin_ia32_vfmaddsubpd512_mask3(A, B, C, D, E) __builtin_ia32_vfmaddsubpd512_mask3(A, B, C, D, 8)
#define __builtin_ia32_vfmaddsubpd512_maskz(A, B, C, D, E) __builtin_ia32_vfmaddsubpd512_maskz(A, B, C, D, 8)
#define __builtin_ia32_vfmaddsubps512_mask(A, B, C, D, E) __builtin_ia32_vfmaddsubps512_mask(A, B, C, D, 8)
#define __builtin_ia32_vfmaddsubps512_mask3(A, B, C, D, E) __builtin_ia32_vfmaddsubps512_mask3(A, B, C, D, 8)
#define __builtin_ia32_vfmaddsubps512_maskz(A, B, C, D, E) __builtin_ia32_vfmaddsubps512_maskz(A, B, C, D, 8)
#define __builtin_ia32_vfmsubaddpd512_mask3(A, B, C, D, E) __builtin_ia32_vfmsubaddpd512_mask3(A, B, C, D, 8)
#define __builtin_ia32_vfmsubaddps512_mask3(A, B, C, D, E) __builtin_ia32_vfmsubaddps512_mask3(A, B, C, D, 8)
#define __builtin_ia32_vfmsubpd512_mask3(A, B, C, D, E) __builtin_ia32_vfmsubpd512_mask3(A, B, C, D, 8)
#define __builtin_ia32_vfmsubps512_mask3(A, B, C, D, E) __builtin_ia32_vfmsubps512_mask3(A, B, C, D, 8)
#define __builtin_ia32_vfmsubsd3_mask3(A, B, C, D, E) __builtin_ia32_vfmsubsd3_mask3(A, B, C, D, 8)
#define __builtin_ia32_vfmsubss3_mask3(A, B, C, D, E) __builtin_ia32_vfmsubss3_mask3(A, B, C, D, 8)
#define __builtin_ia32_vfnmaddpd512_mask(A, B, C, D, E) __builtin_ia32_vfnmaddpd512_mask(A, B, C, D, 8)
#define __builtin_ia32_vfnmaddps512_mask(A, B, C, D, E) __builtin_ia32_vfnmaddps512_mask(A, B, C, D, 8)
#define __builtin_ia32_vfnmsubpd512_mask(A, B, C, D, E) __builtin_ia32_vfnmsubpd512_mask(A, B, C, D, 8)
#define __builtin_ia32_vfnmsubpd512_mask3(A, B, C, D, E) __builtin_ia32_vfnmsubpd512_mask3(A, B, C, D, 8)
#define __builtin_ia32_vfnmsubps512_mask(A, B, C, D, E) __builtin_ia32_vfnmsubps512_mask(A, B, C, D, 8)
#define __builtin_ia32_vfnmsubps512_mask3(A, B, C, D, E) __builtin_ia32_vfnmsubps512_mask3(A, B, C, D, 8)
#define __builtin_ia32_vpermilpd512_mask(A, E, C, D) __builtin_ia32_vpermilpd512_mask(A, 1, C, D)
#define __builtin_ia32_vpermilps512_mask(A, E, C, D) __builtin_ia32_vpermilps512_mask(A, 1, C, D)

/* avx512erintrin.h */
#define __builtin_ia32_exp2ps_mask(A, B, C, D) __builtin_ia32_exp2ps_mask(A, B, C, 8)
#define __builtin_ia32_exp2pd_mask(A, B, C, D) __builtin_ia32_exp2pd_mask(A, B, C, 8)
#define __builtin_ia32_rcp28ps_mask(A, B, C, D) __builtin_ia32_rcp28ps_mask(A, B, C, 8)
#define __builtin_ia32_rcp28pd_mask(A, B, C, D) __builtin_ia32_rcp28pd_mask(A, B, C, 8)
#define __builtin_ia32_rsqrt28ps_mask(A, B, C, D) __builtin_ia32_rsqrt28ps_mask(A, B, C, 8)
#define __builtin_ia32_rsqrt28pd_mask(A, B, C, D) __builtin_ia32_rsqrt28pd_mask(A, B, C, 8)
#define __builtin_ia32_rcp28ss_round(A, B, C) __builtin_ia32_rcp28ss_round(A, B, 8)
#define __builtin_ia32_rcp28sd_round(A, B, C) __builtin_ia32_rcp28sd_round(A, B, 8)
#define __builtin_ia32_rsqrt28ss_round(A, B, C) __builtin_ia32_rsqrt28ss_round(A, B, 8)
#define __builtin_ia32_rsqrt28sd_round(A, B, C) __builtin_ia32_rsqrt28sd_round(A, B, 8)

/* avx512pfintrin.h */
#define __builtin_ia32_gatherpfdps(A, B, C, D, E) __builtin_ia32_gatherpfdps(A, B, C, 1, _MM_HINT_T0)
#define __builtin_ia32_gatherpfqps(A, B, C, D, E) __builtin_ia32_gatherpfqps(A, B, C, 1, _MM_HINT_T0)
#define __builtin_ia32_scatterpfdps(A, B, C, D, E) __builtin_ia32_scatterpfdps(A, B, C, 1, _MM_HINT_T0)
#define __builtin_ia32_scatterpfqps(A, B, C, D, E) __builtin_ia32_scatterpfqps(A, B, C, 1, _MM_HINT_T0)
#define __builtin_ia32_gatherpfdpd(A, B, C, D, E) __builtin_ia32_gatherpfdpd(A, B, C, 1, _MM_HINT_T0)
#define __builtin_ia32_gatherpfqpd(A, B, C, D, E) __builtin_ia32_gatherpfqpd(A, B, C, 1, _MM_HINT_T0)
#define __builtin_ia32_scatterpfdpd(A, B, C, D, E) __builtin_ia32_scatterpfdpd(A, B, C, 1, _MM_HINT_T0)
#define __builtin_ia32_scatterpfqpd(A, B, C, D, E) __builtin_ia32_scatterpfqpd(A, B, C, 1, _MM_HINT_T0)

/* shaintrin.h */
#define __builtin_ia32_sha1rnds4(A, B, C) __builtin_ia32_sha1rnds4(A, B, 1)

/* avx512bwintrin.h */
#define __builtin_ia32_kshiftlisi(A, B) __builtin_ia32_kshiftlisi(A, 8)
#define __builtin_ia32_kshiftlidi(A, B) __builtin_ia32_kshiftlidi(A, 8)
#define __builtin_ia32_kshiftrisi(A, B) __builtin_ia32_kshiftrisi(A, 8)
#define __builtin_ia32_kshiftridi(A, B) __builtin_ia32_kshiftridi(A, 8)
#define __builtin_ia32_ucmpw512_mask(A, B, E, D) __builtin_ia32_ucmpw512_mask(A, B, 1, D)
#define __builtin_ia32_ucmpb512_mask(A, B, E, D) __builtin_ia32_ucmpb512_mask(A, B, 1, D)
#define __builtin_ia32_psrlwi512_mask(A, E, C, D) __builtin_ia32_psrlwi512_mask(A, 1, C, D)
#define __builtin_ia32_psrawi512_mask(A, E, C, D) __builtin_ia32_psrawi512_mask(A, 1, C, D)
#define __builtin_ia32_psllwi512_mask(A, E, C, D) __builtin_ia32_psllwi512_mask(A, 1, C, D)
#define __builtin_ia32_pshuflw512_mask(A, E, C, D) __builtin_ia32_pshuflw512_mask(A, 1, C, D)
#define __builtin_ia32_pshufhw512_mask(A, E, C, D) __builtin_ia32_pshufhw512_mask(A, 1, C, D)
#define __builtin_ia32_palignr512_mask(A, B, F, D, E) __builtin_ia32_palignr512_mask(A, B, 8, D, E)
#define __builtin_ia32_palignr512(A, B, D) __builtin_ia32_palignr512(A, B, 8)
#define __builtin_ia32_dbpsadbw512_mask(A, B, F, D, E) __builtin_ia32_dbpsadbw512_mask(A, B, 1, D, E)
#define __builtin_ia32_cmpw512_mask(A, B, E, D) __builtin_ia32_cmpw512_mask(A, B, 1, D)
#define __builtin_ia32_cmpb512_mask(A, B, E, D) __builtin_ia32_cmpb512_mask(A, B, 1, D)
#define __builtin_ia32_psrldq512(A, B) __builtin_ia32_psrldq512(A, 8)
#define __builtin_ia32_pslldq512(A, B) __builtin_ia32_pslldq512(A, 8)

/* avx512dqintrin.h */
#define __builtin_ia32_kshiftliqi(A, B) __builtin_ia32_kshiftliqi(A, 8)
#define __builtin_ia32_kshiftriqi(A, B) __builtin_ia32_kshiftriqi(A, 8)
#define __builtin_ia32_reducess_mask(A, B, F, W, U) __builtin_ia32_reducess_mask(A, B, 1, W, U)
#define __builtin_ia32_reducesd_mask(A, B, F, W, U) __builtin_ia32_reducesd_mask(A, B, 1, W, U)
#define __builtin_ia32_reduceps512_mask(A, E, C, D) __builtin_ia32_reduceps512_mask(A, 1, C, D)
#define __builtin_ia32_reducepd512_mask(A, E, C, D) __builtin_ia32_reducepd512_mask(A, 1, C, D)
#define __builtin_ia32_rangess128_mask_round(A, B, I, D, E, F) \
    __builtin_ia32_rangess128_mask_round(A, B, 1, D, E, 8)
#define __builtin_ia32_rangesd128_mask_round(A, B, I, D, E, F) \
    __builtin_ia32_rangesd128_mask_round(A, B, 1, D, E, 8)
#define __builtin_ia32_rangeps512_mask(A, B, I, D, E, F) __builtin_ia32_rangeps512_mask(A, B, 1, D, E, 8)
#define __builtin_ia32_rangepd512_mask(A, B, I, D, E, F) __builtin_ia32_rangepd512_mask(A, B, 1, D, E, 8)
#define __builtin_ia32_inserti64x2_512_mask(A, B, F, D, E) __builtin_ia32_inserti64x2_512_mask(A, B, 1, D, E)
#define __builtin_ia32_inserti32x8_mask(A, B, F, D, E) __builtin_ia32_inserti32x8_mask(A, B, 1, D, E)
#define __builtin_ia32_insertf64x2_512_mask(A, B, F, D, E) __builtin_ia32_insertf64x2_512_mask(A, B, 1, D, E)
#define __builtin_ia32_insertf32x8_mask(A, B, F, D, E) __builtin_ia32_insertf32x8_mask(A, B, 1, D, E)
#define __builtin_ia32_fpclassss(A, D) __builtin_ia32_fpclassss(A, 1)
#define __builtin_ia32_fpclasssd(A, D) __builtin_ia32_fpclasssd(A, 1)
#define __builtin_ia32_fpclassps512_mask(A, D, C) __builtin_ia32_fpclassps512_mask(A, 1, C)
#define __builtin_ia32_fpclasspd512_mask(A, D, C) __builtin_ia32_fpclasspd512_mask(A, 1, C)
#define __builtin_ia32_extracti64x2_512_mask(A, E, C, D) __builtin_ia32_extracti64x2_512_mask(A, 1, C, D)
#define __builtin_ia32_extracti32x8_mask(A, E, C, D) __builtin_ia32_extracti32x8_mask(A, 1, C, D)
#define __builtin_ia32_extractf64x2_512_mask(A, E, C, D) __builtin_ia32_extractf64x2_512_mask(A, 1, C, D)
#define __builtin_ia32_extractf32x8_mask(A, E, C, D) __builtin_ia32_extractf32x8_mask(A, 1, C, D)
#define __builtin_ia32_cvtuqq2ps512_mask(A, B, C, D) __builtin_ia32_cvtuqq2ps512_mask(A, B, C, 8)
#define __builtin_ia32_cvtuqq2pd512_mask(A, B, C, D) __builtin_ia32_cvtuqq2pd512_mask(A, B, C, 8)
#define __builtin_ia32_cvttps2uqq512_mask(A, B, C, D) __builtin_ia32_cvttps2uqq512_mask(A, B, C, 8)
#define __builtin_ia32_cvttps2qq512_mask(A, B, C, D) __builtin_ia32_cvttps2qq512_mask(A, B, C, 8)
#define __builtin_ia32_cvttpd2uqq512_mask(A, B, C, D) __builtin_ia32_cvttpd2uqq512_mask(A, B, C, 8)
#define __builtin_ia32_cvttpd2qq512_mask(A, B, C, D) __builtin_ia32_cvttpd2qq512_mask(A, B, C, 8)
#define __builtin_ia32_cvtqq2ps512_mask(A, B, C, D) __builtin_ia32_cvtqq2ps512_mask(A, B, C, 8)
#define __builtin_ia32_cvtqq2pd512_mask(A, B, C, D) __builtin_ia32_cvtqq2pd512_mask(A, B, C, 8)
#define __builtin_ia32_cvtps2uqq512_mask(A, B, C, D) __builtin_ia32_cvtps2uqq512_mask(A, B, C, 8)
#define __builtin_ia32_cvtps2qq512_mask(A, B, C, D) __builtin_ia32_cvtps2qq512_mask(A, B, C, 8)
#define __builtin_ia32_cvtpd2uqq512_mask(A, B, C, D) __builtin_ia32_cvtpd2uqq512_mask(A, B, C, 8)
#define __builtin_ia32_cvtpd2qq512_mask(A, B, C, D) __builtin_ia32_cvtpd2qq512_mask(A, B, C, 8)

/* avx512vlintrin.h */
#define __builtin_ia32_vpermilps_mask(A, E, C, D) __builtin_ia32_vpermilps_mask(A, 1, C, D)
#define __builtin_ia32_vpermilps256_mask(A, E, C, D) __builtin_ia32_vpermilps256_mask(A, 1, C, D)
#define __builtin_ia32_vpermilpd_mask(A, E, C, D) __builtin_ia32_vpermilpd_mask(A, 1, C, D)
#define __builtin_ia32_vpermilpd256_mask(A, E, C, D) __builtin_ia32_vpermilpd256_mask(A, 1, C, D)
#define __builtin_ia32_vcvtps2ph_mask(A, E, C, D) __builtin_ia32_vcvtps2ph_mask(A, 1, C, D)
#define __builtin_ia32_vcvtps2ph256_mask(A, E, C, D) __builtin_ia32_vcvtps2ph256_mask(A, 1, C, D)
#define __builtin_ia32_ucmpq256_mask(A, B, E, D) __builtin_ia32_ucmpq256_mask(A, B, 1, D)
#define __builtin_ia32_ucmpq128_mask(A, B, E, D) __builtin_ia32_ucmpq128_mask(A, B, 1, D)
#define __builtin_ia32_ucmpd256_mask(A, B, E, D) __builtin_ia32_ucmpd256_mask(A, B, 1, D)
#define __builtin_ia32_ucmpd128_mask(A, B, E, D) __builtin_ia32_ucmpd128_mask(A, B, 1, D)
#define __builtin_ia32_shufps256_mask(A, B, F, D, E) __builtin_ia32_shufps256_mask(A, B, 1, D, E)
#define __builtin_ia32_shufps128_mask(A, B, F, D, E) __builtin_ia32_shufps128_mask(A, B, 1, D, E)
#define __builtin_ia32_shufpd256_mask(A, B, F, D, E) __builtin_ia32_shufpd256_mask(A, B, 1, D, E)
#define __builtin_ia32_shufpd128_mask(A, B, F, D, E) __builtin_ia32_shufpd128_mask(A, B, 1, D, E)
#define __builtin_ia32_shuf_i64x2_256_mask(A, B, F, D, E) __builtin_ia32_shuf_i64x2_256_mask(A, B, 1, D, E)
#define __builtin_ia32_shuf_i32x4_256_mask(A, B, F, D, E) __builtin_ia32_shuf_i32x4_256_mask(A, B, 1, D, E)
#define __builtin_ia32_shuf_f64x2_256_mask(A, B, F, D, E) __builtin_ia32_shuf_f64x2_256_mask(A, B, 1, D, E)
#define __builtin_ia32_shuf_f32x4_256_mask(A, B, F, D, E) __builtin_ia32_shuf_f32x4_256_mask(A, B, 1, D, E)
#define __builtin_ia32_scattersiv8si(A, B, C, D, F) __builtin_ia32_scattersiv8si(A, B, C, D, 1)
#define __builtin_ia32_scattersiv8sf(A, B, C, D, F) __builtin_ia32_scattersiv8sf(A, B, C, D, 1)
#define __builtin_ia32_scattersiv4si(A, B, C, D, F) __builtin_ia32_scattersiv4si(A, B, C, D, 1)
#define __builtin_ia32_scattersiv4sf(A, B, C, D, F) __builtin_ia32_scattersiv4sf(A, B, C, D, 1)
#define __builtin_ia32_scattersiv4di(A, B, C, D, F) __builtin_ia32_scattersiv4di(A, B, C, D, 1)
#define __builtin_ia32_scattersiv4df(A, B, C, D, F) __builtin_ia32_scattersiv4df(A, B, C, D, 1)
#define __builtin_ia32_scattersiv2di(A, B, C, D, F) __builtin_ia32_scattersiv2di(A, B, C, D, 1)
#define __builtin_ia32_scattersiv2df(A, B, C, D, F) __builtin_ia32_scattersiv2df(A, B, C, D, 1)
#define __builtin_ia32_scatterdiv8si(A, B, C, D, F) __builtin_ia32_scatterdiv8si(A, B, C, D, 1)
#define __builtin_ia32_scatterdiv8sf(A, B, C, D, F) __builtin_ia32_scatterdiv8sf(A, B, C, D, 1)
#define __builtin_ia32_scatterdiv4si(A, B, C, D, F) __builtin_ia32_scatterdiv4si(A, B, C, D, 1)
#define __builtin_ia32_scatterdiv4sf(A, B, C, D, F) __builtin_ia32_scatterdiv4sf(A, B, C, D, 1)
#define __builtin_ia32_scatterdiv4di(A, B, C, D, F) __builtin_ia32_scatterdiv4di(A, B, C, D, 1)
#define __builtin_ia32_scatterdiv4df(A, B, C, D, F) __builtin_ia32_scatterdiv4df(A, B, C, D, 1)
#define __builtin_ia32_scatterdiv2di(A, B, C, D, F) __builtin_ia32_scatterdiv2di(A, B, C, D, 1)
#define __builtin_ia32_scatterdiv2df(A, B, C, D, F) __builtin_ia32_scatterdiv2df(A, B, C, D, 1)
#define __builtin_ia32_rndscaleps_256_mask(A, E, C, D) __builtin_ia32_rndscaleps_256_mask(A, 1, C, D)
#define __builtin_ia32_rndscaleps_128_mask(A, E, C, D) __builtin_ia32_rndscaleps_128_mask(A, 1, C, D)
#define __builtin_ia32_rndscalepd_256_mask(A, E, C, D) __builtin_ia32_rndscalepd_256_mask(A, 1, C, D)
#define __builtin_ia32_rndscalepd_128_mask(A, E, C, D) __builtin_ia32_rndscalepd_128_mask(A, 1, C, D)
#define __builtin_ia32_pternlogq256_maskz(A, B, C, F, E) __builtin_ia32_pternlogq256_maskz(A, B, C, 1, E)
#define __builtin_ia32_pternlogq256_mask(A, B, C, F, E) __builtin_ia32_pternlogq256_mask(A, B, C, 1, E)
#define __builtin_ia32_pternlogq128_maskz(A, B, C, F, E) __builtin_ia32_pternlogq128_maskz(A, B, C, 1, E)
#define __builtin_ia32_pternlogq128_mask(A, B, C, F, E) __builtin_ia32_pternlogq128_mask(A, B, C, 1, E)
#define __builtin_ia32_pternlogd256_maskz(A, B, C, F, E) __builtin_ia32_pternlogd256_maskz(A, B, C, 1, E)
#define __builtin_ia32_pternlogd256_mask(A, B, C, F, E) __builtin_ia32_pternlogd256_mask(A, B, C, 1, E)
#define __builtin_ia32_pternlogd128_maskz(A, B, C, F, E) __builtin_ia32_pternlogd128_maskz(A, B, C, 1, E)
#define __builtin_ia32_pternlogd128_mask(A, B, C, F, E) __builtin_ia32_pternlogd128_mask(A, B, C, 1, E)
#define __builtin_ia32_psrlqi256_mask(A, E, C, D) __builtin_ia32_psrlqi256_mask(A, 1, C, D)
#define __builtin_ia32_psrlqi128_mask(A, E, C, D) __builtin_ia32_psrlqi128_mask(A, 1, C, D)
#define __builtin_ia32_psrldi256_mask(A, E, C, D) __builtin_ia32_psrldi256_mask(A, 1, C, D)
#define __builtin_ia32_psrldi128_mask(A, E, C, D) __builtin_ia32_psrldi128_mask(A, 1, C, D)
#define __builtin_ia32_psraqi256_mask(A, E, C, D) __builtin_ia32_psraqi256_mask(A, 1, C, D)
#define __builtin_ia32_psraqi128_mask(A, E, C, D) __builtin_ia32_psraqi128_mask(A, 1, C, D)
#define __builtin_ia32_psradi256_mask(A, E, C, D) __builtin_ia32_psradi256_mask(A, 1, C, D)
#define __builtin_ia32_psradi128_mask(A, E, C, D) __builtin_ia32_psradi128_mask(A, 1, C, D)
#define __builtin_ia32_psllqi256_mask(A, E, C, D) __builtin_ia32_psllqi256_mask(A, 1, C, D)
#define __builtin_ia32_psllqi128_mask(A, E, C, D) __builtin_ia32_psllqi128_mask(A, 1, C, D)
#define __builtin_ia32_pslldi256_mask(A, E, C, D) __builtin_ia32_pslldi256_mask(A, 1, C, D)
#define __builtin_ia32_pslldi128_mask(A, E, C, D) __builtin_ia32_pslldi128_mask(A, 1, C, D)
#define __builtin_ia32_pshufd256_mask(A, E, C, D) __builtin_ia32_pshufd256_mask(A, 1, C, D)
#define __builtin_ia32_pshufd128_mask(A, E, C, D) __builtin_ia32_pshufd128_mask(A, 1, C, D)
#define __builtin_ia32_prorq256_mask(A, E, C, D) __builtin_ia32_prorq256_mask(A, 1, C, D)
#define __builtin_ia32_prorq128_mask(A, E, C, D) __builtin_ia32_prorq128_mask(A, 1, C, D)
#define __builtin_ia32_prord256_mask(A, E, C, D) __builtin_ia32_prord256_mask(A, 1, C, D)
#define __builtin_ia32_prord128_mask(A, E, C, D) __builtin_ia32_prord128_mask(A, 1, C, D)
#define __builtin_ia32_prolq256_mask(A, E, C, D) __builtin_ia32_prolq256_mask(A, 1, C, D)
#define __builtin_ia32_prolq128_mask(A, E, C, D) __builtin_ia32_prolq128_mask(A, 1, C, D)
#define __builtin_ia32_prold256_mask(A, E, C, D) __builtin_ia32_prold256_mask(A, 1, C, D)
#define __builtin_ia32_prold128_mask(A, E, C, D) __builtin_ia32_prold128_mask(A, 1, C, D)
#define __builtin_ia32_permdi256_mask(A, E, C, D) __builtin_ia32_permdi256_mask(A, 1, C, D)
#define __builtin_ia32_permdf256_mask(A, E, C, D) __builtin_ia32_permdf256_mask(A, 1, C, D)
#define __builtin_ia32_inserti32x4_256_mask(A, B, F, D, E) __builtin_ia32_inserti32x4_256_mask(A, B, 1, D, E)
#define __builtin_ia32_insertf32x4_256_mask(A, B, F, D, E) __builtin_ia32_insertf32x4_256_mask(A, B, 1, D, E)
#define __builtin_ia32_getmantps256_mask(A, E, C, D) __builtin_ia32_getmantps256_mask(A, 1, C, D)
#define __builtin_ia32_getmantps128_mask(A, E, C, D) __builtin_ia32_getmantps128_mask(A, 1, C, D)
#define __builtin_ia32_getmantpd256_mask(A, E, C, D) __builtin_ia32_getmantpd256_mask(A, 1, C, D)
#define __builtin_ia32_getmantpd128_mask(A, E, C, D) __builtin_ia32_getmantpd128_mask(A, 1, C, D)
#define __builtin_ia32_gather3siv8si(A, B, C, D, F) __builtin_ia32_gather3siv8si(A, B, C, D, 1)
#define __builtin_ia32_gather3siv8sf(A, B, C, D, F) __builtin_ia32_gather3siv8sf(A, B, C, D, 1)
#define __builtin_ia32_gather3siv4si(A, B, C, D, F) __builtin_ia32_gather3siv4si(A, B, C, D, 1)
#define __builtin_ia32_gather3siv4sf(A, B, C, D, F) __builtin_ia32_gather3siv4sf(A, B, C, D, 1)
#define __builtin_ia32_gather3siv4di(A, B, C, D, F) __builtin_ia32_gather3siv4di(A, B, C, D, 1)
#define __builtin_ia32_gather3siv4df(A, B, C, D, F) __builtin_ia32_gather3siv4df(A, B, C, D, 1)
#define __builtin_ia32_gather3siv2di(A, B, C, D, F) __builtin_ia32_gather3siv2di(A, B, C, D, 1)
#define __builtin_ia32_gather3siv2df(A, B, C, D, F) __builtin_ia32_gather3siv2df(A, B, C, D, 1)
#define __builtin_ia32_gather3div8si(A, B, C, D, F) __builtin_ia32_gather3div8si(A, B, C, D, 1)
#define __builtin_ia32_gather3div8sf(A, B, C, D, F) __builtin_ia32_gather3div8sf(A, B, C, D, 1)
#define __builtin_ia32_gather3div4si(A, B, C, D, F) __builtin_ia32_gather3div4si(A, B, C, D, 1)
#define __builtin_ia32_gather3div4sf(A, B, C, D, F) __builtin_ia32_gather3div4sf(A, B, C, D, 1)
#define __builtin_ia32_gather3div4di(A, B, C, D, F) __builtin_ia32_gather3div4di(A, B, C, D, 1)
#define __builtin_ia32_gather3div4df(A, B, C, D, F) __builtin_ia32_gather3div4df(A, B, C, D, 1)
#define __builtin_ia32_gather3div2di(A, B, C, D, F) __builtin_ia32_gather3div2di(A, B, C, D, 1)
#define __builtin_ia32_gather3div2df(A, B, C, D, F) __builtin_ia32_gather3div2df(A, B, C, D, 1)
#define __builtin_ia32_fixupimmps256_maskz(A, B, C, F, E) __builtin_ia32_fixupimmps256_maskz(A, B, C, 1, E)
#define __builtin_ia32_fixupimmps256_mask(A, B, C, F, E) __builtin_ia32_fixupimmps256_mask(A, B, C, 1, E)
#define __builtin_ia32_fixupimmps128_maskz(A, B, C, F, E) __builtin_ia32_fixupimmps128_maskz(A, B, C, 1, E)
#define __builtin_ia32_fixupimmps128_mask(A, B, C, F, E) __builtin_ia32_fixupimmps128_mask(A, B, C, 1, E)
#define __builtin_ia32_fixupimmpd256_maskz(A, B, C, F, E) __builtin_ia32_fixupimmpd256_maskz(A, B, C, 1, E)
#define __builtin_ia32_fixupimmpd256_mask(A, B, C, F, E) __builtin_ia32_fixupimmpd256_mask(A, B, C, 1, E)
#define __builtin_ia32_fixupimmpd128_maskz(A, B, C, F, E) __builtin_ia32_fixupimmpd128_maskz(A, B, C, 1, E)
#define __builtin_ia32_fixupimmpd128_mask(A, B, C, F, E) __builtin_ia32_fixupimmpd128_mask(A, B, C, 1, E)
#define __builtin_ia32_extracti32x4_256_mask(A, E, C, D) __builtin_ia32_extracti32x4_256_mask(A, 1, C, D)
#define __builtin_ia32_extractf32x4_256_mask(A, E, C, D) __builtin_ia32_extractf32x4_256_mask(A, 1, C, D)
#define __builtin_ia32_cmpq256_mask(A, B, E, D) __builtin_ia32_cmpq256_mask(A, B, 1, D)
#define __builtin_ia32_cmpq128_mask(A, B, E, D) __builtin_ia32_cmpq128_mask(A, B, 1, D)
#define __builtin_ia32_cmpps256_mask(A, B, E, D) __builtin_ia32_cmpps256_mask(A, B, 1, D)
#define __builtin_ia32_cmpps128_mask(A, B, E, D) __builtin_ia32_cmpps128_mask(A, B, 1, D)
#define __builtin_ia32_cmppd256_mask(A, B, E, D) __builtin_ia32_cmppd256_mask(A, B, 1, D)
#define __builtin_ia32_cmppd128_mask(A, B, E, D) __builtin_ia32_cmppd128_mask(A, B, 1, D)
#define __builtin_ia32_cmpd256_mask(A, B, E, D) __builtin_ia32_cmpd256_mask(A, B, 1, D)
#define __builtin_ia32_cmpd128_mask(A, B, E, D) __builtin_ia32_cmpd128_mask(A, B, 1, D)
#define __builtin_ia32_alignq256_mask(A, B, F, D, E) __builtin_ia32_alignq256_mask(A, B, 1, D, E)
#define __builtin_ia32_alignq128_mask(A, B, F, D, E) __builtin_ia32_alignq128_mask(A, B, 1, D, E)
#define __builtin_ia32_alignd256_mask(A, B, F, D, E) __builtin_ia32_alignd256_mask(A, B, 1, D, E)
#define __builtin_ia32_alignd128_mask(A, B, F, D, E) __builtin_ia32_alignd128_mask(A, B, 1, D, E)

/* avx512vlbwintrin.h */
#define __builtin_ia32_ucmpw256_mask(A, B, E, D) __builtin_ia32_ucmpw256_mask(A, B, 1, D)
#define __builtin_ia32_ucmpw128_mask(A, B, E, D) __builtin_ia32_ucmpw128_mask(A, B, 1, D)
#define __builtin_ia32_ucmpb256_mask(A, B, E, D) __builtin_ia32_ucmpb256_mask(A, B, 1, D)
#define __builtin_ia32_ucmpb128_mask(A, B, E, D) __builtin_ia32_ucmpb128_mask(A, B, 1, D)
#define __builtin_ia32_psrlwi256_mask(A, E, C, D) __builtin_ia32_psrlwi256_mask(A, 1, C, D)
#define __builtin_ia32_psrlwi128_mask(A, E, C, D) __builtin_ia32_psrlwi128_mask(A, 1, C, D)
#define __builtin_ia32_psrawi256_mask(A, E, C, D) __builtin_ia32_psrawi256_mask(A, 1, C, D)
#define __builtin_ia32_psrawi128_mask(A, E, C, D) __builtin_ia32_psrawi128_mask(A, 1, C, D)
#define __builtin_ia32_psllwi256_mask(A, E, C, D) __builtin_ia32_psllwi256_mask(A, 1, C, D)
#define __builtin_ia32_psllwi128_mask(A, E, C, D) __builtin_ia32_psllwi128_mask(A, 1, C, D)
#define __builtin_ia32_pshuflw256_mask(A, E, C, D) __builtin_ia32_pshuflw256_mask(A, 1, C, D)
#define __builtin_ia32_pshuflw128_mask(A, E, C, D) __builtin_ia32_pshuflw128_mask(A, 1, C, D)
#define __builtin_ia32_pshufhw256_mask(A, E, C, D) __builtin_ia32_pshufhw256_mask(A, 1, C, D)
#define __builtin_ia32_pshufhw128_mask(A, E, C, D) __builtin_ia32_pshufhw128_mask(A, 1, C, D)
#define __builtin_ia32_palignr256_mask(A, B, F, D, E) __builtin_ia32_palignr256_mask(A, B, 8, D, E)
#define __builtin_ia32_palignr128_mask(A, B, F, D, E) __builtin_ia32_palignr128_mask(A, B, 8, D, E)
#define __builtin_ia32_dbpsadbw256_mask(A, B, F, D, E) __builtin_ia32_dbpsadbw256_mask(A, B, 1, D, E)
#define __builtin_ia32_dbpsadbw128_mask(A, B, F, D, E) __builtin_ia32_dbpsadbw128_mask(A, B, 1, D, E)
#define __builtin_ia32_cmpw256_mask(A, B, E, D) __builtin_ia32_cmpw256_mask(A, B, 1, D)
#define __builtin_ia32_cmpw128_mask(A, B, E, D) __builtin_ia32_cmpw128_mask(A, B, 1, D)
#define __builtin_ia32_cmpb256_mask(A, B, E, D) __builtin_ia32_cmpb256_mask(A, B, 1, D)
#define __builtin_ia32_cmpb128_mask(A, B, E, D) __builtin_ia32_cmpb128_mask(A, B, 1, D)

/* avx512vldqintrin.h */
#define __builtin_ia32_reduceps256_mask(A, E, C, D) __builtin_ia32_reduceps256_mask(A, 1, C, D)
#define __builtin_ia32_reduceps128_mask(A, E, C, D) __builtin_ia32_reduceps128_mask(A, 1, C, D)
#define __builtin_ia32_reducepd256_mask(A, E, C, D) __builtin_ia32_reducepd256_mask(A, 1, C, D)
#define __builtin_ia32_reducepd128_mask(A, E, C, D) __builtin_ia32_reducepd128_mask(A, 1, C, D)
#define __builtin_ia32_rangeps256_mask(A, B, F, D, E) __builtin_ia32_rangeps256_mask(A, B, 1, D, E)
#define __builtin_ia32_rangeps128_mask(A, B, F, D, E) __builtin_ia32_rangeps128_mask(A, B, 1, D, E)
#define __builtin_ia32_rangepd256_mask(A, B, F, D, E) __builtin_ia32_rangepd256_mask(A, B, 1, D, E)
#define __builtin_ia32_rangepd128_mask(A, B, F, D, E) __builtin_ia32_rangepd128_mask(A, B, 1, D, E)
#define __builtin_ia32_inserti64x2_256_mask(A, B, F, D, E) __builtin_ia32_inserti64x2_256_mask(A, B, 1, D, E)
#define __builtin_ia32_insertf64x2_256_mask(A, B, F, D, E) __builtin_ia32_insertf64x2_256_mask(A, B, 1, D, E)
#define __builtin_ia32_fpclassps256_mask(A, D, C) __builtin_ia32_fpclassps256_mask(A, 1, C)
#define __builtin_ia32_fpclassps128_mask(A, D, C) __builtin_ia32_fpclassps128_mask(A, 1, C)
#define __builtin_ia32_fpclasspd256_mask(A, D, C) __builtin_ia32_fpclasspd256_mask(A, 1, C)
#define __builtin_ia32_fpclasspd128_mask(A, D, C) __builtin_ia32_fpclasspd128_mask(A, 1, C)
#define __builtin_ia32_extracti64x2_256_mask(A, E, C, D) __builtin_ia32_extracti64x2_256_mask(A, 1, C, D)
#define __builtin_ia32_extractf64x2_256_mask(A, E, C, D) __builtin_ia32_extractf64x2_256_mask(A, 1, C, D)

/* gfniintrin.h */
#define __builtin_ia32_vgf2p8affineinvqb_v16qi(A, B, C) __builtin_ia32_vgf2p8affineinvqb_v16qi(A, B, 1) 
#define __builtin_ia32_vgf2p8affineinvqb_v32qi(A, B, C) __builtin_ia32_vgf2p8affineinvqb_v32qi(A, B, 1)
#define __builtin_ia32_vgf2p8affineinvqb_v64qi(A, B, C) __builtin_ia32_vgf2p8affineinvqb_v64qi(A, B, 1)
#define __builtin_ia32_vgf2p8affineinvqb_v16qi_mask(A, B, C, D, E) __builtin_ia32_vgf2p8affineinvqb_v16qi_mask(A, B, 1, D, E) 
#define __builtin_ia32_vgf2p8affineinvqb_v32qi_mask(A, B, C, D, E) __builtin_ia32_vgf2p8affineinvqb_v32qi_mask(A, B, 1, D, E) 
#define __builtin_ia32_vgf2p8affineinvqb_v64qi_mask(A, B, C, D, E) __builtin_ia32_vgf2p8affineinvqb_v64qi_mask(A, B, 1, D, E) 
#define __builtin_ia32_vgf2p8affineqb_v16qi(A, B, C) __builtin_ia32_vgf2p8affineqb_v16qi(A, B, 1) 
#define __builtin_ia32_vgf2p8affineqb_v32qi(A, B, C) __builtin_ia32_vgf2p8affineqb_v32qi(A, B, 1)
#define __builtin_ia32_vgf2p8affineqb_v64qi(A, B, C) __builtin_ia32_vgf2p8affineqb_v64qi(A, B, 1)
#define __builtin_ia32_vgf2p8affineqb_v16qi_mask(A, B, C, D, E) __builtin_ia32_vgf2p8affineqb_v16qi_mask(A, B, 1, D, E) 
#define __builtin_ia32_vgf2p8affineqb_v32qi_mask(A, B, C, D, E) __builtin_ia32_vgf2p8affineqb_v32qi_mask(A, B, 1, D, E) 
#define __builtin_ia32_vgf2p8affineqb_v64qi_mask(A, B, C, D, E) __builtin_ia32_vgf2p8affineqb_v64qi_mask(A, B, 1, D, E) 

/* avx512vbmi2intrin.h */
#define __builtin_ia32_vpshrd_v32hi(A, B, C) __builtin_ia32_vpshrd_v32hi(A, B, 1)
#define __builtin_ia32_vpshrd_v32hi_mask(A, B, C, D, E)  __builtin_ia32_vpshrd_v32hi_mask(A, B, 1, D, E)
#define __builtin_ia32_vpshrd_v16si(A, B, C) __builtin_ia32_vpshrd_v16si(A, B, 1)
#define __builtin_ia32_vpshrd_v16si_mask(A, B, C, D, E)  __builtin_ia32_vpshrd_v16si_mask(A, B, 1, D, E)
#define __builtin_ia32_vpshrd_v8di(A, B, C) __builtin_ia32_vpshrd_v8di(A, B, 1)
#define __builtin_ia32_vpshrd_v8di_mask(A, B, C, D, E)  __builtin_ia32_vpshrd_v8di_mask(A, B, 1, D, E)
#define __builtin_ia32_vpshrd_v16hi(A, B, C) __builtin_ia32_vpshrd_v16hi(A, B, 1)
#define __builtin_ia32_vpshrd_v16hi_mask(A, B, C, D, E)  __builtin_ia32_vpshrd_v16hi_mask(A, B, 1, D, E)
#define __builtin_ia32_vpshrd_v8si(A, B, C) __builtin_ia32_vpshrd_v8si(A, B, 1)
#define __builtin_ia32_vpshrd_v8si_mask(A, B, C, D, E)  __builtin_ia32_vpshrd_v8si_mask(A, B, 1, D, E)
#define __builtin_ia32_vpshrd_v4di(A, B, C) __builtin_ia32_vpshrd_v4di(A, B, 1)
#define __builtin_ia32_vpshrd_v4di_mask(A, B, C, D, E)  __builtin_ia32_vpshrd_v4di_mask(A, B, 1, D, E)
#define __builtin_ia32_vpshrd_v8hi(A, B, C) __builtin_ia32_vpshrd_v8hi(A, B, 1)
#define __builtin_ia32_vpshrd_v8hi_mask(A, B, C, D, E)  __builtin_ia32_vpshrd_v8hi_mask(A, B, 1, D, E)
#define __builtin_ia32_vpshrd_v4si(A, B, C) __builtin_ia32_vpshrd_v4si(A, B, 1)
#define __builtin_ia32_vpshrd_v4si_mask(A, B, C, D, E)  __builtin_ia32_vpshrd_v4si_mask(A, B, 1, D, E)
#define __builtin_ia32_vpshrd_v2di(A, B, C) __builtin_ia32_vpshrd_v2di(A, B, 1)
#define __builtin_ia32_vpshrd_v2di_mask(A, B, C, D, E)  __builtin_ia32_vpshrd_v2di_mask(A, B, 1, D, E)
#define __builtin_ia32_vpshld_v32hi(A, B, C) __builtin_ia32_vpshld_v32hi(A, B, 1)
#define __builtin_ia32_vpshld_v32hi_mask(A, B, C, D, E)  __builtin_ia32_vpshld_v32hi_mask(A, B, 1, D, E)
#define __builtin_ia32_vpshld_v16si(A, B, C) __builtin_ia32_vpshld_v16si(A, B, 1)
#define __builtin_ia32_vpshld_v16si_mask(A, B, C, D, E)  __builtin_ia32_vpshld_v16si_mask(A, B, 1, D, E)
#define __builtin_ia32_vpshld_v8di(A, B, C) __builtin_ia32_vpshld_v8di(A, B, 1)
#define __builtin_ia32_vpshld_v8di_mask(A, B, C, D, E)  __builtin_ia32_vpshld_v8di_mask(A, B, 1, D, E)
#define __builtin_ia32_vpshld_v16hi(A, B, C) __builtin_ia32_vpshld_v16hi(A, B, 1)
#define __builtin_ia32_vpshld_v16hi_mask(A, B, C, D, E)  __builtin_ia32_vpshld_v16hi_mask(A, B, 1, D, E)
#define __builtin_ia32_vpshld_v8si(A, B, C) __builtin_ia32_vpshld_v8si(A, B, 1)
#define __builtin_ia32_vpshld_v8si_mask(A, B, C, D, E)  __builtin_ia32_vpshld_v8si_mask(A, B, 1, D, E)
#define __builtin_ia32_vpshld_v4di(A, B, C) __builtin_ia32_vpshld_v4di(A, B, 1)
#define __builtin_ia32_vpshld_v4di_mask(A, B, C, D, E)  __builtin_ia32_vpshld_v4di_mask(A, B, 1, D, E)
#define __builtin_ia32_vpshld_v8hi(A, B, C) __builtin_ia32_vpshld_v8hi(A, B, 1)
#define __builtin_ia32_vpshld_v8hi_mask(A, B, C, D, E)  __builtin_ia32_vpshld_v8hi_mask(A, B, 1, D, E)
#define __builtin_ia32_vpshld_v4si(A, B, C) __builtin_ia32_vpshld_v4si(A, B, 1)
#define __builtin_ia32_vpshld_v4si_mask(A, B, C, D, E)  __builtin_ia32_vpshld_v4si_mask(A, B, 1, D, E)
#define __builtin_ia32_vpshld_v2di(A, B, C) __builtin_ia32_vpshld_v2di(A, B, 1)
#define __builtin_ia32_vpshld_v2di_mask(A, B, C, D, E)  __builtin_ia32_vpshld_v2di_mask(A, B, 1, D, E)

/* vpclmulqdqintrin.h */
#define __builtin_ia32_vpclmulqdq_v4di(A, B, C)  __builtin_ia32_vpclmulqdq_v4di(A, B, 1) 
#define __builtin_ia32_vpclmulqdq_v2di(A, B, C)  __builtin_ia32_vpclmulqdq_v2di(A, B, 1) 
#define __builtin_ia32_vpclmulqdq_v8di(A, B, C)  __builtin_ia32_vpclmulqdq_v8di(A, B, 1) 

#include <x86intrin.h>
