/*  GNU Moe - My Own Editor
    Copyright (C) 2005, 2006, 2007, 2008, 2009 Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

namespace Screen {

enum Keys { key_up, key_down, key_left, key_right, key_npage, key_ppage,
            key_home, key_end, key_invalid };

bool init();

//void beep() throw();

const std::string & clock_string() throw();

extern "C" void clock_handler( int sig ) throw();	// Updates the clock.

int kbhit();			// Returns -1 if no key is available.

// Wait for a keystroke. Returns -1 if no key is available.
// The clock only blinks when waiting here for a keystroke.
// The screen is also only refreshed here (and in clock_handler).
// This function is the real "main loop" of the program.
//
int wait_kbhit( const int new_clock_limit = -1, const bool get_key = true,
                const bool force_refresh = false );


// 'history.back()' contains the default result (may be empty), and
// stores the result (if any).
// Returns the size of the result string, 0 if none, -1 if aborted.
//
int get_string( const std::string & prompt,
                std::vector< std::string > & history,
                const int abort_key = 3,
                const bool allow_copy = false, const bool usetab = false );


int height() throw();
int width() throw();
int max_windows() throw();

void move_to( const Point & cursor ) throw();
void save_cursor( Point & cursor ) throw();
void save_lines_and_cursor( const int line, const int lines );
void restore_lines_and_cursor() throw();

void out_buffer_line( const Buffer & buffer, Point c, const int line ) throw();
bool out_line( const std::string & s, const int line, const bool shift = false,
               const char mode = 0 ) throw();
bool out_menu_line( const std::string & s, const int line,
                    const int hbegin = -1, const int hend = -1 ) throw();
void repaint( const Buffer * bufp = 0 ) throw();
int show_message( const std::string & s, const bool get_key = false,
                  const bool take_cursor = false );
void show_status_lines( const Buffer * bufp = 0 ) throw();

Keys convert_key( const int key ) throw();
int user_loop( const std::string & version_msg ) throw();

} // end namespace Screen
