/*
  This file is part of GNU Taler
  Copyright (C) 2012-2025 Taler Systems SA

  GNU Taler is free software: you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as published
  by the Free Software Foundation, either version 3 of the License,
  or (at your option) any later version.

  GNU Taler is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.

  SPDX-License-Identifier: LGPL3.0-or-later

  Note: the LGPL does not apply to all components of GNU Taler,
  but it does apply to this file.
 */

export enum TalerSignaturePurpose {


  /**
   * Initialize or update the status of an AML key for an AML officer
   */
  MASTER_AML_KEY = 1017,


  /**
   * Affirm wiring of exchange profits to operator account.
   */
  MASTER_DRAIN_PROFIT = 1018,


  /**
   * Signature affirming a partner configuration for wads.
   */
  MASTER_PARTNER_DETAILS = 1019,


  /**
   * The given revocation key was revoked and must no longer be used.
   */
  MASTER_SIGNING_KEY_REVOKED = 1020,


  /**
   * Add payto URI to the list of our wire methods.
   */
  MASTER_ADD_WIRE = 1021,


  /**
   * Signature over global set of fees charged by the exchange.
   */
  MASTER_GLOBAL_FEES = 1022,


  /**
   * Remove payto URI from the list of our wire methods.
   */
  MASTER_DEL_WIRE = 1023,


  /**
   * Purpose for signing public keys signed by the exchange master key.
   */
  MASTER_SIGNING_KEY_VALIDITY = 1024,


  /**
   * Purpose for denomination keys signed by the exchange master key.
   */
  MASTER_DENOMINATION_KEY_VALIDITY = 1025,


  /**
   * Add an auditor to the list of our auditors.
   */
  MASTER_ADD_AUDITOR = 1026,


  /**
   * Remove an auditor from the list of our auditors.
   */
  MASTER_DEL_AUDITOR = 1027,


  /**
   * Fees charged per (aggregate) wire transfer to the merchant.
   */
  MASTER_WIRE_FEES = 1028,


  /**
   * The given revocation key was revoked and must no longer be used.
   */
  MASTER_DENOMINATION_KEY_REVOKED = 1029,


  /**
   * Signature where the Exchange confirms its IBAN details in the /wire response.
   */
  MASTER_WIRE_DETAILS = 1030,


  /**
   * Set the configuration of an extension (age-restriction or peer2peer)
   */
  MASTER_EXTENSION = 1031,


  /**
   * Purpose for the state of a reserve, signed by the exchange's signing key.
   */
  EXCHANGE_RESERVE_STATUS = 1032,


  /**
   * Signature where the Exchange confirms a deposit request.
   */
  EXCHANGE_CONFIRM_DEPOSIT = 1033,


  /**
   * Signature where the exchange (current signing key) confirms the no-reveal index for cut-and-choose and the validity of the melted coins.
   */
  EXCHANGE_CONFIRM_MELT = 1034,


  /**
   * Signature where the Exchange confirms the full /keys response set.
   */
  EXCHANGE_KEY_SET = 1035,


  /**
   * Signature where the Exchange confirms the /track/transaction response.
   */
  EXCHANGE_CONFIRM_WIRE = 1036,


  /**
   * Signature where the Exchange confirms the /wire/deposit response.
   */
  EXCHANGE_CONFIRM_WIRE_DEPOSIT = 1037,


  /**
   * Signature where the Exchange confirms a refund request.
   */
  EXCHANGE_CONFIRM_REFUND = 1038,


  /**
   * Signature where the Exchange confirms a recoup.
   */
  EXCHANGE_CONFIRM_RECOUP = 1039,


  /**
   * Signature where the Exchange confirms it closed a reserve.
   */
  EXCHANGE_RESERVE_CLOSED = 1040,


  /**
   * Signature where the Exchange confirms a recoup-refresh operation.
   */
  EXCHANGE_CONFIRM_RECOUP_REFRESH = 1041,


  /**
   * Signature where the Exchange confirms that it does not know a denomination (hash).
   */
  EXCHANGE_AFFIRM_DENOM_UNKNOWN = 1042,


  /**
   * Signature where the Exchange confirms that it does not consider a denomination valid for the given operation at this time.
   */
  EXCHANGE_AFFIRM_DENOM_EXPIRED = 1043,


  /**
   * Signature by which the exchange affirms that a purse was created with a certain amount deposited into it.
   */
  EXCHANGE_CONFIRM_PURSE_CREATION = 1045,


  /**
   * Signature by which the exchange affirms that a purse was merged into a reserve with a certain amount in it.
   */
  EXCHANGE_CONFIRM_PURSE_MERGED = 1046,


  /**
   * Purpose for the state of a purse, signed by the exchange's signing key.
   */
  EXCHANGE_PURSE_STATUS = 1047,


  /**
   * Signature by which the exchange attests identity attributes of a particular reserve owner.
   */
  EXCHANGE_RESERVE_ATTEST_DETAILS = 1048,


  /**
   * Signature by which the exchange confirms that a purse expired and a coin was refunded.
   */
  EXCHANGE_CONFIRM_PURSE_REFUND = 1049,


  /**
   * Signature where the Exchange confirms an (age-)withdraw.
   */
  EXCHANGE_CONFIRM_WITHDRAW = 1050,


  /**
   * Signature where the auditor confirms that he is aware of certain denomination keys from the exchange.
   */
  AUDITOR_EXCHANGE_KEYS = 1064,


  /**
   * Signature where the merchant confirms a contract (to the customer).
   */
  MERCHANT_CONTRACT = 1101,


  /**
   * Signature where the merchant confirms a refund (of a coin).
   */
  MERCHANT_REFUND = 1102,


  /**
   * Signature where the merchant confirms that he needs the wire transfer identifier for a deposit operation.
   */
  MERCHANT_TRACK_TRANSACTION = 1103,


  /**
   * Signature where the merchant confirms that the payment was successful
   */
  MERCHANT_PAYMENT_OK = 1104,


  /**
   * Signature where the merchant confirms its own (salted) wire details (not yet really used).
   */
  MERCHANT_WIRE_DETAILS = 1107,


  /**
   * Signature where the merchant issues a token by blindly signing it. Signed with the token issue private key.
   */
  MERCHANT_TOKEN_ISSUE = 1108,


  /**
   * Signature where the reserve key confirms a withdraw request. Signed with the reserve private key.
   */
  WALLET_RESERVE_WITHDRAW = 1200,


  /**
   * Signature made by the wallet of a user to confirm a deposit of a coin.
   */
  WALLET_COIN_DEPOSIT = 1201,


  /**
   * Signature using a coin key confirming the melting of a coin. Signed with the coin's private key.
   */
  WALLET_COIN_MELT = 1202,


  /**
   * Signature using a coin key requesting recoup. Signed with the coin's private key.
   */
  WALLET_COIN_RECOUP = 1203,


  /**
   * Signature using a coin key authenticating link data. Signed with the old coin's private key.
   */
  WALLET_COIN_LINK = 1204,


  /**
   * Signature using a reserve key by which a wallet requests a payment target UUID for itself. Signs over just a purpose (no body), as the signature only serves to demonstrate that the request comes from the wallet controlling the private key, and not some third party.
   */
  WALLET_ACCOUNT_SETUP = 1205,


  /**
   * Signature using a coin key requesting recoup-refresh. Signed with the coin private key.
   */
  WALLET_COIN_RECOUP_REFRESH = 1206,


  /**
   * Signature using a age restriction key for attestation of a particular age/age-group.
   */
  WALLET_AGE_ATTESTATION = 1207,


  /**
   * Request full or partial reserve history. Signed with the reserve private key.
   */
  WALLET_RESERVE_HISTORY = 1208,


  /**
   * Request full or partial coin history. Signed with the coin private key.
   */
  WALLET_COIN_HISTORY = 1209,


  /**
   * Request purse creation (without reserve). Signed by the purse private key.
   */
  WALLET_PURSE_CREATE = 1210,


  /**
   * Request coin to be deposited into a purse. Signed with the coin private key.
   */
  WALLET_PURSE_DEPOSIT = 1211,


  /**
   * Request purse status. Signed with the purse private key.
   */
  WALLET_PURSE_STATUS = 1212,


  /**
   * Request purse to be merged with a reserve. Signed with the purse private key.
   */
  WALLET_PURSE_MERGE = 1213,


  /**
   * Request purse to be merged with a reserve. Signed by the reserve private key.
   */
  WALLET_ACCOUNT_MERGE = 1214,


  /**
   * Request account to be closed. Signed with the reserve private key.
   */
  WALLET_RESERVE_CLOSE = 1215,


  /**
   * Associates encrypted contract with a purse. Signed with the purse private key.
   */
  WALLET_PURSE_ECONTRACT = 1216,


  /**
   * Request reserve to be kept open. Signed with the reserve private key.
   */
  WALLET_RESERVE_OPEN = 1217,


  /**
   * Request coin to be used to pay for reserve to be kept open. Signed with the coin private key.
   */
  WALLET_RESERVE_OPEN_DEPOSIT = 1218,


  /**
   * Request attestation about reserve owner. Signed by the reserve private key.
   */
  WALLET_RESERVE_ATTEST_DETAILS = 1219,


  /**
   * Signature by which a wallet requests a purse to be deleted.
   */
  WALLET_PURSE_DELETE = 1220,


  /**
   * Signature where the reserve key confirms an age-withdraw request. Signed with the reserve private key.
   */
  WALLET_RESERVE_AGE_WITHDRAW = 1221,


  /**
   * Signature where the token use key confirms the usage of a token on a pay request. Signed with the token use private key.
   */
  WALLET_TOKEN_USE = 1222,


  /**
   * Signature on a denomination key announcement.
   */
  SM_RSA_DENOMINATION_KEY = 1250,


  /**
   * Signature on an exchange message signing key announcement.
   */
  SM_SIGNING_KEY = 1251,


  /**
   * Signature on a denomination key announcement.
   */
  SM_CS_DENOMINATION_KEY = 1252,


  /**
   * EdDSA test signature.
   */
  CLIENT_TEST_EDDSA = 1302,


  /**
   * EdDSA test signature.
   */
  EXCHANGE_TEST_EDDSA = 1303,


  /**
   * Signature by which an AML officer signs an AML decision.
   */
  AML_DECISION = 1350,


  /**
   * Signature by which an AML officer requests AML data.
   */
  AML_QUERY = 1351,


  /**
   * Signature by which an account owner authorizes access to a KYC operation.
   */
  KYC_AUTH = 1360,


  /**
   * EdDSA signature for a policy upload.
   */
  ANASTASIS_POLICY_UPLOAD = 1400,


  /**
   * EdDSA signature for a backup upload.
   */
  SYNC_BACKUP_UPLOAD = 1450,


  /**
   * Signature over messages to delete in the mailbox service
   */
  MAILBOX_MESSAGES_DELETE = 1551,


  /**
   * Signature over new key set in key update
   */
  MAILBOX_KEYS_UPDATE = 1552,


}
