#!/bin/sh
# \
exec wish "$0" "$@"

# install.tcl --
#
#	Simple installer script for combo package distribution.
#
# Copyright (c) 2003 Zveno Pty Ltd
# http://www.zveno.com/
#
# Zveno makes this software available free of charge for any purpose.
# This software may be copied, and distributed, with or without
# modifications; but this notice must be included on any copy.
#
# The software was developed for research purposes only and Zveno does not
# warrant that it is error free or fit for any purpose.  Zveno disclaims any
# liability for all claims, expenses, losses, damages and costs any user may
# incur as a result of using, copying or modifying this software.
#
# $Id$

set package {TclXML Combo}

set major 3
set minor 0
set patchlevel b1
set version ${major}.$minor$patchlevel

set srcdir [file dirname [info script]]
set destdir [info library]

. configure -menu .menu
menu .menu -tearoff 0
.menu add cascade -label File -menu .menu.file
menu .menu.file -tearoff 0
.menu.file add command -label Install -command Install
.menu.file add separator
.menu.file add command -label Quit -command {destroy .}

message .message -text "$package $version Installer" -aspect 200
text .description -width 40 -height 10
.description insert 1.0 "Install the following packages:\n"
foreach pkg [glob [file join $srcdir Tcl*]] {
    .description insert end [file tail $pkg]\n
}
.description configure -state disabled

labelframe .dest -text {Installation Directory}
entry .dest.dir -width 60 -textvariable destdir
button .dest.browse -text Browse -command Browse
grid .dest.dir -row 0 -column 0 -sticky ew
grid .dest.browse -row 0 -column 1 -sticky e
grid columnconfigure .dest 0 -weight 1

frame .controls
button .controls.install -text Install -command Install
button .controls.cancel -text Cancel -command {destroy .}
grid .controls.install -row 0 -column 0 -sticky w
grid .controls.cancel -row 0 -column 1 -sticky e
grid columnconfigure .controls 0 -weight 1
grid columnconfigure .controls 1 -weight 1

label .feedback -textvariable feedback -anchor w

grid .message -row 0 -column 0 -sticky ew
grid .description -row 1 -column 0 -sticky news
grid .dest -row 2 -column 0 -sticky ew
grid .controls -row 3 -column 0 -sticky ew
grid .feedback -row 4 -column 0 -sticky ew

grid rowconfigure . 1 -weight 1
grid columnconfigure . 0 -weight 1

proc Browse {} {
    global destdir feedback

    set feedback {}

    set fname [tk_chooseDirectory -initialdir $destdir -mustexist 1 -title {Select Installation Directory}]
    if {[string length $fname]} {
	set destdir $fname
    }

    return {}
}

proc Install {} {
    global destdir srcdir feedback

    set feedback {}

    foreach dir [glob [file join $srcdir Tcl*]] {
	set pkg [file tail $dir]
	set feedback "Installing $pkg"
	update idletasks
	if {[file exists [file join $destdir $pkg]]} {
	    switch [tk_messageBox -icon warning -message "Package $pkg is already installed.  Do you wish to reinstall?" -type yesno] {
		yes {
		    foreach olddir [glob [file join $srcdir Tcl*]] {
			set oldpkg [file tail $olddir]
			file delete -force [file join $destdir $oldpkg]
		    }
		}
		no -
		default {
		    set feedback {Installation cancelled}
		    return {}
		}
	    }
	}
	file copy $dir $destdir
    }

    set feedback "Installation completed"

    .controls.cancel configure -text Finish
    .controls.install configure -state disabled
    .menu.file entryconfigure Install -state disabled
    .dest.browse configure -state disabled

    return {}
}

