lappend auto_path /home/steve/tclxml/library

source dom.tcl

# Setup a simple DOM tree

set d [dom::DOMImplementation create]
set top [dom::document createElement $d Top]
set l1 [dom::document createElement $top Node1]
set l2 [dom::document createElement $top Node2]

set l1_1 [dom::document createElement $l1 Node1_1]
set l1_2 [dom::document createElement $l1 Node1_2]

set l2_1 [dom::document createElement $l2 Node2_1]
set l2_2 [dom::document createElement $l2 Node2_2]

# Register normal event listeners

dom::node addEventListener $l1_1 click HandleEvent
dom::node addEventListener $l1 click HandleEvent
dom::node addEventListener $l1_1 mouseup HandleEvent

dom::node addEventListener $l1 click HandleEvent -usecapture 1

# Event listener procs

proc HandleEvent evid {
    set currNode [dom::event cget $evid -currentNode]
    puts "Event type [dom::event cget $evid -type], current node [dom::node cget $currNode -nodeName], phase [dom::event cget $evid -eventPhase]"
}

# Synthesize event

set anEvent [dom::document createEvent $d click]
dom::event initMouseEvent $anEvent click 1 1 {} 0 100 101 10 11 0 0 0 0 0 {}
dom::node dispatchEvent $l1_1 $anEvent

