/* tcldom-libxml2.h --
 *
 *	libxml2 wrapper for TclDOM.
 *
 * Copyright (c) 2002 Zveno Pty Ltd
 * http://www.zveno.com/
 *
 * Zveno Pty Ltd makes this software and associated documentation
 * available free of charge for any purpose.  You may make copies
 * of the software but you must include all of this notice on any copy.
 *
 * Zveno Pty Ltd does not warrant that this software is error free
 * or fit for any purpose.  Zveno Pty Ltd disclaims any liability for
 * all claims, expenses, losses, damages and costs any user may incur
 * as a result of using, copying or modifying the software.
 *
 * $Id: tcldom-libxml2.h,v 1.4 2002/02/27 04:28:39 balls Exp $
 */

#ifndef __TCLDOM_LIBXML2_H__
#define __TCLDOM_LIBXML2_H__

#include <tcldom.h>
#include <libxml/tree.h>

/*
 * For C++ compilers, use extern "C"
 */

#ifdef __cplusplus
extern "C" {
#endif

EXTERN Tcl_FreeInternalRepProc	TclDOM_DocFree;
EXTERN Tcl_DupInternalRepProc	TclDOM_DocDup;
EXTERN Tcl_UpdateStringProc	TclDOM_DocUpdate;
EXTERN Tcl_SetFromAnyProc	TclDOM_DocSetFromAny;

EXTERN Tcl_FreeInternalRepProc	TclDOM_NodeFree;
EXTERN Tcl_DupInternalRepProc	TclDOM_NodeDup;
EXTERN Tcl_UpdateStringProc	TclDOM_NodeUpdate;
EXTERN Tcl_SetFromAnyProc	TclDOM_NodeSetFromAny;

/*
 * Object types
 */

  EXTERN Tcl_ObjType TclDOM_DocObjType;
  EXTERN Tcl_ObjType TclDOM_NodeObjType;

  /*
   * Accessor functions
   */

  EXTERN Tcl_Obj * TclDOM_NewDoc _ANSI_ARGS_((Tcl_Interp *interp));
  EXTERN Tcl_Obj * TclDOM_CreateObjFromNode _ANSI_ARGS_((xmlNodePtr nodePtr));
  EXTERN Tcl_Obj * TclDOM_CreateObjFromDoc  _ANSI_ARGS_((xmlDocPtr  docPtr));
  EXTERN int TclDOM_GetNodeFromObj _ANSI_ARGS_((Tcl_Interp *interp, Tcl_Obj *objPtr, xmlNodePtr *nodePtrPtr));
  EXTERN int TclDOM_GetDocFromObj  _ANSI_ARGS_((Tcl_Interp *interp, Tcl_Obj *objPtr, xmlDocPtr *docPtrPtr));

#endif /* __TCLDOM_H__ */

