/* 
 * tclxmlStubLib.c --
 *
 *	Stub object that will be statically linked into extensions that wish
 *	to access the TCLXML API.
 *
 * Copyright (c) 1998 Paul Duffin.
 * Copyright (c) 1998-1999 by Scriptics Corporation.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * RCS: @(#) $Id: tclxmlStubLib.c,v 1.1 2002/09/12 21:15:56 balls Exp $
 */

#ifndef USE_TCL_STUBS
#define USE_TCL_STUBS
#endif

#include "tclxml.h"

TclxmlStubs *tclxmlStubsPtr;

/*
 *----------------------------------------------------------------------
 *
 * TclXML_InitStubs --
 *
 *	Checks that the correct version of Blt is loaded and that it
 *	supports stubs. It then initialises the stub table pointers.
 *
 * Results:
 *	The actual version of BLT that satisfies the request, or
 *	NULL to indicate that an error occurred.
 *
 * Side effects:
 *	Sets the stub table pointers.
 *
 *----------------------------------------------------------------------
 */

CONST char *
TclXML_InitStubs(interp, version, exact)
    Tcl_Interp *interp;
    CONST char *version;
    int exact;
{
    CONST char *result;

    result = Tcl_PkgRequireEx(interp, "xml::c", version, exact,
		(ClientData *) &tclxmlStubsPtr);
    if (!result || !tclxmlStubsPtr) {
        return (char *) NULL;
    }

    return result;
}
