'\"
'\" Copyright (c) 2004 Zveno Pty Ltd
'\"
Zveno makes this software and all associated data and documentation
('Software') available free of charge for any purpose.  This software may
be copied, and distributed, with or without modifications; but this notice
must be included on any copy.
'\"
The Software was developed for research purposes and Zveno does not
warrant that it is error free or fit for any purpose.  Zveno disclaims any
liability for all claims, expenses, losses, damages and costs any user may
incur as a result of using, copying or modifying the Software.
'\"
'\"
'\" RCS: @(#) $Id: nroff.xsl,v 1.4 2004/01/15 08:18:34 balls Exp $
'\" 
.so man.macros
.TH TclDOM n  TclXML "TclXML Package Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
::dom::DOMImplementation ::dom::hasfeature ::dom::create ::dom::destroy ::dom::parse ::dom::serialize ::dom::document ::dom::documenttype ::dom::node ::dom::element ::dom::event ::dom::selectNode ::dom::isNode ::dom::xinclude ::dom::prefix2namespaceURI ::dom::trim \- Tcl language binding for the W3C Document Object Model
.BE

.SH SYNOPSIS
\fBpackage require dom\fP
.sp
\fB::dom::DOMImplementation\fI \fImethod\fR ?\fI args ... ?\fP
.sp
\fB::dom::hasfeature\fI \fIfeature\fR\fI \fIversion\fR\fP
.sp
\fB::dom::create\fP
.sp
\fB::dom::destroy\fI \fItoken\fR\fP
.sp
\fB::dom::parse\fI \fIxml\fR ?\fI option\fI value ... ?\fP
.sp
\fB::dom::serialize\fI \fItoken\fR ?\fI option\fI value ... ?\fP
.sp
\fB::dom::document\fI \fImethod\fR\fI \fItoken\fR ?\fI args ... ?\fP
.sp
\fB::dom::documenttype\fI \fImethod\fR\fI \fItoken\fR ?\fI args ... ?\fP
.sp
\fB::dom::node\fI \fImethod\fR\fI \fItoken\fR ?\fI args ... ?\fP
.sp
\fB::dom::element\fI \fImethod\fR\fI \fItoken\fR ?\fI args ... ?\fP
.sp
\fB::dom::event\fI \fImethod\fR\fI \fItoken\fR ?\fI args ... ?\fP
.sp
\fB::dom::selectNode\fI \fItoken\fR\fI \fIxpath\fR ?\fI option value ... ?\fP
.sp
\fB::dom::isNode\fI \fItoken\fR\fP
.sp
\fB::dom::xinclude\fI \fIdoc\fR\fP
.sp
\fB::dom::prefix2namespaceURI\fI \fInode\fR\fI \fIprefix\fR\fP
.sp
\fB::dom::trim\fI \fIdoc\fR\fP
.BE

.SH DESCRIPTION

.PP
TclDOM is a Tcl language binding for the W3C Document Object Model (DOM).  DOM provides a view of a XML (or HTML) document as a tree structure.  Currently, TclDOM only supports XML documents.

.PP
The package implements most of the DOM Level 1 interfaces and also some Level 2 and Level 3 interfaces.  There are also a number of non-standard commands and methods provided for the convenience of application developers (these are documented).

.PP
The DOM specification should be read in conjunction with this reference manual, as it explains the meaning and purpose of the various interfaces.  This manual is not a tutorial on how to use the DOM.

.PP
TclDOM also provides several implementations of the API:  a pure-Tcl implementation, a C implementation (based on TclDOMPro) and another C implementation based on the Gnome libxml2 library.

.SH PACKAGES AND NAMESPACES

.PP
TclDOM defines the \fBdom\fR package and also a Tcl namespace using that same name.

.PP
Implementations define their own package name and Tcl namespace within the \fB::dom\fR Tcl namespace:

.RS
.TP
\fI\fBTcl implementation\fR\fP 

.PP
Package \fBdom::tcl\fR, Tcl namespace \fB::dom::tcl\fR.

.TP
\fI\fBTclDOMPro\fR\fP 

.PP
Package \fBdom::c\fR, Tcl namespace \fB::dom::c\fR.

.TP
\fI\fBlibxml2\fR\fP 

.PP
Package \fBdom::libxml2\fR, Tcl namespace \fB::dom::libxml2\fR.

.RE

.PP
Each DOM Document is allocated a Tcl namespace within the \fB::dom\fR Tcl namespace.  All storage for the document and commands are defined within that Tcl namespace.

.SH TOKENS

.PP
The TclDOM API uses \fI tokens as identifiers for nodes within the document tree.  This technique has been used to allow alternate implementations of TclDOM to be efficient, while retaining compatibility with the pure-Tcl implementation.

.PP
The format of the token itself as well as the data structure referred to by the token are \fI not public and an application should not rely on these.  Instead, an application should use the accessor methods provided by the API.

.PP
There is no requirement to always use the same token for a node.  In fact, an important performance optimisation for some implementations is to create a new token when a node is accessed, regardless of whether a token has already been issued for that node.  This implies that in order to test whether two tokens refer to the same node it is not sufficient to test the string values of the tokens; the \fBisSameNode\fR method must be used for this purpose.  For example,
.PP
.CS

proc NodeCompare1 {A B} {
    return [string equal $A $B]
}
proc NodeCompare2 {A B} {
    return [$A isSameNode $B]
}

.CE

.PP
In the above example, \fBNodeCompare2\fR correctly determines whether its two arguments refer to the same node.

.SH DOCUMENT AND NODE COMMANDS

.PP
Each Document and Node has a Tcl command defined that may be used to control the object.  This command may be used to invoke the methods by the \fB::dom::document\fR command (for Documents) or the \fB::dom::node\fR command (for all other Nodes).  If a Document' or Node's Tcl command is destroyed then the Document or Node is also destroyed.

.SH DOM INTERFACES

.PP
Each \fI Interface in the DOM specification is implemented with a Tcl command in the \fBdom\fR namespace.  A few interfaces have not been mapped to Tcl commands because Tcl already provides the required functionality, for example the \fBCharacterData\fR interface.

.PP
\fI methods for interfaces are methods (subcommands) of the corresponding Tcl command.

.PP
Each \fI attribute of an interface is a configuration option for an object in the document tree.

.SH CONVENIENCE COMMANDS AND METHODS

.PP
DOM doesn't always provide an interface, method or attribute for every function required.  For example, until DOM Level 3 for was no standard for creating, parsing and serializing a document.  Sometimes using the standard DOM interface is awkward.  TclDOM provides a number of non-standard features to overcome these problems.

.PP
A major convenience is that each method of the \fBDOMImplementation\fR interface is also defined as a command.  For example, rather than using \fBdom::DOMImplementation create\fR to create a new document, the shorter command \fBdom::create\fR may be used.

.PP
Implementations may also provide direct access to specific features.  Refer to the documentation for a DOM implementation.

.SH COMMANDS
.SS \fB::dom::DOMImplementation\fR

.PP
The \fB::dom::DOMImplementation\fR command implements the \fBDOMImplementation\fR DOM interface.  It is used to provide implementation-specific features not explicitly defined in the DOM specification.
.SS Command Options

.PP
The following command options may be used.  These are also available as commands.

.RS
.TP
\fI\fB\fBhasFeature\fR\fR\fP 
\fI hasFeature\fI \fIfeature\fR\fP
.PP
Provides a test for existence of a feature.  Returns \fB1\fR if a feature is implemented, \fB0\fR otherwise.

.TP
\fI\fB\fBcreate\fR\fR\fP 
\fI create\fI \fItype\fR\fP
.PP
Creates the root node of a new DOM document.  The document element type may be specified as an argument, in which case that element is created.  The return value is a token referring to the root node of the newly created document.  A Tcl command is also created with the same name as the document's token.  This command is a shortcut for the \fB::dom::document\fR command.

.PP
\fB
.PP
Non-standard method.  DOM Level 2 introduced the \fBcreateDocument\fR method.
\fR

.TP
\fI\fB\fBcreateDocument\fR\fR\fP 
\fI createDocument\fI \fInsURI\fR\fI \fItype\fR\fI \fIdoctype\fR\fP
.PP
Creates the root node of a new DOM document.  The document element namespace URI and local-name (element type) may be specified as an argument, in which case that element is created.  If the document type is given then the newly created document is configured to use that document type.  The return value is a token referring to the root node of the newly created document.  A Tcl command is also created with the same name as the document's token.  This command is a shortcut for the \fB::dom::document\fR command.

.TP
\fI\fB\fBcreateDocumentType\fR\fR\fP 
\fI createDocumentType\fI \fIname\fR\fI \fIpublicid\fR\fI \fIsystemid\fR\fI \fIinternaldtd\fR\fP
.PP
Creates a Document Type Declaration.  The return value is a token for the newly created document type declaration.  A Tcl command is also created with the same name as the document type's token.  This command is a shortcut for the \fB::dom::documenttype\fR command.

.TP
\fI\fB\fBcreateNode\fR\fR\fP 
\fI createNode\fI \fItoken\fR\fI \fIxpath\fR\fP
.PP
May create a node in the document.  \fI \fItoken\fR\fR specifies a context for the XPath expression given by \fI \fIxpath\fR\fR.  The expression must resolve to a node.  If the node exists then no further action is taken.  Otherwise the node is created.  The token of the matched or newly created node is returned.

.PP
\fB
.PP
Non-standard method.
\fR

.TP
\fI\fB\fBdestroy\fR\fR\fP 
\fI destroy\fI \fItoken\fR\fP
.PP
This method frees all data structures associated with a DOM document or node.  The \fI \fItoken\fR\fR argument must refer to a valid token for any document or any node in the tree of a document.

.PP
When the given token refers to a DOM document then the entire document is destroyed; the Tcl namespace for the document is deleted and all document and node commands are deleted.  All tokens for the document or nodes in the document become invalid.

.PP
When the token refers to a node the node is removed from the tree before it is destroyed.  If the node has children or attributes, they will also be destroyed.  The Tcl command for the node is deleted.

.TP
\fI\fB\fBisNode\fR\fR\fP 
\fI isNode\fI \fItoken\fR\fP
.PP
Tests whether the given token is a valid token for some DOM node.

.PP
\fB
.PP
Non-standard method.
\fR

.TP
\fI\fB\fBparse\fR\fR\fP 
\fI parse\fI \fIxml\fR ?\fI \fIoption\fR\fI \fIvalue\fR?\fP
.PP
This method parses XML formatted text given by the \fI \fIxml\fR\fR argument and constructs a DOM tree for the document.  The return result is the token of the root node of the newly created document.  The document will also have a Tcl command associated with it, see the \fBcreateDocument\fR method.

.PP
This method uses the TclXML package to perform the parsing operation.  The \fBdom\fR package itself does not include an XML parser.  TclXML supports the use of multiple parser implementations.  The \fI -parser\fR may be used to specify which XML parser class to use.

.PP
All options not listed below are passed to the TclXML parser.

.PP
Valid configuration options are:

.RS
.TP
\fI\fB\fI -parser\fI  ?\fI {}\fI expat\fI tcl?\fR\fP 

.PP
This option specifies the name of a TclXML parser class to use to parse the XML data.  The given parser class must be registered with the TclXML package.  If an empty string is given then the default parser class is used.  If an explicit value is given and that parser class is not registered then the command will fail, despite the fact that another parser may be available.

.TP
\fI\fB\fI -progresscommand\fI \fIscript\fR\fR\fP 

.PP
This option specifies a Tcl command to be invoked from time to time while the DOM tree is being constructed.  The script will be invoked after a certain number of element start tags have been processed, given by the \fI -chunksize\fR option.

.TP
\fI\fB\fI -chunksize\fI \fIinteger\fR\fR\fP 

.PP
This option specifies how many element start tags to process before invoking the script given by the \fI -progresscommand\fR option.

.RE

.TP
\fI\fB\fBselectNode\fR\fR\fP 
\fI selectNode\fI \fItoken\fR\fI \fIxpath\fR ?\fI option value ... ?\fP
.PP
Resolves the XPath location path given by \fI \fIxpath\fR\fR.  \fI \fItoken\fR\fR is the initial context for the location path.  Returns the resulting nodeset as a (static) Tcl list.

.PP
The following options may be specified:

.RS
.TP
\fI\fB\fI -namespaces\fR\fR\fP 

.PP
The value for this option is a list of prefix-URI pairs.  Each of these pairs defines an XML Namespace and its prefix for the purposes of evaluating the XPath expression.  The document itself may use a different prefix for the same XML Namespace.

.PP
This option may be repeated, in which case the lists of namespace pairs are merged and all of the XML Namespaces registered.

.RE

.PP
\fB
.PP
Non-standard method.
\fR

.TP
\fI\fB\fBserialize\fR\fR\fP 
\fI serialize\fI \fItoken\fR ?\fI \fIoption\fR\fI \fIvalue\fR?\fP
.PP
This method returns the XML formatted text corresponding to the node given by \fI token\fR.  The text is guaranteed to be a well-formed XML document, unless the \fI -method\fR option specifies a non-XML output method.

.PP
Valid configuration options are:

.RS
.TP
\fI\fB\fI -method\fI xml|html|text\fR\fP 

.PP
Specifies how the document tree is to be serialized as text.  The allowed values correspond to the output methods defined by the XSLT v1.0 W3C Recommendation.  The \fBxml\fR method produces output that conforms to the XML syntax.  The \fBhtml\fR method produces output that conforms to HTML syntax.  The \fBtext\fR method serializes only the text nodes of the document and disables all output escaping.

.TP
\fI\fB\fI -indent\fI \fIboolean\fR\fR\fP 

.PP
Specifies that the output is to be "pretty-printed", ie. element content is indented to provide a visual indication of nesting levels.

.TP
\fI\fB\fI -encoding\fI \fIencoding\fR\fR\fP 

.PP
Specifies that the output is to be encoded using the given character encoding.  If the encoding is \fButf-8\fR (the default) then the output is treated as a string within Tcl.  If any other encoding is specified then the output is treated as a ByteArray object (ie. as binary).

.TP
\fI\fB\fI -newline\fI \fIelementlist\fR\fR\fP 

.PP
This option specifies a list of element types for which newline characters will be added before and after the start and end tags for those elements upon serialization.  This option is deprecated: the \fI -indent option should be used instead.

.PP
White space is significant in XML, so the \fBdom\fR package never adds extra white space for purposes of "pretty-printing" the XML source document.  On some platforms, such as VMS, this can actually cause serious problems due to line length limitations.  This option provides the convenience of adding newlines to certain nominated element types for formatting the source into lines.

.PP
Examples:

.PP
Suppose the following DOM document is constructed:
.PP
.CS

set doc [::dom::DOMImplementation create]
set top [::dom::document createElement $doc Root]
set node [::dom::document createElement $top First]
::dom::document createElement $node Second
::dom::document createElement $top First

.CE

.PP
Without the \fI -newline\fR option the serialized document would be:
.PP
.CS

::dom::DOMImplementation serialize $doc

<?xml version="1.0"?>
<!DOCTYPE Root>
<Root><First><Second/></First><First/></Root>


.CE

.PP
With the \fI -newline\fR option the serialized document would be:
.PP
.CS

::dom::DOMImplementation serialize $doc -newline First

<?xml version="1.0"?>
<!DOCTYPE Root>
<Root>
<First>
<Second/>
</First>
<First/>
</Root>


.CE

.RE

.TP
\fI\fB\fBtrim\fR\fR\fP 
\fI trim\fI \fItoken\fR\fP
.PP
This method removes any node containing only white space from the document tree of the node given by \fI \fItoken\fR\fR.

.RE
.SS \fB::dom::document\fR

.PP
This command implements the Document interface in the DOM specification.  The most important aspect of this command are its factory methods for creating nodes.

.PP
The methods accepted by this command are as follows:

.RS
.TP
\fI\fB\fBcget\fR\fR\fP 
\fBcget\fR\fI \fItoken\fR\fI -option\fP
.PP
This method returns the value of the given configuration option.

.TP
\fI\fB\fBconfigure\fR\fR\fP 
\fBconfigure\fR\fI \fItoken\fR ?\fI \fIoption\fR\fI \fIvalue\fR ... ?\fP
.PP
This method sets the value of the given configuration options.

.PP
Valid configuration options are:

.RS
.TP
\fI\fB\fI -doctype\fR\fP 

.PP
Specifies the token of the Document Type Declaration node.

.PP
This is a read-only option.  Use the factory method to create a Document Type Declaration node.

.TP
\fI\fB\fI -implementation\fR\fP 

.PP
Specifies the token of the document's implementation.

.PP
This is a read-only option.

.TP
\fI\fB\fI -documentElement\fR\fP 

.PP
Specifies the token of the document's document element node.  A document node may only have one document element, but may have other types of children (such as comments).

.PP
This is a read-only option.  Use the factory method to create the document element node.

.RE

.TP
\fI\fB\fBcreateElement\fR\fR\fP 
\fBcreateElement\fR\fI \fItoken\fR\fI \fItype\fR\fP
.PP
This method creates an element node as a child of the given node specified by \fI \fItoken\fR\fR and returns the new node's token as its result.  \fI \fItoken\fR\fR must be a node of type element, document or documentFragment.  The new, child element is added as the last child of \fI \fItoken\fR\fR's list of children.  The new element's type is given by the \fI \fItype\fR\fR argument.  The new element is created with an empty attribute list.

.PP
A Tcl command is created with the same name as the new node's token.  This command is a shortcut for the \fB::dom::node\fR command.

.TP
\fI\fB\fBcreateElementNS\fR\fR\fP 
\fBcreateElementNS\fR\fI \fItoken\fR\fI \fInsuri\fR\fI \fIqualname\fR\fP
.PP
This method creates an element node in an XML Namespace as a child of the given node specified by \fI \fItoken\fR\fR and returns the new node's token as its result.  \fI \fItoken\fR\fR must be a node of type element, document or documentFragment.  The new, child element is added as the last child of \fI \fItoken\fR\fR's list of children.  The new element is created in the XML Namespace given by the namespace URI \fI \fInsuri\fR\fR.  The new element's qualifed name (QName) is given by the \fI \fIqualname\fR\fR argument.  Qualified names have the form \fBprefix:local-part\fR.  The new element is created with an empty attribute list.

.PP
A Tcl command is created with the same name as the new node's token.  This command is a shortcut for the \fB::dom::node\fR command.

.TP
\fI\fB\fBcreateDocumentFragment\fR\fR\fP 
\fBcreateDocumentFragment\fR\fI \fItoken\fR\fP
.PP
This method creates a documentFragment node as a child of the given node specified by \fI \fItoken\fR\fR and returns the new node's token as its result.  \fI \fItoken\fR\fR must be a node of type element, document or documentFragment.

.PP
A Tcl command is created with the same name as the new node's token.  This command is a shortcut for the \fB::dom::node\fR command.

.TP
\fI\fB\fBcreateTextNode\fR\fR\fP 
\fBcreateTextNode\fR\fI \fItoken\fR\fI \fItext\fR\fP
.PP
This method creates a textNode node as a child of the given node specified by \fI \fItoken\fR\fR and returns the new node's token as its result.  \fI \fItoken\fR\fR must be a node of type element, document or documentFragment.  The new, child textNode is added as the last child of \fI \fItoken\fR\fR's list of children.  The new textNode is created with its value set to \fI \fItext\fR\fR.

.PP
A Tcl command is created with the same name as the new node's token.  This command is a shortcut for the \fB::dom::node\fR command.

.TP
\fI\fB\fBcreateComment\fR\fR\fP 
\fBcreateComment\fR\fI \fItoken\fR\fI \fIdata\fR\fP
.PP
This method creates a comment node as a child of the given node specified by \fI \fItoken\fR\fR and returns the new node's token as its result.  \fI \fItoken\fR\fR must be a node of type element, document or documentFragment.  The new, child comment is added as the last child of \fI \fItoken\fR\fR's list of children.  The new comment is created with its value set to \fI \fIdata\fR\fR.

.PP
A Tcl command is created with the same name as the new node's token.  This command is a shortcut for the \fB::dom::node\fR command.

.TP
\fI\fB\fBcreateCDATASection\fR\fR\fP 
\fBcreateCDATASection\fR\fI \fItoken\fR\fI \fItext\fR\fP
.PP
TclDOM does not distinguish between textNodes and CDATASection nodes.  Accordingly, this method creates a textNode node as a child of the given node specified by \fI \fItoken\fR\fR and returns the new node's token as its result.  \fI \fItoken\fR\fR must be a node of type element, document or documentFragment.  The new, child textNode is added as the last child of \fI \fItoken\fR\fR's list of children.  The new node is created with its value set to \fI \fItext\fR\fR and has the attribute \fI -cdatasection\fR set to the value \fB1\fR.

.PP
A Tcl command is created with the same name as the new node's token.  This command is a shortcut for the \fB::dom::node\fR command.

.TP
\fI\fB\fBcreateProcessingInstruction\fR\fR\fP 
\fBcreateProcessingInstruction\fR\fI \fItoken\fR\fI \fItarget\fR\fI \fIdata\fR\fP
.PP
This method creates a processingInstruction node as a child of the given node specified by \fI \fItoken\fR\fR and returns the new node's token as its result.  \fI \fItoken\fR\fR must be a node of type element, document or documentFragment.  The new, child processingInstruction is added as the last child of \fI \fItoken\fR\fR's list of children.  The new node is created with its name set to \fI \fItarget\fR\fR and its value set to \fI \fIdata\fR\fR.

.PP
A Tcl command is created with the same name as the new node's token.  This command is a shortcut for the \fB::dom::node\fR command.

.TP
\fI\fB\fBcreateAttribute\fR\fR\fP 
\fBcreateAttribute\fR\fI \fItoken\fR\fI \fIname\fR\fP
.PP
This method creates an attribute node for the given element specified by \fI \fItoken\fR\fR and returns the new node's token as its result.  \fI \fItoken\fR\fR must be a node of type element.  The new attribute is created with its name set to \fI \fIname\fR\fR and an empty value.

.PP
A Tcl command is created with the same name as the new node's token.  This command is a shortcut for the \fB::dom::node\fR command.

.PP
\fB
.PP
This method is included for completeness with respect to the DOM specification.  The preferred method for setting element attributes is to use the \fB::dom::element\fR command.
\fR

.TP
\fI\fB\fBcreateEntity\fR\fR\fP 
\fBcreateEntity\fR\fI \fItoken\fR\fP
.PP
Not currently implemented.

.TP
\fI\fB\fBcreateEntityReference\fR\fR\fP 
\fBcreateEntityReference\fR\fI \fItoken\fR\fI \fIname\fR\fP
.PP
Not currently implemented.

.TP
\fI\fB\fBcreateEvent\fR\fR\fP 
\fBcreateEvent\fR\fI \fItoken\fR\fI \fIname\fR\fP
.PP
This method creates an event node in the document specified by \fI \fItoken\fR\fR and returns the new node's token as its result.  \fI \fItoken\fR\fR must be a node of type document.  The event type is specified by \fI \fIname\fR\fR.

.PP
A Tcl command is created with the same name as the new node's token.  This command is a shortcut for the \fB::dom::event\fR command.

.TP
\fI\fB\fBgetElementsByTagName\fR\fR\fP 
\fBgetElementsByTagName\fR\fI \fItoken\fR\fI \fIname\fR\fP
.PP
This method searches the node given by the argument \fI \fItoken\fR\fR for child elements with a type matching the argument \fI \fIname\fR\fR.  The name \fB*\fR matches all elements.  All descendants of \fI \fItoken\fR\fR are searched.  This method returns a "live-list"; the return result of this method is the name of a Tcl variable, the content of which is a Tcl list containing tokens for all elements that match.

.TP
\fI\fB\fBdtd\fR\fR\fP 
\fBdtd\fR\fI validate\fP
.PP
This method performs DTD validation upon the document.  If the method returns successfully, then the document is valid.  Otherwise the document is invalid and the error returned contains the reason.

.TP
\fI\fB\fBschema\fR\fR\fP 
\fB\fIsubmethod\fR\fR ?\fI \fIargs\fR ... ?\fP
.PP
This method performs XML Schema validation upon the document.  Schema validation is performed in two steps.  First the document is compiled into a schema document.  Second, the schema document is used to schema-validate an instance document.

.PP
Example:
.PP
.CS

set schema [dom::parse $XML]
$schema schema compile
set instance [dom::parse $XML2]
$schema schema validate $instance

.CE

.PP
If the document is changed after compiling, then schema document must be recompiled.

.RE
.SS \fBdom::node\fR

.PP
This command implements generic functions for DOM nodes.

.PP
The methods accepted by this command are as follows:

.RS
.TP
\fI\fB\fBcget\fR\fR\fP 
\fBcget\fR\fI \fItoken\fR\fI option\fP
.PP
This method returns the value of the given configuration option for the node given by \fI \fItoken\fR\fR.

.TP
\fI\fB\fBconfigure\fR\fR\fP 
\fBconfigure\fR\fI \fItoken\fR ?\fI \fIoption\fR\fI \fIvalue\fR ... ?\fP
.PP
This method sets the value of the given configuration option for the node given by \fI \fItoken\fR\fR.

.PP
Valid configuration options are as follows:

.RS
.TP
\fI\fB\fI -nodeName\fR\fP 

.PP
Returns the node name.  This is a read-only option.

.PP
The DOM specification gives the meaning of names for different types of nodes.  For example, the \fI -nodeName\fR option of an element node is the element type.

.TP
\fI\fB\fI -nodeType\fR\fP 

.PP
Returns the type of the node given by \fI \fItoken\fR\fR.  This is a read-only option.

.TP
\fI\fB\fI -parentNode\fR\fR\fP 

.PP
Returns the parent node of the node given by \fI \fItoken\fR\fR.  This is a read-only option.

.TP
\fI\fB\fI -childNodes\fR\fR\fP 

.PP
Returns the name of a Tcl variable which contains a list of the children of the node given by \fI \fItoken\fR\fR.  The variable contains the "live" list of children.  This is a read-only option.

.TP
\fI\fB\fI -firstChild\fR\fR\fP 

.PP
Returns the first child node of the node given by \fI \fItoken\fR\fR.  This is a read-only option.

.TP
\fI\fB\fI -lastChild\fR\fR\fP 

.PP
Returns the last child node of the node given by \fI \fItoken\fR\fR.  This is a read-only option.

.TP
\fI\fB\fI -previousSibling\fR\fR\fP 

.PP
Returns the parent's child node which appears before this node.  If this child is the first child of its parent then returns an empty string.  This is a read-only option.

.TP
\fI\fB\fI -nextSibling\fR\fR\fP 

.PP
Returns the parent's child node which appears after this node.  If this child is the last child of its parent then returns an empty string.  This is a read-only option.

.TP
\fI\fB\fI -attributes\fR\fR\fP 

.PP
Returns the name of a Tcl array variable which contains the attribute list for an element node.  If the node is not an element type node then returns an empty string.  The indices of the array are attribute names, and the values of the array elements are their corresponding attribute values.  This is a read-only option.

.TP
\fI\fB\fI -nodeValue\fR\fI \fIdata\fR\fR\fP 

.PP
Specifies the value of a node.  The DOM specification gives the meaning of values for different types of nodes.  For example, the \fI -nodeValue\fR option of a textNode node is the node's text.

.RE

.TP
\fI\fB\fBinsertBefore\fR\fR\fP 
\fBinsertBefore\fR\fI \fItoken\fR\fI \fInewchild\fR\fI \fIrefchild\fR\fP
.PP
This method removes the node given by \fI \fInewchild\fR\fR from its parent.  If no \fI \fIrefchild\fR\fR argument is given then \fI \fInewchild\fR\fR is appended to \fI \fItoken\fR\fR's list of children.  If the \fI \fIrefchild\fR\fR argument is given then this method adds \fI \fInewchild\fR\fR as a child of \fI \fItoken\fR\fR.  The new child node is positioned before the node \fI \fIrefchild\fR\fR in \fI \fItoken\fR\fR's list of children.  Returns an empty string.

.TP
\fI\fB\fBreplaceChild\fR\fR\fP 
\fBreplaceChild\fR\fI \fItoken\fR\fI \fInewchild\fR\fI \fIoldchild\fR\fP
.PP
This method removes the node given by \fI \fInewchild\fR\fR from its parent.  It then also removes the node given by \fI \fIoldchild\fR\fR from \fI \fItoken\fR\fR.  \fI \fInewchild\fR\fR is then added as a child of \fI \fItoken\fR\fR in \fI \fIoldchild\fR\fR's original position in the list of children.  The method returns the token \fI \fIoldchild\fR\fR, which will now have no parent.

.TP
\fI\fB\fBremoveChild\fR\fR\fP 
\fBremoveChild\fR\fI \fItoken\fR\fI \fIoldchild\fR\fP
.PP
This method removes the node given by \fI \fIoldchild\fR\fR from its parent, \fI \fItoken\fR\fR.  The method returns the token \fI \fIoldchild\fR\fR, which will now have no parent.

.TP
\fI\fB\fBappendChild\fR\fR\fP 
\fBappendChild\fR\fI \fItoken\fR\fI \fInewchild\fR\fP
.PP
This method removes the node given by \fI \fInewchild\fR\fR from its parent.  \fI \fInewchild\fR\fR is then appended to the end of the list of children for node \fI \fItoken\fR\fR.  The method returns the token \fI \fInewchild\fR\fR.

.TP
\fI\fB\fBhasChildNodes\fR\fR\fP 
\fBhasChildNodes\fR\fI \fItoken\fR\fP
.PP
Returns \fB1\fR if the given node has any child nodes, \fB0\fR otherwise.

.TP
\fI\fB\fBisSameNode\fR\fR\fP 
\fBisSameNode\fR\fI \fItoken\fR\fI \fIref\fR\fP
.PP
Returns \fB1\fR if the given node is the same node as the node given by the \fI \fBref\fR token, \fB0\fR otherwise.

.TP
\fI\fB\fBcloneNode\fR\fR\fP 
\fBcloneNode\fR\fI \fItoken\fR\fI \fIdeep\fR\fP
.PP
This method makes a copy the node given by \fI \fItoken\fR\fR.  If the argument \fI \fIdeep\fR\fR is not specified or has the value \fB0\fR then only the node itself is copied, not its children.  If the argument \fI \fIdeep\fR\fR has the value \fB1\fR then \fI \fItoken\fR\fR's children are also copied recursively.  This method returns the token of the newly created node.  This new node will have no parent.

.TP
\fI\fB\fBchildren\fR\fR\fP 
\fBchildren\fR\fI \fItoken\fR\fP
.PP
This is a convenience method which returns the list of child nodes for the given node as a (static) Tcl list.

.PP
This is not a standard DOM method for this interface.

.TP
\fI\fB\fBparent\fR\fR\fP 
\fBparent\fR\fI \fItoken\fR\fP
.PP
This is a convenience method which returns the parent node for the given node.

.PP
This is not a standard DOM method for this interface.

.TP
\fI\fB\fBpath\fR\fR\fP 
\fBpath\fR\fI \fItoken\fR\fP
.PP
Returns a Tcl list of the ancestor nodes of the given node, starting with the root node.

.PP
This is not a standard DOM method for this interface.

.TP
\fI\fB\fBcreateNode\fR\fR\fP 
\fBcreateNode\fR\fI \fItoken\fR\fI \fIxpath\fR\fP
.PP
May create nodes in order to satisfy the given XPath location path.  The initial context for the location path is the node \fI \fItoken\fR.  For more detail, see the \fB::dom::createNode\fR command.

.PP
This is not a standard DOM method for this interface.

.TP
\fI\fB\fBselectNode\fR\fR\fP 
\fBselectNode\fR\fI \fItoken\fR\fI \fIxpath\fR\fP
.PP
Returns a (static) Tcl list of nodes selected by the XPath location path \fI \fIxpath\fR.  The initial context for the location path is the node \fI \fItoken\fR.  For more detail, see the \fB::dom::selectNode\fR command.

.PP
This is not a standard DOM method for this interface.

.TP
\fI\fB\fBstringValue\fR\fR\fP 
\fBstringValue\fR\fI \fItoken\fR\fP
.PP
Returns the string value of the node given by \fI \fItoken\fR.  The string value of a node is defined by the XPath specification: for element nodes it is the concatenation of the string values of all descendant text nodes, for text nodes it is the node's character data value, for attribute nodes it is the attribute value, for comment nodes it is the comment data and for processing instruction nodes it is the PI data.

.PP
This is not a standard DOM method for this interface.

.TP
\fI\fB\fBaddEventListener\fR\fR\fP 
\fBaddEventListener\fR\fI \fItoken\fR\fI \fItype\fR\fI \fIlistener\fR ?\fI option\fI value ... ?\fP
.PP
Register an event listener for the node given by \fI \fItoken\fR listening for events of type \fI \fItype\fR.  The event mechanism functions as described in the W3C DOM Level 2 Event module.

.PP
When an event of type \fI \fItype\fR occurs the script \fI \fIlistener\fR is evaluated, in the global context.  The token of the event node is appended to the script.

.PP
If the \fI \fIlistener\fR argument is omitted then the listener for the given event type is returned.

.PP
Valid options are:

.RS
.TP
\fI\fB\fI -usecapture\fI \fIboolean\fR\fR\fP 

.PP
If true the listener is triggered in the event capturing phase.  If false the listener is triggered in the event bubbling phase.

.RE

.TP
\fI\fB\fBremoveEventListener\fR\fR\fP 
\fBremoveEventListener\fR\fI \fItoken\fR\fI \fItype\fR\fI \fIlistener\fR ?\fI option\fI value ... ?\fP
.PP
Removes an event listener previously registered for the node given by \fI \fItoken\fR listening for events of type \fI \fItype\fR.

.PP
Valid options are:

.RS
.TP
\fI\fB\fI -usecapture\fI \fIboolean\fR\fR\fP 

.PP
If true the capturing listener is removed.  If false the bubbling listener is removed.

.RE

.TP
\fI\fB\fBdispatchEvent\fR\fR\fP 
\fBdispatchEvent\fR\fI \fItoken\fR\fI \fIevent\fR\fP
.PP
Dispatches the event given by \fI \fIevent\fR with target node \fI \fItoken\fR.  The event mechanism functions as described in the W3C DOM Level 2 Event module.  The event enters the capturing phase first, followed by the bubbling phase.  During each phase any event listeners registered for the same event type as the event \fI \fIevent\fR are triggered; their script is evaluated.  Unless the script invokes the \fBstopPropagation\fR method of the \fBdom::event\fR command, all registered event listeners will be triggered.  The order in which listeners registered at a particular node for a particular phase are triggered is undefined.

.RE
.SS \fBdom::element\fR

.PP
This command provides functions for element type nodes.

.PP
Valid methods for this command are as follows:

.RS
.TP
\fI\fB\fBcget\fR\fR\fP 
\fBcget\fR\fI \fItoken\fR\fI \fIoption\fR\fP
.PP
This method returns the current setting of configuration options for an element.  See the \fBconfigure\fR method for the list of valid configuration options.

.TP
\fI\fB\fBconfigure\fR\fR\fP 
\fBconfigure\fR\fI \fItoken\fR ?\fI \fIoption\fR\fI \fIvalue\fR ... ?\fP
.PP
This method sets configuration options for an element.  Note that element type nodes only have read-only options.

.PP
Valid configuration options are as follows:

.RS
.TP
\fI\fB\fI -tagName\fR\fI \fIname\fR\fR\fP 
The tag name, or element type, of this element.
.TP
\fI\fB\fI -empty\fR\fI \fIboolean\fR\fR\fP 

.PP
Sets whether this element was specified as an empty element when the document was parsed.  That is, XML empty element syntax such as \fB<Empty/>\fR was used.

.PP
This option has no effect upon output (serialization) of the XML document.  Empty element syntax is automatically used where appropriate.

.RE

.TP
\fI\fB\fBgetAttribute\fR\fR\fP 
\fBgetAttribute\fR\fI \fItoken\fR\fI \fIname\fR\fP
.PP
This method returns the attribute value of the attribute given by \fI \fIname\fR\fR.  If the attribute does not exist, then an empty string is returned.

.TP
\fI\fB\fBsetAttribute\fR\fR\fP 
\fBsetAttribute\fR\fI \fItoken\fR\fI \fIname\fR\fI \fIvalue\fR\fP
.PP
This method sets the attribute value of the attribute given by \fI \fIname\fR\fR.  If the attribute already exists then its value is replaced, otherwise the attribute is created.

.TP
\fI\fB\fBremoveAttribute\fR\fR\fP 
\fBremoveAttribute\fR\fI \fItoken\fR\fI \fIname\fR\fP
.PP
This method deletes the attribute given by \fI \fIname\fR\fR.  If the attribute does not exist then the method has no effect.

.TP
\fI\fB\fBgetAttributeNode\fR\fR\fP 
\fBgetAttributeNode\fR\fI \fItoken\fR\fI \fIname\fR\fP
.PP
Not implemented.

.TP
\fI\fB\fBsetAttributeNode\fR\fR\fP 
\fBsetAttributeNode\fR\fI \fItoken\fR\fI \fIname\fR\fP
.PP
Not implemented.

.TP
\fI\fB\fBremoveAttributeNode\fR\fR\fP 
\fBremoveAttributeNode\fR\fI \fItoken\fR\fI \fIname\fR\fP
.PP
Not implemented.

.TP
\fI\fB\fBgetAttributeNS\fR\fR\fP 
\fBgetAttributeNS\fR\fI \fItoken\fR\fI \fIns\fR\fI \fIname\fR\fP
.PP
This method returns the attribute value of the attribute given by \fI \fIname\fR\fR in the XML namespace \fI \fIns\fR.  If the attribute does not exist, then an empty string is returned.

.TP
\fI\fB\fBsetAttributeNS\fR\fR\fP 
\fBsetAttributeNS\fR\fI \fItoken\fR\fI \fIns\fR\fI \fIname\fR\fI \fIvalue\fR\fP
.PP
This method sets the attribute value of the attribute given by \fI \fIname\fR\fR in the XML namespace \fI \fIns\fR.  If the attribute already exists then its value is replaced, otherwise the attribute is created.

.TP
\fI\fB\fBremoveAttributeNS\fR\fR\fP 
\fBremoveAttributeNS\fR\fI \fItoken\fR\fI \fIns\fR\fI \fIname\fR\fP
.PP
This method deletes the attribute given by \fI \fIname\fR\fR in the XML namespace \fI \fIns\fR.  If the attribute does not exist then the method has no effect.

.TP
\fI\fB\fBgetElementsByTagName\fR\fR\fP 
\fBgetElementsByTagName\fR\fI \fItoken\fR\fI \fIname\fR\fP
.PP
This method searches the node given by the argument \fI \fItoken\fR\fR for descendant child elements with a type matching the argument \fI \fIname\fR\fR.  The wildcard character \fB*\fR matches any element type.  The return result is a "live-list" which is represented by a Tcl variable.  This method returns the name of the Tcl variable that contains the list of tokens that match.

.TP
\fI\fB\fBnormalize\fR\fR\fP 
\fBnormalize\fR\fI \fItoken\fR\fP
.PP
This method recursively coalesces textNodes within the children of the given node.  textNodes which are adjacent in the DOM tree cannot be distinguished in the serialized XML document.

.RE
.SS \fBdom::processinginstruction\fR

.PP
This command provides functions for processingInstruction type nodes.

.PP
Valid methods for this command are as follows:

.RS
.TP
\fI\fB\fBcget\fR\fR\fP 
\fBcget\fR\fI \fItoken\fR\fI \fIoption\fR\fP
.PP
This method returns the current setting of configuration options for an element.  See the \fBconfigure\fR method for the list of valid configuration options.

.TP
\fI\fB\fBconfigure\fR\fR\fP 
\fBconfigure\fR\fI \fItoken\fR ?\fI \fIoption\fR\fI \fIvalue\fR ... ?\fP
.PP
This method sets configuration options for a processing instruction.

.PP
Valid configuration options are as follows:

.RS
.TP
\fI\fB\fI -target\fR\fI \fIname\fR\fR\fP 
This option sets the target of the processing instruction.  This is a read-only configuration option.
.TP
\fI\fB\fI -data\fR\fI \fIdata\fR\fR\fP 

.PP
This option sets the data of the processing instruction.

.RE

.RE
.SS \fBdom::event\fR

.PP
This command provides functions for event type nodes.

.PP
Valid methods for this command are as follows:

.RS
.TP
\fI\fB\fBcget\fR\fR\fP 
\fBcget\fR\fI \fItoken\fR\fP
.PP
This method retrieves configuration options for an event.

.PP
Valid configuration options are as follows:

.RS
.TP
\fI\fB\fI -altKey\fR\fR\fP 
This option determines whether the ALT modifier key has been specified for this event.
.TP
\fI\fB\fI -attrName\fR\fR\fB\fI -timeStamp\fR\fR\fP 
This option gives the name of the attribute associated with this event.
.PP
This option gives the time at which the event was posted.  The value is the number of milliseconds since the epoch, which is compatible with the Tcl \fBclock\fR command.  

.PP
\fBThe implementation of this method depends on the \fBTcl_GetTime\fR function.This function only became publically available in Tcl 8.4.  If a version of Tcl prior to 8.4 is being used, then this option will have the value \fB0\fR.\fR

.TP
\fI\fB\fI -type\fR\fR\fP 
The type of this event.
.TP
\fI\fB\fI -view\fR\fR\fP 
This option gives whether the view of the event.
.RE

.TP
\fI\fB\fBconfigure\fR\fR\fP 
\fBconfigure\fR\fI \fItoken\fR ?\fI \fIoption\fR\fI \fIvalue\fR ... ?\fP
.PP
This method sets the configuration options for an event.  However, all event options are read-only.  See the \fBcget\fR method for the list of valid configuration options.

.TP
\fI\fB\fBstopPropagation\fR\fR\fP 
\fBstopPropagation\fR\fI \fItoken\fR\fP
.PP
This method cancels further propagation of the event.

.PP
\fBInvoking this method does not prevent event listeners at the current node from being triggered.\fR

.TP
\fI\fB\fBpreventDefault\fR\fR\fP 
\fBpreventDefault\fR\fI \fItoken\fR\fP
.PP
This method stops the default action for this event from occurring.

.TP
\fI\fB\fBinitEvent\fR\fR\fP 
\fBinitEvent\fR\fI \fItoken\fR\fI \fItype\fR\fI \fIbubbles\fR\fI \fIcancelable\fR\fP
.PP
Initialise the event.

.PP
\fI \fItype\fR gives the type of the event.  Any of the event types defined by the W3C DOM Level 2 Event module may be specified, or a user-defined event type may be used instead.

.PP
\fI \fIbubbles\fR indicates whether the event will enter the bubbling phase after the capturing phase.  \fI \fIcancelable\fR indicates whether the event may be cancelled.

.TP
\fI\fB\fBinitUIEvent\fR\fR\fP 
\fBinitUIEvent\fR\fI \fItoken\fR\fI \fItype\fR\fI \fIbubbles\fR\fI \fIcancelable\fR\fI \fIview\fR\fI \fIdetail\fR\fP
.PP
Initialise a user interface event.  See \fBinitEvent\fR for further information.

.PP
\fI \fIview\fR gives the view for the event (not supported by TclDOM).  \fI \fIdetail\fR provides extra data for the event.

.TP
\fI\fB\fBinitMouseEvent\fR\fR\fP 
\fBinitMouseEvent\fR\fI \fItoken\fR\fI \fItype\fR\fI \fIbubbles\fR\fI \fIcancelable\fR\fI \fIview\fR\fI \fIdetail\fR\fI \fIscreenX\fR\fI \fIscreenY\fR\fI \fIclientX\fR\fI \fIclientY\fR\fI \fIctrlKey\fR\fI \fIaltKey\fR\fI \fIshiftKey\fR\fI \fImetaKey\fR\fI \fIbutton\fR\fI \fIrelatedNode\fR\fP
.PP
Initialise a mouse event.  See \fBinitUIEvent\fR for further information.

.PP
\fI \fIscreenX\fR and \fI \fIscreenY\fR give the coordinates at which the event occurred relative to the screen.  \fI \fIscreenX\fR and \fI \fIscreenY\fR give the coordinates at which the event occurred relative to the window.

.PP
\fI \fIctrlKey\fR, \fI \fIaltKey\fR, \fI \fIshiftKey\fR, \fI \fImetaKey\fR indicate whether the respective modifier key was pressed when the event occurred.

.PP
\fI \fIbutton\fR indicates which button, if any, was pressed when the event occurred.

.PP
\fI \fIrelatedNode\fR specifies that a DOM node is associated with the event.

.TP
\fI\fB\fBinitMutationEvent\fR\fR\fP 
\fBinitMutationEvent\fR\fI \fItoken\fR\fI \fItype\fR\fI \fIbubbles\fR\fI \fIcancelable\fR\fI \fIrelatedNode\fR\fI \fIprevValue\fR\fI \fInewValue\fR\fI \fIattrName\fR\fP
.PP
Initialise a tree mutation event event.  See \fBinitEvent\fR for further information.

.PP
\fI \fIrelatedNode\fR specifies a DOM node to associate with the event.  \fI \fIprevValue\fR gives the previous value of the node.  \fI \fInewValue\fR gives the new value of the node.  \fI \fIattrName\fR gives the name of the attribute where the event is modifying an attribute value.

.TP
\fI\fB\fBpostUIEvent\fR\fR\fP 
\fBpostUIEvent\fR\fI \fItoken\fR\fI \fItype\fR ?\fI option\fI \fIvalue\fR ... ?\fP
.PP
Non-standard convenience method that handles posting an user interface event with \fI \fItoken\fR as the target node.  This method performs the following functions:

.PP
\fI \fItype\fR gives the event type.

.PP
The following options are valid:

.RS
.TP
\fI\fB\fI -bubbles\fR\fR\fP 

.PP
Indicates whether the event bubbles.

.TP
\fI\fB\fI -cancelable\fR\fR\fP 

.PP
Indicates whether the event can be cancelled.

.TP
\fI\fB\fI -view\fR\fR\fP 

.PP
The view.

.TP
\fI\fB\fI -detail\fR\fR\fP 

.PP
Extra data for the event.

.RE

.TP
\fI\fB\fBpostMouseEvent\fR\fR\fP 
\fBpostMouseEvent\fR\fI \fItoken\fR\fI \fItype\fR ?\fI option\fI \fIvalue\fR ... ?\fP
.PP
Non-standard convenience method that handles posting a mouse event with \fI \fItoken\fR as the target node.  This method performs the following functions:

.PP
\fI \fItype\fR gives the event type.

.PP
The following options are valid:

.RS
.TP
\fI\fB\fI -bubbles\fR\fR\fP 

.PP
Indicates whether the event bubbles.

.TP
\fI\fB\fI -cancelable\fR\fR\fP 

.PP
Indicates whether the event can be cancelled.

.TP
\fI\fB\fI -view\fR\fR\fP 

.PP
The view.

.TP
\fI\fB\fI -detail\fR\fR\fP 

.PP
Extra data for the event.

.TP
\fI\fB\fI -screenX\fR\fR\fP 

.PP
Gives the screen X coordinate.

.TP
\fI\fB\fI -screenY\fR\fR\fP 

.PP
Gives the screen Y coordinate.

.TP
\fI\fB\fI -clientX\fR\fR\fP 

.PP
Gives the window X coordinate.

.TP
\fI\fB\fI -clientY\fR\fR\fP 

.PP
Gives the window Y coordinate.

.TP
\fI\fB\fI -ctrlKey\fR\fR\fP 

.PP
Indicates whether the control modifier key was pressed.

.TP
\fI\fB\fI -altKey\fR\fR\fP 

.PP
Indicates whether the ALT modifier key was pressed.

.TP
\fI\fB\fI -shiftKey\fR\fR\fP 

.PP
Indicates whether the shift modifier key was pressed.

.TP
\fI\fB\fI -metaKey\fR\fR\fP 

.PP
Indicates whether the meta modifier key was pressed.

.TP
\fI\fB\fI -button\fR\fR\fP 

.PP
Gives the button pressed.

.TP
\fI\fB\fI -relatedNode\fR\fR\fP 

.PP
Gives a node to associate with the event.

.RE

.TP
\fI\fB\fBpostMutationEvent\fR\fR\fP 
\fBpostMutationEvent\fR\fI \fItoken\fR\fI \fItype\fR ?\fI option\fI \fIvalue\fR ... ?\fP
.PP
Non-standard convenience method that handles posting a mutation event with \fI \fItoken\fR as the target node.  This method performs the following functions:

.PP
\fI \fItype\fR gives the event type.

.PP
The following options are valid:

.RS
.TP
\fI\fB\fI -bubbles\fR\fR\fP 

.PP
Indicates whether the event bubbles.

.TP
\fI\fB\fI -cancelable\fR\fR\fP 

.PP
Indicates whether the event can be cancelled.

.TP
\fI\fB\fI -relatedNode\fR\fR\fP 

.PP
Gives a node to associate with the event.

.TP
\fI\fB\fI -prevValue\fR\fR\fP 

.PP
Gives the previous value of the target node.

.TP
\fI\fB\fI -newValue\fR\fR\fP 

.PP
Gives the new value of the target node.

.TP
\fI\fB\fI -attrName\fR\fR\fP 

.PP
Gives the name of the attribute modified.

.RE

.RE

.SH ERRORS

.PP
If an operation results in an error condition, an error message is returned as a structured Tcl list.  The list has members as follows:
.PP
.CS
{domain level code node line message int1 int2 string1 string2 string3}
.CE

.PP
The format of the list is described in the TclXML manual page.

.SH IMPLEMENTATIONS

.PP
This section documents the various implmentations of the TclDOM API.
.SS Tcl Implementation

.PP
The Tcl implementation is provided by the \fBdom::tcl\fR package.
.SS Limitations

.PP
This implementation is not able to preform the following functions:
.SS libxml2 Implementation

.PP
The TclDOM/libxml2 implementation is a wrapper for the Gnome libxml2 library.  It is provided by the \fBdom::libxml2\fR package.  It is a high-performance library, making use of Tcl objects for fast access to tree nodes.

.PP
On MS Windows, it is necessary to load all required packages separately.  For example:
.PP
.CS

package require xml
package require xml::libxml2
package require dom

.CE
.SS Limitations
