'\"
'\"
'\" RCS: @(#) $Id: nroff.xsl,v 1.4 2005/05/20 12:02:18 balls Exp $
'\" 
.so man.macros
.TH TclXSLT n  TclXML "TclXML Package Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
::xslt::compile ::xslt::extension ::xslt::security \- 
.BE

.SH SYNOPSIS
\fBpackage require xslt\fP
.sp
\fB::xslt::compile\fI \fIdoc\fR\fP
.sp
\fB\fIssheet\fR\fI \fImethod\fR ?\fI option\fI value ... ? ?\fI args ... ?
.sp
\fB::xslt::extension\fBadd\fR\fI \fInsuri\fR\fI \fItcl-namespace\fR\fP
.sp
\fB::xslt::security\fB\fIrequest\fR\fR\fI \fIdetail\fR\fP
.BE

.SH DESCRIPTION

.PP
TclXSLT is a wrapper for the  that allows an application to perform XSL transformations (XSLT).  The package also provides a binding to the XSLT extension mechanism so that XSLT extension may be implemented using Tcl scripts.

.PP
Transformation only works with documents created by TclDOM/libxml2.

.PP
The TclXSLT package makes extensive use of Tcl objects.  Compiled XSL stylesheets are stored as the internal representation of a Tcl object.  Source and result documents are accessed via TclDOM's C interface as Tcl objects.  This allows the application to cache parsed XML documents and compiled XSL stylesheets for better runtime performance.

.SH PACKAGES AND NAMESPACES

.PP
The TclXSLT package defines the  package and also a Tcl namespace using that name.

.SH COMMANDS
.SS \fB::xslt::compile\fR

.PP
The \fB::xslt::compile\fR command compiles a stylesheet document.  It returns a compiled stylesheet object and also defines a Tcl command to access the stylesheet.  This Tcl command may be used to transform XML documents.

.PP
NB.  It is advisable to use the \fI -baseuri\fR option when parsing the source and stylesheet documents to allow external resources to be resolved.
.SS Stylesheet Command

.PP
The stylesheet command created by \fB::xslt::compile\fR command accesses a compiled stylesheet.
.SS Command Methods

.PP
The following command methods may be used:

.RS
.TP
\fI\fB\fI cget\fI \fIoption\fR\fR\fP 

.PP
Returns the value of an option.  See below for the list of valid options.

.TP
\fI\fB\fI configure\fI \fIoption\fR\fIvalue\fR\fR\fP 

.PP
Sets the value of an option.  Available options are as follows:

.RS
.TP
\fI\fB\fI -indent\fR\fR\fP 

.PP
Specifies whether the output being produced by the stylesheet should be idented (or "pretty-printed").  This is usually set by the styesheet's  element.  The result is a boolean value.

.PP
This is a read-only option.

.TP
\fI\fB\fI -messagecommand\fR\fI \fIscript\fR\fR\fP 

.PP
This option specifies a Tcl command to be evaluated when a message is produced by the stylesheet.  Messages may be produced when the stylesheet detects an error during processing, or when the stylesheet uses the  element.

.PP
It is currently not possible to distinguish between an error message and a message produced using .

.TP
\fI\fB\fI -method\fR\fR\fP 

.PP
Specifies the output being produced by the stylesheet.  This is usually set by the styesheet's  element.  May have the value \fBxml\fR, \fBhtml\fR, \fBxhtml\fR, \fBtext\fR or an empty string.

.PP
If the result is an empty string, then the output method used depends on the type of the result document.  If the result document is of type "HTML" (ie. if [dom::node cget $resultdoc -nodeType] returns \fBHTMLdocument\fR), then the \fBhtml\fR output method should be used.  Otherwise the output method to use is \fBxml\fR.

.PP
This is a read-only option.

.TP
\fI\fB\fI -profilechannel\fR\fR\fP 

.PP
Specifies the name of a channel into which profiling information is written.  The channel must have been opened for writing, or an error will be returned when attempting a transformation.  Only file channels may be used and only on Unix systems.

.TP
\fI\fB\fI -resulturi\fR\fR\fP 

.PP
Specifies the target URI for the transformation, ie. where the result will be written to.  The result document is \fInot\fR written to this URI automatically; the application should write the result document to this URI itself.

.PP
Some transformation constructs resolve relative URIs against this URI.  For example, a subsidiary result document produced using the  element.

.RE

.TP
\fI\fB\fI get\fI \fIwhat\fR\fR\fP 

.PP
Returns information from the stylesheet.  The following values may be used for \fI \fIwhat\fR:

.RS
.TP
\fI\fB\fI parameters\fR\fP 

.PP
Returns a Tcl list describing the parameters that the stylesheet accepts.  Each member of the list is itself a Tcl list with three members: \fB{name ns select}\fR.  \fBname\fR is the name of the parameter, \fBns\fR is the XML namespace for the parameter and \fBselect\fR is the value of the  attribute of the  element, if any (ie. the default value of the parameter).  This implementation is not able to return a default value set using the content of the  element.

.PP
All stylesheet parameters are returned by this method, including those in included/imported stylesheets.  Where more than one parameter is defined with the same name, only the parameter with the highest import precedence is included in the returned list.

.RE

.TP
\fI\fB\fI transform\fI \fIsource\fR ?\fI \fIname\fR\fI \fIvalue\fR?\fR\fP 

.PP
Performs an XSL transformation on the given source document.  Stylesheet parameters may be specified as name-value pairs.  The return result is the DOM token for the result document.

.RE
.SS Stylesheet Parameters

.PP
Any number of name-value pairs may be specified as arguments to the \fB\fIstylesheet\fR transform\fR method.  These are passed as values for parameters in the stylesheet.   interprets the values as XPath expressions, where the context node is the root node for the source document.  To pass a value as a string it must be XPath-quoted, for example
.PP
.CS

set library "Gnome libxslt"
$ssheet transform $source_doc \
	library '$library' \
	author "'Daniel Veillard'" \
	node {/*/Element[3]}

.CE

.PP
Following is an example of how to use the \fB\fIstylesheet\fR transform\fR method.
.SS \fB::xslt::extension\fR

.PP
The \fB::xslt::extension\fR command is used to manage extensions of the  library.  The \fBadd\fR is used to register an extension.  The \fBremove\fR is used to unregister an extension.  See  for more detail.
.SS \fB::xslt::security\fR

.PP
The \fB::xslt::security\fR command is a "call-in" used to manage the security of a stylesheet performing a transformation.  The TclXSLT package does not create this command.  A stylesheet may need to perform an operation on an external resource, such as reading or writing a file, or opening a network connection.  Before performing such an operation, TclXSLT will invoke the \fB::xslt::security\fR command.  It interprets the result of the command as a boolean value, and only if the "true" value is returned will it instruct the  library to continue.

.PP
TclXSLT will invoke the \fB::xslt::security\fR command in a different fashion depending on whether the current interpreter is safe or unsafe.

.RS

.PP
*  If the current interpeter is unsafe (ie. it is a trusted interpreter) then the command is invoked in the usual manner (see below for arguments).  If the command does not exist then the value "true" is the default, ie. the operation will be permitted.

.PP
*  If the current interpreter is safe then the command is invoked as a hidden command.  This is to ensure that the untrusted script cannot intercept the invocation of the command.  If the hidden command does not exist then the value "false" is the default, ie. the operation will not be permitted.
.RE

.PP
When the \fB::xslt::security\fR command is invoked two arguments are appended:
\fB::xslt::security\fB\fIrequest\fR\fR\fI \fIdetail\fR\fP
.RS
.TP
\fI\fB\fB\fIrequest\fR\fR\fR\fP 

.PP
This indicates the operation being requested and may have one of the following values:

.RS

.PP
*  \fBreadfile\fR

.PP
*  \fB\fR

.PP
*  \fB\fR

.PP
*  \fB\fR

.PP
*  \fB\fR
.RE

.RE

.SH EXTENSIONS

.PP
The TclXSLT package allows an application to bind Tcl scripts to the extension mechanism of .  This means that Tcl scripts may provide the implementation of an XSLT extension element or function.  The binding is achieved to associating a Tcl namespace with an XML namespace.
.SS Implementing An Extension

.PP
The Tcl application uses the \fB::xslt::extension add\fR command to register an extension.  An XML Namespace for the extension is specified as an argument, along with a Tcl namespace that will provide implementations of extension elements and functions.  For example,
.PP
.CS

::xslt::extension add http://www.zveno.com/Example ::example

.CE

.PP
Everytime the \fB::xslt::transform\fR command is executed, a newly-created XSLT engine is initialized.  For each registered extension, every procedure in the associated Tcl namespace is defined in the XSLT engine as either an extension element or an extension function.  The procedure is defined as an extension function if it has a variable argument list, otherwise it is defined as an extension element.  The procedure name is used as the local part of the extension name.  For example,
.PP
.CS

namespace eval example {
    namespace export myfunc myelement
}

proc example::myfunc {name args} {
    global app
    return $app($name)
}
proc example::myelement {node} {
    global app
    return $app([dom::libxml2::node cget $node -nodeName])
}

.CE

.PP
"myfunc" is defined as an extension function and "myelement" is defined as an extension element.
.SS Extension Functions

.PP
The arguments to an extension function are converted to a string value and then passed as parameters to the Tcl procedure.

.PP
The return result of the Tcl procedure becomes the return value of the extension function.  The type of the result is preserved where possible, otherwise it is converted to a string value.
.SS Extension Elements

.PP
Extension elements have not been implemented in TclXSLT v3.1.
.SS Using An Extension

.PP
To invoke an extension in an XSL stylesheet, use the normal XSLT extension mechanism.  The XML Namespace matches the extension to the registered Tcl namespace (NB. the stylesheet author is free to choose any prefix for the extension namespace).  For example,
.PP
.CS

<xsl:stylesheet version='1.0'
	xmlns:xsl='http://www.w3.org/1999/XSL/Transform'
	xmlns:eg='http://www.zveno.com/Example'>

  <xsl:template match='/'>
    <xsl:text>Result of calling extension is "</xsl:text>
    <xsl:value-of select='eg:myfunc("foo")'/>
    <xsl:text>".
</xsl:text>
  </xsl:template>

</xsl:stylesheet>

.CE

.PP
This stylesheet would result in the following Tcl script being evaluated:
.PP
.CS

::example::myfunc foo

.CE

.SH NOTES
.SS Linking

.PP
Problems may arise when using the TclXSLT package in combination with the TclDOM package if they are statically linked to the libxml2 and libxslt libraries.  Dynamic linking, using shared libraries, DLLs, or their equivalents, is recommended.

.PP
A known symptom of this problem is when an XSL transformation produces text with output escaping disabled, but the text appears in the serialized result with special characters escaped.
