'\"
'\"
'\" RCS: @(#) $Id: nroff.xsl,v 1.3 2003/12/03 20:06:33 balls Exp $
'\" 
.so man.macros
.TH TclXSLT n  TclXML "TclXML Package Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
::xslt::compile ::xslt::extension \- 
.BE

.SH SYNOPSIS
\fBpackage require xslt\fP
.sp
\fB::xslt::compile\fI \fIdoc\fR\fP
.sp
\fB\fIssheet\fR\fI \fImethod\fR ?\fI option\fI value ... ? ?\fI args ... ?
.sp
\fB::xslt::extension\fBadd\fR\fI \fInsuri\fR\fI \fItcl-namespace\fR\fP
.BE

.SH DESCRIPTION

.PP
TclXSLT is a wrapper for the Gnome libxslt library that allows an application to perform XSL transformations (XSLT).  The package also provides a binding to the XSLT extension mechanism so that XSLT extension may be implemented using Tcl scripts.

.PP
Transformation only works with documents created by TclDOM/libxml2.

.PP
The TclXSLT package makes extensive use of Tcl objects.  Compiled XSL stylesheets are stored as the internal representation of a Tcl object.  Source and result documents are accessed via TclDOM's C interface as Tcl objects.  This allows the application to cache parsed XML documents and compiled XSL stylesheets for better runtime performance.

.SH PACKAGES AND NAMESPACES

.PP
The TclXSLT package defines the \fBxslt\fR package and also a Tcl namespace using that name.

.SH COMMANDS
.SS \fB::xslt::compile\fR

.PP
The \fB::xslt::compile\fR command compiles a stylesheet document.  It returns a compiled stylesheet object and also defines a Tcl command to access the stylesheet.  This Tcl command may be used to transform XML documents.

.PP
NB.  It is advisable to use the \fI -baseuri\fR option when parsing the source and stylesheet documents to allow external resources to be resolved.
.SS Stylesheet Command

.PP
The stylesheet command created by \fB::xslt::compile\fR command accesses a compiled stylesheet.
.SS Command Methods

.PP
The following command methods may be used:

.RS
.TP
\fI\fB\fI cget\fI \fIoption\fR\fR\fP 

.PP
Returns the value of an option.  See below for the list of valid options.

.TP
\fI\fB\fI configure\fI \fIoption\fR\fIvalue\fR\fR\fP 

.PP
Sets the value of an option.  Available options are as follows:
.TP
\fI\fP 


.TP
\fI\fB\fI get\fI \fIwhat\fR\fR\fP 

.PP
Returns information from the stylesheet.  The following values may be used for \fI \fIwhat\fR:

.RS
.TP
\fI\fB\fI parameters\fR\fP 

.PP
Returns a Tcl list describing the parameters that the stylesheet accepts.  Each member of the list is itself a Tcl list with three members: \fB{name ns select}\fR.  \fBname\fR is the name of the parameter, \fBns\fR is the XML namespace for the parameter and \fBselect\fR is the value of the  attribute of the  element, if any (ie. the default value of the parameter).  This implementation is not able to return a default value set using the content of the  element.

.PP
All stylesheet parameters are returned by this method, including those in included/imported stylesheets.  Where more than one parameter is defined with the same name, only the parameter with the highest import precedence is included in the returned list.

.RE

.TP
\fI\fB\fI transform\fI \fIsource\fR ?\fI \fIname\fR\fI \fIvalue\fR?\fR\fP 

.PP
Performs an XSL transformation on the given source document.  Stylesheet parameters may be specified as name-value pairs.  The return result is the DOM token for the result document.

.RE
.SS Stylesheet Parameters

.PP
Any number of name-value pairs may be specified as arguments to the \fB\fIstylesheet\fR transform\fR method.  These are passed as values for parameters in the stylesheet.   interprets the values as XPath expressions, where the context node is the root node for the source document.  To pass a value as a string it must be XPath-quoted, for example
.PP
.CS

set library "Gnome libxslt"
$ssheet transform $source_doc \
	library '$library' \
	author "'Daniel Veillard'" \
	node {/*/Element[3]}

.CE

.PP
Following is an example of how to use the \fB\fIstylesheet\fR transform\fR method.
.SS \fB::xslt::extension\fR

.PP
The \fB::xslt::extension\fR command is used to manage extensions of the  library.  The \fBadd\fR is used to register an extension.  The \fBremove\fR is used to unregister an extension.  See  for more detail.

.SH EXTENSIONS

.PP
The TclXSLT package allows an application to bind Tcl scripts to the extension mechanism of .  This means that Tcl scripts may provide the implementation of an XSLT extension element or function.  The binding is achieved to associating a Tcl namespace with an XML namespace.
.SS Implementing An Extension

.PP
The Tcl application uses the \fB::xslt::extension add\fR command to register an extension.  An XML Namespace for the extension is specified as an argument, along with a Tcl namespace that will provide implementations of extension elements and functions.  For example,
.PP
.CS

::xslt::extension add http://www.zveno.com/Example ::example

.CE

.PP
Everytime the \fB::xslt::transform\fR command is executed, a newly-created XSLT engine is initialized.  For each registered extension, every procedure in the associated Tcl namespace is defined in the XSLT engine as either an extension element or an extension function.  The procedure is defined as an extension function if it has a variable argument list, otherwise it is defined as an extension element.  The procedure name is used as the local part of the extension name.  For example,
.PP
.CS

namespace eval example {
    namespace export myfunc myelement
}

proc example::myfunc {name args} {
    global app
    return $app($name)
}
proc example::myelement {node} {
    global app
    return $app([dom::libxml2::node cget $node -nodeName])
}

.CE

.PP
"myfunc" is defined as an extension function and "myelement" is defined as an extension element.
.SS Extension Functions

.PP
The arguments to an extension function are converted to a string value and then passed as parameters to the Tcl procedure.

.PP
The return result of the Tcl procedure becomes the return value of the extension function.  The type of the result is preserved where possible, otherwise it is converted to a string value.
.SS Extension Elements

.PP
Extension elements have not been implemented in TclXSLT v1.1.
.SS Using An Extension

.PP
To invoke an extension in an XSL stylesheet, use the normal XSLT extension mechanism.  The XML Namespace matches the extension to the registered Tcl namespace (NB. the stylesheet author is free to choose any prefix for the extension namespace).  For example,
.PP
.CS

<xsl:stylesheet version='1.0'
	xmlns:xsl='http://www.w3.org/1999/XSL/Transform'
	xmlns:eg='http://www.zveno.com/Example'>

  <xsl:template match='/'>
    <xsl:text>Result of calling extension is "</xsl:text>
    <xsl:value-of select='eg:myfunc("foo")'/>
    <xsl:text>".
</xsl:text>
  </xsl:template>

</xsl:stylesheet>

.CE

.PP
This stylesheet would result in the following Tcl script being evaluated:
.PP
.CS

::example::myfunc foo

.CE
