#
# $Id: clamTheme.tcl,v 1.7 2004/07/01 15:57:51 jenglish Exp $
#
# Tile widget set: "Clam" theme
#
# Inspired by the XFCE family of Gnome themes.
#

namespace eval tile::theme::clam {

package provide tile::theme::clam 0.0.1

variable colors ; array set colors {
    -disabledfg	"#999999"

    -frame  	"#dcdad5"
    -dark	"#cfcdc8"
    -darker 	"#bab5ab"
    -darkest	"#9e9a91"
    -lighter	"#eeebe7"
    -lightest 	"#ffffff"
    -selectbg	"#4a6984"
    -selectfg	"#ffffff"
}

style theme settings clam {

    style default "." \
    	-background $colors(-frame) \
	-foreground black \
    	-bordercolor $colors(-darkest) \
    	-darkcolor $colors(-dark) \
    	-lightcolor $colors(-lighter) \
	-troughcolor $colors(-darker) \
	-selectbackground $colors(-selectbg) \
	-selectforeground $colors(-selectfg) \
	-selectborderwidth 0 \
	-font TkDefaultFont \
	;

    style map "." \
    	-background [list disabled $colors(-frame)  active $colors(-lighter)] \
	-foreground [list disabled $colors(-disabledfg)] \
	-selectbackground [list  !focus $colors(-darkest)] \
	-selectforeground [list  !focus white] \
	;
	# -selectbackground [list  !focus #847d73]

    style default TButton -width -11 -padding 5 -relief raised
    style map TButton \
    	-background [list \
	    disabled $colors(-frame) \
	    pressed $colors(-darker) \
	    active $colors(-lighter)] \
    	-lightcolor [list pressed $colors(-darker)] \
    	-darkcolor [list pressed $colors(-darker)] \
	-bordercolor [list default #000000] \
    ;

    style default Toolbutton -padding 2 -relief flat
    style map Toolbutton \
	-relief {disabled flat selected sunken pressed sunken active raised} \
    	-background [list \
	    disabled $colors(-frame) \
	    pressed $colors(-darker) \
	    active $colors(-lighter)] \
    	-lightcolor [list pressed $colors(-darker)] \
    	-darkcolor [list pressed $colors(-darker)] \
    ;

    style default TCheckbutton \
    	-indicatorbackground #ffffff -indicatormargin {1 1 4 1}
    style default TRadiobutton \
    	-indicatorbackground #ffffff -indicatormargin {1 1 4 1}
    style map TCheckbutton -indicatorbackground \
	[list  disabled $colors(-frame)  pressed $colors(-frame)]
    style map TRadiobutton -indicatorbackground \
	[list  disabled $colors(-frame)  pressed $colors(-frame)]

    style default TMenubutton -width 11 -padding 3 -relief raised

    style default TEntry \
    	-background white -padding 1 -insertwidth 1
    style map TEntry \
    	-background [list  readonly $colors(-frame)] \
    	-bordercolor [list  focus $colors(-selectbg)] \
    	-lightcolor [list  focus #6f9dc6] \
    	-darkcolor [list  focus #6f9dc6] \
	;

    style default TCombobox -padding 1 -insertwidth 1
    style map TCombobox \
    	-background [list  active $colors(-lighter) pressed $colors(-lighter)] \
    	-fieldbackground [list \
    	    {readonly focus} $colors(-selectbg) \
	    readonly $colors(-frame)] \
    	-foreground [list {readonly focus} $colors(-selectfg)] \
	;

    style default Tab.TNotebook -padding {10 3 10 3}
    style map Tab.TNotebook \
	-padding [list selected {10 5 10 3}] \
    	-background [list selected $colors(-frame) {} $colors(-darker)] \
    	-lightcolor [list selected $colors(-lightest) {} $colors(-dark)] \
	;

    style default TScale -groovewidth 4 -troughrelief sunken
    style map TScale -sliderrelief {pressed sunken  {} raised}
    style default TProgress -background SteelBlue
} }

