package require tile::pixmap

namespace eval tile {
    namespace eval keramik {
        variable version 0.2.0
    }
}

namespace eval tile::keramik {

set imgdir [file join [file dirname [info script]] keramik]
array set Images [tile::LoadImages $imgdir *.gif]

style theme create keramik -parent alt -settings {

    style default . -background #CCCCCC -troughcolor #CCCCCC
    style default . -font ButtonFont -borderwidth 1
    style map . -foreground [list disabled #AAAAAA]
    style default TButton -padding "10 0"

    style default TScrollbar -width 16

    style layout Vertical.TScrollbar {
        Scrollbar.background 
        Scrollbar.trough -children {
            Scrollbar.uparrow -side top
            Scrollbar.downarrow -side bottom
            Scrollbar.uparrow -side bottom
            Vertical.Scrollbar.thumb -side top -expand true -sticky ns
        }
    }

    style layout Horizontal.TScrollbar {
        Scrollbar.background 
        Scrollbar.trough -children {
            Scrollbar.leftarrow -side left
            Scrollbar.rightarrow -side right
            Scrollbar.leftarrow -side right
            Horizontal.Scrollbar.thumb -side left -expand true -sticky we
        }
    }

    #
    # Elements:
    #
    style element create Button.background pixmap -images [list  \
        pressed $Images(button-p) \
        active    $Images(button-h) \
        {} $Images(button-n) \
    ] -border 10 -tiling tile

    style element create Checkbutton.indicator pixmap -images [list \
        selected        $Images(check-c) \
        {}                     $Images(check-u) \
    ] -tiling fixed

    style element create Radiobutton.indicator pixmap -images [list \
        selected        $Images(radio-c) \
        {}                     $Images(radio-u) \
    ] -tiling fixed

    style element create Horizontal.Scrollbar.thumb pixmap -images [list \
        {pressed !disabled} $Images(hsb-p) \
        {} $Images(hsb-n) \
    ] -tiling tile -border 3

    style element create Vertical.Scrollbar.thumb pixmap -images [list \
        {pressed !disabled} $Images(vsb-p) \
        {} $Images(vsb-n) \
    ] -tiling tile -border 3

    style element create Scale.slider pixmap -images [list \
        {} $Images(hslider-n) \
    ] -tiling tile -border 3

    style element create Vertical.Scale.slider pixmap -images [list \
        {} $Images(vslider-n) \
    ] -tiling tile -border 3

#    style element create Horizontal.Progress.bar pixmap -images [list \
#        {} $Images(sb-thumb) \
#    ] -tiling tile -border 3
      
#    style element create Vertical.Progress.bar pixmap -images [list \
#        {} $Images(sb-vthumb) \
#    ] -tiling tile -border 3
      
    style element create Scrollbar.uparrow pixmap -images [list \
        {pressed !disabled} $Images(arrowup-p) \
        {} $Images(arrowup-n) \
    ] -tiling fixed
    style element create Scrollbar.downarrow pixmap -images [list \
        {pressed !disabled} $Images(arrowdown-p) \
        {} $Images(arrowdown-n) \
    ] -tiling fixed
    style element create Scrollbar.rightarrow pixmap -images [list \
        {pressed !disabled} $Images(arrowright-p) \
        {} $Images(arrowright-n) \
    ] -tiling fixed
    style element create Scrollbar.leftarrow pixmap -images [list \
        {pressed !disabled} $Images(arrowleft-p) \
        {} $Images(arrowleft-n) \
    ] -tiling fixed

    #
    # Settings:
    #
    style layout TButton {
        Button.background
        Button.focus -children {
            Button.padding -children {
                Button.label -side left -expand true
            }
        }
    }

    style layout TCheckbutton {
        Checkbutton.background
        Checkbutton.focus -children {
            Checkbutton.border -children {
                Checkbutton.padding -children {
                    Checkbutton.indicator -side left
                    Checkbutton.label -side right -expand true
                }
            }
        }
    }

    style layout TRadiobutton {
        Radiobutton.background
        Radiobutton.border -children {
            Radiobutton.padding -children  {
                Radiobutton.indicator -side left
                Radiobutton.focus -expand true -sticky {} -children {
                    Radiobutton.label -side right -expand true
                }
            }
        }
    }

} }

package provide tile::theme::keramik $::tile::keramik::version
