# blue.tcl - Copyright (C) 2004 Pat Thoyts <patthoyts@users.sourceforge.net>
#
# A sample pixmap theme for the tile package.
#
# $Id: blue.tcl,v 1.19 2004/04/27 01:01:14 patthoyts Exp $

package require tile::pixmap

namespace eval tile {
    namespace eval plastik {
        variable version 0.2.0
    }
}

namespace eval tile::plastik {

set imgdir [file join [file dirname [info script]] plastik]
array set Images [tile::LoadImages $imgdir *.gif]

style theme create plastik -parent alt -settings {

    style default . -background #CCCCCC -troughcolor #CCCCCC
    style default . -font ButtonFont -borderwidth 1
    style map . -foreground [list disabled #AAAAAA]
    style default TButton -padding "10 0"

    style default TScrollbar -width 16

    style layout Vertical.TScrollbar {
        Scrollbar.background 
        Scrollbar.trough -children {
            Scrollbar.uparrow -side top
            Scrollbar.downarrow -side bottom
            Scrollbar.uparrow -side bottom
            Vertical.Scrollbar.thumb -side top -expand true -sticky ns
        }
    }

    style layout Horizontal.TScrollbar {
        Scrollbar.background 
        Scrollbar.trough -children {
            Scrollbar.leftarrow -side left
            Scrollbar.rightarrow -side right
            Scrollbar.leftarrow -side right
            Horizontal.Scrollbar.thumb -side left -expand true -sticky we
        }
    }

    #
    # Elements:
    #
    style element create Button.background pixmap -images [list  \
        pressed $Images(button-p) \
        active    $Images(button-h) \
        {} $Images(button-n) \
    ] -border 4 -tiling tile

    style element create Checkbutton.indicator pixmap -images [list \
        {active selected}     $Images(check-hc) \
        {pressed selected} $Images(check-pc) \
        active            $Images(check-hu) \
        selected        $Images(check-nc) \
        {}                     $Images(check-nu) \
    ] -tiling fixed

    style element create Radiobutton.indicator pixmap -images [list \
        {active selected}     $Images(radio-hc) \
        {pressed selected} $Images(radio-pc) \
        active            $Images(radio-hu) \
        selected        $Images(radio-nc) \
        {}                     $Images(radio-nu) \
    ] -tiling fixed

    style element create Horizontal.Scrollbar.thumb pixmap -images [list \
        {} $Images(hsb-n) \
    ] -tiling tile -border 3

    style element create Vertical.Scrollbar.thumb pixmap -images [list \
        {} $Images(vsb-n) \
    ] -tiling tile -border 3

    style element create Scale.slider pixmap -images [list \
        {} $Images(hslider-n) \
    ] -tiling tile -border 3

    style element create Vertical.Scale.slider pixmap -images [list \
        {} $Images(vslider-n) \
    ] -tiling tile -border 3

    style element create Scrollbar.uparrow pixmap -images [list \
        {pressed !disabled} $Images(arrowup-p) \
        {} $Images(arrowup-n) \
    ] -tiling fixed
    style element create Scrollbar.downarrow pixmap -images [list \
        {pressed !disabled} $Images(arrowdown-p) \
        {} $Images(arrowdown-n) \
    ] -tiling fixed
    style element create Scrollbar.rightarrow pixmap -images [list \
        {pressed !disabled} $Images(arrowright-p) \
        {} $Images(arrowright-n) \
    ] -tiling fixed
    style element create Scrollbar.leftarrow pixmap -images [list \
        {pressed !disabled} $Images(arrowleft-p) \
        {} $Images(arrowleft-n) \
    ] -tiling fixed

    #
    # Settings:
    #
    style layout TButton {
        Button.background
        Button.focus -children {
            Button.padding -children {
                Button.label -side left -expand true
            }
        }
    }

    style layout TCheckbutton {
        Checkbutton.background
        Checkbutton.focus -children {
            Checkbutton.border -children {
                Checkbutton.padding -children {
                    Checkbutton.indicator -side left
                    Checkbutton.label -side left -expand true
                }
            }
        }
    }

    style layout TRadiobutton {
        Radiobutton.background
        Radiobutton.border -children {
            Radiobutton.padding -children  {
                Radiobutton.indicator -side left
                Radiobutton.focus -expand true -sticky {} -children {
                    Radiobutton.label -side right -expand true
                }
            }
        }
    }

} }

package provide tile::theme::plastik $::tile::plastik::version
