#
# $Id: fonts.tcl,v 1.2 2004/06/15 23:29:38 jenglish Exp $
#
# Tile package: Font specifications.
#
# This file, [source]d from tile.tcl when the package is loaded,
# sets up TkDefaultFont and TkTextFont based on the current platform.
# (TkTextFont, used for entry widgets, is normally the same as
# TkDefaultFont, except on X11 (unless Xft enabled, when it is the same))
#
# This is a temporary solution until TIP #145 is implemented.
#
# Individual themes should be able to modify fonts when the theme
# is activated (@@@ haven't worked out the details yet...)
#
# Symbolic fonts listed in TIP #145:
#
# TkDefaultFont	-- the default for all GUI items not otherwise specified.
# TkFixedFont	-- standard fixed width font
# TkMenuFont	-- used for menu items
# TkCaptionFont	-- used for window and dialog caption bars
# TkSmallCaptionFont used for captions on contained windows or tool dialogs.
# TkIconFont	-- font in use for icon captions
# TkTooltipFont	-- font to use for tooltip windows
#
# 
#
# +++ Platform notes:
#
# Windows:
#	The default system font changed from "MS Sans Serif" to "Tahoma"
# 	in Windows XP/Windows 2000.
#	Should use SystemParametersInfo() instead.
#
# Mac OSX / Aqua:
#	Quoth the Apple HIG: "The system font (Lucida Grande Regular 13 pt) 
#	is used for text in menus, dialogs, and full-size controls."
#	There's also a GetThemeFont() Appearance Manager API call 
#	for looking up kThemeSystemFont dynamically.
#
# Mac classic:
#	Don't know, can't find *anything* on the Web about Mac pre-OSX.
#	Might have used Geneva.  Doesn't matter, this platform
#	isn't supported anymore anyway.
#
# X11:
#	Need a way to tell if Xft is enabled or not.
#	(@@@ For now, assume patch #971980 applied)
#
#	"Classic" look used Helvetica bold; current trend is
#	to use regular weight.  Sticking with bold for now,
#	(this will be changed when "classic" vs "revitalized" defaults 
#	get sorted out.)
#
#	Font size specified in pixels on X11, not points.
#	This is Theoretically Wrong, but in practice works better; using
#	points leads to huge inconsistencies across different servers.
#

namespace eval tile {

    catch {font create TkDefaultFont}
    catch {font create TkTextFont}

    switch -- [tk windowingsystem] {
	win32 {
	    if {$tcl_platform(osVersion) >= 5.0} {
		set family "Tahoma"
		set size 8
	    } else {
		set family "MS Sans Serif"
		set size 8
	    }
	    font configure TkDefaultFont -family $family -size $size
	    font configure TkTextFont -family $family -size $size
	}
	classic -
	aqua {
	    set family "Lucida Grande"
	    set size 13
	    font configure TkDefaultFont -family $family -size $size
	    font configure TkTextFont -family $family -size $size
	}
	x11 {
	    if {![catch {tk::pkgconfig get fontsystem} fs] && $fs eq "xft"} {
		set family "sans-serif"
		set size -12
		font configure TkDefaultFont -family $family -size $size
		font configure TkTextFont -family $family -size $size
	    } else {
		set family "Helvetica"
		set size -12

		font configure TkDefaultFont \
		    -family $family -size $size -weight bold
		font configure TkTextFont \
		    -family $family -size $size
	    }
	    font configure TkDefaultFont \
	    	-family $family -size $size -weight bold
	    font configure TkTextFont -family $family -size $size
	}
    }
}

#*EOF*
