'\"
'\" Copyright (c) 2004 Joe English
'\"
.so man.macros
.TH treeview n 0.5 tile "Tile Widget Set"
.SH NAME
treeview \- hierarchical multicolumn data display widget
.SH SYNOPSIS
\fBttk::treeview\fR \fIpathname \fR?\fIoptions\fR?
.SH "DESCRIPTION"
The treeview widget displays a hierarchical collection of items.
Each item has a textual label, an optional image, 
and an optional list of data values.
The data values are displayed in successive columns after
the tree label.
.PP
The order in which data values are displayed may be controlled
by setting the \fB-displaycolumns\fP widget option.  
The tree widget can also display column headings.
Columns may be accessed by number or by symbolic names 
listed in the \fB-columns\fP widget option;
see \fBCOLUMN IDENTIFIERS\fP.
.PP
Each item is identified by a unique name.
The widget will generate item IDs if they are not supplied by the caller.
There is a distinguished root item, named \fB{}\fP.
The root item itself is not displayed;
its children appear at the top level of the hierarchy.
.\" .PP
.\" @@@HERE: describe selection, focus item
.PP
Treeview widgets support vertical scrolling with the
standard \fB-yscrollcommand\fP option and \fByview\fP widget command.
They probably ought to support horizontal scrolling as well.
.SO
\-class	\-cursor	\-takefocus	\-style
\-yscrollcommand
.SE
.SH "WIDGET OPTIONS"
.OP \-columns columns Columns
A list of column identifiers, 
specifying the number of columns and their names.
.\"X: This is a read-only option; it may only be set when the widget is created.
.OP \-displaycolumns displayColumns DisplayColumns
A list of column identifiers 
(either symbolic names or integer indices)
specifying which data columns are displayed 
and the order in which they appear.
.br
If empty (the default), all columns are shown in the order given.
.OP \-height height Height
Specifies the number of rows which should be visible.
Note:
the requested width is determined from the sum of the column widths.
.OP \-padding padding Padding
Specifies the internal padding for the widget.
The padding is a list of up to four length specifications;
see \fBTtk_GetPaddingFromObj()\fP for details.
.OP \-show show Show
A list containing zero or more of the following values, specifying
which elements of the tree to display.
.RS
.IP \fBtree\fR
Display tree labels in column #0.  
.IP \fBheadings\fP
Display the heading row.
.PP
The default is \fBtree headings\fP, i.e., show all elements.
.PP
\fBNOTE:\fR Column #0 always refers to the tree column,
even if \fB-show tree\fP is not specified.
.RE
.SH "WIDGET COMMAND"
.TP
\fIpathname \fBcget\fR \fIoption\fR
Returns the current value of the specified \fIoption\fP; see \fIwidget(n)\fP.
.TP
\fIpathname \fBchildren\fR \fIitem\fR ?\fInewchildren\fR?
If \fInewchildren\fR is not specified,
returns the list of children belonging to \fIitem\fP.
.br
If \fInewchildren\fP is specified, replaces \fIitem\fP's child list
with \fInewchildren\fP.  
Items in the old child list not present in the new child list
are detached from the tree.
None of the items in \fInewchildren\fP may be an ancestor
of \fIitem\fP.
.TP
\fIpathname \fBcolumn\fR \fIcolumn\fR ?\fI-option \fR?\fIvalue -option value...\fR?
Query or modify the options for the specified \fIcolumn\fP.
If no \fI-option\fP is specified,
returns a dictionary of option/value pairs.
If a single \fI-option\fP is specified, 
returns the value of that option.
Otherwise, the options are updated with the specified values.
The following options may be set on each column:
.RS
.TP
\fB-id \fIname\fP
The column name.  This is a read-only option.
For example, [\fI$pathname \fBcolumn #\fIn \fB-id\fR] 
returns the data column associated with data column #\fIn\fR. 
.TP
\fB-anchor\fP
Specifies how the text in this column should be aligned
with respect to the cell. One of
\fBn\fR, \fBne\fR, \fBe\fR, \fBse\fR,
\fBs\fR, \fBsw\fR, \fBw\fR, \fBnw\fR, or \fBcenter\fR.
.TP
\fB-width \fIw\fP
The width of the column in pixels.  Default is something reasonable,
probably 200 or so.
.PP
Use \fIpathname column #0\fR to configure the tree column.
.RE
.TP
\fIpathname \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Modify or query widget options; see \fIwidget(n)\fP.
.TP
\fIpathname \fBdelete\fR \fIitems\fP
Deletes each of the \fIitems\fP and all of their descendants.
The root item may not be deleted.
See also: \fBdetach\fP.
.TP
\fIpathname \fBdetach\fR \fIitems\fP
Unlinks all of the specified \fIitems\fP from the tree.
The items and all of their descendants are still present
and may be reinserted at another point in the tree
but will not be displayed.
The root item may not be detached.
See also: \fBdelete\fP.
.TP
\fIpathname \fBexists \fIitem\fR
Returns 1 if the specified \fIitem\fP is present in the tree,
0 otherwise.
.TP
\fIpathname \fBfocus \fR?\fIitem\fR?
If \fIitem\fR is specified, sets the focus item to \fIitem\fP.
Otherwise, returns the current focus item, or \fB{}\fP if there is none.
.\" Need: way to clear the focus item.  {} works for this...
.TP 
\fIpathname \fBheading\fR \fIcolumn\fR ?\fI-option \fR?\fIvalue -option value...\fR?
Query or modify the heading options for the specified \fIcolumn\fP.
Valid options are:
.RS
.TP
\fB-text \fItext\fP
The text to display in the column heading.
.TP
\fB-image \fIimageName\fP
Specifies an image to display to the right of the column heading.
.TP
\fB-command \fIscript\fP
A script to evaluate when the heading label is pressed.
.PP
Use \fIpathname heading #0\fR to configure the tree column heading.
.RE
.TP
\fIpathname \fBidentify \fIx y\fR
Returns a description of the widget component under the point given by
\fIx\fR and \fIy\fR.  The return value is a list with one of the 
following forms:
.RS
.TP
\fBheading \fR#\fIn\fR
The column heading for display column \fI#n\fR.
.TP
\fBseparator \fR#\fIn\fR
The border to the right of display column \fI#n\fR.
.TP
\fBcell \fIitemid \fB#\fIn\fR
The data value for item \fIitemid\fP in display column \fI#n\fP.
.TP
\fBitem \fIitemid \fIelement\fR
The tree label for item \fIitemid\fR; \fIelement\fR is one
of \fBtext\fP, \fBimage\fP, or \fBindicator\fP, or another element name
depending on the style.
.TP
\fBrow \fIitemid\fR
The \fIy\fP position is over the \fIitem\fP but 
\fIx\fP does not identify any element or displayed data value.
.TP
\fBnothing\fP
The coordinates are not over any identifiable object.
.PP
See \fBCOLUMN IDENTIFIERS\fP for a discussion of display columns
and data columns.
.RE
.TP
\fIpathname \fBindex \fIitem\fR
Returns the integer index of \fIitem\fR within its parent's list of children.
.TP
\fIpathname \fBinsert\fR \fIparent\fR \fIindex\fR ?\fB-id \fIid\fR? \fIoptions...\fP
Creates a new item.  
\fIparent\fP is the item ID of the parent item,
or the empty string \fB{}\fP
to create a new top-level item.
\fIindex\fP is an integer, or the value \fBend\fP, specifying where in the
list of \fIparent\fP's children to insert the new item.
If \fIindex\fP is less than or equal to zero, 
the new node is inserted at the beginning;
if \fIindex\fP is greater than or equal to the current number of children,
it is inserted at the end.
If \fB-id\fR is specified, it is used as the item identifier;
\fIid\fR must not already exist in the tree.
Otherwise, a new unique identifier is generated.
.br
\fIpathname \fBinsert\fR returns the item identifier of the
newly created item.
See \fBITEM OPTIONS\fP for the list of available options.
.TP
\fIpathname \fBinstate \fIstatespec\fR ?\fIscript\fR?
Test the widget state; see \fIwidget(n)\fP.
.TP
\fIpathname \fBitem\fR \fIitem\fR ?\fI-option \fR?\fIvalue -option value...\fR?
Query or modify the options for the specified \fIitem\fP.
If no \fI-option\fP is specified, 
returns a dictionary of option/value pairs.
If a single \fI-option\fP is specified, 
returns the value of that option.
Otherwise, the item's options are updated with the specified values.
See \fBITEM OPTIONS\fP for the list of available options.
.TP
\fIpathname \fBmove \fIitem parent index\fR
Moves \fIitem\fR to position \fIindex\fR in \fIparent\fR's list of children.
It is illegal to move an item under one of its descendants.
.br
If \fIindex\fP is less than or equal to zero, \fIitem\fP is moved
to the beginning; if greater than or equal to the number of children,
it's moved to the end.
.TP 
\fIpathname \fBnext \fIitem\fR
Returns the identifier of \fIitem\fP's next sibling,
or \fB{}\fP if \fIitem\fP is the last child of its parent.
.TP
\fIpathname \fBparent \fIitem\fR
Returns the ID of the parent of \fIitem\fR,
or \fB{}\fP if \fIitem\fP is at the top level of the hierarchy.
.TP 
\fIpathname \fBprev \fIitem\fR
Returns the identifier of \fIitem\fP's previous sibling,
or \fB{}\fP if \fIitem\fP is the first child of its parent.
.TP
\fIpathname \fBsee\fR \fIitem\fR
Ensure that \fIitem\fP is visible:
sets all of \fIitem\fP's ancestors to \fB-open true\fR,
and scrolls the widget if necessary so that \fIitem\fR is 
within the visible portion of the tree.
.TP
\fIpathname \fBselection\fR ?\fIselop\fR \fIitems\fR?
If \fIselop\fP is not specified, returns the list of selected items.
Otherwise, \fIselop\fP is one of the following:
.RS
.TP
\fIpathname \fBselection set \fIitems\fR
\fIitems\fP becomes the new selection.
.TP
\fIpathname \fBselection add \fIitems\fR
Add \fIitems\fP to the selection
.TP
\fIpathname \fBselection remove \fIitems\fR
Remove \fIitems\fP from the selection
.TP
\fIpathname \fBselection toggle \fIitems\fR
Toggle the selection state of each item in \fIitems\fP.
.RE
.TP
\fIpathname \fBset\fR \fIitem\fR \fIcolumn\fR \fR?\fIvalue\fR?
If \fIvalue\fR is specified, sets the value of column \fIcolumn\fP
in item \fIitem\fR, otherwise returns the current value.
See \fBCOLUMN IDENTIFIERS\fR.
.TP
\fIpathname \fBstate\fR ?\fIstateSpec\fR?
Modify or query the widget state; see \fIwidget(n)\fP.
.TP
\fIpathName \fByview \fIargs\fR
Standard command for vertical scrolling; see \fIwidget(n)\fP.
.SH "ITEM OPTIONS"
The following item options may be specified for items
in the \fBinsert\fP and \fBitem\fP widget commands.
.OP \-text text Text
The textual label to display for the item.
.OP \-image image Image
A Tk image, displayed to the left of the label.
.OP \-values values Values
The list of values associated with the item.
.br
Each item should have the same number of values as
the \fB-columns\fP widget option.
If there are fewer values than columns,
the remaining values are assumed empty.
If there are more values than columns,
the extra values are ignored.
.OP \-open open Open
A boolean value indicating whether the items's children
should be displayed (\fB-open true\fP) or hidden (\fB-open false\fP).
.SH "COLUMN IDENTIFIERS"
Column identifiers take any of the following forms:
.IP \(bu
A symbolic name from the list of \fB-columns\fP.
.IP \(bu
An integer \fIn\fP, specifying the \fIn\fPth data column.
.IP \(bu
A string of the form \fB#\fIn\fR, where \fIn\fP is an integer,
specifying the \fIn\fPth display column.
.PP
\fBNOTE:\fP 
Item \fB-values\fP may be displayed in a different order than 
the order in which they are stored.
.PP
\fBNOTE:\fR Column #0 always refers to the tree column,
even if \fB-show tree\fP is not specified.
.PP
A \fIdata column number\fP is an index into an item's \fB-values\fP list;
a \fIdisplay column number\fP is the column number in the tree
where the values are displayed.  
Tree labels are displayed in column #0.
If \fB-displaycolumns\fP is not set,
then data column \fIn\fP is displayed in display column \fB#\fIn+1\fP.
Again, \fBcolumn #0 always refers to the tree column\fP.
.SH "VIRTUAL EVENTS"
The treeview widget generates the following virtual events.
.IP <<TreeviewSelect>>
Generated whenever the selection changes.
.IP <<TreeviewOpen>>
Generated just before setting the focus item to \fB-open true\fP.
.IP <<TreeviewClose>>
Generated just after setting the focus item to \fB-open false\fP.
.PP
The \fBfocus\fP and \fBselection\fP widget commands can be used
to determine the affected item or items.
In Tk 8.5, the affected item is also passed as the \fB-detail\fP field
of the virtual event.
.SH "SEE ALSO"
widget(n), listbox(n), image(n)
