/* manager.h,v 1.2 2005/03/18 02:03:47 jenglish Exp
 *
 * Copyright (c) 2005, Joe English.  Freely redistributable.
 *
 * Tile widget set: Geometry management utilities.
 *
 * TODO: opacify data structures.
 */

#ifndef MANAGER_H
#define MANAGER_H 1

typedef struct Manager_ Manager;	/* Forward */
typedef struct Slave_ Slave;		/* Forward */

typedef struct {			/* Manager hooks */
    Tk_GeomMgr tkGeomMgr;
    Tk_OptionSpec *slaveOptionSpecs;
    size_t slaveSize;

    int  (*sizeProc)(void *managerData, int *widthPtr, int *heightPtr);
    void (*layoutProc)(void *managerData);

    void (*SlaveAdded)(Manager *, Slave *);
    void (*SlaveRemoved)(Manager *, Slave *);
    int  (*SlaveConfigured)(Tcl_Interp *, Manager *, Slave *, unsigned mask);

} ManagerSpec;

struct Slave_
{
    Tk_Window 	slaveWindow;
    Manager 	*manager;
    void 	*slaveData;
};

struct Manager_
{
    ManagerSpec	*managerSpec;
    void 	*managerData;
    Tk_Window 	masterWindow;
    Tk_OptionTable slaveOptionTable;
    unsigned 	flags;
    int 	nSlaves;
    Slave 	**slaves;
};

/*
 * Default implementations for Tk_GeomMgr hooks:
 */
extern void ManagerGeometryRequestProc(ClientData, Tk_Window slave);
extern void ManagerLostSlaveProc(ClientData, Tk_Window slave);

/*
 * Public API:
 */
extern Manager *CreateManager(ManagerSpec *, void *managerData, Tk_Window);
extern void DeleteManager(Manager *);

extern int AddSlave(
    Tcl_Interp *, Manager *, Tk_Window, int position,
    int objc, Tcl_Obj *CONST objv[]);

extern void ForgetSlave(Manager *, int slaveIndex);

extern int SlaveIndex(Manager *, Tk_Window);
    /* Returns: index in slave array of specified window, -1 if not found */

extern Slave *GetSlaveFromObj(
    Tcl_Interp *, Manager *, Tcl_Obj *, int *indexPtr);

extern void MoveSlave(Manager *, int fromIndex, int toIndex);

extern int ConfigureSlave(
    Tcl_Interp *interp, Manager *, Slave *, int objc, Tcl_Obj *CONST objv[]);

extern void LayoutChanged(Manager *);
extern void SizeChanged(Manager *);

extern int Manageable(Tcl_Interp *interp, Tk_Window slave, Tk_Window master);
    /* Returns: 1 if mgr can manage slave; otherwise 0 and leaves error msg */

extern int Maintainable(Tcl_Interp *interp, Tk_Window slave, Tk_Window master);
    /* Returns: 1 if Tk_MaintainGeometry is valid */

#endif
