#
# Interactive test for labelframes.
#

lappend auto_path .
package require tile

puts "Loaded tile: [package ifneeded tile [package provide tile]]"

#style map . -background {{} blue}

variable anchorStrings { nw n ne en e es se s sw ws w wn }
variable labelanchor nw

set c [ttk::labelframe .actl -text "-labelanchor"]
$c configure -text "" -labelwidget [ttk::label .lbl -text "-labelanchor"]
.lbl configure -relief solid -borderwidth 1

foreach string $anchorStrings {
    pack [ttk::radiobutton $c.$string -text $string \
    	-variable labelanchor -value $string -command setAnchor] \
    -side top -expand false -fill x ;
}

proc setAnchor {} {
    variable labelanchor
    .actl configure -labelanchor $labelanchor
}
pack $c -side top -expand true -fill both -padx 10 -pady 10
setAnchor

bind . <Key-Escape> [list destroy .]

