#
# optiondiff.tcl,v 1.8 2005/03/22 18:04:34 jenglish Exp
#
# 11 Mar 2004
#
# Generate compat.h header file.
#
# Usage: Build tile library _without_ compatibility options (-DNO_COMPAT),
# then run: wish ../tools/optiondiff.tcl > compat.h
# Recompile with compatibility enabled.
# 

lappend auto_path .
package require tile

package require -exact Tk 8.4

proc realOption {widget option dbname dbclass} {
    global RealOptions
    set RealOptions($widget.$option) [list $dbname $dbclass]
}

# realOption label background frameColor FrameColor
# realOption label font font Font
# realOption label foreground textColor TextColor
realOption checkbutton foreground textColor TextColor
realOption radiobutton foreground textColor TextColor
realOption button foreground textColor TextColor
realOption menubutton foreground textColor TextColor
realOption labelframe foreground textColor TextColor

puts "/* Generated from [info script] */"

puts {

#ifndef NO_COMPAT

#define COMPAT_OPTION(class,option,member,dflt) \
    { TK_OPTION_STRING,option, "." #member, "Unused",dflt, \
      Tk_Offset(class, compat.member), -1, \
	TK_OPTION_NULL_OK|TK_OPTION_COMPAT,0,0 }

#define REAL_OPTION(class,option,member,dbname,dbclass) \
    { TK_OPTION_STRING,option,dbname,dbclass, NULL, \
      Tk_Offset(class, compat.member), -1, \
	TK_OPTION_NULL_OK,0,0 }
}

proc optname {spec} {	;# Convert [configure] spec quintuplet to option name
    string trimleft [lindex $spec 0] "-"
}

proc s {string} { return \"$string\" }

foreach widget $ttk::widgets {
    if {[catch {$widget .w1}]} { continue; #new widget }
    ttk::$widget .w2

    set synonyms [list]
    foreach spec [.w1 configure] {
	if {[llength $spec] == 2} {
	    lappend synonyms [optname $spec] [optname [lindex $spec 1]]
	} else {
	    set options([optname $spec]) $spec
	}
    }
    # Can't use TK_OPTION_SYNONYM, since Tk's synonym processing
    # doesn't follow inheritance chains at TK_OPTION_END, causing
    # a Panic() for some widgets (e.g., ttk::label -fg/-foreground alias)
    #
    foreach {alias option} $synonyms {
	# ARGH!  Some TK_OPTION_SYNONYM's use option name,
	# others use dbclass.  Screw 'em.
	if {[catch { set options($alias) $options($option) }] } {
	    set options($alias) [list $alias unused Unused "" ""]
	}
    }

    foreach spec [.w2 configure] {
	catch { unset options([optname $spec]) }
    }

    set compat [lsort [array names options]]
    set Class [string totitle $widget]
    set CLASS [string toupper $widget]

    puts "#define ${CLASS}_COMPAT_DECLS \\"
    puts "struct { Tcl_Obj *[join $compat ,*];} compat;"
    puts "#define ${CLASS}_COMPAT_OPTIONS \\"
    puts "static Tk_OptionSpec ${Class}CompatOptionSpecs\[\] = { \\"
    foreach option $compat {
	set spec $options($option)
	if {[info exists RealOptions($widget.$option)]} {
	    set realoptspec $RealOptions($widget.$option)
	    set dbname [lindex $realoptspec 0]
	    set dbclass [lindex $realoptspec 1]
	    puts \
    "\tREAL_OPTION($Class,[s -$option],$option,[s $dbname],[s $dbclass]),\\"
	} else {
	    set dflt [lindex $spec 4]
	    puts "\tCOMPAT_OPTION($Class,[s -$option],$option,[s $dflt]),\\"
	}
    }
    puts "{TK_OPTION_END,0,0,0,NULL,-1,-1,0,(ClientData)${Class}OptionSpecs,0}};"
    puts ""

    lappend classes $CLASS 

    destroy .w1 .w2
    unset options
}

puts "\n\n#else\n"

foreach CLASS $classes {
    set Class [string totitle $CLASS]
    puts "#define ${CLASS}_COMPAT_DECLS"
    puts "#define ${CLASS}_COMPAT_OPTIONS"
    puts "#define ${Class}CompatOptionSpecs[] ${Class}OptionSpecs"
}

puts "\n#endif"

exit
