'\"
'\" Copyright (c) 2005 Joe English
'\"
.so man.macros
.TH dialog n 0.7 tile "Tile Widget Set"
.SH "NAME"
dialog \- create a dialog box
.SH "SYNOPSIS"
\fBttk::dialog\fR \fIpathname\fR ?\fIoptions...\fR?
\fBttk::dialog::define\fR \fIdialogType\fR ?\fIoptions...\fR?
.SH "DESCRIPTION"
A dialog box is a transient top-level window 
containing an icon, a short message, an optional, longer, detail message,
and a row of command buttons.
When the user presses any of the buttons,
a callback function is invoked
and then the dialog is destroyed.
.PP
Additional widgets may be added in the dialog \fIclient frame\fR.
.SH "OPTIONS"
.OP \-title n/a n/a
Specifies a string to use as the window manager title.
.OP \-message n/a n/a
Specifies the message to display in this dialog.
.OP \-detail n/a n/a
Specifies a longer auxilliary message.
.OP \-command n/a n/a
Specifies a command prefix to be invoked when the user presses
one of the command buttons.  
The symbolic name of the button is passed as an additional argument
to the command.
The dialog is dismissed after invoking the command.
.OP \-type n/a n/a
Specifies a built-in or user-defined dialog type.
See \fBPREDEFINED DIALOG TYPES\fP, below.
.OP \-icon n/a n/a
Specifies one of the stock dialog icons,
\fBinfo\fP, \fBquestion\fP, \fBwarning\fP, or \fBerror\fP.
.OP \-buttons n/a n/a
A list of symbolic button names.
.OP \-labels n/a n/a
A dictionary mapping symbolic button names to textual labels.
May be omitted if all the buttons are predefined.
.OP \-default n/a n/a
The symbolic name of the default button.
.OP \-cancel n/a n/a
The symbolic name of the "cancel" button.
The cancel button is invoked if the user presses the Escape key
and when the dialog is closed from the window manager.
If \fB-cancel\fP is not specified, 
the dialog ignores window manager close commands (WM_DELETE_WINDOW).
.SH "WIDGET COMMANDS"
.IP
\fBttk::dialog::clientframe \fIdlg\fR
Returns the widget path of the client frame.
Other widgets may be added to the client frame.
The client frame appears between the detail message and the command buttons.
.SH "PREDEFINED DIALOG TYPES"
The \fB-type\fP option, if present, specifies default values 
for other options.  \fBttk::dialog::define \fItype options...\fR
specifies a new stock dialog \fItype\fP.  
The following stock dialog types are predefined:
.CS
ttk::dialog::define ok \e
    -icon info -buttons {ok} -default ok
ttk::dialog::define okcancel \e
    -icon info -buttons {ok cancel} -default ok -cancel cancel
ttk::dialog::define yesno \e
    -icon question -buttons {yes no}
ttk::dialog::define yesnocancel \e
    -icon question -buttons {yes no cancel} -cancel cancel
ttk::dialog::define retrycancel \e
    -icon question -buttons {retry cancel} -cancel cancel
.CE
.SH "STOCK BUTTONS"
The following ``stock'' symbolic button names have predefined labels:
\fByes\fP, \fBno\fP, \fBok\fP, \fBcancel\fP, and \fBretry\fP.
.PP
It is not necessary to list these in the \fB-labels\fP dictionary.
.\" .SH "DIFFERENCES FROM MESSAGE BOXES"
.\" The \fBttk::dialog\fR constructor is similar to
.\" the Tk library procedure \fBtk_messageBox\fP,
.\" but with the following notable differences:
.\" .IP \(bu
.\" The first argument to \fBttk::dialog\fP is the name of
.\" the widget to create; \fBtk_messageBox\fP has
.\" .IP \(bu
.\" Tile dialog boxes are non-modal by default.
.\" .IP \(bu
.\" The \fBtk_messageBox\fP command is blocking:
.\" it does not return until the user presses one of the command buttons.
.\" \fBttk::dialog\fP returns immediately after creating the dialog box.
.SH EXAMPLE
.CS

ttk::dialog .saveFileDialog \e
    -title "Save file?" \e
    -icon question \e
    -message "Save file before closing?" \e
    -detail "If you do not save the file, your work will be lost" \e
    -buttons [list yes no cancel] \e 
    -labels [list yes "Save file" no "Don't save"] \e
    -command safeFileComplete \e
    ;

proc saveFileComplete {button} {
    switch -- $button {
    	yes { # save file ... }
	no  { exit }
	cancel { # no-op }
    }
}
.CE
.SH "SEE ALSO"
\fBtk_messageBox(n)\fR, \fBwm(n)\fR, \fBtoplevel(n)\fP
